# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PcRegistrationV2Args', 'PcRegistrationV2']

@pulumi.input_type
class PcRegistrationV2Args:
    def __init__(__self__, *,
                 pc_ext_id: pulumi.Input[_builtins.str],
                 remote_cluster: pulumi.Input['PcRegistrationV2RemoteClusterArgs']):
        """
        The set of arguments for constructing a PcRegistrationV2 resource.
        :param pulumi.Input[_builtins.str] pc_ext_id: -(Required) The display name for the Role.
        :param pulumi.Input['PcRegistrationV2RemoteClusterArgs'] remote_cluster: -(Required)  The registration request consists of the remote cluster details. Credentials must be of domain manager (Prism Central) role.
               The remote cluster details are different based on the object type. The object type is used to determine the type of remote cluster. The object type can be one of the following:
               * `prism.v4.management.DomainManagerRemoteClusterSpec`
               * `prism.v4.management.AOSRemoteClusterSpec`
               * `prism.v4.management.ClusterReference`
        """
        pulumi.set(__self__, "pc_ext_id", pc_ext_id)
        pulumi.set(__self__, "remote_cluster", remote_cluster)

    @_builtins.property
    @pulumi.getter(name="pcExtId")
    def pc_ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) The display name for the Role.
        """
        return pulumi.get(self, "pc_ext_id")

    @pc_ext_id.setter
    def pc_ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pc_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="remoteCluster")
    def remote_cluster(self) -> pulumi.Input['PcRegistrationV2RemoteClusterArgs']:
        """
        -(Required)  The registration request consists of the remote cluster details. Credentials must be of domain manager (Prism Central) role.
        The remote cluster details are different based on the object type. The object type is used to determine the type of remote cluster. The object type can be one of the following:
        * `prism.v4.management.DomainManagerRemoteClusterSpec`
        * `prism.v4.management.AOSRemoteClusterSpec`
        * `prism.v4.management.ClusterReference`
        """
        return pulumi.get(self, "remote_cluster")

    @remote_cluster.setter
    def remote_cluster(self, value: pulumi.Input['PcRegistrationV2RemoteClusterArgs']):
        pulumi.set(self, "remote_cluster", value)


@pulumi.input_type
class _PcRegistrationV2State:
    def __init__(__self__, *,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input['PcRegistrationV2ConfigArgs']]]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hosting_cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_registered_with_hosting_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input['PcRegistrationV2LinkArgs']]]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['PcRegistrationV2NetworkArgs']]]] = None,
                 node_ext_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 pc_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_cluster: Optional[pulumi.Input['PcRegistrationV2RemoteClusterArgs']] = None,
                 should_enable_high_availability: Optional[pulumi.Input[_builtins.bool]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PcRegistrationV2 resources.
        :param pulumi.Input[_builtins.str] pc_ext_id: -(Required) The display name for the Role.
        :param pulumi.Input['PcRegistrationV2RemoteClusterArgs'] remote_cluster: -(Required)  The registration request consists of the remote cluster details. Credentials must be of domain manager (Prism Central) role.
               The remote cluster details are different based on the object type. The object type is used to determine the type of remote cluster. The object type can be one of the following:
               * `prism.v4.management.DomainManagerRemoteClusterSpec`
               * `prism.v4.management.AOSRemoteClusterSpec`
               * `prism.v4.management.ClusterReference`
        """
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if hosting_cluster_ext_id is not None:
            pulumi.set(__self__, "hosting_cluster_ext_id", hosting_cluster_ext_id)
        if is_registered_with_hosting_cluster is not None:
            pulumi.set(__self__, "is_registered_with_hosting_cluster", is_registered_with_hosting_cluster)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if node_ext_ids is not None:
            pulumi.set(__self__, "node_ext_ids", node_ext_ids)
        if pc_ext_id is not None:
            pulumi.set(__self__, "pc_ext_id", pc_ext_id)
        if remote_cluster is not None:
            pulumi.set(__self__, "remote_cluster", remote_cluster)
        if should_enable_high_availability is not None:
            pulumi.set(__self__, "should_enable_high_availability", should_enable_high_availability)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PcRegistrationV2ConfigArgs']]]]:
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PcRegistrationV2ConfigArgs']]]]):
        pulumi.set(self, "configs", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="hostingClusterExtId")
    def hosting_cluster_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "hosting_cluster_ext_id")

    @hosting_cluster_ext_id.setter
    def hosting_cluster_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hosting_cluster_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="isRegisteredWithHostingCluster")
    def is_registered_with_hosting_cluster(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "is_registered_with_hosting_cluster")

    @is_registered_with_hosting_cluster.setter
    def is_registered_with_hosting_cluster(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_registered_with_hosting_cluster", value)

    @_builtins.property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PcRegistrationV2LinkArgs']]]]:
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PcRegistrationV2LinkArgs']]]]):
        pulumi.set(self, "links", value)

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PcRegistrationV2NetworkArgs']]]]:
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PcRegistrationV2NetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @_builtins.property
    @pulumi.getter(name="nodeExtIds")
    def node_ext_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "node_ext_ids")

    @node_ext_ids.setter
    def node_ext_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "node_ext_ids", value)

    @_builtins.property
    @pulumi.getter(name="pcExtId")
    def pc_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) The display name for the Role.
        """
        return pulumi.get(self, "pc_ext_id")

    @pc_ext_id.setter
    def pc_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pc_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="remoteCluster")
    def remote_cluster(self) -> Optional[pulumi.Input['PcRegistrationV2RemoteClusterArgs']]:
        """
        -(Required)  The registration request consists of the remote cluster details. Credentials must be of domain manager (Prism Central) role.
        The remote cluster details are different based on the object type. The object type is used to determine the type of remote cluster. The object type can be one of the following:
        * `prism.v4.management.DomainManagerRemoteClusterSpec`
        * `prism.v4.management.AOSRemoteClusterSpec`
        * `prism.v4.management.ClusterReference`
        """
        return pulumi.get(self, "remote_cluster")

    @remote_cluster.setter
    def remote_cluster(self, value: Optional[pulumi.Input['PcRegistrationV2RemoteClusterArgs']]):
        pulumi.set(self, "remote_cluster", value)

    @_builtins.property
    @pulumi.getter(name="shouldEnableHighAvailability")
    def should_enable_high_availability(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "should_enable_high_availability")

    @should_enable_high_availability.setter
    def should_enable_high_availability(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "should_enable_high_availability", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.type_token("nutanix:index/pcRegistrationV2:PcRegistrationV2")
class PcRegistrationV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 pc_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_cluster: Optional[pulumi.Input[Union['PcRegistrationV2RemoteClusterArgs', 'PcRegistrationV2RemoteClusterArgsDict']]] = None,
                 __props__=None):
        """
        Provides a resource to Registers a domain manager (Prism Central) instance to other entities like PE and PC. This process is asynchronous, creating a registration task and returning its UUID.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] pc_ext_id: -(Required) The display name for the Role.
        :param pulumi.Input[Union['PcRegistrationV2RemoteClusterArgs', 'PcRegistrationV2RemoteClusterArgsDict']] remote_cluster: -(Required)  The registration request consists of the remote cluster details. Credentials must be of domain manager (Prism Central) role.
               The remote cluster details are different based on the object type. The object type is used to determine the type of remote cluster. The object type can be one of the following:
               * `prism.v4.management.DomainManagerRemoteClusterSpec`
               * `prism.v4.management.AOSRemoteClusterSpec`
               * `prism.v4.management.ClusterReference`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PcRegistrationV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to Registers a domain manager (Prism Central) instance to other entities like PE and PC. This process is asynchronous, creating a registration task and returning its UUID.

        :param str resource_name: The name of the resource.
        :param PcRegistrationV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PcRegistrationV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 pc_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_cluster: Optional[pulumi.Input[Union['PcRegistrationV2RemoteClusterArgs', 'PcRegistrationV2RemoteClusterArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PcRegistrationV2Args.__new__(PcRegistrationV2Args)

            if pc_ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'pc_ext_id'")
            __props__.__dict__["pc_ext_id"] = pc_ext_id
            if remote_cluster is None and not opts.urn:
                raise TypeError("Missing required property 'remote_cluster'")
            __props__.__dict__["remote_cluster"] = remote_cluster
            __props__.__dict__["configs"] = None
            __props__.__dict__["ext_id"] = None
            __props__.__dict__["hosting_cluster_ext_id"] = None
            __props__.__dict__["is_registered_with_hosting_cluster"] = None
            __props__.__dict__["links"] = None
            __props__.__dict__["networks"] = None
            __props__.__dict__["node_ext_ids"] = None
            __props__.__dict__["should_enable_high_availability"] = None
            __props__.__dict__["tenant_id"] = None
        super(PcRegistrationV2, __self__).__init__(
            'nutanix:index/pcRegistrationV2:PcRegistrationV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PcRegistrationV2ConfigArgs', 'PcRegistrationV2ConfigArgsDict']]]]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            hosting_cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_registered_with_hosting_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
            links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PcRegistrationV2LinkArgs', 'PcRegistrationV2LinkArgsDict']]]]] = None,
            networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PcRegistrationV2NetworkArgs', 'PcRegistrationV2NetworkArgsDict']]]]] = None,
            node_ext_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            pc_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            remote_cluster: Optional[pulumi.Input[Union['PcRegistrationV2RemoteClusterArgs', 'PcRegistrationV2RemoteClusterArgsDict']]] = None,
            should_enable_high_availability: Optional[pulumi.Input[_builtins.bool]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'PcRegistrationV2':
        """
        Get an existing PcRegistrationV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] pc_ext_id: -(Required) The display name for the Role.
        :param pulumi.Input[Union['PcRegistrationV2RemoteClusterArgs', 'PcRegistrationV2RemoteClusterArgsDict']] remote_cluster: -(Required)  The registration request consists of the remote cluster details. Credentials must be of domain manager (Prism Central) role.
               The remote cluster details are different based on the object type. The object type is used to determine the type of remote cluster. The object type can be one of the following:
               * `prism.v4.management.DomainManagerRemoteClusterSpec`
               * `prism.v4.management.AOSRemoteClusterSpec`
               * `prism.v4.management.ClusterReference`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PcRegistrationV2State.__new__(_PcRegistrationV2State)

        __props__.__dict__["configs"] = configs
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["hosting_cluster_ext_id"] = hosting_cluster_ext_id
        __props__.__dict__["is_registered_with_hosting_cluster"] = is_registered_with_hosting_cluster
        __props__.__dict__["links"] = links
        __props__.__dict__["networks"] = networks
        __props__.__dict__["node_ext_ids"] = node_ext_ids
        __props__.__dict__["pc_ext_id"] = pc_ext_id
        __props__.__dict__["remote_cluster"] = remote_cluster
        __props__.__dict__["should_enable_high_availability"] = should_enable_high_availability
        __props__.__dict__["tenant_id"] = tenant_id
        return PcRegistrationV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def configs(self) -> pulumi.Output[Sequence['outputs.PcRegistrationV2Config']]:
        return pulumi.get(self, "configs")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="hostingClusterExtId")
    def hosting_cluster_ext_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "hosting_cluster_ext_id")

    @_builtins.property
    @pulumi.getter(name="isRegisteredWithHostingCluster")
    def is_registered_with_hosting_cluster(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "is_registered_with_hosting_cluster")

    @_builtins.property
    @pulumi.getter
    def links(self) -> pulumi.Output[Sequence['outputs.PcRegistrationV2Link']]:
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def networks(self) -> pulumi.Output[Sequence['outputs.PcRegistrationV2Network']]:
        return pulumi.get(self, "networks")

    @_builtins.property
    @pulumi.getter(name="nodeExtIds")
    def node_ext_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "node_ext_ids")

    @_builtins.property
    @pulumi.getter(name="pcExtId")
    def pc_ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) The display name for the Role.
        """
        return pulumi.get(self, "pc_ext_id")

    @_builtins.property
    @pulumi.getter(name="remoteCluster")
    def remote_cluster(self) -> pulumi.Output['outputs.PcRegistrationV2RemoteCluster']:
        """
        -(Required)  The registration request consists of the remote cluster details. Credentials must be of domain manager (Prism Central) role.
        The remote cluster details are different based on the object type. The object type is used to determine the type of remote cluster. The object type can be one of the following:
        * `prism.v4.management.DomainManagerRemoteClusterSpec`
        * `prism.v4.management.AOSRemoteClusterSpec`
        * `prism.v4.management.ClusterReference`
        """
        return pulumi.get(self, "remote_cluster")

    @_builtins.property
    @pulumi.getter(name="shouldEnableHighAvailability")
    def should_enable_high_availability(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "should_enable_high_availability")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tenant_id")

