# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PcRestoreSourceV2Args', 'PcRestoreSourceV2']

@pulumi.input_type
class PcRestoreSourceV2Args:
    def __init__(__self__, *,
                 location: pulumi.Input['PcRestoreSourceV2LocationArgs']):
        """
        The set of arguments for constructing a PcRestoreSourceV2 resource.
        :param pulumi.Input['PcRestoreSourceV2LocationArgs'] location: -(Required) Location of the backup target. For example, a cluster or an object store endpoint, such as AWS s3.
        """
        pulumi.set(__self__, "location", location)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input['PcRestoreSourceV2LocationArgs']:
        """
        -(Required) Location of the backup target. For example, a cluster or an object store endpoint, such as AWS s3.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input['PcRestoreSourceV2LocationArgs']):
        pulumi.set(self, "location", value)


@pulumi.input_type
class _PcRestoreSourceV2State:
    def __init__(__self__, *,
                 backup_pause_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_backup_paused: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_sync_time: Optional[pulumi.Input[_builtins.str]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input['PcRestoreSourceV2LinkArgs']]]] = None,
                 location: Optional[pulumi.Input['PcRestoreSourceV2LocationArgs']] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PcRestoreSourceV2 resources.
        :param pulumi.Input['PcRestoreSourceV2LocationArgs'] location: -(Required) Location of the backup target. For example, a cluster or an object store endpoint, such as AWS s3.
        """
        if backup_pause_reason is not None:
            pulumi.set(__self__, "backup_pause_reason", backup_pause_reason)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if is_backup_paused is not None:
            pulumi.set(__self__, "is_backup_paused", is_backup_paused)
        if last_sync_time is not None:
            pulumi.set(__self__, "last_sync_time", last_sync_time)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="backupPauseReason")
    def backup_pause_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "backup_pause_reason")

    @backup_pause_reason.setter
    def backup_pause_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_pause_reason", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="isBackupPaused")
    def is_backup_paused(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "is_backup_paused")

    @is_backup_paused.setter
    def is_backup_paused(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_backup_paused", value)

    @_builtins.property
    @pulumi.getter(name="lastSyncTime")
    def last_sync_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "last_sync_time")

    @last_sync_time.setter
    def last_sync_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_sync_time", value)

    @_builtins.property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PcRestoreSourceV2LinkArgs']]]]:
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PcRestoreSourceV2LinkArgs']]]]):
        pulumi.set(self, "links", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input['PcRestoreSourceV2LocationArgs']]:
        """
        -(Required) Location of the backup target. For example, a cluster or an object store endpoint, such as AWS s3.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input['PcRestoreSourceV2LocationArgs']]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.type_token("nutanix:index/pcRestoreSourceV2:PcRestoreSourceV2")
class PcRestoreSourceV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[Union['PcRestoreSourceV2LocationArgs', 'PcRestoreSourceV2LocationArgsDict']]] = None,
                 __props__=None):
        """
        > The restore source is auto-deleted after sometime, PcRestoreSourceV2 resource is auto-create new restore source if it was deleted, so notice that the id of the restore source resource will be different after recreation. and for update restore source, it will create a new restore source with the new configuration

        Create a restore source pointing to a cluster or object store to restore the domain manager. The created restore source is intended to be deleted after use. If the restore source is not deleted using the deleteRestoreSource API, then it is auto-deleted after sometime. Also note that a restore source will not contain a backup policy. It is only used to access the backup data at the location from where the Prism Central may be restored. Credentials used to access the restore source are not validated at the time of creation of the restore source. They are validated when the restore source is used to fetch data.

        ## Example Usage

        ### Cluster Location

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # restore source is auto-deleted after sometime, nutanix_pc_restore_source_v2 resource is auto-create
        # new restore source if it was deleted, so notice that the id of the restore source will be different
        # after recreation
        cluster_location = nutanix.PcRestoreSourceV2("cluster-location", location={
            "cluster_locations": [{
                "configs": [{
                    "ext_id": "323860ca-bd10-411e-9fe0-1430b62eaf45",
                }],
            }],
        })
        ```

        ### Object Store Location

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # using object store location
        object_store_location = nutanix.PcRestoreSourceV2("object-store-location", location={
            "object_store_locations": [{
                "provider_configs": [{
                    "bucket_name": "nutanix-terraform-bucket",
                    "region": "us-west-1",
                    "credentials": {
                        "access_key_id": "IHSAJHDHADFWYTKJHFGCJKHASGJHKDSA",
                        "secret_access_key": "JGSDHJYHGFHGHDS+JKBASDF/HSDAFHJ+SjkfbdsASDfdJFdSDFJfk",
                    },
                }],
                "backup_policies": [{
                    "rpo_in_minutes": 120,
                }],
            }],
        })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PcRestoreSourceV2LocationArgs', 'PcRestoreSourceV2LocationArgsDict']] location: -(Required) Location of the backup target. For example, a cluster or an object store endpoint, such as AWS s3.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PcRestoreSourceV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > The restore source is auto-deleted after sometime, PcRestoreSourceV2 resource is auto-create new restore source if it was deleted, so notice that the id of the restore source resource will be different after recreation. and for update restore source, it will create a new restore source with the new configuration

        Create a restore source pointing to a cluster or object store to restore the domain manager. The created restore source is intended to be deleted after use. If the restore source is not deleted using the deleteRestoreSource API, then it is auto-deleted after sometime. Also note that a restore source will not contain a backup policy. It is only used to access the backup data at the location from where the Prism Central may be restored. Credentials used to access the restore source are not validated at the time of creation of the restore source. They are validated when the restore source is used to fetch data.

        ## Example Usage

        ### Cluster Location

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # restore source is auto-deleted after sometime, nutanix_pc_restore_source_v2 resource is auto-create
        # new restore source if it was deleted, so notice that the id of the restore source will be different
        # after recreation
        cluster_location = nutanix.PcRestoreSourceV2("cluster-location", location={
            "cluster_locations": [{
                "configs": [{
                    "ext_id": "323860ca-bd10-411e-9fe0-1430b62eaf45",
                }],
            }],
        })
        ```

        ### Object Store Location

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # using object store location
        object_store_location = nutanix.PcRestoreSourceV2("object-store-location", location={
            "object_store_locations": [{
                "provider_configs": [{
                    "bucket_name": "nutanix-terraform-bucket",
                    "region": "us-west-1",
                    "credentials": {
                        "access_key_id": "IHSAJHDHADFWYTKJHFGCJKHASGJHKDSA",
                        "secret_access_key": "JGSDHJYHGFHGHDS+JKBASDF/HSDAFHJ+SjkfbdsASDfdJFdSDFJfk",
                    },
                }],
                "backup_policies": [{
                    "rpo_in_minutes": 120,
                }],
            }],
        })
        ```

        :param str resource_name: The name of the resource.
        :param PcRestoreSourceV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PcRestoreSourceV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[Union['PcRestoreSourceV2LocationArgs', 'PcRestoreSourceV2LocationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PcRestoreSourceV2Args.__new__(PcRestoreSourceV2Args)

            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["backup_pause_reason"] = None
            __props__.__dict__["ext_id"] = None
            __props__.__dict__["is_backup_paused"] = None
            __props__.__dict__["last_sync_time"] = None
            __props__.__dict__["links"] = None
            __props__.__dict__["tenant_id"] = None
        super(PcRestoreSourceV2, __self__).__init__(
            'nutanix:index/pcRestoreSourceV2:PcRestoreSourceV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_pause_reason: Optional[pulumi.Input[_builtins.str]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_backup_paused: Optional[pulumi.Input[_builtins.bool]] = None,
            last_sync_time: Optional[pulumi.Input[_builtins.str]] = None,
            links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PcRestoreSourceV2LinkArgs', 'PcRestoreSourceV2LinkArgsDict']]]]] = None,
            location: Optional[pulumi.Input[Union['PcRestoreSourceV2LocationArgs', 'PcRestoreSourceV2LocationArgsDict']]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'PcRestoreSourceV2':
        """
        Get an existing PcRestoreSourceV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PcRestoreSourceV2LocationArgs', 'PcRestoreSourceV2LocationArgsDict']] location: -(Required) Location of the backup target. For example, a cluster or an object store endpoint, such as AWS s3.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PcRestoreSourceV2State.__new__(_PcRestoreSourceV2State)

        __props__.__dict__["backup_pause_reason"] = backup_pause_reason
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["is_backup_paused"] = is_backup_paused
        __props__.__dict__["last_sync_time"] = last_sync_time
        __props__.__dict__["links"] = links
        __props__.__dict__["location"] = location
        __props__.__dict__["tenant_id"] = tenant_id
        return PcRestoreSourceV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupPauseReason")
    def backup_pause_reason(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "backup_pause_reason")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="isBackupPaused")
    def is_backup_paused(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "is_backup_paused")

    @_builtins.property
    @pulumi.getter(name="lastSyncTime")
    def last_sync_time(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "last_sync_time")

    @_builtins.property
    @pulumi.getter
    def links(self) -> pulumi.Output[Sequence['outputs.PcRestoreSourceV2Link']]:
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output['outputs.PcRestoreSourceV2Location']:
        """
        -(Required) Location of the backup target. For example, a cluster or an object store endpoint, such as AWS s3.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tenant_id")

