# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PcRestoreV2Args', 'PcRestoreV2']

@pulumi.input_type
class PcRestoreV2Args:
    def __init__(__self__, *,
                 domain_manager: pulumi.Input['PcRestoreV2DomainManagerArgs'],
                 ext_id: pulumi.Input[_builtins.str],
                 restorable_domain_manager_ext_id: pulumi.Input[_builtins.str],
                 restore_source_ext_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a PcRestoreV2 resource.
        :param pulumi.Input['PcRestoreV2DomainManagerArgs'] domain_manager: -(Required) Domain manager (Prism Central) details.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) Restore point ID for the backup created in cluster/object store.
        :param pulumi.Input[_builtins.str] restorable_domain_manager_ext_id: -(Required) A unique identifier for the domain manager.
        :param pulumi.Input[_builtins.str] restore_source_ext_id: -(Required) A unique identifier obtained from the restore source API that corresponds to the details provided for the restore source.
        """
        pulumi.set(__self__, "domain_manager", domain_manager)
        pulumi.set(__self__, "ext_id", ext_id)
        pulumi.set(__self__, "restorable_domain_manager_ext_id", restorable_domain_manager_ext_id)
        pulumi.set(__self__, "restore_source_ext_id", restore_source_ext_id)

    @_builtins.property
    @pulumi.getter(name="domainManager")
    def domain_manager(self) -> pulumi.Input['PcRestoreV2DomainManagerArgs']:
        """
        -(Required) Domain manager (Prism Central) details.
        """
        return pulumi.get(self, "domain_manager")

    @domain_manager.setter
    def domain_manager(self, value: pulumi.Input['PcRestoreV2DomainManagerArgs']):
        pulumi.set(self, "domain_manager", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) Restore point ID for the backup created in cluster/object store.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="restorableDomainManagerExtId")
    def restorable_domain_manager_ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) A unique identifier for the domain manager.
        """
        return pulumi.get(self, "restorable_domain_manager_ext_id")

    @restorable_domain_manager_ext_id.setter
    def restorable_domain_manager_ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "restorable_domain_manager_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="restoreSourceExtId")
    def restore_source_ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) A unique identifier obtained from the restore source API that corresponds to the details provided for the restore source.
        """
        return pulumi.get(self, "restore_source_ext_id")

    @restore_source_ext_id.setter
    def restore_source_ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "restore_source_ext_id", value)


@pulumi.input_type
class _PcRestoreV2State:
    def __init__(__self__, *,
                 domain_manager: Optional[pulumi.Input['PcRestoreV2DomainManagerArgs']] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restorable_domain_manager_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_source_ext_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PcRestoreV2 resources.
        :param pulumi.Input['PcRestoreV2DomainManagerArgs'] domain_manager: -(Required) Domain manager (Prism Central) details.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) Restore point ID for the backup created in cluster/object store.
        :param pulumi.Input[_builtins.str] restorable_domain_manager_ext_id: -(Required) A unique identifier for the domain manager.
        :param pulumi.Input[_builtins.str] restore_source_ext_id: -(Required) A unique identifier obtained from the restore source API that corresponds to the details provided for the restore source.
        """
        if domain_manager is not None:
            pulumi.set(__self__, "domain_manager", domain_manager)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if restorable_domain_manager_ext_id is not None:
            pulumi.set(__self__, "restorable_domain_manager_ext_id", restorable_domain_manager_ext_id)
        if restore_source_ext_id is not None:
            pulumi.set(__self__, "restore_source_ext_id", restore_source_ext_id)

    @_builtins.property
    @pulumi.getter(name="domainManager")
    def domain_manager(self) -> Optional[pulumi.Input['PcRestoreV2DomainManagerArgs']]:
        """
        -(Required) Domain manager (Prism Central) details.
        """
        return pulumi.get(self, "domain_manager")

    @domain_manager.setter
    def domain_manager(self, value: Optional[pulumi.Input['PcRestoreV2DomainManagerArgs']]):
        pulumi.set(self, "domain_manager", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) Restore point ID for the backup created in cluster/object store.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="restorableDomainManagerExtId")
    def restorable_domain_manager_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) A unique identifier for the domain manager.
        """
        return pulumi.get(self, "restorable_domain_manager_ext_id")

    @restorable_domain_manager_ext_id.setter
    def restorable_domain_manager_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restorable_domain_manager_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="restoreSourceExtId")
    def restore_source_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) A unique identifier obtained from the restore source API that corresponds to the details provided for the restore source.
        """
        return pulumi.get(self, "restore_source_ext_id")

    @restore_source_ext_id.setter
    def restore_source_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restore_source_ext_id", value)


@pulumi.type_token("nutanix:index/pcRestoreV2:PcRestoreV2")
class PcRestoreV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_manager: Optional[pulumi.Input[Union['PcRestoreV2DomainManagerArgs', 'PcRestoreV2DomainManagerArgsDict']]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restorable_domain_manager_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_source_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        > - The Pc Restore V2 resource is an action-only resource that supports creating actions. The update and delete operations have no effect. To run it again, destroy and reapply the resource.
        > -  We need to increase the timeout for restoring the PC, because the restore pc takes longer than the default timeout allows for the operation to complete.

        The restore domain manager is a task-driven operation to restore a domain manager from a cluster or object store backup location based on the selected restore point.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PcRestoreV2DomainManagerArgs', 'PcRestoreV2DomainManagerArgsDict']] domain_manager: -(Required) Domain manager (Prism Central) details.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) Restore point ID for the backup created in cluster/object store.
        :param pulumi.Input[_builtins.str] restorable_domain_manager_ext_id: -(Required) A unique identifier for the domain manager.
        :param pulumi.Input[_builtins.str] restore_source_ext_id: -(Required) A unique identifier obtained from the restore source API that corresponds to the details provided for the restore source.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PcRestoreV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > - The Pc Restore V2 resource is an action-only resource that supports creating actions. The update and delete operations have no effect. To run it again, destroy and reapply the resource.
        > -  We need to increase the timeout for restoring the PC, because the restore pc takes longer than the default timeout allows for the operation to complete.

        The restore domain manager is a task-driven operation to restore a domain manager from a cluster or object store backup location based on the selected restore point.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param PcRestoreV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PcRestoreV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_manager: Optional[pulumi.Input[Union['PcRestoreV2DomainManagerArgs', 'PcRestoreV2DomainManagerArgsDict']]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restorable_domain_manager_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_source_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PcRestoreV2Args.__new__(PcRestoreV2Args)

            if domain_manager is None and not opts.urn:
                raise TypeError("Missing required property 'domain_manager'")
            __props__.__dict__["domain_manager"] = domain_manager
            if ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'ext_id'")
            __props__.__dict__["ext_id"] = ext_id
            if restorable_domain_manager_ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'restorable_domain_manager_ext_id'")
            __props__.__dict__["restorable_domain_manager_ext_id"] = restorable_domain_manager_ext_id
            if restore_source_ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'restore_source_ext_id'")
            __props__.__dict__["restore_source_ext_id"] = restore_source_ext_id
        super(PcRestoreV2, __self__).__init__(
            'nutanix:index/pcRestoreV2:PcRestoreV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            domain_manager: Optional[pulumi.Input[Union['PcRestoreV2DomainManagerArgs', 'PcRestoreV2DomainManagerArgsDict']]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            restorable_domain_manager_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            restore_source_ext_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'PcRestoreV2':
        """
        Get an existing PcRestoreV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PcRestoreV2DomainManagerArgs', 'PcRestoreV2DomainManagerArgsDict']] domain_manager: -(Required) Domain manager (Prism Central) details.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) Restore point ID for the backup created in cluster/object store.
        :param pulumi.Input[_builtins.str] restorable_domain_manager_ext_id: -(Required) A unique identifier for the domain manager.
        :param pulumi.Input[_builtins.str] restore_source_ext_id: -(Required) A unique identifier obtained from the restore source API that corresponds to the details provided for the restore source.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PcRestoreV2State.__new__(_PcRestoreV2State)

        __props__.__dict__["domain_manager"] = domain_manager
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["restorable_domain_manager_ext_id"] = restorable_domain_manager_ext_id
        __props__.__dict__["restore_source_ext_id"] = restore_source_ext_id
        return PcRestoreV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="domainManager")
    def domain_manager(self) -> pulumi.Output['outputs.PcRestoreV2DomainManager']:
        """
        -(Required) Domain manager (Prism Central) details.
        """
        return pulumi.get(self, "domain_manager")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) Restore point ID for the backup created in cluster/object store.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="restorableDomainManagerExtId")
    def restorable_domain_manager_ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) A unique identifier for the domain manager.
        """
        return pulumi.get(self, "restorable_domain_manager_ext_id")

    @_builtins.property
    @pulumi.getter(name="restoreSourceExtId")
    def restore_source_ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) A unique identifier obtained from the restore source API that corresponds to the details provided for the restore source.
        """
        return pulumi.get(self, "restore_source_ext_id")

