# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PcUnregistrationV2Args', 'PcUnregistrationV2']

@pulumi.input_type
class PcUnregistrationV2Args:
    def __init__(__self__, *,
                 ext_id: pulumi.Input[_builtins.str],
                 pc_ext_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a PcUnregistrationV2 resource.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) Cluster UUID of a remote cluster.
               
               See detailed information in [Nutanix PC Unregistration V4](https://developers.nutanix.com/api-reference?namespace=prism&version=v4.0#tag/DomainManager/operation/unregister).
        :param pulumi.Input[_builtins.str] pc_ext_id: -(Required) The external identifier of the domain manager (Prism Central) resource
        """
        pulumi.set(__self__, "ext_id", ext_id)
        pulumi.set(__self__, "pc_ext_id", pc_ext_id)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) Cluster UUID of a remote cluster.

        See detailed information in [Nutanix PC Unregistration V4](https://developers.nutanix.com/api-reference?namespace=prism&version=v4.0#tag/DomainManager/operation/unregister).
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="pcExtId")
    def pc_ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) The external identifier of the domain manager (Prism Central) resource
        """
        return pulumi.get(self, "pc_ext_id")

    @pc_ext_id.setter
    def pc_ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pc_ext_id", value)


@pulumi.input_type
class _PcUnregistrationV2State:
    def __init__(__self__, *,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pc_ext_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PcUnregistrationV2 resources.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) Cluster UUID of a remote cluster.
               
               See detailed information in [Nutanix PC Unregistration V4](https://developers.nutanix.com/api-reference?namespace=prism&version=v4.0#tag/DomainManager/operation/unregister).
        :param pulumi.Input[_builtins.str] pc_ext_id: -(Required) The external identifier of the domain manager (Prism Central) resource
        """
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if pc_ext_id is not None:
            pulumi.set(__self__, "pc_ext_id", pc_ext_id)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) Cluster UUID of a remote cluster.

        See detailed information in [Nutanix PC Unregistration V4](https://developers.nutanix.com/api-reference?namespace=prism&version=v4.0#tag/DomainManager/operation/unregister).
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="pcExtId")
    def pc_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) The external identifier of the domain manager (Prism Central) resource
        """
        return pulumi.get(self, "pc_ext_id")

    @pc_ext_id.setter
    def pc_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pc_ext_id", value)


@pulumi.type_token("nutanix:index/pcUnregistrationV2:PcUnregistrationV2")
class PcUnregistrationV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pc_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Unregister a registered remote cluster from the local cluster. This process is asynchronous, creating an un-registration task and returning its UUID.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) Cluster UUID of a remote cluster.
               
               See detailed information in [Nutanix PC Unregistration V4](https://developers.nutanix.com/api-reference?namespace=prism&version=v4.0#tag/DomainManager/operation/unregister).
        :param pulumi.Input[_builtins.str] pc_ext_id: -(Required) The external identifier of the domain manager (Prism Central) resource
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PcUnregistrationV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Unregister a registered remote cluster from the local cluster. This process is asynchronous, creating an un-registration task and returning its UUID.

        :param str resource_name: The name of the resource.
        :param PcUnregistrationV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PcUnregistrationV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pc_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PcUnregistrationV2Args.__new__(PcUnregistrationV2Args)

            if ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'ext_id'")
            __props__.__dict__["ext_id"] = ext_id
            if pc_ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'pc_ext_id'")
            __props__.__dict__["pc_ext_id"] = pc_ext_id
        super(PcUnregistrationV2, __self__).__init__(
            'nutanix:index/pcUnregistrationV2:PcUnregistrationV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            pc_ext_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'PcUnregistrationV2':
        """
        Get an existing PcUnregistrationV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) Cluster UUID of a remote cluster.
               
               See detailed information in [Nutanix PC Unregistration V4](https://developers.nutanix.com/api-reference?namespace=prism&version=v4.0#tag/DomainManager/operation/unregister).
        :param pulumi.Input[_builtins.str] pc_ext_id: -(Required) The external identifier of the domain manager (Prism Central) resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PcUnregistrationV2State.__new__(_PcUnregistrationV2State)

        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["pc_ext_id"] = pc_ext_id
        return PcUnregistrationV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) Cluster UUID of a remote cluster.

        See detailed information in [Nutanix PC Unregistration V4](https://developers.nutanix.com/api-reference?namespace=prism&version=v4.0#tag/DomainManager/operation/unregister).
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="pcExtId")
    def pc_ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) The external identifier of the domain manager (Prism Central) resource
        """
        return pulumi.get(self, "pc_ext_id")

