# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectArgs', 'Project']

@pulumi.input_type
class ProjectArgs:
    def __init__(__self__, *,
                 default_subnet_reference: pulumi.Input['ProjectDefaultSubnetReferenceArgs'],
                 description: pulumi.Input[_builtins.str],
                 account_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectAccountReferenceListArgs']]]] = None,
                 acps: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectAcpArgs']]]] = None,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectCategoryArgs']]]] = None,
                 cluster_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectClusterReferenceListArgs']]]] = None,
                 cluster_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 default_environment_reference: Optional[pulumi.Input['ProjectDefaultEnvironmentReferenceArgs']] = None,
                 enable_collab: Optional[pulumi.Input[_builtins.bool]] = None,
                 environment_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentReferenceListArgs']]]] = None,
                 external_network_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectExternalNetworkListArgs']]]] = None,
                 external_user_group_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectExternalUserGroupReferenceListArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 resource_domain: Optional[pulumi.Input['ProjectResourceDomainArgs']] = None,
                 subnet_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSubnetReferenceListArgs']]]] = None,
                 tunnel_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectTunnelReferenceListArgs']]]] = None,
                 use_project_internal: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_group_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectUserGroupListArgs']]]] = None,
                 user_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectUserListArgs']]]] = None,
                 user_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectUserReferenceListArgs']]]] = None,
                 vpc_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectVpcReferenceListArgs']]]] = None):
        """
        The set of arguments for constructing a Project resource.
        :param pulumi.Input[_builtins.str] description: A description for project.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectCategoryArgs']]] categories: - (Optional) The category values represented as a dictionary of key > list of values.
        :param pulumi.Input[_builtins.str] cluster_uuid: The UUID of cluster. (Required when using project_internal flag).
        :param pulumi.Input[_builtins.bool] enable_collab: flag to allow collaboration of projects. (Use with project_internal flag)
        :param pulumi.Input[_builtins.str] name: The name for the project.
        :param pulumi.Input[_builtins.bool] use_project_internal: flag to use project internal for user role mapping
        :param pulumi.Input[Sequence[pulumi.Input['ProjectUserReferenceListArgs']]] user_reference_lists: List of Reference of users.
        """
        pulumi.set(__self__, "default_subnet_reference", default_subnet_reference)
        pulumi.set(__self__, "description", description)
        if account_reference_lists is not None:
            pulumi.set(__self__, "account_reference_lists", account_reference_lists)
        if acps is not None:
            pulumi.set(__self__, "acps", acps)
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if cluster_reference_lists is not None:
            pulumi.set(__self__, "cluster_reference_lists", cluster_reference_lists)
        if cluster_uuid is not None:
            pulumi.set(__self__, "cluster_uuid", cluster_uuid)
        if default_environment_reference is not None:
            pulumi.set(__self__, "default_environment_reference", default_environment_reference)
        if enable_collab is not None:
            pulumi.set(__self__, "enable_collab", enable_collab)
        if environment_reference_lists is not None:
            pulumi.set(__self__, "environment_reference_lists", environment_reference_lists)
        if external_network_lists is not None:
            pulumi.set(__self__, "external_network_lists", external_network_lists)
        if external_user_group_reference_lists is not None:
            pulumi.set(__self__, "external_user_group_reference_lists", external_user_group_reference_lists)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_reference is not None:
            pulumi.set(__self__, "owner_reference", owner_reference)
        if project_reference is not None:
            pulumi.set(__self__, "project_reference", project_reference)
        if resource_domain is not None:
            pulumi.set(__self__, "resource_domain", resource_domain)
        if subnet_reference_lists is not None:
            pulumi.set(__self__, "subnet_reference_lists", subnet_reference_lists)
        if tunnel_reference_lists is not None:
            pulumi.set(__self__, "tunnel_reference_lists", tunnel_reference_lists)
        if use_project_internal is not None:
            pulumi.set(__self__, "use_project_internal", use_project_internal)
        if user_group_lists is not None:
            pulumi.set(__self__, "user_group_lists", user_group_lists)
        if user_lists is not None:
            pulumi.set(__self__, "user_lists", user_lists)
        if user_reference_lists is not None:
            pulumi.set(__self__, "user_reference_lists", user_reference_lists)
        if vpc_reference_lists is not None:
            pulumi.set(__self__, "vpc_reference_lists", vpc_reference_lists)

    @_builtins.property
    @pulumi.getter(name="defaultSubnetReference")
    def default_subnet_reference(self) -> pulumi.Input['ProjectDefaultSubnetReferenceArgs']:
        return pulumi.get(self, "default_subnet_reference")

    @default_subnet_reference.setter
    def default_subnet_reference(self, value: pulumi.Input['ProjectDefaultSubnetReferenceArgs']):
        pulumi.set(self, "default_subnet_reference", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        A description for project.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="accountReferenceLists")
    def account_reference_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectAccountReferenceListArgs']]]]:
        return pulumi.get(self, "account_reference_lists")

    @account_reference_lists.setter
    def account_reference_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectAccountReferenceListArgs']]]]):
        pulumi.set(self, "account_reference_lists", value)

    @_builtins.property
    @pulumi.getter
    def acps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectAcpArgs']]]]:
        return pulumi.get(self, "acps")

    @acps.setter
    def acps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectAcpArgs']]]]):
        pulumi.set(self, "acps", value)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectCategoryArgs']]]]:
        """
        - (Optional) The category values represented as a dictionary of key > list of values.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectCategoryArgs']]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter(name="clusterReferenceLists")
    def cluster_reference_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectClusterReferenceListArgs']]]]:
        return pulumi.get(self, "cluster_reference_lists")

    @cluster_reference_lists.setter
    def cluster_reference_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectClusterReferenceListArgs']]]]):
        pulumi.set(self, "cluster_reference_lists", value)

    @_builtins.property
    @pulumi.getter(name="clusterUuid")
    def cluster_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UUID of cluster. (Required when using project_internal flag).
        """
        return pulumi.get(self, "cluster_uuid")

    @cluster_uuid.setter
    def cluster_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_uuid", value)

    @_builtins.property
    @pulumi.getter(name="defaultEnvironmentReference")
    def default_environment_reference(self) -> Optional[pulumi.Input['ProjectDefaultEnvironmentReferenceArgs']]:
        return pulumi.get(self, "default_environment_reference")

    @default_environment_reference.setter
    def default_environment_reference(self, value: Optional[pulumi.Input['ProjectDefaultEnvironmentReferenceArgs']]):
        pulumi.set(self, "default_environment_reference", value)

    @_builtins.property
    @pulumi.getter(name="enableCollab")
    def enable_collab(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        flag to allow collaboration of projects. (Use with project_internal flag)
        """
        return pulumi.get(self, "enable_collab")

    @enable_collab.setter
    def enable_collab(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_collab", value)

    @_builtins.property
    @pulumi.getter(name="environmentReferenceLists")
    def environment_reference_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentReferenceListArgs']]]]:
        return pulumi.get(self, "environment_reference_lists")

    @environment_reference_lists.setter
    def environment_reference_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentReferenceListArgs']]]]):
        pulumi.set(self, "environment_reference_lists", value)

    @_builtins.property
    @pulumi.getter(name="externalNetworkLists")
    def external_network_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectExternalNetworkListArgs']]]]:
        return pulumi.get(self, "external_network_lists")

    @external_network_lists.setter
    def external_network_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectExternalNetworkListArgs']]]]):
        pulumi.set(self, "external_network_lists", value)

    @_builtins.property
    @pulumi.getter(name="externalUserGroupReferenceLists")
    def external_user_group_reference_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectExternalUserGroupReferenceListArgs']]]]:
        return pulumi.get(self, "external_user_group_reference_lists")

    @external_user_group_reference_lists.setter
    def external_user_group_reference_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectExternalUserGroupReferenceListArgs']]]]):
        pulumi.set(self, "external_user_group_reference_lists", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "owner_reference")

    @owner_reference.setter
    def owner_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "owner_reference", value)

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "project_reference")

    @project_reference.setter
    def project_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "project_reference", value)

    @_builtins.property
    @pulumi.getter(name="resourceDomain")
    def resource_domain(self) -> Optional[pulumi.Input['ProjectResourceDomainArgs']]:
        return pulumi.get(self, "resource_domain")

    @resource_domain.setter
    def resource_domain(self, value: Optional[pulumi.Input['ProjectResourceDomainArgs']]):
        pulumi.set(self, "resource_domain", value)

    @_builtins.property
    @pulumi.getter(name="subnetReferenceLists")
    def subnet_reference_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSubnetReferenceListArgs']]]]:
        return pulumi.get(self, "subnet_reference_lists")

    @subnet_reference_lists.setter
    def subnet_reference_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSubnetReferenceListArgs']]]]):
        pulumi.set(self, "subnet_reference_lists", value)

    @_builtins.property
    @pulumi.getter(name="tunnelReferenceLists")
    def tunnel_reference_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectTunnelReferenceListArgs']]]]:
        return pulumi.get(self, "tunnel_reference_lists")

    @tunnel_reference_lists.setter
    def tunnel_reference_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectTunnelReferenceListArgs']]]]):
        pulumi.set(self, "tunnel_reference_lists", value)

    @_builtins.property
    @pulumi.getter(name="useProjectInternal")
    def use_project_internal(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        flag to use project internal for user role mapping
        """
        return pulumi.get(self, "use_project_internal")

    @use_project_internal.setter
    def use_project_internal(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_project_internal", value)

    @_builtins.property
    @pulumi.getter(name="userGroupLists")
    def user_group_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectUserGroupListArgs']]]]:
        return pulumi.get(self, "user_group_lists")

    @user_group_lists.setter
    def user_group_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectUserGroupListArgs']]]]):
        pulumi.set(self, "user_group_lists", value)

    @_builtins.property
    @pulumi.getter(name="userLists")
    def user_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectUserListArgs']]]]:
        return pulumi.get(self, "user_lists")

    @user_lists.setter
    def user_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectUserListArgs']]]]):
        pulumi.set(self, "user_lists", value)

    @_builtins.property
    @pulumi.getter(name="userReferenceLists")
    def user_reference_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectUserReferenceListArgs']]]]:
        """
        List of Reference of users.
        """
        return pulumi.get(self, "user_reference_lists")

    @user_reference_lists.setter
    def user_reference_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectUserReferenceListArgs']]]]):
        pulumi.set(self, "user_reference_lists", value)

    @_builtins.property
    @pulumi.getter(name="vpcReferenceLists")
    def vpc_reference_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectVpcReferenceListArgs']]]]:
        return pulumi.get(self, "vpc_reference_lists")

    @vpc_reference_lists.setter
    def vpc_reference_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectVpcReferenceListArgs']]]]):
        pulumi.set(self, "vpc_reference_lists", value)


@pulumi.input_type
class _ProjectState:
    def __init__(__self__, *,
                 account_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectAccountReferenceListArgs']]]] = None,
                 acps: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectAcpArgs']]]] = None,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectCategoryArgs']]]] = None,
                 cluster_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectClusterReferenceListArgs']]]] = None,
                 cluster_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 default_environment_reference: Optional[pulumi.Input['ProjectDefaultEnvironmentReferenceArgs']] = None,
                 default_subnet_reference: Optional[pulumi.Input['ProjectDefaultSubnetReferenceArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_collab: Optional[pulumi.Input[_builtins.bool]] = None,
                 environment_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentReferenceListArgs']]]] = None,
                 external_network_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectExternalNetworkListArgs']]]] = None,
                 external_user_group_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectExternalUserGroupReferenceListArgs']]]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 resource_domain: Optional[pulumi.Input['ProjectResourceDomainArgs']] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSubnetReferenceListArgs']]]] = None,
                 tunnel_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectTunnelReferenceListArgs']]]] = None,
                 use_project_internal: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_group_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectUserGroupListArgs']]]] = None,
                 user_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectUserListArgs']]]] = None,
                 user_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectUserReferenceListArgs']]]] = None,
                 vpc_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectVpcReferenceListArgs']]]] = None):
        """
        Input properties used for looking up and filtering Project resources.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectCategoryArgs']]] categories: - (Optional) The category values represented as a dictionary of key > list of values.
        :param pulumi.Input[_builtins.str] cluster_uuid: The UUID of cluster. (Required when using project_internal flag).
        :param pulumi.Input[_builtins.str] description: A description for project.
        :param pulumi.Input[_builtins.bool] enable_collab: flag to allow collaboration of projects. (Use with project_internal flag)
        :param pulumi.Input[_builtins.str] name: The name for the project.
        :param pulumi.Input[_builtins.bool] use_project_internal: flag to use project internal for user role mapping
        :param pulumi.Input[Sequence[pulumi.Input['ProjectUserReferenceListArgs']]] user_reference_lists: List of Reference of users.
        """
        if account_reference_lists is not None:
            pulumi.set(__self__, "account_reference_lists", account_reference_lists)
        if acps is not None:
            pulumi.set(__self__, "acps", acps)
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if cluster_reference_lists is not None:
            pulumi.set(__self__, "cluster_reference_lists", cluster_reference_lists)
        if cluster_uuid is not None:
            pulumi.set(__self__, "cluster_uuid", cluster_uuid)
        if default_environment_reference is not None:
            pulumi.set(__self__, "default_environment_reference", default_environment_reference)
        if default_subnet_reference is not None:
            pulumi.set(__self__, "default_subnet_reference", default_subnet_reference)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_collab is not None:
            pulumi.set(__self__, "enable_collab", enable_collab)
        if environment_reference_lists is not None:
            pulumi.set(__self__, "environment_reference_lists", environment_reference_lists)
        if external_network_lists is not None:
            pulumi.set(__self__, "external_network_lists", external_network_lists)
        if external_user_group_reference_lists is not None:
            pulumi.set(__self__, "external_user_group_reference_lists", external_user_group_reference_lists)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_reference is not None:
            pulumi.set(__self__, "owner_reference", owner_reference)
        if project_reference is not None:
            pulumi.set(__self__, "project_reference", project_reference)
        if resource_domain is not None:
            pulumi.set(__self__, "resource_domain", resource_domain)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_reference_lists is not None:
            pulumi.set(__self__, "subnet_reference_lists", subnet_reference_lists)
        if tunnel_reference_lists is not None:
            pulumi.set(__self__, "tunnel_reference_lists", tunnel_reference_lists)
        if use_project_internal is not None:
            pulumi.set(__self__, "use_project_internal", use_project_internal)
        if user_group_lists is not None:
            pulumi.set(__self__, "user_group_lists", user_group_lists)
        if user_lists is not None:
            pulumi.set(__self__, "user_lists", user_lists)
        if user_reference_lists is not None:
            pulumi.set(__self__, "user_reference_lists", user_reference_lists)
        if vpc_reference_lists is not None:
            pulumi.set(__self__, "vpc_reference_lists", vpc_reference_lists)

    @_builtins.property
    @pulumi.getter(name="accountReferenceLists")
    def account_reference_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectAccountReferenceListArgs']]]]:
        return pulumi.get(self, "account_reference_lists")

    @account_reference_lists.setter
    def account_reference_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectAccountReferenceListArgs']]]]):
        pulumi.set(self, "account_reference_lists", value)

    @_builtins.property
    @pulumi.getter
    def acps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectAcpArgs']]]]:
        return pulumi.get(self, "acps")

    @acps.setter
    def acps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectAcpArgs']]]]):
        pulumi.set(self, "acps", value)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectCategoryArgs']]]]:
        """
        - (Optional) The category values represented as a dictionary of key > list of values.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectCategoryArgs']]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter(name="clusterReferenceLists")
    def cluster_reference_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectClusterReferenceListArgs']]]]:
        return pulumi.get(self, "cluster_reference_lists")

    @cluster_reference_lists.setter
    def cluster_reference_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectClusterReferenceListArgs']]]]):
        pulumi.set(self, "cluster_reference_lists", value)

    @_builtins.property
    @pulumi.getter(name="clusterUuid")
    def cluster_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UUID of cluster. (Required when using project_internal flag).
        """
        return pulumi.get(self, "cluster_uuid")

    @cluster_uuid.setter
    def cluster_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_uuid", value)

    @_builtins.property
    @pulumi.getter(name="defaultEnvironmentReference")
    def default_environment_reference(self) -> Optional[pulumi.Input['ProjectDefaultEnvironmentReferenceArgs']]:
        return pulumi.get(self, "default_environment_reference")

    @default_environment_reference.setter
    def default_environment_reference(self, value: Optional[pulumi.Input['ProjectDefaultEnvironmentReferenceArgs']]):
        pulumi.set(self, "default_environment_reference", value)

    @_builtins.property
    @pulumi.getter(name="defaultSubnetReference")
    def default_subnet_reference(self) -> Optional[pulumi.Input['ProjectDefaultSubnetReferenceArgs']]:
        return pulumi.get(self, "default_subnet_reference")

    @default_subnet_reference.setter
    def default_subnet_reference(self, value: Optional[pulumi.Input['ProjectDefaultSubnetReferenceArgs']]):
        pulumi.set(self, "default_subnet_reference", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for project.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableCollab")
    def enable_collab(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        flag to allow collaboration of projects. (Use with project_internal flag)
        """
        return pulumi.get(self, "enable_collab")

    @enable_collab.setter
    def enable_collab(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_collab", value)

    @_builtins.property
    @pulumi.getter(name="environmentReferenceLists")
    def environment_reference_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentReferenceListArgs']]]]:
        return pulumi.get(self, "environment_reference_lists")

    @environment_reference_lists.setter
    def environment_reference_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentReferenceListArgs']]]]):
        pulumi.set(self, "environment_reference_lists", value)

    @_builtins.property
    @pulumi.getter(name="externalNetworkLists")
    def external_network_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectExternalNetworkListArgs']]]]:
        return pulumi.get(self, "external_network_lists")

    @external_network_lists.setter
    def external_network_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectExternalNetworkListArgs']]]]):
        pulumi.set(self, "external_network_lists", value)

    @_builtins.property
    @pulumi.getter(name="externalUserGroupReferenceLists")
    def external_user_group_reference_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectExternalUserGroupReferenceListArgs']]]]:
        return pulumi.get(self, "external_user_group_reference_lists")

    @external_user_group_reference_lists.setter
    def external_user_group_reference_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectExternalUserGroupReferenceListArgs']]]]):
        pulumi.set(self, "external_user_group_reference_lists", value)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "owner_reference")

    @owner_reference.setter
    def owner_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "owner_reference", value)

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "project_reference")

    @project_reference.setter
    def project_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "project_reference", value)

    @_builtins.property
    @pulumi.getter(name="resourceDomain")
    def resource_domain(self) -> Optional[pulumi.Input['ProjectResourceDomainArgs']]:
        return pulumi.get(self, "resource_domain")

    @resource_domain.setter
    def resource_domain(self, value: Optional[pulumi.Input['ProjectResourceDomainArgs']]):
        pulumi.set(self, "resource_domain", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="subnetReferenceLists")
    def subnet_reference_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSubnetReferenceListArgs']]]]:
        return pulumi.get(self, "subnet_reference_lists")

    @subnet_reference_lists.setter
    def subnet_reference_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSubnetReferenceListArgs']]]]):
        pulumi.set(self, "subnet_reference_lists", value)

    @_builtins.property
    @pulumi.getter(name="tunnelReferenceLists")
    def tunnel_reference_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectTunnelReferenceListArgs']]]]:
        return pulumi.get(self, "tunnel_reference_lists")

    @tunnel_reference_lists.setter
    def tunnel_reference_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectTunnelReferenceListArgs']]]]):
        pulumi.set(self, "tunnel_reference_lists", value)

    @_builtins.property
    @pulumi.getter(name="useProjectInternal")
    def use_project_internal(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        flag to use project internal for user role mapping
        """
        return pulumi.get(self, "use_project_internal")

    @use_project_internal.setter
    def use_project_internal(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_project_internal", value)

    @_builtins.property
    @pulumi.getter(name="userGroupLists")
    def user_group_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectUserGroupListArgs']]]]:
        return pulumi.get(self, "user_group_lists")

    @user_group_lists.setter
    def user_group_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectUserGroupListArgs']]]]):
        pulumi.set(self, "user_group_lists", value)

    @_builtins.property
    @pulumi.getter(name="userLists")
    def user_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectUserListArgs']]]]:
        return pulumi.get(self, "user_lists")

    @user_lists.setter
    def user_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectUserListArgs']]]]):
        pulumi.set(self, "user_lists", value)

    @_builtins.property
    @pulumi.getter(name="userReferenceLists")
    def user_reference_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectUserReferenceListArgs']]]]:
        """
        List of Reference of users.
        """
        return pulumi.get(self, "user_reference_lists")

    @user_reference_lists.setter
    def user_reference_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectUserReferenceListArgs']]]]):
        pulumi.set(self, "user_reference_lists", value)

    @_builtins.property
    @pulumi.getter(name="vpcReferenceLists")
    def vpc_reference_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectVpcReferenceListArgs']]]]:
        return pulumi.get(self, "vpc_reference_lists")

    @vpc_reference_lists.setter
    def vpc_reference_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectVpcReferenceListArgs']]]]):
        pulumi.set(self, "vpc_reference_lists", value)


@pulumi.type_token("nutanix:index/project:Project")
class Project(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectAccountReferenceListArgs', 'ProjectAccountReferenceListArgsDict']]]]] = None,
                 acps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectAcpArgs', 'ProjectAcpArgsDict']]]]] = None,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectCategoryArgs', 'ProjectCategoryArgsDict']]]]] = None,
                 cluster_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectClusterReferenceListArgs', 'ProjectClusterReferenceListArgsDict']]]]] = None,
                 cluster_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 default_environment_reference: Optional[pulumi.Input[Union['ProjectDefaultEnvironmentReferenceArgs', 'ProjectDefaultEnvironmentReferenceArgsDict']]] = None,
                 default_subnet_reference: Optional[pulumi.Input[Union['ProjectDefaultSubnetReferenceArgs', 'ProjectDefaultSubnetReferenceArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_collab: Optional[pulumi.Input[_builtins.bool]] = None,
                 environment_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectEnvironmentReferenceListArgs', 'ProjectEnvironmentReferenceListArgsDict']]]]] = None,
                 external_network_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectExternalNetworkListArgs', 'ProjectExternalNetworkListArgsDict']]]]] = None,
                 external_user_group_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectExternalUserGroupReferenceListArgs', 'ProjectExternalUserGroupReferenceListArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 resource_domain: Optional[pulumi.Input[Union['ProjectResourceDomainArgs', 'ProjectResourceDomainArgsDict']]] = None,
                 subnet_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectSubnetReferenceListArgs', 'ProjectSubnetReferenceListArgsDict']]]]] = None,
                 tunnel_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectTunnelReferenceListArgs', 'ProjectTunnelReferenceListArgsDict']]]]] = None,
                 use_project_internal: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_group_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectUserGroupListArgs', 'ProjectUserGroupListArgsDict']]]]] = None,
                 user_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectUserListArgs', 'ProjectUserListArgsDict']]]]] = None,
                 user_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectUserReferenceListArgs', 'ProjectUserReferenceListArgsDict']]]]] = None,
                 vpc_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectVpcReferenceListArgs', 'ProjectVpcReferenceListArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a Nutanix Project resource to Create a Project.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectCategoryArgs', 'ProjectCategoryArgsDict']]]] categories: - (Optional) The category values represented as a dictionary of key > list of values.
        :param pulumi.Input[_builtins.str] cluster_uuid: The UUID of cluster. (Required when using project_internal flag).
        :param pulumi.Input[_builtins.str] description: A description for project.
        :param pulumi.Input[_builtins.bool] enable_collab: flag to allow collaboration of projects. (Use with project_internal flag)
        :param pulumi.Input[_builtins.str] name: The name for the project.
        :param pulumi.Input[_builtins.bool] use_project_internal: flag to use project internal for user role mapping
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectUserReferenceListArgs', 'ProjectUserReferenceListArgsDict']]]] user_reference_lists: List of Reference of users.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Nutanix Project resource to Create a Project.

        :param str resource_name: The name of the resource.
        :param ProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectAccountReferenceListArgs', 'ProjectAccountReferenceListArgsDict']]]]] = None,
                 acps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectAcpArgs', 'ProjectAcpArgsDict']]]]] = None,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectCategoryArgs', 'ProjectCategoryArgsDict']]]]] = None,
                 cluster_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectClusterReferenceListArgs', 'ProjectClusterReferenceListArgsDict']]]]] = None,
                 cluster_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 default_environment_reference: Optional[pulumi.Input[Union['ProjectDefaultEnvironmentReferenceArgs', 'ProjectDefaultEnvironmentReferenceArgsDict']]] = None,
                 default_subnet_reference: Optional[pulumi.Input[Union['ProjectDefaultSubnetReferenceArgs', 'ProjectDefaultSubnetReferenceArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_collab: Optional[pulumi.Input[_builtins.bool]] = None,
                 environment_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectEnvironmentReferenceListArgs', 'ProjectEnvironmentReferenceListArgsDict']]]]] = None,
                 external_network_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectExternalNetworkListArgs', 'ProjectExternalNetworkListArgsDict']]]]] = None,
                 external_user_group_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectExternalUserGroupReferenceListArgs', 'ProjectExternalUserGroupReferenceListArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 resource_domain: Optional[pulumi.Input[Union['ProjectResourceDomainArgs', 'ProjectResourceDomainArgsDict']]] = None,
                 subnet_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectSubnetReferenceListArgs', 'ProjectSubnetReferenceListArgsDict']]]]] = None,
                 tunnel_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectTunnelReferenceListArgs', 'ProjectTunnelReferenceListArgsDict']]]]] = None,
                 use_project_internal: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_group_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectUserGroupListArgs', 'ProjectUserGroupListArgsDict']]]]] = None,
                 user_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectUserListArgs', 'ProjectUserListArgsDict']]]]] = None,
                 user_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectUserReferenceListArgs', 'ProjectUserReferenceListArgsDict']]]]] = None,
                 vpc_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectVpcReferenceListArgs', 'ProjectVpcReferenceListArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectArgs.__new__(ProjectArgs)

            __props__.__dict__["account_reference_lists"] = account_reference_lists
            __props__.__dict__["acps"] = acps
            __props__.__dict__["api_version"] = api_version
            __props__.__dict__["categories"] = categories
            __props__.__dict__["cluster_reference_lists"] = cluster_reference_lists
            __props__.__dict__["cluster_uuid"] = cluster_uuid
            __props__.__dict__["default_environment_reference"] = default_environment_reference
            if default_subnet_reference is None and not opts.urn:
                raise TypeError("Missing required property 'default_subnet_reference'")
            __props__.__dict__["default_subnet_reference"] = default_subnet_reference
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_collab"] = enable_collab
            __props__.__dict__["environment_reference_lists"] = environment_reference_lists
            __props__.__dict__["external_network_lists"] = external_network_lists
            __props__.__dict__["external_user_group_reference_lists"] = external_user_group_reference_lists
            __props__.__dict__["name"] = name
            __props__.__dict__["owner_reference"] = owner_reference
            __props__.__dict__["project_reference"] = project_reference
            __props__.__dict__["resource_domain"] = resource_domain
            __props__.__dict__["subnet_reference_lists"] = subnet_reference_lists
            __props__.__dict__["tunnel_reference_lists"] = tunnel_reference_lists
            __props__.__dict__["use_project_internal"] = use_project_internal
            __props__.__dict__["user_group_lists"] = user_group_lists
            __props__.__dict__["user_lists"] = user_lists
            __props__.__dict__["user_reference_lists"] = user_reference_lists
            __props__.__dict__["vpc_reference_lists"] = vpc_reference_lists
            __props__.__dict__["is_default"] = None
            __props__.__dict__["metadata"] = None
            __props__.__dict__["state"] = None
        super(Project, __self__).__init__(
            'nutanix:index/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectAccountReferenceListArgs', 'ProjectAccountReferenceListArgsDict']]]]] = None,
            acps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectAcpArgs', 'ProjectAcpArgsDict']]]]] = None,
            api_version: Optional[pulumi.Input[_builtins.str]] = None,
            categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectCategoryArgs', 'ProjectCategoryArgsDict']]]]] = None,
            cluster_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectClusterReferenceListArgs', 'ProjectClusterReferenceListArgsDict']]]]] = None,
            cluster_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            default_environment_reference: Optional[pulumi.Input[Union['ProjectDefaultEnvironmentReferenceArgs', 'ProjectDefaultEnvironmentReferenceArgsDict']]] = None,
            default_subnet_reference: Optional[pulumi.Input[Union['ProjectDefaultSubnetReferenceArgs', 'ProjectDefaultSubnetReferenceArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enable_collab: Optional[pulumi.Input[_builtins.bool]] = None,
            environment_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectEnvironmentReferenceListArgs', 'ProjectEnvironmentReferenceListArgsDict']]]]] = None,
            external_network_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectExternalNetworkListArgs', 'ProjectExternalNetworkListArgsDict']]]]] = None,
            external_user_group_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectExternalUserGroupReferenceListArgs', 'ProjectExternalUserGroupReferenceListArgsDict']]]]] = None,
            is_default: Optional[pulumi.Input[_builtins.bool]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            resource_domain: Optional[pulumi.Input[Union['ProjectResourceDomainArgs', 'ProjectResourceDomainArgsDict']]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectSubnetReferenceListArgs', 'ProjectSubnetReferenceListArgsDict']]]]] = None,
            tunnel_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectTunnelReferenceListArgs', 'ProjectTunnelReferenceListArgsDict']]]]] = None,
            use_project_internal: Optional[pulumi.Input[_builtins.bool]] = None,
            user_group_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectUserGroupListArgs', 'ProjectUserGroupListArgsDict']]]]] = None,
            user_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectUserListArgs', 'ProjectUserListArgsDict']]]]] = None,
            user_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectUserReferenceListArgs', 'ProjectUserReferenceListArgsDict']]]]] = None,
            vpc_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectVpcReferenceListArgs', 'ProjectVpcReferenceListArgsDict']]]]] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectCategoryArgs', 'ProjectCategoryArgsDict']]]] categories: - (Optional) The category values represented as a dictionary of key > list of values.
        :param pulumi.Input[_builtins.str] cluster_uuid: The UUID of cluster. (Required when using project_internal flag).
        :param pulumi.Input[_builtins.str] description: A description for project.
        :param pulumi.Input[_builtins.bool] enable_collab: flag to allow collaboration of projects. (Use with project_internal flag)
        :param pulumi.Input[_builtins.str] name: The name for the project.
        :param pulumi.Input[_builtins.bool] use_project_internal: flag to use project internal for user role mapping
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectUserReferenceListArgs', 'ProjectUserReferenceListArgsDict']]]] user_reference_lists: List of Reference of users.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectState.__new__(_ProjectState)

        __props__.__dict__["account_reference_lists"] = account_reference_lists
        __props__.__dict__["acps"] = acps
        __props__.__dict__["api_version"] = api_version
        __props__.__dict__["categories"] = categories
        __props__.__dict__["cluster_reference_lists"] = cluster_reference_lists
        __props__.__dict__["cluster_uuid"] = cluster_uuid
        __props__.__dict__["default_environment_reference"] = default_environment_reference
        __props__.__dict__["default_subnet_reference"] = default_subnet_reference
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_collab"] = enable_collab
        __props__.__dict__["environment_reference_lists"] = environment_reference_lists
        __props__.__dict__["external_network_lists"] = external_network_lists
        __props__.__dict__["external_user_group_reference_lists"] = external_user_group_reference_lists
        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["owner_reference"] = owner_reference
        __props__.__dict__["project_reference"] = project_reference
        __props__.__dict__["resource_domain"] = resource_domain
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet_reference_lists"] = subnet_reference_lists
        __props__.__dict__["tunnel_reference_lists"] = tunnel_reference_lists
        __props__.__dict__["use_project_internal"] = use_project_internal
        __props__.__dict__["user_group_lists"] = user_group_lists
        __props__.__dict__["user_lists"] = user_lists
        __props__.__dict__["user_reference_lists"] = user_reference_lists
        __props__.__dict__["vpc_reference_lists"] = vpc_reference_lists
        return Project(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountReferenceLists")
    def account_reference_lists(self) -> pulumi.Output[Sequence['outputs.ProjectAccountReferenceList']]:
        return pulumi.get(self, "account_reference_lists")

    @_builtins.property
    @pulumi.getter
    def acps(self) -> pulumi.Output[Optional[Sequence['outputs.ProjectAcp']]]:
        return pulumi.get(self, "acps")

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> pulumi.Output[Sequence['outputs.ProjectCategory']]:
        """
        - (Optional) The category values represented as a dictionary of key > list of values.
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter(name="clusterReferenceLists")
    def cluster_reference_lists(self) -> pulumi.Output[Sequence['outputs.ProjectClusterReferenceList']]:
        return pulumi.get(self, "cluster_reference_lists")

    @_builtins.property
    @pulumi.getter(name="clusterUuid")
    def cluster_uuid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The UUID of cluster. (Required when using project_internal flag).
        """
        return pulumi.get(self, "cluster_uuid")

    @_builtins.property
    @pulumi.getter(name="defaultEnvironmentReference")
    def default_environment_reference(self) -> pulumi.Output['outputs.ProjectDefaultEnvironmentReference']:
        return pulumi.get(self, "default_environment_reference")

    @_builtins.property
    @pulumi.getter(name="defaultSubnetReference")
    def default_subnet_reference(self) -> pulumi.Output['outputs.ProjectDefaultSubnetReference']:
        return pulumi.get(self, "default_subnet_reference")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        A description for project.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enableCollab")
    def enable_collab(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        flag to allow collaboration of projects. (Use with project_internal flag)
        """
        return pulumi.get(self, "enable_collab")

    @_builtins.property
    @pulumi.getter(name="environmentReferenceLists")
    def environment_reference_lists(self) -> pulumi.Output[Sequence['outputs.ProjectEnvironmentReferenceList']]:
        return pulumi.get(self, "environment_reference_lists")

    @_builtins.property
    @pulumi.getter(name="externalNetworkLists")
    def external_network_lists(self) -> pulumi.Output[Sequence['outputs.ProjectExternalNetworkList']]:
        return pulumi.get(self, "external_network_lists")

    @_builtins.property
    @pulumi.getter(name="externalUserGroupReferenceLists")
    def external_user_group_reference_lists(self) -> pulumi.Output[Sequence['outputs.ProjectExternalUserGroupReferenceList']]:
        return pulumi.get(self, "external_user_group_reference_lists")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name for the project.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "owner_reference")

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "project_reference")

    @_builtins.property
    @pulumi.getter(name="resourceDomain")
    def resource_domain(self) -> pulumi.Output[Optional['outputs.ProjectResourceDomain']]:
        return pulumi.get(self, "resource_domain")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subnetReferenceLists")
    def subnet_reference_lists(self) -> pulumi.Output[Sequence['outputs.ProjectSubnetReferenceList']]:
        return pulumi.get(self, "subnet_reference_lists")

    @_builtins.property
    @pulumi.getter(name="tunnelReferenceLists")
    def tunnel_reference_lists(self) -> pulumi.Output[Sequence['outputs.ProjectTunnelReferenceList']]:
        return pulumi.get(self, "tunnel_reference_lists")

    @_builtins.property
    @pulumi.getter(name="useProjectInternal")
    def use_project_internal(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        flag to use project internal for user role mapping
        """
        return pulumi.get(self, "use_project_internal")

    @_builtins.property
    @pulumi.getter(name="userGroupLists")
    def user_group_lists(self) -> pulumi.Output[Optional[Sequence['outputs.ProjectUserGroupList']]]:
        return pulumi.get(self, "user_group_lists")

    @_builtins.property
    @pulumi.getter(name="userLists")
    def user_lists(self) -> pulumi.Output[Optional[Sequence['outputs.ProjectUserList']]]:
        return pulumi.get(self, "user_lists")

    @_builtins.property
    @pulumi.getter(name="userReferenceLists")
    def user_reference_lists(self) -> pulumi.Output[Sequence['outputs.ProjectUserReferenceList']]:
        """
        List of Reference of users.
        """
        return pulumi.get(self, "user_reference_lists")

    @_builtins.property
    @pulumi.getter(name="vpcReferenceLists")
    def vpc_reference_lists(self) -> pulumi.Output[Sequence['outputs.ProjectVpcReferenceList']]:
        return pulumi.get(self, "vpc_reference_lists")

