# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PromoteProtectedResourceV2Args', 'PromoteProtectedResourceV2']

@pulumi.input_type
class PromoteProtectedResourceV2Args:
    def __init__(__self__, *,
                 ext_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a PromoteProtectedResourceV2 resource.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) The external identifier of a protected VM or volume group that can be used to retrieve the protected resource.
               
               
               See detailed information in [Nutanix Promote Protected Resource v4](https://developers.nutanix.com/api-reference?namespace=dataprotection&version=v4.0#tag/ProtectedResources/operation/promoteProtectedResource).
        """
        pulumi.set(__self__, "ext_id", ext_id)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) The external identifier of a protected VM or volume group that can be used to retrieve the protected resource.


        See detailed information in [Nutanix Promote Protected Resource v4](https://developers.nutanix.com/api-reference?namespace=dataprotection&version=v4.0#tag/ProtectedResources/operation/promoteProtectedResource).
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ext_id", value)


@pulumi.input_type
class _PromoteProtectedResourceV2State:
    def __init__(__self__, *,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PromoteProtectedResourceV2 resources.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) The external identifier of a protected VM or volume group that can be used to retrieve the protected resource.
               
               
               See detailed information in [Nutanix Promote Protected Resource v4](https://developers.nutanix.com/api-reference?namespace=dataprotection&version=v4.0#tag/ProtectedResources/operation/promoteProtectedResource).
        """
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) The external identifier of a protected VM or volume group that can be used to retrieve the protected resource.


        See detailed information in [Nutanix Promote Protected Resource v4](https://developers.nutanix.com/api-reference?namespace=dataprotection&version=v4.0#tag/ProtectedResources/operation/promoteProtectedResource).
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)


@pulumi.type_token("nutanix:index/promoteProtectedResourceV2:PromoteProtectedResourceV2")
class PromoteProtectedResourceV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Promotes the specified synced entity at the target site. This is only relevant if the synced entity is protected in a synchronous schedule.

        ## Example:

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # create a category and a protection policy on the local site
        # promote the protected virtual machine on the remote site
        promote_example = nutanix.PromoteProtectedResourceV2("promote-example", ext_id="d22529bb-f02d-4710-894b-d1de772d7832")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) The external identifier of a protected VM or volume group that can be used to retrieve the protected resource.
               
               
               See detailed information in [Nutanix Promote Protected Resource v4](https://developers.nutanix.com/api-reference?namespace=dataprotection&version=v4.0#tag/ProtectedResources/operation/promoteProtectedResource).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PromoteProtectedResourceV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Promotes the specified synced entity at the target site. This is only relevant if the synced entity is protected in a synchronous schedule.

        ## Example:

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # create a category and a protection policy on the local site
        # promote the protected virtual machine on the remote site
        promote_example = nutanix.PromoteProtectedResourceV2("promote-example", ext_id="d22529bb-f02d-4710-894b-d1de772d7832")
        ```

        :param str resource_name: The name of the resource.
        :param PromoteProtectedResourceV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PromoteProtectedResourceV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PromoteProtectedResourceV2Args.__new__(PromoteProtectedResourceV2Args)

            if ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'ext_id'")
            __props__.__dict__["ext_id"] = ext_id
        super(PromoteProtectedResourceV2, __self__).__init__(
            'nutanix:index/promoteProtectedResourceV2:PromoteProtectedResourceV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'PromoteProtectedResourceV2':
        """
        Get an existing PromoteProtectedResourceV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) The external identifier of a protected VM or volume group that can be used to retrieve the protected resource.
               
               
               See detailed information in [Nutanix Promote Protected Resource v4](https://developers.nutanix.com/api-reference?namespace=dataprotection&version=v4.0#tag/ProtectedResources/operation/promoteProtectedResource).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PromoteProtectedResourceV2State.__new__(_PromoteProtectedResourceV2State)

        __props__.__dict__["ext_id"] = ext_id
        return PromoteProtectedResourceV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) The external identifier of a protected VM or volume group that can be used to retrieve the protected resource.


        See detailed information in [Nutanix Promote Protected Resource v4](https://developers.nutanix.com/api-reference?namespace=dataprotection&version=v4.0#tag/ProtectedResources/operation/promoteProtectedResource).
        """
        return pulumi.get(self, "ext_id")

