# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProtectionPolicyV2Args', 'ProtectionPolicyV2']

@pulumi.input_type
class ProtectionPolicyV2Args:
    def __init__(__self__, *,
                 category_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 replication_configurations: pulumi.Input[Sequence[pulumi.Input['ProtectionPolicyV2ReplicationConfigurationArgs']]],
                 replication_locations: pulumi.Input[Sequence[pulumi.Input['ProtectionPolicyV2ReplicationLocationArgs']]],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ProtectionPolicyV2 resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] category_ids: -(Optional) Host entity with its attributes.
        :param pulumi.Input[Sequence[pulumi.Input['ProtectionPolicyV2ReplicationConfigurationArgs']]] replication_configurations: -(Required) Cluster reference for an entity.
        :param pulumi.Input[Sequence[pulumi.Input['ProtectionPolicyV2ReplicationLocationArgs']]] replication_locations: -(Required) Hypervisor details.
        :param pulumi.Input[_builtins.str] description: -(Optional) Description of the protection policy.
        :param pulumi.Input[_builtins.str] name: -(Required) Name of the protection policy.
        """
        pulumi.set(__self__, "category_ids", category_ids)
        pulumi.set(__self__, "replication_configurations", replication_configurations)
        pulumi.set(__self__, "replication_locations", replication_locations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="categoryIds")
    def category_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        -(Optional) Host entity with its attributes.
        """
        return pulumi.get(self, "category_ids")

    @category_ids.setter
    def category_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "category_ids", value)

    @_builtins.property
    @pulumi.getter(name="replicationConfigurations")
    def replication_configurations(self) -> pulumi.Input[Sequence[pulumi.Input['ProtectionPolicyV2ReplicationConfigurationArgs']]]:
        """
        -(Required) Cluster reference for an entity.
        """
        return pulumi.get(self, "replication_configurations")

    @replication_configurations.setter
    def replication_configurations(self, value: pulumi.Input[Sequence[pulumi.Input['ProtectionPolicyV2ReplicationConfigurationArgs']]]):
        pulumi.set(self, "replication_configurations", value)

    @_builtins.property
    @pulumi.getter(name="replicationLocations")
    def replication_locations(self) -> pulumi.Input[Sequence[pulumi.Input['ProtectionPolicyV2ReplicationLocationArgs']]]:
        """
        -(Required) Hypervisor details.
        """
        return pulumi.get(self, "replication_locations")

    @replication_locations.setter
    def replication_locations(self, value: pulumi.Input[Sequence[pulumi.Input['ProtectionPolicyV2ReplicationLocationArgs']]]):
        pulumi.set(self, "replication_locations", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Description of the protection policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) Name of the protection policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ProtectionPolicyV2State:
    def __init__(__self__, *,
                 category_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_approval_policy_needed: Optional[pulumi.Input[_builtins.bool]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input['ProtectionPolicyV2LinkArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ProtectionPolicyV2ReplicationConfigurationArgs']]]] = None,
                 replication_locations: Optional[pulumi.Input[Sequence[pulumi.Input['ProtectionPolicyV2ReplicationLocationArgs']]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProtectionPolicyV2 resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] category_ids: -(Optional) Host entity with its attributes.
        :param pulumi.Input[_builtins.str] description: -(Optional) Description of the protection policy.
        :param pulumi.Input[_builtins.str] name: -(Required) Name of the protection policy.
        :param pulumi.Input[Sequence[pulumi.Input['ProtectionPolicyV2ReplicationConfigurationArgs']]] replication_configurations: -(Required) Cluster reference for an entity.
        :param pulumi.Input[Sequence[pulumi.Input['ProtectionPolicyV2ReplicationLocationArgs']]] replication_locations: -(Required) Hypervisor details.
        """
        if category_ids is not None:
            pulumi.set(__self__, "category_ids", category_ids)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if is_approval_policy_needed is not None:
            pulumi.set(__self__, "is_approval_policy_needed", is_approval_policy_needed)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_ext_id is not None:
            pulumi.set(__self__, "owner_ext_id", owner_ext_id)
        if replication_configurations is not None:
            pulumi.set(__self__, "replication_configurations", replication_configurations)
        if replication_locations is not None:
            pulumi.set(__self__, "replication_locations", replication_locations)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="categoryIds")
    def category_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        -(Optional) Host entity with its attributes.
        """
        return pulumi.get(self, "category_ids")

    @category_ids.setter
    def category_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "category_ids", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Description of the protection policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="isApprovalPolicyNeeded")
    def is_approval_policy_needed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "is_approval_policy_needed")

    @is_approval_policy_needed.setter
    def is_approval_policy_needed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_approval_policy_needed", value)

    @_builtins.property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProtectionPolicyV2LinkArgs']]]]:
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProtectionPolicyV2LinkArgs']]]]):
        pulumi.set(self, "links", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) Name of the protection policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownerExtId")
    def owner_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "owner_ext_id")

    @owner_ext_id.setter
    def owner_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="replicationConfigurations")
    def replication_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProtectionPolicyV2ReplicationConfigurationArgs']]]]:
        """
        -(Required) Cluster reference for an entity.
        """
        return pulumi.get(self, "replication_configurations")

    @replication_configurations.setter
    def replication_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProtectionPolicyV2ReplicationConfigurationArgs']]]]):
        pulumi.set(self, "replication_configurations", value)

    @_builtins.property
    @pulumi.getter(name="replicationLocations")
    def replication_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProtectionPolicyV2ReplicationLocationArgs']]]]:
        """
        -(Required) Hypervisor details.
        """
        return pulumi.get(self, "replication_locations")

    @replication_locations.setter
    def replication_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProtectionPolicyV2ReplicationLocationArgs']]]]):
        pulumi.set(self, "replication_locations", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.type_token("nutanix:index/protectionPolicyV2:ProtectionPolicyV2")
class ProtectionPolicyV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProtectionPolicyV2ReplicationConfigurationArgs', 'ProtectionPolicyV2ReplicationConfigurationArgsDict']]]]] = None,
                 replication_locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProtectionPolicyV2ReplicationLocationArgs', 'ProtectionPolicyV2ReplicationLocationArgsDict']]]]] = None,
                 __props__=None):
        """
        Creates a protection policy to automate the recovery point creation and replication process.

        ## Example—Synchronous Protection Policy

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        synchronous_protection_policy = nutanix.ProtectionPolicyV2("synchronous-protection-policy",
            name="synchronous_protection_policy",
            replication_configurations=[
                {
                    "source_location_label": "source",
                    "remote_location_label": "target",
                    "schedule": {
                        "recovery_point_objective_time_seconds": 0,
                        "recovery_point_type": "CRASH_CONSISTENT",
                        "sync_replication_auto_suspend_timeout_seconds": 10,
                    },
                },
                {
                    "source_location_label": "target",
                    "remote_location_label": "source",
                    "schedule": {
                        "recovery_point_objective_time_seconds": 0,
                        "recovery_point_type": "CRASH_CONSISTENT",
                        "sync_replication_auto_suspend_timeout_seconds": 10,
                    },
                },
            ],
            replication_locations=[
                {
                    "domain_manager_ext_id": "6a44b05e-cb9b-4e7e-8d75-b1b4715369c4",
                    "label": "source",
                    "is_primary": True,
                },
                {
                    "domain_manager_ext_id": "75dde184-3a0e-4f59-a185-03ca1efead17",
                    "label": "target",
                    "is_primary": False,
                },
            ],
            category_ids=["b08ed184-6b0c-42c1-8179-7b9026fe2676"])
        ```

        ## Example—Linear Retention Protection Policy

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        linear_retention_protection_policy = nutanix.ProtectionPolicyV2("linear-retention-protection-policy",
            name="linear-retention-protection-policy",
            replication_configurations=[
                {
                    "source_location_label": "source",
                    "remote_location_label": "target",
                    "schedule": {
                        "recovery_point_objective_time_seconds": 7200,
                        "recovery_point_type": "CRASH_CONSISTENT",
                        "retention": {
                            "linear_retention": {
                                "local": 1,
                                "remote": 1,
                            },
                        },
                    },
                },
                {
                    "source_location_label": "target",
                    "remote_location_label": "source",
                    "schedule": {
                        "recovery_point_objective_time_seconds": 7200,
                        "recovery_point_type": "CRASH_CONSISTENT",
                        "retention": {
                            "linear_retention": {
                                "local": 1,
                                "remote": 1,
                            },
                        },
                    },
                },
            ],
            replication_locations=[
                {
                    "domain_manager_ext_id": "6a44b05e-cb9b-4e7e-8d75-b1b4715369c4",
                    "label": "source",
                    "is_primary": True,
                    "replication_sub_location": {
                        "cluster_ext_ids": {
                            "cluster_ext_ids": [cluster_ext_id],
                        },
                    },
                },
                {
                    "domain_manager_ext_id": "75dde184-3a0e-4f59-a185-03ca1efead17",
                    "label": "target",
                    "is_primary": False,
                },
            ],
            category_ids=["b08ed184-6b0c-42c1-8179-7b9026fe2676"])
        ```

        ## Example—Auto Rollup Retention Protection Policy

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # Create Auto Rollup Retention Protection Policy
        auto_rollup_retention_protection_policy = nutanix.ProtectionPolicyV2("auto-rollup-retention-protection-policy",
            name="auto_rollup_retention_protection_policy",
            replication_configurations=[
                {
                    "source_location_label": "source",
                    "remote_location_label": "target",
                    "schedule": {
                        "recovery_point_objective_time_seconds": 60,
                        "recovery_point_type": "CRASH_CONSISTENT",
                        "sync_replication_auto_suspend_timeout_seconds": 20,
                        "start_time": "18h:10m",
                        "retention": {
                            "auto_rollup_retention": {
                                "local": {
                                    "snapshot_interval_type": "WEEKLY",
                                    "frequency": 2,
                                },
                                "remote": {
                                    "snapshot_interval_type": "DAILY",
                                    "frequency": 1,
                                },
                            },
                        },
                    },
                },
                {
                    "source_location_label": "target",
                    "remote_location_label": "source",
                    "schedule": {
                        "recovery_point_objective_time_seconds": 60,
                        "recovery_point_type": "CRASH_CONSISTENT",
                        "sync_replication_auto_suspend_timeout_seconds": 30,
                        "start_time": "18h:10m",
                        "retention": {
                            "auto_rollup_retention": {
                                "local": {
                                    "snapshot_interval_type": "DAILY",
                                    "frequency": 1,
                                },
                                "remote": {
                                    "snapshot_interval_type": "WEEKLY",
                                    "frequency": 2,
                                },
                            },
                        },
                    },
                },
            ],
            replication_locations=[
                {
                    "domain_manager_ext_id": "6a44b05e-cb9b-4e7e-8d75-b1b4715369c4",
                    "label": "source",
                    "is_primary": True,
                },
                {
                    "domain_manager_ext_id": "75dde184-3a0e-4f59-a185-03ca1efead17",
                    "label": "target",
                    "is_primary": False,
                },
            ],
            category_ids=["b08ed184-6b0c-42c1-8179-7b9026fe2676"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] category_ids: -(Optional) Host entity with its attributes.
        :param pulumi.Input[_builtins.str] description: -(Optional) Description of the protection policy.
        :param pulumi.Input[_builtins.str] name: -(Required) Name of the protection policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProtectionPolicyV2ReplicationConfigurationArgs', 'ProtectionPolicyV2ReplicationConfigurationArgsDict']]]] replication_configurations: -(Required) Cluster reference for an entity.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProtectionPolicyV2ReplicationLocationArgs', 'ProtectionPolicyV2ReplicationLocationArgsDict']]]] replication_locations: -(Required) Hypervisor details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProtectionPolicyV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a protection policy to automate the recovery point creation and replication process.

        ## Example—Synchronous Protection Policy

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        synchronous_protection_policy = nutanix.ProtectionPolicyV2("synchronous-protection-policy",
            name="synchronous_protection_policy",
            replication_configurations=[
                {
                    "source_location_label": "source",
                    "remote_location_label": "target",
                    "schedule": {
                        "recovery_point_objective_time_seconds": 0,
                        "recovery_point_type": "CRASH_CONSISTENT",
                        "sync_replication_auto_suspend_timeout_seconds": 10,
                    },
                },
                {
                    "source_location_label": "target",
                    "remote_location_label": "source",
                    "schedule": {
                        "recovery_point_objective_time_seconds": 0,
                        "recovery_point_type": "CRASH_CONSISTENT",
                        "sync_replication_auto_suspend_timeout_seconds": 10,
                    },
                },
            ],
            replication_locations=[
                {
                    "domain_manager_ext_id": "6a44b05e-cb9b-4e7e-8d75-b1b4715369c4",
                    "label": "source",
                    "is_primary": True,
                },
                {
                    "domain_manager_ext_id": "75dde184-3a0e-4f59-a185-03ca1efead17",
                    "label": "target",
                    "is_primary": False,
                },
            ],
            category_ids=["b08ed184-6b0c-42c1-8179-7b9026fe2676"])
        ```

        ## Example—Linear Retention Protection Policy

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        linear_retention_protection_policy = nutanix.ProtectionPolicyV2("linear-retention-protection-policy",
            name="linear-retention-protection-policy",
            replication_configurations=[
                {
                    "source_location_label": "source",
                    "remote_location_label": "target",
                    "schedule": {
                        "recovery_point_objective_time_seconds": 7200,
                        "recovery_point_type": "CRASH_CONSISTENT",
                        "retention": {
                            "linear_retention": {
                                "local": 1,
                                "remote": 1,
                            },
                        },
                    },
                },
                {
                    "source_location_label": "target",
                    "remote_location_label": "source",
                    "schedule": {
                        "recovery_point_objective_time_seconds": 7200,
                        "recovery_point_type": "CRASH_CONSISTENT",
                        "retention": {
                            "linear_retention": {
                                "local": 1,
                                "remote": 1,
                            },
                        },
                    },
                },
            ],
            replication_locations=[
                {
                    "domain_manager_ext_id": "6a44b05e-cb9b-4e7e-8d75-b1b4715369c4",
                    "label": "source",
                    "is_primary": True,
                    "replication_sub_location": {
                        "cluster_ext_ids": {
                            "cluster_ext_ids": [cluster_ext_id],
                        },
                    },
                },
                {
                    "domain_manager_ext_id": "75dde184-3a0e-4f59-a185-03ca1efead17",
                    "label": "target",
                    "is_primary": False,
                },
            ],
            category_ids=["b08ed184-6b0c-42c1-8179-7b9026fe2676"])
        ```

        ## Example—Auto Rollup Retention Protection Policy

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # Create Auto Rollup Retention Protection Policy
        auto_rollup_retention_protection_policy = nutanix.ProtectionPolicyV2("auto-rollup-retention-protection-policy",
            name="auto_rollup_retention_protection_policy",
            replication_configurations=[
                {
                    "source_location_label": "source",
                    "remote_location_label": "target",
                    "schedule": {
                        "recovery_point_objective_time_seconds": 60,
                        "recovery_point_type": "CRASH_CONSISTENT",
                        "sync_replication_auto_suspend_timeout_seconds": 20,
                        "start_time": "18h:10m",
                        "retention": {
                            "auto_rollup_retention": {
                                "local": {
                                    "snapshot_interval_type": "WEEKLY",
                                    "frequency": 2,
                                },
                                "remote": {
                                    "snapshot_interval_type": "DAILY",
                                    "frequency": 1,
                                },
                            },
                        },
                    },
                },
                {
                    "source_location_label": "target",
                    "remote_location_label": "source",
                    "schedule": {
                        "recovery_point_objective_time_seconds": 60,
                        "recovery_point_type": "CRASH_CONSISTENT",
                        "sync_replication_auto_suspend_timeout_seconds": 30,
                        "start_time": "18h:10m",
                        "retention": {
                            "auto_rollup_retention": {
                                "local": {
                                    "snapshot_interval_type": "DAILY",
                                    "frequency": 1,
                                },
                                "remote": {
                                    "snapshot_interval_type": "WEEKLY",
                                    "frequency": 2,
                                },
                            },
                        },
                    },
                },
            ],
            replication_locations=[
                {
                    "domain_manager_ext_id": "6a44b05e-cb9b-4e7e-8d75-b1b4715369c4",
                    "label": "source",
                    "is_primary": True,
                },
                {
                    "domain_manager_ext_id": "75dde184-3a0e-4f59-a185-03ca1efead17",
                    "label": "target",
                    "is_primary": False,
                },
            ],
            category_ids=["b08ed184-6b0c-42c1-8179-7b9026fe2676"])
        ```

        :param str resource_name: The name of the resource.
        :param ProtectionPolicyV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProtectionPolicyV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProtectionPolicyV2ReplicationConfigurationArgs', 'ProtectionPolicyV2ReplicationConfigurationArgsDict']]]]] = None,
                 replication_locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProtectionPolicyV2ReplicationLocationArgs', 'ProtectionPolicyV2ReplicationLocationArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProtectionPolicyV2Args.__new__(ProtectionPolicyV2Args)

            if category_ids is None and not opts.urn:
                raise TypeError("Missing required property 'category_ids'")
            __props__.__dict__["category_ids"] = category_ids
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if replication_configurations is None and not opts.urn:
                raise TypeError("Missing required property 'replication_configurations'")
            __props__.__dict__["replication_configurations"] = replication_configurations
            if replication_locations is None and not opts.urn:
                raise TypeError("Missing required property 'replication_locations'")
            __props__.__dict__["replication_locations"] = replication_locations
            __props__.__dict__["ext_id"] = None
            __props__.__dict__["is_approval_policy_needed"] = None
            __props__.__dict__["links"] = None
            __props__.__dict__["owner_ext_id"] = None
            __props__.__dict__["tenant_id"] = None
        super(ProtectionPolicyV2, __self__).__init__(
            'nutanix:index/protectionPolicyV2:ProtectionPolicyV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            category_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_approval_policy_needed: Optional[pulumi.Input[_builtins.bool]] = None,
            links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProtectionPolicyV2LinkArgs', 'ProtectionPolicyV2LinkArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            owner_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            replication_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProtectionPolicyV2ReplicationConfigurationArgs', 'ProtectionPolicyV2ReplicationConfigurationArgsDict']]]]] = None,
            replication_locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProtectionPolicyV2ReplicationLocationArgs', 'ProtectionPolicyV2ReplicationLocationArgsDict']]]]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ProtectionPolicyV2':
        """
        Get an existing ProtectionPolicyV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] category_ids: -(Optional) Host entity with its attributes.
        :param pulumi.Input[_builtins.str] description: -(Optional) Description of the protection policy.
        :param pulumi.Input[_builtins.str] name: -(Required) Name of the protection policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProtectionPolicyV2ReplicationConfigurationArgs', 'ProtectionPolicyV2ReplicationConfigurationArgsDict']]]] replication_configurations: -(Required) Cluster reference for an entity.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProtectionPolicyV2ReplicationLocationArgs', 'ProtectionPolicyV2ReplicationLocationArgsDict']]]] replication_locations: -(Required) Hypervisor details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProtectionPolicyV2State.__new__(_ProtectionPolicyV2State)

        __props__.__dict__["category_ids"] = category_ids
        __props__.__dict__["description"] = description
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["is_approval_policy_needed"] = is_approval_policy_needed
        __props__.__dict__["links"] = links
        __props__.__dict__["name"] = name
        __props__.__dict__["owner_ext_id"] = owner_ext_id
        __props__.__dict__["replication_configurations"] = replication_configurations
        __props__.__dict__["replication_locations"] = replication_locations
        __props__.__dict__["tenant_id"] = tenant_id
        return ProtectionPolicyV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="categoryIds")
    def category_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        -(Optional) Host entity with its attributes.
        """
        return pulumi.get(self, "category_ids")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        -(Optional) Description of the protection policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="isApprovalPolicyNeeded")
    def is_approval_policy_needed(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "is_approval_policy_needed")

    @_builtins.property
    @pulumi.getter
    def links(self) -> pulumi.Output[Sequence['outputs.ProtectionPolicyV2Link']]:
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) Name of the protection policy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownerExtId")
    def owner_ext_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "owner_ext_id")

    @_builtins.property
    @pulumi.getter(name="replicationConfigurations")
    def replication_configurations(self) -> pulumi.Output[Sequence['outputs.ProtectionPolicyV2ReplicationConfiguration']]:
        """
        -(Required) Cluster reference for an entity.
        """
        return pulumi.get(self, "replication_configurations")

    @_builtins.property
    @pulumi.getter(name="replicationLocations")
    def replication_locations(self) -> pulumi.Output[Sequence['outputs.ProtectionPolicyV2ReplicationLocation']]:
        """
        -(Required) Hypervisor details.
        """
        return pulumi.get(self, "replication_locations")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tenant_id")

