# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProtectionRuleArgs', 'ProtectionRule']

@pulumi.input_type
class ProtectionRuleArgs:
    def __init__(__self__, *,
                 availability_zone_connectivity_lists: pulumi.Input[Sequence[pulumi.Input['ProtectionRuleAvailabilityZoneConnectivityListArgs']]],
                 ordered_availability_zone_lists: pulumi.Input[Sequence[pulumi.Input['ProtectionRuleOrderedAvailabilityZoneListArgs']]],
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['ProtectionRuleCategoryArgs']]]] = None,
                 category_filter: Optional[pulumi.Input['ProtectionRuleCategoryFilterArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_reference: Optional[pulumi.Input['ProtectionRuleOwnerReferenceArgs']] = None,
                 project_reference: Optional[pulumi.Input['ProtectionRuleProjectReferenceArgs']] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ProtectionRule resource.
        :param pulumi.Input[_builtins.str] description: A description for protection rule.
        :param pulumi.Input[_builtins.str] name: The name for the protection rule.
        """
        pulumi.set(__self__, "availability_zone_connectivity_lists", availability_zone_connectivity_lists)
        pulumi.set(__self__, "ordered_availability_zone_lists", ordered_availability_zone_lists)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if category_filter is not None:
            pulumi.set(__self__, "category_filter", category_filter)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_reference is not None:
            pulumi.set(__self__, "owner_reference", owner_reference)
        if project_reference is not None:
            pulumi.set(__self__, "project_reference", project_reference)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="availabilityZoneConnectivityLists")
    def availability_zone_connectivity_lists(self) -> pulumi.Input[Sequence[pulumi.Input['ProtectionRuleAvailabilityZoneConnectivityListArgs']]]:
        return pulumi.get(self, "availability_zone_connectivity_lists")

    @availability_zone_connectivity_lists.setter
    def availability_zone_connectivity_lists(self, value: pulumi.Input[Sequence[pulumi.Input['ProtectionRuleAvailabilityZoneConnectivityListArgs']]]):
        pulumi.set(self, "availability_zone_connectivity_lists", value)

    @_builtins.property
    @pulumi.getter(name="orderedAvailabilityZoneLists")
    def ordered_availability_zone_lists(self) -> pulumi.Input[Sequence[pulumi.Input['ProtectionRuleOrderedAvailabilityZoneListArgs']]]:
        return pulumi.get(self, "ordered_availability_zone_lists")

    @ordered_availability_zone_lists.setter
    def ordered_availability_zone_lists(self, value: pulumi.Input[Sequence[pulumi.Input['ProtectionRuleOrderedAvailabilityZoneListArgs']]]):
        pulumi.set(self, "ordered_availability_zone_lists", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProtectionRuleCategoryArgs']]]]:
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProtectionRuleCategoryArgs']]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter(name="categoryFilter")
    def category_filter(self) -> Optional[pulumi.Input['ProtectionRuleCategoryFilterArgs']]:
        return pulumi.get(self, "category_filter")

    @category_filter.setter
    def category_filter(self, value: Optional[pulumi.Input['ProtectionRuleCategoryFilterArgs']]):
        pulumi.set(self, "category_filter", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for protection rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the protection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> Optional[pulumi.Input['ProtectionRuleOwnerReferenceArgs']]:
        return pulumi.get(self, "owner_reference")

    @owner_reference.setter
    def owner_reference(self, value: Optional[pulumi.Input['ProtectionRuleOwnerReferenceArgs']]):
        pulumi.set(self, "owner_reference", value)

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> Optional[pulumi.Input['ProtectionRuleProjectReferenceArgs']]:
        return pulumi.get(self, "project_reference")

    @project_reference.setter
    def project_reference(self, value: Optional[pulumi.Input['ProtectionRuleProjectReferenceArgs']]):
        pulumi.set(self, "project_reference", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class _ProtectionRuleState:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone_connectivity_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ProtectionRuleAvailabilityZoneConnectivityListArgs']]]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['ProtectionRuleCategoryArgs']]]] = None,
                 category_filter: Optional[pulumi.Input['ProtectionRuleCategoryFilterArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ordered_availability_zone_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ProtectionRuleOrderedAvailabilityZoneListArgs']]]] = None,
                 owner_reference: Optional[pulumi.Input['ProtectionRuleOwnerReferenceArgs']] = None,
                 project_reference: Optional[pulumi.Input['ProtectionRuleProjectReferenceArgs']] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProtectionRule resources.
        :param pulumi.Input[_builtins.str] description: A description for protection rule.
        :param pulumi.Input[_builtins.str] name: The name for the protection rule.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if availability_zone_connectivity_lists is not None:
            pulumi.set(__self__, "availability_zone_connectivity_lists", availability_zone_connectivity_lists)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if category_filter is not None:
            pulumi.set(__self__, "category_filter", category_filter)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ordered_availability_zone_lists is not None:
            pulumi.set(__self__, "ordered_availability_zone_lists", ordered_availability_zone_lists)
        if owner_reference is not None:
            pulumi.set(__self__, "owner_reference", owner_reference)
        if project_reference is not None:
            pulumi.set(__self__, "project_reference", project_reference)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZoneConnectivityLists")
    def availability_zone_connectivity_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProtectionRuleAvailabilityZoneConnectivityListArgs']]]]:
        return pulumi.get(self, "availability_zone_connectivity_lists")

    @availability_zone_connectivity_lists.setter
    def availability_zone_connectivity_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProtectionRuleAvailabilityZoneConnectivityListArgs']]]]):
        pulumi.set(self, "availability_zone_connectivity_lists", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProtectionRuleCategoryArgs']]]]:
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProtectionRuleCategoryArgs']]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter(name="categoryFilter")
    def category_filter(self) -> Optional[pulumi.Input['ProtectionRuleCategoryFilterArgs']]:
        return pulumi.get(self, "category_filter")

    @category_filter.setter
    def category_filter(self, value: Optional[pulumi.Input['ProtectionRuleCategoryFilterArgs']]):
        pulumi.set(self, "category_filter", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for protection rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the protection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orderedAvailabilityZoneLists")
    def ordered_availability_zone_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProtectionRuleOrderedAvailabilityZoneListArgs']]]]:
        return pulumi.get(self, "ordered_availability_zone_lists")

    @ordered_availability_zone_lists.setter
    def ordered_availability_zone_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProtectionRuleOrderedAvailabilityZoneListArgs']]]]):
        pulumi.set(self, "ordered_availability_zone_lists", value)

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> Optional[pulumi.Input['ProtectionRuleOwnerReferenceArgs']]:
        return pulumi.get(self, "owner_reference")

    @owner_reference.setter
    def owner_reference(self, value: Optional[pulumi.Input['ProtectionRuleOwnerReferenceArgs']]):
        pulumi.set(self, "owner_reference", value)

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> Optional[pulumi.Input['ProtectionRuleProjectReferenceArgs']]:
        return pulumi.get(self, "project_reference")

    @project_reference.setter
    def project_reference(self, value: Optional[pulumi.Input['ProtectionRuleProjectReferenceArgs']]):
        pulumi.set(self, "project_reference", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("nutanix:index/protectionRule:ProtectionRule")
class ProtectionRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone_connectivity_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProtectionRuleAvailabilityZoneConnectivityListArgs', 'ProtectionRuleAvailabilityZoneConnectivityListArgsDict']]]]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProtectionRuleCategoryArgs', 'ProtectionRuleCategoryArgsDict']]]]] = None,
                 category_filter: Optional[pulumi.Input[Union['ProtectionRuleCategoryFilterArgs', 'ProtectionRuleCategoryFilterArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ordered_availability_zone_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProtectionRuleOrderedAvailabilityZoneListArgs', 'ProtectionRuleOrderedAvailabilityZoneListArgsDict']]]]] = None,
                 owner_reference: Optional[pulumi.Input[Union['ProtectionRuleOwnerReferenceArgs', 'ProtectionRuleOwnerReferenceArgsDict']]] = None,
                 project_reference: Optional[pulumi.Input[Union['ProtectionRuleProjectReferenceArgs', 'ProtectionRuleProjectReferenceArgsDict']]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Nutanix Protection Rule resource to Create a Protection Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        protection_rule_test = nutanix.ProtectionRule("protection_rule_test",
            name="test",
            description="test",
            ordered_availability_zone_lists=[{
                "availability_zone_url": "ab788130-0820-4d07-a1b5-b0ba4d3a42asd",
            }],
            availability_zone_connectivity_lists=[{
                "snapshot_schedule_lists": [{
                    "recovery_point_objective_secs": 3600,
                    "snapshot_type": "CRASH_CONSISTENT",
                    "local_snapshot_retention_policy": {
                        "num_snapshots": 1,
                    },
                }],
            }],
            category_filter={
                "params": [{
                    "name": "Environment",
                    "values": ["Dev"],
                }],
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description for protection rule.
        :param pulumi.Input[_builtins.str] name: The name for the protection rule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProtectionRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Nutanix Protection Rule resource to Create a Protection Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        protection_rule_test = nutanix.ProtectionRule("protection_rule_test",
            name="test",
            description="test",
            ordered_availability_zone_lists=[{
                "availability_zone_url": "ab788130-0820-4d07-a1b5-b0ba4d3a42asd",
            }],
            availability_zone_connectivity_lists=[{
                "snapshot_schedule_lists": [{
                    "recovery_point_objective_secs": 3600,
                    "snapshot_type": "CRASH_CONSISTENT",
                    "local_snapshot_retention_policy": {
                        "num_snapshots": 1,
                    },
                }],
            }],
            category_filter={
                "params": [{
                    "name": "Environment",
                    "values": ["Dev"],
                }],
            })
        ```

        :param str resource_name: The name of the resource.
        :param ProtectionRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProtectionRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone_connectivity_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProtectionRuleAvailabilityZoneConnectivityListArgs', 'ProtectionRuleAvailabilityZoneConnectivityListArgsDict']]]]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProtectionRuleCategoryArgs', 'ProtectionRuleCategoryArgsDict']]]]] = None,
                 category_filter: Optional[pulumi.Input[Union['ProtectionRuleCategoryFilterArgs', 'ProtectionRuleCategoryFilterArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ordered_availability_zone_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProtectionRuleOrderedAvailabilityZoneListArgs', 'ProtectionRuleOrderedAvailabilityZoneListArgsDict']]]]] = None,
                 owner_reference: Optional[pulumi.Input[Union['ProtectionRuleOwnerReferenceArgs', 'ProtectionRuleOwnerReferenceArgsDict']]] = None,
                 project_reference: Optional[pulumi.Input[Union['ProtectionRuleProjectReferenceArgs', 'ProtectionRuleProjectReferenceArgsDict']]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProtectionRuleArgs.__new__(ProtectionRuleArgs)

            if availability_zone_connectivity_lists is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zone_connectivity_lists'")
            __props__.__dict__["availability_zone_connectivity_lists"] = availability_zone_connectivity_lists
            __props__.__dict__["categories"] = categories
            __props__.__dict__["category_filter"] = category_filter
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if ordered_availability_zone_lists is None and not opts.urn:
                raise TypeError("Missing required property 'ordered_availability_zone_lists'")
            __props__.__dict__["ordered_availability_zone_lists"] = ordered_availability_zone_lists
            __props__.__dict__["owner_reference"] = owner_reference
            __props__.__dict__["project_reference"] = project_reference
            __props__.__dict__["start_time"] = start_time
            __props__.__dict__["api_version"] = None
            __props__.__dict__["metadata"] = None
            __props__.__dict__["state"] = None
        super(ProtectionRule, __self__).__init__(
            'nutanix:index/protectionRule:ProtectionRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_version: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zone_connectivity_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProtectionRuleAvailabilityZoneConnectivityListArgs', 'ProtectionRuleAvailabilityZoneConnectivityListArgsDict']]]]] = None,
            categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProtectionRuleCategoryArgs', 'ProtectionRuleCategoryArgsDict']]]]] = None,
            category_filter: Optional[pulumi.Input[Union['ProtectionRuleCategoryFilterArgs', 'ProtectionRuleCategoryFilterArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ordered_availability_zone_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProtectionRuleOrderedAvailabilityZoneListArgs', 'ProtectionRuleOrderedAvailabilityZoneListArgsDict']]]]] = None,
            owner_reference: Optional[pulumi.Input[Union['ProtectionRuleOwnerReferenceArgs', 'ProtectionRuleOwnerReferenceArgsDict']]] = None,
            project_reference: Optional[pulumi.Input[Union['ProtectionRuleProjectReferenceArgs', 'ProtectionRuleProjectReferenceArgsDict']]] = None,
            start_time: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None) -> 'ProtectionRule':
        """
        Get an existing ProtectionRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description for protection rule.
        :param pulumi.Input[_builtins.str] name: The name for the protection rule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProtectionRuleState.__new__(_ProtectionRuleState)

        __props__.__dict__["api_version"] = api_version
        __props__.__dict__["availability_zone_connectivity_lists"] = availability_zone_connectivity_lists
        __props__.__dict__["categories"] = categories
        __props__.__dict__["category_filter"] = category_filter
        __props__.__dict__["description"] = description
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["ordered_availability_zone_lists"] = ordered_availability_zone_lists
        __props__.__dict__["owner_reference"] = owner_reference
        __props__.__dict__["project_reference"] = project_reference
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["state"] = state
        return ProtectionRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter(name="availabilityZoneConnectivityLists")
    def availability_zone_connectivity_lists(self) -> pulumi.Output[Sequence['outputs.ProtectionRuleAvailabilityZoneConnectivityList']]:
        return pulumi.get(self, "availability_zone_connectivity_lists")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> pulumi.Output[Sequence['outputs.ProtectionRuleCategory']]:
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter(name="categoryFilter")
    def category_filter(self) -> pulumi.Output['outputs.ProtectionRuleCategoryFilter']:
        return pulumi.get(self, "category_filter")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        A description for protection rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name for the protection rule.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orderedAvailabilityZoneLists")
    def ordered_availability_zone_lists(self) -> pulumi.Output[Sequence['outputs.ProtectionRuleOrderedAvailabilityZoneList']]:
        return pulumi.get(self, "ordered_availability_zone_lists")

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> pulumi.Output['outputs.ProtectionRuleOwnerReference']:
        return pulumi.get(self, "owner_reference")

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> pulumi.Output['outputs.ProtectionRuleProjectReference']:
        return pulumi.get(self, "project_reference")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "state")

