# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 foundation_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 foundation_port: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure: Optional[pulumi.Input[_builtins.bool]] = None,
                 ndb_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 ndb_password: Optional[pulumi.Input[_builtins.str]] = None,
                 ndb_username: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_url: Optional[pulumi.Input[_builtins.str]] = None,
                 session_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[_builtins.str] endpoint: URL for Nutanix Prism (e.g IP or FQDN for cluster VIP
               note, this is never the data services VIP, and should not be an
               individual CVM address, as this would cause calls to fail during
               cluster lifecycle management operations, such as AOS upgrades.
        :param pulumi.Input[_builtins.str] foundation_endpoint: endpoint for foundation VM (eg. Foundation VM IP)
        :param pulumi.Input[_builtins.str] foundation_port: Port for foundation VM
        :param pulumi.Input[_builtins.bool] insecure: Explicitly allow the provider to perform "insecure" SSL requests. If omitted,default value is `false`
        :param pulumi.Input[_builtins.str] ndb_endpoint: endpoint for Era VM (era ip)
        :param pulumi.Input[_builtins.str] password: Password for provided user name.
        :param pulumi.Input[_builtins.str] port: Port for Nutanix Prism.
        :param pulumi.Input[_builtins.bool] session_auth: Use session authentification instead of basic auth for each request
        :param pulumi.Input[_builtins.str] username: User name for Nutanix Prism. Could be
               local cluster auth (e.g. 'admin') or directory auth.
        :param pulumi.Input[_builtins.int] wait_timeout: Set if you know that the creation o update of a resource may take long time (minutes)
        """
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if foundation_endpoint is not None:
            pulumi.set(__self__, "foundation_endpoint", foundation_endpoint)
        if foundation_port is not None:
            pulumi.set(__self__, "foundation_port", foundation_port)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if ndb_endpoint is not None:
            pulumi.set(__self__, "ndb_endpoint", ndb_endpoint)
        if ndb_password is not None:
            pulumi.set(__self__, "ndb_password", ndb_password)
        if ndb_username is not None:
            pulumi.set(__self__, "ndb_username", ndb_username)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if proxy_url is not None:
            pulumi.set(__self__, "proxy_url", proxy_url)
        if session_auth is not None:
            pulumi.set(__self__, "session_auth", session_auth)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if wait_timeout is not None:
            pulumi.set(__self__, "wait_timeout", wait_timeout)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL for Nutanix Prism (e.g IP or FQDN for cluster VIP
        note, this is never the data services VIP, and should not be an
        individual CVM address, as this would cause calls to fail during
        cluster lifecycle management operations, such as AOS upgrades.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter(name="foundationEndpoint")
    def foundation_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        endpoint for foundation VM (eg. Foundation VM IP)
        """
        return pulumi.get(self, "foundation_endpoint")

    @foundation_endpoint.setter
    def foundation_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "foundation_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="foundationPort")
    def foundation_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Port for foundation VM
        """
        return pulumi.get(self, "foundation_port")

    @foundation_port.setter
    def foundation_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "foundation_port", value)

    @_builtins.property
    @pulumi.getter
    def insecure(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Explicitly allow the provider to perform "insecure" SSL requests. If omitted,default value is `false`
        """
        return pulumi.get(self, "insecure")

    @insecure.setter
    def insecure(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "insecure", value)

    @_builtins.property
    @pulumi.getter(name="ndbEndpoint")
    def ndb_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        endpoint for Era VM (era ip)
        """
        return pulumi.get(self, "ndb_endpoint")

    @ndb_endpoint.setter
    def ndb_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ndb_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="ndbPassword")
    def ndb_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ndb_password")

    @ndb_password.setter
    def ndb_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ndb_password", value)

    @_builtins.property
    @pulumi.getter(name="ndbUsername")
    def ndb_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ndb_username")

    @ndb_username.setter
    def ndb_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ndb_username", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password for provided user name.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Port for Nutanix Prism.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="proxyUrl")
    def proxy_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "proxy_url")

    @proxy_url.setter
    def proxy_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_url", value)

    @_builtins.property
    @pulumi.getter(name="sessionAuth")
    def session_auth(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use session authentification instead of basic auth for each request
        """
        return pulumi.get(self, "session_auth")

    @session_auth.setter
    def session_auth(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "session_auth", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User name for Nutanix Prism. Could be
        local cluster auth (e.g. 'admin') or directory auth.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter(name="waitTimeout")
    def wait_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set if you know that the creation o update of a resource may take long time (minutes)
        """
        return pulumi.get(self, "wait_timeout")

    @wait_timeout.setter
    def wait_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "wait_timeout", value)


@pulumi.type_token("pulumi:providers:nutanix")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 foundation_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 foundation_port: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure: Optional[pulumi.Input[_builtins.bool]] = None,
                 ndb_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 ndb_password: Optional[pulumi.Input[_builtins.str]] = None,
                 ndb_username: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_url: Optional[pulumi.Input[_builtins.str]] = None,
                 session_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        The provider type for the nutanix package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] endpoint: URL for Nutanix Prism (e.g IP or FQDN for cluster VIP
               note, this is never the data services VIP, and should not be an
               individual CVM address, as this would cause calls to fail during
               cluster lifecycle management operations, such as AOS upgrades.
        :param pulumi.Input[_builtins.str] foundation_endpoint: endpoint for foundation VM (eg. Foundation VM IP)
        :param pulumi.Input[_builtins.str] foundation_port: Port for foundation VM
        :param pulumi.Input[_builtins.bool] insecure: Explicitly allow the provider to perform "insecure" SSL requests. If omitted,default value is `false`
        :param pulumi.Input[_builtins.str] ndb_endpoint: endpoint for Era VM (era ip)
        :param pulumi.Input[_builtins.str] password: Password for provided user name.
        :param pulumi.Input[_builtins.str] port: Port for Nutanix Prism.
        :param pulumi.Input[_builtins.bool] session_auth: Use session authentification instead of basic auth for each request
        :param pulumi.Input[_builtins.str] username: User name for Nutanix Prism. Could be
               local cluster auth (e.g. 'admin') or directory auth.
        :param pulumi.Input[_builtins.int] wait_timeout: Set if you know that the creation o update of a resource may take long time (minutes)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the nutanix package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 foundation_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 foundation_port: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure: Optional[pulumi.Input[_builtins.bool]] = None,
                 ndb_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 ndb_password: Optional[pulumi.Input[_builtins.str]] = None,
                 ndb_username: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_url: Optional[pulumi.Input[_builtins.str]] = None,
                 session_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["endpoint"] = endpoint
            __props__.__dict__["foundation_endpoint"] = foundation_endpoint
            __props__.__dict__["foundation_port"] = foundation_port
            __props__.__dict__["insecure"] = pulumi.Output.from_input(insecure).apply(pulumi.runtime.to_json) if insecure is not None else None
            __props__.__dict__["ndb_endpoint"] = ndb_endpoint
            __props__.__dict__["ndb_password"] = ndb_password
            __props__.__dict__["ndb_username"] = ndb_username
            __props__.__dict__["password"] = password
            __props__.__dict__["port"] = port
            __props__.__dict__["proxy_url"] = proxy_url
            __props__.__dict__["session_auth"] = pulumi.Output.from_input(session_auth).apply(pulumi.runtime.to_json) if session_auth is not None else None
            __props__.__dict__["username"] = username
            __props__.__dict__["wait_timeout"] = pulumi.Output.from_input(wait_timeout).apply(pulumi.runtime.to_json) if wait_timeout is not None else None
        super(Provider, __self__).__init__(
            'nutanix',
            resource_name,
            __props__,
            opts)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        URL for Nutanix Prism (e.g IP or FQDN for cluster VIP
        note, this is never the data services VIP, and should not be an
        individual CVM address, as this would cause calls to fail during
        cluster lifecycle management operations, such as AOS upgrades.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="foundationEndpoint")
    def foundation_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        endpoint for foundation VM (eg. Foundation VM IP)
        """
        return pulumi.get(self, "foundation_endpoint")

    @_builtins.property
    @pulumi.getter(name="foundationPort")
    def foundation_port(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Port for foundation VM
        """
        return pulumi.get(self, "foundation_port")

    @_builtins.property
    @pulumi.getter(name="ndbEndpoint")
    def ndb_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        endpoint for Era VM (era ip)
        """
        return pulumi.get(self, "ndb_endpoint")

    @_builtins.property
    @pulumi.getter(name="ndbPassword")
    def ndb_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "ndb_password")

    @_builtins.property
    @pulumi.getter(name="ndbUsername")
    def ndb_username(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "ndb_username")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Password for provided user name.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Port for Nutanix Prism.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="proxyUrl")
    def proxy_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "proxy_url")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User name for Nutanix Prism. Could be
        local cluster auth (e.g. 'admin') or directory auth.
        """
        return pulumi.get(self, "username")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @_builtins.property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:nutanix/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

