# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RecoveryPlanArgs', 'RecoveryPlan']

@pulumi.input_type
class RecoveryPlanArgs:
    def __init__(__self__, *,
                 parameters: pulumi.Input['RecoveryPlanParametersArgs'],
                 stage_lists: pulumi.Input[Sequence[pulumi.Input['RecoveryPlanStageListArgs']]],
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPlanCategoryArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_reference: Optional[pulumi.Input['RecoveryPlanOwnerReferenceArgs']] = None,
                 project_reference: Optional[pulumi.Input['RecoveryPlanProjectReferenceArgs']] = None):
        """
        The set of arguments for constructing a RecoveryPlan resource.
        :param pulumi.Input[_builtins.str] description: A description for Recovery Plan.
        :param pulumi.Input[_builtins.str] name: The name for the Recovery Plan.
        """
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "stage_lists", stage_lists)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_reference is not None:
            pulumi.set(__self__, "owner_reference", owner_reference)
        if project_reference is not None:
            pulumi.set(__self__, "project_reference", project_reference)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Input['RecoveryPlanParametersArgs']:
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input['RecoveryPlanParametersArgs']):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="stageLists")
    def stage_lists(self) -> pulumi.Input[Sequence[pulumi.Input['RecoveryPlanStageListArgs']]]:
        return pulumi.get(self, "stage_lists")

    @stage_lists.setter
    def stage_lists(self, value: pulumi.Input[Sequence[pulumi.Input['RecoveryPlanStageListArgs']]]):
        pulumi.set(self, "stage_lists", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPlanCategoryArgs']]]]:
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPlanCategoryArgs']]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for Recovery Plan.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the Recovery Plan.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> Optional[pulumi.Input['RecoveryPlanOwnerReferenceArgs']]:
        return pulumi.get(self, "owner_reference")

    @owner_reference.setter
    def owner_reference(self, value: Optional[pulumi.Input['RecoveryPlanOwnerReferenceArgs']]):
        pulumi.set(self, "owner_reference", value)

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> Optional[pulumi.Input['RecoveryPlanProjectReferenceArgs']]:
        return pulumi.get(self, "project_reference")

    @project_reference.setter
    def project_reference(self, value: Optional[pulumi.Input['RecoveryPlanProjectReferenceArgs']]):
        pulumi.set(self, "project_reference", value)


@pulumi.input_type
class _RecoveryPlanState:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPlanCategoryArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_reference: Optional[pulumi.Input['RecoveryPlanOwnerReferenceArgs']] = None,
                 parameters: Optional[pulumi.Input['RecoveryPlanParametersArgs']] = None,
                 project_reference: Optional[pulumi.Input['RecoveryPlanProjectReferenceArgs']] = None,
                 stage_lists: Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPlanStageListArgs']]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RecoveryPlan resources.
        :param pulumi.Input[_builtins.str] description: A description for Recovery Plan.
        :param pulumi.Input[_builtins.str] name: The name for the Recovery Plan.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_reference is not None:
            pulumi.set(__self__, "owner_reference", owner_reference)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if project_reference is not None:
            pulumi.set(__self__, "project_reference", project_reference)
        if stage_lists is not None:
            pulumi.set(__self__, "stage_lists", stage_lists)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPlanCategoryArgs']]]]:
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPlanCategoryArgs']]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for Recovery Plan.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the Recovery Plan.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> Optional[pulumi.Input['RecoveryPlanOwnerReferenceArgs']]:
        return pulumi.get(self, "owner_reference")

    @owner_reference.setter
    def owner_reference(self, value: Optional[pulumi.Input['RecoveryPlanOwnerReferenceArgs']]):
        pulumi.set(self, "owner_reference", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input['RecoveryPlanParametersArgs']]:
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input['RecoveryPlanParametersArgs']]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> Optional[pulumi.Input['RecoveryPlanProjectReferenceArgs']]:
        return pulumi.get(self, "project_reference")

    @project_reference.setter
    def project_reference(self, value: Optional[pulumi.Input['RecoveryPlanProjectReferenceArgs']]):
        pulumi.set(self, "project_reference", value)

    @_builtins.property
    @pulumi.getter(name="stageLists")
    def stage_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPlanStageListArgs']]]]:
        return pulumi.get(self, "stage_lists")

    @stage_lists.setter
    def stage_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPlanStageListArgs']]]]):
        pulumi.set(self, "stage_lists", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("nutanix:index/recoveryPlan:RecoveryPlan")
class RecoveryPlan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RecoveryPlanCategoryArgs', 'RecoveryPlanCategoryArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_reference: Optional[pulumi.Input[Union['RecoveryPlanOwnerReferenceArgs', 'RecoveryPlanOwnerReferenceArgsDict']]] = None,
                 parameters: Optional[pulumi.Input[Union['RecoveryPlanParametersArgs', 'RecoveryPlanParametersArgsDict']]] = None,
                 project_reference: Optional[pulumi.Input[Union['RecoveryPlanProjectReferenceArgs', 'RecoveryPlanProjectReferenceArgsDict']]] = None,
                 stage_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RecoveryPlanStageListArgs', 'RecoveryPlanStageListArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a Nutanix Recovery Plan resource to Create a Recovery Plan.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        recovery_plan_test = nutanix.RecoveryPlan("recovery_plan_test",
            name="%s",
            description="%s",
            stage_lists=[{
                "stage_work": {
                    "recover_entities": {
                        "entity_info_lists": [{
                            "categories": [{
                                "name": "Environment",
                                "value": "Dev",
                            }],
                        }],
                    },
                },
                "stage_uuid": "ab788130-0820-4d07-a1b5-b0ba4d3a42asd",
                "delay_time_secs": 0,
            }],
            parameters={})
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description for Recovery Plan.
        :param pulumi.Input[_builtins.str] name: The name for the Recovery Plan.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RecoveryPlanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Nutanix Recovery Plan resource to Create a Recovery Plan.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        recovery_plan_test = nutanix.RecoveryPlan("recovery_plan_test",
            name="%s",
            description="%s",
            stage_lists=[{
                "stage_work": {
                    "recover_entities": {
                        "entity_info_lists": [{
                            "categories": [{
                                "name": "Environment",
                                "value": "Dev",
                            }],
                        }],
                    },
                },
                "stage_uuid": "ab788130-0820-4d07-a1b5-b0ba4d3a42asd",
                "delay_time_secs": 0,
            }],
            parameters={})
        ```

        :param str resource_name: The name of the resource.
        :param RecoveryPlanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RecoveryPlanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RecoveryPlanCategoryArgs', 'RecoveryPlanCategoryArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_reference: Optional[pulumi.Input[Union['RecoveryPlanOwnerReferenceArgs', 'RecoveryPlanOwnerReferenceArgsDict']]] = None,
                 parameters: Optional[pulumi.Input[Union['RecoveryPlanParametersArgs', 'RecoveryPlanParametersArgsDict']]] = None,
                 project_reference: Optional[pulumi.Input[Union['RecoveryPlanProjectReferenceArgs', 'RecoveryPlanProjectReferenceArgsDict']]] = None,
                 stage_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RecoveryPlanStageListArgs', 'RecoveryPlanStageListArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RecoveryPlanArgs.__new__(RecoveryPlanArgs)

            __props__.__dict__["categories"] = categories
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["owner_reference"] = owner_reference
            if parameters is None and not opts.urn:
                raise TypeError("Missing required property 'parameters'")
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["project_reference"] = project_reference
            if stage_lists is None and not opts.urn:
                raise TypeError("Missing required property 'stage_lists'")
            __props__.__dict__["stage_lists"] = stage_lists
            __props__.__dict__["api_version"] = None
            __props__.__dict__["metadata"] = None
            __props__.__dict__["state"] = None
        super(RecoveryPlan, __self__).__init__(
            'nutanix:index/recoveryPlan:RecoveryPlan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_version: Optional[pulumi.Input[_builtins.str]] = None,
            categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RecoveryPlanCategoryArgs', 'RecoveryPlanCategoryArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            owner_reference: Optional[pulumi.Input[Union['RecoveryPlanOwnerReferenceArgs', 'RecoveryPlanOwnerReferenceArgsDict']]] = None,
            parameters: Optional[pulumi.Input[Union['RecoveryPlanParametersArgs', 'RecoveryPlanParametersArgsDict']]] = None,
            project_reference: Optional[pulumi.Input[Union['RecoveryPlanProjectReferenceArgs', 'RecoveryPlanProjectReferenceArgsDict']]] = None,
            stage_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RecoveryPlanStageListArgs', 'RecoveryPlanStageListArgsDict']]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None) -> 'RecoveryPlan':
        """
        Get an existing RecoveryPlan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description for Recovery Plan.
        :param pulumi.Input[_builtins.str] name: The name for the Recovery Plan.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RecoveryPlanState.__new__(_RecoveryPlanState)

        __props__.__dict__["api_version"] = api_version
        __props__.__dict__["categories"] = categories
        __props__.__dict__["description"] = description
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["owner_reference"] = owner_reference
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["project_reference"] = project_reference
        __props__.__dict__["stage_lists"] = stage_lists
        __props__.__dict__["state"] = state
        return RecoveryPlan(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> pulumi.Output[Sequence['outputs.RecoveryPlanCategory']]:
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        A description for Recovery Plan.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name for the Recovery Plan.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> pulumi.Output['outputs.RecoveryPlanOwnerReference']:
        return pulumi.get(self, "owner_reference")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output['outputs.RecoveryPlanParameters']:
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> pulumi.Output['outputs.RecoveryPlanProjectReference']:
        return pulumi.get(self, "project_reference")

    @_builtins.property
    @pulumi.getter(name="stageLists")
    def stage_lists(self) -> pulumi.Output[Sequence['outputs.RecoveryPlanStageList']]:
        return pulumi.get(self, "stage_lists")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "state")

