# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['RecoveryPointReplicateV2Args', 'RecoveryPointReplicateV2']

@pulumi.input_type
class RecoveryPointReplicateV2Args:
    def __init__(__self__, *,
                 ext_id: pulumi.Input[_builtins.str],
                 pc_ext_id: pulumi.Input[_builtins.str],
                 cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RecoveryPointReplicateV2 resource.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) The external identifier that can be used to retrieve the recovery point using its URL.
        :param pulumi.Input[_builtins.str] pc_ext_id: -(Required) External identifier of the Prism Central.
        :param pulumi.Input[_builtins.str] cluster_ext_id: -(Required) External identifier of the cluster.
        """
        pulumi.set(__self__, "ext_id", ext_id)
        pulumi.set(__self__, "pc_ext_id", pc_ext_id)
        if cluster_ext_id is not None:
            pulumi.set(__self__, "cluster_ext_id", cluster_ext_id)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) The external identifier that can be used to retrieve the recovery point using its URL.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="pcExtId")
    def pc_ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) External identifier of the Prism Central.
        """
        return pulumi.get(self, "pc_ext_id")

    @pc_ext_id.setter
    def pc_ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pc_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterExtId")
    def cluster_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) External identifier of the cluster.
        """
        return pulumi.get(self, "cluster_ext_id")

    @cluster_ext_id.setter
    def cluster_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_ext_id", value)


@pulumi.input_type
class _RecoveryPointReplicateV2State:
    def __init__(__self__, *,
                 cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pc_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replicated_rp_ext_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RecoveryPointReplicateV2 resources.
        :param pulumi.Input[_builtins.str] cluster_ext_id: -(Required) External identifier of the cluster.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) The external identifier that can be used to retrieve the recovery point using its URL.
        :param pulumi.Input[_builtins.str] pc_ext_id: -(Required) External identifier of the Prism Central.
        :param pulumi.Input[_builtins.str] replicated_rp_ext_id: - External identifier of replicated recovery point.
        """
        if cluster_ext_id is not None:
            pulumi.set(__self__, "cluster_ext_id", cluster_ext_id)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if pc_ext_id is not None:
            pulumi.set(__self__, "pc_ext_id", pc_ext_id)
        if replicated_rp_ext_id is not None:
            pulumi.set(__self__, "replicated_rp_ext_id", replicated_rp_ext_id)

    @_builtins.property
    @pulumi.getter(name="clusterExtId")
    def cluster_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) External identifier of the cluster.
        """
        return pulumi.get(self, "cluster_ext_id")

    @cluster_ext_id.setter
    def cluster_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) The external identifier that can be used to retrieve the recovery point using its URL.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="pcExtId")
    def pc_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) External identifier of the Prism Central.
        """
        return pulumi.get(self, "pc_ext_id")

    @pc_ext_id.setter
    def pc_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pc_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="replicatedRpExtId")
    def replicated_rp_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - External identifier of replicated recovery point.
        """
        return pulumi.get(self, "replicated_rp_ext_id")

    @replicated_rp_ext_id.setter
    def replicated_rp_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replicated_rp_ext_id", value)


@pulumi.type_token("nutanix:index/recoveryPointReplicateV2:RecoveryPointReplicateV2")
class RecoveryPointReplicateV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pc_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        External identifier of the replicated recovery point can be found in the task completion details under the key

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # replicate RP
        rp_replicate = nutanix.RecoveryPointReplicateV2("rp-replicate",
            ext_id="150a7ed0-9d05-4f35-a060-16dac4c835d0",
            cluster_ext_id="1cefd0f5-6d38-4c9b-a07c-bdd2db004224",
            pc_ext_id="8a938cc5-282b-48c4-81be-de22de145d07")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_ext_id: -(Required) External identifier of the cluster.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) The external identifier that can be used to retrieve the recovery point using its URL.
        :param pulumi.Input[_builtins.str] pc_ext_id: -(Required) External identifier of the Prism Central.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RecoveryPointReplicateV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        External identifier of the replicated recovery point can be found in the task completion details under the key

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # replicate RP
        rp_replicate = nutanix.RecoveryPointReplicateV2("rp-replicate",
            ext_id="150a7ed0-9d05-4f35-a060-16dac4c835d0",
            cluster_ext_id="1cefd0f5-6d38-4c9b-a07c-bdd2db004224",
            pc_ext_id="8a938cc5-282b-48c4-81be-de22de145d07")
        ```

        :param str resource_name: The name of the resource.
        :param RecoveryPointReplicateV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RecoveryPointReplicateV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pc_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RecoveryPointReplicateV2Args.__new__(RecoveryPointReplicateV2Args)

            __props__.__dict__["cluster_ext_id"] = cluster_ext_id
            if ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'ext_id'")
            __props__.__dict__["ext_id"] = ext_id
            if pc_ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'pc_ext_id'")
            __props__.__dict__["pc_ext_id"] = pc_ext_id
            __props__.__dict__["replicated_rp_ext_id"] = None
        super(RecoveryPointReplicateV2, __self__).__init__(
            'nutanix:index/recoveryPointReplicateV2:RecoveryPointReplicateV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            pc_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            replicated_rp_ext_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'RecoveryPointReplicateV2':
        """
        Get an existing RecoveryPointReplicateV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_ext_id: -(Required) External identifier of the cluster.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) The external identifier that can be used to retrieve the recovery point using its URL.
        :param pulumi.Input[_builtins.str] pc_ext_id: -(Required) External identifier of the Prism Central.
        :param pulumi.Input[_builtins.str] replicated_rp_ext_id: - External identifier of replicated recovery point.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RecoveryPointReplicateV2State.__new__(_RecoveryPointReplicateV2State)

        __props__.__dict__["cluster_ext_id"] = cluster_ext_id
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["pc_ext_id"] = pc_ext_id
        __props__.__dict__["replicated_rp_ext_id"] = replicated_rp_ext_id
        return RecoveryPointReplicateV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterExtId")
    def cluster_ext_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        -(Required) External identifier of the cluster.
        """
        return pulumi.get(self, "cluster_ext_id")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) The external identifier that can be used to retrieve the recovery point using its URL.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="pcExtId")
    def pc_ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) External identifier of the Prism Central.
        """
        return pulumi.get(self, "pc_ext_id")

    @_builtins.property
    @pulumi.getter(name="replicatedRpExtId")
    def replicated_rp_ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        - External identifier of replicated recovery point.
        """
        return pulumi.get(self, "replicated_rp_ext_id")

