# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RecoveryPointRestoreV2Args', 'RecoveryPointRestoreV2']

@pulumi.input_type
class RecoveryPointRestoreV2Args:
    def __init__(__self__, *,
                 cluster_ext_id: pulumi.Input[_builtins.str],
                 ext_id: pulumi.Input[_builtins.str],
                 vm_recovery_point_restore_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPointRestoreV2VmRecoveryPointRestoreOverrideArgs']]]] = None,
                 volume_group_recovery_point_restore_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPointRestoreV2VolumeGroupRecoveryPointRestoreOverrideArgs']]]] = None):
        """
        The set of arguments for constructing a RecoveryPointRestoreV2 resource.
        :param pulumi.Input[_builtins.str] cluster_ext_id: -(Required) External identifier of the cluster.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) The external identifier that can be used to retrieve the recovery point using its URL.
        :param pulumi.Input[Sequence[pulumi.Input['RecoveryPointRestoreV2VmRecoveryPointRestoreOverrideArgs']]] vm_recovery_point_restore_overrides: -(Optional) List of specifications to restore a specific VM recovery point(s) that are a part of the top-level recovery point. A specific VM recovery point can be selected for restore by specifying its external identifier along with override specification (if any).
        :param pulumi.Input[Sequence[pulumi.Input['RecoveryPointRestoreV2VolumeGroupRecoveryPointRestoreOverrideArgs']]] volume_group_recovery_point_restore_overrides: -(Optional) List of specifications to restore a specific volume group recovery point(s) that are a part of the top-level recovery point. A specific volume group recovery point can be selected for restore by specifying its external identifier along with override specification (if any).
        """
        pulumi.set(__self__, "cluster_ext_id", cluster_ext_id)
        pulumi.set(__self__, "ext_id", ext_id)
        if vm_recovery_point_restore_overrides is not None:
            pulumi.set(__self__, "vm_recovery_point_restore_overrides", vm_recovery_point_restore_overrides)
        if volume_group_recovery_point_restore_overrides is not None:
            pulumi.set(__self__, "volume_group_recovery_point_restore_overrides", volume_group_recovery_point_restore_overrides)

    @_builtins.property
    @pulumi.getter(name="clusterExtId")
    def cluster_ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) External identifier of the cluster.
        """
        return pulumi.get(self, "cluster_ext_id")

    @cluster_ext_id.setter
    def cluster_ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) The external identifier that can be used to retrieve the recovery point using its URL.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="vmRecoveryPointRestoreOverrides")
    def vm_recovery_point_restore_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPointRestoreV2VmRecoveryPointRestoreOverrideArgs']]]]:
        """
        -(Optional) List of specifications to restore a specific VM recovery point(s) that are a part of the top-level recovery point. A specific VM recovery point can be selected for restore by specifying its external identifier along with override specification (if any).
        """
        return pulumi.get(self, "vm_recovery_point_restore_overrides")

    @vm_recovery_point_restore_overrides.setter
    def vm_recovery_point_restore_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPointRestoreV2VmRecoveryPointRestoreOverrideArgs']]]]):
        pulumi.set(self, "vm_recovery_point_restore_overrides", value)

    @_builtins.property
    @pulumi.getter(name="volumeGroupRecoveryPointRestoreOverrides")
    def volume_group_recovery_point_restore_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPointRestoreV2VolumeGroupRecoveryPointRestoreOverrideArgs']]]]:
        """
        -(Optional) List of specifications to restore a specific volume group recovery point(s) that are a part of the top-level recovery point. A specific volume group recovery point can be selected for restore by specifying its external identifier along with override specification (if any).
        """
        return pulumi.get(self, "volume_group_recovery_point_restore_overrides")

    @volume_group_recovery_point_restore_overrides.setter
    def volume_group_recovery_point_restore_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPointRestoreV2VolumeGroupRecoveryPointRestoreOverrideArgs']]]]):
        pulumi.set(self, "volume_group_recovery_point_restore_overrides", value)


@pulumi.input_type
class _RecoveryPointRestoreV2State:
    def __init__(__self__, *,
                 cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_ext_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vm_recovery_point_restore_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPointRestoreV2VmRecoveryPointRestoreOverrideArgs']]]] = None,
                 volume_group_ext_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 volume_group_recovery_point_restore_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPointRestoreV2VolumeGroupRecoveryPointRestoreOverrideArgs']]]] = None):
        """
        Input properties used for looking up and filtering RecoveryPointRestoreV2 resources.
        :param pulumi.Input[_builtins.str] cluster_ext_id: -(Required) External identifier of the cluster.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) The external identifier that can be used to retrieve the recovery point using its URL.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vm_ext_ids: - List of external identifiers of the created(restored) VMs.
        :param pulumi.Input[Sequence[pulumi.Input['RecoveryPointRestoreV2VmRecoveryPointRestoreOverrideArgs']]] vm_recovery_point_restore_overrides: -(Optional) List of specifications to restore a specific VM recovery point(s) that are a part of the top-level recovery point. A specific VM recovery point can be selected for restore by specifying its external identifier along with override specification (if any).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] volume_group_ext_ids: - List of external identifiers of the created(restored) volume groups.
        :param pulumi.Input[Sequence[pulumi.Input['RecoveryPointRestoreV2VolumeGroupRecoveryPointRestoreOverrideArgs']]] volume_group_recovery_point_restore_overrides: -(Optional) List of specifications to restore a specific volume group recovery point(s) that are a part of the top-level recovery point. A specific volume group recovery point can be selected for restore by specifying its external identifier along with override specification (if any).
        """
        if cluster_ext_id is not None:
            pulumi.set(__self__, "cluster_ext_id", cluster_ext_id)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if vm_ext_ids is not None:
            pulumi.set(__self__, "vm_ext_ids", vm_ext_ids)
        if vm_recovery_point_restore_overrides is not None:
            pulumi.set(__self__, "vm_recovery_point_restore_overrides", vm_recovery_point_restore_overrides)
        if volume_group_ext_ids is not None:
            pulumi.set(__self__, "volume_group_ext_ids", volume_group_ext_ids)
        if volume_group_recovery_point_restore_overrides is not None:
            pulumi.set(__self__, "volume_group_recovery_point_restore_overrides", volume_group_recovery_point_restore_overrides)

    @_builtins.property
    @pulumi.getter(name="clusterExtId")
    def cluster_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) External identifier of the cluster.
        """
        return pulumi.get(self, "cluster_ext_id")

    @cluster_ext_id.setter
    def cluster_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) The external identifier that can be used to retrieve the recovery point using its URL.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="vmExtIds")
    def vm_ext_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        - List of external identifiers of the created(restored) VMs.
        """
        return pulumi.get(self, "vm_ext_ids")

    @vm_ext_ids.setter
    def vm_ext_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vm_ext_ids", value)

    @_builtins.property
    @pulumi.getter(name="vmRecoveryPointRestoreOverrides")
    def vm_recovery_point_restore_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPointRestoreV2VmRecoveryPointRestoreOverrideArgs']]]]:
        """
        -(Optional) List of specifications to restore a specific VM recovery point(s) that are a part of the top-level recovery point. A specific VM recovery point can be selected for restore by specifying its external identifier along with override specification (if any).
        """
        return pulumi.get(self, "vm_recovery_point_restore_overrides")

    @vm_recovery_point_restore_overrides.setter
    def vm_recovery_point_restore_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPointRestoreV2VmRecoveryPointRestoreOverrideArgs']]]]):
        pulumi.set(self, "vm_recovery_point_restore_overrides", value)

    @_builtins.property
    @pulumi.getter(name="volumeGroupExtIds")
    def volume_group_ext_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        - List of external identifiers of the created(restored) volume groups.
        """
        return pulumi.get(self, "volume_group_ext_ids")

    @volume_group_ext_ids.setter
    def volume_group_ext_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "volume_group_ext_ids", value)

    @_builtins.property
    @pulumi.getter(name="volumeGroupRecoveryPointRestoreOverrides")
    def volume_group_recovery_point_restore_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPointRestoreV2VolumeGroupRecoveryPointRestoreOverrideArgs']]]]:
        """
        -(Optional) List of specifications to restore a specific volume group recovery point(s) that are a part of the top-level recovery point. A specific volume group recovery point can be selected for restore by specifying its external identifier along with override specification (if any).
        """
        return pulumi.get(self, "volume_group_recovery_point_restore_overrides")

    @volume_group_recovery_point_restore_overrides.setter
    def volume_group_recovery_point_restore_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecoveryPointRestoreV2VolumeGroupRecoveryPointRestoreOverrideArgs']]]]):
        pulumi.set(self, "volume_group_recovery_point_restore_overrides", value)


@pulumi.type_token("nutanix:index/recoveryPointRestoreV2:RecoveryPointRestoreV2")
class RecoveryPointRestoreV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_recovery_point_restore_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RecoveryPointRestoreV2VmRecoveryPointRestoreOverrideArgs', 'RecoveryPointRestoreV2VmRecoveryPointRestoreOverrideArgsDict']]]]] = None,
                 volume_group_recovery_point_restore_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RecoveryPointRestoreV2VolumeGroupRecoveryPointRestoreOverrideArgs', 'RecoveryPointRestoreV2VolumeGroupRecoveryPointRestoreOverrideArgsDict']]]]] = None,
                 __props__=None):
        """
        This operation Restore a recovery point identified by {extId}.
        A comma separated list of the created VM and volume group external identifiers can be found in the task completion details under the keys `vm_ext_ids` and `volume_group_ext_ids` respectively.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # restore RP
        rp_restore = nutanix.RecoveryPointRestoreV2("rp-restore",
            ext_id="150a7ed0-9d05-4f35-a060-16dac4c835d0",
            cluster_ext_id="1cefd0f5-6d38-4c9b-a07c-bdd2db004224",
            vm_recovery_point_restore_overrides=[{
                "vm_recovery_point_ext_id": "1cefd0f5-6d38-4c9b-a07c-bdd2db004224",
            }],
            volume_group_recovery_point_restore_overrides=[{
                "volume_group_recovery_point_ext_id": "8a938cc5-282b-48c4-81be-de22de145d07",
                "volume_group_override_specs": [{
                    "name": "vg_restored",
                }],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_ext_id: -(Required) External identifier of the cluster.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) The external identifier that can be used to retrieve the recovery point using its URL.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RecoveryPointRestoreV2VmRecoveryPointRestoreOverrideArgs', 'RecoveryPointRestoreV2VmRecoveryPointRestoreOverrideArgsDict']]]] vm_recovery_point_restore_overrides: -(Optional) List of specifications to restore a specific VM recovery point(s) that are a part of the top-level recovery point. A specific VM recovery point can be selected for restore by specifying its external identifier along with override specification (if any).
        :param pulumi.Input[Sequence[pulumi.Input[Union['RecoveryPointRestoreV2VolumeGroupRecoveryPointRestoreOverrideArgs', 'RecoveryPointRestoreV2VolumeGroupRecoveryPointRestoreOverrideArgsDict']]]] volume_group_recovery_point_restore_overrides: -(Optional) List of specifications to restore a specific volume group recovery point(s) that are a part of the top-level recovery point. A specific volume group recovery point can be selected for restore by specifying its external identifier along with override specification (if any).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RecoveryPointRestoreV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This operation Restore a recovery point identified by {extId}.
        A comma separated list of the created VM and volume group external identifiers can be found in the task completion details under the keys `vm_ext_ids` and `volume_group_ext_ids` respectively.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # restore RP
        rp_restore = nutanix.RecoveryPointRestoreV2("rp-restore",
            ext_id="150a7ed0-9d05-4f35-a060-16dac4c835d0",
            cluster_ext_id="1cefd0f5-6d38-4c9b-a07c-bdd2db004224",
            vm_recovery_point_restore_overrides=[{
                "vm_recovery_point_ext_id": "1cefd0f5-6d38-4c9b-a07c-bdd2db004224",
            }],
            volume_group_recovery_point_restore_overrides=[{
                "volume_group_recovery_point_ext_id": "8a938cc5-282b-48c4-81be-de22de145d07",
                "volume_group_override_specs": [{
                    "name": "vg_restored",
                }],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param RecoveryPointRestoreV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RecoveryPointRestoreV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_recovery_point_restore_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RecoveryPointRestoreV2VmRecoveryPointRestoreOverrideArgs', 'RecoveryPointRestoreV2VmRecoveryPointRestoreOverrideArgsDict']]]]] = None,
                 volume_group_recovery_point_restore_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RecoveryPointRestoreV2VolumeGroupRecoveryPointRestoreOverrideArgs', 'RecoveryPointRestoreV2VolumeGroupRecoveryPointRestoreOverrideArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RecoveryPointRestoreV2Args.__new__(RecoveryPointRestoreV2Args)

            if cluster_ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_ext_id'")
            __props__.__dict__["cluster_ext_id"] = cluster_ext_id
            if ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'ext_id'")
            __props__.__dict__["ext_id"] = ext_id
            __props__.__dict__["vm_recovery_point_restore_overrides"] = vm_recovery_point_restore_overrides
            __props__.__dict__["volume_group_recovery_point_restore_overrides"] = volume_group_recovery_point_restore_overrides
            __props__.__dict__["vm_ext_ids"] = None
            __props__.__dict__["volume_group_ext_ids"] = None
        super(RecoveryPointRestoreV2, __self__).__init__(
            'nutanix:index/recoveryPointRestoreV2:RecoveryPointRestoreV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            vm_ext_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            vm_recovery_point_restore_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RecoveryPointRestoreV2VmRecoveryPointRestoreOverrideArgs', 'RecoveryPointRestoreV2VmRecoveryPointRestoreOverrideArgsDict']]]]] = None,
            volume_group_ext_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            volume_group_recovery_point_restore_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RecoveryPointRestoreV2VolumeGroupRecoveryPointRestoreOverrideArgs', 'RecoveryPointRestoreV2VolumeGroupRecoveryPointRestoreOverrideArgsDict']]]]] = None) -> 'RecoveryPointRestoreV2':
        """
        Get an existing RecoveryPointRestoreV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_ext_id: -(Required) External identifier of the cluster.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) The external identifier that can be used to retrieve the recovery point using its URL.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vm_ext_ids: - List of external identifiers of the created(restored) VMs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RecoveryPointRestoreV2VmRecoveryPointRestoreOverrideArgs', 'RecoveryPointRestoreV2VmRecoveryPointRestoreOverrideArgsDict']]]] vm_recovery_point_restore_overrides: -(Optional) List of specifications to restore a specific VM recovery point(s) that are a part of the top-level recovery point. A specific VM recovery point can be selected for restore by specifying its external identifier along with override specification (if any).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] volume_group_ext_ids: - List of external identifiers of the created(restored) volume groups.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RecoveryPointRestoreV2VolumeGroupRecoveryPointRestoreOverrideArgs', 'RecoveryPointRestoreV2VolumeGroupRecoveryPointRestoreOverrideArgsDict']]]] volume_group_recovery_point_restore_overrides: -(Optional) List of specifications to restore a specific volume group recovery point(s) that are a part of the top-level recovery point. A specific volume group recovery point can be selected for restore by specifying its external identifier along with override specification (if any).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RecoveryPointRestoreV2State.__new__(_RecoveryPointRestoreV2State)

        __props__.__dict__["cluster_ext_id"] = cluster_ext_id
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["vm_ext_ids"] = vm_ext_ids
        __props__.__dict__["vm_recovery_point_restore_overrides"] = vm_recovery_point_restore_overrides
        __props__.__dict__["volume_group_ext_ids"] = volume_group_ext_ids
        __props__.__dict__["volume_group_recovery_point_restore_overrides"] = volume_group_recovery_point_restore_overrides
        return RecoveryPointRestoreV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterExtId")
    def cluster_ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) External identifier of the cluster.
        """
        return pulumi.get(self, "cluster_ext_id")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) The external identifier that can be used to retrieve the recovery point using its URL.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="vmExtIds")
    def vm_ext_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        - List of external identifiers of the created(restored) VMs.
        """
        return pulumi.get(self, "vm_ext_ids")

    @_builtins.property
    @pulumi.getter(name="vmRecoveryPointRestoreOverrides")
    def vm_recovery_point_restore_overrides(self) -> pulumi.Output[Optional[Sequence['outputs.RecoveryPointRestoreV2VmRecoveryPointRestoreOverride']]]:
        """
        -(Optional) List of specifications to restore a specific VM recovery point(s) that are a part of the top-level recovery point. A specific VM recovery point can be selected for restore by specifying its external identifier along with override specification (if any).
        """
        return pulumi.get(self, "vm_recovery_point_restore_overrides")

    @_builtins.property
    @pulumi.getter(name="volumeGroupExtIds")
    def volume_group_ext_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        - List of external identifiers of the created(restored) volume groups.
        """
        return pulumi.get(self, "volume_group_ext_ids")

    @_builtins.property
    @pulumi.getter(name="volumeGroupRecoveryPointRestoreOverrides")
    def volume_group_recovery_point_restore_overrides(self) -> pulumi.Output[Optional[Sequence['outputs.RecoveryPointRestoreV2VolumeGroupRecoveryPointRestoreOverride']]]:
        """
        -(Optional) List of specifications to restore a specific volume group recovery point(s) that are a part of the top-level recovery point. A specific volume group recovery point can be selected for restore by specifying its external identifier along with override specification (if any).
        """
        return pulumi.get(self, "volume_group_recovery_point_restore_overrides")

