# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['RestoreProtectedResourceV2Args', 'RestoreProtectedResourceV2']

@pulumi.input_type
class RestoreProtectedResourceV2Args:
    def __init__(__self__, *,
                 cluster_ext_id: pulumi.Input[_builtins.str],
                 ext_id: pulumi.Input[_builtins.str],
                 restore_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RestoreProtectedResourceV2 resource.
        :param pulumi.Input[_builtins.str] cluster_ext_id: -(Required) The external identifier of the cluster on which the entity has valid restorable time ranges. The restored entity will be created on the same cluster.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) The external identifier of a protected VM or volume group that can be used to retrieve the protected resource.
        :param pulumi.Input[_builtins.str] restore_time: -(Optional) UTC date and time in ISO 8601 format representing the time from when the state of the entity should be restored. This needs to be a valid time within the restorable time range(s) for the protected resource.
               
               
               See detailed information in [Nutanix Restore Protected Resource v4](https://developers.nutanix.com/api-reference?namespace=dataprotection&version=v4.0#tag/ProtectedResources/operation/restoreProtectedResourcen).
        """
        pulumi.set(__self__, "cluster_ext_id", cluster_ext_id)
        pulumi.set(__self__, "ext_id", ext_id)
        if restore_time is not None:
            pulumi.set(__self__, "restore_time", restore_time)

    @_builtins.property
    @pulumi.getter(name="clusterExtId")
    def cluster_ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) The external identifier of the cluster on which the entity has valid restorable time ranges. The restored entity will be created on the same cluster.
        """
        return pulumi.get(self, "cluster_ext_id")

    @cluster_ext_id.setter
    def cluster_ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) The external identifier of a protected VM or volume group that can be used to retrieve the protected resource.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="restoreTime")
    def restore_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) UTC date and time in ISO 8601 format representing the time from when the state of the entity should be restored. This needs to be a valid time within the restorable time range(s) for the protected resource.


        See detailed information in [Nutanix Restore Protected Resource v4](https://developers.nutanix.com/api-reference?namespace=dataprotection&version=v4.0#tag/ProtectedResources/operation/restoreProtectedResourcen).
        """
        return pulumi.get(self, "restore_time")

    @restore_time.setter
    def restore_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restore_time", value)


@pulumi.input_type
class _RestoreProtectedResourceV2State:
    def __init__(__self__, *,
                 cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RestoreProtectedResourceV2 resources.
        :param pulumi.Input[_builtins.str] cluster_ext_id: -(Required) The external identifier of the cluster on which the entity has valid restorable time ranges. The restored entity will be created on the same cluster.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) The external identifier of a protected VM or volume group that can be used to retrieve the protected resource.
        :param pulumi.Input[_builtins.str] restore_time: -(Optional) UTC date and time in ISO 8601 format representing the time from when the state of the entity should be restored. This needs to be a valid time within the restorable time range(s) for the protected resource.
               
               
               See detailed information in [Nutanix Restore Protected Resource v4](https://developers.nutanix.com/api-reference?namespace=dataprotection&version=v4.0#tag/ProtectedResources/operation/restoreProtectedResourcen).
        """
        if cluster_ext_id is not None:
            pulumi.set(__self__, "cluster_ext_id", cluster_ext_id)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if restore_time is not None:
            pulumi.set(__self__, "restore_time", restore_time)

    @_builtins.property
    @pulumi.getter(name="clusterExtId")
    def cluster_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) The external identifier of the cluster on which the entity has valid restorable time ranges. The restored entity will be created on the same cluster.
        """
        return pulumi.get(self, "cluster_ext_id")

    @cluster_ext_id.setter
    def cluster_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) The external identifier of a protected VM or volume group that can be used to retrieve the protected resource.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="restoreTime")
    def restore_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) UTC date and time in ISO 8601 format representing the time from when the state of the entity should be restored. This needs to be a valid time within the restorable time range(s) for the protected resource.


        See detailed information in [Nutanix Restore Protected Resource v4](https://developers.nutanix.com/api-reference?namespace=dataprotection&version=v4.0#tag/ProtectedResources/operation/restoreProtectedResourcen).
        """
        return pulumi.get(self, "restore_time")

    @restore_time.setter
    def restore_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restore_time", value)


@pulumi.type_token("nutanix:index/restoreProtectedResourceV2:RestoreProtectedResourceV2")
class RestoreProtectedResourceV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_time: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Restore the specified protected resource from its state at the given timestamp on the given cluster. This is only relevant if the entity is protected in a minutely schedule at the given timestamp.

        ## Example 1: Restore Virtual Machine

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # create a category and a protection policy on the local site
        # restore the protected virtual machine on the remote site
        rp_vm = nutanix.RestoreProtectedResourceV2("rp-vm",
            ext_id="d22529bb-f02d-4710-894b-d1de772d7832",
            cluster_ext_id="0005b6b1-1b16-4983-b5ff-204840f85e07")
        ```

        ## Example 2: Restore Volume Group

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # create a category , a protection policy and VG on the local site
        # restore the protected volume group on the remote site
        rp_vg = nutanix.RestoreProtectedResourceV2("rp-vg",
            ext_id="246c651a-1b16-4983-b5ff-204840f85e07",
            cluster_ext_id="0005b6b1-1b16-4983-b5ff-204840f85e07")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_ext_id: -(Required) The external identifier of the cluster on which the entity has valid restorable time ranges. The restored entity will be created on the same cluster.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) The external identifier of a protected VM or volume group that can be used to retrieve the protected resource.
        :param pulumi.Input[_builtins.str] restore_time: -(Optional) UTC date and time in ISO 8601 format representing the time from when the state of the entity should be restored. This needs to be a valid time within the restorable time range(s) for the protected resource.
               
               
               See detailed information in [Nutanix Restore Protected Resource v4](https://developers.nutanix.com/api-reference?namespace=dataprotection&version=v4.0#tag/ProtectedResources/operation/restoreProtectedResourcen).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RestoreProtectedResourceV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Restore the specified protected resource from its state at the given timestamp on the given cluster. This is only relevant if the entity is protected in a minutely schedule at the given timestamp.

        ## Example 1: Restore Virtual Machine

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # create a category and a protection policy on the local site
        # restore the protected virtual machine on the remote site
        rp_vm = nutanix.RestoreProtectedResourceV2("rp-vm",
            ext_id="d22529bb-f02d-4710-894b-d1de772d7832",
            cluster_ext_id="0005b6b1-1b16-4983-b5ff-204840f85e07")
        ```

        ## Example 2: Restore Volume Group

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # create a category , a protection policy and VG on the local site
        # restore the protected volume group on the remote site
        rp_vg = nutanix.RestoreProtectedResourceV2("rp-vg",
            ext_id="246c651a-1b16-4983-b5ff-204840f85e07",
            cluster_ext_id="0005b6b1-1b16-4983-b5ff-204840f85e07")
        ```

        :param str resource_name: The name of the resource.
        :param RestoreProtectedResourceV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RestoreProtectedResourceV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_time: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RestoreProtectedResourceV2Args.__new__(RestoreProtectedResourceV2Args)

            if cluster_ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_ext_id'")
            __props__.__dict__["cluster_ext_id"] = cluster_ext_id
            if ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'ext_id'")
            __props__.__dict__["ext_id"] = ext_id
            __props__.__dict__["restore_time"] = restore_time
        super(RestoreProtectedResourceV2, __self__).__init__(
            'nutanix:index/restoreProtectedResourceV2:RestoreProtectedResourceV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            restore_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'RestoreProtectedResourceV2':
        """
        Get an existing RestoreProtectedResourceV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_ext_id: -(Required) The external identifier of the cluster on which the entity has valid restorable time ranges. The restored entity will be created on the same cluster.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) The external identifier of a protected VM or volume group that can be used to retrieve the protected resource.
        :param pulumi.Input[_builtins.str] restore_time: -(Optional) UTC date and time in ISO 8601 format representing the time from when the state of the entity should be restored. This needs to be a valid time within the restorable time range(s) for the protected resource.
               
               
               See detailed information in [Nutanix Restore Protected Resource v4](https://developers.nutanix.com/api-reference?namespace=dataprotection&version=v4.0#tag/ProtectedResources/operation/restoreProtectedResourcen).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RestoreProtectedResourceV2State.__new__(_RestoreProtectedResourceV2State)

        __props__.__dict__["cluster_ext_id"] = cluster_ext_id
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["restore_time"] = restore_time
        return RestoreProtectedResourceV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterExtId")
    def cluster_ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) The external identifier of the cluster on which the entity has valid restorable time ranges. The restored entity will be created on the same cluster.
        """
        return pulumi.get(self, "cluster_ext_id")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) The external identifier of a protected VM or volume group that can be used to retrieve the protected resource.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="restoreTime")
    def restore_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        -(Optional) UTC date and time in ISO 8601 format representing the time from when the state of the entity should be restored. This needs to be a valid time within the restorable time range(s) for the protected resource.


        See detailed information in [Nutanix Restore Protected Resource v4](https://developers.nutanix.com/api-reference?namespace=dataprotection&version=v4.0#tag/ProtectedResources/operation/restoreProtectedResourcen).
        """
        return pulumi.get(self, "restore_time")

