# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RolesV2Args', 'RolesV2']

@pulumi.input_type
class RolesV2Args:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 operations: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 client_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RolesV2 resource.
        :param pulumi.Input[_builtins.str] display_name: -(Required) The display name for the Role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] operations: -(Required) List of operations for the role.
        :param pulumi.Input[_builtins.str] client_name: - Client that created the entity.
        :param pulumi.Input[_builtins.str] description: - Description of the Role.
        :param pulumi.Input[_builtins.str] ext_id: - A globally unique identifier of an instance that is suitable for external consumption.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "operations", operations)
        if client_name is not None:
            pulumi.set(__self__, "client_name", client_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) The display name for the Role.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def operations(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        -(Required) List of operations for the role.
        """
        return pulumi.get(self, "operations")

    @operations.setter
    def operations(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "operations", value)

    @_builtins.property
    @pulumi.getter(name="clientName")
    def client_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Client that created the entity.
        """
        return pulumi.get(self, "client_name")

    @client_name.setter
    def client_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Description of the Role.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)


@pulumi.input_type
class _RolesV2State:
    def __init__(__self__, *,
                 accessible_clients: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 accessible_entity_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 assigned_users_count: Optional[pulumi.Input[_builtins.int]] = None,
                 assigned_users_groups_count: Optional[pulumi.Input[_builtins.int]] = None,
                 client_name: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 created_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_system_defined: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_updated_time: Optional[pulumi.Input[_builtins.str]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input['RolesV2LinkArgs']]]] = None,
                 operations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RolesV2 resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] accessible_clients: - List of Accessible Clients for the Role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] accessible_entity_types: - List of Accessible Entity Types for the Role.
        :param pulumi.Input[_builtins.int] assigned_users_count: - Number of Users assigned to given Role.
        :param pulumi.Input[_builtins.int] assigned_users_groups_count: - Number of User Groups assigned to given Role.
        :param pulumi.Input[_builtins.str] client_name: - Client that created the entity.
        :param pulumi.Input[_builtins.str] created_by: - User or Service Name that created the Role.
        :param pulumi.Input[_builtins.str] created_time: - The creation time of the Role.
        :param pulumi.Input[_builtins.str] description: - Description of the Role.
        :param pulumi.Input[_builtins.str] display_name: -(Required) The display name for the Role.
        :param pulumi.Input[_builtins.str] ext_id: - A globally unique identifier of an instance that is suitable for external consumption.
        :param pulumi.Input[_builtins.bool] is_system_defined: - Flag identifying if the Role is system defined or not.
        :param pulumi.Input[_builtins.str] last_updated_time: - The time when the Role was last updated.
        :param pulumi.Input[Sequence[pulumi.Input['RolesV2LinkArgs']]] links: - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] operations: -(Required) List of operations for the role.
        :param pulumi.Input[_builtins.str] tenant_id: - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        """
        if accessible_clients is not None:
            pulumi.set(__self__, "accessible_clients", accessible_clients)
        if accessible_entity_types is not None:
            pulumi.set(__self__, "accessible_entity_types", accessible_entity_types)
        if assigned_users_count is not None:
            pulumi.set(__self__, "assigned_users_count", assigned_users_count)
        if assigned_users_groups_count is not None:
            pulumi.set(__self__, "assigned_users_groups_count", assigned_users_groups_count)
        if client_name is not None:
            pulumi.set(__self__, "client_name", client_name)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if is_system_defined is not None:
            pulumi.set(__self__, "is_system_defined", is_system_defined)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if operations is not None:
            pulumi.set(__self__, "operations", operations)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="accessibleClients")
    def accessible_clients(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        - List of Accessible Clients for the Role.
        """
        return pulumi.get(self, "accessible_clients")

    @accessible_clients.setter
    def accessible_clients(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "accessible_clients", value)

    @_builtins.property
    @pulumi.getter(name="accessibleEntityTypes")
    def accessible_entity_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        - List of Accessible Entity Types for the Role.
        """
        return pulumi.get(self, "accessible_entity_types")

    @accessible_entity_types.setter
    def accessible_entity_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "accessible_entity_types", value)

    @_builtins.property
    @pulumi.getter(name="assignedUsersCount")
    def assigned_users_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - Number of Users assigned to given Role.
        """
        return pulumi.get(self, "assigned_users_count")

    @assigned_users_count.setter
    def assigned_users_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "assigned_users_count", value)

    @_builtins.property
    @pulumi.getter(name="assignedUsersGroupsCount")
    def assigned_users_groups_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - Number of User Groups assigned to given Role.
        """
        return pulumi.get(self, "assigned_users_groups_count")

    @assigned_users_groups_count.setter
    def assigned_users_groups_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "assigned_users_groups_count", value)

    @_builtins.property
    @pulumi.getter(name="clientName")
    def client_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Client that created the entity.
        """
        return pulumi.get(self, "client_name")

    @client_name.setter
    def client_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_name", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - User or Service Name that created the Role.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The creation time of the Role.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Description of the Role.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) The display name for the Role.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="isSystemDefined")
    def is_system_defined(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - Flag identifying if the Role is system defined or not.
        """
        return pulumi.get(self, "is_system_defined")

    @is_system_defined.setter
    def is_system_defined(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_system_defined", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The time when the Role was last updated.
        """
        return pulumi.get(self, "last_updated_time")

    @last_updated_time.setter
    def last_updated_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated_time", value)

    @_builtins.property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RolesV2LinkArgs']]]]:
        """
        - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RolesV2LinkArgs']]]]):
        pulumi.set(self, "links", value)

    @_builtins.property
    @pulumi.getter
    def operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        -(Required) List of operations for the role.
        """
        return pulumi.get(self, "operations")

    @operations.setter
    def operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "operations", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.type_token("nutanix:index/rolesV2:RolesV2")
class RolesV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 operations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a resource to add a Role.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # filtered list operation
        operations_filtered_list = nutanix.get_operations_v2(filter="startswith(displayName, 'Create_')")
        # Create role
        example_role = nutanix.RolesV2("example-role",
            display_name="example_role",
            description="create example role",
            operations=[
                operations_filtered_list.operations[0].ext_id,
                operations_filtered_list.operations[1].ext_id,
                operations_filtered_list.operations[2].ext_id,
                operations_filtered_list.operations[3].ext_id,
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] client_name: - Client that created the entity.
        :param pulumi.Input[_builtins.str] description: - Description of the Role.
        :param pulumi.Input[_builtins.str] display_name: -(Required) The display name for the Role.
        :param pulumi.Input[_builtins.str] ext_id: - A globally unique identifier of an instance that is suitable for external consumption.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] operations: -(Required) List of operations for the role.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RolesV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to add a Role.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # filtered list operation
        operations_filtered_list = nutanix.get_operations_v2(filter="startswith(displayName, 'Create_')")
        # Create role
        example_role = nutanix.RolesV2("example-role",
            display_name="example_role",
            description="create example role",
            operations=[
                operations_filtered_list.operations[0].ext_id,
                operations_filtered_list.operations[1].ext_id,
                operations_filtered_list.operations[2].ext_id,
                operations_filtered_list.operations[3].ext_id,
            ])
        ```

        :param str resource_name: The name of the resource.
        :param RolesV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RolesV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 operations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RolesV2Args.__new__(RolesV2Args)

            __props__.__dict__["client_name"] = client_name
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["ext_id"] = ext_id
            if operations is None and not opts.urn:
                raise TypeError("Missing required property 'operations'")
            __props__.__dict__["operations"] = operations
            __props__.__dict__["accessible_clients"] = None
            __props__.__dict__["accessible_entity_types"] = None
            __props__.__dict__["assigned_users_count"] = None
            __props__.__dict__["assigned_users_groups_count"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["created_time"] = None
            __props__.__dict__["is_system_defined"] = None
            __props__.__dict__["last_updated_time"] = None
            __props__.__dict__["links"] = None
            __props__.__dict__["tenant_id"] = None
        super(RolesV2, __self__).__init__(
            'nutanix:index/rolesV2:RolesV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessible_clients: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            accessible_entity_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            assigned_users_count: Optional[pulumi.Input[_builtins.int]] = None,
            assigned_users_groups_count: Optional[pulumi.Input[_builtins.int]] = None,
            client_name: Optional[pulumi.Input[_builtins.str]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            created_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_system_defined: Optional[pulumi.Input[_builtins.bool]] = None,
            last_updated_time: Optional[pulumi.Input[_builtins.str]] = None,
            links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RolesV2LinkArgs', 'RolesV2LinkArgsDict']]]]] = None,
            operations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'RolesV2':
        """
        Get an existing RolesV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] accessible_clients: - List of Accessible Clients for the Role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] accessible_entity_types: - List of Accessible Entity Types for the Role.
        :param pulumi.Input[_builtins.int] assigned_users_count: - Number of Users assigned to given Role.
        :param pulumi.Input[_builtins.int] assigned_users_groups_count: - Number of User Groups assigned to given Role.
        :param pulumi.Input[_builtins.str] client_name: - Client that created the entity.
        :param pulumi.Input[_builtins.str] created_by: - User or Service Name that created the Role.
        :param pulumi.Input[_builtins.str] created_time: - The creation time of the Role.
        :param pulumi.Input[_builtins.str] description: - Description of the Role.
        :param pulumi.Input[_builtins.str] display_name: -(Required) The display name for the Role.
        :param pulumi.Input[_builtins.str] ext_id: - A globally unique identifier of an instance that is suitable for external consumption.
        :param pulumi.Input[_builtins.bool] is_system_defined: - Flag identifying if the Role is system defined or not.
        :param pulumi.Input[_builtins.str] last_updated_time: - The time when the Role was last updated.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RolesV2LinkArgs', 'RolesV2LinkArgsDict']]]] links: - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] operations: -(Required) List of operations for the role.
        :param pulumi.Input[_builtins.str] tenant_id: - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RolesV2State.__new__(_RolesV2State)

        __props__.__dict__["accessible_clients"] = accessible_clients
        __props__.__dict__["accessible_entity_types"] = accessible_entity_types
        __props__.__dict__["assigned_users_count"] = assigned_users_count
        __props__.__dict__["assigned_users_groups_count"] = assigned_users_groups_count
        __props__.__dict__["client_name"] = client_name
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["created_time"] = created_time
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["is_system_defined"] = is_system_defined
        __props__.__dict__["last_updated_time"] = last_updated_time
        __props__.__dict__["links"] = links
        __props__.__dict__["operations"] = operations
        __props__.__dict__["tenant_id"] = tenant_id
        return RolesV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessibleClients")
    def accessible_clients(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        - List of Accessible Clients for the Role.
        """
        return pulumi.get(self, "accessible_clients")

    @_builtins.property
    @pulumi.getter(name="accessibleEntityTypes")
    def accessible_entity_types(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        - List of Accessible Entity Types for the Role.
        """
        return pulumi.get(self, "accessible_entity_types")

    @_builtins.property
    @pulumi.getter(name="assignedUsersCount")
    def assigned_users_count(self) -> pulumi.Output[_builtins.int]:
        """
        - Number of Users assigned to given Role.
        """
        return pulumi.get(self, "assigned_users_count")

    @_builtins.property
    @pulumi.getter(name="assignedUsersGroupsCount")
    def assigned_users_groups_count(self) -> pulumi.Output[_builtins.int]:
        """
        - Number of User Groups assigned to given Role.
        """
        return pulumi.get(self, "assigned_users_groups_count")

    @_builtins.property
    @pulumi.getter(name="clientName")
    def client_name(self) -> pulumi.Output[_builtins.str]:
        """
        - Client that created the entity.
        """
        return pulumi.get(self, "client_name")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        - User or Service Name that created the Role.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[_builtins.str]:
        """
        - The creation time of the Role.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - Description of the Role.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) The display name for the Role.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        - A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="isSystemDefined")
    def is_system_defined(self) -> pulumi.Output[_builtins.bool]:
        """
        - Flag identifying if the Role is system defined or not.
        """
        return pulumi.get(self, "is_system_defined")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> pulumi.Output[_builtins.str]:
        """
        - The time when the Role was last updated.
        """
        return pulumi.get(self, "last_updated_time")

    @_builtins.property
    @pulumi.getter
    def links(self) -> pulumi.Output[Sequence['outputs.RolesV2Link']]:
        """
        - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def operations(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        -(Required) List of operations for the role.
        """
        return pulumi.get(self, "operations")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        """
        return pulumi.get(self, "tenant_id")

