# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RoutesV2Args', 'RoutesV2']

@pulumi.input_type
class RoutesV2Args:
    def __init__(__self__, *,
                 route_table_ext_id: pulumi.Input[_builtins.str],
                 route_type: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input['RoutesV2DestinationArgs']] = None,
                 external_routing_domain_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input['RoutesV2MetadataArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 next_hop: Optional[pulumi.Input['RoutesV2NextHopArgs']] = None,
                 route_table_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_reference: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RoutesV2 resource.
        :param pulumi.Input[_builtins.str] route_table_ext_id: Route table UUID
        :param pulumi.Input[_builtins.str] route_type: Route type. Acceptable values are "STATIC", "LOCAL", "DYNAMIC"
        :param pulumi.Input[_builtins.str] description: BGP session description.
        :param pulumi.Input['RoutesV2DestinationArgs'] destination: Destination IP Subnet Configuration.
        :param pulumi.Input[_builtins.str] external_routing_domain_reference: External routing domain associated with this route table.
        :param pulumi.Input['RoutesV2MetadataArgs'] metadata: Metadata associated with this resource.
        :param pulumi.Input[_builtins.str] name: Route name.
        :param pulumi.Input['RoutesV2NextHopArgs'] next_hop: Route nexthop.
        :param pulumi.Input[_builtins.str] route_table_reference: Route table reference.
        :param pulumi.Input[_builtins.str] vpc_reference: VPC reference.
        """
        pulumi.set(__self__, "route_table_ext_id", route_table_ext_id)
        pulumi.set(__self__, "route_type", route_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if external_routing_domain_reference is not None:
            pulumi.set(__self__, "external_routing_domain_reference", external_routing_domain_reference)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_hop is not None:
            pulumi.set(__self__, "next_hop", next_hop)
        if route_table_reference is not None:
            pulumi.set(__self__, "route_table_reference", route_table_reference)
        if vpc_reference is not None:
            pulumi.set(__self__, "vpc_reference", vpc_reference)

    @_builtins.property
    @pulumi.getter(name="routeTableExtId")
    def route_table_ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        Route table UUID
        """
        return pulumi.get(self, "route_table_ext_id")

    @route_table_ext_id.setter
    def route_table_ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "route_table_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="routeType")
    def route_type(self) -> pulumi.Input[_builtins.str]:
        """
        Route type. Acceptable values are "STATIC", "LOCAL", "DYNAMIC"
        """
        return pulumi.get(self, "route_type")

    @route_type.setter
    def route_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "route_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        BGP session description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input['RoutesV2DestinationArgs']]:
        """
        Destination IP Subnet Configuration.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input['RoutesV2DestinationArgs']]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter(name="externalRoutingDomainReference")
    def external_routing_domain_reference(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        External routing domain associated with this route table.
        """
        return pulumi.get(self, "external_routing_domain_reference")

    @external_routing_domain_reference.setter
    def external_routing_domain_reference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_routing_domain_reference", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['RoutesV2MetadataArgs']]:
        """
        Metadata associated with this resource.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['RoutesV2MetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Route name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> Optional[pulumi.Input['RoutesV2NextHopArgs']]:
        """
        Route nexthop.
        """
        return pulumi.get(self, "next_hop")

    @next_hop.setter
    def next_hop(self, value: Optional[pulumi.Input['RoutesV2NextHopArgs']]):
        pulumi.set(self, "next_hop", value)

    @_builtins.property
    @pulumi.getter(name="routeTableReference")
    def route_table_reference(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Route table reference.
        """
        return pulumi.get(self, "route_table_reference")

    @route_table_reference.setter
    def route_table_reference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_table_reference", value)

    @_builtins.property
    @pulumi.getter(name="vpcReference")
    def vpc_reference(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VPC reference.
        """
        return pulumi.get(self, "vpc_reference")

    @vpc_reference.setter
    def vpc_reference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_reference", value)


@pulumi.input_type
class _RoutesV2State:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input['RoutesV2DestinationArgs']] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 external_routing_domain_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 is_active: Optional[pulumi.Input[_builtins.bool]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input['RoutesV2LinkArgs']]]] = None,
                 metadata: Optional[pulumi.Input['RoutesV2MetadataArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 next_hop: Optional[pulumi.Input['RoutesV2NextHopArgs']] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 route_table_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 route_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_reference: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RoutesV2 resources.
        :param pulumi.Input[_builtins.str] description: BGP session description.
        :param pulumi.Input['RoutesV2DestinationArgs'] destination: Destination IP Subnet Configuration.
        :param pulumi.Input[_builtins.str] ext_id: Route UUID
        :param pulumi.Input[_builtins.str] external_routing_domain_reference: External routing domain associated with this route table.
        :param pulumi.Input[_builtins.bool] is_active: Indicates whether the route is active in the forwarding plane.
        :param pulumi.Input[Sequence[pulumi.Input['RoutesV2LinkArgs']]] links: A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        :param pulumi.Input['RoutesV2MetadataArgs'] metadata: Metadata associated with this resource.
        :param pulumi.Input[_builtins.str] name: Route name.
        :param pulumi.Input['RoutesV2NextHopArgs'] next_hop: Route nexthop.
        :param pulumi.Input[_builtins.int] priority: Route priority. A higher value implies greater preference is assigned to the route.
        :param pulumi.Input[_builtins.str] route_table_ext_id: Route table UUID
        :param pulumi.Input[_builtins.str] route_table_reference: Route table reference.
        :param pulumi.Input[_builtins.str] route_type: Route type. Acceptable values are "STATIC", "LOCAL", "DYNAMIC"
        :param pulumi.Input[_builtins.str] tenant_id: A globally unique identifier that represents the tenant that owns this entity
        :param pulumi.Input[_builtins.str] vpc_reference: VPC reference.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if external_routing_domain_reference is not None:
            pulumi.set(__self__, "external_routing_domain_reference", external_routing_domain_reference)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_hop is not None:
            pulumi.set(__self__, "next_hop", next_hop)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if route_table_ext_id is not None:
            pulumi.set(__self__, "route_table_ext_id", route_table_ext_id)
        if route_table_reference is not None:
            pulumi.set(__self__, "route_table_reference", route_table_reference)
        if route_type is not None:
            pulumi.set(__self__, "route_type", route_type)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if vpc_reference is not None:
            pulumi.set(__self__, "vpc_reference", vpc_reference)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        BGP session description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input['RoutesV2DestinationArgs']]:
        """
        Destination IP Subnet Configuration.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input['RoutesV2DestinationArgs']]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Route UUID
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="externalRoutingDomainReference")
    def external_routing_domain_reference(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        External routing domain associated with this route table.
        """
        return pulumi.get(self, "external_routing_domain_reference")

    @external_routing_domain_reference.setter
    def external_routing_domain_reference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_routing_domain_reference", value)

    @_builtins.property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the route is active in the forwarding plane.
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_active", value)

    @_builtins.property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RoutesV2LinkArgs']]]]:
        """
        A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RoutesV2LinkArgs']]]]):
        pulumi.set(self, "links", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['RoutesV2MetadataArgs']]:
        """
        Metadata associated with this resource.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['RoutesV2MetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Route name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> Optional[pulumi.Input['RoutesV2NextHopArgs']]:
        """
        Route nexthop.
        """
        return pulumi.get(self, "next_hop")

    @next_hop.setter
    def next_hop(self, value: Optional[pulumi.Input['RoutesV2NextHopArgs']]):
        pulumi.set(self, "next_hop", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Route priority. A higher value implies greater preference is assigned to the route.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="routeTableExtId")
    def route_table_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Route table UUID
        """
        return pulumi.get(self, "route_table_ext_id")

    @route_table_ext_id.setter
    def route_table_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_table_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="routeTableReference")
    def route_table_reference(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Route table reference.
        """
        return pulumi.get(self, "route_table_reference")

    @route_table_reference.setter
    def route_table_reference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_table_reference", value)

    @_builtins.property
    @pulumi.getter(name="routeType")
    def route_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Route type. Acceptable values are "STATIC", "LOCAL", "DYNAMIC"
        """
        return pulumi.get(self, "route_type")

    @route_type.setter
    def route_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_type", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A globally unique identifier that represents the tenant that owns this entity
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcReference")
    def vpc_reference(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VPC reference.
        """
        return pulumi.get(self, "vpc_reference")

    @vpc_reference.setter
    def vpc_reference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_reference", value)


@pulumi.type_token("nutanix:index/routesV2:RoutesV2")
class RoutesV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[Union['RoutesV2DestinationArgs', 'RoutesV2DestinationArgsDict']]] = None,
                 external_routing_domain_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Union['RoutesV2MetadataArgs', 'RoutesV2MetadataArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 next_hop: Optional[pulumi.Input[Union['RoutesV2NextHopArgs', 'RoutesV2NextHopArgsDict']]] = None,
                 route_table_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 route_type: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides Nutanix resource to Create Route.

        ## Example

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # create a route
        route = nutanix.RoutesV2("route",
            name="terraform_example_route",
            description="terraform example route to example create route",
            vpc_reference="8a938cc5-282b-48c4-81be-de22de145d07",
            route_table_ext_id="c2c249b0-98a0-43fa-9ff6-dcde578d3936",
            destination={
                "ipv4": {
                    "ip": {
                        "value": "10.0.0.2",
                    },
                    "prefix_length": 32,
                },
            },
            next_hop={
                "next_hop_type": "EXTERNAL_SUBNET",
                "next_hop_reference": "ba250e3e-1db1-4950-917f-a9e2ea35b8e3",
            },
            metadata={
                "owner_reference_id": "a8fe48c4-f0d3-49c7-a017-efc30dd8fb2b",
                "project_reference_id": "ab520e1d-4950-1db1-917f-a9e2ea35b8e3",
            },
            route_type="STATIC")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: BGP session description.
        :param pulumi.Input[Union['RoutesV2DestinationArgs', 'RoutesV2DestinationArgsDict']] destination: Destination IP Subnet Configuration.
        :param pulumi.Input[_builtins.str] external_routing_domain_reference: External routing domain associated with this route table.
        :param pulumi.Input[Union['RoutesV2MetadataArgs', 'RoutesV2MetadataArgsDict']] metadata: Metadata associated with this resource.
        :param pulumi.Input[_builtins.str] name: Route name.
        :param pulumi.Input[Union['RoutesV2NextHopArgs', 'RoutesV2NextHopArgsDict']] next_hop: Route nexthop.
        :param pulumi.Input[_builtins.str] route_table_ext_id: Route table UUID
        :param pulumi.Input[_builtins.str] route_table_reference: Route table reference.
        :param pulumi.Input[_builtins.str] route_type: Route type. Acceptable values are "STATIC", "LOCAL", "DYNAMIC"
        :param pulumi.Input[_builtins.str] vpc_reference: VPC reference.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RoutesV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides Nutanix resource to Create Route.

        ## Example

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # create a route
        route = nutanix.RoutesV2("route",
            name="terraform_example_route",
            description="terraform example route to example create route",
            vpc_reference="8a938cc5-282b-48c4-81be-de22de145d07",
            route_table_ext_id="c2c249b0-98a0-43fa-9ff6-dcde578d3936",
            destination={
                "ipv4": {
                    "ip": {
                        "value": "10.0.0.2",
                    },
                    "prefix_length": 32,
                },
            },
            next_hop={
                "next_hop_type": "EXTERNAL_SUBNET",
                "next_hop_reference": "ba250e3e-1db1-4950-917f-a9e2ea35b8e3",
            },
            metadata={
                "owner_reference_id": "a8fe48c4-f0d3-49c7-a017-efc30dd8fb2b",
                "project_reference_id": "ab520e1d-4950-1db1-917f-a9e2ea35b8e3",
            },
            route_type="STATIC")
        ```

        :param str resource_name: The name of the resource.
        :param RoutesV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoutesV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[Union['RoutesV2DestinationArgs', 'RoutesV2DestinationArgsDict']]] = None,
                 external_routing_domain_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Union['RoutesV2MetadataArgs', 'RoutesV2MetadataArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 next_hop: Optional[pulumi.Input[Union['RoutesV2NextHopArgs', 'RoutesV2NextHopArgsDict']]] = None,
                 route_table_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 route_type: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoutesV2Args.__new__(RoutesV2Args)

            __props__.__dict__["description"] = description
            __props__.__dict__["destination"] = destination
            __props__.__dict__["external_routing_domain_reference"] = external_routing_domain_reference
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name"] = name
            __props__.__dict__["next_hop"] = next_hop
            if route_table_ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'route_table_ext_id'")
            __props__.__dict__["route_table_ext_id"] = route_table_ext_id
            __props__.__dict__["route_table_reference"] = route_table_reference
            if route_type is None and not opts.urn:
                raise TypeError("Missing required property 'route_type'")
            __props__.__dict__["route_type"] = route_type
            __props__.__dict__["vpc_reference"] = vpc_reference
            __props__.__dict__["ext_id"] = None
            __props__.__dict__["is_active"] = None
            __props__.__dict__["links"] = None
            __props__.__dict__["priority"] = None
            __props__.__dict__["tenant_id"] = None
        super(RoutesV2, __self__).__init__(
            'nutanix:index/routesV2:RoutesV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destination: Optional[pulumi.Input[Union['RoutesV2DestinationArgs', 'RoutesV2DestinationArgsDict']]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            external_routing_domain_reference: Optional[pulumi.Input[_builtins.str]] = None,
            is_active: Optional[pulumi.Input[_builtins.bool]] = None,
            links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RoutesV2LinkArgs', 'RoutesV2LinkArgsDict']]]]] = None,
            metadata: Optional[pulumi.Input[Union['RoutesV2MetadataArgs', 'RoutesV2MetadataArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            next_hop: Optional[pulumi.Input[Union['RoutesV2NextHopArgs', 'RoutesV2NextHopArgsDict']]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None,
            route_table_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            route_table_reference: Optional[pulumi.Input[_builtins.str]] = None,
            route_type: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_reference: Optional[pulumi.Input[_builtins.str]] = None) -> 'RoutesV2':
        """
        Get an existing RoutesV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: BGP session description.
        :param pulumi.Input[Union['RoutesV2DestinationArgs', 'RoutesV2DestinationArgsDict']] destination: Destination IP Subnet Configuration.
        :param pulumi.Input[_builtins.str] ext_id: Route UUID
        :param pulumi.Input[_builtins.str] external_routing_domain_reference: External routing domain associated with this route table.
        :param pulumi.Input[_builtins.bool] is_active: Indicates whether the route is active in the forwarding plane.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RoutesV2LinkArgs', 'RoutesV2LinkArgsDict']]]] links: A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        :param pulumi.Input[Union['RoutesV2MetadataArgs', 'RoutesV2MetadataArgsDict']] metadata: Metadata associated with this resource.
        :param pulumi.Input[_builtins.str] name: Route name.
        :param pulumi.Input[Union['RoutesV2NextHopArgs', 'RoutesV2NextHopArgsDict']] next_hop: Route nexthop.
        :param pulumi.Input[_builtins.int] priority: Route priority. A higher value implies greater preference is assigned to the route.
        :param pulumi.Input[_builtins.str] route_table_ext_id: Route table UUID
        :param pulumi.Input[_builtins.str] route_table_reference: Route table reference.
        :param pulumi.Input[_builtins.str] route_type: Route type. Acceptable values are "STATIC", "LOCAL", "DYNAMIC"
        :param pulumi.Input[_builtins.str] tenant_id: A globally unique identifier that represents the tenant that owns this entity
        :param pulumi.Input[_builtins.str] vpc_reference: VPC reference.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RoutesV2State.__new__(_RoutesV2State)

        __props__.__dict__["description"] = description
        __props__.__dict__["destination"] = destination
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["external_routing_domain_reference"] = external_routing_domain_reference
        __props__.__dict__["is_active"] = is_active
        __props__.__dict__["links"] = links
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["next_hop"] = next_hop
        __props__.__dict__["priority"] = priority
        __props__.__dict__["route_table_ext_id"] = route_table_ext_id
        __props__.__dict__["route_table_reference"] = route_table_reference
        __props__.__dict__["route_type"] = route_type
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["vpc_reference"] = vpc_reference
        return RoutesV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        BGP session description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Output['outputs.RoutesV2Destination']:
        """
        Destination IP Subnet Configuration.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        Route UUID
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="externalRoutingDomainReference")
    def external_routing_domain_reference(self) -> pulumi.Output[_builtins.str]:
        """
        External routing domain associated with this route table.
        """
        return pulumi.get(self, "external_routing_domain_reference")

    @_builtins.property
    @pulumi.getter(name="isActive")
    def is_active(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the route is active in the forwarding plane.
        """
        return pulumi.get(self, "is_active")

    @_builtins.property
    @pulumi.getter
    def links(self) -> pulumi.Output[Sequence['outputs.RoutesV2Link']]:
        """
        A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output['outputs.RoutesV2Metadata']:
        """
        Metadata associated with this resource.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Route name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> pulumi.Output['outputs.RoutesV2NextHop']:
        """
        Route nexthop.
        """
        return pulumi.get(self, "next_hop")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[_builtins.int]:
        """
        Route priority. A higher value implies greater preference is assigned to the route.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="routeTableExtId")
    def route_table_ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        Route table UUID
        """
        return pulumi.get(self, "route_table_ext_id")

    @_builtins.property
    @pulumi.getter(name="routeTableReference")
    def route_table_reference(self) -> pulumi.Output[_builtins.str]:
        """
        Route table reference.
        """
        return pulumi.get(self, "route_table_reference")

    @_builtins.property
    @pulumi.getter(name="routeType")
    def route_type(self) -> pulumi.Output[_builtins.str]:
        """
        Route type. Acceptable values are "STATIC", "LOCAL", "DYNAMIC"
        """
        return pulumi.get(self, "route_type")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        A globally unique identifier that represents the tenant that owns this entity
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="vpcReference")
    def vpc_reference(self) -> pulumi.Output[_builtins.str]:
        """
        VPC reference.
        """
        return pulumi.get(self, "vpc_reference")

