# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SelfServiceAppCustomActionArgs', 'SelfServiceAppCustomAction']

@pulumi.input_type
class SelfServiceAppCustomActionArgs:
    def __init__(__self__, *,
                 action_name: pulumi.Input[_builtins.str],
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 runlog_uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SelfServiceAppCustomAction resource.
        :param pulumi.Input[_builtins.str] action_name: - (Required) The name of the action to run.
               
               Both (`app_name` and `app_uuid`) are optional. You can provide either of them. But atleast one of them is required to make this resource work.
        :param pulumi.Input[_builtins.str] app_name: - (Optional) The name of the application.
        :param pulumi.Input[_builtins.str] app_uuid: - (Optional) The UUID of the application.
        :param pulumi.Input[_builtins.str] runlog_uuid: - (Computed) The UUID of the runlog associated with the execution of the custom action. This can be used to track the progress or status of the action execution.
        """
        pulumi.set(__self__, "action_name", action_name)
        if app_name is not None:
            pulumi.set(__self__, "app_name", app_name)
        if app_uuid is not None:
            pulumi.set(__self__, "app_uuid", app_uuid)
        if runlog_uuid is not None:
            pulumi.set(__self__, "runlog_uuid", runlog_uuid)

    @_builtins.property
    @pulumi.getter(name="actionName")
    def action_name(self) -> pulumi.Input[_builtins.str]:
        """
        - (Required) The name of the action to run.

        Both (`app_name` and `app_uuid`) are optional. You can provide either of them. But atleast one of them is required to make this resource work.
        """
        return pulumi.get(self, "action_name")

    @action_name.setter
    def action_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action_name", value)

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The name of the application.
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_name", value)

    @_builtins.property
    @pulumi.getter(name="appUuid")
    def app_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The UUID of the application.
        """
        return pulumi.get(self, "app_uuid")

    @app_uuid.setter
    def app_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_uuid", value)

    @_builtins.property
    @pulumi.getter(name="runlogUuid")
    def runlog_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Computed) The UUID of the runlog associated with the execution of the custom action. This can be used to track the progress or status of the action execution.
        """
        return pulumi.get(self, "runlog_uuid")

    @runlog_uuid.setter
    def runlog_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runlog_uuid", value)


@pulumi.input_type
class _SelfServiceAppCustomActionState:
    def __init__(__self__, *,
                 action_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 runlog_uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SelfServiceAppCustomAction resources.
        :param pulumi.Input[_builtins.str] action_name: - (Required) The name of the action to run.
               
               Both (`app_name` and `app_uuid`) are optional. You can provide either of them. But atleast one of them is required to make this resource work.
        :param pulumi.Input[_builtins.str] app_name: - (Optional) The name of the application.
        :param pulumi.Input[_builtins.str] app_uuid: - (Optional) The UUID of the application.
        :param pulumi.Input[_builtins.str] runlog_uuid: - (Computed) The UUID of the runlog associated with the execution of the custom action. This can be used to track the progress or status of the action execution.
        """
        if action_name is not None:
            pulumi.set(__self__, "action_name", action_name)
        if app_name is not None:
            pulumi.set(__self__, "app_name", app_name)
        if app_uuid is not None:
            pulumi.set(__self__, "app_uuid", app_uuid)
        if runlog_uuid is not None:
            pulumi.set(__self__, "runlog_uuid", runlog_uuid)

    @_builtins.property
    @pulumi.getter(name="actionName")
    def action_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) The name of the action to run.

        Both (`app_name` and `app_uuid`) are optional. You can provide either of them. But atleast one of them is required to make this resource work.
        """
        return pulumi.get(self, "action_name")

    @action_name.setter
    def action_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action_name", value)

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The name of the application.
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_name", value)

    @_builtins.property
    @pulumi.getter(name="appUuid")
    def app_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The UUID of the application.
        """
        return pulumi.get(self, "app_uuid")

    @app_uuid.setter
    def app_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_uuid", value)

    @_builtins.property
    @pulumi.getter(name="runlogUuid")
    def runlog_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Computed) The UUID of the runlog associated with the execution of the custom action. This can be used to track the progress or status of the action execution.
        """
        return pulumi.get(self, "runlog_uuid")

    @runlog_uuid.setter
    def runlog_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runlog_uuid", value)


@pulumi.type_token("nutanix:index/selfServiceAppCustomAction:SelfServiceAppCustomAction")
class SelfServiceAppCustomAction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 runlog_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Triggers custom action execution using it's name in Self Service Application.

        ## Example Usage

        ### 

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        test = nutanix.SelfServiceAppProvision("test",
            bp_name="NAME OF BLUEPRINT",
            app_name="NAME OF APPLICATION",
            app_description="DESCRIPTION OF APPLICATION")
        test_self_service_app_custom_action = nutanix.SelfServiceAppCustomAction("test",
            app_name=test.app_name,
            action_name="NAME OF ACTION")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action_name: - (Required) The name of the action to run.
               
               Both (`app_name` and `app_uuid`) are optional. You can provide either of them. But atleast one of them is required to make this resource work.
        :param pulumi.Input[_builtins.str] app_name: - (Optional) The name of the application.
        :param pulumi.Input[_builtins.str] app_uuid: - (Optional) The UUID of the application.
        :param pulumi.Input[_builtins.str] runlog_uuid: - (Computed) The UUID of the runlog associated with the execution of the custom action. This can be used to track the progress or status of the action execution.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SelfServiceAppCustomActionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Triggers custom action execution using it's name in Self Service Application.

        ## Example Usage

        ### 

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        test = nutanix.SelfServiceAppProvision("test",
            bp_name="NAME OF BLUEPRINT",
            app_name="NAME OF APPLICATION",
            app_description="DESCRIPTION OF APPLICATION")
        test_self_service_app_custom_action = nutanix.SelfServiceAppCustomAction("test",
            app_name=test.app_name,
            action_name="NAME OF ACTION")
        ```

        :param str resource_name: The name of the resource.
        :param SelfServiceAppCustomActionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SelfServiceAppCustomActionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 runlog_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SelfServiceAppCustomActionArgs.__new__(SelfServiceAppCustomActionArgs)

            if action_name is None and not opts.urn:
                raise TypeError("Missing required property 'action_name'")
            __props__.__dict__["action_name"] = action_name
            __props__.__dict__["app_name"] = app_name
            __props__.__dict__["app_uuid"] = app_uuid
            __props__.__dict__["runlog_uuid"] = runlog_uuid
        super(SelfServiceAppCustomAction, __self__).__init__(
            'nutanix:index/selfServiceAppCustomAction:SelfServiceAppCustomAction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action_name: Optional[pulumi.Input[_builtins.str]] = None,
            app_name: Optional[pulumi.Input[_builtins.str]] = None,
            app_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            runlog_uuid: Optional[pulumi.Input[_builtins.str]] = None) -> 'SelfServiceAppCustomAction':
        """
        Get an existing SelfServiceAppCustomAction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action_name: - (Required) The name of the action to run.
               
               Both (`app_name` and `app_uuid`) are optional. You can provide either of them. But atleast one of them is required to make this resource work.
        :param pulumi.Input[_builtins.str] app_name: - (Optional) The name of the application.
        :param pulumi.Input[_builtins.str] app_uuid: - (Optional) The UUID of the application.
        :param pulumi.Input[_builtins.str] runlog_uuid: - (Computed) The UUID of the runlog associated with the execution of the custom action. This can be used to track the progress or status of the action execution.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SelfServiceAppCustomActionState.__new__(_SelfServiceAppCustomActionState)

        __props__.__dict__["action_name"] = action_name
        __props__.__dict__["app_name"] = app_name
        __props__.__dict__["app_uuid"] = app_uuid
        __props__.__dict__["runlog_uuid"] = runlog_uuid
        return SelfServiceAppCustomAction(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="actionName")
    def action_name(self) -> pulumi.Output[_builtins.str]:
        """
        - (Required) The name of the action to run.

        Both (`app_name` and `app_uuid`) are optional. You can provide either of them. But atleast one of them is required to make this resource work.
        """
        return pulumi.get(self, "action_name")

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - (Optional) The name of the application.
        """
        return pulumi.get(self, "app_name")

    @_builtins.property
    @pulumi.getter(name="appUuid")
    def app_uuid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - (Optional) The UUID of the application.
        """
        return pulumi.get(self, "app_uuid")

    @_builtins.property
    @pulumi.getter(name="runlogUuid")
    def runlog_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        - (Computed) The UUID of the runlog associated with the execution of the custom action. This can be used to track the progress or status of the action execution.
        """
        return pulumi.get(self, "runlog_uuid")

