# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SelfServiceAppPatchArgs', 'SelfServiceAppPatch']

@pulumi.input_type
class SelfServiceAppPatchArgs:
    def __init__(__self__, *,
                 app_uuid: pulumi.Input[_builtins.str],
                 config_name: pulumi.Input[_builtins.str],
                 patch_name: pulumi.Input[_builtins.str],
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppPatchCategoryArgs']]]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppPatchDiskArgs']]]] = None,
                 nics: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppPatchNicArgs']]]] = None,
                 runlog_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_configs: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppPatchVmConfigArgs']]]] = None):
        """
        The set of arguments for constructing a SelfServiceAppPatch resource.
        :param pulumi.Input[_builtins.str] app_uuid: - (Required) The UUID of the application.
        :param pulumi.Input[_builtins.str] config_name: - (Required) The name of the patch configuration. (<b>Same as patch_name for SINGLE VM)</b>
        :param pulumi.Input[_builtins.str] patch_name: - (Required) The name of the patch to be applied. This is used to identify the action name which needs to be executed to update an application.
        :param pulumi.Input[_builtins.str] runlog_uuid: - (Computed) The UUID of the runlog that records the patch operation's execution details.
        """
        pulumi.set(__self__, "app_uuid", app_uuid)
        pulumi.set(__self__, "config_name", config_name)
        pulumi.set(__self__, "patch_name", patch_name)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if nics is not None:
            pulumi.set(__self__, "nics", nics)
        if runlog_uuid is not None:
            pulumi.set(__self__, "runlog_uuid", runlog_uuid)
        if vm_configs is not None:
            pulumi.set(__self__, "vm_configs", vm_configs)

    @_builtins.property
    @pulumi.getter(name="appUuid")
    def app_uuid(self) -> pulumi.Input[_builtins.str]:
        """
        - (Required) The UUID of the application.
        """
        return pulumi.get(self, "app_uuid")

    @app_uuid.setter
    def app_uuid(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app_uuid", value)

    @_builtins.property
    @pulumi.getter(name="configName")
    def config_name(self) -> pulumi.Input[_builtins.str]:
        """
        - (Required) The name of the patch configuration. (<b>Same as patch_name for SINGLE VM)</b>
        """
        return pulumi.get(self, "config_name")

    @config_name.setter
    def config_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "config_name", value)

    @_builtins.property
    @pulumi.getter(name="patchName")
    def patch_name(self) -> pulumi.Input[_builtins.str]:
        """
        - (Required) The name of the patch to be applied. This is used to identify the action name which needs to be executed to update an application.
        """
        return pulumi.get(self, "patch_name")

    @patch_name.setter
    def patch_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "patch_name", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppPatchCategoryArgs']]]]:
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppPatchCategoryArgs']]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter
    def disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppPatchDiskArgs']]]]:
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppPatchDiskArgs']]]]):
        pulumi.set(self, "disks", value)

    @_builtins.property
    @pulumi.getter
    def nics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppPatchNicArgs']]]]:
        return pulumi.get(self, "nics")

    @nics.setter
    def nics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppPatchNicArgs']]]]):
        pulumi.set(self, "nics", value)

    @_builtins.property
    @pulumi.getter(name="runlogUuid")
    def runlog_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Computed) The UUID of the runlog that records the patch operation's execution details.
        """
        return pulumi.get(self, "runlog_uuid")

    @runlog_uuid.setter
    def runlog_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runlog_uuid", value)

    @_builtins.property
    @pulumi.getter(name="vmConfigs")
    def vm_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppPatchVmConfigArgs']]]]:
        return pulumi.get(self, "vm_configs")

    @vm_configs.setter
    def vm_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppPatchVmConfigArgs']]]]):
        pulumi.set(self, "vm_configs", value)


@pulumi.input_type
class _SelfServiceAppPatchState:
    def __init__(__self__, *,
                 app_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppPatchCategoryArgs']]]] = None,
                 config_name: Optional[pulumi.Input[_builtins.str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppPatchDiskArgs']]]] = None,
                 nics: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppPatchNicArgs']]]] = None,
                 patch_name: Optional[pulumi.Input[_builtins.str]] = None,
                 runlog_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_configs: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppPatchVmConfigArgs']]]] = None):
        """
        Input properties used for looking up and filtering SelfServiceAppPatch resources.
        :param pulumi.Input[_builtins.str] app_uuid: - (Required) The UUID of the application.
        :param pulumi.Input[_builtins.str] config_name: - (Required) The name of the patch configuration. (<b>Same as patch_name for SINGLE VM)</b>
        :param pulumi.Input[_builtins.str] patch_name: - (Required) The name of the patch to be applied. This is used to identify the action name which needs to be executed to update an application.
        :param pulumi.Input[_builtins.str] runlog_uuid: - (Computed) The UUID of the runlog that records the patch operation's execution details.
        """
        if app_uuid is not None:
            pulumi.set(__self__, "app_uuid", app_uuid)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if config_name is not None:
            pulumi.set(__self__, "config_name", config_name)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if nics is not None:
            pulumi.set(__self__, "nics", nics)
        if patch_name is not None:
            pulumi.set(__self__, "patch_name", patch_name)
        if runlog_uuid is not None:
            pulumi.set(__self__, "runlog_uuid", runlog_uuid)
        if vm_configs is not None:
            pulumi.set(__self__, "vm_configs", vm_configs)

    @_builtins.property
    @pulumi.getter(name="appUuid")
    def app_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) The UUID of the application.
        """
        return pulumi.get(self, "app_uuid")

    @app_uuid.setter
    def app_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_uuid", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppPatchCategoryArgs']]]]:
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppPatchCategoryArgs']]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter(name="configName")
    def config_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) The name of the patch configuration. (<b>Same as patch_name for SINGLE VM)</b>
        """
        return pulumi.get(self, "config_name")

    @config_name.setter
    def config_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_name", value)

    @_builtins.property
    @pulumi.getter
    def disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppPatchDiskArgs']]]]:
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppPatchDiskArgs']]]]):
        pulumi.set(self, "disks", value)

    @_builtins.property
    @pulumi.getter
    def nics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppPatchNicArgs']]]]:
        return pulumi.get(self, "nics")

    @nics.setter
    def nics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppPatchNicArgs']]]]):
        pulumi.set(self, "nics", value)

    @_builtins.property
    @pulumi.getter(name="patchName")
    def patch_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) The name of the patch to be applied. This is used to identify the action name which needs to be executed to update an application.
        """
        return pulumi.get(self, "patch_name")

    @patch_name.setter
    def patch_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "patch_name", value)

    @_builtins.property
    @pulumi.getter(name="runlogUuid")
    def runlog_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Computed) The UUID of the runlog that records the patch operation's execution details.
        """
        return pulumi.get(self, "runlog_uuid")

    @runlog_uuid.setter
    def runlog_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runlog_uuid", value)

    @_builtins.property
    @pulumi.getter(name="vmConfigs")
    def vm_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppPatchVmConfigArgs']]]]:
        return pulumi.get(self, "vm_configs")

    @vm_configs.setter
    def vm_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppPatchVmConfigArgs']]]]):
        pulumi.set(self, "vm_configs", value)


@pulumi.type_token("nutanix:index/selfServiceAppPatch:SelfServiceAppPatch")
class SelfServiceAppPatch(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SelfServiceAppPatchCategoryArgs', 'SelfServiceAppPatchCategoryArgsDict']]]]] = None,
                 config_name: Optional[pulumi.Input[_builtins.str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SelfServiceAppPatchDiskArgs', 'SelfServiceAppPatchDiskArgsDict']]]]] = None,
                 nics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SelfServiceAppPatchNicArgs', 'SelfServiceAppPatchNicArgsDict']]]]] = None,
                 patch_name: Optional[pulumi.Input[_builtins.str]] = None,
                 runlog_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SelfServiceAppPatchVmConfigArgs', 'SelfServiceAppPatchVmConfigArgsDict']]]]] = None,
                 __props__=None):
        """
        Run the specified patch on the application by running patch action to update vm configuration, add nics, add disks, add/delete categories.

        ## Example 1: Update VM Configuration

        This will run set patch config action in application.

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # Provision Application
        test = nutanix.SelfServiceAppProvision("test",
            bp_name="NAME OF BLUEPRINT",
            app_name="NAME OF APPLICATION",
            app_description="DESCRIPTION OF APPLICATION")
        # Run patch config (update config)
        test_self_service_app_patch = nutanix.SelfServiceAppPatch("test",
            app_uuid=test.id,
            patch_name="NAME OF PATCH ACTION",
            config_name="NAME OF PATCH CONFIG")
        ```

        ## Example 2: Update VM Configuration with runtime editable

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # Provision Application
        test = nutanix.SelfServiceAppProvision("test",
            bp_name="NAME OF BLUEPRINT",
            app_name="NAME OF APPLICATION",
            app_description="DESCRIPTION OF APPLICATION")
        # Run patch config (update config)
        test_self_service_app_patch = nutanix.SelfServiceAppPatch("test",
            app_uuid=test.id,
            patch_name="NAME OF PATCH ACTION",
            config_name="NAME OF PATCH CONFIG",
            vm_configs=[{
                "memory_size_mib": "SIZE IN MiB",
                "num_sockets": "vCPU count",
                "num_vcpus_per_socket": "NUMBER OF CORES VCPU",
            }])
        ```

        ## Example 3: Add Category

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # Provision Application
        test = nutanix.SelfServiceAppProvision("test",
            bp_name="NAME OF BLUEPRINT",
            app_name="NAME OF APPLICATION",
            app_description="DESCRIPTION OF APPLICATION")
        # Run patch config (update config)
        test_self_service_app_patch = nutanix.SelfServiceAppPatch("test",
            app_uuid=test.id,
            patch_name="NAME OF PATCH ACTION",
            config_name="NAME OF PATCH CONFIG",
            categories=[{
                "value": "CATEGORY TO BE ADDED (KEY:VALUE PAIR)",
                "operation": "add",
            }])
        ```

        ## Example 4: Delete Category

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # Provision Application
        test = nutanix.SelfServiceAppProvision("test",
            bp_name="NAME OF BLUEPRINT",
            app_name="NAME OF APPLICATION",
            app_description="DESCRIPTION OF APPLICATION")
        # Run patch config (update config)
        test_self_service_app_patch = nutanix.SelfServiceAppPatch("test",
            app_uuid=test.id,
            patch_name="NAME OF PATCH ACTION",
            config_name="NAME OF PATCH CONFIG",
            categories=[{
                "value": "CATEGORY TO BE ADDED (KEY:VALUE PAIR)",
                "operation": "delete",
            }])
        ```

        ## Example 5: Add Disk

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # Provision Application
        test = nutanix.SelfServiceAppProvision("test",
            bp_name="NAME OF BLUEPRINT",
            app_name="NAME OF APPLICATION",
            app_description="DESCRIPTION OF APPLICATION")
        # Run patch config (update config)
        test_self_service_app_patch = nutanix.SelfServiceAppPatch("test",
            app_uuid=test.id,
            patch_name="NAME OF PATCH ACTION",
            config_name="NAME OF PATCH CONFIG",
            disks=[{
                "disk_size_mib": "SIZE OF DISK IN MiB",
                "operation": "add",
            }])
        ```

        ## Example 6: Add Nic

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # Provision Application
        test = nutanix.SelfServiceAppProvision("test",
            bp_name="NAME OF BLUEPRINT",
            app_name="NAME OF APPLICATION",
            app_description="DESCRIPTION OF APPLICATION")
        # Run patch config (update config)
        test_self_service_app_patch = nutanix.SelfServiceAppPatch("test",
            app_uuid=test.id,
            patch_name="NAME OF PATCH ACTION",
            config_name="NAME OF PATCH CONFIG",
            nics=[{
                "index": "DUMMY INDEX VALUE",
                "operation": "add",
                "subnet_uuid": "VALID SUBNET UUID IN PROJECT ATTACHED TO APP",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_uuid: - (Required) The UUID of the application.
        :param pulumi.Input[_builtins.str] config_name: - (Required) The name of the patch configuration. (<b>Same as patch_name for SINGLE VM)</b>
        :param pulumi.Input[_builtins.str] patch_name: - (Required) The name of the patch to be applied. This is used to identify the action name which needs to be executed to update an application.
        :param pulumi.Input[_builtins.str] runlog_uuid: - (Computed) The UUID of the runlog that records the patch operation's execution details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SelfServiceAppPatchArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Run the specified patch on the application by running patch action to update vm configuration, add nics, add disks, add/delete categories.

        ## Example 1: Update VM Configuration

        This will run set patch config action in application.

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # Provision Application
        test = nutanix.SelfServiceAppProvision("test",
            bp_name="NAME OF BLUEPRINT",
            app_name="NAME OF APPLICATION",
            app_description="DESCRIPTION OF APPLICATION")
        # Run patch config (update config)
        test_self_service_app_patch = nutanix.SelfServiceAppPatch("test",
            app_uuid=test.id,
            patch_name="NAME OF PATCH ACTION",
            config_name="NAME OF PATCH CONFIG")
        ```

        ## Example 2: Update VM Configuration with runtime editable

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # Provision Application
        test = nutanix.SelfServiceAppProvision("test",
            bp_name="NAME OF BLUEPRINT",
            app_name="NAME OF APPLICATION",
            app_description="DESCRIPTION OF APPLICATION")
        # Run patch config (update config)
        test_self_service_app_patch = nutanix.SelfServiceAppPatch("test",
            app_uuid=test.id,
            patch_name="NAME OF PATCH ACTION",
            config_name="NAME OF PATCH CONFIG",
            vm_configs=[{
                "memory_size_mib": "SIZE IN MiB",
                "num_sockets": "vCPU count",
                "num_vcpus_per_socket": "NUMBER OF CORES VCPU",
            }])
        ```

        ## Example 3: Add Category

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # Provision Application
        test = nutanix.SelfServiceAppProvision("test",
            bp_name="NAME OF BLUEPRINT",
            app_name="NAME OF APPLICATION",
            app_description="DESCRIPTION OF APPLICATION")
        # Run patch config (update config)
        test_self_service_app_patch = nutanix.SelfServiceAppPatch("test",
            app_uuid=test.id,
            patch_name="NAME OF PATCH ACTION",
            config_name="NAME OF PATCH CONFIG",
            categories=[{
                "value": "CATEGORY TO BE ADDED (KEY:VALUE PAIR)",
                "operation": "add",
            }])
        ```

        ## Example 4: Delete Category

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # Provision Application
        test = nutanix.SelfServiceAppProvision("test",
            bp_name="NAME OF BLUEPRINT",
            app_name="NAME OF APPLICATION",
            app_description="DESCRIPTION OF APPLICATION")
        # Run patch config (update config)
        test_self_service_app_patch = nutanix.SelfServiceAppPatch("test",
            app_uuid=test.id,
            patch_name="NAME OF PATCH ACTION",
            config_name="NAME OF PATCH CONFIG",
            categories=[{
                "value": "CATEGORY TO BE ADDED (KEY:VALUE PAIR)",
                "operation": "delete",
            }])
        ```

        ## Example 5: Add Disk

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # Provision Application
        test = nutanix.SelfServiceAppProvision("test",
            bp_name="NAME OF BLUEPRINT",
            app_name="NAME OF APPLICATION",
            app_description="DESCRIPTION OF APPLICATION")
        # Run patch config (update config)
        test_self_service_app_patch = nutanix.SelfServiceAppPatch("test",
            app_uuid=test.id,
            patch_name="NAME OF PATCH ACTION",
            config_name="NAME OF PATCH CONFIG",
            disks=[{
                "disk_size_mib": "SIZE OF DISK IN MiB",
                "operation": "add",
            }])
        ```

        ## Example 6: Add Nic

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # Provision Application
        test = nutanix.SelfServiceAppProvision("test",
            bp_name="NAME OF BLUEPRINT",
            app_name="NAME OF APPLICATION",
            app_description="DESCRIPTION OF APPLICATION")
        # Run patch config (update config)
        test_self_service_app_patch = nutanix.SelfServiceAppPatch("test",
            app_uuid=test.id,
            patch_name="NAME OF PATCH ACTION",
            config_name="NAME OF PATCH CONFIG",
            nics=[{
                "index": "DUMMY INDEX VALUE",
                "operation": "add",
                "subnet_uuid": "VALID SUBNET UUID IN PROJECT ATTACHED TO APP",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param SelfServiceAppPatchArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SelfServiceAppPatchArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SelfServiceAppPatchCategoryArgs', 'SelfServiceAppPatchCategoryArgsDict']]]]] = None,
                 config_name: Optional[pulumi.Input[_builtins.str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SelfServiceAppPatchDiskArgs', 'SelfServiceAppPatchDiskArgsDict']]]]] = None,
                 nics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SelfServiceAppPatchNicArgs', 'SelfServiceAppPatchNicArgsDict']]]]] = None,
                 patch_name: Optional[pulumi.Input[_builtins.str]] = None,
                 runlog_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SelfServiceAppPatchVmConfigArgs', 'SelfServiceAppPatchVmConfigArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SelfServiceAppPatchArgs.__new__(SelfServiceAppPatchArgs)

            if app_uuid is None and not opts.urn:
                raise TypeError("Missing required property 'app_uuid'")
            __props__.__dict__["app_uuid"] = app_uuid
            __props__.__dict__["categories"] = categories
            if config_name is None and not opts.urn:
                raise TypeError("Missing required property 'config_name'")
            __props__.__dict__["config_name"] = config_name
            __props__.__dict__["disks"] = disks
            __props__.__dict__["nics"] = nics
            if patch_name is None and not opts.urn:
                raise TypeError("Missing required property 'patch_name'")
            __props__.__dict__["patch_name"] = patch_name
            __props__.__dict__["runlog_uuid"] = runlog_uuid
            __props__.__dict__["vm_configs"] = vm_configs
        super(SelfServiceAppPatch, __self__).__init__(
            'nutanix:index/selfServiceAppPatch:SelfServiceAppPatch',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SelfServiceAppPatchCategoryArgs', 'SelfServiceAppPatchCategoryArgsDict']]]]] = None,
            config_name: Optional[pulumi.Input[_builtins.str]] = None,
            disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SelfServiceAppPatchDiskArgs', 'SelfServiceAppPatchDiskArgsDict']]]]] = None,
            nics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SelfServiceAppPatchNicArgs', 'SelfServiceAppPatchNicArgsDict']]]]] = None,
            patch_name: Optional[pulumi.Input[_builtins.str]] = None,
            runlog_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            vm_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SelfServiceAppPatchVmConfigArgs', 'SelfServiceAppPatchVmConfigArgsDict']]]]] = None) -> 'SelfServiceAppPatch':
        """
        Get an existing SelfServiceAppPatch resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_uuid: - (Required) The UUID of the application.
        :param pulumi.Input[_builtins.str] config_name: - (Required) The name of the patch configuration. (<b>Same as patch_name for SINGLE VM)</b>
        :param pulumi.Input[_builtins.str] patch_name: - (Required) The name of the patch to be applied. This is used to identify the action name which needs to be executed to update an application.
        :param pulumi.Input[_builtins.str] runlog_uuid: - (Computed) The UUID of the runlog that records the patch operation's execution details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SelfServiceAppPatchState.__new__(_SelfServiceAppPatchState)

        __props__.__dict__["app_uuid"] = app_uuid
        __props__.__dict__["categories"] = categories
        __props__.__dict__["config_name"] = config_name
        __props__.__dict__["disks"] = disks
        __props__.__dict__["nics"] = nics
        __props__.__dict__["patch_name"] = patch_name
        __props__.__dict__["runlog_uuid"] = runlog_uuid
        __props__.__dict__["vm_configs"] = vm_configs
        return SelfServiceAppPatch(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appUuid")
    def app_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        - (Required) The UUID of the application.
        """
        return pulumi.get(self, "app_uuid")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> pulumi.Output[Optional[Sequence['outputs.SelfServiceAppPatchCategory']]]:
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter(name="configName")
    def config_name(self) -> pulumi.Output[_builtins.str]:
        """
        - (Required) The name of the patch configuration. (<b>Same as patch_name for SINGLE VM)</b>
        """
        return pulumi.get(self, "config_name")

    @_builtins.property
    @pulumi.getter
    def disks(self) -> pulumi.Output[Optional[Sequence['outputs.SelfServiceAppPatchDisk']]]:
        return pulumi.get(self, "disks")

    @_builtins.property
    @pulumi.getter
    def nics(self) -> pulumi.Output[Optional[Sequence['outputs.SelfServiceAppPatchNic']]]:
        return pulumi.get(self, "nics")

    @_builtins.property
    @pulumi.getter(name="patchName")
    def patch_name(self) -> pulumi.Output[_builtins.str]:
        """
        - (Required) The name of the patch to be applied. This is used to identify the action name which needs to be executed to update an application.
        """
        return pulumi.get(self, "patch_name")

    @_builtins.property
    @pulumi.getter(name="runlogUuid")
    def runlog_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        - (Computed) The UUID of the runlog that records the patch operation's execution details.
        """
        return pulumi.get(self, "runlog_uuid")

    @_builtins.property
    @pulumi.getter(name="vmConfigs")
    def vm_configs(self) -> pulumi.Output[Optional[Sequence['outputs.SelfServiceAppPatchVmConfig']]]:
        return pulumi.get(self, "vm_configs")

