# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SelfServiceAppProvisionArgs', 'SelfServiceAppProvision']

@pulumi.input_type
class SelfServiceAppProvisionArgs:
    def __init__(__self__, *,
                 app_name: pulumi.Input[_builtins.str],
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 app_description: Optional[pulumi.Input[_builtins.str]] = None,
                 bp_name: Optional[pulumi.Input[_builtins.str]] = None,
                 bp_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_editables: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppProvisionRuntimeEditableArgs']]]] = None,
                 soft_delete: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a SelfServiceAppProvision resource.
        :param pulumi.Input[_builtins.str] app_name: - (Required) The name of the application you want to set.
        :param pulumi.Input[_builtins.str] action: - (Optional) System action to trigger after provisioning. Valid values: ["start", "stop", "restart"]
        :param pulumi.Input[_builtins.str] app_description: - (Optional) The description of application.
               
               Both are `bp_name` and `bp_uuid` are optional but atleast one of them to be provided for this resource to work.
        :param pulumi.Input[_builtins.str] bp_name: - (Optional) The name of the blueprint to launch.
        :param pulumi.Input[_builtins.str] bp_uuid: - (Optional) The UUID of the blueprint to launch.
        :param pulumi.Input[_builtins.bool] soft_delete: - (Optional, Default: false) If true, the application is soft-deleted when the resource is destroyed.
        """
        pulumi.set(__self__, "app_name", app_name)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if app_description is not None:
            pulumi.set(__self__, "app_description", app_description)
        if bp_name is not None:
            pulumi.set(__self__, "bp_name", bp_name)
        if bp_uuid is not None:
            pulumi.set(__self__, "bp_uuid", bp_uuid)
        if runtime_editables is not None:
            pulumi.set(__self__, "runtime_editables", runtime_editables)
        if soft_delete is not None:
            pulumi.set(__self__, "soft_delete", soft_delete)

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Input[_builtins.str]:
        """
        - (Required) The name of the application you want to set.
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app_name", value)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) System action to trigger after provisioning. Valid values: ["start", "stop", "restart"]
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="appDescription")
    def app_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The description of application.

        Both are `bp_name` and `bp_uuid` are optional but atleast one of them to be provided for this resource to work.
        """
        return pulumi.get(self, "app_description")

    @app_description.setter
    def app_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_description", value)

    @_builtins.property
    @pulumi.getter(name="bpName")
    def bp_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The name of the blueprint to launch.
        """
        return pulumi.get(self, "bp_name")

    @bp_name.setter
    def bp_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bp_name", value)

    @_builtins.property
    @pulumi.getter(name="bpUuid")
    def bp_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The UUID of the blueprint to launch.
        """
        return pulumi.get(self, "bp_uuid")

    @bp_uuid.setter
    def bp_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bp_uuid", value)

    @_builtins.property
    @pulumi.getter(name="runtimeEditables")
    def runtime_editables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppProvisionRuntimeEditableArgs']]]]:
        return pulumi.get(self, "runtime_editables")

    @runtime_editables.setter
    def runtime_editables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppProvisionRuntimeEditableArgs']]]]):
        pulumi.set(self, "runtime_editables", value)

    @_builtins.property
    @pulumi.getter(name="softDelete")
    def soft_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional, Default: false) If true, the application is soft-deleted when the resource is destroyed.
        """
        return pulumi.get(self, "soft_delete")

    @soft_delete.setter
    def soft_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "soft_delete", value)


@pulumi.input_type
class _SelfServiceAppProvisionState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppProvisionActionArgs']]]] = None,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 app_description: Optional[pulumi.Input[_builtins.str]] = None,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_summaries: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppProvisionAppSummaryArgs']]]] = None,
                 bp_name: Optional[pulumi.Input[_builtins.str]] = None,
                 bp_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_editables: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppProvisionRuntimeEditableArgs']]]] = None,
                 soft_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 spec: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vms: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppProvisionVmArgs']]]] = None):
        """
        Input properties used for looking up and filtering SelfServiceAppProvision resources.
        :param pulumi.Input[_builtins.str] action: - (Optional) System action to trigger after provisioning. Valid values: ["start", "stop", "restart"]
        :param pulumi.Input[_builtins.str] api_version: - (Computed) API version used.
        :param pulumi.Input[_builtins.str] app_description: - (Optional) The description of application.
               
               Both are `bp_name` and `bp_uuid` are optional but atleast one of them to be provided for this resource to work.
        :param pulumi.Input[_builtins.str] app_name: - (Required) The name of the application you want to set.
        :param pulumi.Input[_builtins.str] bp_name: - (Optional) The name of the blueprint to launch.
        :param pulumi.Input[_builtins.str] bp_uuid: - (Optional) The UUID of the blueprint to launch.
        :param pulumi.Input[_builtins.bool] soft_delete: - (Optional, Default: false) If true, the application is soft-deleted when the resource is destroyed.
        :param pulumi.Input[_builtins.str] spec: - (Computed) Application specification (JSON string).
        :param pulumi.Input[_builtins.str] state: - (Computed) state of the application (e.g. running, stopped)
        :param pulumi.Input[_builtins.str] status: - (Computed) Application status coming as response from server.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if app_description is not None:
            pulumi.set(__self__, "app_description", app_description)
        if app_name is not None:
            pulumi.set(__self__, "app_name", app_name)
        if app_summaries is not None:
            pulumi.set(__self__, "app_summaries", app_summaries)
        if bp_name is not None:
            pulumi.set(__self__, "bp_name", bp_name)
        if bp_uuid is not None:
            pulumi.set(__self__, "bp_uuid", bp_uuid)
        if runtime_editables is not None:
            pulumi.set(__self__, "runtime_editables", runtime_editables)
        if soft_delete is not None:
            pulumi.set(__self__, "soft_delete", soft_delete)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vms is not None:
            pulumi.set(__self__, "vms", vms)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) System action to trigger after provisioning. Valid values: ["start", "stop", "restart"]
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppProvisionActionArgs']]]]:
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppProvisionActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Computed) API version used.
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter(name="appDescription")
    def app_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The description of application.

        Both are `bp_name` and `bp_uuid` are optional but atleast one of them to be provided for this resource to work.
        """
        return pulumi.get(self, "app_description")

    @app_description.setter
    def app_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_description", value)

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) The name of the application you want to set.
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_name", value)

    @_builtins.property
    @pulumi.getter(name="appSummaries")
    def app_summaries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppProvisionAppSummaryArgs']]]]:
        return pulumi.get(self, "app_summaries")

    @app_summaries.setter
    def app_summaries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppProvisionAppSummaryArgs']]]]):
        pulumi.set(self, "app_summaries", value)

    @_builtins.property
    @pulumi.getter(name="bpName")
    def bp_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The name of the blueprint to launch.
        """
        return pulumi.get(self, "bp_name")

    @bp_name.setter
    def bp_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bp_name", value)

    @_builtins.property
    @pulumi.getter(name="bpUuid")
    def bp_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The UUID of the blueprint to launch.
        """
        return pulumi.get(self, "bp_uuid")

    @bp_uuid.setter
    def bp_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bp_uuid", value)

    @_builtins.property
    @pulumi.getter(name="runtimeEditables")
    def runtime_editables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppProvisionRuntimeEditableArgs']]]]:
        return pulumi.get(self, "runtime_editables")

    @runtime_editables.setter
    def runtime_editables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppProvisionRuntimeEditableArgs']]]]):
        pulumi.set(self, "runtime_editables", value)

    @_builtins.property
    @pulumi.getter(name="softDelete")
    def soft_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional, Default: false) If true, the application is soft-deleted when the resource is destroyed.
        """
        return pulumi.get(self, "soft_delete")

    @soft_delete.setter
    def soft_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "soft_delete", value)

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Computed) Application specification (JSON string).
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spec", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Computed) state of the application (e.g. running, stopped)
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Computed) Application status coming as response from server.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def vms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppProvisionVmArgs']]]]:
        return pulumi.get(self, "vms")

    @vms.setter
    def vms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceAppProvisionVmArgs']]]]):
        pulumi.set(self, "vms", value)


@pulumi.type_token("nutanix:index/selfServiceAppProvision:SelfServiceAppProvision")
class SelfServiceAppProvision(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 app_description: Optional[pulumi.Input[_builtins.str]] = None,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 bp_name: Optional[pulumi.Input[_builtins.str]] = None,
                 bp_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_editables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SelfServiceAppProvisionRuntimeEditableArgs', 'SelfServiceAppProvisionRuntimeEditableArgsDict']]]]] = None,
                 soft_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Create a SelfServiceAppProvision resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: - (Optional) System action to trigger after provisioning. Valid values: ["start", "stop", "restart"]
        :param pulumi.Input[_builtins.str] app_description: - (Optional) The description of application.
               
               Both are `bp_name` and `bp_uuid` are optional but atleast one of them to be provided for this resource to work.
        :param pulumi.Input[_builtins.str] app_name: - (Required) The name of the application you want to set.
        :param pulumi.Input[_builtins.str] bp_name: - (Optional) The name of the blueprint to launch.
        :param pulumi.Input[_builtins.str] bp_uuid: - (Optional) The UUID of the blueprint to launch.
        :param pulumi.Input[_builtins.bool] soft_delete: - (Optional, Default: false) If true, the application is soft-deleted when the resource is destroyed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SelfServiceAppProvisionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a SelfServiceAppProvision resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param SelfServiceAppProvisionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SelfServiceAppProvisionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 app_description: Optional[pulumi.Input[_builtins.str]] = None,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 bp_name: Optional[pulumi.Input[_builtins.str]] = None,
                 bp_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_editables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SelfServiceAppProvisionRuntimeEditableArgs', 'SelfServiceAppProvisionRuntimeEditableArgsDict']]]]] = None,
                 soft_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SelfServiceAppProvisionArgs.__new__(SelfServiceAppProvisionArgs)

            __props__.__dict__["action"] = action
            __props__.__dict__["app_description"] = app_description
            if app_name is None and not opts.urn:
                raise TypeError("Missing required property 'app_name'")
            __props__.__dict__["app_name"] = app_name
            __props__.__dict__["bp_name"] = bp_name
            __props__.__dict__["bp_uuid"] = bp_uuid
            __props__.__dict__["runtime_editables"] = runtime_editables
            __props__.__dict__["soft_delete"] = soft_delete
            __props__.__dict__["actions"] = None
            __props__.__dict__["api_version"] = None
            __props__.__dict__["app_summaries"] = None
            __props__.__dict__["spec"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["vms"] = None
        super(SelfServiceAppProvision, __self__).__init__(
            'nutanix:index/selfServiceAppProvision:SelfServiceAppProvision',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[_builtins.str]] = None,
            actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SelfServiceAppProvisionActionArgs', 'SelfServiceAppProvisionActionArgsDict']]]]] = None,
            api_version: Optional[pulumi.Input[_builtins.str]] = None,
            app_description: Optional[pulumi.Input[_builtins.str]] = None,
            app_name: Optional[pulumi.Input[_builtins.str]] = None,
            app_summaries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SelfServiceAppProvisionAppSummaryArgs', 'SelfServiceAppProvisionAppSummaryArgsDict']]]]] = None,
            bp_name: Optional[pulumi.Input[_builtins.str]] = None,
            bp_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            runtime_editables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SelfServiceAppProvisionRuntimeEditableArgs', 'SelfServiceAppProvisionRuntimeEditableArgsDict']]]]] = None,
            soft_delete: Optional[pulumi.Input[_builtins.bool]] = None,
            spec: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            vms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SelfServiceAppProvisionVmArgs', 'SelfServiceAppProvisionVmArgsDict']]]]] = None) -> 'SelfServiceAppProvision':
        """
        Get an existing SelfServiceAppProvision resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: - (Optional) System action to trigger after provisioning. Valid values: ["start", "stop", "restart"]
        :param pulumi.Input[_builtins.str] api_version: - (Computed) API version used.
        :param pulumi.Input[_builtins.str] app_description: - (Optional) The description of application.
               
               Both are `bp_name` and `bp_uuid` are optional but atleast one of them to be provided for this resource to work.
        :param pulumi.Input[_builtins.str] app_name: - (Required) The name of the application you want to set.
        :param pulumi.Input[_builtins.str] bp_name: - (Optional) The name of the blueprint to launch.
        :param pulumi.Input[_builtins.str] bp_uuid: - (Optional) The UUID of the blueprint to launch.
        :param pulumi.Input[_builtins.bool] soft_delete: - (Optional, Default: false) If true, the application is soft-deleted when the resource is destroyed.
        :param pulumi.Input[_builtins.str] spec: - (Computed) Application specification (JSON string).
        :param pulumi.Input[_builtins.str] state: - (Computed) state of the application (e.g. running, stopped)
        :param pulumi.Input[_builtins.str] status: - (Computed) Application status coming as response from server.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SelfServiceAppProvisionState.__new__(_SelfServiceAppProvisionState)

        __props__.__dict__["action"] = action
        __props__.__dict__["actions"] = actions
        __props__.__dict__["api_version"] = api_version
        __props__.__dict__["app_description"] = app_description
        __props__.__dict__["app_name"] = app_name
        __props__.__dict__["app_summaries"] = app_summaries
        __props__.__dict__["bp_name"] = bp_name
        __props__.__dict__["bp_uuid"] = bp_uuid
        __props__.__dict__["runtime_editables"] = runtime_editables
        __props__.__dict__["soft_delete"] = soft_delete
        __props__.__dict__["spec"] = spec
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["vms"] = vms
        return SelfServiceAppProvision(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - (Optional) System action to trigger after provisioning. Valid values: ["start", "stop", "restart"]
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def actions(self) -> pulumi.Output[Sequence['outputs.SelfServiceAppProvisionAction']]:
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> pulumi.Output[_builtins.str]:
        """
        - (Computed) API version used.
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter(name="appDescription")
    def app_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - (Optional) The description of application.

        Both are `bp_name` and `bp_uuid` are optional but atleast one of them to be provided for this resource to work.
        """
        return pulumi.get(self, "app_description")

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Output[_builtins.str]:
        """
        - (Required) The name of the application you want to set.
        """
        return pulumi.get(self, "app_name")

    @_builtins.property
    @pulumi.getter(name="appSummaries")
    def app_summaries(self) -> pulumi.Output[Sequence['outputs.SelfServiceAppProvisionAppSummary']]:
        return pulumi.get(self, "app_summaries")

    @_builtins.property
    @pulumi.getter(name="bpName")
    def bp_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - (Optional) The name of the blueprint to launch.
        """
        return pulumi.get(self, "bp_name")

    @_builtins.property
    @pulumi.getter(name="bpUuid")
    def bp_uuid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - (Optional) The UUID of the blueprint to launch.
        """
        return pulumi.get(self, "bp_uuid")

    @_builtins.property
    @pulumi.getter(name="runtimeEditables")
    def runtime_editables(self) -> pulumi.Output[Optional[Sequence['outputs.SelfServiceAppProvisionRuntimeEditable']]]:
        return pulumi.get(self, "runtime_editables")

    @_builtins.property
    @pulumi.getter(name="softDelete")
    def soft_delete(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional, Default: false) If true, the application is soft-deleted when the resource is destroyed.
        """
        return pulumi.get(self, "soft_delete")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> pulumi.Output[_builtins.str]:
        """
        - (Computed) Application specification (JSON string).
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        - (Computed) state of the application (e.g. running, stopped)
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        - (Computed) Application status coming as response from server.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def vms(self) -> pulumi.Output[Sequence['outputs.SelfServiceAppProvisionVm']]:
        return pulumi.get(self, "vms")

