# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SelfServiceAppRecoveryPointArgs', 'SelfServiceAppRecoveryPoint']

@pulumi.input_type
class SelfServiceAppRecoveryPointArgs:
    def __init__(__self__, *,
                 action_name: pulumi.Input[_builtins.str],
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_point_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SelfServiceAppRecoveryPoint resource.
        :param pulumi.Input[_builtins.str] action_name: - (Required) The name of the snapshot action to trigger.
        :param pulumi.Input[_builtins.str] app_name: - (Optional) The name of the application
        :param pulumi.Input[_builtins.str] app_uuid: - (Required) The UUID of the application.
               
               Both (`app_name` and `app_uuid`) are optional but atleast one of them should be provided for resource to work.
        :param pulumi.Input[_builtins.str] recovery_point_name: - (Required) The name of recovery point.
        """
        pulumi.set(__self__, "action_name", action_name)
        if app_name is not None:
            pulumi.set(__self__, "app_name", app_name)
        if app_uuid is not None:
            pulumi.set(__self__, "app_uuid", app_uuid)
        if recovery_point_name is not None:
            pulumi.set(__self__, "recovery_point_name", recovery_point_name)

    @_builtins.property
    @pulumi.getter(name="actionName")
    def action_name(self) -> pulumi.Input[_builtins.str]:
        """
        - (Required) The name of the snapshot action to trigger.
        """
        return pulumi.get(self, "action_name")

    @action_name.setter
    def action_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action_name", value)

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The name of the application
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_name", value)

    @_builtins.property
    @pulumi.getter(name="appUuid")
    def app_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) The UUID of the application.

        Both (`app_name` and `app_uuid`) are optional but atleast one of them should be provided for resource to work.
        """
        return pulumi.get(self, "app_uuid")

    @app_uuid.setter
    def app_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_uuid", value)

    @_builtins.property
    @pulumi.getter(name="recoveryPointName")
    def recovery_point_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) The name of recovery point.
        """
        return pulumi.get(self, "recovery_point_name")

    @recovery_point_name.setter
    def recovery_point_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recovery_point_name", value)


@pulumi.input_type
class _SelfServiceAppRecoveryPointState:
    def __init__(__self__, *,
                 action_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_point_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SelfServiceAppRecoveryPoint resources.
        :param pulumi.Input[_builtins.str] action_name: - (Required) The name of the snapshot action to trigger.
        :param pulumi.Input[_builtins.str] app_name: - (Optional) The name of the application
        :param pulumi.Input[_builtins.str] app_uuid: - (Required) The UUID of the application.
               
               Both (`app_name` and `app_uuid`) are optional but atleast one of them should be provided for resource to work.
        :param pulumi.Input[_builtins.str] recovery_point_name: - (Required) The name of recovery point.
        """
        if action_name is not None:
            pulumi.set(__self__, "action_name", action_name)
        if app_name is not None:
            pulumi.set(__self__, "app_name", app_name)
        if app_uuid is not None:
            pulumi.set(__self__, "app_uuid", app_uuid)
        if recovery_point_name is not None:
            pulumi.set(__self__, "recovery_point_name", recovery_point_name)

    @_builtins.property
    @pulumi.getter(name="actionName")
    def action_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) The name of the snapshot action to trigger.
        """
        return pulumi.get(self, "action_name")

    @action_name.setter
    def action_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action_name", value)

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The name of the application
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_name", value)

    @_builtins.property
    @pulumi.getter(name="appUuid")
    def app_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) The UUID of the application.

        Both (`app_name` and `app_uuid`) are optional but atleast one of them should be provided for resource to work.
        """
        return pulumi.get(self, "app_uuid")

    @app_uuid.setter
    def app_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_uuid", value)

    @_builtins.property
    @pulumi.getter(name="recoveryPointName")
    def recovery_point_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) The name of recovery point.
        """
        return pulumi.get(self, "recovery_point_name")

    @recovery_point_name.setter
    def recovery_point_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recovery_point_name", value)


@pulumi.type_token("nutanix:index/selfServiceAppRecoveryPoint:SelfServiceAppRecoveryPoint")
class SelfServiceAppRecoveryPoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_point_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Run snapshot action in application to create recovery point.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        test = nutanix.SelfServiceAppRecoveryPoint("test",
            app_name="NAME OF APPLICATION",
            action_name="SNAPSHOT ACTION NAME",
            recovery_point_name="RECOVERY POINT NAME")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action_name: - (Required) The name of the snapshot action to trigger.
        :param pulumi.Input[_builtins.str] app_name: - (Optional) The name of the application
        :param pulumi.Input[_builtins.str] app_uuid: - (Required) The UUID of the application.
               
               Both (`app_name` and `app_uuid`) are optional but atleast one of them should be provided for resource to work.
        :param pulumi.Input[_builtins.str] recovery_point_name: - (Required) The name of recovery point.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SelfServiceAppRecoveryPointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Run snapshot action in application to create recovery point.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        test = nutanix.SelfServiceAppRecoveryPoint("test",
            app_name="NAME OF APPLICATION",
            action_name="SNAPSHOT ACTION NAME",
            recovery_point_name="RECOVERY POINT NAME")
        ```

        :param str resource_name: The name of the resource.
        :param SelfServiceAppRecoveryPointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SelfServiceAppRecoveryPointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_point_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SelfServiceAppRecoveryPointArgs.__new__(SelfServiceAppRecoveryPointArgs)

            if action_name is None and not opts.urn:
                raise TypeError("Missing required property 'action_name'")
            __props__.__dict__["action_name"] = action_name
            __props__.__dict__["app_name"] = app_name
            __props__.__dict__["app_uuid"] = app_uuid
            __props__.__dict__["recovery_point_name"] = recovery_point_name
        super(SelfServiceAppRecoveryPoint, __self__).__init__(
            'nutanix:index/selfServiceAppRecoveryPoint:SelfServiceAppRecoveryPoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action_name: Optional[pulumi.Input[_builtins.str]] = None,
            app_name: Optional[pulumi.Input[_builtins.str]] = None,
            app_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            recovery_point_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'SelfServiceAppRecoveryPoint':
        """
        Get an existing SelfServiceAppRecoveryPoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action_name: - (Required) The name of the snapshot action to trigger.
        :param pulumi.Input[_builtins.str] app_name: - (Optional) The name of the application
        :param pulumi.Input[_builtins.str] app_uuid: - (Required) The UUID of the application.
               
               Both (`app_name` and `app_uuid`) are optional but atleast one of them should be provided for resource to work.
        :param pulumi.Input[_builtins.str] recovery_point_name: - (Required) The name of recovery point.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SelfServiceAppRecoveryPointState.__new__(_SelfServiceAppRecoveryPointState)

        __props__.__dict__["action_name"] = action_name
        __props__.__dict__["app_name"] = app_name
        __props__.__dict__["app_uuid"] = app_uuid
        __props__.__dict__["recovery_point_name"] = recovery_point_name
        return SelfServiceAppRecoveryPoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="actionName")
    def action_name(self) -> pulumi.Output[_builtins.str]:
        """
        - (Required) The name of the snapshot action to trigger.
        """
        return pulumi.get(self, "action_name")

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - (Optional) The name of the application
        """
        return pulumi.get(self, "app_name")

    @_builtins.property
    @pulumi.getter(name="appUuid")
    def app_uuid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - (Required) The UUID of the application.

        Both (`app_name` and `app_uuid`) are optional but atleast one of them should be provided for resource to work.
        """
        return pulumi.get(self, "app_uuid")

    @_builtins.property
    @pulumi.getter(name="recoveryPointName")
    def recovery_point_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - (Required) The name of recovery point.
        """
        return pulumi.get(self, "recovery_point_name")

