# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SelfServiceAppRestoreArgs', 'SelfServiceAppRestore']

@pulumi.input_type
class SelfServiceAppRestoreArgs:
    def __init__(__self__, *,
                 restore_action_name: pulumi.Input[_builtins.str],
                 snapshot_uuid: pulumi.Input[_builtins.str],
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SelfServiceAppRestore resource.
        :param pulumi.Input[_builtins.str] restore_action_name: - (Required) The name of the restore action to be performed.
        :param pulumi.Input[_builtins.str] snapshot_uuid: - (Required) The UUID of the snapshot to which the application will be restored.
               
               Both (`app_name` and `app_uuid`) are optional but atleast one of them should be provided for resource to work.
        :param pulumi.Input[_builtins.str] app_name: - (Optional) The name of the application
        :param pulumi.Input[_builtins.str] app_uuid: - (Optional) The UUID of the application.
        """
        pulumi.set(__self__, "restore_action_name", restore_action_name)
        pulumi.set(__self__, "snapshot_uuid", snapshot_uuid)
        if app_name is not None:
            pulumi.set(__self__, "app_name", app_name)
        if app_uuid is not None:
            pulumi.set(__self__, "app_uuid", app_uuid)

    @_builtins.property
    @pulumi.getter(name="restoreActionName")
    def restore_action_name(self) -> pulumi.Input[_builtins.str]:
        """
        - (Required) The name of the restore action to be performed.
        """
        return pulumi.get(self, "restore_action_name")

    @restore_action_name.setter
    def restore_action_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "restore_action_name", value)

    @_builtins.property
    @pulumi.getter(name="snapshotUuid")
    def snapshot_uuid(self) -> pulumi.Input[_builtins.str]:
        """
        - (Required) The UUID of the snapshot to which the application will be restored.

        Both (`app_name` and `app_uuid`) are optional but atleast one of them should be provided for resource to work.
        """
        return pulumi.get(self, "snapshot_uuid")

    @snapshot_uuid.setter
    def snapshot_uuid(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "snapshot_uuid", value)

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The name of the application
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_name", value)

    @_builtins.property
    @pulumi.getter(name="appUuid")
    def app_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The UUID of the application.
        """
        return pulumi.get(self, "app_uuid")

    @app_uuid.setter
    def app_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_uuid", value)


@pulumi.input_type
class _SelfServiceAppRestoreState:
    def __init__(__self__, *,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_action_name: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SelfServiceAppRestore resources.
        :param pulumi.Input[_builtins.str] app_name: - (Optional) The name of the application
        :param pulumi.Input[_builtins.str] app_uuid: - (Optional) The UUID of the application.
        :param pulumi.Input[_builtins.str] restore_action_name: - (Required) The name of the restore action to be performed.
        :param pulumi.Input[_builtins.str] snapshot_uuid: - (Required) The UUID of the snapshot to which the application will be restored.
               
               Both (`app_name` and `app_uuid`) are optional but atleast one of them should be provided for resource to work.
        :param pulumi.Input[_builtins.str] state: - (Computed) This will be set after the restore action has been processed.
        """
        if app_name is not None:
            pulumi.set(__self__, "app_name", app_name)
        if app_uuid is not None:
            pulumi.set(__self__, "app_uuid", app_uuid)
        if restore_action_name is not None:
            pulumi.set(__self__, "restore_action_name", restore_action_name)
        if snapshot_uuid is not None:
            pulumi.set(__self__, "snapshot_uuid", snapshot_uuid)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The name of the application
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_name", value)

    @_builtins.property
    @pulumi.getter(name="appUuid")
    def app_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The UUID of the application.
        """
        return pulumi.get(self, "app_uuid")

    @app_uuid.setter
    def app_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_uuid", value)

    @_builtins.property
    @pulumi.getter(name="restoreActionName")
    def restore_action_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) The name of the restore action to be performed.
        """
        return pulumi.get(self, "restore_action_name")

    @restore_action_name.setter
    def restore_action_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restore_action_name", value)

    @_builtins.property
    @pulumi.getter(name="snapshotUuid")
    def snapshot_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) The UUID of the snapshot to which the application will be restored.

        Both (`app_name` and `app_uuid`) are optional but atleast one of them should be provided for resource to work.
        """
        return pulumi.get(self, "snapshot_uuid")

    @snapshot_uuid.setter
    def snapshot_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_uuid", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Computed) This will be set after the restore action has been processed.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("nutanix:index/selfServiceAppRestore:SelfServiceAppRestore")
class SelfServiceAppRestore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_action_name: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Run restore action in application to restore from recovery point.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        test = nutanix.SelfServiceAppRecoveryPoint("test",
            app_name="NAME OF APPLICATION",
            action_name="SNAPSHOT ACTION NAME",
            recovery_point_name="RECOVERY POINT NAME")
        # Read available recovery points in app
        snapshots = nutanix.get_self_service_app_snapshots(app_name="NAME OF APPLICATION",
            length=250,
            offset=0)
        snapshot_uuid = [snapshot.uuid for snapshot in snapshots.entities if snapshot.name == "SNAPSHOT ACTION NAME"][0]
        # Restore from recovery point
        test_self_service_app_restore = nutanix.SelfServiceAppRestore("test",
            restore_action_name="RESTORE ACTION NAME",
            app_name="NAME OF APPLICATION",
            snapshot_uuid=snapshot_uuid)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_name: - (Optional) The name of the application
        :param pulumi.Input[_builtins.str] app_uuid: - (Optional) The UUID of the application.
        :param pulumi.Input[_builtins.str] restore_action_name: - (Required) The name of the restore action to be performed.
        :param pulumi.Input[_builtins.str] snapshot_uuid: - (Required) The UUID of the snapshot to which the application will be restored.
               
               Both (`app_name` and `app_uuid`) are optional but atleast one of them should be provided for resource to work.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SelfServiceAppRestoreArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Run restore action in application to restore from recovery point.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        test = nutanix.SelfServiceAppRecoveryPoint("test",
            app_name="NAME OF APPLICATION",
            action_name="SNAPSHOT ACTION NAME",
            recovery_point_name="RECOVERY POINT NAME")
        # Read available recovery points in app
        snapshots = nutanix.get_self_service_app_snapshots(app_name="NAME OF APPLICATION",
            length=250,
            offset=0)
        snapshot_uuid = [snapshot.uuid for snapshot in snapshots.entities if snapshot.name == "SNAPSHOT ACTION NAME"][0]
        # Restore from recovery point
        test_self_service_app_restore = nutanix.SelfServiceAppRestore("test",
            restore_action_name="RESTORE ACTION NAME",
            app_name="NAME OF APPLICATION",
            snapshot_uuid=snapshot_uuid)
        ```

        :param str resource_name: The name of the resource.
        :param SelfServiceAppRestoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SelfServiceAppRestoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_action_name: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SelfServiceAppRestoreArgs.__new__(SelfServiceAppRestoreArgs)

            __props__.__dict__["app_name"] = app_name
            __props__.__dict__["app_uuid"] = app_uuid
            if restore_action_name is None and not opts.urn:
                raise TypeError("Missing required property 'restore_action_name'")
            __props__.__dict__["restore_action_name"] = restore_action_name
            if snapshot_uuid is None and not opts.urn:
                raise TypeError("Missing required property 'snapshot_uuid'")
            __props__.__dict__["snapshot_uuid"] = snapshot_uuid
            __props__.__dict__["state"] = None
        super(SelfServiceAppRestore, __self__).__init__(
            'nutanix:index/selfServiceAppRestore:SelfServiceAppRestore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_name: Optional[pulumi.Input[_builtins.str]] = None,
            app_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            restore_action_name: Optional[pulumi.Input[_builtins.str]] = None,
            snapshot_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None) -> 'SelfServiceAppRestore':
        """
        Get an existing SelfServiceAppRestore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_name: - (Optional) The name of the application
        :param pulumi.Input[_builtins.str] app_uuid: - (Optional) The UUID of the application.
        :param pulumi.Input[_builtins.str] restore_action_name: - (Required) The name of the restore action to be performed.
        :param pulumi.Input[_builtins.str] snapshot_uuid: - (Required) The UUID of the snapshot to which the application will be restored.
               
               Both (`app_name` and `app_uuid`) are optional but atleast one of them should be provided for resource to work.
        :param pulumi.Input[_builtins.str] state: - (Computed) This will be set after the restore action has been processed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SelfServiceAppRestoreState.__new__(_SelfServiceAppRestoreState)

        __props__.__dict__["app_name"] = app_name
        __props__.__dict__["app_uuid"] = app_uuid
        __props__.__dict__["restore_action_name"] = restore_action_name
        __props__.__dict__["snapshot_uuid"] = snapshot_uuid
        __props__.__dict__["state"] = state
        return SelfServiceAppRestore(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - (Optional) The name of the application
        """
        return pulumi.get(self, "app_name")

    @_builtins.property
    @pulumi.getter(name="appUuid")
    def app_uuid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - (Optional) The UUID of the application.
        """
        return pulumi.get(self, "app_uuid")

    @_builtins.property
    @pulumi.getter(name="restoreActionName")
    def restore_action_name(self) -> pulumi.Output[_builtins.str]:
        """
        - (Required) The name of the restore action to be performed.
        """
        return pulumi.get(self, "restore_action_name")

    @_builtins.property
    @pulumi.getter(name="snapshotUuid")
    def snapshot_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        - (Required) The UUID of the snapshot to which the application will be restored.

        Both (`app_name` and `app_uuid`) are optional but atleast one of them should be provided for resource to work.
        """
        return pulumi.get(self, "snapshot_uuid")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        - (Computed) This will be set after the restore action has been processed.
        """
        return pulumi.get(self, "state")

