# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceGroupArgs', 'ServiceGroup']

@pulumi.input_type
class ServiceGroupArgs:
    def __init__(__self__, *,
                 service_lists: pulumi.Input[Sequence[pulumi.Input['ServiceGroupServiceListArgs']]],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ServiceGroup resource.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceGroupServiceListArgs']]] service_lists: - (Required) list of services which have protocol (TCP / UDP / ICMP) along with port details
        :param pulumi.Input[_builtins.str] description: - (Optional) Description of the service group
        :param pulumi.Input[_builtins.str] name: - (Required) Name of the service group
        """
        pulumi.set(__self__, "service_lists", service_lists)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="serviceLists")
    def service_lists(self) -> pulumi.Input[Sequence[pulumi.Input['ServiceGroupServiceListArgs']]]:
        """
        - (Required) list of services which have protocol (TCP / UDP / ICMP) along with port details
        """
        return pulumi.get(self, "service_lists")

    @service_lists.setter
    def service_lists(self, value: pulumi.Input[Sequence[pulumi.Input['ServiceGroupServiceListArgs']]]):
        pulumi.set(self, "service_lists", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) Description of the service group
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) Name of the service group
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ServiceGroupState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceGroupServiceListArgs']]]] = None,
                 system_defined: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ServiceGroup resources.
        :param pulumi.Input[_builtins.str] description: - (Optional) Description of the service group
        :param pulumi.Input[_builtins.str] name: - (Required) Name of the service group
        :param pulumi.Input[Sequence[pulumi.Input['ServiceGroupServiceListArgs']]] service_lists: - (Required) list of services which have protocol (TCP / UDP / ICMP) along with port details
        :param pulumi.Input[_builtins.bool] system_defined: - (ReadOnly) boolean value to denote if the service group is system defined
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_lists is not None:
            pulumi.set(__self__, "service_lists", service_lists)
        if system_defined is not None:
            pulumi.set(__self__, "system_defined", system_defined)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) Description of the service group
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) Name of the service group
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="serviceLists")
    def service_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceGroupServiceListArgs']]]]:
        """
        - (Required) list of services which have protocol (TCP / UDP / ICMP) along with port details
        """
        return pulumi.get(self, "service_lists")

    @service_lists.setter
    def service_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceGroupServiceListArgs']]]]):
        pulumi.set(self, "service_lists", value)

    @_builtins.property
    @pulumi.getter(name="systemDefined")
    def system_defined(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (ReadOnly) boolean value to denote if the service group is system defined
        """
        return pulumi.get(self, "system_defined")

    @system_defined.setter
    def system_defined(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "system_defined", value)


@pulumi.type_token("nutanix:index/serviceGroup:ServiceGroup")
class ServiceGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceGroupServiceListArgs', 'ServiceGroupServiceListArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a resource to create a service group based on the input parameters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        test = nutanix.ServiceGroup("test",
            name="test_service_gp",
            description="this is service group",
            service_lists=[{
                "protocol": "TCP",
                "tcp_port_range_lists": [
                    {
                        "start_port": 22,
                        "end_port": 22,
                    },
                    {
                        "start_port": 2222,
                        "end_port": 2222,
                    },
                ],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: - (Optional) Description of the service group
        :param pulumi.Input[_builtins.str] name: - (Required) Name of the service group
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceGroupServiceListArgs', 'ServiceGroupServiceListArgsDict']]]] service_lists: - (Required) list of services which have protocol (TCP / UDP / ICMP) along with port details
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to create a service group based on the input parameters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        test = nutanix.ServiceGroup("test",
            name="test_service_gp",
            description="this is service group",
            service_lists=[{
                "protocol": "TCP",
                "tcp_port_range_lists": [
                    {
                        "start_port": 22,
                        "end_port": 22,
                    },
                    {
                        "start_port": 2222,
                        "end_port": 2222,
                    },
                ],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param ServiceGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceGroupServiceListArgs', 'ServiceGroupServiceListArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceGroupArgs.__new__(ServiceGroupArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if service_lists is None and not opts.urn:
                raise TypeError("Missing required property 'service_lists'")
            __props__.__dict__["service_lists"] = service_lists
            __props__.__dict__["system_defined"] = None
        super(ServiceGroup, __self__).__init__(
            'nutanix:index/serviceGroup:ServiceGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            service_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceGroupServiceListArgs', 'ServiceGroupServiceListArgsDict']]]]] = None,
            system_defined: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ServiceGroup':
        """
        Get an existing ServiceGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: - (Optional) Description of the service group
        :param pulumi.Input[_builtins.str] name: - (Required) Name of the service group
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceGroupServiceListArgs', 'ServiceGroupServiceListArgsDict']]]] service_lists: - (Required) list of services which have protocol (TCP / UDP / ICMP) along with port details
        :param pulumi.Input[_builtins.bool] system_defined: - (ReadOnly) boolean value to denote if the service group is system defined
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceGroupState.__new__(_ServiceGroupState)

        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["service_lists"] = service_lists
        __props__.__dict__["system_defined"] = system_defined
        return ServiceGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - (Optional) Description of the service group
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        - (Required) Name of the service group
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="serviceLists")
    def service_lists(self) -> pulumi.Output[Sequence['outputs.ServiceGroupServiceList']]:
        """
        - (Required) list of services which have protocol (TCP / UDP / ICMP) along with port details
        """
        return pulumi.get(self, "service_lists")

    @_builtins.property
    @pulumi.getter(name="systemDefined")
    def system_defined(self) -> pulumi.Output[_builtins.bool]:
        """
        - (ReadOnly) boolean value to denote if the service group is system defined
        """
        return pulumi.get(self, "system_defined")

