# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceGroupsV2Args', 'ServiceGroupsV2']

@pulumi.input_type
class ServiceGroupsV2Args:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 icmp_services: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2IcmpServiceArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tcp_services: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2TcpServiceArgs']]]] = None,
                 udp_services: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2UdpServiceArgs']]]] = None):
        """
        The set of arguments for constructing a ServiceGroupsV2 resource.
        :param pulumi.Input[_builtins.str] description: Description of the service group
        :param pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2IcmpServiceArgs']]] icmp_services: Icmp Type Code List.
        :param pulumi.Input[_builtins.str] name: Name of the service group
        :param pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2TcpServiceArgs']]] tcp_services: List of TCP ports in the service.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2UdpServiceArgs']]] udp_services: List of UDP ports in the service.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if icmp_services is not None:
            pulumi.set(__self__, "icmp_services", icmp_services)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tcp_services is not None:
            pulumi.set(__self__, "tcp_services", tcp_services)
        if udp_services is not None:
            pulumi.set(__self__, "udp_services", udp_services)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the service group
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="icmpServices")
    def icmp_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2IcmpServiceArgs']]]]:
        """
        Icmp Type Code List.
        """
        return pulumi.get(self, "icmp_services")

    @icmp_services.setter
    def icmp_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2IcmpServiceArgs']]]]):
        pulumi.set(self, "icmp_services", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the service group
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="tcpServices")
    def tcp_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2TcpServiceArgs']]]]:
        """
        List of TCP ports in the service.
        """
        return pulumi.get(self, "tcp_services")

    @tcp_services.setter
    def tcp_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2TcpServiceArgs']]]]):
        pulumi.set(self, "tcp_services", value)

    @_builtins.property
    @pulumi.getter(name="udpServices")
    def udp_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2UdpServiceArgs']]]]:
        """
        List of UDP ports in the service.
        """
        return pulumi.get(self, "udp_services")

    @udp_services.setter
    def udp_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2UdpServiceArgs']]]]):
        pulumi.set(self, "udp_services", value)


@pulumi.input_type
class _ServiceGroupsV2State:
    def __init__(__self__, *,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 icmp_services: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2IcmpServiceArgs']]]] = None,
                 is_system_defined: Optional[pulumi.Input[_builtins.bool]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2LinkArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_references: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tcp_services: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2TcpServiceArgs']]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 udp_services: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2UdpServiceArgs']]]] = None):
        """
        Input properties used for looking up and filtering ServiceGroupsV2 resources.
        :param pulumi.Input[_builtins.str] created_by: created by.
        :param pulumi.Input[_builtins.str] description: Description of the service group
        :param pulumi.Input[_builtins.str] ext_id: address group uuid.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2IcmpServiceArgs']]] icmp_services: Icmp Type Code List.
        :param pulumi.Input[_builtins.bool] is_system_defined: Service Group is system defined or not.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2LinkArgs']]] links: A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        :param pulumi.Input[_builtins.str] name: Name of the service group
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policy_references: Reference to policy associated with Address Group.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2TcpServiceArgs']]] tcp_services: List of TCP ports in the service.
        :param pulumi.Input[_builtins.str] tenant_id: A globally unique identifier that represents the tenant that owns this entity.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2UdpServiceArgs']]] udp_services: List of UDP ports in the service.
        """
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if icmp_services is not None:
            pulumi.set(__self__, "icmp_services", icmp_services)
        if is_system_defined is not None:
            pulumi.set(__self__, "is_system_defined", is_system_defined)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_references is not None:
            pulumi.set(__self__, "policy_references", policy_references)
        if tcp_services is not None:
            pulumi.set(__self__, "tcp_services", tcp_services)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if udp_services is not None:
            pulumi.set(__self__, "udp_services", udp_services)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        created by.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the service group
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        address group uuid.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="icmpServices")
    def icmp_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2IcmpServiceArgs']]]]:
        """
        Icmp Type Code List.
        """
        return pulumi.get(self, "icmp_services")

    @icmp_services.setter
    def icmp_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2IcmpServiceArgs']]]]):
        pulumi.set(self, "icmp_services", value)

    @_builtins.property
    @pulumi.getter(name="isSystemDefined")
    def is_system_defined(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Service Group is system defined or not.
        """
        return pulumi.get(self, "is_system_defined")

    @is_system_defined.setter
    def is_system_defined(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_system_defined", value)

    @_builtins.property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2LinkArgs']]]]:
        """
        A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2LinkArgs']]]]):
        pulumi.set(self, "links", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the service group
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="policyReferences")
    def policy_references(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Reference to policy associated with Address Group.
        """
        return pulumi.get(self, "policy_references")

    @policy_references.setter
    def policy_references(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "policy_references", value)

    @_builtins.property
    @pulumi.getter(name="tcpServices")
    def tcp_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2TcpServiceArgs']]]]:
        """
        List of TCP ports in the service.
        """
        return pulumi.get(self, "tcp_services")

    @tcp_services.setter
    def tcp_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2TcpServiceArgs']]]]):
        pulumi.set(self, "tcp_services", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A globally unique identifier that represents the tenant that owns this entity.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="udpServices")
    def udp_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2UdpServiceArgs']]]]:
        """
        List of UDP ports in the service.
        """
        return pulumi.get(self, "udp_services")

    @udp_services.setter
    def udp_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceGroupsV2UdpServiceArgs']]]]):
        pulumi.set(self, "udp_services", value)


@pulumi.type_token("nutanix:index/serviceGroupsV2:ServiceGroupsV2")
class ServiceGroupsV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 icmp_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceGroupsV2IcmpServiceArgs', 'ServiceGroupsV2IcmpServiceArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tcp_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceGroupsV2TcpServiceArgs', 'ServiceGroupsV2TcpServiceArgsDict']]]]] = None,
                 udp_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceGroupsV2UdpServiceArgs', 'ServiceGroupsV2UdpServiceArgsDict']]]]] = None,
                 __props__=None):
        """
        Create an service Group

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # Add Service  group. with TCP and UDP
        tcp_udp_service = nutanix.ServiceGroupsV2("tcp-udp-service",
            name="service_group_tcp_udp",
            description="service group description",
            tcp_services=[{
                "start_port": 232,
                "end_port": 232,
            }],
            udp_services=[{
                "start_port": 232,
                "end_port": 232,
            }])
        # service group with ICMP
        icmp_service = nutanix.ServiceGroupsV2("icmp-service",
            name="service_group_icmp",
            description="service group description",
            icmp_services=[{
                "type": 8,
                "code": 0,
            }])
        # service group with All TCP, UDP and ICMP
        all_service = nutanix.ServiceGroupsV2("all-service",
            name="service_group_udp_tcp_icmp",
            description="service group description",
            tcp_services=[{
                "start_port": 232,
                "end_port": 232,
            }],
            udp_services=[{
                "start_port": 232,
                "end_port": 232,
            }],
            icmp_services=[{
                "type": 8,
                "code": 0,
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the service group
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceGroupsV2IcmpServiceArgs', 'ServiceGroupsV2IcmpServiceArgsDict']]]] icmp_services: Icmp Type Code List.
        :param pulumi.Input[_builtins.str] name: Name of the service group
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceGroupsV2TcpServiceArgs', 'ServiceGroupsV2TcpServiceArgsDict']]]] tcp_services: List of TCP ports in the service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceGroupsV2UdpServiceArgs', 'ServiceGroupsV2UdpServiceArgsDict']]]] udp_services: List of UDP ports in the service.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ServiceGroupsV2Args] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create an service Group

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # Add Service  group. with TCP and UDP
        tcp_udp_service = nutanix.ServiceGroupsV2("tcp-udp-service",
            name="service_group_tcp_udp",
            description="service group description",
            tcp_services=[{
                "start_port": 232,
                "end_port": 232,
            }],
            udp_services=[{
                "start_port": 232,
                "end_port": 232,
            }])
        # service group with ICMP
        icmp_service = nutanix.ServiceGroupsV2("icmp-service",
            name="service_group_icmp",
            description="service group description",
            icmp_services=[{
                "type": 8,
                "code": 0,
            }])
        # service group with All TCP, UDP and ICMP
        all_service = nutanix.ServiceGroupsV2("all-service",
            name="service_group_udp_tcp_icmp",
            description="service group description",
            tcp_services=[{
                "start_port": 232,
                "end_port": 232,
            }],
            udp_services=[{
                "start_port": 232,
                "end_port": 232,
            }],
            icmp_services=[{
                "type": 8,
                "code": 0,
            }])
        ```

        :param str resource_name: The name of the resource.
        :param ServiceGroupsV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceGroupsV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 icmp_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceGroupsV2IcmpServiceArgs', 'ServiceGroupsV2IcmpServiceArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tcp_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceGroupsV2TcpServiceArgs', 'ServiceGroupsV2TcpServiceArgsDict']]]]] = None,
                 udp_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceGroupsV2UdpServiceArgs', 'ServiceGroupsV2UdpServiceArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceGroupsV2Args.__new__(ServiceGroupsV2Args)

            __props__.__dict__["description"] = description
            __props__.__dict__["icmp_services"] = icmp_services
            __props__.__dict__["name"] = name
            __props__.__dict__["tcp_services"] = tcp_services
            __props__.__dict__["udp_services"] = udp_services
            __props__.__dict__["created_by"] = None
            __props__.__dict__["ext_id"] = None
            __props__.__dict__["is_system_defined"] = None
            __props__.__dict__["links"] = None
            __props__.__dict__["policy_references"] = None
            __props__.__dict__["tenant_id"] = None
        super(ServiceGroupsV2, __self__).__init__(
            'nutanix:index/serviceGroupsV2:ServiceGroupsV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            icmp_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceGroupsV2IcmpServiceArgs', 'ServiceGroupsV2IcmpServiceArgsDict']]]]] = None,
            is_system_defined: Optional[pulumi.Input[_builtins.bool]] = None,
            links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceGroupsV2LinkArgs', 'ServiceGroupsV2LinkArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            policy_references: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tcp_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceGroupsV2TcpServiceArgs', 'ServiceGroupsV2TcpServiceArgsDict']]]]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            udp_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceGroupsV2UdpServiceArgs', 'ServiceGroupsV2UdpServiceArgsDict']]]]] = None) -> 'ServiceGroupsV2':
        """
        Get an existing ServiceGroupsV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_by: created by.
        :param pulumi.Input[_builtins.str] description: Description of the service group
        :param pulumi.Input[_builtins.str] ext_id: address group uuid.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceGroupsV2IcmpServiceArgs', 'ServiceGroupsV2IcmpServiceArgsDict']]]] icmp_services: Icmp Type Code List.
        :param pulumi.Input[_builtins.bool] is_system_defined: Service Group is system defined or not.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceGroupsV2LinkArgs', 'ServiceGroupsV2LinkArgsDict']]]] links: A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        :param pulumi.Input[_builtins.str] name: Name of the service group
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policy_references: Reference to policy associated with Address Group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceGroupsV2TcpServiceArgs', 'ServiceGroupsV2TcpServiceArgsDict']]]] tcp_services: List of TCP ports in the service.
        :param pulumi.Input[_builtins.str] tenant_id: A globally unique identifier that represents the tenant that owns this entity.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceGroupsV2UdpServiceArgs', 'ServiceGroupsV2UdpServiceArgsDict']]]] udp_services: List of UDP ports in the service.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceGroupsV2State.__new__(_ServiceGroupsV2State)

        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["description"] = description
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["icmp_services"] = icmp_services
        __props__.__dict__["is_system_defined"] = is_system_defined
        __props__.__dict__["links"] = links
        __props__.__dict__["name"] = name
        __props__.__dict__["policy_references"] = policy_references
        __props__.__dict__["tcp_services"] = tcp_services
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["udp_services"] = udp_services
        return ServiceGroupsV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        created by.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description of the service group
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        address group uuid.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="icmpServices")
    def icmp_services(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceGroupsV2IcmpService']]]:
        """
        Icmp Type Code List.
        """
        return pulumi.get(self, "icmp_services")

    @_builtins.property
    @pulumi.getter(name="isSystemDefined")
    def is_system_defined(self) -> pulumi.Output[_builtins.bool]:
        """
        Service Group is system defined or not.
        """
        return pulumi.get(self, "is_system_defined")

    @_builtins.property
    @pulumi.getter
    def links(self) -> pulumi.Output[Sequence['outputs.ServiceGroupsV2Link']]:
        """
        A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the service group
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="policyReferences")
    def policy_references(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Reference to policy associated with Address Group.
        """
        return pulumi.get(self, "policy_references")

    @_builtins.property
    @pulumi.getter(name="tcpServices")
    def tcp_services(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceGroupsV2TcpService']]]:
        """
        List of TCP ports in the service.
        """
        return pulumi.get(self, "tcp_services")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        A globally unique identifier that represents the tenant that owns this entity.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="udpServices")
    def udp_services(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceGroupsV2UdpService']]]:
        """
        List of UDP ports in the service.
        """
        return pulumi.get(self, "udp_services")

