# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StaticRoutesArgs', 'StaticRoutes']

@pulumi.input_type
class StaticRoutesArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 default_route_nexthops: Optional[pulumi.Input[Sequence[pulumi.Input['StaticRoutesDefaultRouteNexthopArgs']]]] = None,
                 static_routes_lists: Optional[pulumi.Input[Sequence[pulumi.Input['StaticRoutesStaticRoutesListArgs']]]] = None,
                 vpc_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a StaticRoutes resource.
        :param pulumi.Input[_builtins.str] api_version: The version of the API.
        :param pulumi.Input[Sequence[pulumi.Input['StaticRoutesDefaultRouteNexthopArgs']]] default_route_nexthops: Default Route
        :param pulumi.Input[Sequence[pulumi.Input['StaticRoutesStaticRoutesListArgs']]] static_routes_lists: Static Routes.
        :param pulumi.Input[_builtins.str] vpc_name: vpc Name. Should not be used with vpc_uuid.
        :param pulumi.Input[_builtins.str] vpc_uuid: Reference to a VPC UUID. Should not be used with vpc_name.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if default_route_nexthops is not None:
            pulumi.set(__self__, "default_route_nexthops", default_route_nexthops)
        if static_routes_lists is not None:
            pulumi.set(__self__, "static_routes_lists", static_routes_lists)
        if vpc_name is not None:
            pulumi.set(__self__, "vpc_name", vpc_name)
        if vpc_uuid is not None:
            pulumi.set(__self__, "vpc_uuid", vpc_uuid)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the API.
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter(name="defaultRouteNexthops")
    def default_route_nexthops(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StaticRoutesDefaultRouteNexthopArgs']]]]:
        """
        Default Route
        """
        return pulumi.get(self, "default_route_nexthops")

    @default_route_nexthops.setter
    def default_route_nexthops(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StaticRoutesDefaultRouteNexthopArgs']]]]):
        pulumi.set(self, "default_route_nexthops", value)

    @_builtins.property
    @pulumi.getter(name="staticRoutesLists")
    def static_routes_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StaticRoutesStaticRoutesListArgs']]]]:
        """
        Static Routes.
        """
        return pulumi.get(self, "static_routes_lists")

    @static_routes_lists.setter
    def static_routes_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StaticRoutesStaticRoutesListArgs']]]]):
        pulumi.set(self, "static_routes_lists", value)

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        vpc Name. Should not be used with vpc_uuid.
        """
        return pulumi.get(self, "vpc_name")

    @vpc_name.setter
    def vpc_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_name", value)

    @_builtins.property
    @pulumi.getter(name="vpcUuid")
    def vpc_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reference to a VPC UUID. Should not be used with vpc_name.
        """
        return pulumi.get(self, "vpc_uuid")

    @vpc_uuid.setter
    def vpc_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_uuid", value)


@pulumi.input_type
class _StaticRoutesState:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 default_route_nexthops: Optional[pulumi.Input[Sequence[pulumi.Input['StaticRoutesDefaultRouteNexthopArgs']]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 static_routes_lists: Optional[pulumi.Input[Sequence[pulumi.Input['StaticRoutesStaticRoutesListArgs']]]] = None,
                 vpc_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering StaticRoutes resources.
        :param pulumi.Input[_builtins.str] api_version: The version of the API.
        :param pulumi.Input[Sequence[pulumi.Input['StaticRoutesDefaultRouteNexthopArgs']]] default_route_nexthops: Default Route
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: The vpc_route_table kind metadata.
        :param pulumi.Input[Sequence[pulumi.Input['StaticRoutesStaticRoutesListArgs']]] static_routes_lists: Static Routes.
        :param pulumi.Input[_builtins.str] vpc_name: vpc Name. Should not be used with vpc_uuid.
        :param pulumi.Input[_builtins.str] vpc_uuid: Reference to a VPC UUID. Should not be used with vpc_name.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if default_route_nexthops is not None:
            pulumi.set(__self__, "default_route_nexthops", default_route_nexthops)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if static_routes_lists is not None:
            pulumi.set(__self__, "static_routes_lists", static_routes_lists)
        if vpc_name is not None:
            pulumi.set(__self__, "vpc_name", vpc_name)
        if vpc_uuid is not None:
            pulumi.set(__self__, "vpc_uuid", vpc_uuid)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the API.
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter(name="defaultRouteNexthops")
    def default_route_nexthops(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StaticRoutesDefaultRouteNexthopArgs']]]]:
        """
        Default Route
        """
        return pulumi.get(self, "default_route_nexthops")

    @default_route_nexthops.setter
    def default_route_nexthops(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StaticRoutesDefaultRouteNexthopArgs']]]]):
        pulumi.set(self, "default_route_nexthops", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The vpc_route_table kind metadata.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="staticRoutesLists")
    def static_routes_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StaticRoutesStaticRoutesListArgs']]]]:
        """
        Static Routes.
        """
        return pulumi.get(self, "static_routes_lists")

    @static_routes_lists.setter
    def static_routes_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StaticRoutesStaticRoutesListArgs']]]]):
        pulumi.set(self, "static_routes_lists", value)

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        vpc Name. Should not be used with vpc_uuid.
        """
        return pulumi.get(self, "vpc_name")

    @vpc_name.setter
    def vpc_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_name", value)

    @_builtins.property
    @pulumi.getter(name="vpcUuid")
    def vpc_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reference to a VPC UUID. Should not be used with vpc_name.
        """
        return pulumi.get(self, "vpc_uuid")

    @vpc_uuid.setter
    def vpc_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_uuid", value)


@pulumi.type_token("nutanix:index/staticRoutes:StaticRoutes")
class StaticRoutes(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 default_route_nexthops: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StaticRoutesDefaultRouteNexthopArgs', 'StaticRoutesDefaultRouteNexthopArgsDict']]]]] = None,
                 static_routes_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StaticRoutesStaticRoutesListArgs', 'StaticRoutesStaticRoutesListArgsDict']]]]] = None,
                 vpc_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides Nutanix resource to create Static Routes within VPCs.

        ## create one static route for vpc uuid with external subnet

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        scn = nutanix.StaticRoutes("scn",
            vpc_uuid="{{vpc_uuid}}",
            static_routes_lists=[{
                "destination": "10.x.x.x/x",
                "external_subnet_reference_uuid": "{{ext_subnet_uuid}}",
            }])
        ```

        ## create one static route with default route for vpc name with external subnet

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        scn = nutanix.StaticRoutes("scn",
            vpc_name="{{vpc_name}}",
            static_routes_lists=[{
                "destination": "10.x.x.x/x",
                "external_subnet_reference_uuid": "{{ext_subnet_uuid}}",
            }],
            default_route_nexthops=[{
                "external_subnet_reference_uuid": "{{ext_subnet_uuid}}",
            }])
        ```

        #### Note: destination with 0.0.0.0/0 will be default route.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_version: The version of the API.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StaticRoutesDefaultRouteNexthopArgs', 'StaticRoutesDefaultRouteNexthopArgsDict']]]] default_route_nexthops: Default Route
        :param pulumi.Input[Sequence[pulumi.Input[Union['StaticRoutesStaticRoutesListArgs', 'StaticRoutesStaticRoutesListArgsDict']]]] static_routes_lists: Static Routes.
        :param pulumi.Input[_builtins.str] vpc_name: vpc Name. Should not be used with vpc_uuid.
        :param pulumi.Input[_builtins.str] vpc_uuid: Reference to a VPC UUID. Should not be used with vpc_name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[StaticRoutesArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides Nutanix resource to create Static Routes within VPCs.

        ## create one static route for vpc uuid with external subnet

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        scn = nutanix.StaticRoutes("scn",
            vpc_uuid="{{vpc_uuid}}",
            static_routes_lists=[{
                "destination": "10.x.x.x/x",
                "external_subnet_reference_uuid": "{{ext_subnet_uuid}}",
            }])
        ```

        ## create one static route with default route for vpc name with external subnet

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        scn = nutanix.StaticRoutes("scn",
            vpc_name="{{vpc_name}}",
            static_routes_lists=[{
                "destination": "10.x.x.x/x",
                "external_subnet_reference_uuid": "{{ext_subnet_uuid}}",
            }],
            default_route_nexthops=[{
                "external_subnet_reference_uuid": "{{ext_subnet_uuid}}",
            }])
        ```

        #### Note: destination with 0.0.0.0/0 will be default route.

        :param str resource_name: The name of the resource.
        :param StaticRoutesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StaticRoutesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 default_route_nexthops: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StaticRoutesDefaultRouteNexthopArgs', 'StaticRoutesDefaultRouteNexthopArgsDict']]]]] = None,
                 static_routes_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StaticRoutesStaticRoutesListArgs', 'StaticRoutesStaticRoutesListArgsDict']]]]] = None,
                 vpc_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StaticRoutesArgs.__new__(StaticRoutesArgs)

            __props__.__dict__["api_version"] = api_version
            __props__.__dict__["default_route_nexthops"] = default_route_nexthops
            __props__.__dict__["static_routes_lists"] = static_routes_lists
            __props__.__dict__["vpc_name"] = vpc_name
            __props__.__dict__["vpc_uuid"] = vpc_uuid
            __props__.__dict__["metadata"] = None
        super(StaticRoutes, __self__).__init__(
            'nutanix:index/staticRoutes:StaticRoutes',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_version: Optional[pulumi.Input[_builtins.str]] = None,
            default_route_nexthops: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StaticRoutesDefaultRouteNexthopArgs', 'StaticRoutesDefaultRouteNexthopArgsDict']]]]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            static_routes_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StaticRoutesStaticRoutesListArgs', 'StaticRoutesStaticRoutesListArgsDict']]]]] = None,
            vpc_name: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_uuid: Optional[pulumi.Input[_builtins.str]] = None) -> 'StaticRoutes':
        """
        Get an existing StaticRoutes resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_version: The version of the API.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StaticRoutesDefaultRouteNexthopArgs', 'StaticRoutesDefaultRouteNexthopArgsDict']]]] default_route_nexthops: Default Route
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: The vpc_route_table kind metadata.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StaticRoutesStaticRoutesListArgs', 'StaticRoutesStaticRoutesListArgsDict']]]] static_routes_lists: Static Routes.
        :param pulumi.Input[_builtins.str] vpc_name: vpc Name. Should not be used with vpc_uuid.
        :param pulumi.Input[_builtins.str] vpc_uuid: Reference to a VPC UUID. Should not be used with vpc_name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StaticRoutesState.__new__(_StaticRoutesState)

        __props__.__dict__["api_version"] = api_version
        __props__.__dict__["default_route_nexthops"] = default_route_nexthops
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["static_routes_lists"] = static_routes_lists
        __props__.__dict__["vpc_name"] = vpc_name
        __props__.__dict__["vpc_uuid"] = vpc_uuid
        return StaticRoutes(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the API.
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter(name="defaultRouteNexthops")
    def default_route_nexthops(self) -> pulumi.Output[Optional[Sequence['outputs.StaticRoutesDefaultRouteNexthop']]]:
        """
        Default Route
        """
        return pulumi.get(self, "default_route_nexthops")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The vpc_route_table kind metadata.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter(name="staticRoutesLists")
    def static_routes_lists(self) -> pulumi.Output[Optional[Sequence['outputs.StaticRoutesStaticRoutesList']]]:
        """
        Static Routes.
        """
        return pulumi.get(self, "static_routes_lists")

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        vpc Name. Should not be used with vpc_uuid.
        """
        return pulumi.get(self, "vpc_name")

    @_builtins.property
    @pulumi.getter(name="vpcUuid")
    def vpc_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        Reference to a VPC UUID. Should not be used with vpc_name.
        """
        return pulumi.get(self, "vpc_uuid")

