# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StorageContainersV2Args', 'StorageContainersV2']

@pulumi.input_type
class StorageContainersV2Args:
    def __init__(__self__, *,
                 cluster_ext_id: pulumi.Input[_builtins.str],
                 affinity_host_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_deduplication: Optional[pulumi.Input[_builtins.str]] = None,
                 compression_delay_secs: Optional[pulumi.Input[_builtins.int]] = None,
                 container_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 erasure_code: Optional[pulumi.Input[_builtins.str]] = None,
                 erasure_code_delay_secs: Optional[pulumi.Input[_builtins.int]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 has_higher_ec_fault_domain_preference: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_small_files: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_compression_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_inline_ec_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_internal: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_software_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 logical_advertised_capacity_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 logical_explicit_reserved_capacity_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nfs_whitelist_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['StorageContainersV2NfsWhitelistAddressArgs']]]] = None,
                 on_disk_dedup: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_factor: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a StorageContainersV2 resource.
        :param pulumi.Input[_builtins.str] cluster_ext_id: - ext id for the cluster owning the storage container.
        :param pulumi.Input[_builtins.str] affinity_host_ext_id: -(Optional) Affinity host extId for RF 1 Storage Container.
        :param pulumi.Input[_builtins.str] cache_deduplication: -(Optional) Indicates the current status of Cache Deduplication for the Container. available values:  `NONE`,    `OFF`,    `ON`
        :param pulumi.Input[_builtins.int] compression_delay_secs: -(Optional) The compression delay in seconds.
        :param pulumi.Input[_builtins.str] container_ext_id: - the storage container ext id
        :param pulumi.Input[_builtins.str] erasure_code: -(Optional) Indicates the current status value for Erasure Coding for the Container. available values:  `NONE`,    `OFF`,    `ON`
        :param pulumi.Input[_builtins.int] erasure_code_delay_secs: -(Optional) Delay in performing ErasureCode for the current Container instance.
        :param pulumi.Input[_builtins.str] ext_id: - the storage container uuid
        :param pulumi.Input[_builtins.bool] has_higher_ec_fault_domain_preference: -(Optional) Indicates whether to prefer a higher Erasure Code fault domain.
        :param pulumi.Input[_builtins.bool] is_compression_enabled: -(Optional) Indicates whether the compression is enabled for the Container.
        :param pulumi.Input[_builtins.bool] is_inline_ec_enabled: -(Optional) Indicates whether data written to this container should be inline erasure coded or not. This field is only considered when ErasureCoding is enabled.
        :param pulumi.Input[_builtins.bool] is_internal: - Indicates whether the Container is internal and is managed by Nutanix.
        :param pulumi.Input[_builtins.bool] is_software_encryption_enabled: -(Optional) Indicates whether the Container instance has software encryption enabled.
        :param pulumi.Input[_builtins.int] logical_advertised_capacity_bytes: -(Optional) Max capacity of the Container as defined by the user.
        :param pulumi.Input[_builtins.int] logical_explicit_reserved_capacity_bytes: -(Optional) Total reserved size (in bytes) of the container (set by Admin). This also accounts for the container's replication factor. The actual reserved capacity of the container will be the maximum of explicitReservedCapacity and implicitReservedCapacity.
        :param pulumi.Input[_builtins.str] name: -(Required) Name of the storage container.  Note that the name of Storage Container should be unique per cluster.
        :param pulumi.Input[Sequence[pulumi.Input['StorageContainersV2NfsWhitelistAddressArgs']]] nfs_whitelist_addresses: -(Optional) List of NFS addresses which need to be whitelisted.
        :param pulumi.Input[_builtins.str] on_disk_dedup: - Indicates the current status of Disk Deduplication for the Container. available values:  `NONE`,    `OFF`,    `POST_PROCESS`
        :param pulumi.Input[_builtins.str] owner_ext_id: -(Optional) owner ext id
        :param pulumi.Input[_builtins.int] replication_factor: -(Optional) Replication factor of the Storage Container.
        """
        pulumi.set(__self__, "cluster_ext_id", cluster_ext_id)
        if affinity_host_ext_id is not None:
            pulumi.set(__self__, "affinity_host_ext_id", affinity_host_ext_id)
        if cache_deduplication is not None:
            pulumi.set(__self__, "cache_deduplication", cache_deduplication)
        if compression_delay_secs is not None:
            pulumi.set(__self__, "compression_delay_secs", compression_delay_secs)
        if container_ext_id is not None:
            pulumi.set(__self__, "container_ext_id", container_ext_id)
        if erasure_code is not None:
            pulumi.set(__self__, "erasure_code", erasure_code)
        if erasure_code_delay_secs is not None:
            pulumi.set(__self__, "erasure_code_delay_secs", erasure_code_delay_secs)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if has_higher_ec_fault_domain_preference is not None:
            pulumi.set(__self__, "has_higher_ec_fault_domain_preference", has_higher_ec_fault_domain_preference)
        if ignore_small_files is not None:
            pulumi.set(__self__, "ignore_small_files", ignore_small_files)
        if is_compression_enabled is not None:
            pulumi.set(__self__, "is_compression_enabled", is_compression_enabled)
        if is_inline_ec_enabled is not None:
            pulumi.set(__self__, "is_inline_ec_enabled", is_inline_ec_enabled)
        if is_internal is not None:
            pulumi.set(__self__, "is_internal", is_internal)
        if is_software_encryption_enabled is not None:
            pulumi.set(__self__, "is_software_encryption_enabled", is_software_encryption_enabled)
        if logical_advertised_capacity_bytes is not None:
            pulumi.set(__self__, "logical_advertised_capacity_bytes", logical_advertised_capacity_bytes)
        if logical_explicit_reserved_capacity_bytes is not None:
            pulumi.set(__self__, "logical_explicit_reserved_capacity_bytes", logical_explicit_reserved_capacity_bytes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nfs_whitelist_addresses is not None:
            pulumi.set(__self__, "nfs_whitelist_addresses", nfs_whitelist_addresses)
        if on_disk_dedup is not None:
            pulumi.set(__self__, "on_disk_dedup", on_disk_dedup)
        if owner_ext_id is not None:
            pulumi.set(__self__, "owner_ext_id", owner_ext_id)
        if replication_factor is not None:
            pulumi.set(__self__, "replication_factor", replication_factor)

    @_builtins.property
    @pulumi.getter(name="clusterExtId")
    def cluster_ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        - ext id for the cluster owning the storage container.
        """
        return pulumi.get(self, "cluster_ext_id")

    @cluster_ext_id.setter
    def cluster_ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="affinityHostExtId")
    def affinity_host_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Affinity host extId for RF 1 Storage Container.
        """
        return pulumi.get(self, "affinity_host_ext_id")

    @affinity_host_ext_id.setter
    def affinity_host_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "affinity_host_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="cacheDeduplication")
    def cache_deduplication(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Indicates the current status of Cache Deduplication for the Container. available values:  `NONE`,    `OFF`,    `ON`
        """
        return pulumi.get(self, "cache_deduplication")

    @cache_deduplication.setter
    def cache_deduplication(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_deduplication", value)

    @_builtins.property
    @pulumi.getter(name="compressionDelaySecs")
    def compression_delay_secs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        -(Optional) The compression delay in seconds.
        """
        return pulumi.get(self, "compression_delay_secs")

    @compression_delay_secs.setter
    def compression_delay_secs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "compression_delay_secs", value)

    @_builtins.property
    @pulumi.getter(name="containerExtId")
    def container_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - the storage container ext id
        """
        return pulumi.get(self, "container_ext_id")

    @container_ext_id.setter
    def container_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="erasureCode")
    def erasure_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Indicates the current status value for Erasure Coding for the Container. available values:  `NONE`,    `OFF`,    `ON`
        """
        return pulumi.get(self, "erasure_code")

    @erasure_code.setter
    def erasure_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "erasure_code", value)

    @_builtins.property
    @pulumi.getter(name="erasureCodeDelaySecs")
    def erasure_code_delay_secs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        -(Optional) Delay in performing ErasureCode for the current Container instance.
        """
        return pulumi.get(self, "erasure_code_delay_secs")

    @erasure_code_delay_secs.setter
    def erasure_code_delay_secs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "erasure_code_delay_secs", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - the storage container uuid
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="hasHigherEcFaultDomainPreference")
    def has_higher_ec_fault_domain_preference(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        -(Optional) Indicates whether to prefer a higher Erasure Code fault domain.
        """
        return pulumi.get(self, "has_higher_ec_fault_domain_preference")

    @has_higher_ec_fault_domain_preference.setter
    def has_higher_ec_fault_domain_preference(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "has_higher_ec_fault_domain_preference", value)

    @_builtins.property
    @pulumi.getter(name="ignoreSmallFiles")
    def ignore_small_files(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "ignore_small_files")

    @ignore_small_files.setter
    def ignore_small_files(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_small_files", value)

    @_builtins.property
    @pulumi.getter(name="isCompressionEnabled")
    def is_compression_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        -(Optional) Indicates whether the compression is enabled for the Container.
        """
        return pulumi.get(self, "is_compression_enabled")

    @is_compression_enabled.setter
    def is_compression_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_compression_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isInlineEcEnabled")
    def is_inline_ec_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        -(Optional) Indicates whether data written to this container should be inline erasure coded or not. This field is only considered when ErasureCoding is enabled.
        """
        return pulumi.get(self, "is_inline_ec_enabled")

    @is_inline_ec_enabled.setter
    def is_inline_ec_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_inline_ec_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isInternal")
    def is_internal(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - Indicates whether the Container is internal and is managed by Nutanix.
        """
        return pulumi.get(self, "is_internal")

    @is_internal.setter
    def is_internal(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_internal", value)

    @_builtins.property
    @pulumi.getter(name="isSoftwareEncryptionEnabled")
    def is_software_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        -(Optional) Indicates whether the Container instance has software encryption enabled.
        """
        return pulumi.get(self, "is_software_encryption_enabled")

    @is_software_encryption_enabled.setter
    def is_software_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_software_encryption_enabled", value)

    @_builtins.property
    @pulumi.getter(name="logicalAdvertisedCapacityBytes")
    def logical_advertised_capacity_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        -(Optional) Max capacity of the Container as defined by the user.
        """
        return pulumi.get(self, "logical_advertised_capacity_bytes")

    @logical_advertised_capacity_bytes.setter
    def logical_advertised_capacity_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "logical_advertised_capacity_bytes", value)

    @_builtins.property
    @pulumi.getter(name="logicalExplicitReservedCapacityBytes")
    def logical_explicit_reserved_capacity_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        -(Optional) Total reserved size (in bytes) of the container (set by Admin). This also accounts for the container's replication factor. The actual reserved capacity of the container will be the maximum of explicitReservedCapacity and implicitReservedCapacity.
        """
        return pulumi.get(self, "logical_explicit_reserved_capacity_bytes")

    @logical_explicit_reserved_capacity_bytes.setter
    def logical_explicit_reserved_capacity_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "logical_explicit_reserved_capacity_bytes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) Name of the storage container.  Note that the name of Storage Container should be unique per cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nfsWhitelistAddresses")
    def nfs_whitelist_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageContainersV2NfsWhitelistAddressArgs']]]]:
        """
        -(Optional) List of NFS addresses which need to be whitelisted.
        """
        return pulumi.get(self, "nfs_whitelist_addresses")

    @nfs_whitelist_addresses.setter
    def nfs_whitelist_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageContainersV2NfsWhitelistAddressArgs']]]]):
        pulumi.set(self, "nfs_whitelist_addresses", value)

    @_builtins.property
    @pulumi.getter(name="onDiskDedup")
    def on_disk_dedup(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Indicates the current status of Disk Deduplication for the Container. available values:  `NONE`,    `OFF`,    `POST_PROCESS`
        """
        return pulumi.get(self, "on_disk_dedup")

    @on_disk_dedup.setter
    def on_disk_dedup(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_disk_dedup", value)

    @_builtins.property
    @pulumi.getter(name="ownerExtId")
    def owner_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) owner ext id
        """
        return pulumi.get(self, "owner_ext_id")

    @owner_ext_id.setter
    def owner_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        -(Optional) Replication factor of the Storage Container.
        """
        return pulumi.get(self, "replication_factor")

    @replication_factor.setter
    def replication_factor(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replication_factor", value)


@pulumi.input_type
class _StorageContainersV2State:
    def __init__(__self__, *,
                 affinity_host_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_deduplication: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 compression_delay_secs: Optional[pulumi.Input[_builtins.int]] = None,
                 container_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 erasure_code: Optional[pulumi.Input[_builtins.str]] = None,
                 erasure_code_delay_secs: Optional[pulumi.Input[_builtins.int]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 has_higher_ec_fault_domain_preference: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_small_files: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_compression_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_inline_ec_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_internal: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_marked_for_removal: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_software_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input['StorageContainersV2LinkArgs']]]] = None,
                 logical_advertised_capacity_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 logical_explicit_reserved_capacity_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 logical_implicit_reserved_capacity_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 max_capacity_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nfs_whitelist_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['StorageContainersV2NfsWhitelistAddressArgs']]]] = None,
                 on_disk_dedup: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_factor: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_pool_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering StorageContainersV2 resources.
        :param pulumi.Input[_builtins.str] affinity_host_ext_id: -(Optional) Affinity host extId for RF 1 Storage Container.
        :param pulumi.Input[_builtins.str] cache_deduplication: -(Optional) Indicates the current status of Cache Deduplication for the Container. available values:  `NONE`,    `OFF`,    `ON`
        :param pulumi.Input[_builtins.str] cluster_ext_id: - ext id for the cluster owning the storage container.
        :param pulumi.Input[_builtins.str] cluster_name: - Corresponding name of the Cluster owning the Storage Container instance.
        :param pulumi.Input[_builtins.int] compression_delay_secs: -(Optional) The compression delay in seconds.
        :param pulumi.Input[_builtins.str] container_ext_id: - the storage container ext id
        :param pulumi.Input[_builtins.str] erasure_code: -(Optional) Indicates the current status value for Erasure Coding for the Container. available values:  `NONE`,    `OFF`,    `ON`
        :param pulumi.Input[_builtins.int] erasure_code_delay_secs: -(Optional) Delay in performing ErasureCode for the current Container instance.
        :param pulumi.Input[_builtins.str] ext_id: - the storage container uuid
        :param pulumi.Input[_builtins.bool] has_higher_ec_fault_domain_preference: -(Optional) Indicates whether to prefer a higher Erasure Code fault domain.
        :param pulumi.Input[_builtins.bool] is_compression_enabled: -(Optional) Indicates whether the compression is enabled for the Container.
        :param pulumi.Input[_builtins.bool] is_encrypted: - Indicates whether the Container is encrypted or not.
        :param pulumi.Input[_builtins.bool] is_inline_ec_enabled: -(Optional) Indicates whether data written to this container should be inline erasure coded or not. This field is only considered when ErasureCoding is enabled.
        :param pulumi.Input[_builtins.bool] is_internal: - Indicates whether the Container is internal and is managed by Nutanix.
        :param pulumi.Input[_builtins.bool] is_marked_for_removal: - Indicates if the Storage Container is marked for removal. This field is set when the Storage Container is about to be destroyed.
        :param pulumi.Input[_builtins.bool] is_software_encryption_enabled: -(Optional) Indicates whether the Container instance has software encryption enabled.
        :param pulumi.Input[Sequence[pulumi.Input['StorageContainersV2LinkArgs']]] links: - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        :param pulumi.Input[_builtins.int] logical_advertised_capacity_bytes: -(Optional) Max capacity of the Container as defined by the user.
        :param pulumi.Input[_builtins.int] logical_explicit_reserved_capacity_bytes: -(Optional) Total reserved size (in bytes) of the container (set by Admin). This also accounts for the container's replication factor. The actual reserved capacity of the container will be the maximum of explicitReservedCapacity and implicitReservedCapacity.
        :param pulumi.Input[_builtins.int] logical_implicit_reserved_capacity_bytes: - This is the summation of reservations provisioned on all vdisks in the container. The actual reserved capacity of the container will be the maximum of explicitReservedCapacity and implicitReservedCapacity
        :param pulumi.Input[_builtins.int] max_capacity_bytes: - Maximum physical capacity of the Storage Container in bytes.
        :param pulumi.Input[_builtins.str] name: -(Required) Name of the storage container.  Note that the name of Storage Container should be unique per cluster.
        :param pulumi.Input[Sequence[pulumi.Input['StorageContainersV2NfsWhitelistAddressArgs']]] nfs_whitelist_addresses: -(Optional) List of NFS addresses which need to be whitelisted.
        :param pulumi.Input[_builtins.str] on_disk_dedup: - Indicates the current status of Disk Deduplication for the Container. available values:  `NONE`,    `OFF`,    `POST_PROCESS`
        :param pulumi.Input[_builtins.str] owner_ext_id: -(Optional) owner ext id
        :param pulumi.Input[_builtins.int] replication_factor: -(Optional) Replication factor of the Storage Container.
        :param pulumi.Input[_builtins.str] storage_pool_ext_id: - extId of the Storage Pool owning the Storage Container instance.
        :param pulumi.Input[_builtins.str] tenant_id: - A globally unique identifier that represents the tenant that owns this entity.
        """
        if affinity_host_ext_id is not None:
            pulumi.set(__self__, "affinity_host_ext_id", affinity_host_ext_id)
        if cache_deduplication is not None:
            pulumi.set(__self__, "cache_deduplication", cache_deduplication)
        if cluster_ext_id is not None:
            pulumi.set(__self__, "cluster_ext_id", cluster_ext_id)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if compression_delay_secs is not None:
            pulumi.set(__self__, "compression_delay_secs", compression_delay_secs)
        if container_ext_id is not None:
            pulumi.set(__self__, "container_ext_id", container_ext_id)
        if erasure_code is not None:
            pulumi.set(__self__, "erasure_code", erasure_code)
        if erasure_code_delay_secs is not None:
            pulumi.set(__self__, "erasure_code_delay_secs", erasure_code_delay_secs)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if has_higher_ec_fault_domain_preference is not None:
            pulumi.set(__self__, "has_higher_ec_fault_domain_preference", has_higher_ec_fault_domain_preference)
        if ignore_small_files is not None:
            pulumi.set(__self__, "ignore_small_files", ignore_small_files)
        if is_compression_enabled is not None:
            pulumi.set(__self__, "is_compression_enabled", is_compression_enabled)
        if is_encrypted is not None:
            pulumi.set(__self__, "is_encrypted", is_encrypted)
        if is_inline_ec_enabled is not None:
            pulumi.set(__self__, "is_inline_ec_enabled", is_inline_ec_enabled)
        if is_internal is not None:
            pulumi.set(__self__, "is_internal", is_internal)
        if is_marked_for_removal is not None:
            pulumi.set(__self__, "is_marked_for_removal", is_marked_for_removal)
        if is_software_encryption_enabled is not None:
            pulumi.set(__self__, "is_software_encryption_enabled", is_software_encryption_enabled)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if logical_advertised_capacity_bytes is not None:
            pulumi.set(__self__, "logical_advertised_capacity_bytes", logical_advertised_capacity_bytes)
        if logical_explicit_reserved_capacity_bytes is not None:
            pulumi.set(__self__, "logical_explicit_reserved_capacity_bytes", logical_explicit_reserved_capacity_bytes)
        if logical_implicit_reserved_capacity_bytes is not None:
            pulumi.set(__self__, "logical_implicit_reserved_capacity_bytes", logical_implicit_reserved_capacity_bytes)
        if max_capacity_bytes is not None:
            pulumi.set(__self__, "max_capacity_bytes", max_capacity_bytes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nfs_whitelist_addresses is not None:
            pulumi.set(__self__, "nfs_whitelist_addresses", nfs_whitelist_addresses)
        if on_disk_dedup is not None:
            pulumi.set(__self__, "on_disk_dedup", on_disk_dedup)
        if owner_ext_id is not None:
            pulumi.set(__self__, "owner_ext_id", owner_ext_id)
        if replication_factor is not None:
            pulumi.set(__self__, "replication_factor", replication_factor)
        if storage_pool_ext_id is not None:
            pulumi.set(__self__, "storage_pool_ext_id", storage_pool_ext_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="affinityHostExtId")
    def affinity_host_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Affinity host extId for RF 1 Storage Container.
        """
        return pulumi.get(self, "affinity_host_ext_id")

    @affinity_host_ext_id.setter
    def affinity_host_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "affinity_host_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="cacheDeduplication")
    def cache_deduplication(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Indicates the current status of Cache Deduplication for the Container. available values:  `NONE`,    `OFF`,    `ON`
        """
        return pulumi.get(self, "cache_deduplication")

    @cache_deduplication.setter
    def cache_deduplication(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_deduplication", value)

    @_builtins.property
    @pulumi.getter(name="clusterExtId")
    def cluster_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - ext id for the cluster owning the storage container.
        """
        return pulumi.get(self, "cluster_ext_id")

    @cluster_ext_id.setter
    def cluster_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Corresponding name of the Cluster owning the Storage Container instance.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="compressionDelaySecs")
    def compression_delay_secs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        -(Optional) The compression delay in seconds.
        """
        return pulumi.get(self, "compression_delay_secs")

    @compression_delay_secs.setter
    def compression_delay_secs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "compression_delay_secs", value)

    @_builtins.property
    @pulumi.getter(name="containerExtId")
    def container_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - the storage container ext id
        """
        return pulumi.get(self, "container_ext_id")

    @container_ext_id.setter
    def container_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="erasureCode")
    def erasure_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Indicates the current status value for Erasure Coding for the Container. available values:  `NONE`,    `OFF`,    `ON`
        """
        return pulumi.get(self, "erasure_code")

    @erasure_code.setter
    def erasure_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "erasure_code", value)

    @_builtins.property
    @pulumi.getter(name="erasureCodeDelaySecs")
    def erasure_code_delay_secs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        -(Optional) Delay in performing ErasureCode for the current Container instance.
        """
        return pulumi.get(self, "erasure_code_delay_secs")

    @erasure_code_delay_secs.setter
    def erasure_code_delay_secs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "erasure_code_delay_secs", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - the storage container uuid
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="hasHigherEcFaultDomainPreference")
    def has_higher_ec_fault_domain_preference(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        -(Optional) Indicates whether to prefer a higher Erasure Code fault domain.
        """
        return pulumi.get(self, "has_higher_ec_fault_domain_preference")

    @has_higher_ec_fault_domain_preference.setter
    def has_higher_ec_fault_domain_preference(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "has_higher_ec_fault_domain_preference", value)

    @_builtins.property
    @pulumi.getter(name="ignoreSmallFiles")
    def ignore_small_files(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "ignore_small_files")

    @ignore_small_files.setter
    def ignore_small_files(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_small_files", value)

    @_builtins.property
    @pulumi.getter(name="isCompressionEnabled")
    def is_compression_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        -(Optional) Indicates whether the compression is enabled for the Container.
        """
        return pulumi.get(self, "is_compression_enabled")

    @is_compression_enabled.setter
    def is_compression_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_compression_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isEncrypted")
    def is_encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - Indicates whether the Container is encrypted or not.
        """
        return pulumi.get(self, "is_encrypted")

    @is_encrypted.setter
    def is_encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_encrypted", value)

    @_builtins.property
    @pulumi.getter(name="isInlineEcEnabled")
    def is_inline_ec_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        -(Optional) Indicates whether data written to this container should be inline erasure coded or not. This field is only considered when ErasureCoding is enabled.
        """
        return pulumi.get(self, "is_inline_ec_enabled")

    @is_inline_ec_enabled.setter
    def is_inline_ec_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_inline_ec_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isInternal")
    def is_internal(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - Indicates whether the Container is internal and is managed by Nutanix.
        """
        return pulumi.get(self, "is_internal")

    @is_internal.setter
    def is_internal(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_internal", value)

    @_builtins.property
    @pulumi.getter(name="isMarkedForRemoval")
    def is_marked_for_removal(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - Indicates if the Storage Container is marked for removal. This field is set when the Storage Container is about to be destroyed.
        """
        return pulumi.get(self, "is_marked_for_removal")

    @is_marked_for_removal.setter
    def is_marked_for_removal(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_marked_for_removal", value)

    @_builtins.property
    @pulumi.getter(name="isSoftwareEncryptionEnabled")
    def is_software_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        -(Optional) Indicates whether the Container instance has software encryption enabled.
        """
        return pulumi.get(self, "is_software_encryption_enabled")

    @is_software_encryption_enabled.setter
    def is_software_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_software_encryption_enabled", value)

    @_builtins.property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageContainersV2LinkArgs']]]]:
        """
        - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageContainersV2LinkArgs']]]]):
        pulumi.set(self, "links", value)

    @_builtins.property
    @pulumi.getter(name="logicalAdvertisedCapacityBytes")
    def logical_advertised_capacity_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        -(Optional) Max capacity of the Container as defined by the user.
        """
        return pulumi.get(self, "logical_advertised_capacity_bytes")

    @logical_advertised_capacity_bytes.setter
    def logical_advertised_capacity_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "logical_advertised_capacity_bytes", value)

    @_builtins.property
    @pulumi.getter(name="logicalExplicitReservedCapacityBytes")
    def logical_explicit_reserved_capacity_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        -(Optional) Total reserved size (in bytes) of the container (set by Admin). This also accounts for the container's replication factor. The actual reserved capacity of the container will be the maximum of explicitReservedCapacity and implicitReservedCapacity.
        """
        return pulumi.get(self, "logical_explicit_reserved_capacity_bytes")

    @logical_explicit_reserved_capacity_bytes.setter
    def logical_explicit_reserved_capacity_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "logical_explicit_reserved_capacity_bytes", value)

    @_builtins.property
    @pulumi.getter(name="logicalImplicitReservedCapacityBytes")
    def logical_implicit_reserved_capacity_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - This is the summation of reservations provisioned on all vdisks in the container. The actual reserved capacity of the container will be the maximum of explicitReservedCapacity and implicitReservedCapacity
        """
        return pulumi.get(self, "logical_implicit_reserved_capacity_bytes")

    @logical_implicit_reserved_capacity_bytes.setter
    def logical_implicit_reserved_capacity_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "logical_implicit_reserved_capacity_bytes", value)

    @_builtins.property
    @pulumi.getter(name="maxCapacityBytes")
    def max_capacity_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - Maximum physical capacity of the Storage Container in bytes.
        """
        return pulumi.get(self, "max_capacity_bytes")

    @max_capacity_bytes.setter
    def max_capacity_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_capacity_bytes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) Name of the storage container.  Note that the name of Storage Container should be unique per cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nfsWhitelistAddresses")
    def nfs_whitelist_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageContainersV2NfsWhitelistAddressArgs']]]]:
        """
        -(Optional) List of NFS addresses which need to be whitelisted.
        """
        return pulumi.get(self, "nfs_whitelist_addresses")

    @nfs_whitelist_addresses.setter
    def nfs_whitelist_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageContainersV2NfsWhitelistAddressArgs']]]]):
        pulumi.set(self, "nfs_whitelist_addresses", value)

    @_builtins.property
    @pulumi.getter(name="onDiskDedup")
    def on_disk_dedup(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Indicates the current status of Disk Deduplication for the Container. available values:  `NONE`,    `OFF`,    `POST_PROCESS`
        """
        return pulumi.get(self, "on_disk_dedup")

    @on_disk_dedup.setter
    def on_disk_dedup(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_disk_dedup", value)

    @_builtins.property
    @pulumi.getter(name="ownerExtId")
    def owner_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) owner ext id
        """
        return pulumi.get(self, "owner_ext_id")

    @owner_ext_id.setter
    def owner_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        -(Optional) Replication factor of the Storage Container.
        """
        return pulumi.get(self, "replication_factor")

    @replication_factor.setter
    def replication_factor(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replication_factor", value)

    @_builtins.property
    @pulumi.getter(name="storagePoolExtId")
    def storage_pool_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - extId of the Storage Pool owning the Storage Container instance.
        """
        return pulumi.get(self, "storage_pool_ext_id")

    @storage_pool_ext_id.setter
    def storage_pool_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_pool_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - A globally unique identifier that represents the tenant that owns this entity.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.type_token("nutanix:index/storageContainersV2:StorageContainersV2")
class StorageContainersV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 affinity_host_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_deduplication: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compression_delay_secs: Optional[pulumi.Input[_builtins.int]] = None,
                 container_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 erasure_code: Optional[pulumi.Input[_builtins.str]] = None,
                 erasure_code_delay_secs: Optional[pulumi.Input[_builtins.int]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 has_higher_ec_fault_domain_preference: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_small_files: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_compression_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_inline_ec_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_internal: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_software_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 logical_advertised_capacity_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 logical_explicit_reserved_capacity_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nfs_whitelist_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageContainersV2NfsWhitelistAddressArgs', 'StorageContainersV2NfsWhitelistAddressArgsDict']]]]] = None,
                 on_disk_dedup: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_factor: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides Nutanix resource to create VPC.

        ## Example

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        storage_container = nutanix.StorageContainersV2("storage-container",
            name="example-storage-container",
            logical_advertised_capacity_bytes=1073741824000,
            logical_explicit_reserved_capacity_bytes=32,
            replication_factor=1,
            nfs_whitelist_addresses=[{
                "ipv4s": [{
                    "value": "192.168.15.0",
                    "prefix_length": 32,
                }],
            }],
            erasure_code="OFF",
            is_inline_ec_enabled=False,
            has_higher_ec_fault_domain_preference=False,
            cache_deduplication="OFF",
            on_disk_dedup="OFF",
            is_compression_enabled=True,
            is_internal=False,
            is_software_encryption_enabled=False)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] affinity_host_ext_id: -(Optional) Affinity host extId for RF 1 Storage Container.
        :param pulumi.Input[_builtins.str] cache_deduplication: -(Optional) Indicates the current status of Cache Deduplication for the Container. available values:  `NONE`,    `OFF`,    `ON`
        :param pulumi.Input[_builtins.str] cluster_ext_id: - ext id for the cluster owning the storage container.
        :param pulumi.Input[_builtins.int] compression_delay_secs: -(Optional) The compression delay in seconds.
        :param pulumi.Input[_builtins.str] container_ext_id: - the storage container ext id
        :param pulumi.Input[_builtins.str] erasure_code: -(Optional) Indicates the current status value for Erasure Coding for the Container. available values:  `NONE`,    `OFF`,    `ON`
        :param pulumi.Input[_builtins.int] erasure_code_delay_secs: -(Optional) Delay in performing ErasureCode for the current Container instance.
        :param pulumi.Input[_builtins.str] ext_id: - the storage container uuid
        :param pulumi.Input[_builtins.bool] has_higher_ec_fault_domain_preference: -(Optional) Indicates whether to prefer a higher Erasure Code fault domain.
        :param pulumi.Input[_builtins.bool] is_compression_enabled: -(Optional) Indicates whether the compression is enabled for the Container.
        :param pulumi.Input[_builtins.bool] is_inline_ec_enabled: -(Optional) Indicates whether data written to this container should be inline erasure coded or not. This field is only considered when ErasureCoding is enabled.
        :param pulumi.Input[_builtins.bool] is_internal: - Indicates whether the Container is internal and is managed by Nutanix.
        :param pulumi.Input[_builtins.bool] is_software_encryption_enabled: -(Optional) Indicates whether the Container instance has software encryption enabled.
        :param pulumi.Input[_builtins.int] logical_advertised_capacity_bytes: -(Optional) Max capacity of the Container as defined by the user.
        :param pulumi.Input[_builtins.int] logical_explicit_reserved_capacity_bytes: -(Optional) Total reserved size (in bytes) of the container (set by Admin). This also accounts for the container's replication factor. The actual reserved capacity of the container will be the maximum of explicitReservedCapacity and implicitReservedCapacity.
        :param pulumi.Input[_builtins.str] name: -(Required) Name of the storage container.  Note that the name of Storage Container should be unique per cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StorageContainersV2NfsWhitelistAddressArgs', 'StorageContainersV2NfsWhitelistAddressArgsDict']]]] nfs_whitelist_addresses: -(Optional) List of NFS addresses which need to be whitelisted.
        :param pulumi.Input[_builtins.str] on_disk_dedup: - Indicates the current status of Disk Deduplication for the Container. available values:  `NONE`,    `OFF`,    `POST_PROCESS`
        :param pulumi.Input[_builtins.str] owner_ext_id: -(Optional) owner ext id
        :param pulumi.Input[_builtins.int] replication_factor: -(Optional) Replication factor of the Storage Container.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StorageContainersV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides Nutanix resource to create VPC.

        ## Example

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        storage_container = nutanix.StorageContainersV2("storage-container",
            name="example-storage-container",
            logical_advertised_capacity_bytes=1073741824000,
            logical_explicit_reserved_capacity_bytes=32,
            replication_factor=1,
            nfs_whitelist_addresses=[{
                "ipv4s": [{
                    "value": "192.168.15.0",
                    "prefix_length": 32,
                }],
            }],
            erasure_code="OFF",
            is_inline_ec_enabled=False,
            has_higher_ec_fault_domain_preference=False,
            cache_deduplication="OFF",
            on_disk_dedup="OFF",
            is_compression_enabled=True,
            is_internal=False,
            is_software_encryption_enabled=False)
        ```

        :param str resource_name: The name of the resource.
        :param StorageContainersV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StorageContainersV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 affinity_host_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_deduplication: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compression_delay_secs: Optional[pulumi.Input[_builtins.int]] = None,
                 container_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 erasure_code: Optional[pulumi.Input[_builtins.str]] = None,
                 erasure_code_delay_secs: Optional[pulumi.Input[_builtins.int]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 has_higher_ec_fault_domain_preference: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_small_files: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_compression_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_inline_ec_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_internal: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_software_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 logical_advertised_capacity_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 logical_explicit_reserved_capacity_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nfs_whitelist_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageContainersV2NfsWhitelistAddressArgs', 'StorageContainersV2NfsWhitelistAddressArgsDict']]]]] = None,
                 on_disk_dedup: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_factor: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StorageContainersV2Args.__new__(StorageContainersV2Args)

            __props__.__dict__["affinity_host_ext_id"] = affinity_host_ext_id
            __props__.__dict__["cache_deduplication"] = cache_deduplication
            if cluster_ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_ext_id'")
            __props__.__dict__["cluster_ext_id"] = cluster_ext_id
            __props__.__dict__["compression_delay_secs"] = compression_delay_secs
            __props__.__dict__["container_ext_id"] = container_ext_id
            __props__.__dict__["erasure_code"] = erasure_code
            __props__.__dict__["erasure_code_delay_secs"] = erasure_code_delay_secs
            __props__.__dict__["ext_id"] = ext_id
            __props__.__dict__["has_higher_ec_fault_domain_preference"] = has_higher_ec_fault_domain_preference
            __props__.__dict__["ignore_small_files"] = ignore_small_files
            __props__.__dict__["is_compression_enabled"] = is_compression_enabled
            __props__.__dict__["is_inline_ec_enabled"] = is_inline_ec_enabled
            __props__.__dict__["is_internal"] = is_internal
            __props__.__dict__["is_software_encryption_enabled"] = is_software_encryption_enabled
            __props__.__dict__["logical_advertised_capacity_bytes"] = logical_advertised_capacity_bytes
            __props__.__dict__["logical_explicit_reserved_capacity_bytes"] = logical_explicit_reserved_capacity_bytes
            __props__.__dict__["name"] = name
            __props__.__dict__["nfs_whitelist_addresses"] = nfs_whitelist_addresses
            __props__.__dict__["on_disk_dedup"] = on_disk_dedup
            __props__.__dict__["owner_ext_id"] = owner_ext_id
            __props__.__dict__["replication_factor"] = replication_factor
            __props__.__dict__["cluster_name"] = None
            __props__.__dict__["is_encrypted"] = None
            __props__.__dict__["is_marked_for_removal"] = None
            __props__.__dict__["links"] = None
            __props__.__dict__["logical_implicit_reserved_capacity_bytes"] = None
            __props__.__dict__["max_capacity_bytes"] = None
            __props__.__dict__["storage_pool_ext_id"] = None
            __props__.__dict__["tenant_id"] = None
        super(StorageContainersV2, __self__).__init__(
            'nutanix:index/storageContainersV2:StorageContainersV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            affinity_host_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            cache_deduplication: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            compression_delay_secs: Optional[pulumi.Input[_builtins.int]] = None,
            container_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            erasure_code: Optional[pulumi.Input[_builtins.str]] = None,
            erasure_code_delay_secs: Optional[pulumi.Input[_builtins.int]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            has_higher_ec_fault_domain_preference: Optional[pulumi.Input[_builtins.bool]] = None,
            ignore_small_files: Optional[pulumi.Input[_builtins.bool]] = None,
            is_compression_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
            is_inline_ec_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_internal: Optional[pulumi.Input[_builtins.bool]] = None,
            is_marked_for_removal: Optional[pulumi.Input[_builtins.bool]] = None,
            is_software_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageContainersV2LinkArgs', 'StorageContainersV2LinkArgsDict']]]]] = None,
            logical_advertised_capacity_bytes: Optional[pulumi.Input[_builtins.int]] = None,
            logical_explicit_reserved_capacity_bytes: Optional[pulumi.Input[_builtins.int]] = None,
            logical_implicit_reserved_capacity_bytes: Optional[pulumi.Input[_builtins.int]] = None,
            max_capacity_bytes: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nfs_whitelist_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageContainersV2NfsWhitelistAddressArgs', 'StorageContainersV2NfsWhitelistAddressArgsDict']]]]] = None,
            on_disk_dedup: Optional[pulumi.Input[_builtins.str]] = None,
            owner_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            replication_factor: Optional[pulumi.Input[_builtins.int]] = None,
            storage_pool_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'StorageContainersV2':
        """
        Get an existing StorageContainersV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] affinity_host_ext_id: -(Optional) Affinity host extId for RF 1 Storage Container.
        :param pulumi.Input[_builtins.str] cache_deduplication: -(Optional) Indicates the current status of Cache Deduplication for the Container. available values:  `NONE`,    `OFF`,    `ON`
        :param pulumi.Input[_builtins.str] cluster_ext_id: - ext id for the cluster owning the storage container.
        :param pulumi.Input[_builtins.str] cluster_name: - Corresponding name of the Cluster owning the Storage Container instance.
        :param pulumi.Input[_builtins.int] compression_delay_secs: -(Optional) The compression delay in seconds.
        :param pulumi.Input[_builtins.str] container_ext_id: - the storage container ext id
        :param pulumi.Input[_builtins.str] erasure_code: -(Optional) Indicates the current status value for Erasure Coding for the Container. available values:  `NONE`,    `OFF`,    `ON`
        :param pulumi.Input[_builtins.int] erasure_code_delay_secs: -(Optional) Delay in performing ErasureCode for the current Container instance.
        :param pulumi.Input[_builtins.str] ext_id: - the storage container uuid
        :param pulumi.Input[_builtins.bool] has_higher_ec_fault_domain_preference: -(Optional) Indicates whether to prefer a higher Erasure Code fault domain.
        :param pulumi.Input[_builtins.bool] is_compression_enabled: -(Optional) Indicates whether the compression is enabled for the Container.
        :param pulumi.Input[_builtins.bool] is_encrypted: - Indicates whether the Container is encrypted or not.
        :param pulumi.Input[_builtins.bool] is_inline_ec_enabled: -(Optional) Indicates whether data written to this container should be inline erasure coded or not. This field is only considered when ErasureCoding is enabled.
        :param pulumi.Input[_builtins.bool] is_internal: - Indicates whether the Container is internal and is managed by Nutanix.
        :param pulumi.Input[_builtins.bool] is_marked_for_removal: - Indicates if the Storage Container is marked for removal. This field is set when the Storage Container is about to be destroyed.
        :param pulumi.Input[_builtins.bool] is_software_encryption_enabled: -(Optional) Indicates whether the Container instance has software encryption enabled.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StorageContainersV2LinkArgs', 'StorageContainersV2LinkArgsDict']]]] links: - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        :param pulumi.Input[_builtins.int] logical_advertised_capacity_bytes: -(Optional) Max capacity of the Container as defined by the user.
        :param pulumi.Input[_builtins.int] logical_explicit_reserved_capacity_bytes: -(Optional) Total reserved size (in bytes) of the container (set by Admin). This also accounts for the container's replication factor. The actual reserved capacity of the container will be the maximum of explicitReservedCapacity and implicitReservedCapacity.
        :param pulumi.Input[_builtins.int] logical_implicit_reserved_capacity_bytes: - This is the summation of reservations provisioned on all vdisks in the container. The actual reserved capacity of the container will be the maximum of explicitReservedCapacity and implicitReservedCapacity
        :param pulumi.Input[_builtins.int] max_capacity_bytes: - Maximum physical capacity of the Storage Container in bytes.
        :param pulumi.Input[_builtins.str] name: -(Required) Name of the storage container.  Note that the name of Storage Container should be unique per cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StorageContainersV2NfsWhitelistAddressArgs', 'StorageContainersV2NfsWhitelistAddressArgsDict']]]] nfs_whitelist_addresses: -(Optional) List of NFS addresses which need to be whitelisted.
        :param pulumi.Input[_builtins.str] on_disk_dedup: - Indicates the current status of Disk Deduplication for the Container. available values:  `NONE`,    `OFF`,    `POST_PROCESS`
        :param pulumi.Input[_builtins.str] owner_ext_id: -(Optional) owner ext id
        :param pulumi.Input[_builtins.int] replication_factor: -(Optional) Replication factor of the Storage Container.
        :param pulumi.Input[_builtins.str] storage_pool_ext_id: - extId of the Storage Pool owning the Storage Container instance.
        :param pulumi.Input[_builtins.str] tenant_id: - A globally unique identifier that represents the tenant that owns this entity.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StorageContainersV2State.__new__(_StorageContainersV2State)

        __props__.__dict__["affinity_host_ext_id"] = affinity_host_ext_id
        __props__.__dict__["cache_deduplication"] = cache_deduplication
        __props__.__dict__["cluster_ext_id"] = cluster_ext_id
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["compression_delay_secs"] = compression_delay_secs
        __props__.__dict__["container_ext_id"] = container_ext_id
        __props__.__dict__["erasure_code"] = erasure_code
        __props__.__dict__["erasure_code_delay_secs"] = erasure_code_delay_secs
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["has_higher_ec_fault_domain_preference"] = has_higher_ec_fault_domain_preference
        __props__.__dict__["ignore_small_files"] = ignore_small_files
        __props__.__dict__["is_compression_enabled"] = is_compression_enabled
        __props__.__dict__["is_encrypted"] = is_encrypted
        __props__.__dict__["is_inline_ec_enabled"] = is_inline_ec_enabled
        __props__.__dict__["is_internal"] = is_internal
        __props__.__dict__["is_marked_for_removal"] = is_marked_for_removal
        __props__.__dict__["is_software_encryption_enabled"] = is_software_encryption_enabled
        __props__.__dict__["links"] = links
        __props__.__dict__["logical_advertised_capacity_bytes"] = logical_advertised_capacity_bytes
        __props__.__dict__["logical_explicit_reserved_capacity_bytes"] = logical_explicit_reserved_capacity_bytes
        __props__.__dict__["logical_implicit_reserved_capacity_bytes"] = logical_implicit_reserved_capacity_bytes
        __props__.__dict__["max_capacity_bytes"] = max_capacity_bytes
        __props__.__dict__["name"] = name
        __props__.__dict__["nfs_whitelist_addresses"] = nfs_whitelist_addresses
        __props__.__dict__["on_disk_dedup"] = on_disk_dedup
        __props__.__dict__["owner_ext_id"] = owner_ext_id
        __props__.__dict__["replication_factor"] = replication_factor
        __props__.__dict__["storage_pool_ext_id"] = storage_pool_ext_id
        __props__.__dict__["tenant_id"] = tenant_id
        return StorageContainersV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="affinityHostExtId")
    def affinity_host_ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Optional) Affinity host extId for RF 1 Storage Container.
        """
        return pulumi.get(self, "affinity_host_ext_id")

    @_builtins.property
    @pulumi.getter(name="cacheDeduplication")
    def cache_deduplication(self) -> pulumi.Output[_builtins.str]:
        """
        -(Optional) Indicates the current status of Cache Deduplication for the Container. available values:  `NONE`,    `OFF`,    `ON`
        """
        return pulumi.get(self, "cache_deduplication")

    @_builtins.property
    @pulumi.getter(name="clusterExtId")
    def cluster_ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        - ext id for the cluster owning the storage container.
        """
        return pulumi.get(self, "cluster_ext_id")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        - Corresponding name of the Cluster owning the Storage Container instance.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="compressionDelaySecs")
    def compression_delay_secs(self) -> pulumi.Output[_builtins.int]:
        """
        -(Optional) The compression delay in seconds.
        """
        return pulumi.get(self, "compression_delay_secs")

    @_builtins.property
    @pulumi.getter(name="containerExtId")
    def container_ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        - the storage container ext id
        """
        return pulumi.get(self, "container_ext_id")

    @_builtins.property
    @pulumi.getter(name="erasureCode")
    def erasure_code(self) -> pulumi.Output[_builtins.str]:
        """
        -(Optional) Indicates the current status value for Erasure Coding for the Container. available values:  `NONE`,    `OFF`,    `ON`
        """
        return pulumi.get(self, "erasure_code")

    @_builtins.property
    @pulumi.getter(name="erasureCodeDelaySecs")
    def erasure_code_delay_secs(self) -> pulumi.Output[_builtins.int]:
        """
        -(Optional) Delay in performing ErasureCode for the current Container instance.
        """
        return pulumi.get(self, "erasure_code_delay_secs")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        - the storage container uuid
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="hasHigherEcFaultDomainPreference")
    def has_higher_ec_fault_domain_preference(self) -> pulumi.Output[_builtins.bool]:
        """
        -(Optional) Indicates whether to prefer a higher Erasure Code fault domain.
        """
        return pulumi.get(self, "has_higher_ec_fault_domain_preference")

    @_builtins.property
    @pulumi.getter(name="ignoreSmallFiles")
    def ignore_small_files(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "ignore_small_files")

    @_builtins.property
    @pulumi.getter(name="isCompressionEnabled")
    def is_compression_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        -(Optional) Indicates whether the compression is enabled for the Container.
        """
        return pulumi.get(self, "is_compression_enabled")

    @_builtins.property
    @pulumi.getter(name="isEncrypted")
    def is_encrypted(self) -> pulumi.Output[_builtins.bool]:
        """
        - Indicates whether the Container is encrypted or not.
        """
        return pulumi.get(self, "is_encrypted")

    @_builtins.property
    @pulumi.getter(name="isInlineEcEnabled")
    def is_inline_ec_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        -(Optional) Indicates whether data written to this container should be inline erasure coded or not. This field is only considered when ErasureCoding is enabled.
        """
        return pulumi.get(self, "is_inline_ec_enabled")

    @_builtins.property
    @pulumi.getter(name="isInternal")
    def is_internal(self) -> pulumi.Output[_builtins.bool]:
        """
        - Indicates whether the Container is internal and is managed by Nutanix.
        """
        return pulumi.get(self, "is_internal")

    @_builtins.property
    @pulumi.getter(name="isMarkedForRemoval")
    def is_marked_for_removal(self) -> pulumi.Output[_builtins.bool]:
        """
        - Indicates if the Storage Container is marked for removal. This field is set when the Storage Container is about to be destroyed.
        """
        return pulumi.get(self, "is_marked_for_removal")

    @_builtins.property
    @pulumi.getter(name="isSoftwareEncryptionEnabled")
    def is_software_encryption_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        -(Optional) Indicates whether the Container instance has software encryption enabled.
        """
        return pulumi.get(self, "is_software_encryption_enabled")

    @_builtins.property
    @pulumi.getter
    def links(self) -> pulumi.Output[Sequence['outputs.StorageContainersV2Link']]:
        """
        - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter(name="logicalAdvertisedCapacityBytes")
    def logical_advertised_capacity_bytes(self) -> pulumi.Output[_builtins.int]:
        """
        -(Optional) Max capacity of the Container as defined by the user.
        """
        return pulumi.get(self, "logical_advertised_capacity_bytes")

    @_builtins.property
    @pulumi.getter(name="logicalExplicitReservedCapacityBytes")
    def logical_explicit_reserved_capacity_bytes(self) -> pulumi.Output[_builtins.int]:
        """
        -(Optional) Total reserved size (in bytes) of the container (set by Admin). This also accounts for the container's replication factor. The actual reserved capacity of the container will be the maximum of explicitReservedCapacity and implicitReservedCapacity.
        """
        return pulumi.get(self, "logical_explicit_reserved_capacity_bytes")

    @_builtins.property
    @pulumi.getter(name="logicalImplicitReservedCapacityBytes")
    def logical_implicit_reserved_capacity_bytes(self) -> pulumi.Output[_builtins.int]:
        """
        - This is the summation of reservations provisioned on all vdisks in the container. The actual reserved capacity of the container will be the maximum of explicitReservedCapacity and implicitReservedCapacity
        """
        return pulumi.get(self, "logical_implicit_reserved_capacity_bytes")

    @_builtins.property
    @pulumi.getter(name="maxCapacityBytes")
    def max_capacity_bytes(self) -> pulumi.Output[_builtins.int]:
        """
        - Maximum physical capacity of the Storage Container in bytes.
        """
        return pulumi.get(self, "max_capacity_bytes")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) Name of the storage container.  Note that the name of Storage Container should be unique per cluster.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nfsWhitelistAddresses")
    def nfs_whitelist_addresses(self) -> pulumi.Output[Optional[Sequence['outputs.StorageContainersV2NfsWhitelistAddress']]]:
        """
        -(Optional) List of NFS addresses which need to be whitelisted.
        """
        return pulumi.get(self, "nfs_whitelist_addresses")

    @_builtins.property
    @pulumi.getter(name="onDiskDedup")
    def on_disk_dedup(self) -> pulumi.Output[_builtins.str]:
        """
        - Indicates the current status of Disk Deduplication for the Container. available values:  `NONE`,    `OFF`,    `POST_PROCESS`
        """
        return pulumi.get(self, "on_disk_dedup")

    @_builtins.property
    @pulumi.getter(name="ownerExtId")
    def owner_ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Optional) owner ext id
        """
        return pulumi.get(self, "owner_ext_id")

    @_builtins.property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> pulumi.Output[_builtins.int]:
        """
        -(Optional) Replication factor of the Storage Container.
        """
        return pulumi.get(self, "replication_factor")

    @_builtins.property
    @pulumi.getter(name="storagePoolExtId")
    def storage_pool_ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        - extId of the Storage Pool owning the Storage Container instance.
        """
        return pulumi.get(self, "storage_pool_ext_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        - A globally unique identifier that represents the tenant that owns this entity.
        """
        return pulumi.get(self, "tenant_id")

