# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SubnetArgs', 'Subnet']

@pulumi.input_type
class SubnetArgs:
    def __init__(__self__, *,
                 subnet_type: pulumi.Input[_builtins.str],
                 availability_zone_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetCategoryArgs']]]] = None,
                 cluster_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 default_gateway_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcp_domain_name_server_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dhcp_domain_search_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dhcp_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 dhcp_server_address: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 dhcp_server_address_port: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_nat: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_config_pool_list_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_external: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_function_chain_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 subnet_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_reference_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Subnet resource.
        :param pulumi.Input[_builtins.str] subnet_type: - (Optional). Valid Types are ["VLAN", "OVERLAY"]
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] availability_zone_reference: - (Optional) The reference to a availability_zone.
        :param pulumi.Input[Sequence[pulumi.Input['SubnetCategoryArgs']]] categories: - (Optional) The categories of the resource.
        :param pulumi.Input[_builtins.str] cluster_uuid: - (Required) The UUID of the cluster.
        :param pulumi.Input[_builtins.str] default_gateway_ip: - (Optional) Default gateway IP address.
        :param pulumi.Input[_builtins.str] description: - (Optional) A description for subnet.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dhcp_domain_name_server_lists: - (Optional). List of Domain Name Server addresses .
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dhcp_domain_search_lists: - (Optional).The DNS domain search list .
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] dhcp_options: - (Optional) Spec for defining DHCP options.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] dhcp_server_address: - (Optional) Host address.
        :param pulumi.Input[_builtins.int] dhcp_server_address_port: - (Optional) Port Number.
        :param pulumi.Input[_builtins.bool] enable_nat: - (Optional) Whether NAT should be performed for VPCs attaching to the subnet. This field is supported only for external subnets. NAT is enabled by default on external subnets.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_config_pool_list_ranges: -(Optional) Range of IPs.
        :param pulumi.Input[_builtins.bool] is_external: - (Optional) Whether the subnet is external subnet or not.
        :param pulumi.Input[_builtins.str] name: - (Optional) Subnet name (Readonly).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] network_function_chain_reference: - (Optional) The reference to a network_function_chain.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] owner_reference: - (Optional) The reference to a user.
        :param pulumi.Input[_builtins.int] prefix_length: - (Optional).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] project_reference: - (Optional) The reference to a project.
        :param pulumi.Input[_builtins.str] subnet_ip: - (Optional) Subnet IP address.
        :param pulumi.Input[_builtins.int] vlan_id: - (Optional). For VLAN subnet.
        :param pulumi.Input[_builtins.str] vpc_reference_uuid: VPC reference uuid
        :param pulumi.Input[_builtins.str] vswitch_name: - (Optional).
        """
        pulumi.set(__self__, "subnet_type", subnet_type)
        if availability_zone_reference is not None:
            pulumi.set(__self__, "availability_zone_reference", availability_zone_reference)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if cluster_uuid is not None:
            pulumi.set(__self__, "cluster_uuid", cluster_uuid)
        if default_gateway_ip is not None:
            pulumi.set(__self__, "default_gateway_ip", default_gateway_ip)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dhcp_domain_name_server_lists is not None:
            pulumi.set(__self__, "dhcp_domain_name_server_lists", dhcp_domain_name_server_lists)
        if dhcp_domain_search_lists is not None:
            pulumi.set(__self__, "dhcp_domain_search_lists", dhcp_domain_search_lists)
        if dhcp_options is not None:
            pulumi.set(__self__, "dhcp_options", dhcp_options)
        if dhcp_server_address is not None:
            pulumi.set(__self__, "dhcp_server_address", dhcp_server_address)
        if dhcp_server_address_port is not None:
            pulumi.set(__self__, "dhcp_server_address_port", dhcp_server_address_port)
        if enable_nat is not None:
            pulumi.set(__self__, "enable_nat", enable_nat)
        if ip_config_pool_list_ranges is not None:
            pulumi.set(__self__, "ip_config_pool_list_ranges", ip_config_pool_list_ranges)
        if is_external is not None:
            pulumi.set(__self__, "is_external", is_external)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_function_chain_reference is not None:
            pulumi.set(__self__, "network_function_chain_reference", network_function_chain_reference)
        if owner_reference is not None:
            pulumi.set(__self__, "owner_reference", owner_reference)
        if prefix_length is not None:
            pulumi.set(__self__, "prefix_length", prefix_length)
        if project_reference is not None:
            pulumi.set(__self__, "project_reference", project_reference)
        if subnet_ip is not None:
            pulumi.set(__self__, "subnet_ip", subnet_ip)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)
        if vpc_reference_uuid is not None:
            pulumi.set(__self__, "vpc_reference_uuid", vpc_reference_uuid)
        if vswitch_name is not None:
            pulumi.set(__self__, "vswitch_name", vswitch_name)

    @_builtins.property
    @pulumi.getter(name="subnetType")
    def subnet_type(self) -> pulumi.Input[_builtins.str]:
        """
        - (Optional). Valid Types are ["VLAN", "OVERLAY"]
        """
        return pulumi.get(self, "subnet_type")

    @subnet_type.setter
    def subnet_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_type", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZoneReference")
    def availability_zone_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The reference to a availability_zone.
        """
        return pulumi.get(self, "availability_zone_reference")

    @availability_zone_reference.setter
    def availability_zone_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zone_reference", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubnetCategoryArgs']]]]:
        """
        - (Optional) The categories of the resource.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetCategoryArgs']]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter(name="clusterUuid")
    def cluster_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) The UUID of the cluster.
        """
        return pulumi.get(self, "cluster_uuid")

    @cluster_uuid.setter
    def cluster_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_uuid", value)

    @_builtins.property
    @pulumi.getter(name="defaultGatewayIp")
    def default_gateway_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) Default gateway IP address.
        """
        return pulumi.get(self, "default_gateway_ip")

    @default_gateway_ip.setter
    def default_gateway_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_gateway_ip", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) A description for subnet.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dhcpDomainNameServerLists")
    def dhcp_domain_name_server_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        - (Optional). List of Domain Name Server addresses .
        """
        return pulumi.get(self, "dhcp_domain_name_server_lists")

    @dhcp_domain_name_server_lists.setter
    def dhcp_domain_name_server_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dhcp_domain_name_server_lists", value)

    @_builtins.property
    @pulumi.getter(name="dhcpDomainSearchLists")
    def dhcp_domain_search_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        - (Optional).The DNS domain search list .
        """
        return pulumi.get(self, "dhcp_domain_search_lists")

    @dhcp_domain_search_lists.setter
    def dhcp_domain_search_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dhcp_domain_search_lists", value)

    @_builtins.property
    @pulumi.getter(name="dhcpOptions")
    def dhcp_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) Spec for defining DHCP options.
        """
        return pulumi.get(self, "dhcp_options")

    @dhcp_options.setter
    def dhcp_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dhcp_options", value)

    @_builtins.property
    @pulumi.getter(name="dhcpServerAddress")
    def dhcp_server_address(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) Host address.
        """
        return pulumi.get(self, "dhcp_server_address")

    @dhcp_server_address.setter
    def dhcp_server_address(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dhcp_server_address", value)

    @_builtins.property
    @pulumi.getter(name="dhcpServerAddressPort")
    def dhcp_server_address_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - (Optional) Port Number.
        """
        return pulumi.get(self, "dhcp_server_address_port")

    @dhcp_server_address_port.setter
    def dhcp_server_address_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "dhcp_server_address_port", value)

    @_builtins.property
    @pulumi.getter(name="enableNat")
    def enable_nat(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Whether NAT should be performed for VPCs attaching to the subnet. This field is supported only for external subnets. NAT is enabled by default on external subnets.
        """
        return pulumi.get(self, "enable_nat")

    @enable_nat.setter
    def enable_nat(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_nat", value)

    @_builtins.property
    @pulumi.getter(name="ipConfigPoolListRanges")
    def ip_config_pool_list_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        -(Optional) Range of IPs.
        """
        return pulumi.get(self, "ip_config_pool_list_ranges")

    @ip_config_pool_list_ranges.setter
    def ip_config_pool_list_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_config_pool_list_ranges", value)

    @_builtins.property
    @pulumi.getter(name="isExternal")
    def is_external(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Whether the subnet is external subnet or not.
        """
        return pulumi.get(self, "is_external")

    @is_external.setter
    def is_external(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_external", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) Subnet name (Readonly).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkFunctionChainReference")
    def network_function_chain_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The reference to a network_function_chain.
        """
        return pulumi.get(self, "network_function_chain_reference")

    @network_function_chain_reference.setter
    def network_function_chain_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "network_function_chain_reference", value)

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The reference to a user.
        """
        return pulumi.get(self, "owner_reference")

    @owner_reference.setter
    def owner_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "owner_reference", value)

    @_builtins.property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - (Optional).
        """
        return pulumi.get(self, "prefix_length")

    @prefix_length.setter
    def prefix_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "prefix_length", value)

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The reference to a project.
        """
        return pulumi.get(self, "project_reference")

    @project_reference.setter
    def project_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "project_reference", value)

    @_builtins.property
    @pulumi.getter(name="subnetIp")
    def subnet_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) Subnet IP address.
        """
        return pulumi.get(self, "subnet_ip")

    @subnet_ip.setter
    def subnet_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_ip", value)

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - (Optional). For VLAN subnet.
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vlan_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcReferenceUuid")
    def vpc_reference_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VPC reference uuid
        """
        return pulumi.get(self, "vpc_reference_uuid")

    @vpc_reference_uuid.setter
    def vpc_reference_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_reference_uuid", value)

    @_builtins.property
    @pulumi.getter(name="vswitchName")
    def vswitch_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional).
        """
        return pulumi.get(self, "vswitch_name")

    @vswitch_name.setter
    def vswitch_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_name", value)


@pulumi.input_type
class _SubnetState:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetCategoryArgs']]]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 default_gateway_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcp_domain_name_server_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dhcp_domain_search_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dhcp_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 dhcp_server_address: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 dhcp_server_address_port: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_nat: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_config_pool_list_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_external: Optional[pulumi.Input[_builtins.bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_function_chain_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_type: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_reference_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Subnet resources.
        :param pulumi.Input[_builtins.str] api_version: The version of the API.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] availability_zone_reference: - (Optional) The reference to a availability_zone.
        :param pulumi.Input[Sequence[pulumi.Input['SubnetCategoryArgs']]] categories: - (Optional) The categories of the resource.
        :param pulumi.Input[_builtins.str] cluster_uuid: - (Required) The UUID of the cluster.
        :param pulumi.Input[_builtins.str] default_gateway_ip: - (Optional) Default gateway IP address.
        :param pulumi.Input[_builtins.str] description: - (Optional) A description for subnet.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dhcp_domain_name_server_lists: - (Optional). List of Domain Name Server addresses .
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dhcp_domain_search_lists: - (Optional).The DNS domain search list .
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] dhcp_options: - (Optional) Spec for defining DHCP options.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] dhcp_server_address: - (Optional) Host address.
        :param pulumi.Input[_builtins.int] dhcp_server_address_port: - (Optional) Port Number.
        :param pulumi.Input[_builtins.bool] enable_nat: - (Optional) Whether NAT should be performed for VPCs attaching to the subnet. This field is supported only for external subnets. NAT is enabled by default on external subnets.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_config_pool_list_ranges: -(Optional) Range of IPs.
        :param pulumi.Input[_builtins.bool] is_external: - (Optional) Whether the subnet is external subnet or not.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: - (Required) The subnet kind metadata.
        :param pulumi.Input[_builtins.str] name: - (Optional) Subnet name (Readonly).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] network_function_chain_reference: - (Optional) The reference to a network_function_chain.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] owner_reference: - (Optional) The reference to a user.
        :param pulumi.Input[_builtins.int] prefix_length: - (Optional).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] project_reference: - (Optional) The reference to a project.
        :param pulumi.Input[_builtins.str] state: - The state of the subnet.
        :param pulumi.Input[_builtins.str] subnet_ip: - (Optional) Subnet IP address.
        :param pulumi.Input[_builtins.str] subnet_type: - (Optional). Valid Types are ["VLAN", "OVERLAY"]
        :param pulumi.Input[_builtins.int] vlan_id: - (Optional). For VLAN subnet.
        :param pulumi.Input[_builtins.str] vpc_reference_uuid: VPC reference uuid
        :param pulumi.Input[_builtins.str] vswitch_name: - (Optional).
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if availability_zone_reference is not None:
            pulumi.set(__self__, "availability_zone_reference", availability_zone_reference)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if cluster_uuid is not None:
            pulumi.set(__self__, "cluster_uuid", cluster_uuid)
        if default_gateway_ip is not None:
            pulumi.set(__self__, "default_gateway_ip", default_gateway_ip)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dhcp_domain_name_server_lists is not None:
            pulumi.set(__self__, "dhcp_domain_name_server_lists", dhcp_domain_name_server_lists)
        if dhcp_domain_search_lists is not None:
            pulumi.set(__self__, "dhcp_domain_search_lists", dhcp_domain_search_lists)
        if dhcp_options is not None:
            pulumi.set(__self__, "dhcp_options", dhcp_options)
        if dhcp_server_address is not None:
            pulumi.set(__self__, "dhcp_server_address", dhcp_server_address)
        if dhcp_server_address_port is not None:
            pulumi.set(__self__, "dhcp_server_address_port", dhcp_server_address_port)
        if enable_nat is not None:
            pulumi.set(__self__, "enable_nat", enable_nat)
        if ip_config_pool_list_ranges is not None:
            pulumi.set(__self__, "ip_config_pool_list_ranges", ip_config_pool_list_ranges)
        if is_external is not None:
            pulumi.set(__self__, "is_external", is_external)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_function_chain_reference is not None:
            pulumi.set(__self__, "network_function_chain_reference", network_function_chain_reference)
        if owner_reference is not None:
            pulumi.set(__self__, "owner_reference", owner_reference)
        if prefix_length is not None:
            pulumi.set(__self__, "prefix_length", prefix_length)
        if project_reference is not None:
            pulumi.set(__self__, "project_reference", project_reference)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_ip is not None:
            pulumi.set(__self__, "subnet_ip", subnet_ip)
        if subnet_type is not None:
            pulumi.set(__self__, "subnet_type", subnet_type)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)
        if vpc_reference_uuid is not None:
            pulumi.set(__self__, "vpc_reference_uuid", vpc_reference_uuid)
        if vswitch_name is not None:
            pulumi.set(__self__, "vswitch_name", vswitch_name)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the API.
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZoneReference")
    def availability_zone_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The reference to a availability_zone.
        """
        return pulumi.get(self, "availability_zone_reference")

    @availability_zone_reference.setter
    def availability_zone_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zone_reference", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubnetCategoryArgs']]]]:
        """
        - (Optional) The categories of the resource.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetCategoryArgs']]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="clusterUuid")
    def cluster_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) The UUID of the cluster.
        """
        return pulumi.get(self, "cluster_uuid")

    @cluster_uuid.setter
    def cluster_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_uuid", value)

    @_builtins.property
    @pulumi.getter(name="defaultGatewayIp")
    def default_gateway_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) Default gateway IP address.
        """
        return pulumi.get(self, "default_gateway_ip")

    @default_gateway_ip.setter
    def default_gateway_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_gateway_ip", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) A description for subnet.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dhcpDomainNameServerLists")
    def dhcp_domain_name_server_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        - (Optional). List of Domain Name Server addresses .
        """
        return pulumi.get(self, "dhcp_domain_name_server_lists")

    @dhcp_domain_name_server_lists.setter
    def dhcp_domain_name_server_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dhcp_domain_name_server_lists", value)

    @_builtins.property
    @pulumi.getter(name="dhcpDomainSearchLists")
    def dhcp_domain_search_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        - (Optional).The DNS domain search list .
        """
        return pulumi.get(self, "dhcp_domain_search_lists")

    @dhcp_domain_search_lists.setter
    def dhcp_domain_search_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dhcp_domain_search_lists", value)

    @_builtins.property
    @pulumi.getter(name="dhcpOptions")
    def dhcp_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) Spec for defining DHCP options.
        """
        return pulumi.get(self, "dhcp_options")

    @dhcp_options.setter
    def dhcp_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dhcp_options", value)

    @_builtins.property
    @pulumi.getter(name="dhcpServerAddress")
    def dhcp_server_address(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) Host address.
        """
        return pulumi.get(self, "dhcp_server_address")

    @dhcp_server_address.setter
    def dhcp_server_address(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dhcp_server_address", value)

    @_builtins.property
    @pulumi.getter(name="dhcpServerAddressPort")
    def dhcp_server_address_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - (Optional) Port Number.
        """
        return pulumi.get(self, "dhcp_server_address_port")

    @dhcp_server_address_port.setter
    def dhcp_server_address_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "dhcp_server_address_port", value)

    @_builtins.property
    @pulumi.getter(name="enableNat")
    def enable_nat(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Whether NAT should be performed for VPCs attaching to the subnet. This field is supported only for external subnets. NAT is enabled by default on external subnets.
        """
        return pulumi.get(self, "enable_nat")

    @enable_nat.setter
    def enable_nat(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_nat", value)

    @_builtins.property
    @pulumi.getter(name="ipConfigPoolListRanges")
    def ip_config_pool_list_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        -(Optional) Range of IPs.
        """
        return pulumi.get(self, "ip_config_pool_list_ranges")

    @ip_config_pool_list_ranges.setter
    def ip_config_pool_list_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_config_pool_list_ranges", value)

    @_builtins.property
    @pulumi.getter(name="isExternal")
    def is_external(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Whether the subnet is external subnet or not.
        """
        return pulumi.get(self, "is_external")

    @is_external.setter
    def is_external(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_external", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Required) The subnet kind metadata.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) Subnet name (Readonly).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkFunctionChainReference")
    def network_function_chain_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The reference to a network_function_chain.
        """
        return pulumi.get(self, "network_function_chain_reference")

    @network_function_chain_reference.setter
    def network_function_chain_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "network_function_chain_reference", value)

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The reference to a user.
        """
        return pulumi.get(self, "owner_reference")

    @owner_reference.setter
    def owner_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "owner_reference", value)

    @_builtins.property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - (Optional).
        """
        return pulumi.get(self, "prefix_length")

    @prefix_length.setter
    def prefix_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "prefix_length", value)

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The reference to a project.
        """
        return pulumi.get(self, "project_reference")

    @project_reference.setter
    def project_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "project_reference", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The state of the subnet.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="subnetIp")
    def subnet_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) Subnet IP address.
        """
        return pulumi.get(self, "subnet_ip")

    @subnet_ip.setter
    def subnet_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_ip", value)

    @_builtins.property
    @pulumi.getter(name="subnetType")
    def subnet_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional). Valid Types are ["VLAN", "OVERLAY"]
        """
        return pulumi.get(self, "subnet_type")

    @subnet_type.setter
    def subnet_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_type", value)

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - (Optional). For VLAN subnet.
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vlan_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcReferenceUuid")
    def vpc_reference_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VPC reference uuid
        """
        return pulumi.get(self, "vpc_reference_uuid")

    @vpc_reference_uuid.setter
    def vpc_reference_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_reference_uuid", value)

    @_builtins.property
    @pulumi.getter(name="vswitchName")
    def vswitch_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional).
        """
        return pulumi.get(self, "vswitch_name")

    @vswitch_name.setter
    def vswitch_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_name", value)


@pulumi.type_token("nutanix:index/subnet:Subnet")
class Subnet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SubnetCategoryArgs', 'SubnetCategoryArgsDict']]]]] = None,
                 cluster_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 default_gateway_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcp_domain_name_server_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dhcp_domain_search_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dhcp_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 dhcp_server_address: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 dhcp_server_address_port: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_nat: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_config_pool_list_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_external: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_function_chain_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 subnet_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_type: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_reference_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to create a subnet based on the input parameters. A subnet is a block of IP addresses.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] availability_zone_reference: - (Optional) The reference to a availability_zone.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SubnetCategoryArgs', 'SubnetCategoryArgsDict']]]] categories: - (Optional) The categories of the resource.
        :param pulumi.Input[_builtins.str] cluster_uuid: - (Required) The UUID of the cluster.
        :param pulumi.Input[_builtins.str] default_gateway_ip: - (Optional) Default gateway IP address.
        :param pulumi.Input[_builtins.str] description: - (Optional) A description for subnet.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dhcp_domain_name_server_lists: - (Optional). List of Domain Name Server addresses .
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dhcp_domain_search_lists: - (Optional).The DNS domain search list .
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] dhcp_options: - (Optional) Spec for defining DHCP options.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] dhcp_server_address: - (Optional) Host address.
        :param pulumi.Input[_builtins.int] dhcp_server_address_port: - (Optional) Port Number.
        :param pulumi.Input[_builtins.bool] enable_nat: - (Optional) Whether NAT should be performed for VPCs attaching to the subnet. This field is supported only for external subnets. NAT is enabled by default on external subnets.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_config_pool_list_ranges: -(Optional) Range of IPs.
        :param pulumi.Input[_builtins.bool] is_external: - (Optional) Whether the subnet is external subnet or not.
        :param pulumi.Input[_builtins.str] name: - (Optional) Subnet name (Readonly).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] network_function_chain_reference: - (Optional) The reference to a network_function_chain.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] owner_reference: - (Optional) The reference to a user.
        :param pulumi.Input[_builtins.int] prefix_length: - (Optional).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] project_reference: - (Optional) The reference to a project.
        :param pulumi.Input[_builtins.str] subnet_ip: - (Optional) Subnet IP address.
        :param pulumi.Input[_builtins.str] subnet_type: - (Optional). Valid Types are ["VLAN", "OVERLAY"]
        :param pulumi.Input[_builtins.int] vlan_id: - (Optional). For VLAN subnet.
        :param pulumi.Input[_builtins.str] vpc_reference_uuid: VPC reference uuid
        :param pulumi.Input[_builtins.str] vswitch_name: - (Optional).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubnetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to create a subnet based on the input parameters. A subnet is a block of IP addresses.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param SubnetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubnetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SubnetCategoryArgs', 'SubnetCategoryArgsDict']]]]] = None,
                 cluster_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 default_gateway_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcp_domain_name_server_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dhcp_domain_search_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dhcp_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 dhcp_server_address: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 dhcp_server_address_port: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_nat: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_config_pool_list_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_external: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_function_chain_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 subnet_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_type: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_reference_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubnetArgs.__new__(SubnetArgs)

            __props__.__dict__["availability_zone_reference"] = availability_zone_reference
            __props__.__dict__["categories"] = categories
            __props__.__dict__["cluster_uuid"] = cluster_uuid
            __props__.__dict__["default_gateway_ip"] = default_gateway_ip
            __props__.__dict__["description"] = description
            __props__.__dict__["dhcp_domain_name_server_lists"] = dhcp_domain_name_server_lists
            __props__.__dict__["dhcp_domain_search_lists"] = dhcp_domain_search_lists
            __props__.__dict__["dhcp_options"] = dhcp_options
            __props__.__dict__["dhcp_server_address"] = dhcp_server_address
            __props__.__dict__["dhcp_server_address_port"] = dhcp_server_address_port
            __props__.__dict__["enable_nat"] = enable_nat
            __props__.__dict__["ip_config_pool_list_ranges"] = ip_config_pool_list_ranges
            __props__.__dict__["is_external"] = is_external
            __props__.__dict__["name"] = name
            __props__.__dict__["network_function_chain_reference"] = network_function_chain_reference
            __props__.__dict__["owner_reference"] = owner_reference
            __props__.__dict__["prefix_length"] = prefix_length
            __props__.__dict__["project_reference"] = project_reference
            __props__.__dict__["subnet_ip"] = subnet_ip
            if subnet_type is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_type'")
            __props__.__dict__["subnet_type"] = subnet_type
            __props__.__dict__["vlan_id"] = vlan_id
            __props__.__dict__["vpc_reference_uuid"] = vpc_reference_uuid
            __props__.__dict__["vswitch_name"] = vswitch_name
            __props__.__dict__["api_version"] = None
            __props__.__dict__["cluster_name"] = None
            __props__.__dict__["metadata"] = None
            __props__.__dict__["state"] = None
        super(Subnet, __self__).__init__(
            'nutanix:index/subnet:Subnet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_version: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zone_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SubnetCategoryArgs', 'SubnetCategoryArgsDict']]]]] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            default_gateway_ip: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dhcp_domain_name_server_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            dhcp_domain_search_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            dhcp_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            dhcp_server_address: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            dhcp_server_address_port: Optional[pulumi.Input[_builtins.int]] = None,
            enable_nat: Optional[pulumi.Input[_builtins.bool]] = None,
            ip_config_pool_list_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            is_external: Optional[pulumi.Input[_builtins.bool]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_function_chain_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
            project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_ip: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_type: Optional[pulumi.Input[_builtins.str]] = None,
            vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
            vpc_reference_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'Subnet':
        """
        Get an existing Subnet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_version: The version of the API.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] availability_zone_reference: - (Optional) The reference to a availability_zone.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SubnetCategoryArgs', 'SubnetCategoryArgsDict']]]] categories: - (Optional) The categories of the resource.
        :param pulumi.Input[_builtins.str] cluster_uuid: - (Required) The UUID of the cluster.
        :param pulumi.Input[_builtins.str] default_gateway_ip: - (Optional) Default gateway IP address.
        :param pulumi.Input[_builtins.str] description: - (Optional) A description for subnet.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dhcp_domain_name_server_lists: - (Optional). List of Domain Name Server addresses .
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dhcp_domain_search_lists: - (Optional).The DNS domain search list .
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] dhcp_options: - (Optional) Spec for defining DHCP options.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] dhcp_server_address: - (Optional) Host address.
        :param pulumi.Input[_builtins.int] dhcp_server_address_port: - (Optional) Port Number.
        :param pulumi.Input[_builtins.bool] enable_nat: - (Optional) Whether NAT should be performed for VPCs attaching to the subnet. This field is supported only for external subnets. NAT is enabled by default on external subnets.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_config_pool_list_ranges: -(Optional) Range of IPs.
        :param pulumi.Input[_builtins.bool] is_external: - (Optional) Whether the subnet is external subnet or not.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: - (Required) The subnet kind metadata.
        :param pulumi.Input[_builtins.str] name: - (Optional) Subnet name (Readonly).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] network_function_chain_reference: - (Optional) The reference to a network_function_chain.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] owner_reference: - (Optional) The reference to a user.
        :param pulumi.Input[_builtins.int] prefix_length: - (Optional).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] project_reference: - (Optional) The reference to a project.
        :param pulumi.Input[_builtins.str] state: - The state of the subnet.
        :param pulumi.Input[_builtins.str] subnet_ip: - (Optional) Subnet IP address.
        :param pulumi.Input[_builtins.str] subnet_type: - (Optional). Valid Types are ["VLAN", "OVERLAY"]
        :param pulumi.Input[_builtins.int] vlan_id: - (Optional). For VLAN subnet.
        :param pulumi.Input[_builtins.str] vpc_reference_uuid: VPC reference uuid
        :param pulumi.Input[_builtins.str] vswitch_name: - (Optional).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubnetState.__new__(_SubnetState)

        __props__.__dict__["api_version"] = api_version
        __props__.__dict__["availability_zone_reference"] = availability_zone_reference
        __props__.__dict__["categories"] = categories
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["cluster_uuid"] = cluster_uuid
        __props__.__dict__["default_gateway_ip"] = default_gateway_ip
        __props__.__dict__["description"] = description
        __props__.__dict__["dhcp_domain_name_server_lists"] = dhcp_domain_name_server_lists
        __props__.__dict__["dhcp_domain_search_lists"] = dhcp_domain_search_lists
        __props__.__dict__["dhcp_options"] = dhcp_options
        __props__.__dict__["dhcp_server_address"] = dhcp_server_address
        __props__.__dict__["dhcp_server_address_port"] = dhcp_server_address_port
        __props__.__dict__["enable_nat"] = enable_nat
        __props__.__dict__["ip_config_pool_list_ranges"] = ip_config_pool_list_ranges
        __props__.__dict__["is_external"] = is_external
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["network_function_chain_reference"] = network_function_chain_reference
        __props__.__dict__["owner_reference"] = owner_reference
        __props__.__dict__["prefix_length"] = prefix_length
        __props__.__dict__["project_reference"] = project_reference
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet_ip"] = subnet_ip
        __props__.__dict__["subnet_type"] = subnet_type
        __props__.__dict__["vlan_id"] = vlan_id
        __props__.__dict__["vpc_reference_uuid"] = vpc_reference_uuid
        __props__.__dict__["vswitch_name"] = vswitch_name
        return Subnet(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the API.
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter(name="availabilityZoneReference")
    def availability_zone_reference(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - (Optional) The reference to a availability_zone.
        """
        return pulumi.get(self, "availability_zone_reference")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> pulumi.Output[Sequence['outputs.SubnetCategory']]:
        """
        - (Optional) The categories of the resource.
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="clusterUuid")
    def cluster_uuid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - (Required) The UUID of the cluster.
        """
        return pulumi.get(self, "cluster_uuid")

    @_builtins.property
    @pulumi.getter(name="defaultGatewayIp")
    def default_gateway_ip(self) -> pulumi.Output[_builtins.str]:
        """
        - (Optional) Default gateway IP address.
        """
        return pulumi.get(self, "default_gateway_ip")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        - (Optional) A description for subnet.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dhcpDomainNameServerLists")
    def dhcp_domain_name_server_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        - (Optional). List of Domain Name Server addresses .
        """
        return pulumi.get(self, "dhcp_domain_name_server_lists")

    @_builtins.property
    @pulumi.getter(name="dhcpDomainSearchLists")
    def dhcp_domain_search_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        - (Optional).The DNS domain search list .
        """
        return pulumi.get(self, "dhcp_domain_search_lists")

    @_builtins.property
    @pulumi.getter(name="dhcpOptions")
    def dhcp_options(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - (Optional) Spec for defining DHCP options.
        """
        return pulumi.get(self, "dhcp_options")

    @_builtins.property
    @pulumi.getter(name="dhcpServerAddress")
    def dhcp_server_address(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - (Optional) Host address.
        """
        return pulumi.get(self, "dhcp_server_address")

    @_builtins.property
    @pulumi.getter(name="dhcpServerAddressPort")
    def dhcp_server_address_port(self) -> pulumi.Output[_builtins.int]:
        """
        - (Optional) Port Number.
        """
        return pulumi.get(self, "dhcp_server_address_port")

    @_builtins.property
    @pulumi.getter(name="enableNat")
    def enable_nat(self) -> pulumi.Output[_builtins.bool]:
        """
        - (Optional) Whether NAT should be performed for VPCs attaching to the subnet. This field is supported only for external subnets. NAT is enabled by default on external subnets.
        """
        return pulumi.get(self, "enable_nat")

    @_builtins.property
    @pulumi.getter(name="ipConfigPoolListRanges")
    def ip_config_pool_list_ranges(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        -(Optional) Range of IPs.
        """
        return pulumi.get(self, "ip_config_pool_list_ranges")

    @_builtins.property
    @pulumi.getter(name="isExternal")
    def is_external(self) -> pulumi.Output[_builtins.bool]:
        """
        - (Optional) Whether the subnet is external subnet or not.
        """
        return pulumi.get(self, "is_external")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - (Required) The subnet kind metadata.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        - (Optional) Subnet name (Readonly).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkFunctionChainReference")
    def network_function_chain_reference(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - (Optional) The reference to a network_function_chain.
        """
        return pulumi.get(self, "network_function_chain_reference")

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - (Optional) The reference to a user.
        """
        return pulumi.get(self, "owner_reference")

    @_builtins.property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> pulumi.Output[_builtins.int]:
        """
        - (Optional).
        """
        return pulumi.get(self, "prefix_length")

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - (Optional) The reference to a project.
        """
        return pulumi.get(self, "project_reference")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        - The state of the subnet.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subnetIp")
    def subnet_ip(self) -> pulumi.Output[_builtins.str]:
        """
        - (Optional) Subnet IP address.
        """
        return pulumi.get(self, "subnet_ip")

    @_builtins.property
    @pulumi.getter(name="subnetType")
    def subnet_type(self) -> pulumi.Output[_builtins.str]:
        """
        - (Optional). Valid Types are ["VLAN", "OVERLAY"]
        """
        return pulumi.get(self, "subnet_type")

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> pulumi.Output[_builtins.int]:
        """
        - (Optional). For VLAN subnet.
        """
        return pulumi.get(self, "vlan_id")

    @_builtins.property
    @pulumi.getter(name="vpcReferenceUuid")
    def vpc_reference_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        VPC reference uuid
        """
        return pulumi.get(self, "vpc_reference_uuid")

    @_builtins.property
    @pulumi.getter(name="vswitchName")
    def vswitch_name(self) -> pulumi.Output[_builtins.str]:
        """
        - (Optional).
        """
        return pulumi.get(self, "vswitch_name")

