# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['TemplateGuestOsActionsV2Args', 'TemplateGuestOsActionsV2']

@pulumi.input_type
class TemplateGuestOsActionsV2Args:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 ext_id: pulumi.Input[_builtins.str],
                 is_active_version: Optional[pulumi.Input[_builtins.str]] = None,
                 version_description: Optional[pulumi.Input[_builtins.str]] = None,
                 version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TemplateGuestOsActionsV2 resource.
        :param pulumi.Input[_builtins.str] action: Actions to be performed. Acceptable values are "initiate", "complete", "cancel" .
        :param pulumi.Input[_builtins.str] ext_id: The identifier of a Template.
        :param pulumi.Input[_builtins.str] is_active_version: Specify whether to mark the Template Version as active or not. The newly created Version during Template Creation, Updating or Guest OS Updating is set to Active by default unless specified otherwise. Default is true. Only applicable with `complete` action.
               
               
               See detailed information in [Nutanix Template Guest OS Action Initiate V4](https://developers.nutanix.com/api-reference?namespace=vmm&version=v4.0#tag/Templates/operation/initiateGuestUpdate).
               See detailed information in [Nutanix Template Guest OS Action Complete V4](https://developers.nutanix.com/api-reference?namespace=vmm&version=v4.0#tag/Templates/operation/completeGuestUpdate).
               See detailed information in [Nutanix Template Guest OS Action Cancel V4](https://developers.nutanix.com/api-reference?namespace=vmm&version=v4.0#tag/Templates/operation/cancelGuestUpdate).
        :param pulumi.Input[_builtins.str] version_description: The user defined description of a Template Version. (Required) Only applicable with `complete` action.
        :param pulumi.Input[_builtins.str] version_id: The identifier of a Template Version. Only applicable with `Initiate` action.
        :param pulumi.Input[_builtins.str] version_name: The user defined name of a Template Version. Only applicable with `complete` action.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "ext_id", ext_id)
        if is_active_version is not None:
            pulumi.set(__self__, "is_active_version", is_active_version)
        if version_description is not None:
            pulumi.set(__self__, "version_description", version_description)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)
        if version_name is not None:
            pulumi.set(__self__, "version_name", version_name)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        Actions to be performed. Acceptable values are "initiate", "complete", "cancel" .
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        The identifier of a Template.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="isActiveVersion")
    def is_active_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify whether to mark the Template Version as active or not. The newly created Version during Template Creation, Updating or Guest OS Updating is set to Active by default unless specified otherwise. Default is true. Only applicable with `complete` action.


        See detailed information in [Nutanix Template Guest OS Action Initiate V4](https://developers.nutanix.com/api-reference?namespace=vmm&version=v4.0#tag/Templates/operation/initiateGuestUpdate).
        See detailed information in [Nutanix Template Guest OS Action Complete V4](https://developers.nutanix.com/api-reference?namespace=vmm&version=v4.0#tag/Templates/operation/completeGuestUpdate).
        See detailed information in [Nutanix Template Guest OS Action Cancel V4](https://developers.nutanix.com/api-reference?namespace=vmm&version=v4.0#tag/Templates/operation/cancelGuestUpdate).
        """
        return pulumi.get(self, "is_active_version")

    @is_active_version.setter
    def is_active_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "is_active_version", value)

    @_builtins.property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user defined description of a Template Version. (Required) Only applicable with `complete` action.
        """
        return pulumi.get(self, "version_description")

    @version_description.setter
    def version_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_description", value)

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of a Template Version. Only applicable with `Initiate` action.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_id", value)

    @_builtins.property
    @pulumi.getter(name="versionName")
    def version_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user defined name of a Template Version. Only applicable with `complete` action.
        """
        return pulumi.get(self, "version_name")

    @version_name.setter
    def version_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_name", value)


@pulumi.input_type
class _TemplateGuestOsActionsV2State:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_active_version: Optional[pulumi.Input[_builtins.str]] = None,
                 version_description: Optional[pulumi.Input[_builtins.str]] = None,
                 version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TemplateGuestOsActionsV2 resources.
        :param pulumi.Input[_builtins.str] action: Actions to be performed. Acceptable values are "initiate", "complete", "cancel" .
        :param pulumi.Input[_builtins.str] ext_id: The identifier of a Template.
        :param pulumi.Input[_builtins.str] is_active_version: Specify whether to mark the Template Version as active or not. The newly created Version during Template Creation, Updating or Guest OS Updating is set to Active by default unless specified otherwise. Default is true. Only applicable with `complete` action.
               
               
               See detailed information in [Nutanix Template Guest OS Action Initiate V4](https://developers.nutanix.com/api-reference?namespace=vmm&version=v4.0#tag/Templates/operation/initiateGuestUpdate).
               See detailed information in [Nutanix Template Guest OS Action Complete V4](https://developers.nutanix.com/api-reference?namespace=vmm&version=v4.0#tag/Templates/operation/completeGuestUpdate).
               See detailed information in [Nutanix Template Guest OS Action Cancel V4](https://developers.nutanix.com/api-reference?namespace=vmm&version=v4.0#tag/Templates/operation/cancelGuestUpdate).
        :param pulumi.Input[_builtins.str] version_description: The user defined description of a Template Version. (Required) Only applicable with `complete` action.
        :param pulumi.Input[_builtins.str] version_id: The identifier of a Template Version. Only applicable with `Initiate` action.
        :param pulumi.Input[_builtins.str] version_name: The user defined name of a Template Version. Only applicable with `complete` action.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if is_active_version is not None:
            pulumi.set(__self__, "is_active_version", is_active_version)
        if version_description is not None:
            pulumi.set(__self__, "version_description", version_description)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)
        if version_name is not None:
            pulumi.set(__self__, "version_name", version_name)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Actions to be performed. Acceptable values are "initiate", "complete", "cancel" .
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of a Template.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="isActiveVersion")
    def is_active_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify whether to mark the Template Version as active or not. The newly created Version during Template Creation, Updating or Guest OS Updating is set to Active by default unless specified otherwise. Default is true. Only applicable with `complete` action.


        See detailed information in [Nutanix Template Guest OS Action Initiate V4](https://developers.nutanix.com/api-reference?namespace=vmm&version=v4.0#tag/Templates/operation/initiateGuestUpdate).
        See detailed information in [Nutanix Template Guest OS Action Complete V4](https://developers.nutanix.com/api-reference?namespace=vmm&version=v4.0#tag/Templates/operation/completeGuestUpdate).
        See detailed information in [Nutanix Template Guest OS Action Cancel V4](https://developers.nutanix.com/api-reference?namespace=vmm&version=v4.0#tag/Templates/operation/cancelGuestUpdate).
        """
        return pulumi.get(self, "is_active_version")

    @is_active_version.setter
    def is_active_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "is_active_version", value)

    @_builtins.property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user defined description of a Template Version. (Required) Only applicable with `complete` action.
        """
        return pulumi.get(self, "version_description")

    @version_description.setter
    def version_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_description", value)

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of a Template Version. Only applicable with `Initiate` action.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_id", value)

    @_builtins.property
    @pulumi.getter(name="versionName")
    def version_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user defined name of a Template Version. Only applicable with `complete` action.
        """
        return pulumi.get(self, "version_name")

    @version_name.setter
    def version_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_name", value)


@pulumi.type_token("nutanix:index/templateGuestOsActionsV2:TemplateGuestOsActionsV2")
class TemplateGuestOsActionsV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_active_version: Optional[pulumi.Input[_builtins.str]] = None,
                 version_description: Optional[pulumi.Input[_builtins.str]] = None,
                 version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Performs Guest OS actions on given template. It Initiates, Completes and Cancels the Guest OS operation.

        ## Example

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        example_1 = nutanix.TemplateGuestOsActionsV2("example-1",
            ext_id="ab520e1d-4950-1db1-917f-a9e2ea35b8e3",
            action="initiate",
            version_id="c2c249b0-98a0-43fa-9ff6-dcde578d3936")
        example_2 = nutanix.TemplateGuestOsActionsV2("example-2",
            ext_id="8a938cc5-282b-48c4-81be-de22de145d07",
            action="complete",
            version_name="version_name",
            version_description="version desc",
            is_active_version="true")
        example_3 = nutanix.TemplateGuestOsActionsV2("example-3",
            ext_id="1cefd0f5-6d38-4c9b-a07c-bdd2db004224",
            action="cancel")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: Actions to be performed. Acceptable values are "initiate", "complete", "cancel" .
        :param pulumi.Input[_builtins.str] ext_id: The identifier of a Template.
        :param pulumi.Input[_builtins.str] is_active_version: Specify whether to mark the Template Version as active or not. The newly created Version during Template Creation, Updating or Guest OS Updating is set to Active by default unless specified otherwise. Default is true. Only applicable with `complete` action.
               
               
               See detailed information in [Nutanix Template Guest OS Action Initiate V4](https://developers.nutanix.com/api-reference?namespace=vmm&version=v4.0#tag/Templates/operation/initiateGuestUpdate).
               See detailed information in [Nutanix Template Guest OS Action Complete V4](https://developers.nutanix.com/api-reference?namespace=vmm&version=v4.0#tag/Templates/operation/completeGuestUpdate).
               See detailed information in [Nutanix Template Guest OS Action Cancel V4](https://developers.nutanix.com/api-reference?namespace=vmm&version=v4.0#tag/Templates/operation/cancelGuestUpdate).
        :param pulumi.Input[_builtins.str] version_description: The user defined description of a Template Version. (Required) Only applicable with `complete` action.
        :param pulumi.Input[_builtins.str] version_id: The identifier of a Template Version. Only applicable with `Initiate` action.
        :param pulumi.Input[_builtins.str] version_name: The user defined name of a Template Version. Only applicable with `complete` action.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TemplateGuestOsActionsV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Performs Guest OS actions on given template. It Initiates, Completes and Cancels the Guest OS operation.

        ## Example

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        example_1 = nutanix.TemplateGuestOsActionsV2("example-1",
            ext_id="ab520e1d-4950-1db1-917f-a9e2ea35b8e3",
            action="initiate",
            version_id="c2c249b0-98a0-43fa-9ff6-dcde578d3936")
        example_2 = nutanix.TemplateGuestOsActionsV2("example-2",
            ext_id="8a938cc5-282b-48c4-81be-de22de145d07",
            action="complete",
            version_name="version_name",
            version_description="version desc",
            is_active_version="true")
        example_3 = nutanix.TemplateGuestOsActionsV2("example-3",
            ext_id="1cefd0f5-6d38-4c9b-a07c-bdd2db004224",
            action="cancel")
        ```

        :param str resource_name: The name of the resource.
        :param TemplateGuestOsActionsV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TemplateGuestOsActionsV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_active_version: Optional[pulumi.Input[_builtins.str]] = None,
                 version_description: Optional[pulumi.Input[_builtins.str]] = None,
                 version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TemplateGuestOsActionsV2Args.__new__(TemplateGuestOsActionsV2Args)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            if ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'ext_id'")
            __props__.__dict__["ext_id"] = ext_id
            __props__.__dict__["is_active_version"] = is_active_version
            __props__.__dict__["version_description"] = version_description
            __props__.__dict__["version_id"] = version_id
            __props__.__dict__["version_name"] = version_name
        super(TemplateGuestOsActionsV2, __self__).__init__(
            'nutanix:index/templateGuestOsActionsV2:TemplateGuestOsActionsV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[_builtins.str]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_active_version: Optional[pulumi.Input[_builtins.str]] = None,
            version_description: Optional[pulumi.Input[_builtins.str]] = None,
            version_id: Optional[pulumi.Input[_builtins.str]] = None,
            version_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'TemplateGuestOsActionsV2':
        """
        Get an existing TemplateGuestOsActionsV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: Actions to be performed. Acceptable values are "initiate", "complete", "cancel" .
        :param pulumi.Input[_builtins.str] ext_id: The identifier of a Template.
        :param pulumi.Input[_builtins.str] is_active_version: Specify whether to mark the Template Version as active or not. The newly created Version during Template Creation, Updating or Guest OS Updating is set to Active by default unless specified otherwise. Default is true. Only applicable with `complete` action.
               
               
               See detailed information in [Nutanix Template Guest OS Action Initiate V4](https://developers.nutanix.com/api-reference?namespace=vmm&version=v4.0#tag/Templates/operation/initiateGuestUpdate).
               See detailed information in [Nutanix Template Guest OS Action Complete V4](https://developers.nutanix.com/api-reference?namespace=vmm&version=v4.0#tag/Templates/operation/completeGuestUpdate).
               See detailed information in [Nutanix Template Guest OS Action Cancel V4](https://developers.nutanix.com/api-reference?namespace=vmm&version=v4.0#tag/Templates/operation/cancelGuestUpdate).
        :param pulumi.Input[_builtins.str] version_description: The user defined description of a Template Version. (Required) Only applicable with `complete` action.
        :param pulumi.Input[_builtins.str] version_id: The identifier of a Template Version. Only applicable with `Initiate` action.
        :param pulumi.Input[_builtins.str] version_name: The user defined name of a Template Version. Only applicable with `complete` action.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TemplateGuestOsActionsV2State.__new__(_TemplateGuestOsActionsV2State)

        __props__.__dict__["action"] = action
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["is_active_version"] = is_active_version
        __props__.__dict__["version_description"] = version_description
        __props__.__dict__["version_id"] = version_id
        __props__.__dict__["version_name"] = version_name
        return TemplateGuestOsActionsV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[_builtins.str]:
        """
        Actions to be performed. Acceptable values are "initiate", "complete", "cancel" .
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier of a Template.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="isActiveVersion")
    def is_active_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specify whether to mark the Template Version as active or not. The newly created Version during Template Creation, Updating or Guest OS Updating is set to Active by default unless specified otherwise. Default is true. Only applicable with `complete` action.


        See detailed information in [Nutanix Template Guest OS Action Initiate V4](https://developers.nutanix.com/api-reference?namespace=vmm&version=v4.0#tag/Templates/operation/initiateGuestUpdate).
        See detailed information in [Nutanix Template Guest OS Action Complete V4](https://developers.nutanix.com/api-reference?namespace=vmm&version=v4.0#tag/Templates/operation/completeGuestUpdate).
        See detailed information in [Nutanix Template Guest OS Action Cancel V4](https://developers.nutanix.com/api-reference?namespace=vmm&version=v4.0#tag/Templates/operation/cancelGuestUpdate).
        """
        return pulumi.get(self, "is_active_version")

    @_builtins.property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The user defined description of a Template Version. (Required) Only applicable with `complete` action.
        """
        return pulumi.get(self, "version_description")

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The identifier of a Template Version. Only applicable with `Initiate` action.
        """
        return pulumi.get(self, "version_id")

    @_builtins.property
    @pulumi.getter(name="versionName")
    def version_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The user defined name of a Template Version. Only applicable with `complete` action.
        """
        return pulumi.get(self, "version_name")

