# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['UserCategoryArgs']]]] = None,
                 directory_service_user: Optional[pulumi.Input['UserDirectoryServiceUserArgs']] = None,
                 identity_provider_user: Optional[pulumi.Input['UserIdentityProviderUserArgs']] = None,
                 owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[Sequence[pulumi.Input['UserCategoryArgs']]] categories: - (Optional) Categories for the Access Control Policy.
        :param pulumi.Input['UserDirectoryServiceUserArgs'] directory_service_user: - (Optional) The directory service user configuration. See below for more information.
        :param pulumi.Input['UserIdentityProviderUserArgs'] identity_provider_user: - (Optional) (Optional) The identity provider user configuration. See below for more information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] owner_reference: - (Optional) The reference to a user.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] project_reference: - (Optional) The reference to a project.
        """
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if directory_service_user is not None:
            pulumi.set(__self__, "directory_service_user", directory_service_user)
        if identity_provider_user is not None:
            pulumi.set(__self__, "identity_provider_user", identity_provider_user)
        if owner_reference is not None:
            pulumi.set(__self__, "owner_reference", owner_reference)
        if project_reference is not None:
            pulumi.set(__self__, "project_reference", project_reference)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserCategoryArgs']]]]:
        """
        - (Optional) Categories for the Access Control Policy.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserCategoryArgs']]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter(name="directoryServiceUser")
    def directory_service_user(self) -> Optional[pulumi.Input['UserDirectoryServiceUserArgs']]:
        """
        - (Optional) The directory service user configuration. See below for more information.
        """
        return pulumi.get(self, "directory_service_user")

    @directory_service_user.setter
    def directory_service_user(self, value: Optional[pulumi.Input['UserDirectoryServiceUserArgs']]):
        pulumi.set(self, "directory_service_user", value)

    @_builtins.property
    @pulumi.getter(name="identityProviderUser")
    def identity_provider_user(self) -> Optional[pulumi.Input['UserIdentityProviderUserArgs']]:
        """
        - (Optional) (Optional) The identity provider user configuration. See below for more information.
        """
        return pulumi.get(self, "identity_provider_user")

    @identity_provider_user.setter
    def identity_provider_user(self, value: Optional[pulumi.Input['UserIdentityProviderUserArgs']]):
        pulumi.set(self, "identity_provider_user", value)

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The reference to a user.
        """
        return pulumi.get(self, "owner_reference")

    @owner_reference.setter
    def owner_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "owner_reference", value)

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The reference to a project.
        """
        return pulumi.get(self, "project_reference")

    @project_reference.setter
    def project_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "project_reference", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 access_control_policy_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input['UserAccessControlPolicyReferenceListArgs']]]] = None,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['UserCategoryArgs']]]] = None,
                 directory_service_user: Optional[pulumi.Input['UserDirectoryServiceUserArgs']] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_provider_user: Optional[pulumi.Input['UserIdentityProviderUserArgs']] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input['UserProjectReferenceListArgs']]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[Sequence[pulumi.Input['UserAccessControlPolicyReferenceListArgs']]] access_control_policy_reference_lists: - List of ACP references. See #reference for more details.
        :param pulumi.Input[_builtins.str] api_version: The version of the API.
        :param pulumi.Input[Sequence[pulumi.Input['UserCategoryArgs']]] categories: - (Optional) Categories for the Access Control Policy.
        :param pulumi.Input['UserDirectoryServiceUserArgs'] directory_service_user: - (Optional) The directory service user configuration. See below for more information.
        :param pulumi.Input[_builtins.str] display_name: - The display name of the user (common name) provided by the directory service.
        :param pulumi.Input['UserIdentityProviderUserArgs'] identity_provider_user: - (Optional) (Optional) The identity provider user configuration. See below for more information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: - The vm kind metadata.
        :param pulumi.Input[_builtins.str] name: - the name(Optional).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] owner_reference: - (Optional) The reference to a user.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] project_reference: - (Optional) The reference to a project.
        :param pulumi.Input[Sequence[pulumi.Input['UserProjectReferenceListArgs']]] project_reference_lists: - A list of projects the user is part of. See #reference for more details.
        :param pulumi.Input[_builtins.str] state: - The state of the entity.
        :param pulumi.Input[_builtins.str] user_type: - The name of the user.
        """
        if access_control_policy_reference_lists is not None:
            pulumi.set(__self__, "access_control_policy_reference_lists", access_control_policy_reference_lists)
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if directory_service_user is not None:
            pulumi.set(__self__, "directory_service_user", directory_service_user)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if identity_provider_user is not None:
            pulumi.set(__self__, "identity_provider_user", identity_provider_user)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_reference is not None:
            pulumi.set(__self__, "owner_reference", owner_reference)
        if project_reference is not None:
            pulumi.set(__self__, "project_reference", project_reference)
        if project_reference_lists is not None:
            pulumi.set(__self__, "project_reference_lists", project_reference_lists)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if user_type is not None:
            pulumi.set(__self__, "user_type", user_type)

    @_builtins.property
    @pulumi.getter(name="accessControlPolicyReferenceLists")
    def access_control_policy_reference_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserAccessControlPolicyReferenceListArgs']]]]:
        """
        - List of ACP references. See #reference for more details.
        """
        return pulumi.get(self, "access_control_policy_reference_lists")

    @access_control_policy_reference_lists.setter
    def access_control_policy_reference_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserAccessControlPolicyReferenceListArgs']]]]):
        pulumi.set(self, "access_control_policy_reference_lists", value)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the API.
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserCategoryArgs']]]]:
        """
        - (Optional) Categories for the Access Control Policy.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserCategoryArgs']]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter(name="directoryServiceUser")
    def directory_service_user(self) -> Optional[pulumi.Input['UserDirectoryServiceUserArgs']]:
        """
        - (Optional) The directory service user configuration. See below for more information.
        """
        return pulumi.get(self, "directory_service_user")

    @directory_service_user.setter
    def directory_service_user(self, value: Optional[pulumi.Input['UserDirectoryServiceUserArgs']]):
        pulumi.set(self, "directory_service_user", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The display name of the user (common name) provided by the directory service.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="identityProviderUser")
    def identity_provider_user(self) -> Optional[pulumi.Input['UserIdentityProviderUserArgs']]:
        """
        - (Optional) (Optional) The identity provider user configuration. See below for more information.
        """
        return pulumi.get(self, "identity_provider_user")

    @identity_provider_user.setter
    def identity_provider_user(self, value: Optional[pulumi.Input['UserIdentityProviderUserArgs']]):
        pulumi.set(self, "identity_provider_user", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - The vm kind metadata.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - the name(Optional).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The reference to a user.
        """
        return pulumi.get(self, "owner_reference")

    @owner_reference.setter
    def owner_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "owner_reference", value)

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The reference to a project.
        """
        return pulumi.get(self, "project_reference")

    @project_reference.setter
    def project_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "project_reference", value)

    @_builtins.property
    @pulumi.getter(name="projectReferenceLists")
    def project_reference_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserProjectReferenceListArgs']]]]:
        """
        - A list of projects the user is part of. See #reference for more details.
        """
        return pulumi.get(self, "project_reference_lists")

    @project_reference_lists.setter
    def project_reference_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserProjectReferenceListArgs']]]]):
        pulumi.set(self, "project_reference_lists", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The state of the entity.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="userType")
    def user_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The name of the user.
        """
        return pulumi.get(self, "user_type")

    @user_type.setter
    def user_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_type", value)


@pulumi.type_token("nutanix:index/user:User")
class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserCategoryArgs', 'UserCategoryArgsDict']]]]] = None,
                 directory_service_user: Optional[pulumi.Input[Union['UserDirectoryServiceUserArgs', 'UserDirectoryServiceUserArgsDict']]] = None,
                 identity_provider_user: Optional[pulumi.Input[Union['UserIdentityProviderUserArgs', 'UserIdentityProviderUserArgsDict']]] = None,
                 owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a resource to create a user based on the input parameters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        user = nutanix.User("user", directory_service_user={
            "user_principal_name": "test-user@ntnxlab.local",
            "directory_service_reference": {
                "uuid": "<directory-service-uuid>",
            },
        })
        ```

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        user = nutanix.User("user", identity_provider_user={
            "username": "username",
            "identity_provider_reference": {
                "uuid": "<identity-provider-uuid>",
            },
        })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserCategoryArgs', 'UserCategoryArgsDict']]]] categories: - (Optional) Categories for the Access Control Policy.
        :param pulumi.Input[Union['UserDirectoryServiceUserArgs', 'UserDirectoryServiceUserArgsDict']] directory_service_user: - (Optional) The directory service user configuration. See below for more information.
        :param pulumi.Input[Union['UserIdentityProviderUserArgs', 'UserIdentityProviderUserArgsDict']] identity_provider_user: - (Optional) (Optional) The identity provider user configuration. See below for more information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] owner_reference: - (Optional) The reference to a user.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] project_reference: - (Optional) The reference to a project.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[UserArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to create a user based on the input parameters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        user = nutanix.User("user", directory_service_user={
            "user_principal_name": "test-user@ntnxlab.local",
            "directory_service_reference": {
                "uuid": "<directory-service-uuid>",
            },
        })
        ```

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        user = nutanix.User("user", identity_provider_user={
            "username": "username",
            "identity_provider_reference": {
                "uuid": "<identity-provider-uuid>",
            },
        })
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserCategoryArgs', 'UserCategoryArgsDict']]]]] = None,
                 directory_service_user: Optional[pulumi.Input[Union['UserDirectoryServiceUserArgs', 'UserDirectoryServiceUserArgsDict']]] = None,
                 identity_provider_user: Optional[pulumi.Input[Union['UserIdentityProviderUserArgs', 'UserIdentityProviderUserArgsDict']]] = None,
                 owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            __props__.__dict__["categories"] = categories
            __props__.__dict__["directory_service_user"] = directory_service_user
            __props__.__dict__["identity_provider_user"] = identity_provider_user
            __props__.__dict__["owner_reference"] = owner_reference
            __props__.__dict__["project_reference"] = project_reference
            __props__.__dict__["access_control_policy_reference_lists"] = None
            __props__.__dict__["api_version"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["metadata"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["project_reference_lists"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["user_type"] = None
        super(User, __self__).__init__(
            'nutanix:index/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_control_policy_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserAccessControlPolicyReferenceListArgs', 'UserAccessControlPolicyReferenceListArgsDict']]]]] = None,
            api_version: Optional[pulumi.Input[_builtins.str]] = None,
            categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserCategoryArgs', 'UserCategoryArgsDict']]]]] = None,
            directory_service_user: Optional[pulumi.Input[Union['UserDirectoryServiceUserArgs', 'UserDirectoryServiceUserArgsDict']]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            identity_provider_user: Optional[pulumi.Input[Union['UserIdentityProviderUserArgs', 'UserIdentityProviderUserArgsDict']]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            project_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserProjectReferenceListArgs', 'UserProjectReferenceListArgsDict']]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            user_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserAccessControlPolicyReferenceListArgs', 'UserAccessControlPolicyReferenceListArgsDict']]]] access_control_policy_reference_lists: - List of ACP references. See #reference for more details.
        :param pulumi.Input[_builtins.str] api_version: The version of the API.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserCategoryArgs', 'UserCategoryArgsDict']]]] categories: - (Optional) Categories for the Access Control Policy.
        :param pulumi.Input[Union['UserDirectoryServiceUserArgs', 'UserDirectoryServiceUserArgsDict']] directory_service_user: - (Optional) The directory service user configuration. See below for more information.
        :param pulumi.Input[_builtins.str] display_name: - The display name of the user (common name) provided by the directory service.
        :param pulumi.Input[Union['UserIdentityProviderUserArgs', 'UserIdentityProviderUserArgsDict']] identity_provider_user: - (Optional) (Optional) The identity provider user configuration. See below for more information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: - The vm kind metadata.
        :param pulumi.Input[_builtins.str] name: - the name(Optional).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] owner_reference: - (Optional) The reference to a user.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] project_reference: - (Optional) The reference to a project.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserProjectReferenceListArgs', 'UserProjectReferenceListArgsDict']]]] project_reference_lists: - A list of projects the user is part of. See #reference for more details.
        :param pulumi.Input[_builtins.str] state: - The state of the entity.
        :param pulumi.Input[_builtins.str] user_type: - The name of the user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["access_control_policy_reference_lists"] = access_control_policy_reference_lists
        __props__.__dict__["api_version"] = api_version
        __props__.__dict__["categories"] = categories
        __props__.__dict__["directory_service_user"] = directory_service_user
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["identity_provider_user"] = identity_provider_user
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["owner_reference"] = owner_reference
        __props__.__dict__["project_reference"] = project_reference
        __props__.__dict__["project_reference_lists"] = project_reference_lists
        __props__.__dict__["state"] = state
        __props__.__dict__["user_type"] = user_type
        return User(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessControlPolicyReferenceLists")
    def access_control_policy_reference_lists(self) -> pulumi.Output[Sequence['outputs.UserAccessControlPolicyReferenceList']]:
        """
        - List of ACP references. See #reference for more details.
        """
        return pulumi.get(self, "access_control_policy_reference_lists")

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the API.
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> pulumi.Output[Sequence['outputs.UserCategory']]:
        """
        - (Optional) Categories for the Access Control Policy.
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter(name="directoryServiceUser")
    def directory_service_user(self) -> pulumi.Output['outputs.UserDirectoryServiceUser']:
        """
        - (Optional) The directory service user configuration. See below for more information.
        """
        return pulumi.get(self, "directory_service_user")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        - The display name of the user (common name) provided by the directory service.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="identityProviderUser")
    def identity_provider_user(self) -> pulumi.Output['outputs.UserIdentityProviderUser']:
        """
        - (Optional) (Optional) The identity provider user configuration. See below for more information.
        """
        return pulumi.get(self, "identity_provider_user")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - The vm kind metadata.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        - the name(Optional).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - (Optional) The reference to a user.
        """
        return pulumi.get(self, "owner_reference")

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        - (Optional) The reference to a project.
        """
        return pulumi.get(self, "project_reference")

    @_builtins.property
    @pulumi.getter(name="projectReferenceLists")
    def project_reference_lists(self) -> pulumi.Output[Sequence['outputs.UserProjectReferenceList']]:
        """
        - A list of projects the user is part of. See #reference for more details.
        """
        return pulumi.get(self, "project_reference_lists")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        - The state of the entity.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="userType")
    def user_type(self) -> pulumi.Output[_builtins.str]:
        """
        - The name of the user.
        """
        return pulumi.get(self, "user_type")

