# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserGroupsArgs', 'UserGroups']

@pulumi.input_type
class UserGroupsArgs:
    def __init__(__self__, *,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['UserGroupsCategoryArgs']]]] = None,
                 directory_service_ous: Optional[pulumi.Input[Sequence[pulumi.Input['UserGroupsDirectoryServiceOusArgs']]]] = None,
                 directory_service_user_groups: Optional[pulumi.Input[Sequence[pulumi.Input['UserGroupsDirectoryServiceUserGroupArgs']]]] = None,
                 owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 saml_user_groups: Optional[pulumi.Input[Sequence[pulumi.Input['UserGroupsSamlUserGroupArgs']]]] = None):
        """
        The set of arguments for constructing a UserGroups resource.
        :param pulumi.Input[Sequence[pulumi.Input['UserGroupsDirectoryServiceOusArgs']]] directory_service_ous: - (Optional) A Directory Service organizational unit.
        :param pulumi.Input[Sequence[pulumi.Input['UserGroupsDirectoryServiceUserGroupArgs']]] directory_service_user_groups: - (Optional) A Directory Service user group.
        :param pulumi.Input[Sequence[pulumi.Input['UserGroupsSamlUserGroupArgs']]] saml_user_groups: - (Optional) A SAML Service user group.
        """
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if directory_service_ous is not None:
            pulumi.set(__self__, "directory_service_ous", directory_service_ous)
        if directory_service_user_groups is not None:
            pulumi.set(__self__, "directory_service_user_groups", directory_service_user_groups)
        if owner_reference is not None:
            pulumi.set(__self__, "owner_reference", owner_reference)
        if project_reference is not None:
            pulumi.set(__self__, "project_reference", project_reference)
        if saml_user_groups is not None:
            pulumi.set(__self__, "saml_user_groups", saml_user_groups)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserGroupsCategoryArgs']]]]:
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserGroupsCategoryArgs']]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter(name="directoryServiceOus")
    def directory_service_ous(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserGroupsDirectoryServiceOusArgs']]]]:
        """
        - (Optional) A Directory Service organizational unit.
        """
        return pulumi.get(self, "directory_service_ous")

    @directory_service_ous.setter
    def directory_service_ous(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserGroupsDirectoryServiceOusArgs']]]]):
        pulumi.set(self, "directory_service_ous", value)

    @_builtins.property
    @pulumi.getter(name="directoryServiceUserGroups")
    def directory_service_user_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserGroupsDirectoryServiceUserGroupArgs']]]]:
        """
        - (Optional) A Directory Service user group.
        """
        return pulumi.get(self, "directory_service_user_groups")

    @directory_service_user_groups.setter
    def directory_service_user_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserGroupsDirectoryServiceUserGroupArgs']]]]):
        pulumi.set(self, "directory_service_user_groups", value)

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "owner_reference")

    @owner_reference.setter
    def owner_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "owner_reference", value)

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "project_reference")

    @project_reference.setter
    def project_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "project_reference", value)

    @_builtins.property
    @pulumi.getter(name="samlUserGroups")
    def saml_user_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserGroupsSamlUserGroupArgs']]]]:
        """
        - (Optional) A SAML Service user group.
        """
        return pulumi.get(self, "saml_user_groups")

    @saml_user_groups.setter
    def saml_user_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserGroupsSamlUserGroupArgs']]]]):
        pulumi.set(self, "saml_user_groups", value)


@pulumi.input_type
class _UserGroupsState:
    def __init__(__self__, *,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['UserGroupsCategoryArgs']]]] = None,
                 directory_service_ous: Optional[pulumi.Input[Sequence[pulumi.Input['UserGroupsDirectoryServiceOusArgs']]]] = None,
                 directory_service_user_groups: Optional[pulumi.Input[Sequence[pulumi.Input['UserGroupsDirectoryServiceUserGroupArgs']]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 saml_user_groups: Optional[pulumi.Input[Sequence[pulumi.Input['UserGroupsSamlUserGroupArgs']]]] = None):
        """
        Input properties used for looking up and filtering UserGroups resources.
        :param pulumi.Input[Sequence[pulumi.Input['UserGroupsDirectoryServiceOusArgs']]] directory_service_ous: - (Optional) A Directory Service organizational unit.
        :param pulumi.Input[Sequence[pulumi.Input['UserGroupsDirectoryServiceUserGroupArgs']]] directory_service_user_groups: - (Optional) A Directory Service user group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: The user_group kind metadata.
        :param pulumi.Input[Sequence[pulumi.Input['UserGroupsSamlUserGroupArgs']]] saml_user_groups: - (Optional) A SAML Service user group.
        """
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if directory_service_ous is not None:
            pulumi.set(__self__, "directory_service_ous", directory_service_ous)
        if directory_service_user_groups is not None:
            pulumi.set(__self__, "directory_service_user_groups", directory_service_user_groups)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if owner_reference is not None:
            pulumi.set(__self__, "owner_reference", owner_reference)
        if project_reference is not None:
            pulumi.set(__self__, "project_reference", project_reference)
        if saml_user_groups is not None:
            pulumi.set(__self__, "saml_user_groups", saml_user_groups)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserGroupsCategoryArgs']]]]:
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserGroupsCategoryArgs']]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter(name="directoryServiceOus")
    def directory_service_ous(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserGroupsDirectoryServiceOusArgs']]]]:
        """
        - (Optional) A Directory Service organizational unit.
        """
        return pulumi.get(self, "directory_service_ous")

    @directory_service_ous.setter
    def directory_service_ous(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserGroupsDirectoryServiceOusArgs']]]]):
        pulumi.set(self, "directory_service_ous", value)

    @_builtins.property
    @pulumi.getter(name="directoryServiceUserGroups")
    def directory_service_user_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserGroupsDirectoryServiceUserGroupArgs']]]]:
        """
        - (Optional) A Directory Service user group.
        """
        return pulumi.get(self, "directory_service_user_groups")

    @directory_service_user_groups.setter
    def directory_service_user_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserGroupsDirectoryServiceUserGroupArgs']]]]):
        pulumi.set(self, "directory_service_user_groups", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The user_group kind metadata.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "owner_reference")

    @owner_reference.setter
    def owner_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "owner_reference", value)

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "project_reference")

    @project_reference.setter
    def project_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "project_reference", value)

    @_builtins.property
    @pulumi.getter(name="samlUserGroups")
    def saml_user_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserGroupsSamlUserGroupArgs']]]]:
        """
        - (Optional) A SAML Service user group.
        """
        return pulumi.get(self, "saml_user_groups")

    @saml_user_groups.setter
    def saml_user_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserGroupsSamlUserGroupArgs']]]]):
        pulumi.set(self, "saml_user_groups", value)


@pulumi.type_token("nutanix:index/userGroups:UserGroups")
class UserGroups(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserGroupsCategoryArgs', 'UserGroupsCategoryArgsDict']]]]] = None,
                 directory_service_ous: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserGroupsDirectoryServiceOusArgs', 'UserGroupsDirectoryServiceOusArgsDict']]]]] = None,
                 directory_service_user_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserGroupsDirectoryServiceUserGroupArgs', 'UserGroupsDirectoryServiceUserGroupArgsDict']]]]] = None,
                 owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 saml_user_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserGroupsSamlUserGroupArgs', 'UserGroupsSamlUserGroupArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a resource to add a User group to the system..

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        user_grp = nutanix.UserGroups("user_grp", directory_service_user_groups=[{
            "distinguished_name": "<distinguished name for the user group>",
        }])
        ```

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        user_grp = nutanix.UserGroups("user_grp", saml_user_groups=[{
            "name": "<name of saml group>",
            "idp_uuid": "<idp uuid of the group>",
        }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserGroupsDirectoryServiceOusArgs', 'UserGroupsDirectoryServiceOusArgsDict']]]] directory_service_ous: - (Optional) A Directory Service organizational unit.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserGroupsDirectoryServiceUserGroupArgs', 'UserGroupsDirectoryServiceUserGroupArgsDict']]]] directory_service_user_groups: - (Optional) A Directory Service user group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserGroupsSamlUserGroupArgs', 'UserGroupsSamlUserGroupArgsDict']]]] saml_user_groups: - (Optional) A SAML Service user group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[UserGroupsArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to add a User group to the system..

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        user_grp = nutanix.UserGroups("user_grp", directory_service_user_groups=[{
            "distinguished_name": "<distinguished name for the user group>",
        }])
        ```

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        user_grp = nutanix.UserGroups("user_grp", saml_user_groups=[{
            "name": "<name of saml group>",
            "idp_uuid": "<idp uuid of the group>",
        }])
        ```

        :param str resource_name: The name of the resource.
        :param UserGroupsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserGroupsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserGroupsCategoryArgs', 'UserGroupsCategoryArgsDict']]]]] = None,
                 directory_service_ous: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserGroupsDirectoryServiceOusArgs', 'UserGroupsDirectoryServiceOusArgsDict']]]]] = None,
                 directory_service_user_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserGroupsDirectoryServiceUserGroupArgs', 'UserGroupsDirectoryServiceUserGroupArgsDict']]]]] = None,
                 owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 saml_user_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserGroupsSamlUserGroupArgs', 'UserGroupsSamlUserGroupArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserGroupsArgs.__new__(UserGroupsArgs)

            __props__.__dict__["categories"] = categories
            __props__.__dict__["directory_service_ous"] = directory_service_ous
            __props__.__dict__["directory_service_user_groups"] = directory_service_user_groups
            __props__.__dict__["owner_reference"] = owner_reference
            __props__.__dict__["project_reference"] = project_reference
            __props__.__dict__["saml_user_groups"] = saml_user_groups
            __props__.__dict__["metadata"] = None
        super(UserGroups, __self__).__init__(
            'nutanix:index/userGroups:UserGroups',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserGroupsCategoryArgs', 'UserGroupsCategoryArgsDict']]]]] = None,
            directory_service_ous: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserGroupsDirectoryServiceOusArgs', 'UserGroupsDirectoryServiceOusArgsDict']]]]] = None,
            directory_service_user_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserGroupsDirectoryServiceUserGroupArgs', 'UserGroupsDirectoryServiceUserGroupArgsDict']]]]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            saml_user_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserGroupsSamlUserGroupArgs', 'UserGroupsSamlUserGroupArgsDict']]]]] = None) -> 'UserGroups':
        """
        Get an existing UserGroups resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserGroupsDirectoryServiceOusArgs', 'UserGroupsDirectoryServiceOusArgsDict']]]] directory_service_ous: - (Optional) A Directory Service organizational unit.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserGroupsDirectoryServiceUserGroupArgs', 'UserGroupsDirectoryServiceUserGroupArgsDict']]]] directory_service_user_groups: - (Optional) A Directory Service user group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: The user_group kind metadata.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserGroupsSamlUserGroupArgs', 'UserGroupsSamlUserGroupArgsDict']]]] saml_user_groups: - (Optional) A SAML Service user group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserGroupsState.__new__(_UserGroupsState)

        __props__.__dict__["categories"] = categories
        __props__.__dict__["directory_service_ous"] = directory_service_ous
        __props__.__dict__["directory_service_user_groups"] = directory_service_user_groups
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["owner_reference"] = owner_reference
        __props__.__dict__["project_reference"] = project_reference
        __props__.__dict__["saml_user_groups"] = saml_user_groups
        return UserGroups(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> pulumi.Output[Sequence['outputs.UserGroupsCategory']]:
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter(name="directoryServiceOus")
    def directory_service_ous(self) -> pulumi.Output[Optional[Sequence['outputs.UserGroupsDirectoryServiceOus']]]:
        """
        - (Optional) A Directory Service organizational unit.
        """
        return pulumi.get(self, "directory_service_ous")

    @_builtins.property
    @pulumi.getter(name="directoryServiceUserGroups")
    def directory_service_user_groups(self) -> pulumi.Output[Optional[Sequence['outputs.UserGroupsDirectoryServiceUserGroup']]]:
        """
        - (Optional) A Directory Service user group.
        """
        return pulumi.get(self, "directory_service_user_groups")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The user_group kind metadata.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "owner_reference")

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "project_reference")

    @_builtins.property
    @pulumi.getter(name="samlUserGroups")
    def saml_user_groups(self) -> pulumi.Output[Optional[Sequence['outputs.UserGroupsSamlUserGroup']]]:
        """
        - (Optional) A SAML Service user group.
        """
        return pulumi.get(self, "saml_user_groups")

