# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['UserGroupsV2Args', 'UserGroupsV2']

@pulumi.input_type
class UserGroupsV2Args:
    def __init__(__self__, *,
                 group_type: pulumi.Input[_builtins.str],
                 idp_id: pulumi.Input[_builtins.str],
                 distinguished_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a UserGroupsV2 resource.
        :param pulumi.Input[_builtins.str] group_type: -(Required) Type of the User Group. LDAP (User Group belonging to a Directory Service (Open LDAP/AD)), SAML (User Group belonging to a SAML IDP.)
        :param pulumi.Input[_builtins.str] idp_id: -(Required) Identifier of the IDP for the User Group.
        :param pulumi.Input[_builtins.str] distinguished_name: -(Optional) Identifier for the User Group in the form of a distinguished name.
        :param pulumi.Input[_builtins.str] ext_id: The External Identifier of the User Group.
        :param pulumi.Input[_builtins.str] name: -(Optional) Common Name of the User Group.
        """
        pulumi.set(__self__, "group_type", group_type)
        pulumi.set(__self__, "idp_id", idp_id)
        if distinguished_name is not None:
            pulumi.set(__self__, "distinguished_name", distinguished_name)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="groupType")
    def group_type(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) Type of the User Group. LDAP (User Group belonging to a Directory Service (Open LDAP/AD)), SAML (User Group belonging to a SAML IDP.)
        """
        return pulumi.get(self, "group_type")

    @group_type.setter
    def group_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_type", value)

    @_builtins.property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) Identifier of the IDP for the User Group.
        """
        return pulumi.get(self, "idp_id")

    @idp_id.setter
    def idp_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "idp_id", value)

    @_builtins.property
    @pulumi.getter(name="distinguishedName")
    def distinguished_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Identifier for the User Group in the form of a distinguished name.
        """
        return pulumi.get(self, "distinguished_name")

    @distinguished_name.setter
    def distinguished_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "distinguished_name", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The External Identifier of the User Group.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Common Name of the User Group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _UserGroupsV2State:
    def __init__(__self__, *,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 created_time: Optional[pulumi.Input[_builtins.str]] = None,
                 distinguished_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 idp_id: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated_time: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserGroupsV2 resources.
        :param pulumi.Input[_builtins.str] created_by: - User or Service who created the User Group.
        :param pulumi.Input[_builtins.str] created_time: - Creation time of the User Group.
        :param pulumi.Input[_builtins.str] distinguished_name: -(Optional) Identifier for the User Group in the form of a distinguished name.
        :param pulumi.Input[_builtins.str] ext_id: The External Identifier of the User Group.
        :param pulumi.Input[_builtins.str] group_type: -(Required) Type of the User Group. LDAP (User Group belonging to a Directory Service (Open LDAP/AD)), SAML (User Group belonging to a SAML IDP.)
        :param pulumi.Input[_builtins.str] idp_id: -(Required) Identifier of the IDP for the User Group.
        :param pulumi.Input[_builtins.str] last_updated_time: - Last updated time of the User Group.
        :param pulumi.Input[_builtins.str] name: -(Optional) Common Name of the User Group.
        """
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if distinguished_name is not None:
            pulumi.set(__self__, "distinguished_name", distinguished_name)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if group_type is not None:
            pulumi.set(__self__, "group_type", group_type)
        if idp_id is not None:
            pulumi.set(__self__, "idp_id", idp_id)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - User or Service who created the User Group.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Creation time of the User Group.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_time", value)

    @_builtins.property
    @pulumi.getter(name="distinguishedName")
    def distinguished_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Identifier for the User Group in the form of a distinguished name.
        """
        return pulumi.get(self, "distinguished_name")

    @distinguished_name.setter
    def distinguished_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "distinguished_name", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The External Identifier of the User Group.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="groupType")
    def group_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) Type of the User Group. LDAP (User Group belonging to a Directory Service (Open LDAP/AD)), SAML (User Group belonging to a SAML IDP.)
        """
        return pulumi.get(self, "group_type")

    @group_type.setter
    def group_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_type", value)

    @_builtins.property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) Identifier of the IDP for the User Group.
        """
        return pulumi.get(self, "idp_id")

    @idp_id.setter
    def idp_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "idp_id", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Last updated time of the User Group.
        """
        return pulumi.get(self, "last_updated_time")

    @last_updated_time.setter
    def last_updated_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated_time", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Common Name of the User Group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("nutanix:index/userGroupsV2:UserGroupsV2")
class UserGroupsV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 distinguished_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 idp_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to add a User group to the system..

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        usr_group = nutanix.UserGroupsV2("usr_group",
            group_type="LDAP",
            idp_id="ba250e3e-1db1-4950-917f-a9e2ea35b8e3",
            name="group_0664229e",
            distinguished_name="cn=group_0664229e,ou=group,dc=devtest,dc=local")
        # Saml User group
        saml_ug = nutanix.UserGroupsV2("saml-ug",
            group_type="SAML",
            idp_id="a8fe48c4-f0d3-49c7-a017-efc30dd8fb2b",
            name="adfs19admingroup")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] distinguished_name: -(Optional) Identifier for the User Group in the form of a distinguished name.
        :param pulumi.Input[_builtins.str] ext_id: The External Identifier of the User Group.
        :param pulumi.Input[_builtins.str] group_type: -(Required) Type of the User Group. LDAP (User Group belonging to a Directory Service (Open LDAP/AD)), SAML (User Group belonging to a SAML IDP.)
        :param pulumi.Input[_builtins.str] idp_id: -(Required) Identifier of the IDP for the User Group.
        :param pulumi.Input[_builtins.str] name: -(Optional) Common Name of the User Group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserGroupsV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to add a User group to the system..

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        usr_group = nutanix.UserGroupsV2("usr_group",
            group_type="LDAP",
            idp_id="ba250e3e-1db1-4950-917f-a9e2ea35b8e3",
            name="group_0664229e",
            distinguished_name="cn=group_0664229e,ou=group,dc=devtest,dc=local")
        # Saml User group
        saml_ug = nutanix.UserGroupsV2("saml-ug",
            group_type="SAML",
            idp_id="a8fe48c4-f0d3-49c7-a017-efc30dd8fb2b",
            name="adfs19admingroup")
        ```

        :param str resource_name: The name of the resource.
        :param UserGroupsV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserGroupsV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 distinguished_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 idp_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserGroupsV2Args.__new__(UserGroupsV2Args)

            __props__.__dict__["distinguished_name"] = distinguished_name
            __props__.__dict__["ext_id"] = ext_id
            if group_type is None and not opts.urn:
                raise TypeError("Missing required property 'group_type'")
            __props__.__dict__["group_type"] = group_type
            if idp_id is None and not opts.urn:
                raise TypeError("Missing required property 'idp_id'")
            __props__.__dict__["idp_id"] = idp_id
            __props__.__dict__["name"] = name
            __props__.__dict__["created_by"] = None
            __props__.__dict__["created_time"] = None
            __props__.__dict__["last_updated_time"] = None
        super(UserGroupsV2, __self__).__init__(
            'nutanix:index/userGroupsV2:UserGroupsV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            created_time: Optional[pulumi.Input[_builtins.str]] = None,
            distinguished_name: Optional[pulumi.Input[_builtins.str]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            group_type: Optional[pulumi.Input[_builtins.str]] = None,
            idp_id: Optional[pulumi.Input[_builtins.str]] = None,
            last_updated_time: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'UserGroupsV2':
        """
        Get an existing UserGroupsV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_by: - User or Service who created the User Group.
        :param pulumi.Input[_builtins.str] created_time: - Creation time of the User Group.
        :param pulumi.Input[_builtins.str] distinguished_name: -(Optional) Identifier for the User Group in the form of a distinguished name.
        :param pulumi.Input[_builtins.str] ext_id: The External Identifier of the User Group.
        :param pulumi.Input[_builtins.str] group_type: -(Required) Type of the User Group. LDAP (User Group belonging to a Directory Service (Open LDAP/AD)), SAML (User Group belonging to a SAML IDP.)
        :param pulumi.Input[_builtins.str] idp_id: -(Required) Identifier of the IDP for the User Group.
        :param pulumi.Input[_builtins.str] last_updated_time: - Last updated time of the User Group.
        :param pulumi.Input[_builtins.str] name: -(Optional) Common Name of the User Group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserGroupsV2State.__new__(_UserGroupsV2State)

        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["created_time"] = created_time
        __props__.__dict__["distinguished_name"] = distinguished_name
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["group_type"] = group_type
        __props__.__dict__["idp_id"] = idp_id
        __props__.__dict__["last_updated_time"] = last_updated_time
        __props__.__dict__["name"] = name
        return UserGroupsV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        - User or Service who created the User Group.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[_builtins.str]:
        """
        - Creation time of the User Group.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter(name="distinguishedName")
    def distinguished_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        -(Optional) Identifier for the User Group in the form of a distinguished name.
        """
        return pulumi.get(self, "distinguished_name")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        The External Identifier of the User Group.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="groupType")
    def group_type(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) Type of the User Group. LDAP (User Group belonging to a Directory Service (Open LDAP/AD)), SAML (User Group belonging to a SAML IDP.)
        """
        return pulumi.get(self, "group_type")

    @_builtins.property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) Identifier of the IDP for the User Group.
        """
        return pulumi.get(self, "idp_id")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> pulumi.Output[_builtins.str]:
        """
        - Last updated time of the User Group.
        """
        return pulumi.get(self, "last_updated_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        -(Optional) Common Name of the User Group.
        """
        return pulumi.get(self, "name")

