# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserKeyRevokeV2Args', 'UserKeyRevokeV2']

@pulumi.input_type
class UserKeyRevokeV2Args:
    def __init__(__self__, *,
                 ext_id: pulumi.Input[_builtins.str],
                 user_ext_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a UserKeyRevokeV2 resource.
        """
        pulumi.set(__self__, "ext_id", ext_id)
        pulumi.set(__self__, "user_ext_id", user_ext_id)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="userExtId")
    def user_ext_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "user_ext_id")

    @user_ext_id.setter
    def user_ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_ext_id", value)


@pulumi.input_type
class _UserKeyRevokeV2State:
    def __init__(__self__, *,
                 arguments_maps: Optional[pulumi.Input[Sequence[pulumi.Input['UserKeyRevokeV2ArgumentsMapArgs']]]] = None,
                 code: Optional[pulumi.Input[_builtins.str]] = None,
                 error_group: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 locale: Optional[pulumi.Input[_builtins.str]] = None,
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 severity: Optional[pulumi.Input[_builtins.str]] = None,
                 user_ext_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserKeyRevokeV2 resources.
        :param pulumi.Input[Sequence[pulumi.Input['UserKeyRevokeV2ArgumentsMapArgs']]] arguments_maps: - The map of argument name to value.
        :param pulumi.Input[_builtins.str] code: - The code associated with this message.This string is typically prefixed by the namespace the endpoint belongs to. For example: VMM-40000.
        :param pulumi.Input[_builtins.str] error_group: - The error group associated with this message of severity ERROR.
        :param pulumi.Input[_builtins.str] locale: - Locale for this message. The default locale would be 'en-US'.
        :param pulumi.Input[_builtins.str] message: - The message string.
        :param pulumi.Input[_builtins.str] severity: - The message severity.
        """
        if arguments_maps is not None:
            pulumi.set(__self__, "arguments_maps", arguments_maps)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if error_group is not None:
            pulumi.set(__self__, "error_group", error_group)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if locale is not None:
            pulumi.set(__self__, "locale", locale)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if user_ext_id is not None:
            pulumi.set(__self__, "user_ext_id", user_ext_id)

    @_builtins.property
    @pulumi.getter(name="argumentsMaps")
    def arguments_maps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserKeyRevokeV2ArgumentsMapArgs']]]]:
        """
        - The map of argument name to value.
        """
        return pulumi.get(self, "arguments_maps")

    @arguments_maps.setter
    def arguments_maps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserKeyRevokeV2ArgumentsMapArgs']]]]):
        pulumi.set(self, "arguments_maps", value)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The code associated with this message.This string is typically prefixed by the namespace the endpoint belongs to. For example: VMM-40000.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "code", value)

    @_builtins.property
    @pulumi.getter(name="errorGroup")
    def error_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The error group associated with this message of severity ERROR.
        """
        return pulumi.get(self, "error_group")

    @error_group.setter
    def error_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "error_group", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter
    def locale(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Locale for this message. The default locale would be 'en-US'.
        """
        return pulumi.get(self, "locale")

    @locale.setter
    def locale(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "locale", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The message string.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The message severity.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "severity", value)

    @_builtins.property
    @pulumi.getter(name="userExtId")
    def user_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "user_ext_id")

    @user_ext_id.setter
    def user_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_ext_id", value)


@pulumi.type_token("nutanix:index/userKeyRevokeV2:UserKeyRevokeV2")
class UserKeyRevokeV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides Nutanix resource to Revoke the requested key for a user.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # revoke key
        revoke_key = nutanix.UserKeyRevokeV2("revoke-key",
            user_ext_id="<SERVICE_ACCOUNT_UUID>",
            ext_id="<USER_KEY_UUID>")
        ```

        ## Argument Reference

        The following arguments are supported:

        * `user_ext_id`: - ( Required ) External Identifier of the User.
        * `ext_id`: - ( Required ) External identifier of the key.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserKeyRevokeV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides Nutanix resource to Revoke the requested key for a user.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # revoke key
        revoke_key = nutanix.UserKeyRevokeV2("revoke-key",
            user_ext_id="<SERVICE_ACCOUNT_UUID>",
            ext_id="<USER_KEY_UUID>")
        ```

        ## Argument Reference

        The following arguments are supported:

        * `user_ext_id`: - ( Required ) External Identifier of the User.
        * `ext_id`: - ( Required ) External identifier of the key.

        :param str resource_name: The name of the resource.
        :param UserKeyRevokeV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserKeyRevokeV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserKeyRevokeV2Args.__new__(UserKeyRevokeV2Args)

            if ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'ext_id'")
            __props__.__dict__["ext_id"] = ext_id
            if user_ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_ext_id'")
            __props__.__dict__["user_ext_id"] = user_ext_id
            __props__.__dict__["arguments_maps"] = None
            __props__.__dict__["code"] = None
            __props__.__dict__["error_group"] = None
            __props__.__dict__["locale"] = None
            __props__.__dict__["message"] = None
            __props__.__dict__["severity"] = None
        super(UserKeyRevokeV2, __self__).__init__(
            'nutanix:index/userKeyRevokeV2:UserKeyRevokeV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arguments_maps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserKeyRevokeV2ArgumentsMapArgs', 'UserKeyRevokeV2ArgumentsMapArgsDict']]]]] = None,
            code: Optional[pulumi.Input[_builtins.str]] = None,
            error_group: Optional[pulumi.Input[_builtins.str]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            locale: Optional[pulumi.Input[_builtins.str]] = None,
            message: Optional[pulumi.Input[_builtins.str]] = None,
            severity: Optional[pulumi.Input[_builtins.str]] = None,
            user_ext_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'UserKeyRevokeV2':
        """
        Get an existing UserKeyRevokeV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserKeyRevokeV2ArgumentsMapArgs', 'UserKeyRevokeV2ArgumentsMapArgsDict']]]] arguments_maps: - The map of argument name to value.
        :param pulumi.Input[_builtins.str] code: - The code associated with this message.This string is typically prefixed by the namespace the endpoint belongs to. For example: VMM-40000.
        :param pulumi.Input[_builtins.str] error_group: - The error group associated with this message of severity ERROR.
        :param pulumi.Input[_builtins.str] locale: - Locale for this message. The default locale would be 'en-US'.
        :param pulumi.Input[_builtins.str] message: - The message string.
        :param pulumi.Input[_builtins.str] severity: - The message severity.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserKeyRevokeV2State.__new__(_UserKeyRevokeV2State)

        __props__.__dict__["arguments_maps"] = arguments_maps
        __props__.__dict__["code"] = code
        __props__.__dict__["error_group"] = error_group
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["locale"] = locale
        __props__.__dict__["message"] = message
        __props__.__dict__["severity"] = severity
        __props__.__dict__["user_ext_id"] = user_ext_id
        return UserKeyRevokeV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="argumentsMaps")
    def arguments_maps(self) -> pulumi.Output[Sequence['outputs.UserKeyRevokeV2ArgumentsMap']]:
        """
        - The map of argument name to value.
        """
        return pulumi.get(self, "arguments_maps")

    @_builtins.property
    @pulumi.getter
    def code(self) -> pulumi.Output[_builtins.str]:
        """
        - The code associated with this message.This string is typically prefixed by the namespace the endpoint belongs to. For example: VMM-40000.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter(name="errorGroup")
    def error_group(self) -> pulumi.Output[_builtins.str]:
        """
        - The error group associated with this message of severity ERROR.
        """
        return pulumi.get(self, "error_group")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter
    def locale(self) -> pulumi.Output[_builtins.str]:
        """
        - Locale for this message. The default locale would be 'en-US'.
        """
        return pulumi.get(self, "locale")

    @_builtins.property
    @pulumi.getter
    def message(self) -> pulumi.Output[_builtins.str]:
        """
        - The message string.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> pulumi.Output[_builtins.str]:
        """
        - The message severity.
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter(name="userExtId")
    def user_ext_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "user_ext_id")

