# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserKeyV2Args', 'UserKeyV2']

@pulumi.input_type
class UserKeyV2Args:
    def __init__(__self__, *,
                 key_type: pulumi.Input[_builtins.str],
                 user_ext_id: pulumi.Input[_builtins.str],
                 assigned_to: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 created_time: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expiry_time: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated_by: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated_time: Optional[pulumi.Input[_builtins.str]] = None,
                 last_used_time: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a UserKeyV2 resource.
        :param pulumi.Input[_builtins.str] key_type: - The type of key.
        :param pulumi.Input[_builtins.str] assigned_to: - External client to whom the given key is allocated.
        :param pulumi.Input[_builtins.str] created_by: - User or service who created the key.
        :param pulumi.Input[_builtins.str] created_time: - The creation time of the key.
        :param pulumi.Input[_builtins.str] creation_type: - The creation mechanism of this entity.
        :param pulumi.Input[_builtins.str] description: - Brief description of the key.
        :param pulumi.Input[_builtins.str] expiry_time: - The time when the key will expire.
        :param pulumi.Input[_builtins.str] last_updated_by: - User who updated the key.
        :param pulumi.Input[_builtins.str] last_updated_time: - The time when the key was updated.
        :param pulumi.Input[_builtins.str] last_used_time: - The time when the key was last used.
        :param pulumi.Input[_builtins.str] name: - Identifier for the key in the form of a name.
        :param pulumi.Input[_builtins.str] status: - The status of the key.
        """
        pulumi.set(__self__, "key_type", key_type)
        pulumi.set(__self__, "user_ext_id", user_ext_id)
        if assigned_to is not None:
            pulumi.set(__self__, "assigned_to", assigned_to)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if creation_type is not None:
            pulumi.set(__self__, "creation_type", creation_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expiry_time is not None:
            pulumi.set(__self__, "expiry_time", expiry_time)
        if last_updated_by is not None:
            pulumi.set(__self__, "last_updated_by", last_updated_by)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if last_used_time is not None:
            pulumi.set(__self__, "last_used_time", last_used_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> pulumi.Input[_builtins.str]:
        """
        - The type of key.
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_type", value)

    @_builtins.property
    @pulumi.getter(name="userExtId")
    def user_ext_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "user_ext_id")

    @user_ext_id.setter
    def user_ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="assignedTo")
    def assigned_to(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - External client to whom the given key is allocated.
        """
        return pulumi.get(self, "assigned_to")

    @assigned_to.setter
    def assigned_to(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assigned_to", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - User or service who created the key.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The creation time of the key.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_time", value)

    @_builtins.property
    @pulumi.getter(name="creationType")
    def creation_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The creation mechanism of this entity.
        """
        return pulumi.get(self, "creation_type")

    @creation_type.setter
    def creation_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Brief description of the key.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="expiryTime")
    def expiry_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The time when the key will expire.
        """
        return pulumi.get(self, "expiry_time")

    @expiry_time.setter
    def expiry_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expiry_time", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - User who updated the key.
        """
        return pulumi.get(self, "last_updated_by")

    @last_updated_by.setter
    def last_updated_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated_by", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The time when the key was updated.
        """
        return pulumi.get(self, "last_updated_time")

    @last_updated_time.setter
    def last_updated_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated_time", value)

    @_builtins.property
    @pulumi.getter(name="lastUsedTime")
    def last_used_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The time when the key was last used.
        """
        return pulumi.get(self, "last_used_time")

    @last_used_time.setter
    def last_used_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_used_time", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Identifier for the key in the form of a name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The status of the key.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _UserKeyV2State:
    def __init__(__self__, *,
                 assigned_to: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 created_time: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expiry_time: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_details: Optional[pulumi.Input[Sequence[pulumi.Input['UserKeyV2KeyDetailArgs']]]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated_by: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated_time: Optional[pulumi.Input[_builtins.str]] = None,
                 last_used_time: Optional[pulumi.Input[_builtins.str]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input['UserKeyV2LinkArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_ext_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserKeyV2 resources.
        :param pulumi.Input[_builtins.str] assigned_to: - External client to whom the given key is allocated.
        :param pulumi.Input[_builtins.str] created_by: - User or service who created the key.
        :param pulumi.Input[_builtins.str] created_time: - The creation time of the key.
        :param pulumi.Input[_builtins.str] creation_type: - The creation mechanism of this entity.
        :param pulumi.Input[_builtins.str] description: - Brief description of the key.
        :param pulumi.Input[_builtins.str] expiry_time: - The time when the key will expire.
        :param pulumi.Input[_builtins.str] ext_id: - The External Identifier of the User Group.
        :param pulumi.Input[Sequence[pulumi.Input['UserKeyV2KeyDetailArgs']]] key_details: - Details specific to type of the key.
        :param pulumi.Input[_builtins.str] key_type: - The type of key.
        :param pulumi.Input[_builtins.str] last_updated_by: - User who updated the key.
        :param pulumi.Input[_builtins.str] last_updated_time: - The time when the key was updated.
        :param pulumi.Input[_builtins.str] last_used_time: - The time when the key was last used.
        :param pulumi.Input[Sequence[pulumi.Input['UserKeyV2LinkArgs']]] links: - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        :param pulumi.Input[_builtins.str] name: - Identifier for the key in the form of a name.
        :param pulumi.Input[_builtins.str] status: - The status of the key.
        :param pulumi.Input[_builtins.str] tenant_id: - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        """
        if assigned_to is not None:
            pulumi.set(__self__, "assigned_to", assigned_to)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if creation_type is not None:
            pulumi.set(__self__, "creation_type", creation_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expiry_time is not None:
            pulumi.set(__self__, "expiry_time", expiry_time)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if key_details is not None:
            pulumi.set(__self__, "key_details", key_details)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if last_updated_by is not None:
            pulumi.set(__self__, "last_updated_by", last_updated_by)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if last_used_time is not None:
            pulumi.set(__self__, "last_used_time", last_used_time)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if user_ext_id is not None:
            pulumi.set(__self__, "user_ext_id", user_ext_id)

    @_builtins.property
    @pulumi.getter(name="assignedTo")
    def assigned_to(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - External client to whom the given key is allocated.
        """
        return pulumi.get(self, "assigned_to")

    @assigned_to.setter
    def assigned_to(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assigned_to", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - User or service who created the key.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The creation time of the key.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_time", value)

    @_builtins.property
    @pulumi.getter(name="creationType")
    def creation_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The creation mechanism of this entity.
        """
        return pulumi.get(self, "creation_type")

    @creation_type.setter
    def creation_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Brief description of the key.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="expiryTime")
    def expiry_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The time when the key will expire.
        """
        return pulumi.get(self, "expiry_time")

    @expiry_time.setter
    def expiry_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expiry_time", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The External Identifier of the User Group.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="keyDetails")
    def key_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserKeyV2KeyDetailArgs']]]]:
        """
        - Details specific to type of the key.
        """
        return pulumi.get(self, "key_details")

    @key_details.setter
    def key_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserKeyV2KeyDetailArgs']]]]):
        pulumi.set(self, "key_details", value)

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The type of key.
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_type", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - User who updated the key.
        """
        return pulumi.get(self, "last_updated_by")

    @last_updated_by.setter
    def last_updated_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated_by", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The time when the key was updated.
        """
        return pulumi.get(self, "last_updated_time")

    @last_updated_time.setter
    def last_updated_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated_time", value)

    @_builtins.property
    @pulumi.getter(name="lastUsedTime")
    def last_used_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The time when the key was last used.
        """
        return pulumi.get(self, "last_used_time")

    @last_used_time.setter
    def last_used_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_used_time", value)

    @_builtins.property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserKeyV2LinkArgs']]]]:
        """
        - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserKeyV2LinkArgs']]]]):
        pulumi.set(self, "links", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Identifier for the key in the form of a name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The status of the key.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="userExtId")
    def user_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "user_ext_id")

    @user_ext_id.setter
    def user_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_ext_id", value)


@pulumi.type_token("nutanix:index/userKeyV2:UserKeyV2")
class UserKeyV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assigned_to: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 created_time: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expiry_time: Optional[pulumi.Input[_builtins.str]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated_by: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated_time: Optional[pulumi.Input[_builtins.str]] = None,
                 last_used_time: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 user_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides Nutanix resource to Create key of a requested type for a user.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # Create key under service account, never expires
        create_key = nutanix.UserKeyV2("create_key",
            user_ext_id="<SERVICE_ACCOUNT_UUID>",
            name="api_key_developers",
            key_type="API_KEY",
            expiry_time="2125-01-01T00:00:00Z",
            assigned_to="developer_user_1")
        ```
        ## Argument Reference

        The following arguments are supported:

        * `user_ext_id`: - ( Required ) External Identifier of the User.
        * `name`: - ( Required ) Identifier for the key in the form of a name.
        * `description`: - ( Optional ) Brief description of the key.
        * `key_type`: - ( Required ) The type of key. Enum Values:
              * "API_KEY":	A key type that is used to identify a service.
              * "OBJECT_KEY":	A combination of access key and secret key to sign an API request.
        * `creation_type`: - ( Optional ) The creation mechanism of this entity. Enum Values:
              * "PREDEFINED":	Predefined creator workflow type is for entity created by the system.
              * "SERVICEDEFINED":	Servicedefined creator workflow type is for entity created by the service.
              * "USERDEFINED":	Userdefined creator workflow type is for entity created by the users.
        * `expiry_time`: - ( Optional ) The time when the key will expire.
        * `status`: - ( Optional ) The status of the key. Enum Values:
              * "REVOKED":	Key is revoked.
              * "VALID":	Key is valid.
              * "EXPIRED":	Key is expired.
        * `assigned_to`: - ( Optional ) External client to whom the given key is allocated.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] assigned_to: - External client to whom the given key is allocated.
        :param pulumi.Input[_builtins.str] created_by: - User or service who created the key.
        :param pulumi.Input[_builtins.str] created_time: - The creation time of the key.
        :param pulumi.Input[_builtins.str] creation_type: - The creation mechanism of this entity.
        :param pulumi.Input[_builtins.str] description: - Brief description of the key.
        :param pulumi.Input[_builtins.str] expiry_time: - The time when the key will expire.
        :param pulumi.Input[_builtins.str] key_type: - The type of key.
        :param pulumi.Input[_builtins.str] last_updated_by: - User who updated the key.
        :param pulumi.Input[_builtins.str] last_updated_time: - The time when the key was updated.
        :param pulumi.Input[_builtins.str] last_used_time: - The time when the key was last used.
        :param pulumi.Input[_builtins.str] name: - Identifier for the key in the form of a name.
        :param pulumi.Input[_builtins.str] status: - The status of the key.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserKeyV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides Nutanix resource to Create key of a requested type for a user.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # Create key under service account, never expires
        create_key = nutanix.UserKeyV2("create_key",
            user_ext_id="<SERVICE_ACCOUNT_UUID>",
            name="api_key_developers",
            key_type="API_KEY",
            expiry_time="2125-01-01T00:00:00Z",
            assigned_to="developer_user_1")
        ```
        ## Argument Reference

        The following arguments are supported:

        * `user_ext_id`: - ( Required ) External Identifier of the User.
        * `name`: - ( Required ) Identifier for the key in the form of a name.
        * `description`: - ( Optional ) Brief description of the key.
        * `key_type`: - ( Required ) The type of key. Enum Values:
              * "API_KEY":	A key type that is used to identify a service.
              * "OBJECT_KEY":	A combination of access key and secret key to sign an API request.
        * `creation_type`: - ( Optional ) The creation mechanism of this entity. Enum Values:
              * "PREDEFINED":	Predefined creator workflow type is for entity created by the system.
              * "SERVICEDEFINED":	Servicedefined creator workflow type is for entity created by the service.
              * "USERDEFINED":	Userdefined creator workflow type is for entity created by the users.
        * `expiry_time`: - ( Optional ) The time when the key will expire.
        * `status`: - ( Optional ) The status of the key. Enum Values:
              * "REVOKED":	Key is revoked.
              * "VALID":	Key is valid.
              * "EXPIRED":	Key is expired.
        * `assigned_to`: - ( Optional ) External client to whom the given key is allocated.

        :param str resource_name: The name of the resource.
        :param UserKeyV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserKeyV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assigned_to: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 created_time: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expiry_time: Optional[pulumi.Input[_builtins.str]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated_by: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated_time: Optional[pulumi.Input[_builtins.str]] = None,
                 last_used_time: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 user_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserKeyV2Args.__new__(UserKeyV2Args)

            __props__.__dict__["assigned_to"] = assigned_to
            __props__.__dict__["created_by"] = created_by
            __props__.__dict__["created_time"] = created_time
            __props__.__dict__["creation_type"] = creation_type
            __props__.__dict__["description"] = description
            __props__.__dict__["expiry_time"] = expiry_time
            if key_type is None and not opts.urn:
                raise TypeError("Missing required property 'key_type'")
            __props__.__dict__["key_type"] = key_type
            __props__.__dict__["last_updated_by"] = last_updated_by
            __props__.__dict__["last_updated_time"] = last_updated_time
            __props__.__dict__["last_used_time"] = last_used_time
            __props__.__dict__["name"] = name
            __props__.__dict__["status"] = status
            if user_ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_ext_id'")
            __props__.__dict__["user_ext_id"] = user_ext_id
            __props__.__dict__["ext_id"] = None
            __props__.__dict__["key_details"] = None
            __props__.__dict__["links"] = None
            __props__.__dict__["tenant_id"] = None
        super(UserKeyV2, __self__).__init__(
            'nutanix:index/userKeyV2:UserKeyV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assigned_to: Optional[pulumi.Input[_builtins.str]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            created_time: Optional[pulumi.Input[_builtins.str]] = None,
            creation_type: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            expiry_time: Optional[pulumi.Input[_builtins.str]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            key_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserKeyV2KeyDetailArgs', 'UserKeyV2KeyDetailArgsDict']]]]] = None,
            key_type: Optional[pulumi.Input[_builtins.str]] = None,
            last_updated_by: Optional[pulumi.Input[_builtins.str]] = None,
            last_updated_time: Optional[pulumi.Input[_builtins.str]] = None,
            last_used_time: Optional[pulumi.Input[_builtins.str]] = None,
            links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserKeyV2LinkArgs', 'UserKeyV2LinkArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            user_ext_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'UserKeyV2':
        """
        Get an existing UserKeyV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] assigned_to: - External client to whom the given key is allocated.
        :param pulumi.Input[_builtins.str] created_by: - User or service who created the key.
        :param pulumi.Input[_builtins.str] created_time: - The creation time of the key.
        :param pulumi.Input[_builtins.str] creation_type: - The creation mechanism of this entity.
        :param pulumi.Input[_builtins.str] description: - Brief description of the key.
        :param pulumi.Input[_builtins.str] expiry_time: - The time when the key will expire.
        :param pulumi.Input[_builtins.str] ext_id: - The External Identifier of the User Group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserKeyV2KeyDetailArgs', 'UserKeyV2KeyDetailArgsDict']]]] key_details: - Details specific to type of the key.
        :param pulumi.Input[_builtins.str] key_type: - The type of key.
        :param pulumi.Input[_builtins.str] last_updated_by: - User who updated the key.
        :param pulumi.Input[_builtins.str] last_updated_time: - The time when the key was updated.
        :param pulumi.Input[_builtins.str] last_used_time: - The time when the key was last used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserKeyV2LinkArgs', 'UserKeyV2LinkArgsDict']]]] links: - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        :param pulumi.Input[_builtins.str] name: - Identifier for the key in the form of a name.
        :param pulumi.Input[_builtins.str] status: - The status of the key.
        :param pulumi.Input[_builtins.str] tenant_id: - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserKeyV2State.__new__(_UserKeyV2State)

        __props__.__dict__["assigned_to"] = assigned_to
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["created_time"] = created_time
        __props__.__dict__["creation_type"] = creation_type
        __props__.__dict__["description"] = description
        __props__.__dict__["expiry_time"] = expiry_time
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["key_details"] = key_details
        __props__.__dict__["key_type"] = key_type
        __props__.__dict__["last_updated_by"] = last_updated_by
        __props__.__dict__["last_updated_time"] = last_updated_time
        __props__.__dict__["last_used_time"] = last_used_time
        __props__.__dict__["links"] = links
        __props__.__dict__["name"] = name
        __props__.__dict__["status"] = status
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["user_ext_id"] = user_ext_id
        return UserKeyV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="assignedTo")
    def assigned_to(self) -> pulumi.Output[_builtins.str]:
        """
        - External client to whom the given key is allocated.
        """
        return pulumi.get(self, "assigned_to")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        - User or service who created the key.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[_builtins.str]:
        """
        - The creation time of the key.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter(name="creationType")
    def creation_type(self) -> pulumi.Output[_builtins.str]:
        """
        - The creation mechanism of this entity.
        """
        return pulumi.get(self, "creation_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        - Brief description of the key.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="expiryTime")
    def expiry_time(self) -> pulumi.Output[_builtins.str]:
        """
        - The time when the key will expire.
        """
        return pulumi.get(self, "expiry_time")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        - The External Identifier of the User Group.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="keyDetails")
    def key_details(self) -> pulumi.Output[Sequence['outputs.UserKeyV2KeyDetail']]:
        """
        - Details specific to type of the key.
        """
        return pulumi.get(self, "key_details")

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> pulumi.Output[_builtins.str]:
        """
        - The type of key.
        """
        return pulumi.get(self, "key_type")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> pulumi.Output[_builtins.str]:
        """
        - User who updated the key.
        """
        return pulumi.get(self, "last_updated_by")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> pulumi.Output[_builtins.str]:
        """
        - The time when the key was updated.
        """
        return pulumi.get(self, "last_updated_time")

    @_builtins.property
    @pulumi.getter(name="lastUsedTime")
    def last_used_time(self) -> pulumi.Output[_builtins.str]:
        """
        - The time when the key was last used.
        """
        return pulumi.get(self, "last_used_time")

    @_builtins.property
    @pulumi.getter
    def links(self) -> pulumi.Output[Sequence['outputs.UserKeyV2Link']]:
        """
        - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        - Identifier for the key in the form of a name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        - The status of the key.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="userExtId")
    def user_ext_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "user_ext_id")

