# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UsersV2Args', 'UsersV2']

@pulumi.input_type
class UsersV2Args:
    def __init__(__self__, *,
                 user_type: pulumi.Input[_builtins.str],
                 username: pulumi.Input[_builtins.str],
                 additional_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['UsersV2AdditionalAttributeArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email_id: Optional[pulumi.Input[_builtins.str]] = None,
                 first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 force_reset_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 idp_id: Optional[pulumi.Input[_builtins.str]] = None,
                 last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 locale: Optional[pulumi.Input[_builtins.str]] = None,
                 middle_initial: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a UsersV2 resource.
        :param pulumi.Input[_builtins.str] user_type: - Enum: `$UNKNOWN` `$REDACTED` `LOCAL` `SAML` `LDAP` `EXTERNAL`
               Type of the User.
        :param pulumi.Input[_builtins.str] username: - Identifier for the User in the form an email address.
        :param pulumi.Input[Sequence[pulumi.Input['UsersV2AdditionalAttributeArgs']]] additional_attributes: -  Any additional attribute for the User.
        :param pulumi.Input[_builtins.str] description: - Description of the user.
        :param pulumi.Input[_builtins.str] display_name: - Display name for the User.
        :param pulumi.Input[_builtins.str] email_id: - Email Id for the User.
        :param pulumi.Input[_builtins.str] first_name: - First name for the User.
        :param pulumi.Input[_builtins.str] idp_id: - Identifier of the IDP for the User.
        :param pulumi.Input[_builtins.str] last_name: - Last name for the User.
        :param pulumi.Input[_builtins.str] locale: - Default locale for the User.
        :param pulumi.Input[_builtins.str] middle_initial: - Middle name for the User.
        :param pulumi.Input[_builtins.str] region: - Default Region for the User.
        :param pulumi.Input[_builtins.str] status: - Status of the User. `ACTIVE`: Denotes that the local User is active. `INACTIVE`: Denotes that the local User is inactive and needs to be reactivated.
        """
        pulumi.set(__self__, "user_type", user_type)
        pulumi.set(__self__, "username", username)
        if additional_attributes is not None:
            pulumi.set(__self__, "additional_attributes", additional_attributes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if email_id is not None:
            pulumi.set(__self__, "email_id", email_id)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if force_reset_password is not None:
            pulumi.set(__self__, "force_reset_password", force_reset_password)
        if idp_id is not None:
            pulumi.set(__self__, "idp_id", idp_id)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if locale is not None:
            pulumi.set(__self__, "locale", locale)
        if middle_initial is not None:
            pulumi.set(__self__, "middle_initial", middle_initial)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="userType")
    def user_type(self) -> pulumi.Input[_builtins.str]:
        """
        - Enum: `$UNKNOWN` `$REDACTED` `LOCAL` `SAML` `LDAP` `EXTERNAL`
        Type of the User.
        """
        return pulumi.get(self, "user_type")

    @user_type.setter
    def user_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_type", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Input[_builtins.str]:
        """
        - Identifier for the User in the form an email address.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter(name="additionalAttributes")
    def additional_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UsersV2AdditionalAttributeArgs']]]]:
        """
        -  Any additional attribute for the User.
        """
        return pulumi.get(self, "additional_attributes")

    @additional_attributes.setter
    def additional_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UsersV2AdditionalAttributeArgs']]]]):
        pulumi.set(self, "additional_attributes", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Description of the user.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Display name for the User.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="emailId")
    def email_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Email Id for the User.
        """
        return pulumi.get(self, "email_id")

    @email_id.setter
    def email_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email_id", value)

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - First name for the User.
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "first_name", value)

    @_builtins.property
    @pulumi.getter(name="forceResetPassword")
    def force_reset_password(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "force_reset_password")

    @force_reset_password.setter
    def force_reset_password(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_reset_password", value)

    @_builtins.property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Identifier of the IDP for the User.
        """
        return pulumi.get(self, "idp_id")

    @idp_id.setter
    def idp_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "idp_id", value)

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Last name for the User.
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_name", value)

    @_builtins.property
    @pulumi.getter
    def locale(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Default locale for the User.
        """
        return pulumi.get(self, "locale")

    @locale.setter
    def locale(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "locale", value)

    @_builtins.property
    @pulumi.getter(name="middleInitial")
    def middle_initial(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Middle name for the User.
        """
        return pulumi.get(self, "middle_initial")

    @middle_initial.setter
    def middle_initial(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "middle_initial", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Default Region for the User.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Status of the User. `ACTIVE`: Denotes that the local User is active. `INACTIVE`: Denotes that the local User is inactive and needs to be reactivated.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _UsersV2State:
    def __init__(__self__, *,
                 additional_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['UsersV2AdditionalAttributeArgs']]]] = None,
                 buckets_access_keys: Optional[pulumi.Input[Sequence[pulumi.Input['UsersV2BucketsAccessKeyArgs']]]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 created_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 force_reset_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 idp_id: Optional[pulumi.Input[_builtins.str]] = None,
                 last_login_time: Optional[pulumi.Input[_builtins.str]] = None,
                 last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated_time: Optional[pulumi.Input[_builtins.str]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input['UsersV2LinkArgs']]]] = None,
                 locale: Optional[pulumi.Input[_builtins.str]] = None,
                 middle_initial: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UsersV2 resources.
        :param pulumi.Input[Sequence[pulumi.Input['UsersV2AdditionalAttributeArgs']]] additional_attributes: -  Any additional attribute for the User.
        :param pulumi.Input[Sequence[pulumi.Input['UsersV2BucketsAccessKeyArgs']]] buckets_access_keys: - Bucket Access Keys for the User.
        :param pulumi.Input[_builtins.str] created_by: - User or Service who created the User.
        :param pulumi.Input[_builtins.str] created_time: - Creation time for the Bucket Access Key.
        :param pulumi.Input[_builtins.str] description: - Description of the user.
        :param pulumi.Input[_builtins.str] display_name: - Display name for the User.
        :param pulumi.Input[_builtins.str] email_id: - Email Id for the User.
        :param pulumi.Input[_builtins.str] ext_id: - A globally unique identifier of an instance that is suitable for external consumption.
        :param pulumi.Input[_builtins.str] first_name: - First name for the User.
        :param pulumi.Input[_builtins.str] idp_id: - Identifier of the IDP for the User.
        :param pulumi.Input[_builtins.str] last_login_time: - Last successful logged in time for the User.
        :param pulumi.Input[_builtins.str] last_name: - Last name for the User.
        :param pulumi.Input[_builtins.str] last_updated_time: - Last updated time of the User.
        :param pulumi.Input[Sequence[pulumi.Input['UsersV2LinkArgs']]] links: - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        :param pulumi.Input[_builtins.str] locale: - Default locale for the User.
        :param pulumi.Input[_builtins.str] middle_initial: - Middle name for the User.
        :param pulumi.Input[_builtins.str] region: - Default Region for the User.
        :param pulumi.Input[_builtins.str] status: - Status of the User. `ACTIVE`: Denotes that the local User is active. `INACTIVE`: Denotes that the local User is inactive and needs to be reactivated.
        :param pulumi.Input[_builtins.str] user_type: - Enum: `$UNKNOWN` `$REDACTED` `LOCAL` `SAML` `LDAP` `EXTERNAL`
               Type of the User.
        :param pulumi.Input[_builtins.str] username: - Identifier for the User in the form an email address.
        """
        if additional_attributes is not None:
            pulumi.set(__self__, "additional_attributes", additional_attributes)
        if buckets_access_keys is not None:
            pulumi.set(__self__, "buckets_access_keys", buckets_access_keys)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if email_id is not None:
            pulumi.set(__self__, "email_id", email_id)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if force_reset_password is not None:
            pulumi.set(__self__, "force_reset_password", force_reset_password)
        if idp_id is not None:
            pulumi.set(__self__, "idp_id", idp_id)
        if last_login_time is not None:
            pulumi.set(__self__, "last_login_time", last_login_time)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if locale is not None:
            pulumi.set(__self__, "locale", locale)
        if middle_initial is not None:
            pulumi.set(__self__, "middle_initial", middle_initial)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if user_type is not None:
            pulumi.set(__self__, "user_type", user_type)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="additionalAttributes")
    def additional_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UsersV2AdditionalAttributeArgs']]]]:
        """
        -  Any additional attribute for the User.
        """
        return pulumi.get(self, "additional_attributes")

    @additional_attributes.setter
    def additional_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UsersV2AdditionalAttributeArgs']]]]):
        pulumi.set(self, "additional_attributes", value)

    @_builtins.property
    @pulumi.getter(name="bucketsAccessKeys")
    def buckets_access_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UsersV2BucketsAccessKeyArgs']]]]:
        """
        - Bucket Access Keys for the User.
        """
        return pulumi.get(self, "buckets_access_keys")

    @buckets_access_keys.setter
    def buckets_access_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UsersV2BucketsAccessKeyArgs']]]]):
        pulumi.set(self, "buckets_access_keys", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - User or Service who created the User.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Creation time for the Bucket Access Key.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Description of the user.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Display name for the User.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="emailId")
    def email_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Email Id for the User.
        """
        return pulumi.get(self, "email_id")

    @email_id.setter
    def email_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email_id", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - First name for the User.
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "first_name", value)

    @_builtins.property
    @pulumi.getter(name="forceResetPassword")
    def force_reset_password(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "force_reset_password")

    @force_reset_password.setter
    def force_reset_password(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_reset_password", value)

    @_builtins.property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Identifier of the IDP for the User.
        """
        return pulumi.get(self, "idp_id")

    @idp_id.setter
    def idp_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "idp_id", value)

    @_builtins.property
    @pulumi.getter(name="lastLoginTime")
    def last_login_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Last successful logged in time for the User.
        """
        return pulumi.get(self, "last_login_time")

    @last_login_time.setter
    def last_login_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_login_time", value)

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Last name for the User.
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_name", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Last updated time of the User.
        """
        return pulumi.get(self, "last_updated_time")

    @last_updated_time.setter
    def last_updated_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated_time", value)

    @_builtins.property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UsersV2LinkArgs']]]]:
        """
        - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UsersV2LinkArgs']]]]):
        pulumi.set(self, "links", value)

    @_builtins.property
    @pulumi.getter
    def locale(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Default locale for the User.
        """
        return pulumi.get(self, "locale")

    @locale.setter
    def locale(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "locale", value)

    @_builtins.property
    @pulumi.getter(name="middleInitial")
    def middle_initial(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Middle name for the User.
        """
        return pulumi.get(self, "middle_initial")

    @middle_initial.setter
    def middle_initial(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "middle_initial", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Default Region for the User.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Status of the User. `ACTIVE`: Denotes that the local User is active. `INACTIVE`: Denotes that the local User is inactive and needs to be reactivated.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="userType")
    def user_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Enum: `$UNKNOWN` `$REDACTED` `LOCAL` `SAML` `LDAP` `EXTERNAL`
        Type of the User.
        """
        return pulumi.get(self, "user_type")

    @user_type.setter
    def user_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_type", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Identifier for the User in the form an email address.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("nutanix:index/usersV2:UsersV2")
class UsersV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UsersV2AdditionalAttributeArgs', 'UsersV2AdditionalAttributeArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email_id: Optional[pulumi.Input[_builtins.str]] = None,
                 first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 force_reset_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 idp_id: Optional[pulumi.Input[_builtins.str]] = None,
                 last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 locale: Optional[pulumi.Input[_builtins.str]] = None,
                 middle_initial: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides Nutanix resource to Create a User.

        ## Import

        This helps to manage existing entities which are not created through terraform. Users can be imported using the `UUID`.  eg,

        hcl

        // create its configuration in the root module. For example:

        resource "nutanix_users_v2" "import_user" {}

        // execute this command

        ```sh
        $ pulumi import nutanix:index/usersV2:UsersV2 import_user <UUID>
        ```

        See detailed information in [Nutanix Users v4](https://developers.nutanix.com/api-reference?namespace=iam&version=v4.0#tag/Users/operation/createUser).

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UsersV2AdditionalAttributeArgs', 'UsersV2AdditionalAttributeArgsDict']]]] additional_attributes: -  Any additional attribute for the User.
        :param pulumi.Input[_builtins.str] description: - Description of the user.
        :param pulumi.Input[_builtins.str] display_name: - Display name for the User.
        :param pulumi.Input[_builtins.str] email_id: - Email Id for the User.
        :param pulumi.Input[_builtins.str] first_name: - First name for the User.
        :param pulumi.Input[_builtins.str] idp_id: - Identifier of the IDP for the User.
        :param pulumi.Input[_builtins.str] last_name: - Last name for the User.
        :param pulumi.Input[_builtins.str] locale: - Default locale for the User.
        :param pulumi.Input[_builtins.str] middle_initial: - Middle name for the User.
        :param pulumi.Input[_builtins.str] region: - Default Region for the User.
        :param pulumi.Input[_builtins.str] status: - Status of the User. `ACTIVE`: Denotes that the local User is active. `INACTIVE`: Denotes that the local User is inactive and needs to be reactivated.
        :param pulumi.Input[_builtins.str] user_type: - Enum: `$UNKNOWN` `$REDACTED` `LOCAL` `SAML` `LDAP` `EXTERNAL`
               Type of the User.
        :param pulumi.Input[_builtins.str] username: - Identifier for the User in the form an email address.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UsersV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides Nutanix resource to Create a User.

        ## Import

        This helps to manage existing entities which are not created through terraform. Users can be imported using the `UUID`.  eg,

        hcl

        // create its configuration in the root module. For example:

        resource "nutanix_users_v2" "import_user" {}

        // execute this command

        ```sh
        $ pulumi import nutanix:index/usersV2:UsersV2 import_user <UUID>
        ```

        See detailed information in [Nutanix Users v4](https://developers.nutanix.com/api-reference?namespace=iam&version=v4.0#tag/Users/operation/createUser).

        :param str resource_name: The name of the resource.
        :param UsersV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UsersV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UsersV2AdditionalAttributeArgs', 'UsersV2AdditionalAttributeArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email_id: Optional[pulumi.Input[_builtins.str]] = None,
                 first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 force_reset_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 idp_id: Optional[pulumi.Input[_builtins.str]] = None,
                 last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 locale: Optional[pulumi.Input[_builtins.str]] = None,
                 middle_initial: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UsersV2Args.__new__(UsersV2Args)

            __props__.__dict__["additional_attributes"] = additional_attributes
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["email_id"] = email_id
            __props__.__dict__["first_name"] = first_name
            __props__.__dict__["force_reset_password"] = force_reset_password
            __props__.__dict__["idp_id"] = idp_id
            __props__.__dict__["last_name"] = last_name
            __props__.__dict__["locale"] = locale
            __props__.__dict__["middle_initial"] = middle_initial
            __props__.__dict__["password"] = password
            __props__.__dict__["region"] = region
            __props__.__dict__["status"] = status
            if user_type is None and not opts.urn:
                raise TypeError("Missing required property 'user_type'")
            __props__.__dict__["user_type"] = user_type
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
            __props__.__dict__["buckets_access_keys"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["created_time"] = None
            __props__.__dict__["ext_id"] = None
            __props__.__dict__["last_login_time"] = None
            __props__.__dict__["last_updated_time"] = None
            __props__.__dict__["links"] = None
        super(UsersV2, __self__).__init__(
            'nutanix:index/usersV2:UsersV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UsersV2AdditionalAttributeArgs', 'UsersV2AdditionalAttributeArgsDict']]]]] = None,
            buckets_access_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UsersV2BucketsAccessKeyArgs', 'UsersV2BucketsAccessKeyArgsDict']]]]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            created_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            email_id: Optional[pulumi.Input[_builtins.str]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            first_name: Optional[pulumi.Input[_builtins.str]] = None,
            force_reset_password: Optional[pulumi.Input[_builtins.bool]] = None,
            idp_id: Optional[pulumi.Input[_builtins.str]] = None,
            last_login_time: Optional[pulumi.Input[_builtins.str]] = None,
            last_name: Optional[pulumi.Input[_builtins.str]] = None,
            last_updated_time: Optional[pulumi.Input[_builtins.str]] = None,
            links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UsersV2LinkArgs', 'UsersV2LinkArgsDict']]]]] = None,
            locale: Optional[pulumi.Input[_builtins.str]] = None,
            middle_initial: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            user_type: Optional[pulumi.Input[_builtins.str]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None) -> 'UsersV2':
        """
        Get an existing UsersV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UsersV2AdditionalAttributeArgs', 'UsersV2AdditionalAttributeArgsDict']]]] additional_attributes: -  Any additional attribute for the User.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UsersV2BucketsAccessKeyArgs', 'UsersV2BucketsAccessKeyArgsDict']]]] buckets_access_keys: - Bucket Access Keys for the User.
        :param pulumi.Input[_builtins.str] created_by: - User or Service who created the User.
        :param pulumi.Input[_builtins.str] created_time: - Creation time for the Bucket Access Key.
        :param pulumi.Input[_builtins.str] description: - Description of the user.
        :param pulumi.Input[_builtins.str] display_name: - Display name for the User.
        :param pulumi.Input[_builtins.str] email_id: - Email Id for the User.
        :param pulumi.Input[_builtins.str] ext_id: - A globally unique identifier of an instance that is suitable for external consumption.
        :param pulumi.Input[_builtins.str] first_name: - First name for the User.
        :param pulumi.Input[_builtins.str] idp_id: - Identifier of the IDP for the User.
        :param pulumi.Input[_builtins.str] last_login_time: - Last successful logged in time for the User.
        :param pulumi.Input[_builtins.str] last_name: - Last name for the User.
        :param pulumi.Input[_builtins.str] last_updated_time: - Last updated time of the User.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UsersV2LinkArgs', 'UsersV2LinkArgsDict']]]] links: - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        :param pulumi.Input[_builtins.str] locale: - Default locale for the User.
        :param pulumi.Input[_builtins.str] middle_initial: - Middle name for the User.
        :param pulumi.Input[_builtins.str] region: - Default Region for the User.
        :param pulumi.Input[_builtins.str] status: - Status of the User. `ACTIVE`: Denotes that the local User is active. `INACTIVE`: Denotes that the local User is inactive and needs to be reactivated.
        :param pulumi.Input[_builtins.str] user_type: - Enum: `$UNKNOWN` `$REDACTED` `LOCAL` `SAML` `LDAP` `EXTERNAL`
               Type of the User.
        :param pulumi.Input[_builtins.str] username: - Identifier for the User in the form an email address.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UsersV2State.__new__(_UsersV2State)

        __props__.__dict__["additional_attributes"] = additional_attributes
        __props__.__dict__["buckets_access_keys"] = buckets_access_keys
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["created_time"] = created_time
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["email_id"] = email_id
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["first_name"] = first_name
        __props__.__dict__["force_reset_password"] = force_reset_password
        __props__.__dict__["idp_id"] = idp_id
        __props__.__dict__["last_login_time"] = last_login_time
        __props__.__dict__["last_name"] = last_name
        __props__.__dict__["last_updated_time"] = last_updated_time
        __props__.__dict__["links"] = links
        __props__.__dict__["locale"] = locale
        __props__.__dict__["middle_initial"] = middle_initial
        __props__.__dict__["password"] = password
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["user_type"] = user_type
        __props__.__dict__["username"] = username
        return UsersV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalAttributes")
    def additional_attributes(self) -> pulumi.Output[Sequence['outputs.UsersV2AdditionalAttribute']]:
        """
        -  Any additional attribute for the User.
        """
        return pulumi.get(self, "additional_attributes")

    @_builtins.property
    @pulumi.getter(name="bucketsAccessKeys")
    def buckets_access_keys(self) -> pulumi.Output[Sequence['outputs.UsersV2BucketsAccessKey']]:
        """
        - Bucket Access Keys for the User.
        """
        return pulumi.get(self, "buckets_access_keys")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        - User or Service who created the User.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[_builtins.str]:
        """
        - Creation time for the Bucket Access Key.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        - Description of the user.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        - Display name for the User.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="emailId")
    def email_id(self) -> pulumi.Output[_builtins.str]:
        """
        - Email Id for the User.
        """
        return pulumi.get(self, "email_id")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        - A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> pulumi.Output[_builtins.str]:
        """
        - First name for the User.
        """
        return pulumi.get(self, "first_name")

    @_builtins.property
    @pulumi.getter(name="forceResetPassword")
    def force_reset_password(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "force_reset_password")

    @_builtins.property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> pulumi.Output[_builtins.str]:
        """
        - Identifier of the IDP for the User.
        """
        return pulumi.get(self, "idp_id")

    @_builtins.property
    @pulumi.getter(name="lastLoginTime")
    def last_login_time(self) -> pulumi.Output[_builtins.str]:
        """
        - Last successful logged in time for the User.
        """
        return pulumi.get(self, "last_login_time")

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> pulumi.Output[_builtins.str]:
        """
        - Last name for the User.
        """
        return pulumi.get(self, "last_name")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> pulumi.Output[_builtins.str]:
        """
        - Last updated time of the User.
        """
        return pulumi.get(self, "last_updated_time")

    @_builtins.property
    @pulumi.getter
    def links(self) -> pulumi.Output[Sequence['outputs.UsersV2Link']]:
        """
        - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def locale(self) -> pulumi.Output[_builtins.str]:
        """
        - Default locale for the User.
        """
        return pulumi.get(self, "locale")

    @_builtins.property
    @pulumi.getter(name="middleInitial")
    def middle_initial(self) -> pulumi.Output[_builtins.str]:
        """
        - Middle name for the User.
        """
        return pulumi.get(self, "middle_initial")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        - Default Region for the User.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        - Status of the User. `ACTIVE`: Denotes that the local User is active. `INACTIVE`: Denotes that the local User is inactive and needs to be reactivated.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="userType")
    def user_type(self) -> pulumi.Output[_builtins.str]:
        """
        - Enum: `$UNKNOWN` `$REDACTED` `LOCAL` `SAML` `LDAP` `EXTERNAL`
        Type of the User.
        """
        return pulumi.get(self, "user_type")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[_builtins.str]:
        """
        - Identifier for the User in the form an email address.
        """
        return pulumi.get(self, "username")

