# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VirtualMachineArgs', 'VirtualMachine']

@pulumi.input_type
class VirtualMachineArgs:
    def __init__(__self__, *,
                 cluster_uuid: pulumi.Input[_builtins.str],
                 availability_zone_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 boot_device_disk_address: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 boot_device_mac_address: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_device_order_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 boot_type: Optional[pulumi.Input[_builtins.str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineCategoryArgs']]]] = None,
                 cloud_init_cdrom_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_lists: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineDiskListArgs']]]] = None,
                 enable_cpu_passthrough: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_script_exec: Optional[pulumi.Input[_builtins.bool]] = None,
                 gpu_lists: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineGpuListArgs']]]] = None,
                 guest_customization_cloud_init_custom_key_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 guest_customization_cloud_init_meta_data: Optional[pulumi.Input[_builtins.str]] = None,
                 guest_customization_cloud_init_user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 guest_customization_is_overridable: Optional[pulumi.Input[_builtins.bool]] = None,
                 guest_customization_sysprep: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 guest_customization_sysprep_custom_key_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 guest_os_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hardware_clock_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 is_vcpu_hard_pinned: Optional[pulumi.Input[_builtins.bool]] = None,
                 machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_size_mib: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ngt_credentials: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ngt_enabled_capability_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 nic_lists: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineNicListArgs']]]] = None,
                 num_sockets: Optional[pulumi.Input[_builtins.int]] = None,
                 num_vcpus_per_socket: Optional[pulumi.Input[_builtins.int]] = None,
                 num_vnuma_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 nutanix_guest_tools: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 parent_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 power_state: Optional[pulumi.Input[_builtins.str]] = None,
                 power_state_mechanism: Optional[pulumi.Input[_builtins.str]] = None,
                 project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 serial_port_lists: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineSerialPortListArgs']]]] = None,
                 should_fail_on_script_failure: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_hot_add: Optional[pulumi.Input[_builtins.bool]] = None,
                 vga_console_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a VirtualMachine resource.
        :param pulumi.Input[_builtins.str] cluster_uuid: - (Required) The UUID of the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] availability_zone_reference: - (Optional) The reference to a availability_zone.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] boot_device_disk_address: - (Optional) Address of disk to boot from.
        :param pulumi.Input[_builtins.str] boot_device_mac_address: - (Optional) MAC address of nic to boot from.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] boot_device_order_lists: - (Optional) Indicates the order of device types in which VM should try to boot from. If boot device order is not provided the system will decide appropriate boot device order.
        :param pulumi.Input[_builtins.str] boot_type: - (Optional) Indicates whether the VM should use Secure boot, UEFI boot or Legacy boot.If UEFI or; Secure boot is enabled then other legacy boot options (like boot_device and; boot_device_order_list) are ignored. Secure boot depends on UEFI boot, i.e. enabling; Secure boot means that UEFI boot is also enabled. The possible value are: UEFI", "LEGACY", "SECURE_BOOT".
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineCategoryArgs']]] categories: - (Optional) Categories for the vm.
        :param pulumi.Input[_builtins.str] description: - (Optional) A description for vm.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineDiskListArgs']]] disk_lists: Disks attached to the VM.
        :param pulumi.Input[_builtins.bool] enable_cpu_passthrough: - (Optional) Add true to enable CPU passthrough.
        :param pulumi.Input[_builtins.bool] enable_script_exec: - (Optional) Extra configs related to power state transition. Indicates whether to execute set script before ngt shutdown/reboot.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineGpuListArgs']]] gpu_lists: - (Optional) GPUs attached to the VM.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] guest_customization_cloud_init_custom_key_values: - (Optional) Generic key value pair used for custom attributes in cloud init.
        :param pulumi.Input[_builtins.str] guest_customization_cloud_init_meta_data: The contents of the meta_data configuration for cloud-init. This can be formatted as YAML or JSON. The value must be base64 encoded.
        :param pulumi.Input[_builtins.str] guest_customization_cloud_init_user_data: - (Optional) The contents of the user_data configuration for cloud-init. This can be formatted as YAML, JSON, or could be a shell script. The value must be base64 encoded.
        :param pulumi.Input[_builtins.bool] guest_customization_is_overridable: - (Optional) Flag to allow override of customization by deployer.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] guest_customization_sysprep: - (Optional) VM guests may be customized at boot time using one of several different methods. Currently, cloud-init w/ ConfigDriveV2 (for Linux VMs) and Sysprep (for Windows VMs) are supported. Only ONE OF sysprep or cloud_init should be provided. Note that guest customization can currently only be set during VM creation. Attempting to change it after creation will result in an error. Additional properties can be specified. For example - in the context of VM template creation if \\"override_script\\" is set to \\"True\\" then the deployer can upload their own custom script.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] guest_customization_sysprep_custom_key_values: - (Optional) Generic key value pair used for custom attributes in sysprep.
        :param pulumi.Input[_builtins.str] guest_os_id: - (Optional) Guest OS Identifier. For ESX, refer to VMware documentation [link](https://www.vmware.com/support/developer/converter-sdk/conv43_apireference/vim.vm.GuestOsDescriptor.GuestOsIdentifier.html) for the list of guest OS identifiers.
        :param pulumi.Input[_builtins.str] hardware_clock_timezone: - (Optional) VM's hardware clock timezone in IANA TZDB format (America/Los_Angeles).
        :param pulumi.Input[_builtins.bool] is_vcpu_hard_pinned: - (Optional) Add true to enable CPU pinning.
        :param pulumi.Input[_builtins.str] machine_type: - Machine type for the VM. Machine type Q35 is required for secure boot and does not support IDE disks.
        :param pulumi.Input[_builtins.int] memory_size_mib: - (Optional) Memory size in MiB. On updating memory to powered ON VMs should only be done in 1GB increments.
        :param pulumi.Input[_builtins.str] name: - (Required) The name for the vm.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] ngt_credentials: - (Ooptional) Credentials to login server.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ngt_enabled_capability_lists: Application names that are enabled.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineNicListArgs']]] nic_lists: - (Optional) Spec NICs attached to the VM.
        :param pulumi.Input[_builtins.int] num_sockets: - (Optional) Number of vCPU sockets.
        :param pulumi.Input[_builtins.int] num_vcpus_per_socket: - (Optional) Number of vCPUs per socket.
        :param pulumi.Input[_builtins.int] num_vnuma_nodes: - (Optional) Number of vNUMA nodes. 0 means vNUMA is disabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] nutanix_guest_tools: - (Optional) Information regarding Nutanix Guest Tools.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] owner_reference: - (Optional) The reference to a user.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parent_reference: - (Optional) Reference to an entity that the VM cloned from.
        :param pulumi.Input[_builtins.str] power_state: - (Optional) The current or desired power state of the VM. (Options : ON , OFF)
        :param pulumi.Input[_builtins.str] power_state_mechanism: - (Optional) Indicates the mechanism guiding the VM power state transition. Currently used for the transition to \\"OFF\\" state. Power state mechanism (ACPI/GUEST/HARD).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] project_reference: - (Optional) The reference to a project.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineSerialPortListArgs']]] serial_port_lists: - (Optional) Serial Ports configured on the VM.
        :param pulumi.Input[_builtins.bool] should_fail_on_script_failure: - (Optional)  Extra configs related to power state transition. Indicates whether to abort ngt shutdown/reboot if script fails.
        :param pulumi.Input[_builtins.bool] use_hot_add: - (Optional) Use Hot Add when modifying VM resources. Passing value false will result in VM reboots. Default value is `true`.
        :param pulumi.Input[_builtins.bool] vga_console_enabled: - (Optional) Indicates whether VGA console should be enabled or not.
        """
        pulumi.set(__self__, "cluster_uuid", cluster_uuid)
        if availability_zone_reference is not None:
            pulumi.set(__self__, "availability_zone_reference", availability_zone_reference)
        if boot_device_disk_address is not None:
            pulumi.set(__self__, "boot_device_disk_address", boot_device_disk_address)
        if boot_device_mac_address is not None:
            pulumi.set(__self__, "boot_device_mac_address", boot_device_mac_address)
        if boot_device_order_lists is not None:
            pulumi.set(__self__, "boot_device_order_lists", boot_device_order_lists)
        if boot_type is not None:
            pulumi.set(__self__, "boot_type", boot_type)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if cloud_init_cdrom_uuid is not None:
            pulumi.set(__self__, "cloud_init_cdrom_uuid", cloud_init_cdrom_uuid)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_lists is not None:
            pulumi.set(__self__, "disk_lists", disk_lists)
        if enable_cpu_passthrough is not None:
            pulumi.set(__self__, "enable_cpu_passthrough", enable_cpu_passthrough)
        if enable_script_exec is not None:
            pulumi.set(__self__, "enable_script_exec", enable_script_exec)
        if gpu_lists is not None:
            pulumi.set(__self__, "gpu_lists", gpu_lists)
        if guest_customization_cloud_init_custom_key_values is not None:
            pulumi.set(__self__, "guest_customization_cloud_init_custom_key_values", guest_customization_cloud_init_custom_key_values)
        if guest_customization_cloud_init_meta_data is not None:
            pulumi.set(__self__, "guest_customization_cloud_init_meta_data", guest_customization_cloud_init_meta_data)
        if guest_customization_cloud_init_user_data is not None:
            pulumi.set(__self__, "guest_customization_cloud_init_user_data", guest_customization_cloud_init_user_data)
        if guest_customization_is_overridable is not None:
            pulumi.set(__self__, "guest_customization_is_overridable", guest_customization_is_overridable)
        if guest_customization_sysprep is not None:
            pulumi.set(__self__, "guest_customization_sysprep", guest_customization_sysprep)
        if guest_customization_sysprep_custom_key_values is not None:
            pulumi.set(__self__, "guest_customization_sysprep_custom_key_values", guest_customization_sysprep_custom_key_values)
        if guest_os_id is not None:
            pulumi.set(__self__, "guest_os_id", guest_os_id)
        if hardware_clock_timezone is not None:
            pulumi.set(__self__, "hardware_clock_timezone", hardware_clock_timezone)
        if is_vcpu_hard_pinned is not None:
            pulumi.set(__self__, "is_vcpu_hard_pinned", is_vcpu_hard_pinned)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if memory_size_mib is not None:
            pulumi.set(__self__, "memory_size_mib", memory_size_mib)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ngt_credentials is not None:
            pulumi.set(__self__, "ngt_credentials", ngt_credentials)
        if ngt_enabled_capability_lists is not None:
            pulumi.set(__self__, "ngt_enabled_capability_lists", ngt_enabled_capability_lists)
        if nic_lists is not None:
            pulumi.set(__self__, "nic_lists", nic_lists)
        if num_sockets is not None:
            pulumi.set(__self__, "num_sockets", num_sockets)
        if num_vcpus_per_socket is not None:
            pulumi.set(__self__, "num_vcpus_per_socket", num_vcpus_per_socket)
        if num_vnuma_nodes is not None:
            pulumi.set(__self__, "num_vnuma_nodes", num_vnuma_nodes)
        if nutanix_guest_tools is not None:
            pulumi.set(__self__, "nutanix_guest_tools", nutanix_guest_tools)
        if owner_reference is not None:
            pulumi.set(__self__, "owner_reference", owner_reference)
        if parent_reference is not None:
            pulumi.set(__self__, "parent_reference", parent_reference)
        if power_state is not None:
            pulumi.set(__self__, "power_state", power_state)
        if power_state_mechanism is not None:
            pulumi.set(__self__, "power_state_mechanism", power_state_mechanism)
        if project_reference is not None:
            pulumi.set(__self__, "project_reference", project_reference)
        if serial_port_lists is not None:
            pulumi.set(__self__, "serial_port_lists", serial_port_lists)
        if should_fail_on_script_failure is not None:
            pulumi.set(__self__, "should_fail_on_script_failure", should_fail_on_script_failure)
        if use_hot_add is not None:
            pulumi.set(__self__, "use_hot_add", use_hot_add)
        if vga_console_enabled is not None:
            pulumi.set(__self__, "vga_console_enabled", vga_console_enabled)

    @_builtins.property
    @pulumi.getter(name="clusterUuid")
    def cluster_uuid(self) -> pulumi.Input[_builtins.str]:
        """
        - (Required) The UUID of the cluster.
        """
        return pulumi.get(self, "cluster_uuid")

    @cluster_uuid.setter
    def cluster_uuid(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_uuid", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZoneReference")
    def availability_zone_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The reference to a availability_zone.
        """
        return pulumi.get(self, "availability_zone_reference")

    @availability_zone_reference.setter
    def availability_zone_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zone_reference", value)

    @_builtins.property
    @pulumi.getter(name="bootDeviceDiskAddress")
    def boot_device_disk_address(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) Address of disk to boot from.
        """
        return pulumi.get(self, "boot_device_disk_address")

    @boot_device_disk_address.setter
    def boot_device_disk_address(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "boot_device_disk_address", value)

    @_builtins.property
    @pulumi.getter(name="bootDeviceMacAddress")
    def boot_device_mac_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) MAC address of nic to boot from.
        """
        return pulumi.get(self, "boot_device_mac_address")

    @boot_device_mac_address.setter
    def boot_device_mac_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "boot_device_mac_address", value)

    @_builtins.property
    @pulumi.getter(name="bootDeviceOrderLists")
    def boot_device_order_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) Indicates the order of device types in which VM should try to boot from. If boot device order is not provided the system will decide appropriate boot device order.
        """
        return pulumi.get(self, "boot_device_order_lists")

    @boot_device_order_lists.setter
    def boot_device_order_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "boot_device_order_lists", value)

    @_builtins.property
    @pulumi.getter(name="bootType")
    def boot_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) Indicates whether the VM should use Secure boot, UEFI boot or Legacy boot.If UEFI or; Secure boot is enabled then other legacy boot options (like boot_device and; boot_device_order_list) are ignored. Secure boot depends on UEFI boot, i.e. enabling; Secure boot means that UEFI boot is also enabled. The possible value are: UEFI", "LEGACY", "SECURE_BOOT".
        """
        return pulumi.get(self, "boot_type")

    @boot_type.setter
    def boot_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "boot_type", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineCategoryArgs']]]]:
        """
        - (Optional) Categories for the vm.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineCategoryArgs']]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter(name="cloudInitCdromUuid")
    def cloud_init_cdrom_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cloud_init_cdrom_uuid")

    @cloud_init_cdrom_uuid.setter
    def cloud_init_cdrom_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_init_cdrom_uuid", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) A description for vm.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskLists")
    def disk_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineDiskListArgs']]]]:
        """
        Disks attached to the VM.
        """
        return pulumi.get(self, "disk_lists")

    @disk_lists.setter
    def disk_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineDiskListArgs']]]]):
        pulumi.set(self, "disk_lists", value)

    @_builtins.property
    @pulumi.getter(name="enableCpuPassthrough")
    def enable_cpu_passthrough(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Add true to enable CPU passthrough.
        """
        return pulumi.get(self, "enable_cpu_passthrough")

    @enable_cpu_passthrough.setter
    def enable_cpu_passthrough(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_cpu_passthrough", value)

    @_builtins.property
    @pulumi.getter(name="enableScriptExec")
    def enable_script_exec(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Extra configs related to power state transition. Indicates whether to execute set script before ngt shutdown/reboot.
        """
        return pulumi.get(self, "enable_script_exec")

    @enable_script_exec.setter
    def enable_script_exec(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_script_exec", value)

    @_builtins.property
    @pulumi.getter(name="gpuLists")
    def gpu_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineGpuListArgs']]]]:
        """
        - (Optional) GPUs attached to the VM.
        """
        return pulumi.get(self, "gpu_lists")

    @gpu_lists.setter
    def gpu_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineGpuListArgs']]]]):
        pulumi.set(self, "gpu_lists", value)

    @_builtins.property
    @pulumi.getter(name="guestCustomizationCloudInitCustomKeyValues")
    def guest_customization_cloud_init_custom_key_values(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) Generic key value pair used for custom attributes in cloud init.
        """
        return pulumi.get(self, "guest_customization_cloud_init_custom_key_values")

    @guest_customization_cloud_init_custom_key_values.setter
    def guest_customization_cloud_init_custom_key_values(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "guest_customization_cloud_init_custom_key_values", value)

    @_builtins.property
    @pulumi.getter(name="guestCustomizationCloudInitMetaData")
    def guest_customization_cloud_init_meta_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The contents of the meta_data configuration for cloud-init. This can be formatted as YAML or JSON. The value must be base64 encoded.
        """
        return pulumi.get(self, "guest_customization_cloud_init_meta_data")

    @guest_customization_cloud_init_meta_data.setter
    def guest_customization_cloud_init_meta_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "guest_customization_cloud_init_meta_data", value)

    @_builtins.property
    @pulumi.getter(name="guestCustomizationCloudInitUserData")
    def guest_customization_cloud_init_user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The contents of the user_data configuration for cloud-init. This can be formatted as YAML, JSON, or could be a shell script. The value must be base64 encoded.
        """
        return pulumi.get(self, "guest_customization_cloud_init_user_data")

    @guest_customization_cloud_init_user_data.setter
    def guest_customization_cloud_init_user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "guest_customization_cloud_init_user_data", value)

    @_builtins.property
    @pulumi.getter(name="guestCustomizationIsOverridable")
    def guest_customization_is_overridable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Flag to allow override of customization by deployer.
        """
        return pulumi.get(self, "guest_customization_is_overridable")

    @guest_customization_is_overridable.setter
    def guest_customization_is_overridable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "guest_customization_is_overridable", value)

    @_builtins.property
    @pulumi.getter(name="guestCustomizationSysprep")
    def guest_customization_sysprep(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) VM guests may be customized at boot time using one of several different methods. Currently, cloud-init w/ ConfigDriveV2 (for Linux VMs) and Sysprep (for Windows VMs) are supported. Only ONE OF sysprep or cloud_init should be provided. Note that guest customization can currently only be set during VM creation. Attempting to change it after creation will result in an error. Additional properties can be specified. For example - in the context of VM template creation if \\"override_script\\" is set to \\"True\\" then the deployer can upload their own custom script.
        """
        return pulumi.get(self, "guest_customization_sysprep")

    @guest_customization_sysprep.setter
    def guest_customization_sysprep(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "guest_customization_sysprep", value)

    @_builtins.property
    @pulumi.getter(name="guestCustomizationSysprepCustomKeyValues")
    def guest_customization_sysprep_custom_key_values(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) Generic key value pair used for custom attributes in sysprep.
        """
        return pulumi.get(self, "guest_customization_sysprep_custom_key_values")

    @guest_customization_sysprep_custom_key_values.setter
    def guest_customization_sysprep_custom_key_values(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "guest_customization_sysprep_custom_key_values", value)

    @_builtins.property
    @pulumi.getter(name="guestOsId")
    def guest_os_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) Guest OS Identifier. For ESX, refer to VMware documentation [link](https://www.vmware.com/support/developer/converter-sdk/conv43_apireference/vim.vm.GuestOsDescriptor.GuestOsIdentifier.html) for the list of guest OS identifiers.
        """
        return pulumi.get(self, "guest_os_id")

    @guest_os_id.setter
    def guest_os_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "guest_os_id", value)

    @_builtins.property
    @pulumi.getter(name="hardwareClockTimezone")
    def hardware_clock_timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) VM's hardware clock timezone in IANA TZDB format (America/Los_Angeles).
        """
        return pulumi.get(self, "hardware_clock_timezone")

    @hardware_clock_timezone.setter
    def hardware_clock_timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hardware_clock_timezone", value)

    @_builtins.property
    @pulumi.getter(name="isVcpuHardPinned")
    def is_vcpu_hard_pinned(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Add true to enable CPU pinning.
        """
        return pulumi.get(self, "is_vcpu_hard_pinned")

    @is_vcpu_hard_pinned.setter
    def is_vcpu_hard_pinned(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_vcpu_hard_pinned", value)

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Machine type for the VM. Machine type Q35 is required for secure boot and does not support IDE disks.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "machine_type", value)

    @_builtins.property
    @pulumi.getter(name="memorySizeMib")
    def memory_size_mib(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - (Optional) Memory size in MiB. On updating memory to powered ON VMs should only be done in 1GB increments.
        """
        return pulumi.get(self, "memory_size_mib")

    @memory_size_mib.setter
    def memory_size_mib(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_size_mib", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) The name for the vm.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ngtCredentials")
    def ngt_credentials(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Ooptional) Credentials to login server.
        """
        return pulumi.get(self, "ngt_credentials")

    @ngt_credentials.setter
    def ngt_credentials(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ngt_credentials", value)

    @_builtins.property
    @pulumi.getter(name="ngtEnabledCapabilityLists")
    def ngt_enabled_capability_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Application names that are enabled.
        """
        return pulumi.get(self, "ngt_enabled_capability_lists")

    @ngt_enabled_capability_lists.setter
    def ngt_enabled_capability_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ngt_enabled_capability_lists", value)

    @_builtins.property
    @pulumi.getter(name="nicLists")
    def nic_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineNicListArgs']]]]:
        """
        - (Optional) Spec NICs attached to the VM.
        """
        return pulumi.get(self, "nic_lists")

    @nic_lists.setter
    def nic_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineNicListArgs']]]]):
        pulumi.set(self, "nic_lists", value)

    @_builtins.property
    @pulumi.getter(name="numSockets")
    def num_sockets(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - (Optional) Number of vCPU sockets.
        """
        return pulumi.get(self, "num_sockets")

    @num_sockets.setter
    def num_sockets(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_sockets", value)

    @_builtins.property
    @pulumi.getter(name="numVcpusPerSocket")
    def num_vcpus_per_socket(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - (Optional) Number of vCPUs per socket.
        """
        return pulumi.get(self, "num_vcpus_per_socket")

    @num_vcpus_per_socket.setter
    def num_vcpus_per_socket(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_vcpus_per_socket", value)

    @_builtins.property
    @pulumi.getter(name="numVnumaNodes")
    def num_vnuma_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - (Optional) Number of vNUMA nodes. 0 means vNUMA is disabled.
        """
        return pulumi.get(self, "num_vnuma_nodes")

    @num_vnuma_nodes.setter
    def num_vnuma_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_vnuma_nodes", value)

    @_builtins.property
    @pulumi.getter(name="nutanixGuestTools")
    def nutanix_guest_tools(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) Information regarding Nutanix Guest Tools.
        """
        return pulumi.get(self, "nutanix_guest_tools")

    @nutanix_guest_tools.setter
    def nutanix_guest_tools(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "nutanix_guest_tools", value)

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The reference to a user.
        """
        return pulumi.get(self, "owner_reference")

    @owner_reference.setter
    def owner_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "owner_reference", value)

    @_builtins.property
    @pulumi.getter(name="parentReference")
    def parent_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) Reference to an entity that the VM cloned from.
        """
        return pulumi.get(self, "parent_reference")

    @parent_reference.setter
    def parent_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parent_reference", value)

    @_builtins.property
    @pulumi.getter(name="powerState")
    def power_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The current or desired power state of the VM. (Options : ON , OFF)
        """
        return pulumi.get(self, "power_state")

    @power_state.setter
    def power_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "power_state", value)

    @_builtins.property
    @pulumi.getter(name="powerStateMechanism")
    def power_state_mechanism(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) Indicates the mechanism guiding the VM power state transition. Currently used for the transition to \\"OFF\\" state. Power state mechanism (ACPI/GUEST/HARD).
        """
        return pulumi.get(self, "power_state_mechanism")

    @power_state_mechanism.setter
    def power_state_mechanism(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "power_state_mechanism", value)

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The reference to a project.
        """
        return pulumi.get(self, "project_reference")

    @project_reference.setter
    def project_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "project_reference", value)

    @_builtins.property
    @pulumi.getter(name="serialPortLists")
    def serial_port_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineSerialPortListArgs']]]]:
        """
        - (Optional) Serial Ports configured on the VM.
        """
        return pulumi.get(self, "serial_port_lists")

    @serial_port_lists.setter
    def serial_port_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineSerialPortListArgs']]]]):
        pulumi.set(self, "serial_port_lists", value)

    @_builtins.property
    @pulumi.getter(name="shouldFailOnScriptFailure")
    def should_fail_on_script_failure(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional)  Extra configs related to power state transition. Indicates whether to abort ngt shutdown/reboot if script fails.
        """
        return pulumi.get(self, "should_fail_on_script_failure")

    @should_fail_on_script_failure.setter
    def should_fail_on_script_failure(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "should_fail_on_script_failure", value)

    @_builtins.property
    @pulumi.getter(name="useHotAdd")
    def use_hot_add(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Use Hot Add when modifying VM resources. Passing value false will result in VM reboots. Default value is `true`.
        """
        return pulumi.get(self, "use_hot_add")

    @use_hot_add.setter
    def use_hot_add(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_hot_add", value)

    @_builtins.property
    @pulumi.getter(name="vgaConsoleEnabled")
    def vga_console_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Indicates whether VGA console should be enabled or not.
        """
        return pulumi.get(self, "vga_console_enabled")

    @vga_console_enabled.setter
    def vga_console_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "vga_console_enabled", value)


@pulumi.input_type
class _VirtualMachineState:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 boot_device_disk_address: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 boot_device_mac_address: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_device_order_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 boot_type: Optional[pulumi.Input[_builtins.str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineCategoryArgs']]]] = None,
                 cloud_init_cdrom_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_lists: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineDiskListArgs']]]] = None,
                 enable_cpu_passthrough: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_script_exec: Optional[pulumi.Input[_builtins.bool]] = None,
                 gpu_lists: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineGpuListArgs']]]] = None,
                 guest_customization_cloud_init_custom_key_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 guest_customization_cloud_init_meta_data: Optional[pulumi.Input[_builtins.str]] = None,
                 guest_customization_cloud_init_user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 guest_customization_is_overridable: Optional[pulumi.Input[_builtins.bool]] = None,
                 guest_customization_sysprep: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 guest_customization_sysprep_custom_key_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 guest_os_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hardware_clock_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 host_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 hypervisor_type: Optional[pulumi.Input[_builtins.str]] = None,
                 is_vcpu_hard_pinned: Optional[pulumi.Input[_builtins.bool]] = None,
                 machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_size_mib: Optional[pulumi.Input[_builtins.int]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ngt_credentials: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ngt_enabled_capability_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 nic_list_statuses: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineNicListStatusArgs']]]] = None,
                 nic_lists: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineNicListArgs']]]] = None,
                 num_sockets: Optional[pulumi.Input[_builtins.int]] = None,
                 num_vcpus_per_socket: Optional[pulumi.Input[_builtins.int]] = None,
                 num_vnuma_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 nutanix_guest_tools: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 parent_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 power_state: Optional[pulumi.Input[_builtins.str]] = None,
                 power_state_mechanism: Optional[pulumi.Input[_builtins.str]] = None,
                 project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 serial_port_lists: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineSerialPortListArgs']]]] = None,
                 should_fail_on_script_failure: Optional[pulumi.Input[_builtins.bool]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 use_hot_add: Optional[pulumi.Input[_builtins.bool]] = None,
                 vga_console_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering VirtualMachine resources.
        :param pulumi.Input[_builtins.str] api_version: The version of the API.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] availability_zone_reference: - (Optional) The reference to a availability_zone.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] boot_device_disk_address: - (Optional) Address of disk to boot from.
        :param pulumi.Input[_builtins.str] boot_device_mac_address: - (Optional) MAC address of nic to boot from.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] boot_device_order_lists: - (Optional) Indicates the order of device types in which VM should try to boot from. If boot device order is not provided the system will decide appropriate boot device order.
        :param pulumi.Input[_builtins.str] boot_type: - (Optional) Indicates whether the VM should use Secure boot, UEFI boot or Legacy boot.If UEFI or; Secure boot is enabled then other legacy boot options (like boot_device and; boot_device_order_list) are ignored. Secure boot depends on UEFI boot, i.e. enabling; Secure boot means that UEFI boot is also enabled. The possible value are: UEFI", "LEGACY", "SECURE_BOOT".
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineCategoryArgs']]] categories: - (Optional) Categories for the vm.
        :param pulumi.Input[_builtins.str] cluster_name: - The name of the cluster.
        :param pulumi.Input[_builtins.str] cluster_uuid: - (Required) The UUID of the cluster.
        :param pulumi.Input[_builtins.str] description: - (Optional) A description for vm.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineDiskListArgs']]] disk_lists: Disks attached to the VM.
        :param pulumi.Input[_builtins.bool] enable_cpu_passthrough: - (Optional) Add true to enable CPU passthrough.
        :param pulumi.Input[_builtins.bool] enable_script_exec: - (Optional) Extra configs related to power state transition. Indicates whether to execute set script before ngt shutdown/reboot.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineGpuListArgs']]] gpu_lists: - (Optional) GPUs attached to the VM.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] guest_customization_cloud_init_custom_key_values: - (Optional) Generic key value pair used for custom attributes in cloud init.
        :param pulumi.Input[_builtins.str] guest_customization_cloud_init_meta_data: The contents of the meta_data configuration for cloud-init. This can be formatted as YAML or JSON. The value must be base64 encoded.
        :param pulumi.Input[_builtins.str] guest_customization_cloud_init_user_data: - (Optional) The contents of the user_data configuration for cloud-init. This can be formatted as YAML, JSON, or could be a shell script. The value must be base64 encoded.
        :param pulumi.Input[_builtins.bool] guest_customization_is_overridable: - (Optional) Flag to allow override of customization by deployer.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] guest_customization_sysprep: - (Optional) VM guests may be customized at boot time using one of several different methods. Currently, cloud-init w/ ConfigDriveV2 (for Linux VMs) and Sysprep (for Windows VMs) are supported. Only ONE OF sysprep or cloud_init should be provided. Note that guest customization can currently only be set during VM creation. Attempting to change it after creation will result in an error. Additional properties can be specified. For example - in the context of VM template creation if \\"override_script\\" is set to \\"True\\" then the deployer can upload their own custom script.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] guest_customization_sysprep_custom_key_values: - (Optional) Generic key value pair used for custom attributes in sysprep.
        :param pulumi.Input[_builtins.str] guest_os_id: - (Optional) Guest OS Identifier. For ESX, refer to VMware documentation [link](https://www.vmware.com/support/developer/converter-sdk/conv43_apireference/vim.vm.GuestOsDescriptor.GuestOsIdentifier.html) for the list of guest OS identifiers.
        :param pulumi.Input[_builtins.str] hardware_clock_timezone: - (Optional) VM's hardware clock timezone in IANA TZDB format (America/Los_Angeles).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] host_reference: - Reference to a host.
        :param pulumi.Input[_builtins.str] hypervisor_type: - The hypervisor type for the hypervisor the VM is hosted on.
        :param pulumi.Input[_builtins.bool] is_vcpu_hard_pinned: - (Optional) Add true to enable CPU pinning.
        :param pulumi.Input[_builtins.str] machine_type: - Machine type for the VM. Machine type Q35 is required for secure boot and does not support IDE disks.
        :param pulumi.Input[_builtins.int] memory_size_mib: - (Optional) Memory size in MiB. On updating memory to powered ON VMs should only be done in 1GB increments.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: - The vm kind metadata.
        :param pulumi.Input[_builtins.str] name: - (Required) The name for the vm.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] ngt_credentials: - (Ooptional) Credentials to login server.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ngt_enabled_capability_lists: Application names that are enabled.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineNicListStatusArgs']]] nic_list_statuses: - Status NICs attached to the VM.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineNicListArgs']]] nic_lists: - (Optional) Spec NICs attached to the VM.
        :param pulumi.Input[_builtins.int] num_sockets: - (Optional) Number of vCPU sockets.
        :param pulumi.Input[_builtins.int] num_vcpus_per_socket: - (Optional) Number of vCPUs per socket.
        :param pulumi.Input[_builtins.int] num_vnuma_nodes: - (Optional) Number of vNUMA nodes. 0 means vNUMA is disabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] nutanix_guest_tools: - (Optional) Information regarding Nutanix Guest Tools.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] owner_reference: - (Optional) The reference to a user.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parent_reference: - (Optional) Reference to an entity that the VM cloned from.
        :param pulumi.Input[_builtins.str] power_state: - (Optional) The current or desired power state of the VM. (Options : ON , OFF)
        :param pulumi.Input[_builtins.str] power_state_mechanism: - (Optional) Indicates the mechanism guiding the VM power state transition. Currently used for the transition to \\"OFF\\" state. Power state mechanism (ACPI/GUEST/HARD).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] project_reference: - (Optional) The reference to a project.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineSerialPortListArgs']]] serial_port_lists: - (Optional) Serial Ports configured on the VM.
        :param pulumi.Input[_builtins.bool] should_fail_on_script_failure: - (Optional)  Extra configs related to power state transition. Indicates whether to abort ngt shutdown/reboot if script fails.
        :param pulumi.Input[_builtins.str] state: - The state of the vm.
        :param pulumi.Input[_builtins.bool] use_hot_add: - (Optional) Use Hot Add when modifying VM resources. Passing value false will result in VM reboots. Default value is `true`.
        :param pulumi.Input[_builtins.bool] vga_console_enabled: - (Optional) Indicates whether VGA console should be enabled or not.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if availability_zone_reference is not None:
            pulumi.set(__self__, "availability_zone_reference", availability_zone_reference)
        if boot_device_disk_address is not None:
            pulumi.set(__self__, "boot_device_disk_address", boot_device_disk_address)
        if boot_device_mac_address is not None:
            pulumi.set(__self__, "boot_device_mac_address", boot_device_mac_address)
        if boot_device_order_lists is not None:
            pulumi.set(__self__, "boot_device_order_lists", boot_device_order_lists)
        if boot_type is not None:
            pulumi.set(__self__, "boot_type", boot_type)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if cloud_init_cdrom_uuid is not None:
            pulumi.set(__self__, "cloud_init_cdrom_uuid", cloud_init_cdrom_uuid)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if cluster_uuid is not None:
            pulumi.set(__self__, "cluster_uuid", cluster_uuid)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_lists is not None:
            pulumi.set(__self__, "disk_lists", disk_lists)
        if enable_cpu_passthrough is not None:
            pulumi.set(__self__, "enable_cpu_passthrough", enable_cpu_passthrough)
        if enable_script_exec is not None:
            pulumi.set(__self__, "enable_script_exec", enable_script_exec)
        if gpu_lists is not None:
            pulumi.set(__self__, "gpu_lists", gpu_lists)
        if guest_customization_cloud_init_custom_key_values is not None:
            pulumi.set(__self__, "guest_customization_cloud_init_custom_key_values", guest_customization_cloud_init_custom_key_values)
        if guest_customization_cloud_init_meta_data is not None:
            pulumi.set(__self__, "guest_customization_cloud_init_meta_data", guest_customization_cloud_init_meta_data)
        if guest_customization_cloud_init_user_data is not None:
            pulumi.set(__self__, "guest_customization_cloud_init_user_data", guest_customization_cloud_init_user_data)
        if guest_customization_is_overridable is not None:
            pulumi.set(__self__, "guest_customization_is_overridable", guest_customization_is_overridable)
        if guest_customization_sysprep is not None:
            pulumi.set(__self__, "guest_customization_sysprep", guest_customization_sysprep)
        if guest_customization_sysprep_custom_key_values is not None:
            pulumi.set(__self__, "guest_customization_sysprep_custom_key_values", guest_customization_sysprep_custom_key_values)
        if guest_os_id is not None:
            pulumi.set(__self__, "guest_os_id", guest_os_id)
        if hardware_clock_timezone is not None:
            pulumi.set(__self__, "hardware_clock_timezone", hardware_clock_timezone)
        if host_reference is not None:
            pulumi.set(__self__, "host_reference", host_reference)
        if hypervisor_type is not None:
            pulumi.set(__self__, "hypervisor_type", hypervisor_type)
        if is_vcpu_hard_pinned is not None:
            pulumi.set(__self__, "is_vcpu_hard_pinned", is_vcpu_hard_pinned)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if memory_size_mib is not None:
            pulumi.set(__self__, "memory_size_mib", memory_size_mib)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ngt_credentials is not None:
            pulumi.set(__self__, "ngt_credentials", ngt_credentials)
        if ngt_enabled_capability_lists is not None:
            pulumi.set(__self__, "ngt_enabled_capability_lists", ngt_enabled_capability_lists)
        if nic_list_statuses is not None:
            pulumi.set(__self__, "nic_list_statuses", nic_list_statuses)
        if nic_lists is not None:
            pulumi.set(__self__, "nic_lists", nic_lists)
        if num_sockets is not None:
            pulumi.set(__self__, "num_sockets", num_sockets)
        if num_vcpus_per_socket is not None:
            pulumi.set(__self__, "num_vcpus_per_socket", num_vcpus_per_socket)
        if num_vnuma_nodes is not None:
            pulumi.set(__self__, "num_vnuma_nodes", num_vnuma_nodes)
        if nutanix_guest_tools is not None:
            pulumi.set(__self__, "nutanix_guest_tools", nutanix_guest_tools)
        if owner_reference is not None:
            pulumi.set(__self__, "owner_reference", owner_reference)
        if parent_reference is not None:
            pulumi.set(__self__, "parent_reference", parent_reference)
        if power_state is not None:
            pulumi.set(__self__, "power_state", power_state)
        if power_state_mechanism is not None:
            pulumi.set(__self__, "power_state_mechanism", power_state_mechanism)
        if project_reference is not None:
            pulumi.set(__self__, "project_reference", project_reference)
        if serial_port_lists is not None:
            pulumi.set(__self__, "serial_port_lists", serial_port_lists)
        if should_fail_on_script_failure is not None:
            pulumi.set(__self__, "should_fail_on_script_failure", should_fail_on_script_failure)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if use_hot_add is not None:
            pulumi.set(__self__, "use_hot_add", use_hot_add)
        if vga_console_enabled is not None:
            pulumi.set(__self__, "vga_console_enabled", vga_console_enabled)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the API.
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZoneReference")
    def availability_zone_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The reference to a availability_zone.
        """
        return pulumi.get(self, "availability_zone_reference")

    @availability_zone_reference.setter
    def availability_zone_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zone_reference", value)

    @_builtins.property
    @pulumi.getter(name="bootDeviceDiskAddress")
    def boot_device_disk_address(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) Address of disk to boot from.
        """
        return pulumi.get(self, "boot_device_disk_address")

    @boot_device_disk_address.setter
    def boot_device_disk_address(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "boot_device_disk_address", value)

    @_builtins.property
    @pulumi.getter(name="bootDeviceMacAddress")
    def boot_device_mac_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) MAC address of nic to boot from.
        """
        return pulumi.get(self, "boot_device_mac_address")

    @boot_device_mac_address.setter
    def boot_device_mac_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "boot_device_mac_address", value)

    @_builtins.property
    @pulumi.getter(name="bootDeviceOrderLists")
    def boot_device_order_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) Indicates the order of device types in which VM should try to boot from. If boot device order is not provided the system will decide appropriate boot device order.
        """
        return pulumi.get(self, "boot_device_order_lists")

    @boot_device_order_lists.setter
    def boot_device_order_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "boot_device_order_lists", value)

    @_builtins.property
    @pulumi.getter(name="bootType")
    def boot_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) Indicates whether the VM should use Secure boot, UEFI boot or Legacy boot.If UEFI or; Secure boot is enabled then other legacy boot options (like boot_device and; boot_device_order_list) are ignored. Secure boot depends on UEFI boot, i.e. enabling; Secure boot means that UEFI boot is also enabled. The possible value are: UEFI", "LEGACY", "SECURE_BOOT".
        """
        return pulumi.get(self, "boot_type")

    @boot_type.setter
    def boot_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "boot_type", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineCategoryArgs']]]]:
        """
        - (Optional) Categories for the vm.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineCategoryArgs']]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter(name="cloudInitCdromUuid")
    def cloud_init_cdrom_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cloud_init_cdrom_uuid")

    @cloud_init_cdrom_uuid.setter
    def cloud_init_cdrom_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_init_cdrom_uuid", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The name of the cluster.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="clusterUuid")
    def cluster_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) The UUID of the cluster.
        """
        return pulumi.get(self, "cluster_uuid")

    @cluster_uuid.setter
    def cluster_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_uuid", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) A description for vm.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskLists")
    def disk_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineDiskListArgs']]]]:
        """
        Disks attached to the VM.
        """
        return pulumi.get(self, "disk_lists")

    @disk_lists.setter
    def disk_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineDiskListArgs']]]]):
        pulumi.set(self, "disk_lists", value)

    @_builtins.property
    @pulumi.getter(name="enableCpuPassthrough")
    def enable_cpu_passthrough(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Add true to enable CPU passthrough.
        """
        return pulumi.get(self, "enable_cpu_passthrough")

    @enable_cpu_passthrough.setter
    def enable_cpu_passthrough(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_cpu_passthrough", value)

    @_builtins.property
    @pulumi.getter(name="enableScriptExec")
    def enable_script_exec(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Extra configs related to power state transition. Indicates whether to execute set script before ngt shutdown/reboot.
        """
        return pulumi.get(self, "enable_script_exec")

    @enable_script_exec.setter
    def enable_script_exec(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_script_exec", value)

    @_builtins.property
    @pulumi.getter(name="gpuLists")
    def gpu_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineGpuListArgs']]]]:
        """
        - (Optional) GPUs attached to the VM.
        """
        return pulumi.get(self, "gpu_lists")

    @gpu_lists.setter
    def gpu_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineGpuListArgs']]]]):
        pulumi.set(self, "gpu_lists", value)

    @_builtins.property
    @pulumi.getter(name="guestCustomizationCloudInitCustomKeyValues")
    def guest_customization_cloud_init_custom_key_values(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) Generic key value pair used for custom attributes in cloud init.
        """
        return pulumi.get(self, "guest_customization_cloud_init_custom_key_values")

    @guest_customization_cloud_init_custom_key_values.setter
    def guest_customization_cloud_init_custom_key_values(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "guest_customization_cloud_init_custom_key_values", value)

    @_builtins.property
    @pulumi.getter(name="guestCustomizationCloudInitMetaData")
    def guest_customization_cloud_init_meta_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The contents of the meta_data configuration for cloud-init. This can be formatted as YAML or JSON. The value must be base64 encoded.
        """
        return pulumi.get(self, "guest_customization_cloud_init_meta_data")

    @guest_customization_cloud_init_meta_data.setter
    def guest_customization_cloud_init_meta_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "guest_customization_cloud_init_meta_data", value)

    @_builtins.property
    @pulumi.getter(name="guestCustomizationCloudInitUserData")
    def guest_customization_cloud_init_user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The contents of the user_data configuration for cloud-init. This can be formatted as YAML, JSON, or could be a shell script. The value must be base64 encoded.
        """
        return pulumi.get(self, "guest_customization_cloud_init_user_data")

    @guest_customization_cloud_init_user_data.setter
    def guest_customization_cloud_init_user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "guest_customization_cloud_init_user_data", value)

    @_builtins.property
    @pulumi.getter(name="guestCustomizationIsOverridable")
    def guest_customization_is_overridable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Flag to allow override of customization by deployer.
        """
        return pulumi.get(self, "guest_customization_is_overridable")

    @guest_customization_is_overridable.setter
    def guest_customization_is_overridable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "guest_customization_is_overridable", value)

    @_builtins.property
    @pulumi.getter(name="guestCustomizationSysprep")
    def guest_customization_sysprep(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) VM guests may be customized at boot time using one of several different methods. Currently, cloud-init w/ ConfigDriveV2 (for Linux VMs) and Sysprep (for Windows VMs) are supported. Only ONE OF sysprep or cloud_init should be provided. Note that guest customization can currently only be set during VM creation. Attempting to change it after creation will result in an error. Additional properties can be specified. For example - in the context of VM template creation if \\"override_script\\" is set to \\"True\\" then the deployer can upload their own custom script.
        """
        return pulumi.get(self, "guest_customization_sysprep")

    @guest_customization_sysprep.setter
    def guest_customization_sysprep(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "guest_customization_sysprep", value)

    @_builtins.property
    @pulumi.getter(name="guestCustomizationSysprepCustomKeyValues")
    def guest_customization_sysprep_custom_key_values(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) Generic key value pair used for custom attributes in sysprep.
        """
        return pulumi.get(self, "guest_customization_sysprep_custom_key_values")

    @guest_customization_sysprep_custom_key_values.setter
    def guest_customization_sysprep_custom_key_values(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "guest_customization_sysprep_custom_key_values", value)

    @_builtins.property
    @pulumi.getter(name="guestOsId")
    def guest_os_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) Guest OS Identifier. For ESX, refer to VMware documentation [link](https://www.vmware.com/support/developer/converter-sdk/conv43_apireference/vim.vm.GuestOsDescriptor.GuestOsIdentifier.html) for the list of guest OS identifiers.
        """
        return pulumi.get(self, "guest_os_id")

    @guest_os_id.setter
    def guest_os_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "guest_os_id", value)

    @_builtins.property
    @pulumi.getter(name="hardwareClockTimezone")
    def hardware_clock_timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) VM's hardware clock timezone in IANA TZDB format (America/Los_Angeles).
        """
        return pulumi.get(self, "hardware_clock_timezone")

    @hardware_clock_timezone.setter
    def hardware_clock_timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hardware_clock_timezone", value)

    @_builtins.property
    @pulumi.getter(name="hostReference")
    def host_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - Reference to a host.
        """
        return pulumi.get(self, "host_reference")

    @host_reference.setter
    def host_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "host_reference", value)

    @_builtins.property
    @pulumi.getter(name="hypervisorType")
    def hypervisor_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The hypervisor type for the hypervisor the VM is hosted on.
        """
        return pulumi.get(self, "hypervisor_type")

    @hypervisor_type.setter
    def hypervisor_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hypervisor_type", value)

    @_builtins.property
    @pulumi.getter(name="isVcpuHardPinned")
    def is_vcpu_hard_pinned(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Add true to enable CPU pinning.
        """
        return pulumi.get(self, "is_vcpu_hard_pinned")

    @is_vcpu_hard_pinned.setter
    def is_vcpu_hard_pinned(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_vcpu_hard_pinned", value)

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Machine type for the VM. Machine type Q35 is required for secure boot and does not support IDE disks.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "machine_type", value)

    @_builtins.property
    @pulumi.getter(name="memorySizeMib")
    def memory_size_mib(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - (Optional) Memory size in MiB. On updating memory to powered ON VMs should only be done in 1GB increments.
        """
        return pulumi.get(self, "memory_size_mib")

    @memory_size_mib.setter
    def memory_size_mib(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_size_mib", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - The vm kind metadata.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) The name for the vm.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ngtCredentials")
    def ngt_credentials(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Ooptional) Credentials to login server.
        """
        return pulumi.get(self, "ngt_credentials")

    @ngt_credentials.setter
    def ngt_credentials(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ngt_credentials", value)

    @_builtins.property
    @pulumi.getter(name="ngtEnabledCapabilityLists")
    def ngt_enabled_capability_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Application names that are enabled.
        """
        return pulumi.get(self, "ngt_enabled_capability_lists")

    @ngt_enabled_capability_lists.setter
    def ngt_enabled_capability_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ngt_enabled_capability_lists", value)

    @_builtins.property
    @pulumi.getter(name="nicListStatuses")
    def nic_list_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineNicListStatusArgs']]]]:
        """
        - Status NICs attached to the VM.
        """
        return pulumi.get(self, "nic_list_statuses")

    @nic_list_statuses.setter
    def nic_list_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineNicListStatusArgs']]]]):
        pulumi.set(self, "nic_list_statuses", value)

    @_builtins.property
    @pulumi.getter(name="nicLists")
    def nic_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineNicListArgs']]]]:
        """
        - (Optional) Spec NICs attached to the VM.
        """
        return pulumi.get(self, "nic_lists")

    @nic_lists.setter
    def nic_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineNicListArgs']]]]):
        pulumi.set(self, "nic_lists", value)

    @_builtins.property
    @pulumi.getter(name="numSockets")
    def num_sockets(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - (Optional) Number of vCPU sockets.
        """
        return pulumi.get(self, "num_sockets")

    @num_sockets.setter
    def num_sockets(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_sockets", value)

    @_builtins.property
    @pulumi.getter(name="numVcpusPerSocket")
    def num_vcpus_per_socket(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - (Optional) Number of vCPUs per socket.
        """
        return pulumi.get(self, "num_vcpus_per_socket")

    @num_vcpus_per_socket.setter
    def num_vcpus_per_socket(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_vcpus_per_socket", value)

    @_builtins.property
    @pulumi.getter(name="numVnumaNodes")
    def num_vnuma_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - (Optional) Number of vNUMA nodes. 0 means vNUMA is disabled.
        """
        return pulumi.get(self, "num_vnuma_nodes")

    @num_vnuma_nodes.setter
    def num_vnuma_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_vnuma_nodes", value)

    @_builtins.property
    @pulumi.getter(name="nutanixGuestTools")
    def nutanix_guest_tools(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) Information regarding Nutanix Guest Tools.
        """
        return pulumi.get(self, "nutanix_guest_tools")

    @nutanix_guest_tools.setter
    def nutanix_guest_tools(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "nutanix_guest_tools", value)

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The reference to a user.
        """
        return pulumi.get(self, "owner_reference")

    @owner_reference.setter
    def owner_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "owner_reference", value)

    @_builtins.property
    @pulumi.getter(name="parentReference")
    def parent_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) Reference to an entity that the VM cloned from.
        """
        return pulumi.get(self, "parent_reference")

    @parent_reference.setter
    def parent_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parent_reference", value)

    @_builtins.property
    @pulumi.getter(name="powerState")
    def power_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The current or desired power state of the VM. (Options : ON , OFF)
        """
        return pulumi.get(self, "power_state")

    @power_state.setter
    def power_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "power_state", value)

    @_builtins.property
    @pulumi.getter(name="powerStateMechanism")
    def power_state_mechanism(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) Indicates the mechanism guiding the VM power state transition. Currently used for the transition to \\"OFF\\" state. Power state mechanism (ACPI/GUEST/HARD).
        """
        return pulumi.get(self, "power_state_mechanism")

    @power_state_mechanism.setter
    def power_state_mechanism(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "power_state_mechanism", value)

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The reference to a project.
        """
        return pulumi.get(self, "project_reference")

    @project_reference.setter
    def project_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "project_reference", value)

    @_builtins.property
    @pulumi.getter(name="serialPortLists")
    def serial_port_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineSerialPortListArgs']]]]:
        """
        - (Optional) Serial Ports configured on the VM.
        """
        return pulumi.get(self, "serial_port_lists")

    @serial_port_lists.setter
    def serial_port_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineSerialPortListArgs']]]]):
        pulumi.set(self, "serial_port_lists", value)

    @_builtins.property
    @pulumi.getter(name="shouldFailOnScriptFailure")
    def should_fail_on_script_failure(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional)  Extra configs related to power state transition. Indicates whether to abort ngt shutdown/reboot if script fails.
        """
        return pulumi.get(self, "should_fail_on_script_failure")

    @should_fail_on_script_failure.setter
    def should_fail_on_script_failure(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "should_fail_on_script_failure", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The state of the vm.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="useHotAdd")
    def use_hot_add(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Use Hot Add when modifying VM resources. Passing value false will result in VM reboots. Default value is `true`.
        """
        return pulumi.get(self, "use_hot_add")

    @use_hot_add.setter
    def use_hot_add(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_hot_add", value)

    @_builtins.property
    @pulumi.getter(name="vgaConsoleEnabled")
    def vga_console_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Indicates whether VGA console should be enabled or not.
        """
        return pulumi.get(self, "vga_console_enabled")

    @vga_console_enabled.setter
    def vga_console_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "vga_console_enabled", value)


@pulumi.type_token("nutanix:index/virtualMachine:VirtualMachine")
class VirtualMachine(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 boot_device_disk_address: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 boot_device_mac_address: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_device_order_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 boot_type: Optional[pulumi.Input[_builtins.str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineCategoryArgs', 'VirtualMachineCategoryArgsDict']]]]] = None,
                 cloud_init_cdrom_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineDiskListArgs', 'VirtualMachineDiskListArgsDict']]]]] = None,
                 enable_cpu_passthrough: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_script_exec: Optional[pulumi.Input[_builtins.bool]] = None,
                 gpu_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineGpuListArgs', 'VirtualMachineGpuListArgsDict']]]]] = None,
                 guest_customization_cloud_init_custom_key_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 guest_customization_cloud_init_meta_data: Optional[pulumi.Input[_builtins.str]] = None,
                 guest_customization_cloud_init_user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 guest_customization_is_overridable: Optional[pulumi.Input[_builtins.bool]] = None,
                 guest_customization_sysprep: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 guest_customization_sysprep_custom_key_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 guest_os_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hardware_clock_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 is_vcpu_hard_pinned: Optional[pulumi.Input[_builtins.bool]] = None,
                 machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_size_mib: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ngt_credentials: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ngt_enabled_capability_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 nic_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineNicListArgs', 'VirtualMachineNicListArgsDict']]]]] = None,
                 num_sockets: Optional[pulumi.Input[_builtins.int]] = None,
                 num_vcpus_per_socket: Optional[pulumi.Input[_builtins.int]] = None,
                 num_vnuma_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 nutanix_guest_tools: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 parent_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 power_state: Optional[pulumi.Input[_builtins.str]] = None,
                 power_state_mechanism: Optional[pulumi.Input[_builtins.str]] = None,
                 project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 serial_port_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineSerialPortListArgs', 'VirtualMachineSerialPortListArgsDict']]]]] = None,
                 should_fail_on_script_failure: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_hot_add: Optional[pulumi.Input[_builtins.bool]] = None,
                 vga_console_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Provides a Nutanix Virtual Machine resource to Create a virtual machine.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        clusters = nutanix.get_clusters()
        vm1 = nutanix.VirtualMachine("vm1",
            name="test-dou",
            cluster_uuid=clusters.entities[0].metadata["uuid"],
            categories=[{
                "name": "Environment",
                "value": "Staging",
            }],
            num_vcpus_per_socket=1,
            num_sockets=1,
            memory_size_mib=2048)
        ```

        ### With Storage Config
        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        clusters = nutanix.get_clusters()
        vm = nutanix.VirtualMachine("vm",
            name="myVm",
            cluster_uuid=clusters.entities[0].metadata["uuid"],
            num_vcpus_per_socket=1,
            num_sockets=1,
            memory_size_mib=186,
            disk_lists=[{
                "disk_size_bytes": 68157440,
                "disk_size_mib": 65,
                "storage_config": {
                    "storage_container_references": [{
                        "kind": "storage_container",
                        "uuid": "2bbe67bc-fd14-4637-8de1-6379257f4219",
                    }],
                },
            }])
        ```

        ## Import

        Nutanix Virtual machines can be imported using the `UUID` eg,

        `

        ```sh
        $ pulumi import nutanix:index/virtualMachine:VirtualMachine vm01 0F75E6A7-55FB-44D9-A50D-14AD72E2CF7C
        ```

        `

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] availability_zone_reference: - (Optional) The reference to a availability_zone.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] boot_device_disk_address: - (Optional) Address of disk to boot from.
        :param pulumi.Input[_builtins.str] boot_device_mac_address: - (Optional) MAC address of nic to boot from.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] boot_device_order_lists: - (Optional) Indicates the order of device types in which VM should try to boot from. If boot device order is not provided the system will decide appropriate boot device order.
        :param pulumi.Input[_builtins.str] boot_type: - (Optional) Indicates whether the VM should use Secure boot, UEFI boot or Legacy boot.If UEFI or; Secure boot is enabled then other legacy boot options (like boot_device and; boot_device_order_list) are ignored. Secure boot depends on UEFI boot, i.e. enabling; Secure boot means that UEFI boot is also enabled. The possible value are: UEFI", "LEGACY", "SECURE_BOOT".
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineCategoryArgs', 'VirtualMachineCategoryArgsDict']]]] categories: - (Optional) Categories for the vm.
        :param pulumi.Input[_builtins.str] cluster_uuid: - (Required) The UUID of the cluster.
        :param pulumi.Input[_builtins.str] description: - (Optional) A description for vm.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineDiskListArgs', 'VirtualMachineDiskListArgsDict']]]] disk_lists: Disks attached to the VM.
        :param pulumi.Input[_builtins.bool] enable_cpu_passthrough: - (Optional) Add true to enable CPU passthrough.
        :param pulumi.Input[_builtins.bool] enable_script_exec: - (Optional) Extra configs related to power state transition. Indicates whether to execute set script before ngt shutdown/reboot.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineGpuListArgs', 'VirtualMachineGpuListArgsDict']]]] gpu_lists: - (Optional) GPUs attached to the VM.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] guest_customization_cloud_init_custom_key_values: - (Optional) Generic key value pair used for custom attributes in cloud init.
        :param pulumi.Input[_builtins.str] guest_customization_cloud_init_meta_data: The contents of the meta_data configuration for cloud-init. This can be formatted as YAML or JSON. The value must be base64 encoded.
        :param pulumi.Input[_builtins.str] guest_customization_cloud_init_user_data: - (Optional) The contents of the user_data configuration for cloud-init. This can be formatted as YAML, JSON, or could be a shell script. The value must be base64 encoded.
        :param pulumi.Input[_builtins.bool] guest_customization_is_overridable: - (Optional) Flag to allow override of customization by deployer.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] guest_customization_sysprep: - (Optional) VM guests may be customized at boot time using one of several different methods. Currently, cloud-init w/ ConfigDriveV2 (for Linux VMs) and Sysprep (for Windows VMs) are supported. Only ONE OF sysprep or cloud_init should be provided. Note that guest customization can currently only be set during VM creation. Attempting to change it after creation will result in an error. Additional properties can be specified. For example - in the context of VM template creation if \\"override_script\\" is set to \\"True\\" then the deployer can upload their own custom script.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] guest_customization_sysprep_custom_key_values: - (Optional) Generic key value pair used for custom attributes in sysprep.
        :param pulumi.Input[_builtins.str] guest_os_id: - (Optional) Guest OS Identifier. For ESX, refer to VMware documentation [link](https://www.vmware.com/support/developer/converter-sdk/conv43_apireference/vim.vm.GuestOsDescriptor.GuestOsIdentifier.html) for the list of guest OS identifiers.
        :param pulumi.Input[_builtins.str] hardware_clock_timezone: - (Optional) VM's hardware clock timezone in IANA TZDB format (America/Los_Angeles).
        :param pulumi.Input[_builtins.bool] is_vcpu_hard_pinned: - (Optional) Add true to enable CPU pinning.
        :param pulumi.Input[_builtins.str] machine_type: - Machine type for the VM. Machine type Q35 is required for secure boot and does not support IDE disks.
        :param pulumi.Input[_builtins.int] memory_size_mib: - (Optional) Memory size in MiB. On updating memory to powered ON VMs should only be done in 1GB increments.
        :param pulumi.Input[_builtins.str] name: - (Required) The name for the vm.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] ngt_credentials: - (Ooptional) Credentials to login server.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ngt_enabled_capability_lists: Application names that are enabled.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineNicListArgs', 'VirtualMachineNicListArgsDict']]]] nic_lists: - (Optional) Spec NICs attached to the VM.
        :param pulumi.Input[_builtins.int] num_sockets: - (Optional) Number of vCPU sockets.
        :param pulumi.Input[_builtins.int] num_vcpus_per_socket: - (Optional) Number of vCPUs per socket.
        :param pulumi.Input[_builtins.int] num_vnuma_nodes: - (Optional) Number of vNUMA nodes. 0 means vNUMA is disabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] nutanix_guest_tools: - (Optional) Information regarding Nutanix Guest Tools.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] owner_reference: - (Optional) The reference to a user.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parent_reference: - (Optional) Reference to an entity that the VM cloned from.
        :param pulumi.Input[_builtins.str] power_state: - (Optional) The current or desired power state of the VM. (Options : ON , OFF)
        :param pulumi.Input[_builtins.str] power_state_mechanism: - (Optional) Indicates the mechanism guiding the VM power state transition. Currently used for the transition to \\"OFF\\" state. Power state mechanism (ACPI/GUEST/HARD).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] project_reference: - (Optional) The reference to a project.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineSerialPortListArgs', 'VirtualMachineSerialPortListArgsDict']]]] serial_port_lists: - (Optional) Serial Ports configured on the VM.
        :param pulumi.Input[_builtins.bool] should_fail_on_script_failure: - (Optional)  Extra configs related to power state transition. Indicates whether to abort ngt shutdown/reboot if script fails.
        :param pulumi.Input[_builtins.bool] use_hot_add: - (Optional) Use Hot Add when modifying VM resources. Passing value false will result in VM reboots. Default value is `true`.
        :param pulumi.Input[_builtins.bool] vga_console_enabled: - (Optional) Indicates whether VGA console should be enabled or not.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualMachineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Nutanix Virtual Machine resource to Create a virtual machine.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        clusters = nutanix.get_clusters()
        vm1 = nutanix.VirtualMachine("vm1",
            name="test-dou",
            cluster_uuid=clusters.entities[0].metadata["uuid"],
            categories=[{
                "name": "Environment",
                "value": "Staging",
            }],
            num_vcpus_per_socket=1,
            num_sockets=1,
            memory_size_mib=2048)
        ```

        ### With Storage Config
        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        clusters = nutanix.get_clusters()
        vm = nutanix.VirtualMachine("vm",
            name="myVm",
            cluster_uuid=clusters.entities[0].metadata["uuid"],
            num_vcpus_per_socket=1,
            num_sockets=1,
            memory_size_mib=186,
            disk_lists=[{
                "disk_size_bytes": 68157440,
                "disk_size_mib": 65,
                "storage_config": {
                    "storage_container_references": [{
                        "kind": "storage_container",
                        "uuid": "2bbe67bc-fd14-4637-8de1-6379257f4219",
                    }],
                },
            }])
        ```

        ## Import

        Nutanix Virtual machines can be imported using the `UUID` eg,

        `

        ```sh
        $ pulumi import nutanix:index/virtualMachine:VirtualMachine vm01 0F75E6A7-55FB-44D9-A50D-14AD72E2CF7C
        ```

        `

        :param str resource_name: The name of the resource.
        :param VirtualMachineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualMachineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 boot_device_disk_address: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 boot_device_mac_address: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_device_order_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 boot_type: Optional[pulumi.Input[_builtins.str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineCategoryArgs', 'VirtualMachineCategoryArgsDict']]]]] = None,
                 cloud_init_cdrom_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineDiskListArgs', 'VirtualMachineDiskListArgsDict']]]]] = None,
                 enable_cpu_passthrough: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_script_exec: Optional[pulumi.Input[_builtins.bool]] = None,
                 gpu_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineGpuListArgs', 'VirtualMachineGpuListArgsDict']]]]] = None,
                 guest_customization_cloud_init_custom_key_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 guest_customization_cloud_init_meta_data: Optional[pulumi.Input[_builtins.str]] = None,
                 guest_customization_cloud_init_user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 guest_customization_is_overridable: Optional[pulumi.Input[_builtins.bool]] = None,
                 guest_customization_sysprep: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 guest_customization_sysprep_custom_key_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 guest_os_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hardware_clock_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 is_vcpu_hard_pinned: Optional[pulumi.Input[_builtins.bool]] = None,
                 machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_size_mib: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ngt_credentials: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ngt_enabled_capability_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 nic_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineNicListArgs', 'VirtualMachineNicListArgsDict']]]]] = None,
                 num_sockets: Optional[pulumi.Input[_builtins.int]] = None,
                 num_vcpus_per_socket: Optional[pulumi.Input[_builtins.int]] = None,
                 num_vnuma_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 nutanix_guest_tools: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 parent_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 power_state: Optional[pulumi.Input[_builtins.str]] = None,
                 power_state_mechanism: Optional[pulumi.Input[_builtins.str]] = None,
                 project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 serial_port_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineSerialPortListArgs', 'VirtualMachineSerialPortListArgsDict']]]]] = None,
                 should_fail_on_script_failure: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_hot_add: Optional[pulumi.Input[_builtins.bool]] = None,
                 vga_console_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualMachineArgs.__new__(VirtualMachineArgs)

            __props__.__dict__["availability_zone_reference"] = availability_zone_reference
            __props__.__dict__["boot_device_disk_address"] = boot_device_disk_address
            __props__.__dict__["boot_device_mac_address"] = boot_device_mac_address
            __props__.__dict__["boot_device_order_lists"] = boot_device_order_lists
            __props__.__dict__["boot_type"] = boot_type
            __props__.__dict__["categories"] = categories
            __props__.__dict__["cloud_init_cdrom_uuid"] = cloud_init_cdrom_uuid
            if cluster_uuid is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_uuid'")
            __props__.__dict__["cluster_uuid"] = cluster_uuid
            __props__.__dict__["description"] = description
            __props__.__dict__["disk_lists"] = disk_lists
            __props__.__dict__["enable_cpu_passthrough"] = enable_cpu_passthrough
            __props__.__dict__["enable_script_exec"] = enable_script_exec
            __props__.__dict__["gpu_lists"] = gpu_lists
            __props__.__dict__["guest_customization_cloud_init_custom_key_values"] = guest_customization_cloud_init_custom_key_values
            __props__.__dict__["guest_customization_cloud_init_meta_data"] = guest_customization_cloud_init_meta_data
            __props__.__dict__["guest_customization_cloud_init_user_data"] = guest_customization_cloud_init_user_data
            __props__.__dict__["guest_customization_is_overridable"] = guest_customization_is_overridable
            __props__.__dict__["guest_customization_sysprep"] = guest_customization_sysprep
            __props__.__dict__["guest_customization_sysprep_custom_key_values"] = guest_customization_sysprep_custom_key_values
            __props__.__dict__["guest_os_id"] = guest_os_id
            __props__.__dict__["hardware_clock_timezone"] = hardware_clock_timezone
            __props__.__dict__["is_vcpu_hard_pinned"] = is_vcpu_hard_pinned
            __props__.__dict__["machine_type"] = machine_type
            __props__.__dict__["memory_size_mib"] = memory_size_mib
            __props__.__dict__["name"] = name
            __props__.__dict__["ngt_credentials"] = ngt_credentials
            __props__.__dict__["ngt_enabled_capability_lists"] = ngt_enabled_capability_lists
            __props__.__dict__["nic_lists"] = nic_lists
            __props__.__dict__["num_sockets"] = num_sockets
            __props__.__dict__["num_vcpus_per_socket"] = num_vcpus_per_socket
            __props__.__dict__["num_vnuma_nodes"] = num_vnuma_nodes
            __props__.__dict__["nutanix_guest_tools"] = nutanix_guest_tools
            __props__.__dict__["owner_reference"] = owner_reference
            __props__.__dict__["parent_reference"] = parent_reference
            __props__.__dict__["power_state"] = power_state
            __props__.__dict__["power_state_mechanism"] = power_state_mechanism
            __props__.__dict__["project_reference"] = project_reference
            __props__.__dict__["serial_port_lists"] = serial_port_lists
            __props__.__dict__["should_fail_on_script_failure"] = should_fail_on_script_failure
            __props__.__dict__["use_hot_add"] = use_hot_add
            __props__.__dict__["vga_console_enabled"] = vga_console_enabled
            __props__.__dict__["api_version"] = None
            __props__.__dict__["cluster_name"] = None
            __props__.__dict__["host_reference"] = None
            __props__.__dict__["hypervisor_type"] = None
            __props__.__dict__["metadata"] = None
            __props__.__dict__["nic_list_statuses"] = None
            __props__.__dict__["state"] = None
        super(VirtualMachine, __self__).__init__(
            'nutanix:index/virtualMachine:VirtualMachine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_version: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zone_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            boot_device_disk_address: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            boot_device_mac_address: Optional[pulumi.Input[_builtins.str]] = None,
            boot_device_order_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            boot_type: Optional[pulumi.Input[_builtins.str]] = None,
            categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineCategoryArgs', 'VirtualMachineCategoryArgsDict']]]]] = None,
            cloud_init_cdrom_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disk_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineDiskListArgs', 'VirtualMachineDiskListArgsDict']]]]] = None,
            enable_cpu_passthrough: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_script_exec: Optional[pulumi.Input[_builtins.bool]] = None,
            gpu_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineGpuListArgs', 'VirtualMachineGpuListArgsDict']]]]] = None,
            guest_customization_cloud_init_custom_key_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            guest_customization_cloud_init_meta_data: Optional[pulumi.Input[_builtins.str]] = None,
            guest_customization_cloud_init_user_data: Optional[pulumi.Input[_builtins.str]] = None,
            guest_customization_is_overridable: Optional[pulumi.Input[_builtins.bool]] = None,
            guest_customization_sysprep: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            guest_customization_sysprep_custom_key_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            guest_os_id: Optional[pulumi.Input[_builtins.str]] = None,
            hardware_clock_timezone: Optional[pulumi.Input[_builtins.str]] = None,
            host_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            hypervisor_type: Optional[pulumi.Input[_builtins.str]] = None,
            is_vcpu_hard_pinned: Optional[pulumi.Input[_builtins.bool]] = None,
            machine_type: Optional[pulumi.Input[_builtins.str]] = None,
            memory_size_mib: Optional[pulumi.Input[_builtins.int]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ngt_credentials: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            ngt_enabled_capability_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            nic_list_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineNicListStatusArgs', 'VirtualMachineNicListStatusArgsDict']]]]] = None,
            nic_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineNicListArgs', 'VirtualMachineNicListArgsDict']]]]] = None,
            num_sockets: Optional[pulumi.Input[_builtins.int]] = None,
            num_vcpus_per_socket: Optional[pulumi.Input[_builtins.int]] = None,
            num_vnuma_nodes: Optional[pulumi.Input[_builtins.int]] = None,
            nutanix_guest_tools: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            parent_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            power_state: Optional[pulumi.Input[_builtins.str]] = None,
            power_state_mechanism: Optional[pulumi.Input[_builtins.str]] = None,
            project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            serial_port_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineSerialPortListArgs', 'VirtualMachineSerialPortListArgsDict']]]]] = None,
            should_fail_on_script_failure: Optional[pulumi.Input[_builtins.bool]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            use_hot_add: Optional[pulumi.Input[_builtins.bool]] = None,
            vga_console_enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'VirtualMachine':
        """
        Get an existing VirtualMachine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_version: The version of the API.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] availability_zone_reference: - (Optional) The reference to a availability_zone.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] boot_device_disk_address: - (Optional) Address of disk to boot from.
        :param pulumi.Input[_builtins.str] boot_device_mac_address: - (Optional) MAC address of nic to boot from.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] boot_device_order_lists: - (Optional) Indicates the order of device types in which VM should try to boot from. If boot device order is not provided the system will decide appropriate boot device order.
        :param pulumi.Input[_builtins.str] boot_type: - (Optional) Indicates whether the VM should use Secure boot, UEFI boot or Legacy boot.If UEFI or; Secure boot is enabled then other legacy boot options (like boot_device and; boot_device_order_list) are ignored. Secure boot depends on UEFI boot, i.e. enabling; Secure boot means that UEFI boot is also enabled. The possible value are: UEFI", "LEGACY", "SECURE_BOOT".
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineCategoryArgs', 'VirtualMachineCategoryArgsDict']]]] categories: - (Optional) Categories for the vm.
        :param pulumi.Input[_builtins.str] cluster_name: - The name of the cluster.
        :param pulumi.Input[_builtins.str] cluster_uuid: - (Required) The UUID of the cluster.
        :param pulumi.Input[_builtins.str] description: - (Optional) A description for vm.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineDiskListArgs', 'VirtualMachineDiskListArgsDict']]]] disk_lists: Disks attached to the VM.
        :param pulumi.Input[_builtins.bool] enable_cpu_passthrough: - (Optional) Add true to enable CPU passthrough.
        :param pulumi.Input[_builtins.bool] enable_script_exec: - (Optional) Extra configs related to power state transition. Indicates whether to execute set script before ngt shutdown/reboot.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineGpuListArgs', 'VirtualMachineGpuListArgsDict']]]] gpu_lists: - (Optional) GPUs attached to the VM.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] guest_customization_cloud_init_custom_key_values: - (Optional) Generic key value pair used for custom attributes in cloud init.
        :param pulumi.Input[_builtins.str] guest_customization_cloud_init_meta_data: The contents of the meta_data configuration for cloud-init. This can be formatted as YAML or JSON. The value must be base64 encoded.
        :param pulumi.Input[_builtins.str] guest_customization_cloud_init_user_data: - (Optional) The contents of the user_data configuration for cloud-init. This can be formatted as YAML, JSON, or could be a shell script. The value must be base64 encoded.
        :param pulumi.Input[_builtins.bool] guest_customization_is_overridable: - (Optional) Flag to allow override of customization by deployer.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] guest_customization_sysprep: - (Optional) VM guests may be customized at boot time using one of several different methods. Currently, cloud-init w/ ConfigDriveV2 (for Linux VMs) and Sysprep (for Windows VMs) are supported. Only ONE OF sysprep or cloud_init should be provided. Note that guest customization can currently only be set during VM creation. Attempting to change it after creation will result in an error. Additional properties can be specified. For example - in the context of VM template creation if \\"override_script\\" is set to \\"True\\" then the deployer can upload their own custom script.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] guest_customization_sysprep_custom_key_values: - (Optional) Generic key value pair used for custom attributes in sysprep.
        :param pulumi.Input[_builtins.str] guest_os_id: - (Optional) Guest OS Identifier. For ESX, refer to VMware documentation [link](https://www.vmware.com/support/developer/converter-sdk/conv43_apireference/vim.vm.GuestOsDescriptor.GuestOsIdentifier.html) for the list of guest OS identifiers.
        :param pulumi.Input[_builtins.str] hardware_clock_timezone: - (Optional) VM's hardware clock timezone in IANA TZDB format (America/Los_Angeles).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] host_reference: - Reference to a host.
        :param pulumi.Input[_builtins.str] hypervisor_type: - The hypervisor type for the hypervisor the VM is hosted on.
        :param pulumi.Input[_builtins.bool] is_vcpu_hard_pinned: - (Optional) Add true to enable CPU pinning.
        :param pulumi.Input[_builtins.str] machine_type: - Machine type for the VM. Machine type Q35 is required for secure boot and does not support IDE disks.
        :param pulumi.Input[_builtins.int] memory_size_mib: - (Optional) Memory size in MiB. On updating memory to powered ON VMs should only be done in 1GB increments.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: - The vm kind metadata.
        :param pulumi.Input[_builtins.str] name: - (Required) The name for the vm.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] ngt_credentials: - (Ooptional) Credentials to login server.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ngt_enabled_capability_lists: Application names that are enabled.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineNicListStatusArgs', 'VirtualMachineNicListStatusArgsDict']]]] nic_list_statuses: - Status NICs attached to the VM.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineNicListArgs', 'VirtualMachineNicListArgsDict']]]] nic_lists: - (Optional) Spec NICs attached to the VM.
        :param pulumi.Input[_builtins.int] num_sockets: - (Optional) Number of vCPU sockets.
        :param pulumi.Input[_builtins.int] num_vcpus_per_socket: - (Optional) Number of vCPUs per socket.
        :param pulumi.Input[_builtins.int] num_vnuma_nodes: - (Optional) Number of vNUMA nodes. 0 means vNUMA is disabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] nutanix_guest_tools: - (Optional) Information regarding Nutanix Guest Tools.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] owner_reference: - (Optional) The reference to a user.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parent_reference: - (Optional) Reference to an entity that the VM cloned from.
        :param pulumi.Input[_builtins.str] power_state: - (Optional) The current or desired power state of the VM. (Options : ON , OFF)
        :param pulumi.Input[_builtins.str] power_state_mechanism: - (Optional) Indicates the mechanism guiding the VM power state transition. Currently used for the transition to \\"OFF\\" state. Power state mechanism (ACPI/GUEST/HARD).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] project_reference: - (Optional) The reference to a project.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineSerialPortListArgs', 'VirtualMachineSerialPortListArgsDict']]]] serial_port_lists: - (Optional) Serial Ports configured on the VM.
        :param pulumi.Input[_builtins.bool] should_fail_on_script_failure: - (Optional)  Extra configs related to power state transition. Indicates whether to abort ngt shutdown/reboot if script fails.
        :param pulumi.Input[_builtins.str] state: - The state of the vm.
        :param pulumi.Input[_builtins.bool] use_hot_add: - (Optional) Use Hot Add when modifying VM resources. Passing value false will result in VM reboots. Default value is `true`.
        :param pulumi.Input[_builtins.bool] vga_console_enabled: - (Optional) Indicates whether VGA console should be enabled or not.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualMachineState.__new__(_VirtualMachineState)

        __props__.__dict__["api_version"] = api_version
        __props__.__dict__["availability_zone_reference"] = availability_zone_reference
        __props__.__dict__["boot_device_disk_address"] = boot_device_disk_address
        __props__.__dict__["boot_device_mac_address"] = boot_device_mac_address
        __props__.__dict__["boot_device_order_lists"] = boot_device_order_lists
        __props__.__dict__["boot_type"] = boot_type
        __props__.__dict__["categories"] = categories
        __props__.__dict__["cloud_init_cdrom_uuid"] = cloud_init_cdrom_uuid
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["cluster_uuid"] = cluster_uuid
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_lists"] = disk_lists
        __props__.__dict__["enable_cpu_passthrough"] = enable_cpu_passthrough
        __props__.__dict__["enable_script_exec"] = enable_script_exec
        __props__.__dict__["gpu_lists"] = gpu_lists
        __props__.__dict__["guest_customization_cloud_init_custom_key_values"] = guest_customization_cloud_init_custom_key_values
        __props__.__dict__["guest_customization_cloud_init_meta_data"] = guest_customization_cloud_init_meta_data
        __props__.__dict__["guest_customization_cloud_init_user_data"] = guest_customization_cloud_init_user_data
        __props__.__dict__["guest_customization_is_overridable"] = guest_customization_is_overridable
        __props__.__dict__["guest_customization_sysprep"] = guest_customization_sysprep
        __props__.__dict__["guest_customization_sysprep_custom_key_values"] = guest_customization_sysprep_custom_key_values
        __props__.__dict__["guest_os_id"] = guest_os_id
        __props__.__dict__["hardware_clock_timezone"] = hardware_clock_timezone
        __props__.__dict__["host_reference"] = host_reference
        __props__.__dict__["hypervisor_type"] = hypervisor_type
        __props__.__dict__["is_vcpu_hard_pinned"] = is_vcpu_hard_pinned
        __props__.__dict__["machine_type"] = machine_type
        __props__.__dict__["memory_size_mib"] = memory_size_mib
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["ngt_credentials"] = ngt_credentials
        __props__.__dict__["ngt_enabled_capability_lists"] = ngt_enabled_capability_lists
        __props__.__dict__["nic_list_statuses"] = nic_list_statuses
        __props__.__dict__["nic_lists"] = nic_lists
        __props__.__dict__["num_sockets"] = num_sockets
        __props__.__dict__["num_vcpus_per_socket"] = num_vcpus_per_socket
        __props__.__dict__["num_vnuma_nodes"] = num_vnuma_nodes
        __props__.__dict__["nutanix_guest_tools"] = nutanix_guest_tools
        __props__.__dict__["owner_reference"] = owner_reference
        __props__.__dict__["parent_reference"] = parent_reference
        __props__.__dict__["power_state"] = power_state
        __props__.__dict__["power_state_mechanism"] = power_state_mechanism
        __props__.__dict__["project_reference"] = project_reference
        __props__.__dict__["serial_port_lists"] = serial_port_lists
        __props__.__dict__["should_fail_on_script_failure"] = should_fail_on_script_failure
        __props__.__dict__["state"] = state
        __props__.__dict__["use_hot_add"] = use_hot_add
        __props__.__dict__["vga_console_enabled"] = vga_console_enabled
        return VirtualMachine(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the API.
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter(name="availabilityZoneReference")
    def availability_zone_reference(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - (Optional) The reference to a availability_zone.
        """
        return pulumi.get(self, "availability_zone_reference")

    @_builtins.property
    @pulumi.getter(name="bootDeviceDiskAddress")
    def boot_device_disk_address(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - (Optional) Address of disk to boot from.
        """
        return pulumi.get(self, "boot_device_disk_address")

    @_builtins.property
    @pulumi.getter(name="bootDeviceMacAddress")
    def boot_device_mac_address(self) -> pulumi.Output[_builtins.str]:
        """
        - (Optional) MAC address of nic to boot from.
        """
        return pulumi.get(self, "boot_device_mac_address")

    @_builtins.property
    @pulumi.getter(name="bootDeviceOrderLists")
    def boot_device_order_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        - (Optional) Indicates the order of device types in which VM should try to boot from. If boot device order is not provided the system will decide appropriate boot device order.
        """
        return pulumi.get(self, "boot_device_order_lists")

    @_builtins.property
    @pulumi.getter(name="bootType")
    def boot_type(self) -> pulumi.Output[_builtins.str]:
        """
        - (Optional) Indicates whether the VM should use Secure boot, UEFI boot or Legacy boot.If UEFI or; Secure boot is enabled then other legacy boot options (like boot_device and; boot_device_order_list) are ignored. Secure boot depends on UEFI boot, i.e. enabling; Secure boot means that UEFI boot is also enabled. The possible value are: UEFI", "LEGACY", "SECURE_BOOT".
        """
        return pulumi.get(self, "boot_type")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> pulumi.Output[Sequence['outputs.VirtualMachineCategory']]:
        """
        - (Optional) Categories for the vm.
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter(name="cloudInitCdromUuid")
    def cloud_init_cdrom_uuid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "cloud_init_cdrom_uuid")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        - The name of the cluster.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="clusterUuid")
    def cluster_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        - (Required) The UUID of the cluster.
        """
        return pulumi.get(self, "cluster_uuid")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        - (Optional) A description for vm.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="diskLists")
    def disk_lists(self) -> pulumi.Output[Sequence['outputs.VirtualMachineDiskList']]:
        """
        Disks attached to the VM.
        """
        return pulumi.get(self, "disk_lists")

    @_builtins.property
    @pulumi.getter(name="enableCpuPassthrough")
    def enable_cpu_passthrough(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) Add true to enable CPU passthrough.
        """
        return pulumi.get(self, "enable_cpu_passthrough")

    @_builtins.property
    @pulumi.getter(name="enableScriptExec")
    def enable_script_exec(self) -> pulumi.Output[_builtins.bool]:
        """
        - (Optional) Extra configs related to power state transition. Indicates whether to execute set script before ngt shutdown/reboot.
        """
        return pulumi.get(self, "enable_script_exec")

    @_builtins.property
    @pulumi.getter(name="gpuLists")
    def gpu_lists(self) -> pulumi.Output[Sequence['outputs.VirtualMachineGpuList']]:
        """
        - (Optional) GPUs attached to the VM.
        """
        return pulumi.get(self, "gpu_lists")

    @_builtins.property
    @pulumi.getter(name="guestCustomizationCloudInitCustomKeyValues")
    def guest_customization_cloud_init_custom_key_values(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - (Optional) Generic key value pair used for custom attributes in cloud init.
        """
        return pulumi.get(self, "guest_customization_cloud_init_custom_key_values")

    @_builtins.property
    @pulumi.getter(name="guestCustomizationCloudInitMetaData")
    def guest_customization_cloud_init_meta_data(self) -> pulumi.Output[_builtins.str]:
        """
        The contents of the meta_data configuration for cloud-init. This can be formatted as YAML or JSON. The value must be base64 encoded.
        """
        return pulumi.get(self, "guest_customization_cloud_init_meta_data")

    @_builtins.property
    @pulumi.getter(name="guestCustomizationCloudInitUserData")
    def guest_customization_cloud_init_user_data(self) -> pulumi.Output[_builtins.str]:
        """
        - (Optional) The contents of the user_data configuration for cloud-init. This can be formatted as YAML, JSON, or could be a shell script. The value must be base64 encoded.
        """
        return pulumi.get(self, "guest_customization_cloud_init_user_data")

    @_builtins.property
    @pulumi.getter(name="guestCustomizationIsOverridable")
    def guest_customization_is_overridable(self) -> pulumi.Output[_builtins.bool]:
        """
        - (Optional) Flag to allow override of customization by deployer.
        """
        return pulumi.get(self, "guest_customization_is_overridable")

    @_builtins.property
    @pulumi.getter(name="guestCustomizationSysprep")
    def guest_customization_sysprep(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - (Optional) VM guests may be customized at boot time using one of several different methods. Currently, cloud-init w/ ConfigDriveV2 (for Linux VMs) and Sysprep (for Windows VMs) are supported. Only ONE OF sysprep or cloud_init should be provided. Note that guest customization can currently only be set during VM creation. Attempting to change it after creation will result in an error. Additional properties can be specified. For example - in the context of VM template creation if \\"override_script\\" is set to \\"True\\" then the deployer can upload their own custom script.
        """
        return pulumi.get(self, "guest_customization_sysprep")

    @_builtins.property
    @pulumi.getter(name="guestCustomizationSysprepCustomKeyValues")
    def guest_customization_sysprep_custom_key_values(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - (Optional) Generic key value pair used for custom attributes in sysprep.
        """
        return pulumi.get(self, "guest_customization_sysprep_custom_key_values")

    @_builtins.property
    @pulumi.getter(name="guestOsId")
    def guest_os_id(self) -> pulumi.Output[_builtins.str]:
        """
        - (Optional) Guest OS Identifier. For ESX, refer to VMware documentation [link](https://www.vmware.com/support/developer/converter-sdk/conv43_apireference/vim.vm.GuestOsDescriptor.GuestOsIdentifier.html) for the list of guest OS identifiers.
        """
        return pulumi.get(self, "guest_os_id")

    @_builtins.property
    @pulumi.getter(name="hardwareClockTimezone")
    def hardware_clock_timezone(self) -> pulumi.Output[_builtins.str]:
        """
        - (Optional) VM's hardware clock timezone in IANA TZDB format (America/Los_Angeles).
        """
        return pulumi.get(self, "hardware_clock_timezone")

    @_builtins.property
    @pulumi.getter(name="hostReference")
    def host_reference(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - Reference to a host.
        """
        return pulumi.get(self, "host_reference")

    @_builtins.property
    @pulumi.getter(name="hypervisorType")
    def hypervisor_type(self) -> pulumi.Output[_builtins.str]:
        """
        - The hypervisor type for the hypervisor the VM is hosted on.
        """
        return pulumi.get(self, "hypervisor_type")

    @_builtins.property
    @pulumi.getter(name="isVcpuHardPinned")
    def is_vcpu_hard_pinned(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) Add true to enable CPU pinning.
        """
        return pulumi.get(self, "is_vcpu_hard_pinned")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> pulumi.Output[_builtins.str]:
        """
        - Machine type for the VM. Machine type Q35 is required for secure boot and does not support IDE disks.
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter(name="memorySizeMib")
    def memory_size_mib(self) -> pulumi.Output[_builtins.int]:
        """
        - (Optional) Memory size in MiB. On updating memory to powered ON VMs should only be done in 1GB increments.
        """
        return pulumi.get(self, "memory_size_mib")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - The vm kind metadata.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        - (Required) The name for the vm.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ngtCredentials")
    def ngt_credentials(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - (Ooptional) Credentials to login server.
        """
        return pulumi.get(self, "ngt_credentials")

    @_builtins.property
    @pulumi.getter(name="ngtEnabledCapabilityLists")
    def ngt_enabled_capability_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Application names that are enabled.
        """
        return pulumi.get(self, "ngt_enabled_capability_lists")

    @_builtins.property
    @pulumi.getter(name="nicListStatuses")
    def nic_list_statuses(self) -> pulumi.Output[Sequence['outputs.VirtualMachineNicListStatus']]:
        """
        - Status NICs attached to the VM.
        """
        return pulumi.get(self, "nic_list_statuses")

    @_builtins.property
    @pulumi.getter(name="nicLists")
    def nic_lists(self) -> pulumi.Output[Sequence['outputs.VirtualMachineNicList']]:
        """
        - (Optional) Spec NICs attached to the VM.
        """
        return pulumi.get(self, "nic_lists")

    @_builtins.property
    @pulumi.getter(name="numSockets")
    def num_sockets(self) -> pulumi.Output[_builtins.int]:
        """
        - (Optional) Number of vCPU sockets.
        """
        return pulumi.get(self, "num_sockets")

    @_builtins.property
    @pulumi.getter(name="numVcpusPerSocket")
    def num_vcpus_per_socket(self) -> pulumi.Output[_builtins.int]:
        """
        - (Optional) Number of vCPUs per socket.
        """
        return pulumi.get(self, "num_vcpus_per_socket")

    @_builtins.property
    @pulumi.getter(name="numVnumaNodes")
    def num_vnuma_nodes(self) -> pulumi.Output[_builtins.int]:
        """
        - (Optional) Number of vNUMA nodes. 0 means vNUMA is disabled.
        """
        return pulumi.get(self, "num_vnuma_nodes")

    @_builtins.property
    @pulumi.getter(name="nutanixGuestTools")
    def nutanix_guest_tools(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - (Optional) Information regarding Nutanix Guest Tools.
        """
        return pulumi.get(self, "nutanix_guest_tools")

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - (Optional) The reference to a user.
        """
        return pulumi.get(self, "owner_reference")

    @_builtins.property
    @pulumi.getter(name="parentReference")
    def parent_reference(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - (Optional) Reference to an entity that the VM cloned from.
        """
        return pulumi.get(self, "parent_reference")

    @_builtins.property
    @pulumi.getter(name="powerState")
    def power_state(self) -> pulumi.Output[_builtins.str]:
        """
        - (Optional) The current or desired power state of the VM. (Options : ON , OFF)
        """
        return pulumi.get(self, "power_state")

    @_builtins.property
    @pulumi.getter(name="powerStateMechanism")
    def power_state_mechanism(self) -> pulumi.Output[_builtins.str]:
        """
        - (Optional) Indicates the mechanism guiding the VM power state transition. Currently used for the transition to \\"OFF\\" state. Power state mechanism (ACPI/GUEST/HARD).
        """
        return pulumi.get(self, "power_state_mechanism")

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - (Optional) The reference to a project.
        """
        return pulumi.get(self, "project_reference")

    @_builtins.property
    @pulumi.getter(name="serialPortLists")
    def serial_port_lists(self) -> pulumi.Output[Optional[Sequence['outputs.VirtualMachineSerialPortList']]]:
        """
        - (Optional) Serial Ports configured on the VM.
        """
        return pulumi.get(self, "serial_port_lists")

    @_builtins.property
    @pulumi.getter(name="shouldFailOnScriptFailure")
    def should_fail_on_script_failure(self) -> pulumi.Output[_builtins.bool]:
        """
        - (Optional)  Extra configs related to power state transition. Indicates whether to abort ngt shutdown/reboot if script fails.
        """
        return pulumi.get(self, "should_fail_on_script_failure")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        - The state of the vm.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="useHotAdd")
    def use_hot_add(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) Use Hot Add when modifying VM resources. Passing value false will result in VM reboots. Default value is `true`.
        """
        return pulumi.get(self, "use_hot_add")

    @_builtins.property
    @pulumi.getter(name="vgaConsoleEnabled")
    def vga_console_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        - (Optional) Indicates whether VGA console should be enabled or not.
        """
        return pulumi.get(self, "vga_console_enabled")

