# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VirtualMachineV2Args', 'VirtualMachineV2']

@pulumi.input_type
class VirtualMachineV2Args:
    def __init__(__self__, *,
                 apc_configs: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2ApcConfigArgs']]]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2AvailabilityZoneArgs']]]] = None,
                 bios_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_configs: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2BootConfigArgs']]]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2CategoryArgs']]]] = None,
                 cd_roms: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2CdRomArgs']]]] = None,
                 clusters: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2ClusterArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2DiskArgs']]]] = None,
                 enabled_cpu_features: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 generation_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 gpuses: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2GpusArgs']]]] = None,
                 guest_customizations: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2GuestCustomizationArgs']]]] = None,
                 guest_tools: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2GuestToolArgs']]]] = None,
                 hardware_clock_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2HostArgs']]]] = None,
                 is_agent_vm: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_branding_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_cpu_hotplug_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_cpu_passthrough_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_gpu_console_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_memory_overcommit_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_scsi_controller_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_vcpu_hard_pinning_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_vga_console_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_size_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nics: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2NicArgs']]]] = None,
                 num_cores_per_socket: Optional[pulumi.Input[_builtins.int]] = None,
                 num_numa_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 num_sockets: Optional[pulumi.Input[_builtins.int]] = None,
                 num_threads_per_core: Optional[pulumi.Input[_builtins.int]] = None,
                 ownership_infos: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2OwnershipInfoArgs']]]] = None,
                 power_state: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_policy_states: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2ProtectionPolicyStateArgs']]]] = None,
                 protection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 serial_ports: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2SerialPortArgs']]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2SourceArgs']]]] = None,
                 storage_configs: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2StorageConfigArgs']]]] = None,
                 vtpm_configs: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2VtpmConfigArgs']]]] = None):
        """
        The set of arguments for constructing a VirtualMachineV2 resource.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2ApcConfigArgs']]] apc_configs: Advanced Processor Compatibility configuration for the VM. Enabling this retains the CPU model for the VM across power cycles and migrations.
        :param pulumi.Input[_builtins.str] bios_uuid: BIOS UUID of the VM. It should be of type UUID.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2BootConfigArgs']]] boot_configs: Indicates the order of device types in which the VM should try to boot from. If the boot device order is not provided the system will decide an appropriate boot device order.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2CategoryArgs']]] categories: Categories for the VM.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2CdRomArgs']]] cd_roms: CD-ROMs attached to the VM.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2ClusterArgs']]] clusters: Reference to a cluster.
        :param pulumi.Input[_builtins.str] description: VM description
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2DiskArgs']]] disks: Disks attached to the VM.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_cpu_features: The list of additional CPU features to be enabled. HardwareVirtualization: Indicates whether hardware assisted virtualization should be enabled for the Guest OS or not. Once enabled, the Guest OS can deploy a nested hypervisor. Valid values are "HARDWARE_VIRTUALIZATION".
        :param pulumi.Input[_builtins.str] generation_uuid: Generation UUID of the VM. It should be of type UUID.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2GpusArgs']]] gpuses: GPUs attached to the VM.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2GuestCustomizationArgs']]] guest_customizations: Stage a Sysprep or cloud-init configuration file to be used by the guest for the next boot. Note that the Sysprep command must be used to generalize the Windows VMs before triggering this API call.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2GuestToolArgs']]] guest_tools: The details about Nutanix Guest Tools for a VM.
        :param pulumi.Input[_builtins.str] hardware_clock_timezone: VM hardware clock timezone in IANA TZDB format (America/Los_Angeles).
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2HostArgs']]] hosts: Reference to the host, the VM is running on.
        :param pulumi.Input[_builtins.bool] is_agent_vm: Indicates whether the VM is an agent VM or not. When their host enters maintenance mode, once the normal VMs are evacuated, the agent VMs are powered off. When the host is restored, agent VMs are powered on before the normal VMs are restored. In other words, agent VMs cannot be HA-protected or live migrated.
        :param pulumi.Input[_builtins.bool] is_branding_enabled: Indicates whether to remove AHV branding from VM firmware tables or not.
        :param pulumi.Input[_builtins.bool] is_cpu_hotplug_enabled: Indicates whether the VM CPU hotplug is enabled.
        :param pulumi.Input[_builtins.bool] is_cpu_passthrough_enabled: Indicates whether to passthrough the host CPU features to the guest or not. Enabling this will make VM incapable of live migration.
        :param pulumi.Input[_builtins.bool] is_gpu_console_enabled: Indicates whether the vGPU console is enabled or not.
        :param pulumi.Input[_builtins.bool] is_memory_overcommit_enabled: Indicates whether the memory overcommit feature should be enabled for the VM or not. If enabled, parts of the VM memory may reside outside of the hypervisor physical memory. Once enabled, it should be expected that the VM may suffer performance degradation.
        :param pulumi.Input[_builtins.bool] is_scsi_controller_enabled: Indicates whether the VM SCSI controller is enabled.
        :param pulumi.Input[_builtins.bool] is_vcpu_hard_pinning_enabled: Indicates whether the vCPUs should be hard pinned to specific pCPUs or not.
        :param pulumi.Input[_builtins.bool] is_vga_console_enabled: Indicates whether the VGA console should be disabled or not.
        :param pulumi.Input[_builtins.str] machine_type: Machine type for the VM. Machine type Q35 is required for secure boot and does not support IDE disks. Valid values are "PSERIES", "Q35", "PC" .
        :param pulumi.Input[_builtins.int] memory_size_bytes: Memory size in bytes.
        :param pulumi.Input[_builtins.str] name: VM name.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2NicArgs']]] nics: NICs attached to the VM.
        :param pulumi.Input[_builtins.int] num_cores_per_socket: Number of cores per socket. Value should be at least 1.
        :param pulumi.Input[_builtins.int] num_numa_nodes: Number of NUMA nodes. 0 means NUMA is disabled.
        :param pulumi.Input[_builtins.int] num_sockets: Number of vCPU sockets. Value should be at least 1.
        :param pulumi.Input[_builtins.int] num_threads_per_core: Number of threads per core. Value should be at least 1.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2OwnershipInfoArgs']]] ownership_infos: Ownership information for the VM.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2ProtectionPolicyStateArgs']]] protection_policy_states: Status of protection policy applied to this VM.
        :param pulumi.Input[_builtins.str] protection_type: The type of protection applied on a VM. Valid values "PD_PROTECTED", "UNPROTECTED", "RULE_PROTECTED".
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2SerialPortArgs']]] serial_ports: Serial ports configured on the VM.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2SourceArgs']]] sources: Reference to an entity that the VM should be cloned or created from. Valid values are "VM", "VM_RECOVERY_POINT".
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2StorageConfigArgs']]] storage_configs: Storage configuration for VM.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2VtpmConfigArgs']]] vtpm_configs: Indicates how the vTPM for the VM should be configured.
        """
        if apc_configs is not None:
            pulumi.set(__self__, "apc_configs", apc_configs)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if bios_uuid is not None:
            pulumi.set(__self__, "bios_uuid", bios_uuid)
        if boot_configs is not None:
            pulumi.set(__self__, "boot_configs", boot_configs)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if cd_roms is not None:
            pulumi.set(__self__, "cd_roms", cd_roms)
        if clusters is not None:
            pulumi.set(__self__, "clusters", clusters)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if enabled_cpu_features is not None:
            pulumi.set(__self__, "enabled_cpu_features", enabled_cpu_features)
        if generation_uuid is not None:
            pulumi.set(__self__, "generation_uuid", generation_uuid)
        if gpuses is not None:
            pulumi.set(__self__, "gpuses", gpuses)
        if guest_customizations is not None:
            pulumi.set(__self__, "guest_customizations", guest_customizations)
        if guest_tools is not None:
            pulumi.set(__self__, "guest_tools", guest_tools)
        if hardware_clock_timezone is not None:
            pulumi.set(__self__, "hardware_clock_timezone", hardware_clock_timezone)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if is_agent_vm is not None:
            pulumi.set(__self__, "is_agent_vm", is_agent_vm)
        if is_branding_enabled is not None:
            pulumi.set(__self__, "is_branding_enabled", is_branding_enabled)
        if is_cpu_hotplug_enabled is not None:
            pulumi.set(__self__, "is_cpu_hotplug_enabled", is_cpu_hotplug_enabled)
        if is_cpu_passthrough_enabled is not None:
            pulumi.set(__self__, "is_cpu_passthrough_enabled", is_cpu_passthrough_enabled)
        if is_gpu_console_enabled is not None:
            pulumi.set(__self__, "is_gpu_console_enabled", is_gpu_console_enabled)
        if is_memory_overcommit_enabled is not None:
            pulumi.set(__self__, "is_memory_overcommit_enabled", is_memory_overcommit_enabled)
        if is_scsi_controller_enabled is not None:
            pulumi.set(__self__, "is_scsi_controller_enabled", is_scsi_controller_enabled)
        if is_vcpu_hard_pinning_enabled is not None:
            pulumi.set(__self__, "is_vcpu_hard_pinning_enabled", is_vcpu_hard_pinning_enabled)
        if is_vga_console_enabled is not None:
            pulumi.set(__self__, "is_vga_console_enabled", is_vga_console_enabled)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if memory_size_bytes is not None:
            pulumi.set(__self__, "memory_size_bytes", memory_size_bytes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nics is not None:
            pulumi.set(__self__, "nics", nics)
        if num_cores_per_socket is not None:
            pulumi.set(__self__, "num_cores_per_socket", num_cores_per_socket)
        if num_numa_nodes is not None:
            pulumi.set(__self__, "num_numa_nodes", num_numa_nodes)
        if num_sockets is not None:
            pulumi.set(__self__, "num_sockets", num_sockets)
        if num_threads_per_core is not None:
            pulumi.set(__self__, "num_threads_per_core", num_threads_per_core)
        if ownership_infos is not None:
            pulumi.set(__self__, "ownership_infos", ownership_infos)
        if power_state is not None:
            pulumi.set(__self__, "power_state", power_state)
        if protection_policy_states is not None:
            pulumi.set(__self__, "protection_policy_states", protection_policy_states)
        if protection_type is not None:
            pulumi.set(__self__, "protection_type", protection_type)
        if serial_ports is not None:
            pulumi.set(__self__, "serial_ports", serial_ports)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if storage_configs is not None:
            pulumi.set(__self__, "storage_configs", storage_configs)
        if vtpm_configs is not None:
            pulumi.set(__self__, "vtpm_configs", vtpm_configs)

    @_builtins.property
    @pulumi.getter(name="apcConfigs")
    def apc_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2ApcConfigArgs']]]]:
        """
        Advanced Processor Compatibility configuration for the VM. Enabling this retains the CPU model for the VM across power cycles and migrations.
        """
        return pulumi.get(self, "apc_configs")

    @apc_configs.setter
    def apc_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2ApcConfigArgs']]]]):
        pulumi.set(self, "apc_configs", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2AvailabilityZoneArgs']]]]:
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2AvailabilityZoneArgs']]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="biosUuid")
    def bios_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        BIOS UUID of the VM. It should be of type UUID.
        """
        return pulumi.get(self, "bios_uuid")

    @bios_uuid.setter
    def bios_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bios_uuid", value)

    @_builtins.property
    @pulumi.getter(name="bootConfigs")
    def boot_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2BootConfigArgs']]]]:
        """
        Indicates the order of device types in which the VM should try to boot from. If the boot device order is not provided the system will decide an appropriate boot device order.
        """
        return pulumi.get(self, "boot_configs")

    @boot_configs.setter
    def boot_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2BootConfigArgs']]]]):
        pulumi.set(self, "boot_configs", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2CategoryArgs']]]]:
        """
        Categories for the VM.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2CategoryArgs']]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter(name="cdRoms")
    def cd_roms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2CdRomArgs']]]]:
        """
        CD-ROMs attached to the VM.
        """
        return pulumi.get(self, "cd_roms")

    @cd_roms.setter
    def cd_roms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2CdRomArgs']]]]):
        pulumi.set(self, "cd_roms", value)

    @_builtins.property
    @pulumi.getter
    def clusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2ClusterArgs']]]]:
        """
        Reference to a cluster.
        """
        return pulumi.get(self, "clusters")

    @clusters.setter
    def clusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2ClusterArgs']]]]):
        pulumi.set(self, "clusters", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VM description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2DiskArgs']]]]:
        """
        Disks attached to the VM.
        """
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2DiskArgs']]]]):
        pulumi.set(self, "disks", value)

    @_builtins.property
    @pulumi.getter(name="enabledCpuFeatures")
    def enabled_cpu_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of additional CPU features to be enabled. HardwareVirtualization: Indicates whether hardware assisted virtualization should be enabled for the Guest OS or not. Once enabled, the Guest OS can deploy a nested hypervisor. Valid values are "HARDWARE_VIRTUALIZATION".
        """
        return pulumi.get(self, "enabled_cpu_features")

    @enabled_cpu_features.setter
    def enabled_cpu_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "enabled_cpu_features", value)

    @_builtins.property
    @pulumi.getter(name="generationUuid")
    def generation_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Generation UUID of the VM. It should be of type UUID.
        """
        return pulumi.get(self, "generation_uuid")

    @generation_uuid.setter
    def generation_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "generation_uuid", value)

    @_builtins.property
    @pulumi.getter
    def gpuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2GpusArgs']]]]:
        """
        GPUs attached to the VM.
        """
        return pulumi.get(self, "gpuses")

    @gpuses.setter
    def gpuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2GpusArgs']]]]):
        pulumi.set(self, "gpuses", value)

    @_builtins.property
    @pulumi.getter(name="guestCustomizations")
    def guest_customizations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2GuestCustomizationArgs']]]]:
        """
        Stage a Sysprep or cloud-init configuration file to be used by the guest for the next boot. Note that the Sysprep command must be used to generalize the Windows VMs before triggering this API call.
        """
        return pulumi.get(self, "guest_customizations")

    @guest_customizations.setter
    def guest_customizations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2GuestCustomizationArgs']]]]):
        pulumi.set(self, "guest_customizations", value)

    @_builtins.property
    @pulumi.getter(name="guestTools")
    def guest_tools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2GuestToolArgs']]]]:
        """
        The details about Nutanix Guest Tools for a VM.
        """
        return pulumi.get(self, "guest_tools")

    @guest_tools.setter
    def guest_tools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2GuestToolArgs']]]]):
        pulumi.set(self, "guest_tools", value)

    @_builtins.property
    @pulumi.getter(name="hardwareClockTimezone")
    def hardware_clock_timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VM hardware clock timezone in IANA TZDB format (America/Los_Angeles).
        """
        return pulumi.get(self, "hardware_clock_timezone")

    @hardware_clock_timezone.setter
    def hardware_clock_timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hardware_clock_timezone", value)

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2HostArgs']]]]:
        """
        Reference to the host, the VM is running on.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2HostArgs']]]]):
        pulumi.set(self, "hosts", value)

    @_builtins.property
    @pulumi.getter(name="isAgentVm")
    def is_agent_vm(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the VM is an agent VM or not. When their host enters maintenance mode, once the normal VMs are evacuated, the agent VMs are powered off. When the host is restored, agent VMs are powered on before the normal VMs are restored. In other words, agent VMs cannot be HA-protected or live migrated.
        """
        return pulumi.get(self, "is_agent_vm")

    @is_agent_vm.setter
    def is_agent_vm(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_agent_vm", value)

    @_builtins.property
    @pulumi.getter(name="isBrandingEnabled")
    def is_branding_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether to remove AHV branding from VM firmware tables or not.
        """
        return pulumi.get(self, "is_branding_enabled")

    @is_branding_enabled.setter
    def is_branding_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_branding_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isCpuHotplugEnabled")
    def is_cpu_hotplug_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the VM CPU hotplug is enabled.
        """
        return pulumi.get(self, "is_cpu_hotplug_enabled")

    @is_cpu_hotplug_enabled.setter
    def is_cpu_hotplug_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_cpu_hotplug_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isCpuPassthroughEnabled")
    def is_cpu_passthrough_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether to passthrough the host CPU features to the guest or not. Enabling this will make VM incapable of live migration.
        """
        return pulumi.get(self, "is_cpu_passthrough_enabled")

    @is_cpu_passthrough_enabled.setter
    def is_cpu_passthrough_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_cpu_passthrough_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isGpuConsoleEnabled")
    def is_gpu_console_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the vGPU console is enabled or not.
        """
        return pulumi.get(self, "is_gpu_console_enabled")

    @is_gpu_console_enabled.setter
    def is_gpu_console_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_gpu_console_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isMemoryOvercommitEnabled")
    def is_memory_overcommit_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the memory overcommit feature should be enabled for the VM or not. If enabled, parts of the VM memory may reside outside of the hypervisor physical memory. Once enabled, it should be expected that the VM may suffer performance degradation.
        """
        return pulumi.get(self, "is_memory_overcommit_enabled")

    @is_memory_overcommit_enabled.setter
    def is_memory_overcommit_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_memory_overcommit_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isScsiControllerEnabled")
    def is_scsi_controller_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the VM SCSI controller is enabled.
        """
        return pulumi.get(self, "is_scsi_controller_enabled")

    @is_scsi_controller_enabled.setter
    def is_scsi_controller_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_scsi_controller_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isVcpuHardPinningEnabled")
    def is_vcpu_hard_pinning_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the vCPUs should be hard pinned to specific pCPUs or not.
        """
        return pulumi.get(self, "is_vcpu_hard_pinning_enabled")

    @is_vcpu_hard_pinning_enabled.setter
    def is_vcpu_hard_pinning_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_vcpu_hard_pinning_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isVgaConsoleEnabled")
    def is_vga_console_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the VGA console should be disabled or not.
        """
        return pulumi.get(self, "is_vga_console_enabled")

    @is_vga_console_enabled.setter
    def is_vga_console_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_vga_console_enabled", value)

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Machine type for the VM. Machine type Q35 is required for secure boot and does not support IDE disks. Valid values are "PSERIES", "Q35", "PC" .
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "machine_type", value)

    @_builtins.property
    @pulumi.getter(name="memorySizeBytes")
    def memory_size_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Memory size in bytes.
        """
        return pulumi.get(self, "memory_size_bytes")

    @memory_size_bytes.setter
    def memory_size_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_size_bytes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VM name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def nics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2NicArgs']]]]:
        """
        NICs attached to the VM.
        """
        return pulumi.get(self, "nics")

    @nics.setter
    def nics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2NicArgs']]]]):
        pulumi.set(self, "nics", value)

    @_builtins.property
    @pulumi.getter(name="numCoresPerSocket")
    def num_cores_per_socket(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of cores per socket. Value should be at least 1.
        """
        return pulumi.get(self, "num_cores_per_socket")

    @num_cores_per_socket.setter
    def num_cores_per_socket(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_cores_per_socket", value)

    @_builtins.property
    @pulumi.getter(name="numNumaNodes")
    def num_numa_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of NUMA nodes. 0 means NUMA is disabled.
        """
        return pulumi.get(self, "num_numa_nodes")

    @num_numa_nodes.setter
    def num_numa_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_numa_nodes", value)

    @_builtins.property
    @pulumi.getter(name="numSockets")
    def num_sockets(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of vCPU sockets. Value should be at least 1.
        """
        return pulumi.get(self, "num_sockets")

    @num_sockets.setter
    def num_sockets(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_sockets", value)

    @_builtins.property
    @pulumi.getter(name="numThreadsPerCore")
    def num_threads_per_core(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of threads per core. Value should be at least 1.
        """
        return pulumi.get(self, "num_threads_per_core")

    @num_threads_per_core.setter
    def num_threads_per_core(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_threads_per_core", value)

    @_builtins.property
    @pulumi.getter(name="ownershipInfos")
    def ownership_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2OwnershipInfoArgs']]]]:
        """
        Ownership information for the VM.
        """
        return pulumi.get(self, "ownership_infos")

    @ownership_infos.setter
    def ownership_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2OwnershipInfoArgs']]]]):
        pulumi.set(self, "ownership_infos", value)

    @_builtins.property
    @pulumi.getter(name="powerState")
    def power_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "power_state")

    @power_state.setter
    def power_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "power_state", value)

    @_builtins.property
    @pulumi.getter(name="protectionPolicyStates")
    def protection_policy_states(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2ProtectionPolicyStateArgs']]]]:
        """
        Status of protection policy applied to this VM.
        """
        return pulumi.get(self, "protection_policy_states")

    @protection_policy_states.setter
    def protection_policy_states(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2ProtectionPolicyStateArgs']]]]):
        pulumi.set(self, "protection_policy_states", value)

    @_builtins.property
    @pulumi.getter(name="protectionType")
    def protection_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of protection applied on a VM. Valid values "PD_PROTECTED", "UNPROTECTED", "RULE_PROTECTED".
        """
        return pulumi.get(self, "protection_type")

    @protection_type.setter
    def protection_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_type", value)

    @_builtins.property
    @pulumi.getter(name="serialPorts")
    def serial_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2SerialPortArgs']]]]:
        """
        Serial ports configured on the VM.
        """
        return pulumi.get(self, "serial_ports")

    @serial_ports.setter
    def serial_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2SerialPortArgs']]]]):
        pulumi.set(self, "serial_ports", value)

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2SourceArgs']]]]:
        """
        Reference to an entity that the VM should be cloned or created from. Valid values are "VM", "VM_RECOVERY_POINT".
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2SourceArgs']]]]):
        pulumi.set(self, "sources", value)

    @_builtins.property
    @pulumi.getter(name="storageConfigs")
    def storage_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2StorageConfigArgs']]]]:
        """
        Storage configuration for VM.
        """
        return pulumi.get(self, "storage_configs")

    @storage_configs.setter
    def storage_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2StorageConfigArgs']]]]):
        pulumi.set(self, "storage_configs", value)

    @_builtins.property
    @pulumi.getter(name="vtpmConfigs")
    def vtpm_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2VtpmConfigArgs']]]]:
        """
        Indicates how the vTPM for the VM should be configured.
        """
        return pulumi.get(self, "vtpm_configs")

    @vtpm_configs.setter
    def vtpm_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2VtpmConfigArgs']]]]):
        pulumi.set(self, "vtpm_configs", value)


@pulumi.input_type
class _VirtualMachineV2State:
    def __init__(__self__, *,
                 apc_configs: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2ApcConfigArgs']]]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2AvailabilityZoneArgs']]]] = None,
                 bios_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_configs: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2BootConfigArgs']]]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2CategoryArgs']]]] = None,
                 cd_roms: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2CdRomArgs']]]] = None,
                 clusters: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2ClusterArgs']]]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2DiskArgs']]]] = None,
                 enabled_cpu_features: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 generation_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 gpuses: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2GpusArgs']]]] = None,
                 guest_customizations: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2GuestCustomizationArgs']]]] = None,
                 guest_tools: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2GuestToolArgs']]]] = None,
                 hardware_clock_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2HostArgs']]]] = None,
                 is_agent_vm: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_branding_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_cpu_hotplug_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_cpu_passthrough_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_gpu_console_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_memory_overcommit_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_scsi_controller_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_vcpu_hard_pinning_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_vga_console_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_size_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nics: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2NicArgs']]]] = None,
                 num_cores_per_socket: Optional[pulumi.Input[_builtins.int]] = None,
                 num_numa_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 num_sockets: Optional[pulumi.Input[_builtins.int]] = None,
                 num_threads_per_core: Optional[pulumi.Input[_builtins.int]] = None,
                 ownership_infos: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2OwnershipInfoArgs']]]] = None,
                 power_state: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_policy_states: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2ProtectionPolicyStateArgs']]]] = None,
                 protection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 serial_ports: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2SerialPortArgs']]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2SourceArgs']]]] = None,
                 storage_configs: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2StorageConfigArgs']]]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None,
                 vtpm_configs: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2VtpmConfigArgs']]]] = None):
        """
        Input properties used for looking up and filtering VirtualMachineV2 resources.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2ApcConfigArgs']]] apc_configs: Advanced Processor Compatibility configuration for the VM. Enabling this retains the CPU model for the VM across power cycles and migrations.
        :param pulumi.Input[_builtins.str] bios_uuid: BIOS UUID of the VM. It should be of type UUID.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2BootConfigArgs']]] boot_configs: Indicates the order of device types in which the VM should try to boot from. If the boot device order is not provided the system will decide an appropriate boot device order.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2CategoryArgs']]] categories: Categories for the VM.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2CdRomArgs']]] cd_roms: CD-ROMs attached to the VM.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2ClusterArgs']]] clusters: Reference to a cluster.
        :param pulumi.Input[_builtins.str] create_time: VM creation time
        :param pulumi.Input[_builtins.str] description: VM description
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2DiskArgs']]] disks: Disks attached to the VM.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_cpu_features: The list of additional CPU features to be enabled. HardwareVirtualization: Indicates whether hardware assisted virtualization should be enabled for the Guest OS or not. Once enabled, the Guest OS can deploy a nested hypervisor. Valid values are "HARDWARE_VIRTUALIZATION".
        :param pulumi.Input[_builtins.str] ext_id: A globally unique identifier of an instance that is suitable for external consumption.
        :param pulumi.Input[_builtins.str] generation_uuid: Generation UUID of the VM. It should be of type UUID.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2GpusArgs']]] gpuses: GPUs attached to the VM.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2GuestCustomizationArgs']]] guest_customizations: Stage a Sysprep or cloud-init configuration file to be used by the guest for the next boot. Note that the Sysprep command must be used to generalize the Windows VMs before triggering this API call.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2GuestToolArgs']]] guest_tools: The details about Nutanix Guest Tools for a VM.
        :param pulumi.Input[_builtins.str] hardware_clock_timezone: VM hardware clock timezone in IANA TZDB format (America/Los_Angeles).
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2HostArgs']]] hosts: Reference to the host, the VM is running on.
        :param pulumi.Input[_builtins.bool] is_agent_vm: Indicates whether the VM is an agent VM or not. When their host enters maintenance mode, once the normal VMs are evacuated, the agent VMs are powered off. When the host is restored, agent VMs are powered on before the normal VMs are restored. In other words, agent VMs cannot be HA-protected or live migrated.
        :param pulumi.Input[_builtins.bool] is_branding_enabled: Indicates whether to remove AHV branding from VM firmware tables or not.
        :param pulumi.Input[_builtins.bool] is_cpu_hotplug_enabled: Indicates whether the VM CPU hotplug is enabled.
        :param pulumi.Input[_builtins.bool] is_cpu_passthrough_enabled: Indicates whether to passthrough the host CPU features to the guest or not. Enabling this will make VM incapable of live migration.
        :param pulumi.Input[_builtins.bool] is_gpu_console_enabled: Indicates whether the vGPU console is enabled or not.
        :param pulumi.Input[_builtins.bool] is_memory_overcommit_enabled: Indicates whether the memory overcommit feature should be enabled for the VM or not. If enabled, parts of the VM memory may reside outside of the hypervisor physical memory. Once enabled, it should be expected that the VM may suffer performance degradation.
        :param pulumi.Input[_builtins.bool] is_scsi_controller_enabled: Indicates whether the VM SCSI controller is enabled.
        :param pulumi.Input[_builtins.bool] is_vcpu_hard_pinning_enabled: Indicates whether the vCPUs should be hard pinned to specific pCPUs or not.
        :param pulumi.Input[_builtins.bool] is_vga_console_enabled: Indicates whether the VGA console should be disabled or not.
        :param pulumi.Input[_builtins.str] machine_type: Machine type for the VM. Machine type Q35 is required for secure boot and does not support IDE disks. Valid values are "PSERIES", "Q35", "PC" .
        :param pulumi.Input[_builtins.int] memory_size_bytes: Memory size in bytes.
        :param pulumi.Input[_builtins.str] name: VM name.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2NicArgs']]] nics: NICs attached to the VM.
        :param pulumi.Input[_builtins.int] num_cores_per_socket: Number of cores per socket. Value should be at least 1.
        :param pulumi.Input[_builtins.int] num_numa_nodes: Number of NUMA nodes. 0 means NUMA is disabled.
        :param pulumi.Input[_builtins.int] num_sockets: Number of vCPU sockets. Value should be at least 1.
        :param pulumi.Input[_builtins.int] num_threads_per_core: Number of threads per core. Value should be at least 1.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2OwnershipInfoArgs']]] ownership_infos: Ownership information for the VM.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2ProtectionPolicyStateArgs']]] protection_policy_states: Status of protection policy applied to this VM.
        :param pulumi.Input[_builtins.str] protection_type: The type of protection applied on a VM. Valid values "PD_PROTECTED", "UNPROTECTED", "RULE_PROTECTED".
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2SerialPortArgs']]] serial_ports: Serial ports configured on the VM.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2SourceArgs']]] sources: Reference to an entity that the VM should be cloned or created from. Valid values are "VM", "VM_RECOVERY_POINT".
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2StorageConfigArgs']]] storage_configs: Storage configuration for VM.
        :param pulumi.Input[_builtins.str] update_time: VM last updated time.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2VtpmConfigArgs']]] vtpm_configs: Indicates how the vTPM for the VM should be configured.
        """
        if apc_configs is not None:
            pulumi.set(__self__, "apc_configs", apc_configs)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if bios_uuid is not None:
            pulumi.set(__self__, "bios_uuid", bios_uuid)
        if boot_configs is not None:
            pulumi.set(__self__, "boot_configs", boot_configs)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if cd_roms is not None:
            pulumi.set(__self__, "cd_roms", cd_roms)
        if clusters is not None:
            pulumi.set(__self__, "clusters", clusters)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if enabled_cpu_features is not None:
            pulumi.set(__self__, "enabled_cpu_features", enabled_cpu_features)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if generation_uuid is not None:
            pulumi.set(__self__, "generation_uuid", generation_uuid)
        if gpuses is not None:
            pulumi.set(__self__, "gpuses", gpuses)
        if guest_customizations is not None:
            pulumi.set(__self__, "guest_customizations", guest_customizations)
        if guest_tools is not None:
            pulumi.set(__self__, "guest_tools", guest_tools)
        if hardware_clock_timezone is not None:
            pulumi.set(__self__, "hardware_clock_timezone", hardware_clock_timezone)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if is_agent_vm is not None:
            pulumi.set(__self__, "is_agent_vm", is_agent_vm)
        if is_branding_enabled is not None:
            pulumi.set(__self__, "is_branding_enabled", is_branding_enabled)
        if is_cpu_hotplug_enabled is not None:
            pulumi.set(__self__, "is_cpu_hotplug_enabled", is_cpu_hotplug_enabled)
        if is_cpu_passthrough_enabled is not None:
            pulumi.set(__self__, "is_cpu_passthrough_enabled", is_cpu_passthrough_enabled)
        if is_gpu_console_enabled is not None:
            pulumi.set(__self__, "is_gpu_console_enabled", is_gpu_console_enabled)
        if is_memory_overcommit_enabled is not None:
            pulumi.set(__self__, "is_memory_overcommit_enabled", is_memory_overcommit_enabled)
        if is_scsi_controller_enabled is not None:
            pulumi.set(__self__, "is_scsi_controller_enabled", is_scsi_controller_enabled)
        if is_vcpu_hard_pinning_enabled is not None:
            pulumi.set(__self__, "is_vcpu_hard_pinning_enabled", is_vcpu_hard_pinning_enabled)
        if is_vga_console_enabled is not None:
            pulumi.set(__self__, "is_vga_console_enabled", is_vga_console_enabled)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if memory_size_bytes is not None:
            pulumi.set(__self__, "memory_size_bytes", memory_size_bytes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nics is not None:
            pulumi.set(__self__, "nics", nics)
        if num_cores_per_socket is not None:
            pulumi.set(__self__, "num_cores_per_socket", num_cores_per_socket)
        if num_numa_nodes is not None:
            pulumi.set(__self__, "num_numa_nodes", num_numa_nodes)
        if num_sockets is not None:
            pulumi.set(__self__, "num_sockets", num_sockets)
        if num_threads_per_core is not None:
            pulumi.set(__self__, "num_threads_per_core", num_threads_per_core)
        if ownership_infos is not None:
            pulumi.set(__self__, "ownership_infos", ownership_infos)
        if power_state is not None:
            pulumi.set(__self__, "power_state", power_state)
        if protection_policy_states is not None:
            pulumi.set(__self__, "protection_policy_states", protection_policy_states)
        if protection_type is not None:
            pulumi.set(__self__, "protection_type", protection_type)
        if serial_ports is not None:
            pulumi.set(__self__, "serial_ports", serial_ports)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if storage_configs is not None:
            pulumi.set(__self__, "storage_configs", storage_configs)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if vtpm_configs is not None:
            pulumi.set(__self__, "vtpm_configs", vtpm_configs)

    @_builtins.property
    @pulumi.getter(name="apcConfigs")
    def apc_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2ApcConfigArgs']]]]:
        """
        Advanced Processor Compatibility configuration for the VM. Enabling this retains the CPU model for the VM across power cycles and migrations.
        """
        return pulumi.get(self, "apc_configs")

    @apc_configs.setter
    def apc_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2ApcConfigArgs']]]]):
        pulumi.set(self, "apc_configs", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2AvailabilityZoneArgs']]]]:
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2AvailabilityZoneArgs']]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="biosUuid")
    def bios_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        BIOS UUID of the VM. It should be of type UUID.
        """
        return pulumi.get(self, "bios_uuid")

    @bios_uuid.setter
    def bios_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bios_uuid", value)

    @_builtins.property
    @pulumi.getter(name="bootConfigs")
    def boot_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2BootConfigArgs']]]]:
        """
        Indicates the order of device types in which the VM should try to boot from. If the boot device order is not provided the system will decide an appropriate boot device order.
        """
        return pulumi.get(self, "boot_configs")

    @boot_configs.setter
    def boot_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2BootConfigArgs']]]]):
        pulumi.set(self, "boot_configs", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2CategoryArgs']]]]:
        """
        Categories for the VM.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2CategoryArgs']]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter(name="cdRoms")
    def cd_roms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2CdRomArgs']]]]:
        """
        CD-ROMs attached to the VM.
        """
        return pulumi.get(self, "cd_roms")

    @cd_roms.setter
    def cd_roms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2CdRomArgs']]]]):
        pulumi.set(self, "cd_roms", value)

    @_builtins.property
    @pulumi.getter
    def clusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2ClusterArgs']]]]:
        """
        Reference to a cluster.
        """
        return pulumi.get(self, "clusters")

    @clusters.setter
    def clusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2ClusterArgs']]]]):
        pulumi.set(self, "clusters", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VM creation time
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VM description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2DiskArgs']]]]:
        """
        Disks attached to the VM.
        """
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2DiskArgs']]]]):
        pulumi.set(self, "disks", value)

    @_builtins.property
    @pulumi.getter(name="enabledCpuFeatures")
    def enabled_cpu_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of additional CPU features to be enabled. HardwareVirtualization: Indicates whether hardware assisted virtualization should be enabled for the Guest OS or not. Once enabled, the Guest OS can deploy a nested hypervisor. Valid values are "HARDWARE_VIRTUALIZATION".
        """
        return pulumi.get(self, "enabled_cpu_features")

    @enabled_cpu_features.setter
    def enabled_cpu_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "enabled_cpu_features", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="generationUuid")
    def generation_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Generation UUID of the VM. It should be of type UUID.
        """
        return pulumi.get(self, "generation_uuid")

    @generation_uuid.setter
    def generation_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "generation_uuid", value)

    @_builtins.property
    @pulumi.getter
    def gpuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2GpusArgs']]]]:
        """
        GPUs attached to the VM.
        """
        return pulumi.get(self, "gpuses")

    @gpuses.setter
    def gpuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2GpusArgs']]]]):
        pulumi.set(self, "gpuses", value)

    @_builtins.property
    @pulumi.getter(name="guestCustomizations")
    def guest_customizations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2GuestCustomizationArgs']]]]:
        """
        Stage a Sysprep or cloud-init configuration file to be used by the guest for the next boot. Note that the Sysprep command must be used to generalize the Windows VMs before triggering this API call.
        """
        return pulumi.get(self, "guest_customizations")

    @guest_customizations.setter
    def guest_customizations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2GuestCustomizationArgs']]]]):
        pulumi.set(self, "guest_customizations", value)

    @_builtins.property
    @pulumi.getter(name="guestTools")
    def guest_tools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2GuestToolArgs']]]]:
        """
        The details about Nutanix Guest Tools for a VM.
        """
        return pulumi.get(self, "guest_tools")

    @guest_tools.setter
    def guest_tools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2GuestToolArgs']]]]):
        pulumi.set(self, "guest_tools", value)

    @_builtins.property
    @pulumi.getter(name="hardwareClockTimezone")
    def hardware_clock_timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VM hardware clock timezone in IANA TZDB format (America/Los_Angeles).
        """
        return pulumi.get(self, "hardware_clock_timezone")

    @hardware_clock_timezone.setter
    def hardware_clock_timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hardware_clock_timezone", value)

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2HostArgs']]]]:
        """
        Reference to the host, the VM is running on.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2HostArgs']]]]):
        pulumi.set(self, "hosts", value)

    @_builtins.property
    @pulumi.getter(name="isAgentVm")
    def is_agent_vm(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the VM is an agent VM or not. When their host enters maintenance mode, once the normal VMs are evacuated, the agent VMs are powered off. When the host is restored, agent VMs are powered on before the normal VMs are restored. In other words, agent VMs cannot be HA-protected or live migrated.
        """
        return pulumi.get(self, "is_agent_vm")

    @is_agent_vm.setter
    def is_agent_vm(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_agent_vm", value)

    @_builtins.property
    @pulumi.getter(name="isBrandingEnabled")
    def is_branding_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether to remove AHV branding from VM firmware tables or not.
        """
        return pulumi.get(self, "is_branding_enabled")

    @is_branding_enabled.setter
    def is_branding_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_branding_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isCpuHotplugEnabled")
    def is_cpu_hotplug_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the VM CPU hotplug is enabled.
        """
        return pulumi.get(self, "is_cpu_hotplug_enabled")

    @is_cpu_hotplug_enabled.setter
    def is_cpu_hotplug_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_cpu_hotplug_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isCpuPassthroughEnabled")
    def is_cpu_passthrough_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether to passthrough the host CPU features to the guest or not. Enabling this will make VM incapable of live migration.
        """
        return pulumi.get(self, "is_cpu_passthrough_enabled")

    @is_cpu_passthrough_enabled.setter
    def is_cpu_passthrough_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_cpu_passthrough_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isGpuConsoleEnabled")
    def is_gpu_console_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the vGPU console is enabled or not.
        """
        return pulumi.get(self, "is_gpu_console_enabled")

    @is_gpu_console_enabled.setter
    def is_gpu_console_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_gpu_console_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isMemoryOvercommitEnabled")
    def is_memory_overcommit_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the memory overcommit feature should be enabled for the VM or not. If enabled, parts of the VM memory may reside outside of the hypervisor physical memory. Once enabled, it should be expected that the VM may suffer performance degradation.
        """
        return pulumi.get(self, "is_memory_overcommit_enabled")

    @is_memory_overcommit_enabled.setter
    def is_memory_overcommit_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_memory_overcommit_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isScsiControllerEnabled")
    def is_scsi_controller_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the VM SCSI controller is enabled.
        """
        return pulumi.get(self, "is_scsi_controller_enabled")

    @is_scsi_controller_enabled.setter
    def is_scsi_controller_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_scsi_controller_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isVcpuHardPinningEnabled")
    def is_vcpu_hard_pinning_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the vCPUs should be hard pinned to specific pCPUs or not.
        """
        return pulumi.get(self, "is_vcpu_hard_pinning_enabled")

    @is_vcpu_hard_pinning_enabled.setter
    def is_vcpu_hard_pinning_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_vcpu_hard_pinning_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isVgaConsoleEnabled")
    def is_vga_console_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the VGA console should be disabled or not.
        """
        return pulumi.get(self, "is_vga_console_enabled")

    @is_vga_console_enabled.setter
    def is_vga_console_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_vga_console_enabled", value)

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Machine type for the VM. Machine type Q35 is required for secure boot and does not support IDE disks. Valid values are "PSERIES", "Q35", "PC" .
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "machine_type", value)

    @_builtins.property
    @pulumi.getter(name="memorySizeBytes")
    def memory_size_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Memory size in bytes.
        """
        return pulumi.get(self, "memory_size_bytes")

    @memory_size_bytes.setter
    def memory_size_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_size_bytes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VM name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def nics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2NicArgs']]]]:
        """
        NICs attached to the VM.
        """
        return pulumi.get(self, "nics")

    @nics.setter
    def nics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2NicArgs']]]]):
        pulumi.set(self, "nics", value)

    @_builtins.property
    @pulumi.getter(name="numCoresPerSocket")
    def num_cores_per_socket(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of cores per socket. Value should be at least 1.
        """
        return pulumi.get(self, "num_cores_per_socket")

    @num_cores_per_socket.setter
    def num_cores_per_socket(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_cores_per_socket", value)

    @_builtins.property
    @pulumi.getter(name="numNumaNodes")
    def num_numa_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of NUMA nodes. 0 means NUMA is disabled.
        """
        return pulumi.get(self, "num_numa_nodes")

    @num_numa_nodes.setter
    def num_numa_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_numa_nodes", value)

    @_builtins.property
    @pulumi.getter(name="numSockets")
    def num_sockets(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of vCPU sockets. Value should be at least 1.
        """
        return pulumi.get(self, "num_sockets")

    @num_sockets.setter
    def num_sockets(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_sockets", value)

    @_builtins.property
    @pulumi.getter(name="numThreadsPerCore")
    def num_threads_per_core(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of threads per core. Value should be at least 1.
        """
        return pulumi.get(self, "num_threads_per_core")

    @num_threads_per_core.setter
    def num_threads_per_core(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_threads_per_core", value)

    @_builtins.property
    @pulumi.getter(name="ownershipInfos")
    def ownership_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2OwnershipInfoArgs']]]]:
        """
        Ownership information for the VM.
        """
        return pulumi.get(self, "ownership_infos")

    @ownership_infos.setter
    def ownership_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2OwnershipInfoArgs']]]]):
        pulumi.set(self, "ownership_infos", value)

    @_builtins.property
    @pulumi.getter(name="powerState")
    def power_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "power_state")

    @power_state.setter
    def power_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "power_state", value)

    @_builtins.property
    @pulumi.getter(name="protectionPolicyStates")
    def protection_policy_states(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2ProtectionPolicyStateArgs']]]]:
        """
        Status of protection policy applied to this VM.
        """
        return pulumi.get(self, "protection_policy_states")

    @protection_policy_states.setter
    def protection_policy_states(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2ProtectionPolicyStateArgs']]]]):
        pulumi.set(self, "protection_policy_states", value)

    @_builtins.property
    @pulumi.getter(name="protectionType")
    def protection_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of protection applied on a VM. Valid values "PD_PROTECTED", "UNPROTECTED", "RULE_PROTECTED".
        """
        return pulumi.get(self, "protection_type")

    @protection_type.setter
    def protection_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_type", value)

    @_builtins.property
    @pulumi.getter(name="serialPorts")
    def serial_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2SerialPortArgs']]]]:
        """
        Serial ports configured on the VM.
        """
        return pulumi.get(self, "serial_ports")

    @serial_ports.setter
    def serial_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2SerialPortArgs']]]]):
        pulumi.set(self, "serial_ports", value)

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2SourceArgs']]]]:
        """
        Reference to an entity that the VM should be cloned or created from. Valid values are "VM", "VM_RECOVERY_POINT".
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2SourceArgs']]]]):
        pulumi.set(self, "sources", value)

    @_builtins.property
    @pulumi.getter(name="storageConfigs")
    def storage_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2StorageConfigArgs']]]]:
        """
        Storage configuration for VM.
        """
        return pulumi.get(self, "storage_configs")

    @storage_configs.setter
    def storage_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2StorageConfigArgs']]]]):
        pulumi.set(self, "storage_configs", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VM last updated time.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)

    @_builtins.property
    @pulumi.getter(name="vtpmConfigs")
    def vtpm_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2VtpmConfigArgs']]]]:
        """
        Indicates how the vTPM for the VM should be configured.
        """
        return pulumi.get(self, "vtpm_configs")

    @vtpm_configs.setter
    def vtpm_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineV2VtpmConfigArgs']]]]):
        pulumi.set(self, "vtpm_configs", value)


@pulumi.type_token("nutanix:index/virtualMachineV2:VirtualMachineV2")
class VirtualMachineV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apc_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2ApcConfigArgs', 'VirtualMachineV2ApcConfigArgsDict']]]]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2AvailabilityZoneArgs', 'VirtualMachineV2AvailabilityZoneArgsDict']]]]] = None,
                 bios_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2BootConfigArgs', 'VirtualMachineV2BootConfigArgsDict']]]]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2CategoryArgs', 'VirtualMachineV2CategoryArgsDict']]]]] = None,
                 cd_roms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2CdRomArgs', 'VirtualMachineV2CdRomArgsDict']]]]] = None,
                 clusters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2ClusterArgs', 'VirtualMachineV2ClusterArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2DiskArgs', 'VirtualMachineV2DiskArgsDict']]]]] = None,
                 enabled_cpu_features: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 generation_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 gpuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2GpusArgs', 'VirtualMachineV2GpusArgsDict']]]]] = None,
                 guest_customizations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2GuestCustomizationArgs', 'VirtualMachineV2GuestCustomizationArgsDict']]]]] = None,
                 guest_tools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2GuestToolArgs', 'VirtualMachineV2GuestToolArgsDict']]]]] = None,
                 hardware_clock_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2HostArgs', 'VirtualMachineV2HostArgsDict']]]]] = None,
                 is_agent_vm: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_branding_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_cpu_hotplug_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_cpu_passthrough_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_gpu_console_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_memory_overcommit_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_scsi_controller_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_vcpu_hard_pinning_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_vga_console_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_size_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2NicArgs', 'VirtualMachineV2NicArgsDict']]]]] = None,
                 num_cores_per_socket: Optional[pulumi.Input[_builtins.int]] = None,
                 num_numa_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 num_sockets: Optional[pulumi.Input[_builtins.int]] = None,
                 num_threads_per_core: Optional[pulumi.Input[_builtins.int]] = None,
                 ownership_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2OwnershipInfoArgs', 'VirtualMachineV2OwnershipInfoArgsDict']]]]] = None,
                 power_state: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_policy_states: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2ProtectionPolicyStateArgs', 'VirtualMachineV2ProtectionPolicyStateArgsDict']]]]] = None,
                 protection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 serial_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2SerialPortArgs', 'VirtualMachineV2SerialPortArgsDict']]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2SourceArgs', 'VirtualMachineV2SourceArgsDict']]]]] = None,
                 storage_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2StorageConfigArgs', 'VirtualMachineV2StorageConfigArgsDict']]]]] = None,
                 vtpm_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2VtpmConfigArgs', 'VirtualMachineV2VtpmConfigArgsDict']]]]] = None,
                 __props__=None):
        """
        Creates a Virtual Machine with the provided configuration.

        ## Example

        ```python
        import pulumi
        import pulumi_nutanix as nutanix
        import pulumi_std as std

        vm_1 = nutanix.VirtualMachineV2("vm-1",
            name="example-vm-1",
            description="vm desc",
            num_cores_per_socket=1,
            num_sockets=1,
            clusters=[{
                "ext_id": "1cefd0f5-6d38-4c9b-a07c-bdd2db004224",
            }])
        vm_2 = nutanix.VirtualMachineV2("vm-2",
            name="example-vm-2",
            description="vm desc",
            num_cores_per_socket=1,
            num_sockets=1,
            clusters=[{
                "ext_id": "1cefd0f5-6d38-4c9b-a07c-bdd2db004224",
            }],
            disks=[{
                "disk_addresses": [{
                    "bus_type": "SCSI",
                    "index": 0,
                }],
                "backing_infos": [{
                    "vm_disks": [{
                        "disk_size_bytes": 1073741824,
                        "storage_containers": [{
                            "ext_id": "1cefd0f5-6d38-4c9b-a07c-bdd2db004224",
                        }],
                    }],
                }],
            }],
            boot_configs=[{
                "uefi_boots": [{
                    "boot_orders": [
                        "NETWORK",
                        "DISK",
                        "CDROM",
                    ],
                }],
            }])
        vm_3 = nutanix.VirtualMachineV2("vm-3",
            name="terraform-example-vm-4-disks",
            num_cores_per_socket=1,
            num_sockets=1,
            clusters=[{
                "ext_id": "1cefd0f5-6d38-4c9b-a07c-bdd2db004224",
            }],
            disks=[
                {
                    "disk_addresses": [{
                        "bus_type": "SCSI",
                        "index": 0,
                    }],
                    "backing_infos": [{
                        "vm_disks": [{
                            "data_sources": [{
                                "references": [{
                                    "image_references": [{
                                        "image_ext_id": "59ec786c-4311-4225-affe-68b65c5ebf10",
                                    }],
                                }],
                            }],
                            "disk_size_bytes": 20 * std.pow(base=1024,
                                exponent=3).result,
                        }],
                    }],
                },
                {
                    "disk_addresses": [{
                        "bus_type": "SCSI",
                        "index": 1,
                    }],
                    "backing_infos": [{
                        "vm_disks": [{
                            "disk_size_bytes": 10 * std.pow(base=1024,
                                exponent=3).result,
                            "storage_containers": [{
                                "ext_id": "5d9b5941-fec3-4996-9d31-f31bed1c7735",
                            }],
                        }],
                    }],
                },
                {
                    "disk_addresses": [{
                        "bus_type": "SCSI",
                        "index": 2,
                    }],
                    "backing_infos": [{
                        "vm_disks": [{
                            "disk_size_bytes": 15 * std.pow(base=1024,
                                exponent=3).result,
                            "storage_containers": [{
                                "ext_id": "5d9b5941-fec3-4996-9d31-f31bed1c7735",
                            }],
                        }],
                    }],
                },
                {
                    "disk_addresses": [{
                        "bus_type": "SCSI",
                        "index": 3,
                    }],
                    "backing_infos": [{
                        "vm_disks": [{
                            "disk_size_bytes": 20 * std.pow(base=1024,
                                exponent=3).result,
                            "storage_containers": [{
                                "ext_id": "5d9b5941-fec3-4996-9d31-f31bed1c7735",
                            }],
                        }],
                    }],
                },
            ],
            nics=[{
                "network_infos": [{
                    "nic_type": "NORMAL_NIC",
                    "subnets": [{
                        "ext_id": "7f66e20f-67f4-473f-96bb-c4fcfd487f16",
                    }],
                    "vlan_mode": "ACCESS",
                }],
            }],
            boot_configs=[{
                "legacy_boots": [{
                    "boot_orders": [
                        "CDROM",
                        "DISK",
                        "NETWORK",
                    ],
                }],
            }],
            power_state="ON")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2ApcConfigArgs', 'VirtualMachineV2ApcConfigArgsDict']]]] apc_configs: Advanced Processor Compatibility configuration for the VM. Enabling this retains the CPU model for the VM across power cycles and migrations.
        :param pulumi.Input[_builtins.str] bios_uuid: BIOS UUID of the VM. It should be of type UUID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2BootConfigArgs', 'VirtualMachineV2BootConfigArgsDict']]]] boot_configs: Indicates the order of device types in which the VM should try to boot from. If the boot device order is not provided the system will decide an appropriate boot device order.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2CategoryArgs', 'VirtualMachineV2CategoryArgsDict']]]] categories: Categories for the VM.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2CdRomArgs', 'VirtualMachineV2CdRomArgsDict']]]] cd_roms: CD-ROMs attached to the VM.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2ClusterArgs', 'VirtualMachineV2ClusterArgsDict']]]] clusters: Reference to a cluster.
        :param pulumi.Input[_builtins.str] description: VM description
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2DiskArgs', 'VirtualMachineV2DiskArgsDict']]]] disks: Disks attached to the VM.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_cpu_features: The list of additional CPU features to be enabled. HardwareVirtualization: Indicates whether hardware assisted virtualization should be enabled for the Guest OS or not. Once enabled, the Guest OS can deploy a nested hypervisor. Valid values are "HARDWARE_VIRTUALIZATION".
        :param pulumi.Input[_builtins.str] generation_uuid: Generation UUID of the VM. It should be of type UUID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2GpusArgs', 'VirtualMachineV2GpusArgsDict']]]] gpuses: GPUs attached to the VM.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2GuestCustomizationArgs', 'VirtualMachineV2GuestCustomizationArgsDict']]]] guest_customizations: Stage a Sysprep or cloud-init configuration file to be used by the guest for the next boot. Note that the Sysprep command must be used to generalize the Windows VMs before triggering this API call.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2GuestToolArgs', 'VirtualMachineV2GuestToolArgsDict']]]] guest_tools: The details about Nutanix Guest Tools for a VM.
        :param pulumi.Input[_builtins.str] hardware_clock_timezone: VM hardware clock timezone in IANA TZDB format (America/Los_Angeles).
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2HostArgs', 'VirtualMachineV2HostArgsDict']]]] hosts: Reference to the host, the VM is running on.
        :param pulumi.Input[_builtins.bool] is_agent_vm: Indicates whether the VM is an agent VM or not. When their host enters maintenance mode, once the normal VMs are evacuated, the agent VMs are powered off. When the host is restored, agent VMs are powered on before the normal VMs are restored. In other words, agent VMs cannot be HA-protected or live migrated.
        :param pulumi.Input[_builtins.bool] is_branding_enabled: Indicates whether to remove AHV branding from VM firmware tables or not.
        :param pulumi.Input[_builtins.bool] is_cpu_hotplug_enabled: Indicates whether the VM CPU hotplug is enabled.
        :param pulumi.Input[_builtins.bool] is_cpu_passthrough_enabled: Indicates whether to passthrough the host CPU features to the guest or not. Enabling this will make VM incapable of live migration.
        :param pulumi.Input[_builtins.bool] is_gpu_console_enabled: Indicates whether the vGPU console is enabled or not.
        :param pulumi.Input[_builtins.bool] is_memory_overcommit_enabled: Indicates whether the memory overcommit feature should be enabled for the VM or not. If enabled, parts of the VM memory may reside outside of the hypervisor physical memory. Once enabled, it should be expected that the VM may suffer performance degradation.
        :param pulumi.Input[_builtins.bool] is_scsi_controller_enabled: Indicates whether the VM SCSI controller is enabled.
        :param pulumi.Input[_builtins.bool] is_vcpu_hard_pinning_enabled: Indicates whether the vCPUs should be hard pinned to specific pCPUs or not.
        :param pulumi.Input[_builtins.bool] is_vga_console_enabled: Indicates whether the VGA console should be disabled or not.
        :param pulumi.Input[_builtins.str] machine_type: Machine type for the VM. Machine type Q35 is required for secure boot and does not support IDE disks. Valid values are "PSERIES", "Q35", "PC" .
        :param pulumi.Input[_builtins.int] memory_size_bytes: Memory size in bytes.
        :param pulumi.Input[_builtins.str] name: VM name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2NicArgs', 'VirtualMachineV2NicArgsDict']]]] nics: NICs attached to the VM.
        :param pulumi.Input[_builtins.int] num_cores_per_socket: Number of cores per socket. Value should be at least 1.
        :param pulumi.Input[_builtins.int] num_numa_nodes: Number of NUMA nodes. 0 means NUMA is disabled.
        :param pulumi.Input[_builtins.int] num_sockets: Number of vCPU sockets. Value should be at least 1.
        :param pulumi.Input[_builtins.int] num_threads_per_core: Number of threads per core. Value should be at least 1.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2OwnershipInfoArgs', 'VirtualMachineV2OwnershipInfoArgsDict']]]] ownership_infos: Ownership information for the VM.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2ProtectionPolicyStateArgs', 'VirtualMachineV2ProtectionPolicyStateArgsDict']]]] protection_policy_states: Status of protection policy applied to this VM.
        :param pulumi.Input[_builtins.str] protection_type: The type of protection applied on a VM. Valid values "PD_PROTECTED", "UNPROTECTED", "RULE_PROTECTED".
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2SerialPortArgs', 'VirtualMachineV2SerialPortArgsDict']]]] serial_ports: Serial ports configured on the VM.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2SourceArgs', 'VirtualMachineV2SourceArgsDict']]]] sources: Reference to an entity that the VM should be cloned or created from. Valid values are "VM", "VM_RECOVERY_POINT".
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2StorageConfigArgs', 'VirtualMachineV2StorageConfigArgsDict']]]] storage_configs: Storage configuration for VM.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2VtpmConfigArgs', 'VirtualMachineV2VtpmConfigArgsDict']]]] vtpm_configs: Indicates how the vTPM for the VM should be configured.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[VirtualMachineV2Args] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a Virtual Machine with the provided configuration.

        ## Example

        ```python
        import pulumi
        import pulumi_nutanix as nutanix
        import pulumi_std as std

        vm_1 = nutanix.VirtualMachineV2("vm-1",
            name="example-vm-1",
            description="vm desc",
            num_cores_per_socket=1,
            num_sockets=1,
            clusters=[{
                "ext_id": "1cefd0f5-6d38-4c9b-a07c-bdd2db004224",
            }])
        vm_2 = nutanix.VirtualMachineV2("vm-2",
            name="example-vm-2",
            description="vm desc",
            num_cores_per_socket=1,
            num_sockets=1,
            clusters=[{
                "ext_id": "1cefd0f5-6d38-4c9b-a07c-bdd2db004224",
            }],
            disks=[{
                "disk_addresses": [{
                    "bus_type": "SCSI",
                    "index": 0,
                }],
                "backing_infos": [{
                    "vm_disks": [{
                        "disk_size_bytes": 1073741824,
                        "storage_containers": [{
                            "ext_id": "1cefd0f5-6d38-4c9b-a07c-bdd2db004224",
                        }],
                    }],
                }],
            }],
            boot_configs=[{
                "uefi_boots": [{
                    "boot_orders": [
                        "NETWORK",
                        "DISK",
                        "CDROM",
                    ],
                }],
            }])
        vm_3 = nutanix.VirtualMachineV2("vm-3",
            name="terraform-example-vm-4-disks",
            num_cores_per_socket=1,
            num_sockets=1,
            clusters=[{
                "ext_id": "1cefd0f5-6d38-4c9b-a07c-bdd2db004224",
            }],
            disks=[
                {
                    "disk_addresses": [{
                        "bus_type": "SCSI",
                        "index": 0,
                    }],
                    "backing_infos": [{
                        "vm_disks": [{
                            "data_sources": [{
                                "references": [{
                                    "image_references": [{
                                        "image_ext_id": "59ec786c-4311-4225-affe-68b65c5ebf10",
                                    }],
                                }],
                            }],
                            "disk_size_bytes": 20 * std.pow(base=1024,
                                exponent=3).result,
                        }],
                    }],
                },
                {
                    "disk_addresses": [{
                        "bus_type": "SCSI",
                        "index": 1,
                    }],
                    "backing_infos": [{
                        "vm_disks": [{
                            "disk_size_bytes": 10 * std.pow(base=1024,
                                exponent=3).result,
                            "storage_containers": [{
                                "ext_id": "5d9b5941-fec3-4996-9d31-f31bed1c7735",
                            }],
                        }],
                    }],
                },
                {
                    "disk_addresses": [{
                        "bus_type": "SCSI",
                        "index": 2,
                    }],
                    "backing_infos": [{
                        "vm_disks": [{
                            "disk_size_bytes": 15 * std.pow(base=1024,
                                exponent=3).result,
                            "storage_containers": [{
                                "ext_id": "5d9b5941-fec3-4996-9d31-f31bed1c7735",
                            }],
                        }],
                    }],
                },
                {
                    "disk_addresses": [{
                        "bus_type": "SCSI",
                        "index": 3,
                    }],
                    "backing_infos": [{
                        "vm_disks": [{
                            "disk_size_bytes": 20 * std.pow(base=1024,
                                exponent=3).result,
                            "storage_containers": [{
                                "ext_id": "5d9b5941-fec3-4996-9d31-f31bed1c7735",
                            }],
                        }],
                    }],
                },
            ],
            nics=[{
                "network_infos": [{
                    "nic_type": "NORMAL_NIC",
                    "subnets": [{
                        "ext_id": "7f66e20f-67f4-473f-96bb-c4fcfd487f16",
                    }],
                    "vlan_mode": "ACCESS",
                }],
            }],
            boot_configs=[{
                "legacy_boots": [{
                    "boot_orders": [
                        "CDROM",
                        "DISK",
                        "NETWORK",
                    ],
                }],
            }],
            power_state="ON")
        ```

        :param str resource_name: The name of the resource.
        :param VirtualMachineV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualMachineV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apc_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2ApcConfigArgs', 'VirtualMachineV2ApcConfigArgsDict']]]]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2AvailabilityZoneArgs', 'VirtualMachineV2AvailabilityZoneArgsDict']]]]] = None,
                 bios_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2BootConfigArgs', 'VirtualMachineV2BootConfigArgsDict']]]]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2CategoryArgs', 'VirtualMachineV2CategoryArgsDict']]]]] = None,
                 cd_roms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2CdRomArgs', 'VirtualMachineV2CdRomArgsDict']]]]] = None,
                 clusters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2ClusterArgs', 'VirtualMachineV2ClusterArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2DiskArgs', 'VirtualMachineV2DiskArgsDict']]]]] = None,
                 enabled_cpu_features: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 generation_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 gpuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2GpusArgs', 'VirtualMachineV2GpusArgsDict']]]]] = None,
                 guest_customizations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2GuestCustomizationArgs', 'VirtualMachineV2GuestCustomizationArgsDict']]]]] = None,
                 guest_tools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2GuestToolArgs', 'VirtualMachineV2GuestToolArgsDict']]]]] = None,
                 hardware_clock_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2HostArgs', 'VirtualMachineV2HostArgsDict']]]]] = None,
                 is_agent_vm: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_branding_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_cpu_hotplug_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_cpu_passthrough_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_gpu_console_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_memory_overcommit_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_scsi_controller_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_vcpu_hard_pinning_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_vga_console_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_size_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2NicArgs', 'VirtualMachineV2NicArgsDict']]]]] = None,
                 num_cores_per_socket: Optional[pulumi.Input[_builtins.int]] = None,
                 num_numa_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 num_sockets: Optional[pulumi.Input[_builtins.int]] = None,
                 num_threads_per_core: Optional[pulumi.Input[_builtins.int]] = None,
                 ownership_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2OwnershipInfoArgs', 'VirtualMachineV2OwnershipInfoArgsDict']]]]] = None,
                 power_state: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_policy_states: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2ProtectionPolicyStateArgs', 'VirtualMachineV2ProtectionPolicyStateArgsDict']]]]] = None,
                 protection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 serial_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2SerialPortArgs', 'VirtualMachineV2SerialPortArgsDict']]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2SourceArgs', 'VirtualMachineV2SourceArgsDict']]]]] = None,
                 storage_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2StorageConfigArgs', 'VirtualMachineV2StorageConfigArgsDict']]]]] = None,
                 vtpm_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2VtpmConfigArgs', 'VirtualMachineV2VtpmConfigArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualMachineV2Args.__new__(VirtualMachineV2Args)

            __props__.__dict__["apc_configs"] = apc_configs
            __props__.__dict__["availability_zones"] = availability_zones
            __props__.__dict__["bios_uuid"] = bios_uuid
            __props__.__dict__["boot_configs"] = boot_configs
            __props__.__dict__["categories"] = categories
            __props__.__dict__["cd_roms"] = cd_roms
            __props__.__dict__["clusters"] = clusters
            __props__.__dict__["description"] = description
            __props__.__dict__["disks"] = disks
            __props__.__dict__["enabled_cpu_features"] = enabled_cpu_features
            __props__.__dict__["generation_uuid"] = generation_uuid
            __props__.__dict__["gpuses"] = gpuses
            __props__.__dict__["guest_customizations"] = guest_customizations
            __props__.__dict__["guest_tools"] = guest_tools
            __props__.__dict__["hardware_clock_timezone"] = hardware_clock_timezone
            __props__.__dict__["hosts"] = hosts
            __props__.__dict__["is_agent_vm"] = is_agent_vm
            __props__.__dict__["is_branding_enabled"] = is_branding_enabled
            __props__.__dict__["is_cpu_hotplug_enabled"] = is_cpu_hotplug_enabled
            __props__.__dict__["is_cpu_passthrough_enabled"] = is_cpu_passthrough_enabled
            __props__.__dict__["is_gpu_console_enabled"] = is_gpu_console_enabled
            __props__.__dict__["is_memory_overcommit_enabled"] = is_memory_overcommit_enabled
            __props__.__dict__["is_scsi_controller_enabled"] = is_scsi_controller_enabled
            __props__.__dict__["is_vcpu_hard_pinning_enabled"] = is_vcpu_hard_pinning_enabled
            __props__.__dict__["is_vga_console_enabled"] = is_vga_console_enabled
            __props__.__dict__["machine_type"] = machine_type
            __props__.__dict__["memory_size_bytes"] = memory_size_bytes
            __props__.__dict__["name"] = name
            __props__.__dict__["nics"] = nics
            __props__.__dict__["num_cores_per_socket"] = num_cores_per_socket
            __props__.__dict__["num_numa_nodes"] = num_numa_nodes
            __props__.__dict__["num_sockets"] = num_sockets
            __props__.__dict__["num_threads_per_core"] = num_threads_per_core
            __props__.__dict__["ownership_infos"] = ownership_infos
            __props__.__dict__["power_state"] = power_state
            __props__.__dict__["protection_policy_states"] = protection_policy_states
            __props__.__dict__["protection_type"] = protection_type
            __props__.__dict__["serial_ports"] = serial_ports
            __props__.__dict__["sources"] = sources
            __props__.__dict__["storage_configs"] = storage_configs
            __props__.__dict__["vtpm_configs"] = vtpm_configs
            __props__.__dict__["create_time"] = None
            __props__.__dict__["ext_id"] = None
            __props__.__dict__["update_time"] = None
        super(VirtualMachineV2, __self__).__init__(
            'nutanix:index/virtualMachineV2:VirtualMachineV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apc_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2ApcConfigArgs', 'VirtualMachineV2ApcConfigArgsDict']]]]] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2AvailabilityZoneArgs', 'VirtualMachineV2AvailabilityZoneArgsDict']]]]] = None,
            bios_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            boot_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2BootConfigArgs', 'VirtualMachineV2BootConfigArgsDict']]]]] = None,
            categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2CategoryArgs', 'VirtualMachineV2CategoryArgsDict']]]]] = None,
            cd_roms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2CdRomArgs', 'VirtualMachineV2CdRomArgsDict']]]]] = None,
            clusters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2ClusterArgs', 'VirtualMachineV2ClusterArgsDict']]]]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2DiskArgs', 'VirtualMachineV2DiskArgsDict']]]]] = None,
            enabled_cpu_features: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            generation_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            gpuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2GpusArgs', 'VirtualMachineV2GpusArgsDict']]]]] = None,
            guest_customizations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2GuestCustomizationArgs', 'VirtualMachineV2GuestCustomizationArgsDict']]]]] = None,
            guest_tools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2GuestToolArgs', 'VirtualMachineV2GuestToolArgsDict']]]]] = None,
            hardware_clock_timezone: Optional[pulumi.Input[_builtins.str]] = None,
            hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2HostArgs', 'VirtualMachineV2HostArgsDict']]]]] = None,
            is_agent_vm: Optional[pulumi.Input[_builtins.bool]] = None,
            is_branding_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_cpu_hotplug_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_cpu_passthrough_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_gpu_console_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_memory_overcommit_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_scsi_controller_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_vcpu_hard_pinning_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_vga_console_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            machine_type: Optional[pulumi.Input[_builtins.str]] = None,
            memory_size_bytes: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2NicArgs', 'VirtualMachineV2NicArgsDict']]]]] = None,
            num_cores_per_socket: Optional[pulumi.Input[_builtins.int]] = None,
            num_numa_nodes: Optional[pulumi.Input[_builtins.int]] = None,
            num_sockets: Optional[pulumi.Input[_builtins.int]] = None,
            num_threads_per_core: Optional[pulumi.Input[_builtins.int]] = None,
            ownership_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2OwnershipInfoArgs', 'VirtualMachineV2OwnershipInfoArgsDict']]]]] = None,
            power_state: Optional[pulumi.Input[_builtins.str]] = None,
            protection_policy_states: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2ProtectionPolicyStateArgs', 'VirtualMachineV2ProtectionPolicyStateArgsDict']]]]] = None,
            protection_type: Optional[pulumi.Input[_builtins.str]] = None,
            serial_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2SerialPortArgs', 'VirtualMachineV2SerialPortArgsDict']]]]] = None,
            sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2SourceArgs', 'VirtualMachineV2SourceArgsDict']]]]] = None,
            storage_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2StorageConfigArgs', 'VirtualMachineV2StorageConfigArgsDict']]]]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None,
            vtpm_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2VtpmConfigArgs', 'VirtualMachineV2VtpmConfigArgsDict']]]]] = None) -> 'VirtualMachineV2':
        """
        Get an existing VirtualMachineV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2ApcConfigArgs', 'VirtualMachineV2ApcConfigArgsDict']]]] apc_configs: Advanced Processor Compatibility configuration for the VM. Enabling this retains the CPU model for the VM across power cycles and migrations.
        :param pulumi.Input[_builtins.str] bios_uuid: BIOS UUID of the VM. It should be of type UUID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2BootConfigArgs', 'VirtualMachineV2BootConfigArgsDict']]]] boot_configs: Indicates the order of device types in which the VM should try to boot from. If the boot device order is not provided the system will decide an appropriate boot device order.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2CategoryArgs', 'VirtualMachineV2CategoryArgsDict']]]] categories: Categories for the VM.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2CdRomArgs', 'VirtualMachineV2CdRomArgsDict']]]] cd_roms: CD-ROMs attached to the VM.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2ClusterArgs', 'VirtualMachineV2ClusterArgsDict']]]] clusters: Reference to a cluster.
        :param pulumi.Input[_builtins.str] create_time: VM creation time
        :param pulumi.Input[_builtins.str] description: VM description
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2DiskArgs', 'VirtualMachineV2DiskArgsDict']]]] disks: Disks attached to the VM.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_cpu_features: The list of additional CPU features to be enabled. HardwareVirtualization: Indicates whether hardware assisted virtualization should be enabled for the Guest OS or not. Once enabled, the Guest OS can deploy a nested hypervisor. Valid values are "HARDWARE_VIRTUALIZATION".
        :param pulumi.Input[_builtins.str] ext_id: A globally unique identifier of an instance that is suitable for external consumption.
        :param pulumi.Input[_builtins.str] generation_uuid: Generation UUID of the VM. It should be of type UUID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2GpusArgs', 'VirtualMachineV2GpusArgsDict']]]] gpuses: GPUs attached to the VM.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2GuestCustomizationArgs', 'VirtualMachineV2GuestCustomizationArgsDict']]]] guest_customizations: Stage a Sysprep or cloud-init configuration file to be used by the guest for the next boot. Note that the Sysprep command must be used to generalize the Windows VMs before triggering this API call.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2GuestToolArgs', 'VirtualMachineV2GuestToolArgsDict']]]] guest_tools: The details about Nutanix Guest Tools for a VM.
        :param pulumi.Input[_builtins.str] hardware_clock_timezone: VM hardware clock timezone in IANA TZDB format (America/Los_Angeles).
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2HostArgs', 'VirtualMachineV2HostArgsDict']]]] hosts: Reference to the host, the VM is running on.
        :param pulumi.Input[_builtins.bool] is_agent_vm: Indicates whether the VM is an agent VM or not. When their host enters maintenance mode, once the normal VMs are evacuated, the agent VMs are powered off. When the host is restored, agent VMs are powered on before the normal VMs are restored. In other words, agent VMs cannot be HA-protected or live migrated.
        :param pulumi.Input[_builtins.bool] is_branding_enabled: Indicates whether to remove AHV branding from VM firmware tables or not.
        :param pulumi.Input[_builtins.bool] is_cpu_hotplug_enabled: Indicates whether the VM CPU hotplug is enabled.
        :param pulumi.Input[_builtins.bool] is_cpu_passthrough_enabled: Indicates whether to passthrough the host CPU features to the guest or not. Enabling this will make VM incapable of live migration.
        :param pulumi.Input[_builtins.bool] is_gpu_console_enabled: Indicates whether the vGPU console is enabled or not.
        :param pulumi.Input[_builtins.bool] is_memory_overcommit_enabled: Indicates whether the memory overcommit feature should be enabled for the VM or not. If enabled, parts of the VM memory may reside outside of the hypervisor physical memory. Once enabled, it should be expected that the VM may suffer performance degradation.
        :param pulumi.Input[_builtins.bool] is_scsi_controller_enabled: Indicates whether the VM SCSI controller is enabled.
        :param pulumi.Input[_builtins.bool] is_vcpu_hard_pinning_enabled: Indicates whether the vCPUs should be hard pinned to specific pCPUs or not.
        :param pulumi.Input[_builtins.bool] is_vga_console_enabled: Indicates whether the VGA console should be disabled or not.
        :param pulumi.Input[_builtins.str] machine_type: Machine type for the VM. Machine type Q35 is required for secure boot and does not support IDE disks. Valid values are "PSERIES", "Q35", "PC" .
        :param pulumi.Input[_builtins.int] memory_size_bytes: Memory size in bytes.
        :param pulumi.Input[_builtins.str] name: VM name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2NicArgs', 'VirtualMachineV2NicArgsDict']]]] nics: NICs attached to the VM.
        :param pulumi.Input[_builtins.int] num_cores_per_socket: Number of cores per socket. Value should be at least 1.
        :param pulumi.Input[_builtins.int] num_numa_nodes: Number of NUMA nodes. 0 means NUMA is disabled.
        :param pulumi.Input[_builtins.int] num_sockets: Number of vCPU sockets. Value should be at least 1.
        :param pulumi.Input[_builtins.int] num_threads_per_core: Number of threads per core. Value should be at least 1.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2OwnershipInfoArgs', 'VirtualMachineV2OwnershipInfoArgsDict']]]] ownership_infos: Ownership information for the VM.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2ProtectionPolicyStateArgs', 'VirtualMachineV2ProtectionPolicyStateArgsDict']]]] protection_policy_states: Status of protection policy applied to this VM.
        :param pulumi.Input[_builtins.str] protection_type: The type of protection applied on a VM. Valid values "PD_PROTECTED", "UNPROTECTED", "RULE_PROTECTED".
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2SerialPortArgs', 'VirtualMachineV2SerialPortArgsDict']]]] serial_ports: Serial ports configured on the VM.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2SourceArgs', 'VirtualMachineV2SourceArgsDict']]]] sources: Reference to an entity that the VM should be cloned or created from. Valid values are "VM", "VM_RECOVERY_POINT".
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2StorageConfigArgs', 'VirtualMachineV2StorageConfigArgsDict']]]] storage_configs: Storage configuration for VM.
        :param pulumi.Input[_builtins.str] update_time: VM last updated time.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineV2VtpmConfigArgs', 'VirtualMachineV2VtpmConfigArgsDict']]]] vtpm_configs: Indicates how the vTPM for the VM should be configured.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualMachineV2State.__new__(_VirtualMachineV2State)

        __props__.__dict__["apc_configs"] = apc_configs
        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["bios_uuid"] = bios_uuid
        __props__.__dict__["boot_configs"] = boot_configs
        __props__.__dict__["categories"] = categories
        __props__.__dict__["cd_roms"] = cd_roms
        __props__.__dict__["clusters"] = clusters
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["disks"] = disks
        __props__.__dict__["enabled_cpu_features"] = enabled_cpu_features
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["generation_uuid"] = generation_uuid
        __props__.__dict__["gpuses"] = gpuses
        __props__.__dict__["guest_customizations"] = guest_customizations
        __props__.__dict__["guest_tools"] = guest_tools
        __props__.__dict__["hardware_clock_timezone"] = hardware_clock_timezone
        __props__.__dict__["hosts"] = hosts
        __props__.__dict__["is_agent_vm"] = is_agent_vm
        __props__.__dict__["is_branding_enabled"] = is_branding_enabled
        __props__.__dict__["is_cpu_hotplug_enabled"] = is_cpu_hotplug_enabled
        __props__.__dict__["is_cpu_passthrough_enabled"] = is_cpu_passthrough_enabled
        __props__.__dict__["is_gpu_console_enabled"] = is_gpu_console_enabled
        __props__.__dict__["is_memory_overcommit_enabled"] = is_memory_overcommit_enabled
        __props__.__dict__["is_scsi_controller_enabled"] = is_scsi_controller_enabled
        __props__.__dict__["is_vcpu_hard_pinning_enabled"] = is_vcpu_hard_pinning_enabled
        __props__.__dict__["is_vga_console_enabled"] = is_vga_console_enabled
        __props__.__dict__["machine_type"] = machine_type
        __props__.__dict__["memory_size_bytes"] = memory_size_bytes
        __props__.__dict__["name"] = name
        __props__.__dict__["nics"] = nics
        __props__.__dict__["num_cores_per_socket"] = num_cores_per_socket
        __props__.__dict__["num_numa_nodes"] = num_numa_nodes
        __props__.__dict__["num_sockets"] = num_sockets
        __props__.__dict__["num_threads_per_core"] = num_threads_per_core
        __props__.__dict__["ownership_infos"] = ownership_infos
        __props__.__dict__["power_state"] = power_state
        __props__.__dict__["protection_policy_states"] = protection_policy_states
        __props__.__dict__["protection_type"] = protection_type
        __props__.__dict__["serial_ports"] = serial_ports
        __props__.__dict__["sources"] = sources
        __props__.__dict__["storage_configs"] = storage_configs
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["vtpm_configs"] = vtpm_configs
        return VirtualMachineV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apcConfigs")
    def apc_configs(self) -> pulumi.Output[Sequence['outputs.VirtualMachineV2ApcConfig']]:
        """
        Advanced Processor Compatibility configuration for the VM. Enabling this retains the CPU model for the VM across power cycles and migrations.
        """
        return pulumi.get(self, "apc_configs")

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Sequence['outputs.VirtualMachineV2AvailabilityZone']]:
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter(name="biosUuid")
    def bios_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        BIOS UUID of the VM. It should be of type UUID.
        """
        return pulumi.get(self, "bios_uuid")

    @_builtins.property
    @pulumi.getter(name="bootConfigs")
    def boot_configs(self) -> pulumi.Output[Sequence['outputs.VirtualMachineV2BootConfig']]:
        """
        Indicates the order of device types in which the VM should try to boot from. If the boot device order is not provided the system will decide an appropriate boot device order.
        """
        return pulumi.get(self, "boot_configs")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> pulumi.Output[Sequence['outputs.VirtualMachineV2Category']]:
        """
        Categories for the VM.
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter(name="cdRoms")
    def cd_roms(self) -> pulumi.Output[Optional[Sequence['outputs.VirtualMachineV2CdRom']]]:
        """
        CD-ROMs attached to the VM.
        """
        return pulumi.get(self, "cd_roms")

    @_builtins.property
    @pulumi.getter
    def clusters(self) -> pulumi.Output[Sequence['outputs.VirtualMachineV2Cluster']]:
        """
        Reference to a cluster.
        """
        return pulumi.get(self, "clusters")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        VM creation time
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        VM description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def disks(self) -> pulumi.Output[Optional[Sequence['outputs.VirtualMachineV2Disk']]]:
        """
        Disks attached to the VM.
        """
        return pulumi.get(self, "disks")

    @_builtins.property
    @pulumi.getter(name="enabledCpuFeatures")
    def enabled_cpu_features(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of additional CPU features to be enabled. HardwareVirtualization: Indicates whether hardware assisted virtualization should be enabled for the Guest OS or not. Once enabled, the Guest OS can deploy a nested hypervisor. Valid values are "HARDWARE_VIRTUALIZATION".
        """
        return pulumi.get(self, "enabled_cpu_features")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="generationUuid")
    def generation_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        Generation UUID of the VM. It should be of type UUID.
        """
        return pulumi.get(self, "generation_uuid")

    @_builtins.property
    @pulumi.getter
    def gpuses(self) -> pulumi.Output[Optional[Sequence['outputs.VirtualMachineV2Gpus']]]:
        """
        GPUs attached to the VM.
        """
        return pulumi.get(self, "gpuses")

    @_builtins.property
    @pulumi.getter(name="guestCustomizations")
    def guest_customizations(self) -> pulumi.Output[Sequence['outputs.VirtualMachineV2GuestCustomization']]:
        """
        Stage a Sysprep or cloud-init configuration file to be used by the guest for the next boot. Note that the Sysprep command must be used to generalize the Windows VMs before triggering this API call.
        """
        return pulumi.get(self, "guest_customizations")

    @_builtins.property
    @pulumi.getter(name="guestTools")
    def guest_tools(self) -> pulumi.Output[Optional[Sequence['outputs.VirtualMachineV2GuestTool']]]:
        """
        The details about Nutanix Guest Tools for a VM.
        """
        return pulumi.get(self, "guest_tools")

    @_builtins.property
    @pulumi.getter(name="hardwareClockTimezone")
    def hardware_clock_timezone(self) -> pulumi.Output[_builtins.str]:
        """
        VM hardware clock timezone in IANA TZDB format (America/Los_Angeles).
        """
        return pulumi.get(self, "hardware_clock_timezone")

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> pulumi.Output[Sequence['outputs.VirtualMachineV2Host']]:
        """
        Reference to the host, the VM is running on.
        """
        return pulumi.get(self, "hosts")

    @_builtins.property
    @pulumi.getter(name="isAgentVm")
    def is_agent_vm(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the VM is an agent VM or not. When their host enters maintenance mode, once the normal VMs are evacuated, the agent VMs are powered off. When the host is restored, agent VMs are powered on before the normal VMs are restored. In other words, agent VMs cannot be HA-protected or live migrated.
        """
        return pulumi.get(self, "is_agent_vm")

    @_builtins.property
    @pulumi.getter(name="isBrandingEnabled")
    def is_branding_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether to remove AHV branding from VM firmware tables or not.
        """
        return pulumi.get(self, "is_branding_enabled")

    @_builtins.property
    @pulumi.getter(name="isCpuHotplugEnabled")
    def is_cpu_hotplug_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the VM CPU hotplug is enabled.
        """
        return pulumi.get(self, "is_cpu_hotplug_enabled")

    @_builtins.property
    @pulumi.getter(name="isCpuPassthroughEnabled")
    def is_cpu_passthrough_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether to passthrough the host CPU features to the guest or not. Enabling this will make VM incapable of live migration.
        """
        return pulumi.get(self, "is_cpu_passthrough_enabled")

    @_builtins.property
    @pulumi.getter(name="isGpuConsoleEnabled")
    def is_gpu_console_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the vGPU console is enabled or not.
        """
        return pulumi.get(self, "is_gpu_console_enabled")

    @_builtins.property
    @pulumi.getter(name="isMemoryOvercommitEnabled")
    def is_memory_overcommit_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the memory overcommit feature should be enabled for the VM or not. If enabled, parts of the VM memory may reside outside of the hypervisor physical memory. Once enabled, it should be expected that the VM may suffer performance degradation.
        """
        return pulumi.get(self, "is_memory_overcommit_enabled")

    @_builtins.property
    @pulumi.getter(name="isScsiControllerEnabled")
    def is_scsi_controller_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the VM SCSI controller is enabled.
        """
        return pulumi.get(self, "is_scsi_controller_enabled")

    @_builtins.property
    @pulumi.getter(name="isVcpuHardPinningEnabled")
    def is_vcpu_hard_pinning_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the vCPUs should be hard pinned to specific pCPUs or not.
        """
        return pulumi.get(self, "is_vcpu_hard_pinning_enabled")

    @_builtins.property
    @pulumi.getter(name="isVgaConsoleEnabled")
    def is_vga_console_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the VGA console should be disabled or not.
        """
        return pulumi.get(self, "is_vga_console_enabled")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> pulumi.Output[_builtins.str]:
        """
        Machine type for the VM. Machine type Q35 is required for secure boot and does not support IDE disks. Valid values are "PSERIES", "Q35", "PC" .
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter(name="memorySizeBytes")
    def memory_size_bytes(self) -> pulumi.Output[_builtins.int]:
        """
        Memory size in bytes.
        """
        return pulumi.get(self, "memory_size_bytes")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        VM name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def nics(self) -> pulumi.Output[Optional[Sequence['outputs.VirtualMachineV2Nic']]]:
        """
        NICs attached to the VM.
        """
        return pulumi.get(self, "nics")

    @_builtins.property
    @pulumi.getter(name="numCoresPerSocket")
    def num_cores_per_socket(self) -> pulumi.Output[_builtins.int]:
        """
        Number of cores per socket. Value should be at least 1.
        """
        return pulumi.get(self, "num_cores_per_socket")

    @_builtins.property
    @pulumi.getter(name="numNumaNodes")
    def num_numa_nodes(self) -> pulumi.Output[_builtins.int]:
        """
        Number of NUMA nodes. 0 means NUMA is disabled.
        """
        return pulumi.get(self, "num_numa_nodes")

    @_builtins.property
    @pulumi.getter(name="numSockets")
    def num_sockets(self) -> pulumi.Output[_builtins.int]:
        """
        Number of vCPU sockets. Value should be at least 1.
        """
        return pulumi.get(self, "num_sockets")

    @_builtins.property
    @pulumi.getter(name="numThreadsPerCore")
    def num_threads_per_core(self) -> pulumi.Output[_builtins.int]:
        """
        Number of threads per core. Value should be at least 1.
        """
        return pulumi.get(self, "num_threads_per_core")

    @_builtins.property
    @pulumi.getter(name="ownershipInfos")
    def ownership_infos(self) -> pulumi.Output[Sequence['outputs.VirtualMachineV2OwnershipInfo']]:
        """
        Ownership information for the VM.
        """
        return pulumi.get(self, "ownership_infos")

    @_builtins.property
    @pulumi.getter(name="powerState")
    def power_state(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "power_state")

    @_builtins.property
    @pulumi.getter(name="protectionPolicyStates")
    def protection_policy_states(self) -> pulumi.Output[Sequence['outputs.VirtualMachineV2ProtectionPolicyState']]:
        """
        Status of protection policy applied to this VM.
        """
        return pulumi.get(self, "protection_policy_states")

    @_builtins.property
    @pulumi.getter(name="protectionType")
    def protection_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of protection applied on a VM. Valid values "PD_PROTECTED", "UNPROTECTED", "RULE_PROTECTED".
        """
        return pulumi.get(self, "protection_type")

    @_builtins.property
    @pulumi.getter(name="serialPorts")
    def serial_ports(self) -> pulumi.Output[Sequence['outputs.VirtualMachineV2SerialPort']]:
        """
        Serial ports configured on the VM.
        """
        return pulumi.get(self, "serial_ports")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> pulumi.Output[Sequence['outputs.VirtualMachineV2Source']]:
        """
        Reference to an entity that the VM should be cloned or created from. Valid values are "VM", "VM_RECOVERY_POINT".
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter(name="storageConfigs")
    def storage_configs(self) -> pulumi.Output[Sequence['outputs.VirtualMachineV2StorageConfig']]:
        """
        Storage configuration for VM.
        """
        return pulumi.get(self, "storage_configs")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        VM last updated time.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="vtpmConfigs")
    def vtpm_configs(self) -> pulumi.Output[Sequence['outputs.VirtualMachineV2VtpmConfig']]:
        """
        Indicates how the vTPM for the VM should be configured.
        """
        return pulumi.get(self, "vtpm_configs")

