# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['VmRevertV2Args', 'VmRevertV2']

@pulumi.input_type
class VmRevertV2Args:
    def __init__(__self__, *,
                 ext_id: pulumi.Input[_builtins.str],
                 vm_recovery_point_ext_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a VmRevertV2 resource.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) The globally unique identifier of a VM. It should be of type UUID.
        :param pulumi.Input[_builtins.str] vm_recovery_point_ext_id: -(Required) The external identifier of the VM Recovery Point.
        """
        pulumi.set(__self__, "ext_id", ext_id)
        pulumi.set(__self__, "vm_recovery_point_ext_id", vm_recovery_point_ext_id)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) The globally unique identifier of a VM. It should be of type UUID.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="vmRecoveryPointExtId")
    def vm_recovery_point_ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) The external identifier of the VM Recovery Point.
        """
        return pulumi.get(self, "vm_recovery_point_ext_id")

    @vm_recovery_point_ext_id.setter
    def vm_recovery_point_ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vm_recovery_point_ext_id", value)


@pulumi.input_type
class _VmRevertV2State:
    def __init__(__self__, *,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_recovery_point_ext_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VmRevertV2 resources.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) The globally unique identifier of a VM. It should be of type UUID.
        :param pulumi.Input[_builtins.str] status: - The status of the Revert operation.
        :param pulumi.Input[_builtins.str] vm_recovery_point_ext_id: -(Required) The external identifier of the VM Recovery Point.
        """
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vm_recovery_point_ext_id is not None:
            pulumi.set(__self__, "vm_recovery_point_ext_id", vm_recovery_point_ext_id)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) The globally unique identifier of a VM. It should be of type UUID.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The status of the Revert operation.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="vmRecoveryPointExtId")
    def vm_recovery_point_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) The external identifier of the VM Recovery Point.
        """
        return pulumi.get(self, "vm_recovery_point_ext_id")

    @vm_recovery_point_ext_id.setter
    def vm_recovery_point_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_recovery_point_ext_id", value)


@pulumi.type_token("nutanix:index/vmRevertV2:VmRevertV2")
class VmRevertV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_recovery_point_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This operation Revert VM identified by {extId}. This does an in-place VM restore from a specified VM Recovery Point.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # revert Vm
        example = nutanix.VmRevertV2("example",
            ext_id="8a938cc5-282b-48c4-81be-de22de145d07",
            vm_recovery_point_ext_id="c2c249b0-98a0-43fa-9ff6-dcde578d3936")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) The globally unique identifier of a VM. It should be of type UUID.
        :param pulumi.Input[_builtins.str] vm_recovery_point_ext_id: -(Required) The external identifier of the VM Recovery Point.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VmRevertV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This operation Revert VM identified by {extId}. This does an in-place VM restore from a specified VM Recovery Point.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # revert Vm
        example = nutanix.VmRevertV2("example",
            ext_id="8a938cc5-282b-48c4-81be-de22de145d07",
            vm_recovery_point_ext_id="c2c249b0-98a0-43fa-9ff6-dcde578d3936")
        ```

        :param str resource_name: The name of the resource.
        :param VmRevertV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VmRevertV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_recovery_point_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VmRevertV2Args.__new__(VmRevertV2Args)

            if ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'ext_id'")
            __props__.__dict__["ext_id"] = ext_id
            if vm_recovery_point_ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'vm_recovery_point_ext_id'")
            __props__.__dict__["vm_recovery_point_ext_id"] = vm_recovery_point_ext_id
            __props__.__dict__["status"] = None
        super(VmRevertV2, __self__).__init__(
            'nutanix:index/vmRevertV2:VmRevertV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            vm_recovery_point_ext_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'VmRevertV2':
        """
        Get an existing VmRevertV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) The globally unique identifier of a VM. It should be of type UUID.
        :param pulumi.Input[_builtins.str] status: - The status of the Revert operation.
        :param pulumi.Input[_builtins.str] vm_recovery_point_ext_id: -(Required) The external identifier of the VM Recovery Point.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VmRevertV2State.__new__(_VmRevertV2State)

        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["status"] = status
        __props__.__dict__["vm_recovery_point_ext_id"] = vm_recovery_point_ext_id
        return VmRevertV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) The globally unique identifier of a VM. It should be of type UUID.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        - The status of the Revert operation.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vmRecoveryPointExtId")
    def vm_recovery_point_ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) The external identifier of the VM Recovery Point.
        """
        return pulumi.get(self, "vm_recovery_point_ext_id")

