# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VmShutdownActionV2Args', 'VmShutdownActionV2']

@pulumi.input_type
class VmShutdownActionV2Args:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 ext_id: pulumi.Input[_builtins.str],
                 guest_power_state_transition_configs: Optional[pulumi.Input[Sequence[pulumi.Input['VmShutdownActionV2GuestPowerStateTransitionConfigArgs']]]] = None):
        """
        The set of arguments for constructing a VmShutdownActionV2 resource.
        :param pulumi.Input[_builtins.str] action: It supports "shutdown", "guest_shutdown", "reboot", "guest_reboot".
        :param pulumi.Input[_builtins.str] ext_id: The globally unique identifier of a VM. It should be of type UUID.
        :param pulumi.Input[Sequence[pulumi.Input['VmShutdownActionV2GuestPowerStateTransitionConfigArgs']]] guest_power_state_transition_configs: Additional configuration for Nutanix Gust Tools power state transition. It should be only used with `guest_shutdown` or `guest_reboot`.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "ext_id", ext_id)
        if guest_power_state_transition_configs is not None:
            pulumi.set(__self__, "guest_power_state_transition_configs", guest_power_state_transition_configs)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        It supports "shutdown", "guest_shutdown", "reboot", "guest_reboot".
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        The globally unique identifier of a VM. It should be of type UUID.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="guestPowerStateTransitionConfigs")
    def guest_power_state_transition_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VmShutdownActionV2GuestPowerStateTransitionConfigArgs']]]]:
        """
        Additional configuration for Nutanix Gust Tools power state transition. It should be only used with `guest_shutdown` or `guest_reboot`.
        """
        return pulumi.get(self, "guest_power_state_transition_configs")

    @guest_power_state_transition_configs.setter
    def guest_power_state_transition_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VmShutdownActionV2GuestPowerStateTransitionConfigArgs']]]]):
        pulumi.set(self, "guest_power_state_transition_configs", value)


@pulumi.input_type
class _VmShutdownActionV2State:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 guest_power_state_transition_configs: Optional[pulumi.Input[Sequence[pulumi.Input['VmShutdownActionV2GuestPowerStateTransitionConfigArgs']]]] = None):
        """
        Input properties used for looking up and filtering VmShutdownActionV2 resources.
        :param pulumi.Input[_builtins.str] action: It supports "shutdown", "guest_shutdown", "reboot", "guest_reboot".
        :param pulumi.Input[_builtins.str] ext_id: The globally unique identifier of a VM. It should be of type UUID.
        :param pulumi.Input[Sequence[pulumi.Input['VmShutdownActionV2GuestPowerStateTransitionConfigArgs']]] guest_power_state_transition_configs: Additional configuration for Nutanix Gust Tools power state transition. It should be only used with `guest_shutdown` or `guest_reboot`.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if guest_power_state_transition_configs is not None:
            pulumi.set(__self__, "guest_power_state_transition_configs", guest_power_state_transition_configs)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It supports "shutdown", "guest_shutdown", "reboot", "guest_reboot".
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The globally unique identifier of a VM. It should be of type UUID.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="guestPowerStateTransitionConfigs")
    def guest_power_state_transition_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VmShutdownActionV2GuestPowerStateTransitionConfigArgs']]]]:
        """
        Additional configuration for Nutanix Gust Tools power state transition. It should be only used with `guest_shutdown` or `guest_reboot`.
        """
        return pulumi.get(self, "guest_power_state_transition_configs")

    @guest_power_state_transition_configs.setter
    def guest_power_state_transition_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VmShutdownActionV2GuestPowerStateTransitionConfigArgs']]]]):
        pulumi.set(self, "guest_power_state_transition_configs", value)


@pulumi.type_token("nutanix:index/vmShutdownActionV2:VmShutdownActionV2")
class VmShutdownActionV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 guest_power_state_transition_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmShutdownActionV2GuestPowerStateTransitionConfigArgs', 'VmShutdownActionV2GuestPowerStateTransitionConfigArgsDict']]]]] = None,
                 __props__=None):
        """
        Collaborative reboot or shutdown of a Virtual Machine through the ACPI support in the operating system. Also, Collaborative reboot or shutdown of a Virtual Machine, requesting Nutanix Guest Tools to trigger a reboot or shutdown from within the VM.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: It supports "shutdown", "guest_shutdown", "reboot", "guest_reboot".
        :param pulumi.Input[_builtins.str] ext_id: The globally unique identifier of a VM. It should be of type UUID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VmShutdownActionV2GuestPowerStateTransitionConfigArgs', 'VmShutdownActionV2GuestPowerStateTransitionConfigArgsDict']]]] guest_power_state_transition_configs: Additional configuration for Nutanix Gust Tools power state transition. It should be only used with `guest_shutdown` or `guest_reboot`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VmShutdownActionV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Collaborative reboot or shutdown of a Virtual Machine through the ACPI support in the operating system. Also, Collaborative reboot or shutdown of a Virtual Machine, requesting Nutanix Guest Tools to trigger a reboot or shutdown from within the VM.

        :param str resource_name: The name of the resource.
        :param VmShutdownActionV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VmShutdownActionV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 guest_power_state_transition_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmShutdownActionV2GuestPowerStateTransitionConfigArgs', 'VmShutdownActionV2GuestPowerStateTransitionConfigArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VmShutdownActionV2Args.__new__(VmShutdownActionV2Args)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            if ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'ext_id'")
            __props__.__dict__["ext_id"] = ext_id
            __props__.__dict__["guest_power_state_transition_configs"] = guest_power_state_transition_configs
        super(VmShutdownActionV2, __self__).__init__(
            'nutanix:index/vmShutdownActionV2:VmShutdownActionV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[_builtins.str]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            guest_power_state_transition_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmShutdownActionV2GuestPowerStateTransitionConfigArgs', 'VmShutdownActionV2GuestPowerStateTransitionConfigArgsDict']]]]] = None) -> 'VmShutdownActionV2':
        """
        Get an existing VmShutdownActionV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: It supports "shutdown", "guest_shutdown", "reboot", "guest_reboot".
        :param pulumi.Input[_builtins.str] ext_id: The globally unique identifier of a VM. It should be of type UUID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VmShutdownActionV2GuestPowerStateTransitionConfigArgs', 'VmShutdownActionV2GuestPowerStateTransitionConfigArgsDict']]]] guest_power_state_transition_configs: Additional configuration for Nutanix Gust Tools power state transition. It should be only used with `guest_shutdown` or `guest_reboot`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VmShutdownActionV2State.__new__(_VmShutdownActionV2State)

        __props__.__dict__["action"] = action
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["guest_power_state_transition_configs"] = guest_power_state_transition_configs
        return VmShutdownActionV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[_builtins.str]:
        """
        It supports "shutdown", "guest_shutdown", "reboot", "guest_reboot".
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        The globally unique identifier of a VM. It should be of type UUID.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="guestPowerStateTransitionConfigs")
    def guest_power_state_transition_configs(self) -> pulumi.Output[Optional[Sequence['outputs.VmShutdownActionV2GuestPowerStateTransitionConfig']]]:
        """
        Additional configuration for Nutanix Gust Tools power state transition. It should be only used with `guest_shutdown` or `guest_reboot`.
        """
        return pulumi.get(self, "guest_power_state_transition_configs")

