# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VolumeGroupDiskV2Args', 'VolumeGroupDiskV2']

@pulumi.input_type
class VolumeGroupDiskV2Args:
    def __init__(__self__, *,
                 disk_data_source_references: pulumi.Input[Sequence[pulumi.Input['VolumeGroupDiskV2DiskDataSourceReferenceArgs']]],
                 disk_size_bytes: pulumi.Input[_builtins.int],
                 volume_group_ext_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_storage_features: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupDiskV2DiskStorageFeatureArgs']]]] = None,
                 index: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a VolumeGroupDiskV2 resource.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeGroupDiskV2DiskDataSourceReferenceArgs']]] disk_data_source_references: -(Required) Disk Data Source Reference.
        :param pulumi.Input[_builtins.int] disk_size_bytes: - ize of the disk in bytes. This field is mandatory during Volume Group creation if a new disk is being created on the storage container.
        :param pulumi.Input[_builtins.str] volume_group_ext_id: The external identifier of the volume group.
        :param pulumi.Input[_builtins.str] description: - Volume Disk description.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeGroupDiskV2DiskStorageFeatureArgs']]] disk_storage_features: - Storage optimization features which must be enabled on the Volume Disks. This is an optional field. If omitted, the disks will honor the Volume Group specific storage features setting.
        :param pulumi.Input[_builtins.int] index: - Index of the disk in a Volume Group. This field is optional and immutable.
        """
        pulumi.set(__self__, "disk_data_source_references", disk_data_source_references)
        pulumi.set(__self__, "disk_size_bytes", disk_size_bytes)
        pulumi.set(__self__, "volume_group_ext_id", volume_group_ext_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_storage_features is not None:
            pulumi.set(__self__, "disk_storage_features", disk_storage_features)
        if index is not None:
            pulumi.set(__self__, "index", index)

    @_builtins.property
    @pulumi.getter(name="diskDataSourceReferences")
    def disk_data_source_references(self) -> pulumi.Input[Sequence[pulumi.Input['VolumeGroupDiskV2DiskDataSourceReferenceArgs']]]:
        """
        -(Required) Disk Data Source Reference.
        """
        return pulumi.get(self, "disk_data_source_references")

    @disk_data_source_references.setter
    def disk_data_source_references(self, value: pulumi.Input[Sequence[pulumi.Input['VolumeGroupDiskV2DiskDataSourceReferenceArgs']]]):
        pulumi.set(self, "disk_data_source_references", value)

    @_builtins.property
    @pulumi.getter(name="diskSizeBytes")
    def disk_size_bytes(self) -> pulumi.Input[_builtins.int]:
        """
        - ize of the disk in bytes. This field is mandatory during Volume Group creation if a new disk is being created on the storage container.
        """
        return pulumi.get(self, "disk_size_bytes")

    @disk_size_bytes.setter
    def disk_size_bytes(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "disk_size_bytes", value)

    @_builtins.property
    @pulumi.getter(name="volumeGroupExtId")
    def volume_group_ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        The external identifier of the volume group.
        """
        return pulumi.get(self, "volume_group_ext_id")

    @volume_group_ext_id.setter
    def volume_group_ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "volume_group_ext_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Volume Disk description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskStorageFeatures")
    def disk_storage_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupDiskV2DiskStorageFeatureArgs']]]]:
        """
        - Storage optimization features which must be enabled on the Volume Disks. This is an optional field. If omitted, the disks will honor the Volume Group specific storage features setting.
        """
        return pulumi.get(self, "disk_storage_features")

    @disk_storage_features.setter
    def disk_storage_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupDiskV2DiskStorageFeatureArgs']]]]):
        pulumi.set(self, "disk_storage_features", value)

    @_builtins.property
    @pulumi.getter
    def index(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - Index of the disk in a Volume Group. This field is optional and immutable.
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "index", value)


@pulumi.input_type
class _VolumeGroupDiskV2State:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_data_source_references: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupDiskV2DiskDataSourceReferenceArgs']]]] = None,
                 disk_size_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_storage_features: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupDiskV2DiskStorageFeatureArgs']]]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 index: Optional[pulumi.Input[_builtins.int]] = None,
                 volume_group_ext_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VolumeGroupDiskV2 resources.
        :param pulumi.Input[_builtins.str] description: - Volume Disk description.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeGroupDiskV2DiskDataSourceReferenceArgs']]] disk_data_source_references: -(Required) Disk Data Source Reference.
        :param pulumi.Input[_builtins.int] disk_size_bytes: - ize of the disk in bytes. This field is mandatory during Volume Group creation if a new disk is being created on the storage container.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeGroupDiskV2DiskStorageFeatureArgs']]] disk_storage_features: - Storage optimization features which must be enabled on the Volume Disks. This is an optional field. If omitted, the disks will honor the Volume Group specific storage features setting.
        :param pulumi.Input[_builtins.str] ext_id: - A globally unique identifier of an instance that is suitable for external consumption.
        :param pulumi.Input[_builtins.int] index: - Index of the disk in a Volume Group. This field is optional and immutable.
        :param pulumi.Input[_builtins.str] volume_group_ext_id: The external identifier of the volume group.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_data_source_references is not None:
            pulumi.set(__self__, "disk_data_source_references", disk_data_source_references)
        if disk_size_bytes is not None:
            pulumi.set(__self__, "disk_size_bytes", disk_size_bytes)
        if disk_storage_features is not None:
            pulumi.set(__self__, "disk_storage_features", disk_storage_features)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if index is not None:
            pulumi.set(__self__, "index", index)
        if volume_group_ext_id is not None:
            pulumi.set(__self__, "volume_group_ext_id", volume_group_ext_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Volume Disk description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskDataSourceReferences")
    def disk_data_source_references(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupDiskV2DiskDataSourceReferenceArgs']]]]:
        """
        -(Required) Disk Data Source Reference.
        """
        return pulumi.get(self, "disk_data_source_references")

    @disk_data_source_references.setter
    def disk_data_source_references(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupDiskV2DiskDataSourceReferenceArgs']]]]):
        pulumi.set(self, "disk_data_source_references", value)

    @_builtins.property
    @pulumi.getter(name="diskSizeBytes")
    def disk_size_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - ize of the disk in bytes. This field is mandatory during Volume Group creation if a new disk is being created on the storage container.
        """
        return pulumi.get(self, "disk_size_bytes")

    @disk_size_bytes.setter
    def disk_size_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_size_bytes", value)

    @_builtins.property
    @pulumi.getter(name="diskStorageFeatures")
    def disk_storage_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupDiskV2DiskStorageFeatureArgs']]]]:
        """
        - Storage optimization features which must be enabled on the Volume Disks. This is an optional field. If omitted, the disks will honor the Volume Group specific storage features setting.
        """
        return pulumi.get(self, "disk_storage_features")

    @disk_storage_features.setter
    def disk_storage_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupDiskV2DiskStorageFeatureArgs']]]]):
        pulumi.set(self, "disk_storage_features", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter
    def index(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - Index of the disk in a Volume Group. This field is optional and immutable.
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "index", value)

    @_builtins.property
    @pulumi.getter(name="volumeGroupExtId")
    def volume_group_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The external identifier of the volume group.
        """
        return pulumi.get(self, "volume_group_ext_id")

    @volume_group_ext_id.setter
    def volume_group_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_group_ext_id", value)


@pulumi.type_token("nutanix:index/volumeGroupDiskV2:VolumeGroupDiskV2")
class VolumeGroupDiskV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_data_source_references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupDiskV2DiskDataSourceReferenceArgs', 'VolumeGroupDiskV2DiskDataSourceReferenceArgsDict']]]]] = None,
                 disk_size_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_storage_features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupDiskV2DiskStorageFeatureArgs', 'VolumeGroupDiskV2DiskStorageFeatureArgsDict']]]]] = None,
                 index: Optional[pulumi.Input[_builtins.int]] = None,
                 volume_group_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to Creates a new Volume Disk.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # create new volume group disk  and attached it to the previous volume group
        example = nutanix.VolumeGroupDiskV2("example",
            volume_group_ext_id="cf7de8b9-88ed-477d-a602-c34ab7174c01",
            index=1,
            description="create volume disk example",
            disk_size_bytes=5368709120,
            disk_data_source_references=[{
                "name": "disk1",
                "ext_id": "1d92110d-26b5-46c0-8c93-20b8171373e0",
                "entity_type": "STORAGE_CONTAINER",
                "uris": [
                    "uri1",
                    "uri2",
                ],
            }],
            disk_storage_features=[{
                "flash_modes": [{
                    "is_enabled": False,
                }],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: - Volume Disk description.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupDiskV2DiskDataSourceReferenceArgs', 'VolumeGroupDiskV2DiskDataSourceReferenceArgsDict']]]] disk_data_source_references: -(Required) Disk Data Source Reference.
        :param pulumi.Input[_builtins.int] disk_size_bytes: - ize of the disk in bytes. This field is mandatory during Volume Group creation if a new disk is being created on the storage container.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupDiskV2DiskStorageFeatureArgs', 'VolumeGroupDiskV2DiskStorageFeatureArgsDict']]]] disk_storage_features: - Storage optimization features which must be enabled on the Volume Disks. This is an optional field. If omitted, the disks will honor the Volume Group specific storage features setting.
        :param pulumi.Input[_builtins.int] index: - Index of the disk in a Volume Group. This field is optional and immutable.
        :param pulumi.Input[_builtins.str] volume_group_ext_id: The external identifier of the volume group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeGroupDiskV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to Creates a new Volume Disk.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # create new volume group disk  and attached it to the previous volume group
        example = nutanix.VolumeGroupDiskV2("example",
            volume_group_ext_id="cf7de8b9-88ed-477d-a602-c34ab7174c01",
            index=1,
            description="create volume disk example",
            disk_size_bytes=5368709120,
            disk_data_source_references=[{
                "name": "disk1",
                "ext_id": "1d92110d-26b5-46c0-8c93-20b8171373e0",
                "entity_type": "STORAGE_CONTAINER",
                "uris": [
                    "uri1",
                    "uri2",
                ],
            }],
            disk_storage_features=[{
                "flash_modes": [{
                    "is_enabled": False,
                }],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param VolumeGroupDiskV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeGroupDiskV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_data_source_references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupDiskV2DiskDataSourceReferenceArgs', 'VolumeGroupDiskV2DiskDataSourceReferenceArgsDict']]]]] = None,
                 disk_size_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_storage_features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupDiskV2DiskStorageFeatureArgs', 'VolumeGroupDiskV2DiskStorageFeatureArgsDict']]]]] = None,
                 index: Optional[pulumi.Input[_builtins.int]] = None,
                 volume_group_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeGroupDiskV2Args.__new__(VolumeGroupDiskV2Args)

            __props__.__dict__["description"] = description
            if disk_data_source_references is None and not opts.urn:
                raise TypeError("Missing required property 'disk_data_source_references'")
            __props__.__dict__["disk_data_source_references"] = disk_data_source_references
            if disk_size_bytes is None and not opts.urn:
                raise TypeError("Missing required property 'disk_size_bytes'")
            __props__.__dict__["disk_size_bytes"] = disk_size_bytes
            __props__.__dict__["disk_storage_features"] = disk_storage_features
            __props__.__dict__["index"] = index
            if volume_group_ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'volume_group_ext_id'")
            __props__.__dict__["volume_group_ext_id"] = volume_group_ext_id
            __props__.__dict__["ext_id"] = None
        super(VolumeGroupDiskV2, __self__).__init__(
            'nutanix:index/volumeGroupDiskV2:VolumeGroupDiskV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disk_data_source_references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupDiskV2DiskDataSourceReferenceArgs', 'VolumeGroupDiskV2DiskDataSourceReferenceArgsDict']]]]] = None,
            disk_size_bytes: Optional[pulumi.Input[_builtins.int]] = None,
            disk_storage_features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupDiskV2DiskStorageFeatureArgs', 'VolumeGroupDiskV2DiskStorageFeatureArgsDict']]]]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            index: Optional[pulumi.Input[_builtins.int]] = None,
            volume_group_ext_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'VolumeGroupDiskV2':
        """
        Get an existing VolumeGroupDiskV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: - Volume Disk description.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupDiskV2DiskDataSourceReferenceArgs', 'VolumeGroupDiskV2DiskDataSourceReferenceArgsDict']]]] disk_data_source_references: -(Required) Disk Data Source Reference.
        :param pulumi.Input[_builtins.int] disk_size_bytes: - ize of the disk in bytes. This field is mandatory during Volume Group creation if a new disk is being created on the storage container.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupDiskV2DiskStorageFeatureArgs', 'VolumeGroupDiskV2DiskStorageFeatureArgsDict']]]] disk_storage_features: - Storage optimization features which must be enabled on the Volume Disks. This is an optional field. If omitted, the disks will honor the Volume Group specific storage features setting.
        :param pulumi.Input[_builtins.str] ext_id: - A globally unique identifier of an instance that is suitable for external consumption.
        :param pulumi.Input[_builtins.int] index: - Index of the disk in a Volume Group. This field is optional and immutable.
        :param pulumi.Input[_builtins.str] volume_group_ext_id: The external identifier of the volume group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VolumeGroupDiskV2State.__new__(_VolumeGroupDiskV2State)

        __props__.__dict__["description"] = description
        __props__.__dict__["disk_data_source_references"] = disk_data_source_references
        __props__.__dict__["disk_size_bytes"] = disk_size_bytes
        __props__.__dict__["disk_storage_features"] = disk_storage_features
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["index"] = index
        __props__.__dict__["volume_group_ext_id"] = volume_group_ext_id
        return VolumeGroupDiskV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - Volume Disk description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="diskDataSourceReferences")
    def disk_data_source_references(self) -> pulumi.Output[Sequence['outputs.VolumeGroupDiskV2DiskDataSourceReference']]:
        """
        -(Required) Disk Data Source Reference.
        """
        return pulumi.get(self, "disk_data_source_references")

    @_builtins.property
    @pulumi.getter(name="diskSizeBytes")
    def disk_size_bytes(self) -> pulumi.Output[_builtins.int]:
        """
        - ize of the disk in bytes. This field is mandatory during Volume Group creation if a new disk is being created on the storage container.
        """
        return pulumi.get(self, "disk_size_bytes")

    @_builtins.property
    @pulumi.getter(name="diskStorageFeatures")
    def disk_storage_features(self) -> pulumi.Output[Optional[Sequence['outputs.VolumeGroupDiskV2DiskStorageFeature']]]:
        """
        - Storage optimization features which must be enabled on the Volume Disks. This is an optional field. If omitted, the disks will honor the Volume Group specific storage features setting.
        """
        return pulumi.get(self, "disk_storage_features")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        - A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter
    def index(self) -> pulumi.Output[_builtins.int]:
        """
        - Index of the disk in a Volume Group. This field is optional and immutable.
        """
        return pulumi.get(self, "index")

    @_builtins.property
    @pulumi.getter(name="volumeGroupExtId")
    def volume_group_ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        The external identifier of the volume group.
        """
        return pulumi.get(self, "volume_group_ext_id")

