# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VolumeGroupIscsiClientV2Args', 'VolumeGroupIscsiClientV2']

@pulumi.input_type
class VolumeGroupIscsiClientV2Args:
    def __init__(__self__, *,
                 vg_ext_id: pulumi.Input[_builtins.str],
                 attachment_site: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled_authentications: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iscsi_initiator_name: Optional[pulumi.Input[_builtins.str]] = None,
                 iscsi_initiator_network_ids: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupIscsiClientV2IscsiInitiatorNetworkIdArgs']]]] = None,
                 num_virtual_targets: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a VolumeGroupIscsiClientV2 resource.
        :param pulumi.Input[_builtins.str] vg_ext_id: -(Required) The external identifier of the volume group.
        :param pulumi.Input[_builtins.str] attachment_site: -(Optional) The site where the Volume Group attach operation should be processed. This is an optional field. This field may only be set if Metro DR has been configured for this Volume Group. Valid values are SECONDARY, PRIMARY.
        :param pulumi.Input[_builtins.str] client_secret: -(Optional) iSCSI initiator client secret in case of CHAP authentication. This field should not be provided in case the authentication type is not set to CHAP.
        :param pulumi.Input[_builtins.str] enabled_authentications: -(Optional) (Optional) The authentication type enabled for the Volume Group. This is an optional field. If omitted, authentication is not configured for the Volume Group. If this is set to CHAP, the target/client secret must be provided. Valid values are CHAP, NONE
        :param pulumi.Input[_builtins.str] ext_id: -(Required) A globally unique identifier of an instance that is suitable for external consumption.
        :param pulumi.Input[_builtins.str] iscsi_initiator_name: -iSCSI initiator name. During the attach operation, exactly one of iscsiInitiatorName and iscsiInitiatorNetworkId must be specified. This field is immutable.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeGroupIscsiClientV2IscsiInitiatorNetworkIdArgs']]] iscsi_initiator_network_ids: - An unique address that identifies a device on the internet or a local network in IPv4/IPv6 format or a Fully Qualified Domain Name.
        :param pulumi.Input[_builtins.int] num_virtual_targets: -(Optional) Number of virtual targets generated for the iSCSI target. This field is immutable.
        """
        pulumi.set(__self__, "vg_ext_id", vg_ext_id)
        if attachment_site is not None:
            pulumi.set(__self__, "attachment_site", attachment_site)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if enabled_authentications is not None:
            pulumi.set(__self__, "enabled_authentications", enabled_authentications)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if iscsi_initiator_name is not None:
            pulumi.set(__self__, "iscsi_initiator_name", iscsi_initiator_name)
        if iscsi_initiator_network_ids is not None:
            pulumi.set(__self__, "iscsi_initiator_network_ids", iscsi_initiator_network_ids)
        if num_virtual_targets is not None:
            pulumi.set(__self__, "num_virtual_targets", num_virtual_targets)

    @_builtins.property
    @pulumi.getter(name="vgExtId")
    def vg_ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) The external identifier of the volume group.
        """
        return pulumi.get(self, "vg_ext_id")

    @vg_ext_id.setter
    def vg_ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vg_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="attachmentSite")
    def attachment_site(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) The site where the Volume Group attach operation should be processed. This is an optional field. This field may only be set if Metro DR has been configured for this Volume Group. Valid values are SECONDARY, PRIMARY.
        """
        return pulumi.get(self, "attachment_site")

    @attachment_site.setter
    def attachment_site(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "attachment_site", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) iSCSI initiator client secret in case of CHAP authentication. This field should not be provided in case the authentication type is not set to CHAP.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter(name="enabledAuthentications")
    def enabled_authentications(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) (Optional) The authentication type enabled for the Volume Group. This is an optional field. If omitted, authentication is not configured for the Volume Group. If this is set to CHAP, the target/client secret must be provided. Valid values are CHAP, NONE
        """
        return pulumi.get(self, "enabled_authentications")

    @enabled_authentications.setter
    def enabled_authentications(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enabled_authentications", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="iscsiInitiatorName")
    def iscsi_initiator_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -iSCSI initiator name. During the attach operation, exactly one of iscsiInitiatorName and iscsiInitiatorNetworkId must be specified. This field is immutable.
        """
        return pulumi.get(self, "iscsi_initiator_name")

    @iscsi_initiator_name.setter
    def iscsi_initiator_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iscsi_initiator_name", value)

    @_builtins.property
    @pulumi.getter(name="iscsiInitiatorNetworkIds")
    def iscsi_initiator_network_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupIscsiClientV2IscsiInitiatorNetworkIdArgs']]]]:
        """
        - An unique address that identifies a device on the internet or a local network in IPv4/IPv6 format or a Fully Qualified Domain Name.
        """
        return pulumi.get(self, "iscsi_initiator_network_ids")

    @iscsi_initiator_network_ids.setter
    def iscsi_initiator_network_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupIscsiClientV2IscsiInitiatorNetworkIdArgs']]]]):
        pulumi.set(self, "iscsi_initiator_network_ids", value)

    @_builtins.property
    @pulumi.getter(name="numVirtualTargets")
    def num_virtual_targets(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        -(Optional) Number of virtual targets generated for the iSCSI target. This field is immutable.
        """
        return pulumi.get(self, "num_virtual_targets")

    @num_virtual_targets.setter
    def num_virtual_targets(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_virtual_targets", value)


@pulumi.input_type
class _VolumeGroupIscsiClientV2State:
    def __init__(__self__, *,
                 attachment_site: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled_authentications: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iscsi_initiator_name: Optional[pulumi.Input[_builtins.str]] = None,
                 iscsi_initiator_network_ids: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupIscsiClientV2IscsiInitiatorNetworkIdArgs']]]] = None,
                 num_virtual_targets: Optional[pulumi.Input[_builtins.int]] = None,
                 vg_ext_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VolumeGroupIscsiClientV2 resources.
        :param pulumi.Input[_builtins.str] attachment_site: -(Optional) The site where the Volume Group attach operation should be processed. This is an optional field. This field may only be set if Metro DR has been configured for this Volume Group. Valid values are SECONDARY, PRIMARY.
        :param pulumi.Input[_builtins.str] client_secret: -(Optional) iSCSI initiator client secret in case of CHAP authentication. This field should not be provided in case the authentication type is not set to CHAP.
        :param pulumi.Input[_builtins.str] enabled_authentications: -(Optional) (Optional) The authentication type enabled for the Volume Group. This is an optional field. If omitted, authentication is not configured for the Volume Group. If this is set to CHAP, the target/client secret must be provided. Valid values are CHAP, NONE
        :param pulumi.Input[_builtins.str] ext_id: -(Required) A globally unique identifier of an instance that is suitable for external consumption.
        :param pulumi.Input[_builtins.str] iscsi_initiator_name: -iSCSI initiator name. During the attach operation, exactly one of iscsiInitiatorName and iscsiInitiatorNetworkId must be specified. This field is immutable.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeGroupIscsiClientV2IscsiInitiatorNetworkIdArgs']]] iscsi_initiator_network_ids: - An unique address that identifies a device on the internet or a local network in IPv4/IPv6 format or a Fully Qualified Domain Name.
        :param pulumi.Input[_builtins.int] num_virtual_targets: -(Optional) Number of virtual targets generated for the iSCSI target. This field is immutable.
        :param pulumi.Input[_builtins.str] vg_ext_id: -(Required) The external identifier of the volume group.
        """
        if attachment_site is not None:
            pulumi.set(__self__, "attachment_site", attachment_site)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if enabled_authentications is not None:
            pulumi.set(__self__, "enabled_authentications", enabled_authentications)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if iscsi_initiator_name is not None:
            pulumi.set(__self__, "iscsi_initiator_name", iscsi_initiator_name)
        if iscsi_initiator_network_ids is not None:
            pulumi.set(__self__, "iscsi_initiator_network_ids", iscsi_initiator_network_ids)
        if num_virtual_targets is not None:
            pulumi.set(__self__, "num_virtual_targets", num_virtual_targets)
        if vg_ext_id is not None:
            pulumi.set(__self__, "vg_ext_id", vg_ext_id)

    @_builtins.property
    @pulumi.getter(name="attachmentSite")
    def attachment_site(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) The site where the Volume Group attach operation should be processed. This is an optional field. This field may only be set if Metro DR has been configured for this Volume Group. Valid values are SECONDARY, PRIMARY.
        """
        return pulumi.get(self, "attachment_site")

    @attachment_site.setter
    def attachment_site(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "attachment_site", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) iSCSI initiator client secret in case of CHAP authentication. This field should not be provided in case the authentication type is not set to CHAP.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter(name="enabledAuthentications")
    def enabled_authentications(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) (Optional) The authentication type enabled for the Volume Group. This is an optional field. If omitted, authentication is not configured for the Volume Group. If this is set to CHAP, the target/client secret must be provided. Valid values are CHAP, NONE
        """
        return pulumi.get(self, "enabled_authentications")

    @enabled_authentications.setter
    def enabled_authentications(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enabled_authentications", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="iscsiInitiatorName")
    def iscsi_initiator_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -iSCSI initiator name. During the attach operation, exactly one of iscsiInitiatorName and iscsiInitiatorNetworkId must be specified. This field is immutable.
        """
        return pulumi.get(self, "iscsi_initiator_name")

    @iscsi_initiator_name.setter
    def iscsi_initiator_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iscsi_initiator_name", value)

    @_builtins.property
    @pulumi.getter(name="iscsiInitiatorNetworkIds")
    def iscsi_initiator_network_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupIscsiClientV2IscsiInitiatorNetworkIdArgs']]]]:
        """
        - An unique address that identifies a device on the internet or a local network in IPv4/IPv6 format or a Fully Qualified Domain Name.
        """
        return pulumi.get(self, "iscsi_initiator_network_ids")

    @iscsi_initiator_network_ids.setter
    def iscsi_initiator_network_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupIscsiClientV2IscsiInitiatorNetworkIdArgs']]]]):
        pulumi.set(self, "iscsi_initiator_network_ids", value)

    @_builtins.property
    @pulumi.getter(name="numVirtualTargets")
    def num_virtual_targets(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        -(Optional) Number of virtual targets generated for the iSCSI target. This field is immutable.
        """
        return pulumi.get(self, "num_virtual_targets")

    @num_virtual_targets.setter
    def num_virtual_targets(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_virtual_targets", value)

    @_builtins.property
    @pulumi.getter(name="vgExtId")
    def vg_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) The external identifier of the volume group.
        """
        return pulumi.get(self, "vg_ext_id")

    @vg_ext_id.setter
    def vg_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vg_ext_id", value)


@pulumi.type_token("nutanix:index/volumeGroupIscsiClientV2:VolumeGroupIscsiClientV2")
class VolumeGroupIscsiClientV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachment_site: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled_authentications: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iscsi_initiator_name: Optional[pulumi.Input[_builtins.str]] = None,
                 iscsi_initiator_network_ids: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupIscsiClientV2IscsiInitiatorNetworkIdArgs', 'VolumeGroupIscsiClientV2IscsiInitiatorNetworkIdArgsDict']]]]] = None,
                 num_virtual_targets: Optional[pulumi.Input[_builtins.int]] = None,
                 vg_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Attaches iSCSI initiator to a Volume Group identified by {extId}.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        #list iscsi clients
        list_iscsi_clients = nutanix.get_volume_iscsi_clients_v2()
        # attach iscsi client to the volume group
        vg_iscsi_example = nutanix.index.VolumeGroupIscsiClientsV2("vg_iscsi_example",
            vg_ext_id=1cdb5b48-fb2c-41b6-b751-b504117ee3e2,
            ext_id=list_iscsi_clients.iscsi_clients[0].ext_id,
            iscsi_initiator_name=list_iscsi_clients.iscsi_clients[0].iscsi_initiator_name)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] attachment_site: -(Optional) The site where the Volume Group attach operation should be processed. This is an optional field. This field may only be set if Metro DR has been configured for this Volume Group. Valid values are SECONDARY, PRIMARY.
        :param pulumi.Input[_builtins.str] client_secret: -(Optional) iSCSI initiator client secret in case of CHAP authentication. This field should not be provided in case the authentication type is not set to CHAP.
        :param pulumi.Input[_builtins.str] enabled_authentications: -(Optional) (Optional) The authentication type enabled for the Volume Group. This is an optional field. If omitted, authentication is not configured for the Volume Group. If this is set to CHAP, the target/client secret must be provided. Valid values are CHAP, NONE
        :param pulumi.Input[_builtins.str] ext_id: -(Required) A globally unique identifier of an instance that is suitable for external consumption.
        :param pulumi.Input[_builtins.str] iscsi_initiator_name: -iSCSI initiator name. During the attach operation, exactly one of iscsiInitiatorName and iscsiInitiatorNetworkId must be specified. This field is immutable.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupIscsiClientV2IscsiInitiatorNetworkIdArgs', 'VolumeGroupIscsiClientV2IscsiInitiatorNetworkIdArgsDict']]]] iscsi_initiator_network_ids: - An unique address that identifies a device on the internet or a local network in IPv4/IPv6 format or a Fully Qualified Domain Name.
        :param pulumi.Input[_builtins.int] num_virtual_targets: -(Optional) Number of virtual targets generated for the iSCSI target. This field is immutable.
        :param pulumi.Input[_builtins.str] vg_ext_id: -(Required) The external identifier of the volume group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeGroupIscsiClientV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Attaches iSCSI initiator to a Volume Group identified by {extId}.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        #list iscsi clients
        list_iscsi_clients = nutanix.get_volume_iscsi_clients_v2()
        # attach iscsi client to the volume group
        vg_iscsi_example = nutanix.index.VolumeGroupIscsiClientsV2("vg_iscsi_example",
            vg_ext_id=1cdb5b48-fb2c-41b6-b751-b504117ee3e2,
            ext_id=list_iscsi_clients.iscsi_clients[0].ext_id,
            iscsi_initiator_name=list_iscsi_clients.iscsi_clients[0].iscsi_initiator_name)
        ```

        :param str resource_name: The name of the resource.
        :param VolumeGroupIscsiClientV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeGroupIscsiClientV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachment_site: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled_authentications: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iscsi_initiator_name: Optional[pulumi.Input[_builtins.str]] = None,
                 iscsi_initiator_network_ids: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupIscsiClientV2IscsiInitiatorNetworkIdArgs', 'VolumeGroupIscsiClientV2IscsiInitiatorNetworkIdArgsDict']]]]] = None,
                 num_virtual_targets: Optional[pulumi.Input[_builtins.int]] = None,
                 vg_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeGroupIscsiClientV2Args.__new__(VolumeGroupIscsiClientV2Args)

            __props__.__dict__["attachment_site"] = attachment_site
            __props__.__dict__["client_secret"] = client_secret
            __props__.__dict__["enabled_authentications"] = enabled_authentications
            __props__.__dict__["ext_id"] = ext_id
            __props__.__dict__["iscsi_initiator_name"] = iscsi_initiator_name
            __props__.__dict__["iscsi_initiator_network_ids"] = iscsi_initiator_network_ids
            __props__.__dict__["num_virtual_targets"] = num_virtual_targets
            if vg_ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'vg_ext_id'")
            __props__.__dict__["vg_ext_id"] = vg_ext_id
        super(VolumeGroupIscsiClientV2, __self__).__init__(
            'nutanix:index/volumeGroupIscsiClientV2:VolumeGroupIscsiClientV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attachment_site: Optional[pulumi.Input[_builtins.str]] = None,
            client_secret: Optional[pulumi.Input[_builtins.str]] = None,
            enabled_authentications: Optional[pulumi.Input[_builtins.str]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            iscsi_initiator_name: Optional[pulumi.Input[_builtins.str]] = None,
            iscsi_initiator_network_ids: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupIscsiClientV2IscsiInitiatorNetworkIdArgs', 'VolumeGroupIscsiClientV2IscsiInitiatorNetworkIdArgsDict']]]]] = None,
            num_virtual_targets: Optional[pulumi.Input[_builtins.int]] = None,
            vg_ext_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'VolumeGroupIscsiClientV2':
        """
        Get an existing VolumeGroupIscsiClientV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] attachment_site: -(Optional) The site where the Volume Group attach operation should be processed. This is an optional field. This field may only be set if Metro DR has been configured for this Volume Group. Valid values are SECONDARY, PRIMARY.
        :param pulumi.Input[_builtins.str] client_secret: -(Optional) iSCSI initiator client secret in case of CHAP authentication. This field should not be provided in case the authentication type is not set to CHAP.
        :param pulumi.Input[_builtins.str] enabled_authentications: -(Optional) (Optional) The authentication type enabled for the Volume Group. This is an optional field. If omitted, authentication is not configured for the Volume Group. If this is set to CHAP, the target/client secret must be provided. Valid values are CHAP, NONE
        :param pulumi.Input[_builtins.str] ext_id: -(Required) A globally unique identifier of an instance that is suitable for external consumption.
        :param pulumi.Input[_builtins.str] iscsi_initiator_name: -iSCSI initiator name. During the attach operation, exactly one of iscsiInitiatorName and iscsiInitiatorNetworkId must be specified. This field is immutable.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupIscsiClientV2IscsiInitiatorNetworkIdArgs', 'VolumeGroupIscsiClientV2IscsiInitiatorNetworkIdArgsDict']]]] iscsi_initiator_network_ids: - An unique address that identifies a device on the internet or a local network in IPv4/IPv6 format or a Fully Qualified Domain Name.
        :param pulumi.Input[_builtins.int] num_virtual_targets: -(Optional) Number of virtual targets generated for the iSCSI target. This field is immutable.
        :param pulumi.Input[_builtins.str] vg_ext_id: -(Required) The external identifier of the volume group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VolumeGroupIscsiClientV2State.__new__(_VolumeGroupIscsiClientV2State)

        __props__.__dict__["attachment_site"] = attachment_site
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["enabled_authentications"] = enabled_authentications
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["iscsi_initiator_name"] = iscsi_initiator_name
        __props__.__dict__["iscsi_initiator_network_ids"] = iscsi_initiator_network_ids
        __props__.__dict__["num_virtual_targets"] = num_virtual_targets
        __props__.__dict__["vg_ext_id"] = vg_ext_id
        return VolumeGroupIscsiClientV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="attachmentSite")
    def attachment_site(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        -(Optional) The site where the Volume Group attach operation should be processed. This is an optional field. This field may only be set if Metro DR has been configured for this Volume Group. Valid values are SECONDARY, PRIMARY.
        """
        return pulumi.get(self, "attachment_site")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        -(Optional) iSCSI initiator client secret in case of CHAP authentication. This field should not be provided in case the authentication type is not set to CHAP.
        """
        return pulumi.get(self, "client_secret")

    @_builtins.property
    @pulumi.getter(name="enabledAuthentications")
    def enabled_authentications(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        -(Optional) (Optional) The authentication type enabled for the Volume Group. This is an optional field. If omitted, authentication is not configured for the Volume Group. If this is set to CHAP, the target/client secret must be provided. Valid values are CHAP, NONE
        """
        return pulumi.get(self, "enabled_authentications")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="iscsiInitiatorName")
    def iscsi_initiator_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        -iSCSI initiator name. During the attach operation, exactly one of iscsiInitiatorName and iscsiInitiatorNetworkId must be specified. This field is immutable.
        """
        return pulumi.get(self, "iscsi_initiator_name")

    @_builtins.property
    @pulumi.getter(name="iscsiInitiatorNetworkIds")
    def iscsi_initiator_network_ids(self) -> pulumi.Output[Optional[Sequence['outputs.VolumeGroupIscsiClientV2IscsiInitiatorNetworkId']]]:
        """
        - An unique address that identifies a device on the internet or a local network in IPv4/IPv6 format or a Fully Qualified Domain Name.
        """
        return pulumi.get(self, "iscsi_initiator_network_ids")

    @_builtins.property
    @pulumi.getter(name="numVirtualTargets")
    def num_virtual_targets(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        -(Optional) Number of virtual targets generated for the iSCSI target. This field is immutable.
        """
        return pulumi.get(self, "num_virtual_targets")

    @_builtins.property
    @pulumi.getter(name="vgExtId")
    def vg_ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) The external identifier of the volume group.
        """
        return pulumi.get(self, "vg_ext_id")

