# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VolumeGroupV2Args', 'VolumeGroupV2']

@pulumi.input_type
class VolumeGroupV2Args:
    def __init__(__self__, *,
                 cluster_reference: pulumi.Input[_builtins.str],
                 attachment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupV2DiskArgs']]]] = None,
                 enabled_authentications: Optional[pulumi.Input[_builtins.str]] = None,
                 is_hidden: Optional[pulumi.Input[_builtins.bool]] = None,
                 iscsi_features: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupV2IscsiFeatureArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 sharing_status: Optional[pulumi.Input[_builtins.str]] = None,
                 should_load_balance_vm_attachments: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_features: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupV2StorageFeatureArgs']]]] = None,
                 target_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 usage_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VolumeGroupV2 resource.
        :param pulumi.Input[_builtins.str] cluster_reference: -(Required) The UUID of the cluster that will host the Volume Group.
        :param pulumi.Input[_builtins.str] attachment_type: -(Optional) The field indicates whether a VG has a VM or an external attachment associated with it. Valid values are :
               - EXTERNAL : Volume Group has an external iSCSI or NVMf attachment.
               - NONE : Volume Group has no attachment.
               - DIRECT : Volume Group has a VM attachment.
        :param pulumi.Input[_builtins.str] created_by: -(Optional) Service/user who created this Volume Group.
        :param pulumi.Input[_builtins.str] description: -(Optional) Volume Group description. This is an optional field.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeGroupV2DiskArgs']]] disks: -(Optional) A list of Volume Disks to be attached to the Volume Group.
        :param pulumi.Input[_builtins.str] enabled_authentications: -(Optional) The authentication type enabled for the Volume Group. Valid values are CHAP, NONE
        :param pulumi.Input[_builtins.bool] is_hidden: -(Optional) Indicates whether the Volume Group is meant to be hidden or not.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeGroupV2IscsiFeatureArgs']]] iscsi_features: -(Optional) iSCSI specific settings for the Volume Group.
        :param pulumi.Input[_builtins.str] name: -(Required) Volume Group name. This is an optional field.
        :param pulumi.Input[_builtins.str] protocol: -(Optional) Type of protocol to be used for Volume Group. Valid values are :
               - NOT_ASSIGNED :  Volume Group does not use any protocol.
               - ISCSI : Volume Group uses iSCSI protocol.
               - NVMF : Volume Group uses NVMf protocol.
        :param pulumi.Input[_builtins.str] sharing_status: -(Optional) Indicates whether the Volume Group can be shared across multiple iSCSI initiators. The mode cannot be changed from SHARED to NOT_SHARED on a Volume Group with multiple attachments. Similarly, a Volume Group cannot be associated with more than one attachment as long as it is in exclusive mode. This is an optional field. Valid values are SHARED, NOT_SHARED
        :param pulumi.Input[_builtins.bool] should_load_balance_vm_attachments: -(Optional) Indicates whether to enable Volume Group load balancing for VM attachments. This cannot be enabled if there are iSCSI client attachments already associated with the Volume Group, and vice-versa. This is an optional field.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeGroupV2StorageFeatureArgs']]] storage_features: -(Optional) Storage optimization features which must be enabled on the Volume Group.
        :param pulumi.Input[_builtins.str] target_name: -(Optional) Name of the external client target that will be visible and accessible to the client.
        :param pulumi.Input[_builtins.str] target_prefix: The specifications contain the target prefix for external clients as the value. This is an optional field.
        :param pulumi.Input[_builtins.str] usage_type: -(Optional) Expected usage type for the Volume Group. This is an indicative hint on how the caller will consume the Volume Group.  Valid values are BACKUP_TARGET, INTERNAL, TEMPORARY, USER
        """
        pulumi.set(__self__, "cluster_reference", cluster_reference)
        if attachment_type is not None:
            pulumi.set(__self__, "attachment_type", attachment_type)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if enabled_authentications is not None:
            pulumi.set(__self__, "enabled_authentications", enabled_authentications)
        if is_hidden is not None:
            pulumi.set(__self__, "is_hidden", is_hidden)
        if iscsi_features is not None:
            pulumi.set(__self__, "iscsi_features", iscsi_features)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if sharing_status is not None:
            pulumi.set(__self__, "sharing_status", sharing_status)
        if should_load_balance_vm_attachments is not None:
            pulumi.set(__self__, "should_load_balance_vm_attachments", should_load_balance_vm_attachments)
        if storage_features is not None:
            pulumi.set(__self__, "storage_features", storage_features)
        if target_name is not None:
            pulumi.set(__self__, "target_name", target_name)
        if target_prefix is not None:
            pulumi.set(__self__, "target_prefix", target_prefix)
        if usage_type is not None:
            pulumi.set(__self__, "usage_type", usage_type)

    @_builtins.property
    @pulumi.getter(name="clusterReference")
    def cluster_reference(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) The UUID of the cluster that will host the Volume Group.
        """
        return pulumi.get(self, "cluster_reference")

    @cluster_reference.setter
    def cluster_reference(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_reference", value)

    @_builtins.property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) The field indicates whether a VG has a VM or an external attachment associated with it. Valid values are :
        - EXTERNAL : Volume Group has an external iSCSI or NVMf attachment.
        - NONE : Volume Group has no attachment.
        - DIRECT : Volume Group has a VM attachment.
        """
        return pulumi.get(self, "attachment_type")

    @attachment_type.setter
    def attachment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "attachment_type", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Service/user who created this Volume Group.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Volume Group description. This is an optional field.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupV2DiskArgs']]]]:
        """
        -(Optional) A list of Volume Disks to be attached to the Volume Group.
        """
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupV2DiskArgs']]]]):
        pulumi.set(self, "disks", value)

    @_builtins.property
    @pulumi.getter(name="enabledAuthentications")
    def enabled_authentications(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) The authentication type enabled for the Volume Group. Valid values are CHAP, NONE
        """
        return pulumi.get(self, "enabled_authentications")

    @enabled_authentications.setter
    def enabled_authentications(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enabled_authentications", value)

    @_builtins.property
    @pulumi.getter(name="isHidden")
    def is_hidden(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        -(Optional) Indicates whether the Volume Group is meant to be hidden or not.
        """
        return pulumi.get(self, "is_hidden")

    @is_hidden.setter
    def is_hidden(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_hidden", value)

    @_builtins.property
    @pulumi.getter(name="iscsiFeatures")
    def iscsi_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupV2IscsiFeatureArgs']]]]:
        """
        -(Optional) iSCSI specific settings for the Volume Group.
        """
        return pulumi.get(self, "iscsi_features")

    @iscsi_features.setter
    def iscsi_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupV2IscsiFeatureArgs']]]]):
        pulumi.set(self, "iscsi_features", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) Volume Group name. This is an optional field.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Type of protocol to be used for Volume Group. Valid values are :
        - NOT_ASSIGNED :  Volume Group does not use any protocol.
        - ISCSI : Volume Group uses iSCSI protocol.
        - NVMF : Volume Group uses NVMf protocol.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="sharingStatus")
    def sharing_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Indicates whether the Volume Group can be shared across multiple iSCSI initiators. The mode cannot be changed from SHARED to NOT_SHARED on a Volume Group with multiple attachments. Similarly, a Volume Group cannot be associated with more than one attachment as long as it is in exclusive mode. This is an optional field. Valid values are SHARED, NOT_SHARED
        """
        return pulumi.get(self, "sharing_status")

    @sharing_status.setter
    def sharing_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sharing_status", value)

    @_builtins.property
    @pulumi.getter(name="shouldLoadBalanceVmAttachments")
    def should_load_balance_vm_attachments(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        -(Optional) Indicates whether to enable Volume Group load balancing for VM attachments. This cannot be enabled if there are iSCSI client attachments already associated with the Volume Group, and vice-versa. This is an optional field.
        """
        return pulumi.get(self, "should_load_balance_vm_attachments")

    @should_load_balance_vm_attachments.setter
    def should_load_balance_vm_attachments(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "should_load_balance_vm_attachments", value)

    @_builtins.property
    @pulumi.getter(name="storageFeatures")
    def storage_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupV2StorageFeatureArgs']]]]:
        """
        -(Optional) Storage optimization features which must be enabled on the Volume Group.
        """
        return pulumi.get(self, "storage_features")

    @storage_features.setter
    def storage_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupV2StorageFeatureArgs']]]]):
        pulumi.set(self, "storage_features", value)

    @_builtins.property
    @pulumi.getter(name="targetName")
    def target_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Name of the external client target that will be visible and accessible to the client.
        """
        return pulumi.get(self, "target_name")

    @target_name.setter
    def target_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_name", value)

    @_builtins.property
    @pulumi.getter(name="targetPrefix")
    def target_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specifications contain the target prefix for external clients as the value. This is an optional field.
        """
        return pulumi.get(self, "target_prefix")

    @target_prefix.setter
    def target_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_prefix", value)

    @_builtins.property
    @pulumi.getter(name="usageType")
    def usage_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Expected usage type for the Volume Group. This is an indicative hint on how the caller will consume the Volume Group.  Valid values are BACKUP_TARGET, INTERNAL, TEMPORARY, USER
        """
        return pulumi.get(self, "usage_type")

    @usage_type.setter
    def usage_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "usage_type", value)


@pulumi.input_type
class _VolumeGroupV2State:
    def __init__(__self__, *,
                 attachment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupV2DiskArgs']]]] = None,
                 enabled_authentications: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_hidden: Optional[pulumi.Input[_builtins.bool]] = None,
                 iscsi_features: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupV2IscsiFeatureArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 sharing_status: Optional[pulumi.Input[_builtins.str]] = None,
                 should_load_balance_vm_attachments: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_features: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupV2StorageFeatureArgs']]]] = None,
                 target_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 usage_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VolumeGroupV2 resources.
        :param pulumi.Input[_builtins.str] attachment_type: -(Optional) The field indicates whether a VG has a VM or an external attachment associated with it. Valid values are :
               - EXTERNAL : Volume Group has an external iSCSI or NVMf attachment.
               - NONE : Volume Group has no attachment.
               - DIRECT : Volume Group has a VM attachment.
        :param pulumi.Input[_builtins.str] cluster_reference: -(Required) The UUID of the cluster that will host the Volume Group.
        :param pulumi.Input[_builtins.str] created_by: -(Optional) Service/user who created this Volume Group.
        :param pulumi.Input[_builtins.str] description: -(Optional) Volume Group description. This is an optional field.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeGroupV2DiskArgs']]] disks: -(Optional) A list of Volume Disks to be attached to the Volume Group.
        :param pulumi.Input[_builtins.str] enabled_authentications: -(Optional) The authentication type enabled for the Volume Group. Valid values are CHAP, NONE
        :param pulumi.Input[_builtins.str] ext_id: -(Optional) A globally unique identifier of an instance that is suitable for external consumption.
        :param pulumi.Input[_builtins.bool] is_hidden: -(Optional) Indicates whether the Volume Group is meant to be hidden or not.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeGroupV2IscsiFeatureArgs']]] iscsi_features: -(Optional) iSCSI specific settings for the Volume Group.
        :param pulumi.Input[_builtins.str] name: -(Required) Volume Group name. This is an optional field.
        :param pulumi.Input[_builtins.str] protocol: -(Optional) Type of protocol to be used for Volume Group. Valid values are :
               - NOT_ASSIGNED :  Volume Group does not use any protocol.
               - ISCSI : Volume Group uses iSCSI protocol.
               - NVMF : Volume Group uses NVMf protocol.
        :param pulumi.Input[_builtins.str] sharing_status: -(Optional) Indicates whether the Volume Group can be shared across multiple iSCSI initiators. The mode cannot be changed from SHARED to NOT_SHARED on a Volume Group with multiple attachments. Similarly, a Volume Group cannot be associated with more than one attachment as long as it is in exclusive mode. This is an optional field. Valid values are SHARED, NOT_SHARED
        :param pulumi.Input[_builtins.bool] should_load_balance_vm_attachments: -(Optional) Indicates whether to enable Volume Group load balancing for VM attachments. This cannot be enabled if there are iSCSI client attachments already associated with the Volume Group, and vice-versa. This is an optional field.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeGroupV2StorageFeatureArgs']]] storage_features: -(Optional) Storage optimization features which must be enabled on the Volume Group.
        :param pulumi.Input[_builtins.str] target_name: -(Optional) Name of the external client target that will be visible and accessible to the client.
        :param pulumi.Input[_builtins.str] target_prefix: The specifications contain the target prefix for external clients as the value. This is an optional field.
        :param pulumi.Input[_builtins.str] usage_type: -(Optional) Expected usage type for the Volume Group. This is an indicative hint on how the caller will consume the Volume Group.  Valid values are BACKUP_TARGET, INTERNAL, TEMPORARY, USER
        """
        if attachment_type is not None:
            pulumi.set(__self__, "attachment_type", attachment_type)
        if cluster_reference is not None:
            pulumi.set(__self__, "cluster_reference", cluster_reference)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if enabled_authentications is not None:
            pulumi.set(__self__, "enabled_authentications", enabled_authentications)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if is_hidden is not None:
            pulumi.set(__self__, "is_hidden", is_hidden)
        if iscsi_features is not None:
            pulumi.set(__self__, "iscsi_features", iscsi_features)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if sharing_status is not None:
            pulumi.set(__self__, "sharing_status", sharing_status)
        if should_load_balance_vm_attachments is not None:
            pulumi.set(__self__, "should_load_balance_vm_attachments", should_load_balance_vm_attachments)
        if storage_features is not None:
            pulumi.set(__self__, "storage_features", storage_features)
        if target_name is not None:
            pulumi.set(__self__, "target_name", target_name)
        if target_prefix is not None:
            pulumi.set(__self__, "target_prefix", target_prefix)
        if usage_type is not None:
            pulumi.set(__self__, "usage_type", usage_type)

    @_builtins.property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) The field indicates whether a VG has a VM or an external attachment associated with it. Valid values are :
        - EXTERNAL : Volume Group has an external iSCSI or NVMf attachment.
        - NONE : Volume Group has no attachment.
        - DIRECT : Volume Group has a VM attachment.
        """
        return pulumi.get(self, "attachment_type")

    @attachment_type.setter
    def attachment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "attachment_type", value)

    @_builtins.property
    @pulumi.getter(name="clusterReference")
    def cluster_reference(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) The UUID of the cluster that will host the Volume Group.
        """
        return pulumi.get(self, "cluster_reference")

    @cluster_reference.setter
    def cluster_reference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_reference", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Service/user who created this Volume Group.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Volume Group description. This is an optional field.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupV2DiskArgs']]]]:
        """
        -(Optional) A list of Volume Disks to be attached to the Volume Group.
        """
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupV2DiskArgs']]]]):
        pulumi.set(self, "disks", value)

    @_builtins.property
    @pulumi.getter(name="enabledAuthentications")
    def enabled_authentications(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) The authentication type enabled for the Volume Group. Valid values are CHAP, NONE
        """
        return pulumi.get(self, "enabled_authentications")

    @enabled_authentications.setter
    def enabled_authentications(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enabled_authentications", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="isHidden")
    def is_hidden(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        -(Optional) Indicates whether the Volume Group is meant to be hidden or not.
        """
        return pulumi.get(self, "is_hidden")

    @is_hidden.setter
    def is_hidden(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_hidden", value)

    @_builtins.property
    @pulumi.getter(name="iscsiFeatures")
    def iscsi_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupV2IscsiFeatureArgs']]]]:
        """
        -(Optional) iSCSI specific settings for the Volume Group.
        """
        return pulumi.get(self, "iscsi_features")

    @iscsi_features.setter
    def iscsi_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupV2IscsiFeatureArgs']]]]):
        pulumi.set(self, "iscsi_features", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) Volume Group name. This is an optional field.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Type of protocol to be used for Volume Group. Valid values are :
        - NOT_ASSIGNED :  Volume Group does not use any protocol.
        - ISCSI : Volume Group uses iSCSI protocol.
        - NVMF : Volume Group uses NVMf protocol.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="sharingStatus")
    def sharing_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Indicates whether the Volume Group can be shared across multiple iSCSI initiators. The mode cannot be changed from SHARED to NOT_SHARED on a Volume Group with multiple attachments. Similarly, a Volume Group cannot be associated with more than one attachment as long as it is in exclusive mode. This is an optional field. Valid values are SHARED, NOT_SHARED
        """
        return pulumi.get(self, "sharing_status")

    @sharing_status.setter
    def sharing_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sharing_status", value)

    @_builtins.property
    @pulumi.getter(name="shouldLoadBalanceVmAttachments")
    def should_load_balance_vm_attachments(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        -(Optional) Indicates whether to enable Volume Group load balancing for VM attachments. This cannot be enabled if there are iSCSI client attachments already associated with the Volume Group, and vice-versa. This is an optional field.
        """
        return pulumi.get(self, "should_load_balance_vm_attachments")

    @should_load_balance_vm_attachments.setter
    def should_load_balance_vm_attachments(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "should_load_balance_vm_attachments", value)

    @_builtins.property
    @pulumi.getter(name="storageFeatures")
    def storage_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupV2StorageFeatureArgs']]]]:
        """
        -(Optional) Storage optimization features which must be enabled on the Volume Group.
        """
        return pulumi.get(self, "storage_features")

    @storage_features.setter
    def storage_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupV2StorageFeatureArgs']]]]):
        pulumi.set(self, "storage_features", value)

    @_builtins.property
    @pulumi.getter(name="targetName")
    def target_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Name of the external client target that will be visible and accessible to the client.
        """
        return pulumi.get(self, "target_name")

    @target_name.setter
    def target_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_name", value)

    @_builtins.property
    @pulumi.getter(name="targetPrefix")
    def target_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specifications contain the target prefix for external clients as the value. This is an optional field.
        """
        return pulumi.get(self, "target_prefix")

    @target_prefix.setter
    def target_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_prefix", value)

    @_builtins.property
    @pulumi.getter(name="usageType")
    def usage_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Expected usage type for the Volume Group. This is an indicative hint on how the caller will consume the Volume Group.  Valid values are BACKUP_TARGET, INTERNAL, TEMPORARY, USER
        """
        return pulumi.get(self, "usage_type")

    @usage_type.setter
    def usage_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "usage_type", value)


@pulumi.type_token("nutanix:index/volumeGroupV2:VolumeGroupV2")
class VolumeGroupV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupV2DiskArgs', 'VolumeGroupV2DiskArgsDict']]]]] = None,
                 enabled_authentications: Optional[pulumi.Input[_builtins.str]] = None,
                 is_hidden: Optional[pulumi.Input[_builtins.bool]] = None,
                 iscsi_features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupV2IscsiFeatureArgs', 'VolumeGroupV2IscsiFeatureArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 sharing_status: Optional[pulumi.Input[_builtins.str]] = None,
                 should_load_balance_vm_attachments: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupV2StorageFeatureArgs', 'VolumeGroupV2StorageFeatureArgsDict']]]]] = None,
                 target_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 usage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to Create a new Volume Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        volume_group_example = nutanix.VolumeGroupV2("volume_group_example",
            name="volume_group_test",
            description="Test Create Volume group with spec",
            should_load_balance_vm_attachments=False,
            sharing_status="SHARED",
            target_name="volumegroup-test-001234",
            created_by="example",
            cluster_reference="ab520e1d-4950-1db1-917f-a9e2ea35b8e3",
            iscsi_features=[{
                "enabled_authentications": "CHAP",
                "target_secret": "123456789abc",
            }],
            storage_features=[{
                "flash_modes": [{
                    "is_enabled": True,
                }],
            }],
            usage_type="USER",
            is_hidden=False)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] attachment_type: -(Optional) The field indicates whether a VG has a VM or an external attachment associated with it. Valid values are :
               - EXTERNAL : Volume Group has an external iSCSI or NVMf attachment.
               - NONE : Volume Group has no attachment.
               - DIRECT : Volume Group has a VM attachment.
        :param pulumi.Input[_builtins.str] cluster_reference: -(Required) The UUID of the cluster that will host the Volume Group.
        :param pulumi.Input[_builtins.str] created_by: -(Optional) Service/user who created this Volume Group.
        :param pulumi.Input[_builtins.str] description: -(Optional) Volume Group description. This is an optional field.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupV2DiskArgs', 'VolumeGroupV2DiskArgsDict']]]] disks: -(Optional) A list of Volume Disks to be attached to the Volume Group.
        :param pulumi.Input[_builtins.str] enabled_authentications: -(Optional) The authentication type enabled for the Volume Group. Valid values are CHAP, NONE
        :param pulumi.Input[_builtins.bool] is_hidden: -(Optional) Indicates whether the Volume Group is meant to be hidden or not.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupV2IscsiFeatureArgs', 'VolumeGroupV2IscsiFeatureArgsDict']]]] iscsi_features: -(Optional) iSCSI specific settings for the Volume Group.
        :param pulumi.Input[_builtins.str] name: -(Required) Volume Group name. This is an optional field.
        :param pulumi.Input[_builtins.str] protocol: -(Optional) Type of protocol to be used for Volume Group. Valid values are :
               - NOT_ASSIGNED :  Volume Group does not use any protocol.
               - ISCSI : Volume Group uses iSCSI protocol.
               - NVMF : Volume Group uses NVMf protocol.
        :param pulumi.Input[_builtins.str] sharing_status: -(Optional) Indicates whether the Volume Group can be shared across multiple iSCSI initiators. The mode cannot be changed from SHARED to NOT_SHARED on a Volume Group with multiple attachments. Similarly, a Volume Group cannot be associated with more than one attachment as long as it is in exclusive mode. This is an optional field. Valid values are SHARED, NOT_SHARED
        :param pulumi.Input[_builtins.bool] should_load_balance_vm_attachments: -(Optional) Indicates whether to enable Volume Group load balancing for VM attachments. This cannot be enabled if there are iSCSI client attachments already associated with the Volume Group, and vice-versa. This is an optional field.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupV2StorageFeatureArgs', 'VolumeGroupV2StorageFeatureArgsDict']]]] storage_features: -(Optional) Storage optimization features which must be enabled on the Volume Group.
        :param pulumi.Input[_builtins.str] target_name: -(Optional) Name of the external client target that will be visible and accessible to the client.
        :param pulumi.Input[_builtins.str] target_prefix: The specifications contain the target prefix for external clients as the value. This is an optional field.
        :param pulumi.Input[_builtins.str] usage_type: -(Optional) Expected usage type for the Volume Group. This is an indicative hint on how the caller will consume the Volume Group.  Valid values are BACKUP_TARGET, INTERNAL, TEMPORARY, USER
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeGroupV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to Create a new Volume Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        volume_group_example = nutanix.VolumeGroupV2("volume_group_example",
            name="volume_group_test",
            description="Test Create Volume group with spec",
            should_load_balance_vm_attachments=False,
            sharing_status="SHARED",
            target_name="volumegroup-test-001234",
            created_by="example",
            cluster_reference="ab520e1d-4950-1db1-917f-a9e2ea35b8e3",
            iscsi_features=[{
                "enabled_authentications": "CHAP",
                "target_secret": "123456789abc",
            }],
            storage_features=[{
                "flash_modes": [{
                    "is_enabled": True,
                }],
            }],
            usage_type="USER",
            is_hidden=False)
        ```

        :param str resource_name: The name of the resource.
        :param VolumeGroupV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeGroupV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupV2DiskArgs', 'VolumeGroupV2DiskArgsDict']]]]] = None,
                 enabled_authentications: Optional[pulumi.Input[_builtins.str]] = None,
                 is_hidden: Optional[pulumi.Input[_builtins.bool]] = None,
                 iscsi_features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupV2IscsiFeatureArgs', 'VolumeGroupV2IscsiFeatureArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 sharing_status: Optional[pulumi.Input[_builtins.str]] = None,
                 should_load_balance_vm_attachments: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupV2StorageFeatureArgs', 'VolumeGroupV2StorageFeatureArgsDict']]]]] = None,
                 target_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 usage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeGroupV2Args.__new__(VolumeGroupV2Args)

            __props__.__dict__["attachment_type"] = attachment_type
            if cluster_reference is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_reference'")
            __props__.__dict__["cluster_reference"] = cluster_reference
            __props__.__dict__["created_by"] = created_by
            __props__.__dict__["description"] = description
            __props__.__dict__["disks"] = disks
            __props__.__dict__["enabled_authentications"] = enabled_authentications
            __props__.__dict__["is_hidden"] = is_hidden
            __props__.__dict__["iscsi_features"] = iscsi_features
            __props__.__dict__["name"] = name
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["sharing_status"] = sharing_status
            __props__.__dict__["should_load_balance_vm_attachments"] = should_load_balance_vm_attachments
            __props__.__dict__["storage_features"] = storage_features
            __props__.__dict__["target_name"] = target_name
            __props__.__dict__["target_prefix"] = target_prefix
            __props__.__dict__["usage_type"] = usage_type
            __props__.__dict__["ext_id"] = None
        super(VolumeGroupV2, __self__).__init__(
            'nutanix:index/volumeGroupV2:VolumeGroupV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attachment_type: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_reference: Optional[pulumi.Input[_builtins.str]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupV2DiskArgs', 'VolumeGroupV2DiskArgsDict']]]]] = None,
            enabled_authentications: Optional[pulumi.Input[_builtins.str]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_hidden: Optional[pulumi.Input[_builtins.bool]] = None,
            iscsi_features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupV2IscsiFeatureArgs', 'VolumeGroupV2IscsiFeatureArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            sharing_status: Optional[pulumi.Input[_builtins.str]] = None,
            should_load_balance_vm_attachments: Optional[pulumi.Input[_builtins.bool]] = None,
            storage_features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupV2StorageFeatureArgs', 'VolumeGroupV2StorageFeatureArgsDict']]]]] = None,
            target_name: Optional[pulumi.Input[_builtins.str]] = None,
            target_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            usage_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'VolumeGroupV2':
        """
        Get an existing VolumeGroupV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] attachment_type: -(Optional) The field indicates whether a VG has a VM or an external attachment associated with it. Valid values are :
               - EXTERNAL : Volume Group has an external iSCSI or NVMf attachment.
               - NONE : Volume Group has no attachment.
               - DIRECT : Volume Group has a VM attachment.
        :param pulumi.Input[_builtins.str] cluster_reference: -(Required) The UUID of the cluster that will host the Volume Group.
        :param pulumi.Input[_builtins.str] created_by: -(Optional) Service/user who created this Volume Group.
        :param pulumi.Input[_builtins.str] description: -(Optional) Volume Group description. This is an optional field.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupV2DiskArgs', 'VolumeGroupV2DiskArgsDict']]]] disks: -(Optional) A list of Volume Disks to be attached to the Volume Group.
        :param pulumi.Input[_builtins.str] enabled_authentications: -(Optional) The authentication type enabled for the Volume Group. Valid values are CHAP, NONE
        :param pulumi.Input[_builtins.str] ext_id: -(Optional) A globally unique identifier of an instance that is suitable for external consumption.
        :param pulumi.Input[_builtins.bool] is_hidden: -(Optional) Indicates whether the Volume Group is meant to be hidden or not.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupV2IscsiFeatureArgs', 'VolumeGroupV2IscsiFeatureArgsDict']]]] iscsi_features: -(Optional) iSCSI specific settings for the Volume Group.
        :param pulumi.Input[_builtins.str] name: -(Required) Volume Group name. This is an optional field.
        :param pulumi.Input[_builtins.str] protocol: -(Optional) Type of protocol to be used for Volume Group. Valid values are :
               - NOT_ASSIGNED :  Volume Group does not use any protocol.
               - ISCSI : Volume Group uses iSCSI protocol.
               - NVMF : Volume Group uses NVMf protocol.
        :param pulumi.Input[_builtins.str] sharing_status: -(Optional) Indicates whether the Volume Group can be shared across multiple iSCSI initiators. The mode cannot be changed from SHARED to NOT_SHARED on a Volume Group with multiple attachments. Similarly, a Volume Group cannot be associated with more than one attachment as long as it is in exclusive mode. This is an optional field. Valid values are SHARED, NOT_SHARED
        :param pulumi.Input[_builtins.bool] should_load_balance_vm_attachments: -(Optional) Indicates whether to enable Volume Group load balancing for VM attachments. This cannot be enabled if there are iSCSI client attachments already associated with the Volume Group, and vice-versa. This is an optional field.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupV2StorageFeatureArgs', 'VolumeGroupV2StorageFeatureArgsDict']]]] storage_features: -(Optional) Storage optimization features which must be enabled on the Volume Group.
        :param pulumi.Input[_builtins.str] target_name: -(Optional) Name of the external client target that will be visible and accessible to the client.
        :param pulumi.Input[_builtins.str] target_prefix: The specifications contain the target prefix for external clients as the value. This is an optional field.
        :param pulumi.Input[_builtins.str] usage_type: -(Optional) Expected usage type for the Volume Group. This is an indicative hint on how the caller will consume the Volume Group.  Valid values are BACKUP_TARGET, INTERNAL, TEMPORARY, USER
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VolumeGroupV2State.__new__(_VolumeGroupV2State)

        __props__.__dict__["attachment_type"] = attachment_type
        __props__.__dict__["cluster_reference"] = cluster_reference
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["description"] = description
        __props__.__dict__["disks"] = disks
        __props__.__dict__["enabled_authentications"] = enabled_authentications
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["is_hidden"] = is_hidden
        __props__.__dict__["iscsi_features"] = iscsi_features
        __props__.__dict__["name"] = name
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["sharing_status"] = sharing_status
        __props__.__dict__["should_load_balance_vm_attachments"] = should_load_balance_vm_attachments
        __props__.__dict__["storage_features"] = storage_features
        __props__.__dict__["target_name"] = target_name
        __props__.__dict__["target_prefix"] = target_prefix
        __props__.__dict__["usage_type"] = usage_type
        return VolumeGroupV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        -(Optional) The field indicates whether a VG has a VM or an external attachment associated with it. Valid values are :
        - EXTERNAL : Volume Group has an external iSCSI or NVMf attachment.
        - NONE : Volume Group has no attachment.
        - DIRECT : Volume Group has a VM attachment.
        """
        return pulumi.get(self, "attachment_type")

    @_builtins.property
    @pulumi.getter(name="clusterReference")
    def cluster_reference(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) The UUID of the cluster that will host the Volume Group.
        """
        return pulumi.get(self, "cluster_reference")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        -(Optional) Service/user who created this Volume Group.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        -(Optional) Volume Group description. This is an optional field.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def disks(self) -> pulumi.Output[Optional[Sequence['outputs.VolumeGroupV2Disk']]]:
        """
        -(Optional) A list of Volume Disks to be attached to the Volume Group.
        """
        return pulumi.get(self, "disks")

    @_builtins.property
    @pulumi.getter(name="enabledAuthentications")
    def enabled_authentications(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        -(Optional) The authentication type enabled for the Volume Group. Valid values are CHAP, NONE
        """
        return pulumi.get(self, "enabled_authentications")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Optional) A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="isHidden")
    def is_hidden(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        -(Optional) Indicates whether the Volume Group is meant to be hidden or not.
        """
        return pulumi.get(self, "is_hidden")

    @_builtins.property
    @pulumi.getter(name="iscsiFeatures")
    def iscsi_features(self) -> pulumi.Output[Sequence['outputs.VolumeGroupV2IscsiFeature']]:
        """
        -(Optional) iSCSI specific settings for the Volume Group.
        """
        return pulumi.get(self, "iscsi_features")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) Volume Group name. This is an optional field.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        -(Optional) Type of protocol to be used for Volume Group. Valid values are :
        - NOT_ASSIGNED :  Volume Group does not use any protocol.
        - ISCSI : Volume Group uses iSCSI protocol.
        - NVMF : Volume Group uses NVMf protocol.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="sharingStatus")
    def sharing_status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        -(Optional) Indicates whether the Volume Group can be shared across multiple iSCSI initiators. The mode cannot be changed from SHARED to NOT_SHARED on a Volume Group with multiple attachments. Similarly, a Volume Group cannot be associated with more than one attachment as long as it is in exclusive mode. This is an optional field. Valid values are SHARED, NOT_SHARED
        """
        return pulumi.get(self, "sharing_status")

    @_builtins.property
    @pulumi.getter(name="shouldLoadBalanceVmAttachments")
    def should_load_balance_vm_attachments(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        -(Optional) Indicates whether to enable Volume Group load balancing for VM attachments. This cannot be enabled if there are iSCSI client attachments already associated with the Volume Group, and vice-versa. This is an optional field.
        """
        return pulumi.get(self, "should_load_balance_vm_attachments")

    @_builtins.property
    @pulumi.getter(name="storageFeatures")
    def storage_features(self) -> pulumi.Output[Optional[Sequence['outputs.VolumeGroupV2StorageFeature']]]:
        """
        -(Optional) Storage optimization features which must be enabled on the Volume Group.
        """
        return pulumi.get(self, "storage_features")

    @_builtins.property
    @pulumi.getter(name="targetName")
    def target_name(self) -> pulumi.Output[_builtins.str]:
        """
        -(Optional) Name of the external client target that will be visible and accessible to the client.
        """
        return pulumi.get(self, "target_name")

    @_builtins.property
    @pulumi.getter(name="targetPrefix")
    def target_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The specifications contain the target prefix for external clients as the value. This is an optional field.
        """
        return pulumi.get(self, "target_prefix")

    @_builtins.property
    @pulumi.getter(name="usageType")
    def usage_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        -(Optional) Expected usage type for the Volume Group. This is an indicative hint on how the caller will consume the Volume Group.  Valid values are BACKUP_TARGET, INTERNAL, TEMPORARY, USER
        """
        return pulumi.get(self, "usage_type")

