# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['VolumeGroupVmV2Args', 'VolumeGroupVmV2']

@pulumi.input_type
class VolumeGroupVmV2Args:
    def __init__(__self__, *,
                 vm_ext_id: pulumi.Input[_builtins.str],
                 volume_group_ext_id: pulumi.Input[_builtins.str],
                 index: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a VolumeGroupVmV2 resource.
        :param pulumi.Input[_builtins.str] vm_ext_id: -(Required) A globally unique identifier of an instance that is suitable for external consumption.
        :param pulumi.Input[_builtins.str] volume_group_ext_id: -(Required) The external identifier of the volume group.
        :param pulumi.Input[_builtins.int] index: -(Optional) The index on the SCSI bus to attach the VM to the Volume Group.
               
               
               See detailed information in [Nutanix Attach VM to Volume Group V4](https://developers.nutanix.com/api-reference?namespace=volumes&version=v4.0#tag/VolumeGroups/operation/attachVm).
        """
        pulumi.set(__self__, "vm_ext_id", vm_ext_id)
        pulumi.set(__self__, "volume_group_ext_id", volume_group_ext_id)
        if index is not None:
            pulumi.set(__self__, "index", index)

    @_builtins.property
    @pulumi.getter(name="vmExtId")
    def vm_ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "vm_ext_id")

    @vm_ext_id.setter
    def vm_ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vm_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="volumeGroupExtId")
    def volume_group_ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) The external identifier of the volume group.
        """
        return pulumi.get(self, "volume_group_ext_id")

    @volume_group_ext_id.setter
    def volume_group_ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "volume_group_ext_id", value)

    @_builtins.property
    @pulumi.getter
    def index(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        -(Optional) The index on the SCSI bus to attach the VM to the Volume Group.


        See detailed information in [Nutanix Attach VM to Volume Group V4](https://developers.nutanix.com/api-reference?namespace=volumes&version=v4.0#tag/VolumeGroups/operation/attachVm).
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "index", value)


@pulumi.input_type
class _VolumeGroupVmV2State:
    def __init__(__self__, *,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 index: Optional[pulumi.Input[_builtins.int]] = None,
                 vm_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_group_ext_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VolumeGroupVmV2 resources.
        :param pulumi.Input[_builtins.str] ext_id: A globally unique identifier of a task.
        :param pulumi.Input[_builtins.int] index: -(Optional) The index on the SCSI bus to attach the VM to the Volume Group.
               
               
               See detailed information in [Nutanix Attach VM to Volume Group V4](https://developers.nutanix.com/api-reference?namespace=volumes&version=v4.0#tag/VolumeGroups/operation/attachVm).
        :param pulumi.Input[_builtins.str] vm_ext_id: -(Required) A globally unique identifier of an instance that is suitable for external consumption.
        :param pulumi.Input[_builtins.str] volume_group_ext_id: -(Required) The external identifier of the volume group.
        """
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if index is not None:
            pulumi.set(__self__, "index", index)
        if vm_ext_id is not None:
            pulumi.set(__self__, "vm_ext_id", vm_ext_id)
        if volume_group_ext_id is not None:
            pulumi.set(__self__, "volume_group_ext_id", volume_group_ext_id)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A globally unique identifier of a task.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter
    def index(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        -(Optional) The index on the SCSI bus to attach the VM to the Volume Group.


        See detailed information in [Nutanix Attach VM to Volume Group V4](https://developers.nutanix.com/api-reference?namespace=volumes&version=v4.0#tag/VolumeGroups/operation/attachVm).
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "index", value)

    @_builtins.property
    @pulumi.getter(name="vmExtId")
    def vm_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "vm_ext_id")

    @vm_ext_id.setter
    def vm_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="volumeGroupExtId")
    def volume_group_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) The external identifier of the volume group.
        """
        return pulumi.get(self, "volume_group_ext_id")

    @volume_group_ext_id.setter
    def volume_group_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_group_ext_id", value)


@pulumi.type_token("nutanix:index/volumeGroupVmV2:VolumeGroupVmV2")
class VolumeGroupVmV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 index: Optional[pulumi.Input[_builtins.int]] = None,
                 vm_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_group_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to Create a new Volume Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        vg_vm_example = nutanix.VolumeGroupVmV2("vg_vm_example",
            volume_group_ext_id="1cdb5b48-fb2c-41b6-b751-b504117ee3e2",
            vm_ext_id="8a938cc5-282b-48c4-81be-de22de145d07")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] index: -(Optional) The index on the SCSI bus to attach the VM to the Volume Group.
               
               
               See detailed information in [Nutanix Attach VM to Volume Group V4](https://developers.nutanix.com/api-reference?namespace=volumes&version=v4.0#tag/VolumeGroups/operation/attachVm).
        :param pulumi.Input[_builtins.str] vm_ext_id: -(Required) A globally unique identifier of an instance that is suitable for external consumption.
        :param pulumi.Input[_builtins.str] volume_group_ext_id: -(Required) The external identifier of the volume group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeGroupVmV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to Create a new Volume Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        vg_vm_example = nutanix.VolumeGroupVmV2("vg_vm_example",
            volume_group_ext_id="1cdb5b48-fb2c-41b6-b751-b504117ee3e2",
            vm_ext_id="8a938cc5-282b-48c4-81be-de22de145d07")
        ```

        :param str resource_name: The name of the resource.
        :param VolumeGroupVmV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeGroupVmV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 index: Optional[pulumi.Input[_builtins.int]] = None,
                 vm_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_group_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeGroupVmV2Args.__new__(VolumeGroupVmV2Args)

            __props__.__dict__["index"] = index
            if vm_ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'vm_ext_id'")
            __props__.__dict__["vm_ext_id"] = vm_ext_id
            if volume_group_ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'volume_group_ext_id'")
            __props__.__dict__["volume_group_ext_id"] = volume_group_ext_id
            __props__.__dict__["ext_id"] = None
        super(VolumeGroupVmV2, __self__).__init__(
            'nutanix:index/volumeGroupVmV2:VolumeGroupVmV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            index: Optional[pulumi.Input[_builtins.int]] = None,
            vm_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            volume_group_ext_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'VolumeGroupVmV2':
        """
        Get an existing VolumeGroupVmV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ext_id: A globally unique identifier of a task.
        :param pulumi.Input[_builtins.int] index: -(Optional) The index on the SCSI bus to attach the VM to the Volume Group.
               
               
               See detailed information in [Nutanix Attach VM to Volume Group V4](https://developers.nutanix.com/api-reference?namespace=volumes&version=v4.0#tag/VolumeGroups/operation/attachVm).
        :param pulumi.Input[_builtins.str] vm_ext_id: -(Required) A globally unique identifier of an instance that is suitable for external consumption.
        :param pulumi.Input[_builtins.str] volume_group_ext_id: -(Required) The external identifier of the volume group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VolumeGroupVmV2State.__new__(_VolumeGroupVmV2State)

        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["index"] = index
        __props__.__dict__["vm_ext_id"] = vm_ext_id
        __props__.__dict__["volume_group_ext_id"] = volume_group_ext_id
        return VolumeGroupVmV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        A globally unique identifier of a task.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter
    def index(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        -(Optional) The index on the SCSI bus to attach the VM to the Volume Group.


        See detailed information in [Nutanix Attach VM to Volume Group V4](https://developers.nutanix.com/api-reference?namespace=volumes&version=v4.0#tag/VolumeGroups/operation/attachVm).
        """
        return pulumi.get(self, "index")

    @_builtins.property
    @pulumi.getter(name="vmExtId")
    def vm_ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "vm_ext_id")

    @_builtins.property
    @pulumi.getter(name="volumeGroupExtId")
    def volume_group_ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) The external identifier of the volume group.
        """
        return pulumi.get(self, "volume_group_ext_id")

