# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VpcArgs', 'Vpc']

@pulumi.input_type
class VpcArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 common_domain_name_server_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input['VpcCommonDomainNameServerIpListArgs']]]] = None,
                 external_subnet_reference_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_subnet_reference_uuids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 externally_routable_prefix_lists: Optional[pulumi.Input[Sequence[pulumi.Input['VpcExternallyRoutablePrefixListArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Vpc resource.
        :param pulumi.Input[_builtins.str] api_version: The version of the API.
        :param pulumi.Input[Sequence[pulumi.Input['VpcCommonDomainNameServerIpListArgs']]] common_domain_name_server_ip_lists: List of domain name server IPs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_subnet_reference_names: List of external subnets name attached to this VPC. Should not be used with external_subnet_reference_uuid.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_subnet_reference_uuids: List of external subnets uuid attached to this VPC. Should not be used with external_subnet_reference_name.
        :param pulumi.Input[Sequence[pulumi.Input['VpcExternallyRoutablePrefixListArgs']]] externally_routable_prefix_lists: List Externally Routable IP Addresses. Required when external subnet with NoNAT is used.
        :param pulumi.Input[_builtins.str] name: The name for the VPC.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if common_domain_name_server_ip_lists is not None:
            pulumi.set(__self__, "common_domain_name_server_ip_lists", common_domain_name_server_ip_lists)
        if external_subnet_reference_names is not None:
            pulumi.set(__self__, "external_subnet_reference_names", external_subnet_reference_names)
        if external_subnet_reference_uuids is not None:
            pulumi.set(__self__, "external_subnet_reference_uuids", external_subnet_reference_uuids)
        if externally_routable_prefix_lists is not None:
            pulumi.set(__self__, "externally_routable_prefix_lists", externally_routable_prefix_lists)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the API.
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter(name="commonDomainNameServerIpLists")
    def common_domain_name_server_ip_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcCommonDomainNameServerIpListArgs']]]]:
        """
        List of domain name server IPs.
        """
        return pulumi.get(self, "common_domain_name_server_ip_lists")

    @common_domain_name_server_ip_lists.setter
    def common_domain_name_server_ip_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcCommonDomainNameServerIpListArgs']]]]):
        pulumi.set(self, "common_domain_name_server_ip_lists", value)

    @_builtins.property
    @pulumi.getter(name="externalSubnetReferenceNames")
    def external_subnet_reference_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of external subnets name attached to this VPC. Should not be used with external_subnet_reference_uuid.
        """
        return pulumi.get(self, "external_subnet_reference_names")

    @external_subnet_reference_names.setter
    def external_subnet_reference_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_subnet_reference_names", value)

    @_builtins.property
    @pulumi.getter(name="externalSubnetReferenceUuids")
    def external_subnet_reference_uuids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of external subnets uuid attached to this VPC. Should not be used with external_subnet_reference_name.
        """
        return pulumi.get(self, "external_subnet_reference_uuids")

    @external_subnet_reference_uuids.setter
    def external_subnet_reference_uuids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_subnet_reference_uuids", value)

    @_builtins.property
    @pulumi.getter(name="externallyRoutablePrefixLists")
    def externally_routable_prefix_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcExternallyRoutablePrefixListArgs']]]]:
        """
        List Externally Routable IP Addresses. Required when external subnet with NoNAT is used.
        """
        return pulumi.get(self, "externally_routable_prefix_lists")

    @externally_routable_prefix_lists.setter
    def externally_routable_prefix_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcExternallyRoutablePrefixListArgs']]]]):
        pulumi.set(self, "externally_routable_prefix_lists", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the VPC.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _VpcState:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 common_domain_name_server_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input['VpcCommonDomainNameServerIpListArgs']]]] = None,
                 external_subnet_list_statuses: Optional[pulumi.Input[Sequence[pulumi.Input['VpcExternalSubnetListStatusArgs']]]] = None,
                 external_subnet_reference_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_subnet_reference_uuids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 externally_routable_prefix_lists: Optional[pulumi.Input[Sequence[pulumi.Input['VpcExternallyRoutablePrefixListArgs']]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Vpc resources.
        :param pulumi.Input[_builtins.str] api_version: The version of the API.
        :param pulumi.Input[Sequence[pulumi.Input['VpcCommonDomainNameServerIpListArgs']]] common_domain_name_server_ip_lists: List of domain name server IPs.
        :param pulumi.Input[Sequence[pulumi.Input['VpcExternalSubnetListStatusArgs']]] external_subnet_list_statuses: Status of List of external subnets attached to this VPC
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_subnet_reference_names: List of external subnets name attached to this VPC. Should not be used with external_subnet_reference_uuid.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_subnet_reference_uuids: List of external subnets uuid attached to this VPC. Should not be used with external_subnet_reference_name.
        :param pulumi.Input[Sequence[pulumi.Input['VpcExternallyRoutablePrefixListArgs']]] externally_routable_prefix_lists: List Externally Routable IP Addresses. Required when external subnet with NoNAT is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: The vpc kind metadata.
        :param pulumi.Input[_builtins.str] name: The name for the VPC.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if common_domain_name_server_ip_lists is not None:
            pulumi.set(__self__, "common_domain_name_server_ip_lists", common_domain_name_server_ip_lists)
        if external_subnet_list_statuses is not None:
            pulumi.set(__self__, "external_subnet_list_statuses", external_subnet_list_statuses)
        if external_subnet_reference_names is not None:
            pulumi.set(__self__, "external_subnet_reference_names", external_subnet_reference_names)
        if external_subnet_reference_uuids is not None:
            pulumi.set(__self__, "external_subnet_reference_uuids", external_subnet_reference_uuids)
        if externally_routable_prefix_lists is not None:
            pulumi.set(__self__, "externally_routable_prefix_lists", externally_routable_prefix_lists)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the API.
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter(name="commonDomainNameServerIpLists")
    def common_domain_name_server_ip_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcCommonDomainNameServerIpListArgs']]]]:
        """
        List of domain name server IPs.
        """
        return pulumi.get(self, "common_domain_name_server_ip_lists")

    @common_domain_name_server_ip_lists.setter
    def common_domain_name_server_ip_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcCommonDomainNameServerIpListArgs']]]]):
        pulumi.set(self, "common_domain_name_server_ip_lists", value)

    @_builtins.property
    @pulumi.getter(name="externalSubnetListStatuses")
    def external_subnet_list_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcExternalSubnetListStatusArgs']]]]:
        """
        Status of List of external subnets attached to this VPC
        """
        return pulumi.get(self, "external_subnet_list_statuses")

    @external_subnet_list_statuses.setter
    def external_subnet_list_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcExternalSubnetListStatusArgs']]]]):
        pulumi.set(self, "external_subnet_list_statuses", value)

    @_builtins.property
    @pulumi.getter(name="externalSubnetReferenceNames")
    def external_subnet_reference_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of external subnets name attached to this VPC. Should not be used with external_subnet_reference_uuid.
        """
        return pulumi.get(self, "external_subnet_reference_names")

    @external_subnet_reference_names.setter
    def external_subnet_reference_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_subnet_reference_names", value)

    @_builtins.property
    @pulumi.getter(name="externalSubnetReferenceUuids")
    def external_subnet_reference_uuids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of external subnets uuid attached to this VPC. Should not be used with external_subnet_reference_name.
        """
        return pulumi.get(self, "external_subnet_reference_uuids")

    @external_subnet_reference_uuids.setter
    def external_subnet_reference_uuids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_subnet_reference_uuids", value)

    @_builtins.property
    @pulumi.getter(name="externallyRoutablePrefixLists")
    def externally_routable_prefix_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcExternallyRoutablePrefixListArgs']]]]:
        """
        List Externally Routable IP Addresses. Required when external subnet with NoNAT is used.
        """
        return pulumi.get(self, "externally_routable_prefix_lists")

    @externally_routable_prefix_lists.setter
    def externally_routable_prefix_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcExternallyRoutablePrefixListArgs']]]]):
        pulumi.set(self, "externally_routable_prefix_lists", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The vpc kind metadata.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the VPC.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("nutanix:index/vpc:Vpc")
class Vpc(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 common_domain_name_server_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcCommonDomainNameServerIpListArgs', 'VpcCommonDomainNameServerIpListArgsDict']]]]] = None,
                 external_subnet_reference_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_subnet_reference_uuids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 externally_routable_prefix_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcExternallyRoutablePrefixListArgs', 'VpcExternallyRoutablePrefixListArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides Nutanix resource to create VPC.

        ## Example Usage

        ### vpc creation with external subnet name

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        vpc = nutanix.Vpc("vpc",
            name="testtNew-1",
            external_subnet_reference_names=[
                "test-Ext1",
                "test-ext2",
            ],
            common_domain_name_server_ip_lists=[
                {
                    "ip": "8.8.8.8",
                },
                {
                    "ip": "8.8.8.9",
                },
            ],
            externally_routable_prefix_lists=[{
                "ip": "192.43.0.0",
                "prefix_length": 16,
            }])
        ```

        ### vpc creation with external subnet uuid

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        vpc = nutanix.Vpc("vpc",
            name="testtNew-1",
            external_subnet_reference_uuids=["<subnet_uuid>"],
            common_domain_name_server_ip_lists=[{
                "ip": "8.8.8.8",
            }],
            externally_routable_prefix_lists=[
                {
                    "ip": "192.43.0.0",
                    "prefix_length": 16,
                },
                {
                    "ip": "192.42.0.0",
                    "prefix_length": 16,
                },
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_version: The version of the API.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpcCommonDomainNameServerIpListArgs', 'VpcCommonDomainNameServerIpListArgsDict']]]] common_domain_name_server_ip_lists: List of domain name server IPs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_subnet_reference_names: List of external subnets name attached to this VPC. Should not be used with external_subnet_reference_uuid.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_subnet_reference_uuids: List of external subnets uuid attached to this VPC. Should not be used with external_subnet_reference_name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpcExternallyRoutablePrefixListArgs', 'VpcExternallyRoutablePrefixListArgsDict']]]] externally_routable_prefix_lists: List Externally Routable IP Addresses. Required when external subnet with NoNAT is used.
        :param pulumi.Input[_builtins.str] name: The name for the VPC.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[VpcArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides Nutanix resource to create VPC.

        ## Example Usage

        ### vpc creation with external subnet name

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        vpc = nutanix.Vpc("vpc",
            name="testtNew-1",
            external_subnet_reference_names=[
                "test-Ext1",
                "test-ext2",
            ],
            common_domain_name_server_ip_lists=[
                {
                    "ip": "8.8.8.8",
                },
                {
                    "ip": "8.8.8.9",
                },
            ],
            externally_routable_prefix_lists=[{
                "ip": "192.43.0.0",
                "prefix_length": 16,
            }])
        ```

        ### vpc creation with external subnet uuid

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        vpc = nutanix.Vpc("vpc",
            name="testtNew-1",
            external_subnet_reference_uuids=["<subnet_uuid>"],
            common_domain_name_server_ip_lists=[{
                "ip": "8.8.8.8",
            }],
            externally_routable_prefix_lists=[
                {
                    "ip": "192.43.0.0",
                    "prefix_length": 16,
                },
                {
                    "ip": "192.42.0.0",
                    "prefix_length": 16,
                },
            ])
        ```

        :param str resource_name: The name of the resource.
        :param VpcArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 common_domain_name_server_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcCommonDomainNameServerIpListArgs', 'VpcCommonDomainNameServerIpListArgsDict']]]]] = None,
                 external_subnet_reference_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_subnet_reference_uuids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 externally_routable_prefix_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcExternallyRoutablePrefixListArgs', 'VpcExternallyRoutablePrefixListArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcArgs.__new__(VpcArgs)

            __props__.__dict__["api_version"] = api_version
            __props__.__dict__["common_domain_name_server_ip_lists"] = common_domain_name_server_ip_lists
            __props__.__dict__["external_subnet_reference_names"] = external_subnet_reference_names
            __props__.__dict__["external_subnet_reference_uuids"] = external_subnet_reference_uuids
            __props__.__dict__["externally_routable_prefix_lists"] = externally_routable_prefix_lists
            __props__.__dict__["name"] = name
            __props__.__dict__["external_subnet_list_statuses"] = None
            __props__.__dict__["metadata"] = None
        super(Vpc, __self__).__init__(
            'nutanix:index/vpc:Vpc',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_version: Optional[pulumi.Input[_builtins.str]] = None,
            common_domain_name_server_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcCommonDomainNameServerIpListArgs', 'VpcCommonDomainNameServerIpListArgsDict']]]]] = None,
            external_subnet_list_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcExternalSubnetListStatusArgs', 'VpcExternalSubnetListStatusArgsDict']]]]] = None,
            external_subnet_reference_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            external_subnet_reference_uuids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            externally_routable_prefix_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcExternallyRoutablePrefixListArgs', 'VpcExternallyRoutablePrefixListArgsDict']]]]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'Vpc':
        """
        Get an existing Vpc resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_version: The version of the API.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpcCommonDomainNameServerIpListArgs', 'VpcCommonDomainNameServerIpListArgsDict']]]] common_domain_name_server_ip_lists: List of domain name server IPs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpcExternalSubnetListStatusArgs', 'VpcExternalSubnetListStatusArgsDict']]]] external_subnet_list_statuses: Status of List of external subnets attached to this VPC
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_subnet_reference_names: List of external subnets name attached to this VPC. Should not be used with external_subnet_reference_uuid.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_subnet_reference_uuids: List of external subnets uuid attached to this VPC. Should not be used with external_subnet_reference_name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpcExternallyRoutablePrefixListArgs', 'VpcExternallyRoutablePrefixListArgsDict']]]] externally_routable_prefix_lists: List Externally Routable IP Addresses. Required when external subnet with NoNAT is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: The vpc kind metadata.
        :param pulumi.Input[_builtins.str] name: The name for the VPC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcState.__new__(_VpcState)

        __props__.__dict__["api_version"] = api_version
        __props__.__dict__["common_domain_name_server_ip_lists"] = common_domain_name_server_ip_lists
        __props__.__dict__["external_subnet_list_statuses"] = external_subnet_list_statuses
        __props__.__dict__["external_subnet_reference_names"] = external_subnet_reference_names
        __props__.__dict__["external_subnet_reference_uuids"] = external_subnet_reference_uuids
        __props__.__dict__["externally_routable_prefix_lists"] = externally_routable_prefix_lists
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        return Vpc(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the API.
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter(name="commonDomainNameServerIpLists")
    def common_domain_name_server_ip_lists(self) -> pulumi.Output[Sequence['outputs.VpcCommonDomainNameServerIpList']]:
        """
        List of domain name server IPs.
        """
        return pulumi.get(self, "common_domain_name_server_ip_lists")

    @_builtins.property
    @pulumi.getter(name="externalSubnetListStatuses")
    def external_subnet_list_statuses(self) -> pulumi.Output[Sequence['outputs.VpcExternalSubnetListStatus']]:
        """
        Status of List of external subnets attached to this VPC
        """
        return pulumi.get(self, "external_subnet_list_statuses")

    @_builtins.property
    @pulumi.getter(name="externalSubnetReferenceNames")
    def external_subnet_reference_names(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of external subnets name attached to this VPC. Should not be used with external_subnet_reference_uuid.
        """
        return pulumi.get(self, "external_subnet_reference_names")

    @_builtins.property
    @pulumi.getter(name="externalSubnetReferenceUuids")
    def external_subnet_reference_uuids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of external subnets uuid attached to this VPC. Should not be used with external_subnet_reference_name.
        """
        return pulumi.get(self, "external_subnet_reference_uuids")

    @_builtins.property
    @pulumi.getter(name="externallyRoutablePrefixLists")
    def externally_routable_prefix_lists(self) -> pulumi.Output[Sequence['outputs.VpcExternallyRoutablePrefixList']]:
        """
        List Externally Routable IP Addresses. Required when external subnet with NoNAT is used.
        """
        return pulumi.get(self, "externally_routable_prefix_lists")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The vpc kind metadata.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name for the VPC.
        """
        return pulumi.get(self, "name")

