# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VpcV2Args', 'VpcV2']

@pulumi.input_type
class VpcV2Args:
    def __init__(__self__, *,
                 common_dhcp_options: Optional[pulumi.Input[Sequence[pulumi.Input['VpcV2CommonDhcpOptionArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_routing_domain_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 external_subnets: Optional[pulumi.Input[Sequence[pulumi.Input['VpcV2ExternalSubnetArgs']]]] = None,
                 externally_routable_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input['VpcV2ExternallyRoutablePrefixArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VpcV2 resource.
        :param pulumi.Input[Sequence[pulumi.Input['VpcV2CommonDhcpOptionArgs']]] common_dhcp_options: List of DHCP options to be configured.
        :param pulumi.Input[_builtins.str] description: Description of the VPC.
        :param pulumi.Input[_builtins.str] external_routing_domain_reference: External routing domain associated with this route table
        :param pulumi.Input[Sequence[pulumi.Input['VpcV2ExternalSubnetArgs']]] external_subnets: List of external subnets that the VPC is attached to.
        :param pulumi.Input[Sequence[pulumi.Input['VpcV2ExternallyRoutablePrefixArgs']]] externally_routable_prefixes: CIDR blocks from the VPC which can talk externally without performing NAT. This is applicable when connecting to external subnets which have disabled NAT.
        :param pulumi.Input[_builtins.str] name: Name of the VPC.
        :param pulumi.Input[_builtins.str] vpc_type: Type of VPC. Acceptable values are "REGULAR" , "TRANSIT".
        """
        if common_dhcp_options is not None:
            pulumi.set(__self__, "common_dhcp_options", common_dhcp_options)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_routing_domain_reference is not None:
            pulumi.set(__self__, "external_routing_domain_reference", external_routing_domain_reference)
        if external_subnets is not None:
            pulumi.set(__self__, "external_subnets", external_subnets)
        if externally_routable_prefixes is not None:
            pulumi.set(__self__, "externally_routable_prefixes", externally_routable_prefixes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if vpc_type is not None:
            pulumi.set(__self__, "vpc_type", vpc_type)

    @_builtins.property
    @pulumi.getter(name="commonDhcpOptions")
    def common_dhcp_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcV2CommonDhcpOptionArgs']]]]:
        """
        List of DHCP options to be configured.
        """
        return pulumi.get(self, "common_dhcp_options")

    @common_dhcp_options.setter
    def common_dhcp_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcV2CommonDhcpOptionArgs']]]]):
        pulumi.set(self, "common_dhcp_options", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the VPC.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="externalRoutingDomainReference")
    def external_routing_domain_reference(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        External routing domain associated with this route table
        """
        return pulumi.get(self, "external_routing_domain_reference")

    @external_routing_domain_reference.setter
    def external_routing_domain_reference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_routing_domain_reference", value)

    @_builtins.property
    @pulumi.getter(name="externalSubnets")
    def external_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcV2ExternalSubnetArgs']]]]:
        """
        List of external subnets that the VPC is attached to.
        """
        return pulumi.get(self, "external_subnets")

    @external_subnets.setter
    def external_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcV2ExternalSubnetArgs']]]]):
        pulumi.set(self, "external_subnets", value)

    @_builtins.property
    @pulumi.getter(name="externallyRoutablePrefixes")
    def externally_routable_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcV2ExternallyRoutablePrefixArgs']]]]:
        """
        CIDR blocks from the VPC which can talk externally without performing NAT. This is applicable when connecting to external subnets which have disabled NAT.
        """
        return pulumi.get(self, "externally_routable_prefixes")

    @externally_routable_prefixes.setter
    def externally_routable_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcV2ExternallyRoutablePrefixArgs']]]]):
        pulumi.set(self, "externally_routable_prefixes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the VPC.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="vpcType")
    def vpc_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of VPC. Acceptable values are "REGULAR" , "TRANSIT".
        """
        return pulumi.get(self, "vpc_type")

    @vpc_type.setter
    def vpc_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_type", value)


@pulumi.input_type
class _VpcV2State:
    def __init__(__self__, *,
                 common_dhcp_options: Optional[pulumi.Input[Sequence[pulumi.Input['VpcV2CommonDhcpOptionArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 external_routing_domain_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 external_subnets: Optional[pulumi.Input[Sequence[pulumi.Input['VpcV2ExternalSubnetArgs']]]] = None,
                 externally_routable_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input['VpcV2ExternallyRoutablePrefixArgs']]]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input['VpcV2LinkArgs']]]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['VpcV2MetadataArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snat_ips: Optional[pulumi.Input[Sequence[pulumi.Input['VpcV2SnatIpArgs']]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VpcV2 resources.
        :param pulumi.Input[Sequence[pulumi.Input['VpcV2CommonDhcpOptionArgs']]] common_dhcp_options: List of DHCP options to be configured.
        :param pulumi.Input[_builtins.str] description: Description of the VPC.
        :param pulumi.Input[_builtins.str] ext_id: the vpc uuid.
        :param pulumi.Input[_builtins.str] external_routing_domain_reference: External routing domain associated with this route table
        :param pulumi.Input[Sequence[pulumi.Input['VpcV2ExternalSubnetArgs']]] external_subnets: List of external subnets that the VPC is attached to.
        :param pulumi.Input[Sequence[pulumi.Input['VpcV2ExternallyRoutablePrefixArgs']]] externally_routable_prefixes: CIDR blocks from the VPC which can talk externally without performing NAT. This is applicable when connecting to external subnets which have disabled NAT.
        :param pulumi.Input[Sequence[pulumi.Input['VpcV2LinkArgs']]] links: A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        :param pulumi.Input[Sequence[pulumi.Input['VpcV2MetadataArgs']]] metadatas: The vpc kind metadata.
        :param pulumi.Input[_builtins.str] name: Name of the VPC.
        :param pulumi.Input[_builtins.str] tenant_id: A globally unique identifier that represents the tenant that owns this entity.
        :param pulumi.Input[_builtins.str] vpc_type: Type of VPC. Acceptable values are "REGULAR" , "TRANSIT".
        """
        if common_dhcp_options is not None:
            pulumi.set(__self__, "common_dhcp_options", common_dhcp_options)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if external_routing_domain_reference is not None:
            pulumi.set(__self__, "external_routing_domain_reference", external_routing_domain_reference)
        if external_subnets is not None:
            pulumi.set(__self__, "external_subnets", external_subnets)
        if externally_routable_prefixes is not None:
            pulumi.set(__self__, "externally_routable_prefixes", externally_routable_prefixes)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snat_ips is not None:
            pulumi.set(__self__, "snat_ips", snat_ips)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if vpc_type is not None:
            pulumi.set(__self__, "vpc_type", vpc_type)

    @_builtins.property
    @pulumi.getter(name="commonDhcpOptions")
    def common_dhcp_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcV2CommonDhcpOptionArgs']]]]:
        """
        List of DHCP options to be configured.
        """
        return pulumi.get(self, "common_dhcp_options")

    @common_dhcp_options.setter
    def common_dhcp_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcV2CommonDhcpOptionArgs']]]]):
        pulumi.set(self, "common_dhcp_options", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the VPC.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the vpc uuid.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="externalRoutingDomainReference")
    def external_routing_domain_reference(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        External routing domain associated with this route table
        """
        return pulumi.get(self, "external_routing_domain_reference")

    @external_routing_domain_reference.setter
    def external_routing_domain_reference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_routing_domain_reference", value)

    @_builtins.property
    @pulumi.getter(name="externalSubnets")
    def external_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcV2ExternalSubnetArgs']]]]:
        """
        List of external subnets that the VPC is attached to.
        """
        return pulumi.get(self, "external_subnets")

    @external_subnets.setter
    def external_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcV2ExternalSubnetArgs']]]]):
        pulumi.set(self, "external_subnets", value)

    @_builtins.property
    @pulumi.getter(name="externallyRoutablePrefixes")
    def externally_routable_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcV2ExternallyRoutablePrefixArgs']]]]:
        """
        CIDR blocks from the VPC which can talk externally without performing NAT. This is applicable when connecting to external subnets which have disabled NAT.
        """
        return pulumi.get(self, "externally_routable_prefixes")

    @externally_routable_prefixes.setter
    def externally_routable_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcV2ExternallyRoutablePrefixArgs']]]]):
        pulumi.set(self, "externally_routable_prefixes", value)

    @_builtins.property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcV2LinkArgs']]]]:
        """
        A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcV2LinkArgs']]]]):
        pulumi.set(self, "links", value)

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcV2MetadataArgs']]]]:
        """
        The vpc kind metadata.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcV2MetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the VPC.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="snatIps")
    def snat_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcV2SnatIpArgs']]]]:
        return pulumi.get(self, "snat_ips")

    @snat_ips.setter
    def snat_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcV2SnatIpArgs']]]]):
        pulumi.set(self, "snat_ips", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A globally unique identifier that represents the tenant that owns this entity.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcType")
    def vpc_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of VPC. Acceptable values are "REGULAR" , "TRANSIT".
        """
        return pulumi.get(self, "vpc_type")

    @vpc_type.setter
    def vpc_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_type", value)


@pulumi.type_token("nutanix:index/vpcV2:VpcV2")
class VpcV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 common_dhcp_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcV2CommonDhcpOptionArgs', 'VpcV2CommonDhcpOptionArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_routing_domain_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 external_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcV2ExternalSubnetArgs', 'VpcV2ExternalSubnetArgsDict']]]]] = None,
                 externally_routable_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcV2ExternallyRoutablePrefixArgs', 'VpcV2ExternallyRoutablePrefixArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides Nutanix resource to create VPC.

        ## Example

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        vpc = nutanix.VpcV2("vpc",
            name="vpc-example",
            description="VPC for example",
            external_subnets=[{
                "subnet_reference": "a8fe48c4-f0d3-49c7-a017-efc30dd8fb2b",
            }])
        # creating VPC with external routable prefixes
        external_vpc_routable_vpc = nutanix.VpcV2("external-vpc-routable-vpc",
            name="tf-vpc-example",
            description="VPC ",
            external_subnets=[{
                "subnet_reference": "a8fe48c4-f0d3-49c7-a017-efc30dd8fb2b",
                "external_ips": [
                    {
                        "ipv4s": [{
                            "value": "192.168.0.24",
                            "prefix_length": 32,
                        }],
                    },
                    {
                        "ipv4s": [{
                            "value": "192.168.0.25",
                            "prefix_length": 32,
                        }],
                    },
                ],
            }],
            externally_routable_prefixes=[{
                "ipv4s": [{
                    "ips": [{
                        "value": "172.30.0.0",
                        "prefix_length": 32,
                    }],
                    "prefix_length": 16,
                }],
            }])
        # creating VPC with transit type
        transit_vpc = nutanix.VpcV2("transit-vpc",
            name="vpc-transit",
            description="VPC for transit type",
            external_subnets=[{
                "subnet_reference": "a8fe48c4-f0d3-49c7-a017-efc30dd8fb2b",
            }],
            vpc_type="TRANSIT")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpcV2CommonDhcpOptionArgs', 'VpcV2CommonDhcpOptionArgsDict']]]] common_dhcp_options: List of DHCP options to be configured.
        :param pulumi.Input[_builtins.str] description: Description of the VPC.
        :param pulumi.Input[_builtins.str] external_routing_domain_reference: External routing domain associated with this route table
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpcV2ExternalSubnetArgs', 'VpcV2ExternalSubnetArgsDict']]]] external_subnets: List of external subnets that the VPC is attached to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpcV2ExternallyRoutablePrefixArgs', 'VpcV2ExternallyRoutablePrefixArgsDict']]]] externally_routable_prefixes: CIDR blocks from the VPC which can talk externally without performing NAT. This is applicable when connecting to external subnets which have disabled NAT.
        :param pulumi.Input[_builtins.str] name: Name of the VPC.
        :param pulumi.Input[_builtins.str] vpc_type: Type of VPC. Acceptable values are "REGULAR" , "TRANSIT".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[VpcV2Args] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides Nutanix resource to create VPC.

        ## Example

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        vpc = nutanix.VpcV2("vpc",
            name="vpc-example",
            description="VPC for example",
            external_subnets=[{
                "subnet_reference": "a8fe48c4-f0d3-49c7-a017-efc30dd8fb2b",
            }])
        # creating VPC with external routable prefixes
        external_vpc_routable_vpc = nutanix.VpcV2("external-vpc-routable-vpc",
            name="tf-vpc-example",
            description="VPC ",
            external_subnets=[{
                "subnet_reference": "a8fe48c4-f0d3-49c7-a017-efc30dd8fb2b",
                "external_ips": [
                    {
                        "ipv4s": [{
                            "value": "192.168.0.24",
                            "prefix_length": 32,
                        }],
                    },
                    {
                        "ipv4s": [{
                            "value": "192.168.0.25",
                            "prefix_length": 32,
                        }],
                    },
                ],
            }],
            externally_routable_prefixes=[{
                "ipv4s": [{
                    "ips": [{
                        "value": "172.30.0.0",
                        "prefix_length": 32,
                    }],
                    "prefix_length": 16,
                }],
            }])
        # creating VPC with transit type
        transit_vpc = nutanix.VpcV2("transit-vpc",
            name="vpc-transit",
            description="VPC for transit type",
            external_subnets=[{
                "subnet_reference": "a8fe48c4-f0d3-49c7-a017-efc30dd8fb2b",
            }],
            vpc_type="TRANSIT")
        ```

        :param str resource_name: The name of the resource.
        :param VpcV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 common_dhcp_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcV2CommonDhcpOptionArgs', 'VpcV2CommonDhcpOptionArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_routing_domain_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 external_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcV2ExternalSubnetArgs', 'VpcV2ExternalSubnetArgsDict']]]]] = None,
                 externally_routable_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcV2ExternallyRoutablePrefixArgs', 'VpcV2ExternallyRoutablePrefixArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcV2Args.__new__(VpcV2Args)

            __props__.__dict__["common_dhcp_options"] = common_dhcp_options
            __props__.__dict__["description"] = description
            __props__.__dict__["external_routing_domain_reference"] = external_routing_domain_reference
            __props__.__dict__["external_subnets"] = external_subnets
            __props__.__dict__["externally_routable_prefixes"] = externally_routable_prefixes
            __props__.__dict__["name"] = name
            __props__.__dict__["vpc_type"] = vpc_type
            __props__.__dict__["ext_id"] = None
            __props__.__dict__["links"] = None
            __props__.__dict__["metadatas"] = None
            __props__.__dict__["snat_ips"] = None
            __props__.__dict__["tenant_id"] = None
        super(VpcV2, __self__).__init__(
            'nutanix:index/vpcV2:VpcV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            common_dhcp_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcV2CommonDhcpOptionArgs', 'VpcV2CommonDhcpOptionArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            external_routing_domain_reference: Optional[pulumi.Input[_builtins.str]] = None,
            external_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcV2ExternalSubnetArgs', 'VpcV2ExternalSubnetArgsDict']]]]] = None,
            externally_routable_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcV2ExternallyRoutablePrefixArgs', 'VpcV2ExternallyRoutablePrefixArgsDict']]]]] = None,
            links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcV2LinkArgs', 'VpcV2LinkArgsDict']]]]] = None,
            metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcV2MetadataArgs', 'VpcV2MetadataArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            snat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcV2SnatIpArgs', 'VpcV2SnatIpArgsDict']]]]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'VpcV2':
        """
        Get an existing VpcV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpcV2CommonDhcpOptionArgs', 'VpcV2CommonDhcpOptionArgsDict']]]] common_dhcp_options: List of DHCP options to be configured.
        :param pulumi.Input[_builtins.str] description: Description of the VPC.
        :param pulumi.Input[_builtins.str] ext_id: the vpc uuid.
        :param pulumi.Input[_builtins.str] external_routing_domain_reference: External routing domain associated with this route table
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpcV2ExternalSubnetArgs', 'VpcV2ExternalSubnetArgsDict']]]] external_subnets: List of external subnets that the VPC is attached to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpcV2ExternallyRoutablePrefixArgs', 'VpcV2ExternallyRoutablePrefixArgsDict']]]] externally_routable_prefixes: CIDR blocks from the VPC which can talk externally without performing NAT. This is applicable when connecting to external subnets which have disabled NAT.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpcV2LinkArgs', 'VpcV2LinkArgsDict']]]] links: A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpcV2MetadataArgs', 'VpcV2MetadataArgsDict']]]] metadatas: The vpc kind metadata.
        :param pulumi.Input[_builtins.str] name: Name of the VPC.
        :param pulumi.Input[_builtins.str] tenant_id: A globally unique identifier that represents the tenant that owns this entity.
        :param pulumi.Input[_builtins.str] vpc_type: Type of VPC. Acceptable values are "REGULAR" , "TRANSIT".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcV2State.__new__(_VpcV2State)

        __props__.__dict__["common_dhcp_options"] = common_dhcp_options
        __props__.__dict__["description"] = description
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["external_routing_domain_reference"] = external_routing_domain_reference
        __props__.__dict__["external_subnets"] = external_subnets
        __props__.__dict__["externally_routable_prefixes"] = externally_routable_prefixes
        __props__.__dict__["links"] = links
        __props__.__dict__["metadatas"] = metadatas
        __props__.__dict__["name"] = name
        __props__.__dict__["snat_ips"] = snat_ips
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["vpc_type"] = vpc_type
        return VpcV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="commonDhcpOptions")
    def common_dhcp_options(self) -> pulumi.Output[Sequence['outputs.VpcV2CommonDhcpOption']]:
        """
        List of DHCP options to be configured.
        """
        return pulumi.get(self, "common_dhcp_options")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the VPC.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        the vpc uuid.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="externalRoutingDomainReference")
    def external_routing_domain_reference(self) -> pulumi.Output[_builtins.str]:
        """
        External routing domain associated with this route table
        """
        return pulumi.get(self, "external_routing_domain_reference")

    @_builtins.property
    @pulumi.getter(name="externalSubnets")
    def external_subnets(self) -> pulumi.Output[Sequence['outputs.VpcV2ExternalSubnet']]:
        """
        List of external subnets that the VPC is attached to.
        """
        return pulumi.get(self, "external_subnets")

    @_builtins.property
    @pulumi.getter(name="externallyRoutablePrefixes")
    def externally_routable_prefixes(self) -> pulumi.Output[Sequence['outputs.VpcV2ExternallyRoutablePrefix']]:
        """
        CIDR blocks from the VPC which can talk externally without performing NAT. This is applicable when connecting to external subnets which have disabled NAT.
        """
        return pulumi.get(self, "externally_routable_prefixes")

    @_builtins.property
    @pulumi.getter
    def links(self) -> pulumi.Output[Sequence['outputs.VpcV2Link']]:
        """
        A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> pulumi.Output[Sequence['outputs.VpcV2Metadata']]:
        """
        The vpc kind metadata.
        """
        return pulumi.get(self, "metadatas")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the VPC.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="snatIps")
    def snat_ips(self) -> pulumi.Output[Sequence['outputs.VpcV2SnatIp']]:
        return pulumi.get(self, "snat_ips")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        A globally unique identifier that represents the tenant that owns this entity.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="vpcType")
    def vpc_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Type of VPC. Acceptable values are "REGULAR" , "TRANSIT".
        """
        return pulumi.get(self, "vpc_type")

