# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'ExchangeSettings',
    'FederationUpstreamDefinition',
    'OperatorPolicyPolicy',
    'PermissionsPermissions',
    'PolicyPolicy',
    'QueueSettings',
    'ShovelInfo',
    'TopicPermissionsPermission',
    'GetExchangeSettingResult',
]

@pulumi.output_type
class ExchangeSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoDelete":
            suggest = "auto_delete"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExchangeSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExchangeSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExchangeSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 arguments: Optional[Mapping[str, _builtins.str]] = None,
                 auto_delete: Optional[_builtins.bool] = None,
                 durable: Optional[_builtins.bool] = None):
        """
        :param _builtins.str type: The type of exchange.
        :param Mapping[str, _builtins.str] arguments: Additional key/value settings for the exchange.
        :param _builtins.bool auto_delete: Whether the exchange will self-delete when all
               queues have finished using it.
        :param _builtins.bool durable: Whether the exchange survives server restarts.
               Defaults to `false`.
        """
        pulumi.set(__self__, "type", type)
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if auto_delete is not None:
            pulumi.set(__self__, "auto_delete", auto_delete)
        if durable is not None:
            pulumi.set(__self__, "durable", durable)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of exchange.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def arguments(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Additional key/value settings for the exchange.
        """
        return pulumi.get(self, "arguments")

    @_builtins.property
    @pulumi.getter(name="autoDelete")
    def auto_delete(self) -> Optional[_builtins.bool]:
        """
        Whether the exchange will self-delete when all
        queues have finished using it.
        """
        return pulumi.get(self, "auto_delete")

    @_builtins.property
    @pulumi.getter
    def durable(self) -> Optional[_builtins.bool]:
        """
        Whether the exchange survives server restarts.
        Defaults to `false`.
        """
        return pulumi.get(self, "durable")


@pulumi.output_type
class FederationUpstreamDefinition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ackMode":
            suggest = "ack_mode"
        elif key == "maxHops":
            suggest = "max_hops"
        elif key == "messageTtl":
            suggest = "message_ttl"
        elif key == "prefetchCount":
            suggest = "prefetch_count"
        elif key == "reconnectDelay":
            suggest = "reconnect_delay"
        elif key == "trustUserId":
            suggest = "trust_user_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FederationUpstreamDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FederationUpstreamDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FederationUpstreamDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 uri: _builtins.str,
                 ack_mode: Optional[_builtins.str] = None,
                 exchange: Optional[_builtins.str] = None,
                 expires: Optional[_builtins.int] = None,
                 max_hops: Optional[_builtins.int] = None,
                 message_ttl: Optional[_builtins.int] = None,
                 prefetch_count: Optional[_builtins.int] = None,
                 queue: Optional[_builtins.str] = None,
                 reconnect_delay: Optional[_builtins.int] = None,
                 trust_user_id: Optional[_builtins.bool] = None):
        """
        :param _builtins.str uri: The AMQP URI(s) for the upstream. Note that the URI may contain sensitive information, such as a password.
        :param _builtins.str ack_mode: Determines how the link should acknowledge messages. Valid values are `on-confirm`, `on-publish`, and `no-ack`. Default is `on-confirm`.
        :param _builtins.str exchange: The name of the upstream exchange.
        :param _builtins.int expires: The expiry time (in milliseconds) after which an upstream queue for a federated exchange may be deleted if a connection to the upstream is lost.
        :param _builtins.int max_hops: Maximum number of federation links that messages can traverse before being dropped. Default is `1`.
        :param _builtins.int message_ttl: The expiry time (in milliseconds) for messages in the upstream queue for a federated exchange (see expires).
               
               Applicable to Federated Queues Only
        :param _builtins.int prefetch_count: Maximum number of unacknowledged messages that may be in flight over a federation link at one time. Default is `1000`.
        :param _builtins.str queue: The name of the upstream queue.
               
               Consult the RabbitMQ [Federation Reference](https://www.rabbitmq.com/federation-reference.html) documentation for detailed information and guidance on setting these values.
        :param _builtins.int reconnect_delay: Time in seconds to wait after a network link goes down before attempting reconnection. Default is `5`.
        :param _builtins.bool trust_user_id: Determines how federation should interact with the validated user-id feature. Default is `false`.
               
               Applicable to Federated Exchanges Only
        """
        pulumi.set(__self__, "uri", uri)
        if ack_mode is not None:
            pulumi.set(__self__, "ack_mode", ack_mode)
        if exchange is not None:
            pulumi.set(__self__, "exchange", exchange)
        if expires is not None:
            pulumi.set(__self__, "expires", expires)
        if max_hops is not None:
            pulumi.set(__self__, "max_hops", max_hops)
        if message_ttl is not None:
            pulumi.set(__self__, "message_ttl", message_ttl)
        if prefetch_count is not None:
            pulumi.set(__self__, "prefetch_count", prefetch_count)
        if queue is not None:
            pulumi.set(__self__, "queue", queue)
        if reconnect_delay is not None:
            pulumi.set(__self__, "reconnect_delay", reconnect_delay)
        if trust_user_id is not None:
            pulumi.set(__self__, "trust_user_id", trust_user_id)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        The AMQP URI(s) for the upstream. Note that the URI may contain sensitive information, such as a password.
        """
        return pulumi.get(self, "uri")

    @_builtins.property
    @pulumi.getter(name="ackMode")
    def ack_mode(self) -> Optional[_builtins.str]:
        """
        Determines how the link should acknowledge messages. Valid values are `on-confirm`, `on-publish`, and `no-ack`. Default is `on-confirm`.
        """
        return pulumi.get(self, "ack_mode")

    @_builtins.property
    @pulumi.getter
    def exchange(self) -> Optional[_builtins.str]:
        """
        The name of the upstream exchange.
        """
        return pulumi.get(self, "exchange")

    @_builtins.property
    @pulumi.getter
    def expires(self) -> Optional[_builtins.int]:
        """
        The expiry time (in milliseconds) after which an upstream queue for a federated exchange may be deleted if a connection to the upstream is lost.
        """
        return pulumi.get(self, "expires")

    @_builtins.property
    @pulumi.getter(name="maxHops")
    def max_hops(self) -> Optional[_builtins.int]:
        """
        Maximum number of federation links that messages can traverse before being dropped. Default is `1`.
        """
        return pulumi.get(self, "max_hops")

    @_builtins.property
    @pulumi.getter(name="messageTtl")
    def message_ttl(self) -> Optional[_builtins.int]:
        """
        The expiry time (in milliseconds) for messages in the upstream queue for a federated exchange (see expires).

        Applicable to Federated Queues Only
        """
        return pulumi.get(self, "message_ttl")

    @_builtins.property
    @pulumi.getter(name="prefetchCount")
    def prefetch_count(self) -> Optional[_builtins.int]:
        """
        Maximum number of unacknowledged messages that may be in flight over a federation link at one time. Default is `1000`.
        """
        return pulumi.get(self, "prefetch_count")

    @_builtins.property
    @pulumi.getter
    def queue(self) -> Optional[_builtins.str]:
        """
        The name of the upstream queue.

        Consult the RabbitMQ [Federation Reference](https://www.rabbitmq.com/federation-reference.html) documentation for detailed information and guidance on setting these values.
        """
        return pulumi.get(self, "queue")

    @_builtins.property
    @pulumi.getter(name="reconnectDelay")
    def reconnect_delay(self) -> Optional[_builtins.int]:
        """
        Time in seconds to wait after a network link goes down before attempting reconnection. Default is `5`.
        """
        return pulumi.get(self, "reconnect_delay")

    @_builtins.property
    @pulumi.getter(name="trustUserId")
    def trust_user_id(self) -> Optional[_builtins.bool]:
        """
        Determines how federation should interact with the validated user-id feature. Default is `false`.

        Applicable to Federated Exchanges Only
        """
        return pulumi.get(self, "trust_user_id")


@pulumi.output_type
class OperatorPolicyPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applyTo":
            suggest = "apply_to"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OperatorPolicyPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OperatorPolicyPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OperatorPolicyPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apply_to: _builtins.str,
                 definition: Mapping[str, _builtins.str],
                 pattern: _builtins.str,
                 priority: _builtins.int):
        """
        :param _builtins.str apply_to: Can be "queues".
        :param Mapping[str, _builtins.str] definition: Key/value pairs of the operator policy definition. See the
               RabbitMQ documentation for definition references and examples.
        :param _builtins.str pattern: A pattern to match an exchange or queue name.
        :param _builtins.int priority: The policy with the greater priority is applied first.
        """
        pulumi.set(__self__, "apply_to", apply_to)
        pulumi.set(__self__, "definition", definition)
        pulumi.set(__self__, "pattern", pattern)
        pulumi.set(__self__, "priority", priority)

    @_builtins.property
    @pulumi.getter(name="applyTo")
    def apply_to(self) -> _builtins.str:
        """
        Can be "queues".
        """
        return pulumi.get(self, "apply_to")

    @_builtins.property
    @pulumi.getter
    def definition(self) -> Mapping[str, _builtins.str]:
        """
        Key/value pairs of the operator policy definition. See the
        RabbitMQ documentation for definition references and examples.
        """
        return pulumi.get(self, "definition")

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> _builtins.str:
        """
        A pattern to match an exchange or queue name.
        """
        return pulumi.get(self, "pattern")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        The policy with the greater priority is applied first.
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class PermissionsPermissions(dict):
    def __init__(__self__, *,
                 configure: _builtins.str,
                 read: _builtins.str,
                 write: _builtins.str):
        """
        :param _builtins.str configure: The "configure" ACL.
        :param _builtins.str read: The "read" ACL.
        :param _builtins.str write: The "write" ACL.
        """
        pulumi.set(__self__, "configure", configure)
        pulumi.set(__self__, "read", read)
        pulumi.set(__self__, "write", write)

    @_builtins.property
    @pulumi.getter
    def configure(self) -> _builtins.str:
        """
        The "configure" ACL.
        """
        return pulumi.get(self, "configure")

    @_builtins.property
    @pulumi.getter
    def read(self) -> _builtins.str:
        """
        The "read" ACL.
        """
        return pulumi.get(self, "read")

    @_builtins.property
    @pulumi.getter
    def write(self) -> _builtins.str:
        """
        The "write" ACL.
        """
        return pulumi.get(self, "write")


@pulumi.output_type
class PolicyPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applyTo":
            suggest = "apply_to"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apply_to: _builtins.str,
                 definition: Mapping[str, _builtins.str],
                 pattern: _builtins.str,
                 priority: _builtins.int):
        """
        :param _builtins.str apply_to: Can either be "exchanges", "queues", or "all".
        :param Mapping[str, _builtins.str] definition: Key/value pairs of the policy definition. See the
               RabbitMQ documentation for definition references and examples.
        :param _builtins.str pattern: A pattern to match an exchange or queue name.
        :param _builtins.int priority: The policy with the greater priority is applied first.
        """
        pulumi.set(__self__, "apply_to", apply_to)
        pulumi.set(__self__, "definition", definition)
        pulumi.set(__self__, "pattern", pattern)
        pulumi.set(__self__, "priority", priority)

    @_builtins.property
    @pulumi.getter(name="applyTo")
    def apply_to(self) -> _builtins.str:
        """
        Can either be "exchanges", "queues", or "all".
        """
        return pulumi.get(self, "apply_to")

    @_builtins.property
    @pulumi.getter
    def definition(self) -> Mapping[str, _builtins.str]:
        """
        Key/value pairs of the policy definition. See the
        RabbitMQ documentation for definition references and examples.
        """
        return pulumi.get(self, "definition")

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> _builtins.str:
        """
        A pattern to match an exchange or queue name.
        """
        return pulumi.get(self, "pattern")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        The policy with the greater priority is applied first.
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class QueueSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "argumentsJson":
            suggest = "arguments_json"
        elif key == "autoDelete":
            suggest = "auto_delete"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QueueSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QueueSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QueueSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arguments: Optional[Mapping[str, _builtins.str]] = None,
                 arguments_json: Optional[_builtins.str] = None,
                 auto_delete: Optional[_builtins.bool] = None,
                 durable: Optional[_builtins.bool] = None):
        """
        :param Mapping[str, _builtins.str] arguments: Additional key/value settings for the queue.
               All values will be sent to RabbitMQ as a string. If you require non-string
               values, use `arguments_json`.
        :param _builtins.str arguments_json: A nested JSON string which contains additional
               settings for the queue. This is useful for when the arguments contain
               non-string values.
        :param _builtins.bool auto_delete: Whether the queue will self-delete when all
               consumers have unsubscribed.
        :param _builtins.bool durable: Whether the queue survives server restarts.
               Defaults to `false`.
        """
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if arguments_json is not None:
            pulumi.set(__self__, "arguments_json", arguments_json)
        if auto_delete is not None:
            pulumi.set(__self__, "auto_delete", auto_delete)
        if durable is not None:
            pulumi.set(__self__, "durable", durable)

    @_builtins.property
    @pulumi.getter
    def arguments(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Additional key/value settings for the queue.
        All values will be sent to RabbitMQ as a string. If you require non-string
        values, use `arguments_json`.
        """
        return pulumi.get(self, "arguments")

    @_builtins.property
    @pulumi.getter(name="argumentsJson")
    def arguments_json(self) -> Optional[_builtins.str]:
        """
        A nested JSON string which contains additional
        settings for the queue. This is useful for when the arguments contain
        non-string values.
        """
        return pulumi.get(self, "arguments_json")

    @_builtins.property
    @pulumi.getter(name="autoDelete")
    def auto_delete(self) -> Optional[_builtins.bool]:
        """
        Whether the queue will self-delete when all
        consumers have unsubscribed.
        """
        return pulumi.get(self, "auto_delete")

    @_builtins.property
    @pulumi.getter
    def durable(self) -> Optional[_builtins.bool]:
        """
        Whether the queue survives server restarts.
        Defaults to `false`.
        """
        return pulumi.get(self, "durable")


@pulumi.output_type
class ShovelInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationUri":
            suggest = "destination_uri"
        elif key == "sourceUri":
            suggest = "source_uri"
        elif key == "ackMode":
            suggest = "ack_mode"
        elif key == "addForwardHeaders":
            suggest = "add_forward_headers"
        elif key == "deleteAfter":
            suggest = "delete_after"
        elif key == "destinationAddForwardHeaders":
            suggest = "destination_add_forward_headers"
        elif key == "destinationAddTimestampHeader":
            suggest = "destination_add_timestamp_header"
        elif key == "destinationAddress":
            suggest = "destination_address"
        elif key == "destinationApplicationProperties":
            suggest = "destination_application_properties"
        elif key == "destinationExchange":
            suggest = "destination_exchange"
        elif key == "destinationExchangeKey":
            suggest = "destination_exchange_key"
        elif key == "destinationProperties":
            suggest = "destination_properties"
        elif key == "destinationProtocol":
            suggest = "destination_protocol"
        elif key == "destinationPublishProperties":
            suggest = "destination_publish_properties"
        elif key == "destinationQueue":
            suggest = "destination_queue"
        elif key == "destinationQueueArguments":
            suggest = "destination_queue_arguments"
        elif key == "prefetchCount":
            suggest = "prefetch_count"
        elif key == "reconnectDelay":
            suggest = "reconnect_delay"
        elif key == "sourceAddress":
            suggest = "source_address"
        elif key == "sourceDeleteAfter":
            suggest = "source_delete_after"
        elif key == "sourceExchange":
            suggest = "source_exchange"
        elif key == "sourceExchangeKey":
            suggest = "source_exchange_key"
        elif key == "sourcePrefetchCount":
            suggest = "source_prefetch_count"
        elif key == "sourceProtocol":
            suggest = "source_protocol"
        elif key == "sourceQueue":
            suggest = "source_queue"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShovelInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShovelInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShovelInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_uri: _builtins.str,
                 source_uri: _builtins.str,
                 ack_mode: Optional[_builtins.str] = None,
                 add_forward_headers: Optional[_builtins.bool] = None,
                 delete_after: Optional[_builtins.str] = None,
                 destination_add_forward_headers: Optional[_builtins.bool] = None,
                 destination_add_timestamp_header: Optional[_builtins.bool] = None,
                 destination_address: Optional[_builtins.str] = None,
                 destination_application_properties: Optional[Mapping[str, _builtins.str]] = None,
                 destination_exchange: Optional[_builtins.str] = None,
                 destination_exchange_key: Optional[_builtins.str] = None,
                 destination_properties: Optional[Mapping[str, _builtins.str]] = None,
                 destination_protocol: Optional[_builtins.str] = None,
                 destination_publish_properties: Optional[Mapping[str, _builtins.str]] = None,
                 destination_queue: Optional[_builtins.str] = None,
                 destination_queue_arguments: Optional[Mapping[str, _builtins.str]] = None,
                 prefetch_count: Optional[_builtins.int] = None,
                 reconnect_delay: Optional[_builtins.int] = None,
                 source_address: Optional[_builtins.str] = None,
                 source_delete_after: Optional[_builtins.str] = None,
                 source_exchange: Optional[_builtins.str] = None,
                 source_exchange_key: Optional[_builtins.str] = None,
                 source_prefetch_count: Optional[_builtins.int] = None,
                 source_protocol: Optional[_builtins.str] = None,
                 source_queue: Optional[_builtins.str] = None):
        """
        :param _builtins.str destination_uri: The amqp uri for the destination .
        :param _builtins.str source_uri: The amqp uri for the source.
        :param _builtins.str ack_mode: Determines how the shovel should acknowledge messages. Possible values are: `on-confirm`, `on-publish` and `no-ack`.
               Defaults to `on-confirm`.
        :param _builtins.bool add_forward_headers: Whether to add `x-shovelled` headers to shovelled messages.
        :param _builtins.str delete_after: Determines when (if ever) the shovel should delete itself. Possible values are: `never`, `queue-length` or an integer.
        :param _builtins.bool destination_add_forward_headers: Whether to add `x-shovelled` headers to shovelled messages.
        :param _builtins.str destination_address: The AMQP 1.0 destination link address.
        :param Mapping[str, _builtins.str] destination_application_properties: Application properties to set when shovelling messages.
        :param _builtins.str destination_exchange: The exchange to which messages should be published.
               Either this or `destination_queue` must be specified but not both.
        :param _builtins.str destination_exchange_key: The routing key when using `destination_exchange`.
        :param Mapping[str, _builtins.str] destination_properties: Properties to overwrite when shovelling messages.
               
               For more details regarding dynamic shovel parameters please have a look at the official reference documentaion at [RabbitMQ: Configuring Dynamic Shovels](https://www.rabbitmq.com/shovel-dynamic.html).
        :param _builtins.str destination_protocol: The protocol (`amqp091` or `amqp10`) to use when connecting to the destination.
               Defaults to `amqp091`.
        :param Mapping[str, _builtins.str] destination_publish_properties: A map of properties to overwrite when shovelling messages.
        :param _builtins.str destination_queue: The queue to which messages should be published.
               Either this or `destination_exchange` must be specified but not both.
        :param _builtins.int prefetch_count: The maximum number of unacknowledged messages copied over a shovel at any one time.
        :param _builtins.int reconnect_delay: The duration in seconds to reconnect to a broker after disconnected.
               Defaults to `1`.
        :param _builtins.str source_address: The AMQP 1.0 source link address.
        :param _builtins.str source_delete_after: Determines when (if ever) the shovel should delete itself. Possible values are: `never`, `queue-length` or an integer.
        :param _builtins.str source_exchange: The exchange from which to consume.
               Either this or `source_queue` must be specified but not both.
        :param _builtins.str source_exchange_key: The routing key when using `source_exchange`.
        :param _builtins.int source_prefetch_count: The maximum number of unacknowledged messages copied over a shovel at any one time.
        :param _builtins.str source_protocol: The protocol (`amqp091` or `amqp10`) to use when connecting to the source.
               Defaults to `amqp091`.
        :param _builtins.str source_queue: The queue from which to consume.
               Either this or `source_exchange` must be specified but not both.
        """
        pulumi.set(__self__, "destination_uri", destination_uri)
        pulumi.set(__self__, "source_uri", source_uri)
        if ack_mode is not None:
            pulumi.set(__self__, "ack_mode", ack_mode)
        if add_forward_headers is not None:
            pulumi.set(__self__, "add_forward_headers", add_forward_headers)
        if delete_after is not None:
            pulumi.set(__self__, "delete_after", delete_after)
        if destination_add_forward_headers is not None:
            pulumi.set(__self__, "destination_add_forward_headers", destination_add_forward_headers)
        if destination_add_timestamp_header is not None:
            pulumi.set(__self__, "destination_add_timestamp_header", destination_add_timestamp_header)
        if destination_address is not None:
            pulumi.set(__self__, "destination_address", destination_address)
        if destination_application_properties is not None:
            pulumi.set(__self__, "destination_application_properties", destination_application_properties)
        if destination_exchange is not None:
            pulumi.set(__self__, "destination_exchange", destination_exchange)
        if destination_exchange_key is not None:
            pulumi.set(__self__, "destination_exchange_key", destination_exchange_key)
        if destination_properties is not None:
            pulumi.set(__self__, "destination_properties", destination_properties)
        if destination_protocol is not None:
            pulumi.set(__self__, "destination_protocol", destination_protocol)
        if destination_publish_properties is not None:
            pulumi.set(__self__, "destination_publish_properties", destination_publish_properties)
        if destination_queue is not None:
            pulumi.set(__self__, "destination_queue", destination_queue)
        if destination_queue_arguments is not None:
            pulumi.set(__self__, "destination_queue_arguments", destination_queue_arguments)
        if prefetch_count is not None:
            pulumi.set(__self__, "prefetch_count", prefetch_count)
        if reconnect_delay is not None:
            pulumi.set(__self__, "reconnect_delay", reconnect_delay)
        if source_address is not None:
            pulumi.set(__self__, "source_address", source_address)
        if source_delete_after is not None:
            pulumi.set(__self__, "source_delete_after", source_delete_after)
        if source_exchange is not None:
            pulumi.set(__self__, "source_exchange", source_exchange)
        if source_exchange_key is not None:
            pulumi.set(__self__, "source_exchange_key", source_exchange_key)
        if source_prefetch_count is not None:
            pulumi.set(__self__, "source_prefetch_count", source_prefetch_count)
        if source_protocol is not None:
            pulumi.set(__self__, "source_protocol", source_protocol)
        if source_queue is not None:
            pulumi.set(__self__, "source_queue", source_queue)

    @_builtins.property
    @pulumi.getter(name="destinationUri")
    def destination_uri(self) -> _builtins.str:
        """
        The amqp uri for the destination .
        """
        return pulumi.get(self, "destination_uri")

    @_builtins.property
    @pulumi.getter(name="sourceUri")
    def source_uri(self) -> _builtins.str:
        """
        The amqp uri for the source.
        """
        return pulumi.get(self, "source_uri")

    @_builtins.property
    @pulumi.getter(name="ackMode")
    def ack_mode(self) -> Optional[_builtins.str]:
        """
        Determines how the shovel should acknowledge messages. Possible values are: `on-confirm`, `on-publish` and `no-ack`.
        Defaults to `on-confirm`.
        """
        return pulumi.get(self, "ack_mode")

    @_builtins.property
    @pulumi.getter(name="addForwardHeaders")
    @_utilities.deprecated("""use destination_add_forward_headers instead""")
    def add_forward_headers(self) -> Optional[_builtins.bool]:
        """
        Whether to add `x-shovelled` headers to shovelled messages.
        """
        return pulumi.get(self, "add_forward_headers")

    @_builtins.property
    @pulumi.getter(name="deleteAfter")
    @_utilities.deprecated("""use source_delete_after instead""")
    def delete_after(self) -> Optional[_builtins.str]:
        """
        Determines when (if ever) the shovel should delete itself. Possible values are: `never`, `queue-length` or an integer.
        """
        return pulumi.get(self, "delete_after")

    @_builtins.property
    @pulumi.getter(name="destinationAddForwardHeaders")
    def destination_add_forward_headers(self) -> Optional[_builtins.bool]:
        """
        Whether to add `x-shovelled` headers to shovelled messages.
        """
        return pulumi.get(self, "destination_add_forward_headers")

    @_builtins.property
    @pulumi.getter(name="destinationAddTimestampHeader")
    def destination_add_timestamp_header(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "destination_add_timestamp_header")

    @_builtins.property
    @pulumi.getter(name="destinationAddress")
    def destination_address(self) -> Optional[_builtins.str]:
        """
        The AMQP 1.0 destination link address.
        """
        return pulumi.get(self, "destination_address")

    @_builtins.property
    @pulumi.getter(name="destinationApplicationProperties")
    def destination_application_properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Application properties to set when shovelling messages.
        """
        return pulumi.get(self, "destination_application_properties")

    @_builtins.property
    @pulumi.getter(name="destinationExchange")
    def destination_exchange(self) -> Optional[_builtins.str]:
        """
        The exchange to which messages should be published.
        Either this or `destination_queue` must be specified but not both.
        """
        return pulumi.get(self, "destination_exchange")

    @_builtins.property
    @pulumi.getter(name="destinationExchangeKey")
    def destination_exchange_key(self) -> Optional[_builtins.str]:
        """
        The routing key when using `destination_exchange`.
        """
        return pulumi.get(self, "destination_exchange_key")

    @_builtins.property
    @pulumi.getter(name="destinationProperties")
    def destination_properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Properties to overwrite when shovelling messages.

        For more details regarding dynamic shovel parameters please have a look at the official reference documentaion at [RabbitMQ: Configuring Dynamic Shovels](https://www.rabbitmq.com/shovel-dynamic.html).
        """
        return pulumi.get(self, "destination_properties")

    @_builtins.property
    @pulumi.getter(name="destinationProtocol")
    def destination_protocol(self) -> Optional[_builtins.str]:
        """
        The protocol (`amqp091` or `amqp10`) to use when connecting to the destination.
        Defaults to `amqp091`.
        """
        return pulumi.get(self, "destination_protocol")

    @_builtins.property
    @pulumi.getter(name="destinationPublishProperties")
    def destination_publish_properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of properties to overwrite when shovelling messages.
        """
        return pulumi.get(self, "destination_publish_properties")

    @_builtins.property
    @pulumi.getter(name="destinationQueue")
    def destination_queue(self) -> Optional[_builtins.str]:
        """
        The queue to which messages should be published.
        Either this or `destination_exchange` must be specified but not both.
        """
        return pulumi.get(self, "destination_queue")

    @_builtins.property
    @pulumi.getter(name="destinationQueueArguments")
    def destination_queue_arguments(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "destination_queue_arguments")

    @_builtins.property
    @pulumi.getter(name="prefetchCount")
    @_utilities.deprecated("""use source_prefetch_count instead""")
    def prefetch_count(self) -> Optional[_builtins.int]:
        """
        The maximum number of unacknowledged messages copied over a shovel at any one time.
        """
        return pulumi.get(self, "prefetch_count")

    @_builtins.property
    @pulumi.getter(name="reconnectDelay")
    def reconnect_delay(self) -> Optional[_builtins.int]:
        """
        The duration in seconds to reconnect to a broker after disconnected.
        Defaults to `1`.
        """
        return pulumi.get(self, "reconnect_delay")

    @_builtins.property
    @pulumi.getter(name="sourceAddress")
    def source_address(self) -> Optional[_builtins.str]:
        """
        The AMQP 1.0 source link address.
        """
        return pulumi.get(self, "source_address")

    @_builtins.property
    @pulumi.getter(name="sourceDeleteAfter")
    def source_delete_after(self) -> Optional[_builtins.str]:
        """
        Determines when (if ever) the shovel should delete itself. Possible values are: `never`, `queue-length` or an integer.
        """
        return pulumi.get(self, "source_delete_after")

    @_builtins.property
    @pulumi.getter(name="sourceExchange")
    def source_exchange(self) -> Optional[_builtins.str]:
        """
        The exchange from which to consume.
        Either this or `source_queue` must be specified but not both.
        """
        return pulumi.get(self, "source_exchange")

    @_builtins.property
    @pulumi.getter(name="sourceExchangeKey")
    def source_exchange_key(self) -> Optional[_builtins.str]:
        """
        The routing key when using `source_exchange`.
        """
        return pulumi.get(self, "source_exchange_key")

    @_builtins.property
    @pulumi.getter(name="sourcePrefetchCount")
    def source_prefetch_count(self) -> Optional[_builtins.int]:
        """
        The maximum number of unacknowledged messages copied over a shovel at any one time.
        """
        return pulumi.get(self, "source_prefetch_count")

    @_builtins.property
    @pulumi.getter(name="sourceProtocol")
    def source_protocol(self) -> Optional[_builtins.str]:
        """
        The protocol (`amqp091` or `amqp10`) to use when connecting to the source.
        Defaults to `amqp091`.
        """
        return pulumi.get(self, "source_protocol")

    @_builtins.property
    @pulumi.getter(name="sourceQueue")
    def source_queue(self) -> Optional[_builtins.str]:
        """
        The queue from which to consume.
        Either this or `source_exchange` must be specified but not both.
        """
        return pulumi.get(self, "source_queue")


@pulumi.output_type
class TopicPermissionsPermission(dict):
    def __init__(__self__, *,
                 exchange: _builtins.str,
                 read: _builtins.str,
                 write: _builtins.str):
        """
        :param _builtins.str exchange: The exchange to set the permissions for.
        :param _builtins.str read: The "read" ACL.
        :param _builtins.str write: The "write" ACL.
        """
        pulumi.set(__self__, "exchange", exchange)
        pulumi.set(__self__, "read", read)
        pulumi.set(__self__, "write", write)

    @_builtins.property
    @pulumi.getter
    def exchange(self) -> _builtins.str:
        """
        The exchange to set the permissions for.
        """
        return pulumi.get(self, "exchange")

    @_builtins.property
    @pulumi.getter
    def read(self) -> _builtins.str:
        """
        The "read" ACL.
        """
        return pulumi.get(self, "read")

    @_builtins.property
    @pulumi.getter
    def write(self) -> _builtins.str:
        """
        The "write" ACL.
        """
        return pulumi.get(self, "write")


@pulumi.output_type
class GetExchangeSettingResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 arguments: Optional[Mapping[str, _builtins.str]] = None,
                 auto_delete: Optional[_builtins.bool] = None,
                 durable: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "type", type)
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if auto_delete is not None:
            pulumi.set(__self__, "auto_delete", auto_delete)
        if durable is not None:
            pulumi.set(__self__, "durable", durable)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def arguments(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "arguments")

    @_builtins.property
    @pulumi.getter(name="autoDelete")
    def auto_delete(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "auto_delete")

    @_builtins.property
    @pulumi.getter
    def durable(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "durable")


