"""Stub file for reflex/components/radix/themes/components/slider.py"""

# ------------------- DO NOT EDIT ----------------------
# This file was generated by `reflex/utils/pyi_generator.py`!
# ------------------------------------------------------
from collections.abc import Mapping, Sequence
from typing import Any, Literal

from reflex.components.core.breakpoints import Breakpoints
from reflex.components.radix.themes.base import RadixThemesComponent
from reflex.event import EventType, PointerEventInfo, passthrough_event_spec
from reflex.vars.base import Var

on_value_event_spec = (
    passthrough_event_spec(list[int | float]),
    passthrough_event_spec(list[int]),
    passthrough_event_spec(list[float]),
)

class Slider(RadixThemesComponent):
    @classmethod
    def create(
        cls,
        *children,
        as_child: Var[bool] | bool | None = None,
        size: Breakpoints[str, Literal["1", "2", "3"]]
        | Literal["1", "2", "3"]
        | Var[Breakpoints[str, Literal["1", "2", "3"]] | Literal["1", "2", "3"]]
        | None = None,
        variant: Literal["classic", "soft", "surface"]
        | Var[Literal["classic", "soft", "surface"]]
        | None = None,
        color_scheme: Literal[
            "amber",
            "blue",
            "bronze",
            "brown",
            "crimson",
            "cyan",
            "gold",
            "grass",
            "gray",
            "green",
            "indigo",
            "iris",
            "jade",
            "lime",
            "mint",
            "orange",
            "pink",
            "plum",
            "purple",
            "red",
            "ruby",
            "sky",
            "teal",
            "tomato",
            "violet",
            "yellow",
        ]
        | Var[
            Literal[
                "amber",
                "blue",
                "bronze",
                "brown",
                "crimson",
                "cyan",
                "gold",
                "grass",
                "gray",
                "green",
                "indigo",
                "iris",
                "jade",
                "lime",
                "mint",
                "orange",
                "pink",
                "plum",
                "purple",
                "red",
                "ruby",
                "sky",
                "teal",
                "tomato",
                "violet",
                "yellow",
            ]
        ]
        | None = None,
        high_contrast: Var[bool] | bool | None = None,
        radius: Literal["full", "none", "small"]
        | Var[Literal["full", "none", "small"]]
        | None = None,
        default_value: Sequence[float | int]
        | Var[Sequence[float | int] | float | int]
        | float
        | int
        | None = None,
        value: Sequence[float | int] | Var[Sequence[float | int]] | None = None,
        name: Var[str] | str | None = None,
        width: Var[str | None] | str | None = None,
        min: Var[float | int] | float | int | None = None,
        max: Var[float | int] | float | int | None = None,
        step: Var[float | int] | float | int | None = None,
        disabled: Var[bool] | bool | None = None,
        orientation: Literal["horizontal", "vertical"]
        | Var[Literal["horizontal", "vertical"]]
        | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_change: EventType[()]
        | EventType[list[int | float]]
        | (EventType[()] | EventType[list[int]])
        | (EventType[()] | EventType[list[float]])
        | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        on_value_commit: EventType[()]
        | EventType[list[int | float]]
        | (EventType[()] | EventType[list[int]])
        | (EventType[()] | EventType[list[float]])
        | None = None,
        **props,
    ) -> Slider:
        """Create a Slider component.

        Args:
            *children: The children of the component.
            as_child: Change the default rendered element for the one passed as a child, merging their props and behavior.
            size: Button size "1" - "3"
            variant: Variant of button
            color_scheme: Override theme color for button
            high_contrast: Whether to render the button with higher contrast color against background
            radius: Override theme radius for button: "none" | "small" | "full"
            default_value: The value of the slider when initially rendered. Use when you do not need to control the state of the slider.
            value: The controlled value of the slider. Must be used in conjunction with onValueChange.
            name: The name of the slider. Submitted with its owning form as part of a name/value pair.
            width: The width of the slider.
            min: The minimum value of the slider.
            max: The maximum value of the slider.
            step: The step value of the slider.
            disabled: Whether the slider is disabled
            orientation: The orientation of the slider.
            on_change: Fired when the value of the slider changes.
            on_value_commit: Fired when a thumb is released after being dragged.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The properties of the component.

        Returns:
            The component.
        """

slider = Slider.create
