"""Stub file for reflex/components/recharts/general.py"""

# ------------------- DO NOT EDIT ----------------------
# This file was generated by `reflex/utils/pyi_generator.py`!
# ------------------------------------------------------
from collections.abc import Mapping, Sequence
from typing import Any, Literal

from reflex.components.component import MemoizationLeaf
from reflex.components.core.breakpoints import Breakpoints
from reflex.constants.colors import Color
from reflex.event import EventType, PointerEventInfo
from reflex.vars.base import Var

from .recharts import Recharts

class ResponsiveContainer(Recharts, MemoizationLeaf):
    @classmethod
    def create(
        cls,
        *children,
        aspect: Var[int] | int | None = None,
        width: Var[int | str] | int | str | None = None,
        height: Var[int | str] | int | str | None = None,
        min_width: Var[int | str] | int | str | None = None,
        min_height: Var[int | str] | int | str | None = None,
        debounce: Var[int] | int | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_resize: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> ResponsiveContainer:
        """Create a new memoization leaf component.

        Args:
            *children: The children of the component.
            aspect: The aspect ratio of the container. The final aspect ratio of the SVG element will be (width / height) * aspect. Number
            width: The width of chart container. Can be a number or string. Default: "100%"
            height: The height of chart container. Can be a number or string. Default: "100%"
            min_width: The minimum width of chart container. Number or string.
            min_height: The minimum height of chart container. Number or string.
            debounce: If specified a positive number, debounced function will be used to handle the resize event. Default: 0
            on_resize: If specified provides a callback providing the updated chart width and height values.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The memoization leaf
        """

class Legend(Recharts):
    @classmethod
    def create(
        cls,
        *children,
        width: Var[int] | int | None = None,
        height: Var[int] | int | None = None,
        layout: Literal["horizontal", "vertical"]
        | Var[Literal["horizontal", "vertical"]]
        | None = None,
        align: Literal["center", "left", "right"]
        | Var[Literal["center", "left", "right"]]
        | None = None,
        vertical_align: Literal["bottom", "middle", "top"]
        | Var[Literal["bottom", "middle", "top"]]
        | None = None,
        icon_size: Var[int] | int | None = None,
        icon_type: Literal[
            "circle",
            "cross",
            "diamond",
            "line",
            "plainline",
            "rect",
            "square",
            "star",
            "triangle",
            "wye",
        ]
        | Var[
            Literal[
                "circle",
                "cross",
                "diamond",
                "line",
                "plainline",
                "rect",
                "square",
                "star",
                "triangle",
                "wye",
            ]
        ]
        | None = None,
        payload: Sequence[dict[str, Any]] | Var[Sequence[dict[str, Any]]] | None = None,
        chart_width: Var[int] | int | None = None,
        chart_height: Var[int] | int | None = None,
        margin: Var[dict[str, Any]] | dict[str, Any] | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> Legend:
        """Create the component.

        Args:
            *children: The children of the component.
            width: The width of legend container. Number
            height: The height of legend container. Number
            layout: The layout of legend items. 'horizontal' | 'vertical'. Default: "horizontal"
            align: The alignment of legend items in 'horizontal' direction, which can be 'left', 'center', 'right'. Default: "center"
            vertical_align: The alignment of legend items in 'vertical' direction, which can be 'top', 'middle', 'bottom'. Default: "bottom"
            icon_size: The size of icon in each legend item. Default: 14
            icon_type: The type of icon in each legend item. 'line' | 'plainline' | 'square' | 'rect' | 'circle' | 'cross' | 'diamond' | 'star' | 'triangle' | 'wye'
            payload: The source data of the content to be displayed in the legend, usually calculated internally. Default: []
            chart_width: The width of chart container, usually calculated internally.
            chart_height: The height of chart container, usually calculated internally.
            margin: The margin of chart container, usually calculated internally.
            on_click: The customized event handler of click on the items in this group
            on_mouse_down: The customized event handler of mousedown on the items in this group
            on_mouse_up: The customized event handler of mouseup on the items in this group
            on_mouse_move: The customized event handler of mousemove on the items in this group
            on_mouse_over: The customized event handler of mouseover on the items in this group
            on_mouse_out: The customized event handler of mouseout on the items in this group
            on_mouse_enter: The customized event handler of mouseenter on the items in this group
            on_mouse_leave: The customized event handler of mouseleave on the items in this group
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class GraphingTooltip(Recharts):
    @classmethod
    def create(
        cls,
        *children,
        separator: Var[str] | str | None = None,
        offset: Var[int] | int | None = None,
        filter_null: Var[bool] | bool | None = None,
        cursor: Var[bool | dict[str, Any]] | bool | dict[str, Any] | None = None,
        view_box: Var[dict[str, Any]] | dict[str, Any] | None = None,
        item_style: Var[dict[str, Any]] | dict[str, Any] | None = None,
        wrapper_style: Var[dict[str, Any]] | dict[str, Any] | None = None,
        content_style: Var[dict[str, Any]] | dict[str, Any] | None = None,
        label_style: Var[dict[str, Any]] | dict[str, Any] | None = None,
        allow_escape_view_box: Var[dict[str, bool]] | dict[str, bool] | None = None,
        active: Var[bool] | bool | None = None,
        position: Var[dict[str, Any]] | dict[str, Any] | None = None,
        coordinate: Var[dict[str, Any]] | dict[str, Any] | None = None,
        is_animation_active: Var[bool] | bool | None = None,
        animation_duration: Var[int] | int | None = None,
        animation_easing: Literal[
            "ease", "ease-in", "ease-in-out", "ease-out", "linear"
        ]
        | Var[Literal["ease", "ease-in", "ease-in-out", "ease-out", "linear"]]
        | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> GraphingTooltip:
        """Create the component.

        Args:
            *children: The children of the component.
            separator: The separator between name and value. Default: ":"
            offset: The offset size of tooltip. Number. Default: 10
            filter_null: When an item of the payload has value null or undefined, this item won't be displayed. Default: True
            cursor: If set false, no cursor will be drawn when tooltip is active. Default: {"strokeWidth": 1, "fill": rx.color("gray", 3)}
            view_box: The box of viewing area, which has the shape of {x: someVal, y: someVal, width: someVal, height: someVal}, usually calculated internally.
            item_style: The style of default tooltip content item which is a li element. Default: {"color": rx.color("gray", 12)}
            wrapper_style: The style of tooltip wrapper which is a dom element. Default: {}
            content_style: The style of tooltip content which is a dom element. Default: {"background": rx.color("gray", 1), "borderColor": rx.color("gray", 4), "borderRadius": "8px"}
            label_style: The style of default tooltip label which is a p element. Default: {"color": rx.color("gray", 11)}
            allow_escape_view_box: This option allows the tooltip to extend beyond the viewBox of the chart itself. Default: {"x": False, "y": False}
            active: If set true, the tooltip is displayed. If set false, the tooltip is hidden, usually calculated internally. Default: False
            position: If this field is set, the tooltip position will be fixed and will not move anymore.
            coordinate: The coordinate of tooltip which is usually calculated internally. Default: {"x": 0, "y": 0}
            is_animation_active: If set false, animation of tooltip will be disabled. Default: True
            animation_duration: Specifies the duration of animation, the unit of this option is ms. Default: 1500
            animation_easing: The type of easing function. Default: "ease"
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class Label(Recharts):
    @classmethod
    def create(
        cls,
        *children,
        view_box: Var[dict[str, Any]] | dict[str, Any] | None = None,
        value: Var[str] | str | None = None,
        offset: Var[int] | int | None = None,
        position: Literal[
            "bottom",
            "center",
            "end",
            "inside",
            "insideBottom",
            "insideBottomLeft",
            "insideBottomRight",
            "insideEnd",
            "insideLeft",
            "insideRight",
            "insideStart",
            "insideTop",
            "insideTopLeft",
            "insideTopRight",
            "left",
            "outside",
            "right",
            "top",
        ]
        | Var[
            Literal[
                "bottom",
                "center",
                "end",
                "inside",
                "insideBottom",
                "insideBottomLeft",
                "insideBottomRight",
                "insideEnd",
                "insideLeft",
                "insideRight",
                "insideStart",
                "insideTop",
                "insideTopLeft",
                "insideTopRight",
                "left",
                "outside",
                "right",
                "top",
            ]
        ]
        | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> Label:
        """Create the component.

        Args:
            *children: The children of the component.
            view_box: The box of viewing area, which has the shape of {x: someVal, y: someVal, width: someVal, height: someVal}, usually calculated internally.
            value: The value of label, which can be specified by this props or the children of <Label />
            offset: The offset of label which can be specified by this props or the children of <Label />
            position: The position of label which can be specified by this props or the children of <Label />
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class LabelList(Recharts):
    @classmethod
    def create(
        cls,
        *children,
        data_key: Var[int | str] | int | str | None = None,
        position: Literal[
            "bottom",
            "center",
            "end",
            "inside",
            "insideBottom",
            "insideBottomLeft",
            "insideBottomRight",
            "insideEnd",
            "insideLeft",
            "insideRight",
            "insideStart",
            "insideTop",
            "insideTopLeft",
            "insideTopRight",
            "left",
            "outside",
            "right",
            "top",
        ]
        | Var[
            Literal[
                "bottom",
                "center",
                "end",
                "inside",
                "insideBottom",
                "insideBottomLeft",
                "insideBottomRight",
                "insideEnd",
                "insideLeft",
                "insideRight",
                "insideStart",
                "insideTop",
                "insideTopLeft",
                "insideTopRight",
                "left",
                "outside",
                "right",
                "top",
            ]
        ]
        | None = None,
        offset: Var[int] | int | None = None,
        fill: Color | Var[Color | str] | str | None = None,
        stroke: Color | Var[Color | str] | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> LabelList:
        """Create the component.

        Args:
            *children: The children of the component.
            data_key: The key of a group of label values in data.
            position: The position of each label relative to it view box. "Top" | "left" | "right" | "bottom" | "inside" | "outside" | "insideLeft" | "insideRight" | "insideTop" | "insideBottom" | "insideTopLeft" | "insideBottomLeft" | "insideTopRight" | "insideBottomRight" | "insideStart" | "insideEnd" | "end" | "center"
            offset: The offset to the specified "position". Default: 5
            fill: The fill color of each label. Default: rx.color("gray", 10)
            stroke: The stroke color of each label. Default: "none"
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class Cell(Recharts):
    @classmethod
    def create(
        cls,
        *children,
        fill: Color | Var[Color | str] | str | None = None,
        stroke: Color | Var[Color | str] | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> Cell:
        """Create the component.

        Args:
            *children: The children of the component.
            fill: The presentation attribute of a rectangle in bar or a sector in pie.
            stroke: The presentation attribute of a rectangle in bar or a sector in pie.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

responsive_container = ResponsiveContainer.create
legend = Legend.create
graphing_tooltip = tooltip = GraphingTooltip.create
label = Label.create
label_list = LabelList.create
cell = Cell.create
