import importlib
from unittest import mock


def test_create_resource_client_uses_azure_mgmt_resource(monkeypatch):
    # prepare fake ResourceManagementClient class
    fake_module = mock.MagicMock()

    class FakeRMC:
        def __init__(self, credential, subscription_id):
            self.credential = credential
            self.subscription_id = subscription_id

    fake_module.ResourceManagementClient = FakeRMC

    with mock.patch.dict("sys.modules", {"azure.mgmt.resource": fake_module}):
        mod = importlib.import_module("azure_policy_engine.azure_auth")
        importlib.reload(mod)
        # provide a fake credential object
        fake_cred = object()
        client = mod.create_resource_client(credential=fake_cred, subscription_id="subid")
        assert isinstance(client, FakeRMC)
        assert client.credential is fake_cred
        assert client.subscription_id == "subid"


def test_create_policyinsights_client_uses_azure_mgmt_policyinsights(monkeypatch):
    fake_module = mock.MagicMock()

    class FakePIC:
        def __init__(self, credential):
            self.credential = credential

    fake_module.PolicyInsightsClient = FakePIC

    with mock.patch.dict("sys.modules", {"azure.mgmt.policyinsights": fake_module}):
        mod = importlib.import_module("azure_policy_engine.azure_auth")
        importlib.reload(mod)
        fake_cred = object()
        client = mod.create_policyinsights_client(credential=fake_cred)
        assert isinstance(client, FakePIC)
        assert client.credential is fake_cred

