"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import List, Optional

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import Action, ActionRelation, ActionRetryResponse
from ..utils import parse_query_string


class ActionsApiService(DevopnessBaseService):
    """
    ActionsApiService - Auto Generated
    """

    def get_action(
        self,
        action_id: int,
    ) -> DevopnessResponse[Action]:
        """
        Get an action by ID

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/actions/{action_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, Action)

    def list_actions(
        self,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[ActionRelation]]:
        """
        Return a list of all actions belonging to current user

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            "/actions",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, List[ActionRelation])

    def list_actions_by_resource_type(
        self,
        resource_id: int,
        resource_type: str,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[ActionRelation]]:
        """
        List resource actions of an action type

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/actions/{resource_type}/{resource_id}",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, List[ActionRelation])

    def list_actions_by_target_resource_type(
        self,
        target_resource_id: int,
        target_resource_type: str,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[ActionRelation]]:
        """
        List actions triggered to a given action target resource

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/actions/targets/{target_resource_type}/{target_resource_id}",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, List[ActionRelation])

    def retry_action(
        self,
        action_id: int,
    ) -> DevopnessResponse[ActionRetryResponse]:
        """
        Retry an action

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/actions/{action_id}/retry",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._post(endpoint)

        return DevopnessResponse(response, ActionRetryResponse)


class ActionsApiServiceAsync(DevopnessBaseServiceAsync):
    """
    ActionsApiServiceAsync - Auto Generated
    """

    async def get_action(
        self,
        action_id: int,
    ) -> DevopnessResponse[Action]:
        """
        Get an action by ID

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/actions/{action_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(response, Action)

    async def list_actions(
        self,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[ActionRelation]]:
        """
        Return a list of all actions belonging to current user

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            "/actions",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(response, List[ActionRelation])

    async def list_actions_by_resource_type(
        self,
        resource_id: int,
        resource_type: str,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[ActionRelation]]:
        """
        List resource actions of an action type

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/actions/{resource_type}/{resource_id}",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(response, List[ActionRelation])

    async def list_actions_by_target_resource_type(
        self,
        target_resource_id: int,
        target_resource_type: str,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[ActionRelation]]:
        """
        List actions triggered to a given action target resource

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/actions/targets/{target_resource_type}/{target_resource_id}",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(response, List[ActionRelation])

    async def retry_action(
        self,
        action_id: int,
    ) -> DevopnessResponse[ActionRetryResponse]:
        """
        Retry an action

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/actions/{action_id}/retry",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._post(endpoint)

        return await DevopnessResponse.from_async(response, ActionRetryResponse)
