"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import List, Optional, Union

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import (
    Daemon,
    DaemonEnvironmentCreate,
    DaemonEnvironmentCreatePlain,
    DaemonGetStatus,
    DaemonGetStatusPlain,
    DaemonRelation,
    DaemonRestart,
    DaemonRestartPlain,
    DaemonStart,
    DaemonStartPlain,
    DaemonStop,
    DaemonStopPlain,
    DaemonUpdate,
    DaemonUpdatePlain,
)
from ..utils import parse_query_string


class DaemonsApiService(DevopnessBaseService):
    """
    DaemonsApiService - Auto Generated
    """

    def add_environment_daemon(
        self,
        environment_id: int,
        daemon_environment_create: Union[
            DaemonEnvironmentCreate,
            DaemonEnvironmentCreatePlain,
        ],
    ) -> DevopnessResponse[Daemon]:
        """
        Add a Daemon to the given environment

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/environments/{environment_id}/daemons",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._post(endpoint, daemon_environment_create)

        return DevopnessResponse(response, Daemon)

    def delete_daemon(
        self,
        daemon_id: int,
    ) -> DevopnessResponse[None]:
        """
        Delete a given Daemon

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/daemons/{daemon_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._delete(endpoint)

        return DevopnessResponse(response, None)

    def get_daemon(
        self,
        daemon_id: int,
    ) -> DevopnessResponse[Daemon]:
        """
        Get a Daemon by ID

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/daemons/{daemon_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, Daemon)

    def get_status_daemon(
        self,
        daemon_id: int,
        daemon_get_status: Union[
            DaemonGetStatus,
            DaemonGetStatusPlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Get current status of a daemon

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/daemons/{daemon_id}/get-status",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._post(endpoint, daemon_get_status)

        return DevopnessResponse(response, None)

    def list_environment_daemons(
        self,
        environment_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[DaemonRelation]]:
        """
        Return a list of all Daemons belonging to an environment

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/environments/{environment_id}/daemons",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, List[DaemonRelation])

    def restart_daemon(
        self,
        daemon_id: int,
        daemon_restart: Union[
            DaemonRestart,
            DaemonRestartPlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Restart a Daemon

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/daemons/{daemon_id}/restart",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._post(endpoint, daemon_restart)

        return DevopnessResponse(response, None)

    def start_daemon(
        self,
        daemon_id: int,
        daemon_start: Union[
            DaemonStart,
            DaemonStartPlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Start a Daemon

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/daemons/{daemon_id}/start",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._post(endpoint, daemon_start)

        return DevopnessResponse(response, None)

    def stop_daemon(
        self,
        daemon_id: int,
        daemon_stop: Union[
            DaemonStop,
            DaemonStopPlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Stop a Daemon

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/daemons/{daemon_id}/stop",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._post(endpoint, daemon_stop)

        return DevopnessResponse(response, None)

    def update_daemon(
        self,
        daemon_id: int,
        daemon_update: Union[
            DaemonUpdate,
            DaemonUpdatePlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Update an existing Daemon

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/daemons/{daemon_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._put(endpoint, daemon_update)

        return DevopnessResponse(response, None)


class DaemonsApiServiceAsync(DevopnessBaseServiceAsync):
    """
    DaemonsApiServiceAsync - Auto Generated
    """

    async def add_environment_daemon(
        self,
        environment_id: int,
        daemon_environment_create: Union[
            DaemonEnvironmentCreate,
            DaemonEnvironmentCreatePlain,
        ],
    ) -> DevopnessResponse[Daemon]:
        """
        Add a Daemon to the given environment

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/environments/{environment_id}/daemons",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._post(endpoint, daemon_environment_create)

        return await DevopnessResponse.from_async(response, Daemon)

    async def delete_daemon(
        self,
        daemon_id: int,
    ) -> DevopnessResponse[None]:
        """
        Delete a given Daemon

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/daemons/{daemon_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._delete(endpoint)

        return await DevopnessResponse.from_async(response, None)

    async def get_daemon(
        self,
        daemon_id: int,
    ) -> DevopnessResponse[Daemon]:
        """
        Get a Daemon by ID

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/daemons/{daemon_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(response, Daemon)

    async def get_status_daemon(
        self,
        daemon_id: int,
        daemon_get_status: Union[
            DaemonGetStatus,
            DaemonGetStatusPlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Get current status of a daemon

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/daemons/{daemon_id}/get-status",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._post(endpoint, daemon_get_status)

        return await DevopnessResponse.from_async(response, None)

    async def list_environment_daemons(
        self,
        environment_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[DaemonRelation]]:
        """
        Return a list of all Daemons belonging to an environment

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/environments/{environment_id}/daemons",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(response, List[DaemonRelation])

    async def restart_daemon(
        self,
        daemon_id: int,
        daemon_restart: Union[
            DaemonRestart,
            DaemonRestartPlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Restart a Daemon

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/daemons/{daemon_id}/restart",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._post(endpoint, daemon_restart)

        return await DevopnessResponse.from_async(response, None)

    async def start_daemon(
        self,
        daemon_id: int,
        daemon_start: Union[
            DaemonStart,
            DaemonStartPlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Start a Daemon

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/daemons/{daemon_id}/start",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._post(endpoint, daemon_start)

        return await DevopnessResponse.from_async(response, None)

    async def stop_daemon(
        self,
        daemon_id: int,
        daemon_stop: Union[
            DaemonStop,
            DaemonStopPlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Stop a Daemon

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/daemons/{daemon_id}/stop",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._post(endpoint, daemon_stop)

        return await DevopnessResponse.from_async(response, None)

    async def update_daemon(
        self,
        daemon_id: int,
        daemon_update: Union[
            DaemonUpdate,
            DaemonUpdatePlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Update an existing Daemon

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/daemons/{daemon_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._put(endpoint, daemon_update)

        return await DevopnessResponse.from_async(response, None)
