"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import List, Optional

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import TeamMembershipRelation
from ..utils import parse_query_string


class EnvironmentsTeamMembershipsApiService(DevopnessBaseService):
    """
    EnvironmentsTeamMembershipsApiService - Auto Generated
    """

    def list_environment_team_memberships(
        self,
        environment_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[TeamMembershipRelation]]:
        """
        Return a list of teams with access to an environment

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/environments/{environment_id}/team-memberships",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, List[TeamMembershipRelation])


class EnvironmentsTeamMembershipsApiServiceAsync(DevopnessBaseServiceAsync):
    """
    EnvironmentsTeamMembershipsApiServiceAsync - Auto Generated
    """

    async def list_environment_team_memberships(
        self,
        environment_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[TeamMembershipRelation]]:
        """
        Return a list of teams with access to an environment

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/environments/{environment_id}/team-memberships",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(
            response, List[TeamMembershipRelation]
        )
