"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import Union

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import TeamEnvironmentLink, TeamEnvironmentLinkPlain


class EnvironmentsTeamsApiService(DevopnessBaseService):
    """
    EnvironmentsTeamsApiService - Auto Generated
    """

    def link_team_to_environment(
        self,
        environment_id: int,
        team_id: int,
        team_environment_link: Union[
            TeamEnvironmentLink,
            TeamEnvironmentLinkPlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Link team to a given environment

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/environments/{environment_id}/teams/{team_id}/link",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._post(endpoint, team_environment_link)

        return DevopnessResponse(response, None)

    def unlink_team_from_environment(
        self,
        environment_id: int,
        team_id: int,
    ) -> DevopnessResponse[None]:
        """
        Unlink team from the environment

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/environments/{environment_id}/teams/{team_id}/unlink",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._delete(endpoint)

        return DevopnessResponse(response, None)


class EnvironmentsTeamsApiServiceAsync(DevopnessBaseServiceAsync):
    """
    EnvironmentsTeamsApiServiceAsync - Auto Generated
    """

    async def link_team_to_environment(
        self,
        environment_id: int,
        team_id: int,
        team_environment_link: Union[
            TeamEnvironmentLink,
            TeamEnvironmentLinkPlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Link team to a given environment

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/environments/{environment_id}/teams/{team_id}/link",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._post(endpoint, team_environment_link)

        return await DevopnessResponse.from_async(response, None)

    async def unlink_team_from_environment(
        self,
        environment_id: int,
        team_id: int,
    ) -> DevopnessResponse[None]:
        """
        Unlink team from the environment

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/environments/{environment_id}/teams/{team_id}/unlink",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._delete(endpoint)

        return await DevopnessResponse.from_async(response, None)
